/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Spider {
    public static final int MAX_SPIDERS = 100;
    private static final short[][] ActionSeq_X_2 = new short[][]{{16, 0}, {8, 0}, {32, 0}, {24, 0}, {0, 0}, {40, 1}, {41, 1}};
    public static final Enemy.EnemyStruct[] SpiderList = new Enemy.EnemyStruct[100];
    private static int SpiderCount;

    public static void InitSpider() {
        SpiderCount = 0;
    }

    public static void saveSpider(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, SpiderCount);
        for (int i = 0; i < SpiderCount; ++i) {
            SpiderList[i].save(os);
        }
    }

    public static void loadSpider(SafeLoader loader) {
        SpiderCount = loader.SpiderCount;
        for (int i = 0; i < loader.SpiderCount; ++i) {
            if (SpiderList[i] == null) {
                Spider.SpiderList[i] = new Enemy.EnemyStruct();
            }
            SpiderList[i].copy(loader.SpiderList[i]);
        }
    }

    public static void loadSpider(SafeLoader loader, InputStream is) throws IOException {
        loader.SpiderCount = StreamUtils.readShort(is);
        for (int i = 0; i < loader.SpiderCount; ++i) {
            if (loader.SpiderList[i] == null) {
                loader.SpiderList[i] = new Enemy.EnemyStruct();
            }
            loader.SpiderList[i].load(is);
        }
    }

    public static int BuildSpider(int spr, int x, int y, int z, int sectnum, int ang) {
        Sector sec;
        int count;
        if ((count = SpiderCount++) >= 100) {
            return -1;
        }
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 99);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            y = pSprite.getY();
            z = pSprite.getZ();
            x = pSprite.getX();
            ang = pSprite.getAng();
            Main.engine.changespritestat(spr, 99);
        }
        if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
            return -1;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(z);
        pSprite.setCstat(257);
        pSprite.setShade(-12);
        pSprite.setClipdist(15);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setXrepeat(40);
        pSprite.setYrepeat(40);
        pSprite.setPal(sec.getCeilingpal());
        pSprite.setXoffset(0);
        pSprite.setYoffset(0);
        pSprite.setAng(ang);
        pSprite.setPicnum(1);
        pSprite.setHitag(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        if (SpiderList[count] == null) {
            Spider.SpiderList[count] = new Enemy.EnemyStruct();
        }
        Spider.SpiderList[count].nHealth = 160;
        Spider.SpiderList[count].nSeq = 0;
        Spider.SpiderList[count].nState = 0;
        Spider.SpiderList[count].nSprite = spr;
        Spider.SpiderList[count].nTarget = -1;
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0xC0000 | count));
        Spider.SpiderList[count].nFunc = RunList.AddRunRec(RunList.NewRun, 0xC0000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
        return spr;
    }

    /*
     * Unable to fully structure code
     */
    public static void FuncSpider(int nStack, int nDamage, int RunPtr) {
        nSpider = RunList.RunData[RunPtr].getObject();
        if (nSpider < 0 || nSpider >= 100) {
            throw new AssertException("nSpider>=0 && nSpider<MAX_SPIDERS");
        }
        pSpider = Spider.SpiderList[nSpider];
        nSprite = pSpider.nSprite;
        pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        sec = Main.boardService.getSector(pSprite.getSectnum());
        if (sec == null) {
            return;
        }
        nState = pSpider.nState;
        nTarget = pSpider.nTarget;
        pTarget = Main.boardService.getSprite(nTarget);
        plr = (short)(nStack & 65535);
        switch (nStack & 0x7F0000) {
            case 131072: {
                vel = 6;
                if (pSpider.nHealth != 0) {
                    if ((pSprite.getCstat() & 8) != 0) {
                        Main.game.pInt.setsprinterpolate(nSprite, pSprite);
                        pSprite.setZ(Sprites.GetSpriteHeight(nSprite) + sec.getCeilingz());
                    } else {
                        Sprites.Gravity(nSprite);
                    }
                }
                nSeq = Spider.ActionSeq_X_2[nState][0] + Seq.SeqOffsets[16];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pSpider.nSeq));
                Seq.MoveSequence(nSprite, nSeq, pSpider.nSeq);
                if (++pSpider.nSeq >= Seq.SeqSize[nSeq]) {
                    pSpider.nSeq = 0;
                }
                nFlags = Seq.FrameFlag[pSpider.nSeq + Seq.SeqBase[nSeq]];
                if (pTarget != null && (pTarget.getCstat() & 257) == 0) ** GOTO lbl107
                switch (nState) {
                    case 0: {
                        if ((nSpider & 31) == (Globals.totalmoves & 31)) {
                            if (nTarget < 0) {
                                nTarget = Enemy.FindPlayer(nSprite, 100);
                                pTarget = Main.boardService.getSprite(nTarget);
                            }
                            if (pTarget != null) {
                                pSpider.nState = 1;
                                pSpider.nSeq = 0;
                                pSpider.nTarget = nTarget;
                                pSprite.setXvel(EngineUtils.cos(pSprite.getAng() & 2047));
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 2047));
                                return;
                            }
                        }
                        ** GOTO lbl112
                    }
                    case 1: {
                        if (nTarget >= 0) {
                            vel = 7;
                        }
                    }
                    case 3: 
                    case 4: {
                        if (nState == 4 && pSpider.nSeq == 0) {
                            pSpider.nState = 1;
                        }
                        if ((pSprite.getCstat() & 8) != 0) {
                            pSprite.setZvel(0);
                            pSprite.setZ(32 * Main.engine.getTile(pSprite.getPicnum()).getHeight() + sec.getCeilingz());
                            if ((sec.getCeilingstat() & 1) != 0) {
                                pSprite.setCstat(pSprite.getCstat() ^ 8);
                                pSprite.setZvel(1);
                                pSpider.nState = 3;
                                pSpider.nSeq = 0;
                            }
                        }
                        if ((Globals.totalmoves & 31) == (nSpider & 31)) {
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            if (Random.RandomSize(3) != 0) {
                                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 2047));
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 2047));
                            } else {
                                pSprite.setXvel(0);
                                pSprite.setYvel(0);
                            }
                            if (nState == 1 && Random.RandomBit() != 0) {
                                if ((pSprite.getCstat() & 8) != 0) {
                                    pSprite.setCstat(pSprite.getCstat() ^ 8);
                                    pSprite.setZvel(1);
                                    pSprite.setZ(Sprites.GetSpriteHeight(nSprite) + sec.getCeilingz());
                                } else {
                                    pSprite.setZvel(-5120);
                                }
                                pSpider.nState = 3;
                                pSpider.nSeq = 0;
                                if (Random.RandomSize(3) == 0) {
                                    Sound.D3PlayFX(Sound.StaticSound[29], nSprite);
                                }
                            }
                        }
                        ** GOTO lbl112
                    }
                    case 2: {
                        if (nTarget == -1) {
                            pSpider.nSeq = 0;
                            pSpider.nState = 0;
                            pSprite.setXvel(0);
                            pSprite.setYvel(0);
                        } else {
                            if ((nFlags & 128) != 0) {
                                Sprites.DamageEnemy(nTarget, nSprite, 3);
                                Sound.D3PlayFX(Sound.StaticSound[38], nSprite);
                            }
                            if (Enemy.PlotCourseToSprite(nSprite, nTarget) < 1024) {
                                return;
                            }
                            pSpider.nSeq = 0;
                            pSpider.nState = 1;
                        }
                        ** GOTO lbl112
                    }
                    case 5: {
                        if (pSpider.nSeq == 0) {
                            RunList.DoSubRunRec(pSprite.getOwner());
                            RunList.FreeRun(pSprite.getLotag() - 1);
                            RunList.SubRunRec(pSpider.nFunc);
                            pSprite.setCstat(32768);
                            Main.engine.mydeletesprite(nSprite);
                        }
                        return;
                    }
                    default: {
                        return;
                    }
                }
lbl107:
                // 1 sources

                pSpider.nTarget = -1;
                pSpider.nState = 0;
                pSprite.setYvel(0);
                pSprite.setXvel(0);
                pSpider.nSeq = 0;
lbl112:
                // 5 sources

                osect = pSprite.getSectnum();
                oz = pSprite.getZ();
                hitMove = Main.engine.movesprite(nSprite, pSprite.getXvel() << vel, pSprite.getYvel() << vel, pSprite.getZvel(), 1280, -1280, 0);
                sect = pSprite.getSectnum();
                sec = Main.boardService.getSector(pSprite.getSectnum());
                if (sec == null) {
                    return;
                }
                if (!Globals.isOriginal() && osect != sect && (Globals.SectFlag[osect] & 8192) == 0 && (Globals.SectFlag[sect] & 8192) != 0) {
                    Main.engine.changespritesect(nSprite, osect);
                    pSprite.setZ(oz - 2048);
                    pSpider.nState = 1;
                    pSprite.setZvel(-512);
                    return;
                }
                if (hitMove != 0) {
                    if ((hitMove & 65536) != 0 && pSprite.getZvel() < 0 && (Engine.zr_ceilhit & 57344) != 49152 && (sec.getCeilingstat() & 1) == 0) {
                        pSprite.setCstat(pSprite.getCstat() | 8);
                        pSprite.setZ(Sprites.GetSpriteHeight(nSprite) + sec.getCeilingz());
                        pSprite.setZvel(0);
                        pSpider.nState = 1;
                        pSpider.nSeq = 0;
                        return;
                    }
                    switch (hitMove & 57344) {
                        case 32768: {
                            pSprite.setAng(pSprite.getAng() + 256 & 2031);
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 2047));
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 2047));
                            return;
                        }
                        case 49152: {
                            if ((hitMove & 8191) == nTarget && pTarget != null) {
                                v34 = EngineUtils.getAngle(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY());
                                if (Sprites.AngleDiff(pSprite.getAng(), v34) < 64) {
                                    pSpider.nState = 2;
                                    pSpider.nSeq = 0;
                                }
                            }
                            return;
                        }
                    }
                    if (nState == 3) {
                        pSpider.nState = 1;
                        pSpider.nSeq = 0;
                    }
                }
                return;
            }
            case 589824: {
                renderer = Main.game.getRenderer();
                tsp = (TSprite)renderer.getRenderedSprites().get(plr);
                Seq.PlotSequence(tsp, Spider.ActionSeq_X_2[nState][0] + Seq.SeqOffsets[16], pSpider.nSeq, Spider.ActionSeq_X_2[nState][1]);
                return;
            }
            case 655360: {
                if (pSpider.nHealth <= 0) {
                    return;
                }
                nDamage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (nDamage == 0 || pSpider.nHealth <= 0) break;
                pSpider.nHealth -= nDamage;
                if (pSpider.nHealth > 0) {
                    plrSpr = Main.boardService.getSprite(plr);
                    if (plrSpr != null && plrSpr.getStatnum() == 100) {
                        pSpider.nTarget = plr;
                    }
                    pSpider.nSeq = 0;
                    pSpider.nState = 4;
                    break;
                }
                pSpider.nSeq = 0;
                pSpider.nHealth = 0;
                pSpider.nState = 5;
                pSprite.setCstat(pSprite.getCstat() & -258);
                i = 0;
                seq = 41;
                while (i < 7) {
                    Sprites.BuildCreatureChunk(nSprite, Seq.GetSeqPicnum(16, seq, 0));
                    ++i;
                    ++seq;
                }
                --Globals.nCreaturesLeft;
            }
        }
    }
}

