/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Factory;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.Types.FastColorLookup;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Powerslave.Factory.PSFastColorLookup;

public class PSPaletteLoader
implements PaletteManager.PaletteLoader {
    private final byte[] basePalette;
    private final int shadesCount;
    private final byte[][] palookup;
    private final byte[] transluc;

    public PSPaletteLoader(Entry entry) throws IOException {
        if (!entry.exists()) {
            throw new FileNotFoundException("Failed to load \"palette.dat\"!");
        }
        boolean hastransluc = false;
        int numshades = (int)(entry.getSize() - 768L >> 7);
        if ((numshades & 1) <= 0) {
            numshades >>= 1;
        } else {
            numshades = numshades - 255 >> 1;
            hastransluc = true;
        }
        this.palookup = new byte[256][];
        this.transluc = new byte[65536];
        try (InputStream is = entry.getInputStream();){
            System.out.println("Loading palettes");
            this.basePalette = StreamUtils.readBytes(is, 768);
            StreamUtils.skip(is, numshades << 8);
            if (hastransluc) {
                int i;
                Console.out.println("Loading translucency table");
                byte[] tmp = new byte[256];
                for (i = 0; i < 255; ++i) {
                    StreamUtils.readBytes(is, tmp, 255 - i);
                    System.arraycopy(tmp, 0, this.transluc, (i << 8) + i + 1, 255 - i);
                    for (int j = i + 1; j < 256; ++j) {
                        this.transluc[(j << 8) + i] = this.transluc[(i << 8) + j];
                    }
                }
                for (i = 0; i < 256; ++i) {
                    this.transluc[(i << 8) + i] = (byte)i;
                }
            }
        }
        this.shadesCount = 64;
    }

    @Override
    public FastColorLookup getFastColorLookup() {
        return new PSFastColorLookup();
    }

    @Override
    public byte[] getBasePalette() {
        return this.basePalette;
    }

    @Override
    public int getShadeCount() {
        return this.shadesCount;
    }

    @Override
    public byte[][] getPalookup() {
        return this.palookup;
    }

    @Override
    public byte[] getTransluc() {
        return this.transluc;
    }
}

