/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Factory;

import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.Types.Color;
import ru.m210projects.Build.Types.DefaultPaletteManager;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Factory.PSPaletteLoader;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.View;

public class PSPaletteManager
extends DefaultPaletteManager {
    public static final Color WATER_FOG_COLOR = new Color(0, 10, 20, 0);
    public boolean bGreenPalette;

    public PSPaletteManager(Engine engine, Entry entry) throws IOException {
        super(engine, new PSPaletteLoader(entry));
        this.loadremaps();
    }

    private void loadremaps() throws IOException {
        String[] flookups = new String[]{"normal.rmp", "nodim.rmp", "torch.rmp", "notorch.rmp", "brite.rmp", "redbrite.rmp", "grnbrite.rmp", "normal.rmp", "nodim.rmp", "torch.rmp", "notorch.rmp", "brite.rmp"};
        for (int i = 0; i < 12; ++i) {
            Entry entry = Main.game.cache.getEntry(flookups[i], true);
            if (!entry.exists()) {
                throw new IOException("Error reading palette lookup \"" + flookups[i] + "\"!");
            }
            byte[] palookup = this.makePalookup(i, null, 0, 0, 0, 0);
            try (InputStream is = entry.getInputStream();){
                StreamUtils.readBytes(is, palookup, 16384);
            }
            if (i == 5) {
                this.setFogColor(i, new Color(63, 0, 0, 0));
            }
            Globals.origpalookup[i] = palookup;
        }
    }

    public void setGreenPal() {
        if (this.bGreenPalette) {
            return;
        }
        for (int i = 0; i < 12; ++i) {
            this.palookup[i] = this.palookup[6];
            this.listener.onPalookupChanged(i);
        }
        this.palookup[5] = Globals.origpalookup[5];
        this.bGreenPalette = true;
    }

    public void restoreGreenPal() {
        if (!this.bGreenPalette) {
            return;
        }
        System.arraycopy(Globals.origpalookup, 0, this.palookup, 0, 12);
        for (int i = 0; i < 12; ++i) {
            this.listener.onPalookupChanged(i);
        }
        this.bGreenPalette = false;
    }

    public void updateUnderwaterGLFog() {
        this.palookupfog[0] = !Main.game.pCfg.isPaletteEmulation() && (Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]] & 0x2000) != 0 ? WATER_FOG_COLOR : DEFAULT_COLOR;
    }

    public void SetTorch(int nPlayer, int nTorch) {
        if (nTorch != Light.bTorch && nPlayer == Globals.nLocalPlayer) {
            byte[][] palookup = Main.engine.getPaletteManager().getPalookupBuffer();
            this.SwapPalookup(palookup, 2, 3);
            this.SwapPalookup(palookup, 9, 10);
            Light.bTorch = nTorch == 2 ? (Light.bTorch == 0 ? 1 : 0) : nTorch;
            if (Light.bTorch != 0) {
                Sound.PlayLocalSound(12, 0);
            }
            View.StatusMessage(150, "TORCH IS " + (Light.bTorch != 0 ? "LIT" : "OUT"), nPlayer);
        }
    }

    public void LoadTorch(int nTorch) {
        byte[][] palookup = Main.engine.getPaletteManager().getPalookupBuffer();
        palookup[2] = Globals.origpalookup[2];
        palookup[3] = Globals.origpalookup[3];
        palookup[9] = Globals.origpalookup[9];
        palookup[10] = Globals.origpalookup[10];
        if (nTorch != 0) {
            this.SwapPalookup(palookup, 2, 3);
            this.SwapPalookup(palookup, 9, 10);
        }
    }

    private void SwapPalookup(byte[][] palookup, int num1, int num2) {
        byte[] tmp = palookup[num1];
        palookup[num1] = palookup[num2];
        palookup[num2] = tmp;
        this.listener.onPalookupChanged(num1);
        this.listener.onPalookupChanged(num2);
    }
}

