/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.GrenadeStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Weapons;

public class Grenade {
    public static final int MAX_GRENADES = 50;
    public static final int[] GrenadeFree = new int[50];
    public static final int[] nGrenadePlayer = new int[50];
    public static final GrenadeStruct[] GrenadeList = new GrenadeStruct[50];
    private static int nGrenadeCount;
    private static int nGrenadesFree;

    public static void InitGrenades() {
        nGrenadeCount = 0;
        for (int i = 0; i < 50; i = (int)((short)(i + 1))) {
            Grenade.GrenadeFree[i] = i;
            if (GrenadeList[i] != null) continue;
            Grenade.GrenadeList[i] = new GrenadeStruct();
        }
        nGrenadesFree = 50;
    }

    public static void saveGrenades(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, nGrenadeCount);
        StreamUtils.writeShort(os, nGrenadesFree);
        for (int i = 0; i < 50; ++i) {
            StreamUtils.writeShort(os, GrenadeFree[i]);
            StreamUtils.writeShort(os, nGrenadePlayer[i]);
            GrenadeList[i].save(os);
        }
    }

    public static void loadGrenades(SafeLoader loader) {
        nGrenadeCount = loader.nGrenadeCount;
        nGrenadesFree = loader.nGrenadesFree;
        System.arraycopy(loader.GrenadeFree, 0, GrenadeFree, 0, 50);
        System.arraycopy(loader.nGrenadePlayer, 0, nGrenadePlayer, 0, 50);
        for (int i = 0; i < 50; ++i) {
            if (GrenadeList[i] == null) {
                Grenade.GrenadeList[i] = new GrenadeStruct();
            }
            GrenadeList[i].copy(loader.GrenadeList[i]);
        }
    }

    public static void loadGrenades(SafeLoader loader, InputStream is) throws IOException {
        loader.nGrenadeCount = StreamUtils.readShort(is);
        loader.nGrenadesFree = StreamUtils.readShort(is);
        for (int i = 0; i < 50; ++i) {
            loader.GrenadeFree[i] = StreamUtils.readShort(is);
            loader.nGrenadePlayer[i] = StreamUtils.readShort(is);
            if (loader.GrenadeList[i] == null) {
                loader.GrenadeList[i] = new GrenadeStruct();
            }
            loader.GrenadeList[i].load(is);
        }
    }

    public static int GrabGrenade() {
        return GrenadeFree[--nGrenadesFree];
    }

    public static void DestroyGrenade(int a1) {
        Sprite pSprite = Main.boardService.getSprite(Grenade.GrenadeList[a1].nSprite);
        if (pSprite == null) {
            return;
        }
        RunList.DoSubRunRec(Grenade.GrenadeList[a1].field_6);
        RunList.SubRunRec(Grenade.GrenadeList[a1].field_8);
        RunList.DoSubRunRec(pSprite.getLotag() - 1);
        Main.engine.mydeletesprite(Grenade.GrenadeList[a1].nSprite);
        Grenade.GrenadeFree[Grenade.nGrenadesFree] = a1;
        ++nGrenadesFree;
    }

    public static void BounceGrenade(int a1, int a2) {
        Grenade.GrenadeList[a1].field_10 >>= 1;
        Grenade.GrenadeList[a1].xvel = Grenade.GrenadeList[a1].field_10 * (EngineUtils.sin(a2 + 512 & 0x7FF) >> 5);
        Grenade.GrenadeList[a1].yvel = Grenade.GrenadeList[a1].field_10 * (EngineUtils.sin(a2 & 0x7FF) >> 5);
        Sound.D3PlayFX(Sound.StaticSound[3], Grenade.GrenadeList[a1].nSprite);
    }

    public static void ThrowGrenade(int a1, int ignored1, int ignored2, int a4, int a5) {
        int v7 = Globals.nPlayerGrenade[a1];
        if (v7 >= 0) {
            int nPlayer = Globals.PlayerList[a1].spriteId;
            int nGrenade = Grenade.GrenadeList[v7].nSprite;
            Sprite pGrenade = Main.boardService.getSprite(nGrenade);
            Sprite pPlayerSpr = Main.boardService.getSprite(nPlayer);
            if (pGrenade == null || pPlayerSpr == null) {
                return;
            }
            Main.engine.mychangespritesect(nGrenade, Globals.nPlayerViewSect[a1]);
            pGrenade.setX(pPlayerSpr.getX());
            pGrenade.setY(pPlayerSpr.getY());
            pGrenade.setZ(pPlayerSpr.getZ());
            pGrenade.setAng(pPlayerSpr.getAng());
            pGrenade.setCstat(pGrenade.getCstat() & 0x7FF);
            if (a5 >= -3000) {
                Grenade.GrenadeList[v7].field_10 = 32 * (Main.cfg.bGrenadeFix && !Globals.isOriginal() ? 90 - Grenade.GrenadeList[v7].field_E : Globals.totalvel[a1]) + (90 - Grenade.GrenadeList[v7].field_E) * (90 - Grenade.GrenadeList[v7].field_E);
                pGrenade.setZvel(-64 * a5 - 4352);
                int dist = 8 * pPlayerSpr.getClipdist();
                int hitMove = Main.engine.movesprite(nGrenade, dist * EngineUtils.sin(pPlayerSpr.getAng() + 512 & 0x7FF), EngineUtils.sin(pPlayerSpr.getAng() & 0x7FF) * dist, a4, 0, 0, 1);
                if ((hitMove & 0xE000) == 32768) {
                    Grenade.BounceGrenade(v7, Main.engine.GetWallNormal(hitMove & 0x1FFF));
                }
            } else {
                Grenade.GrenadeList[v7].field_10 = 0;
                pGrenade.setZvel(pPlayerSpr.getZvel());
            }
            Grenade.GrenadeList[v7].xvel = Grenade.GrenadeList[v7].field_10 * (EngineUtils.sin(pPlayerSpr.getAng() + 512 & 0x7FF) >> 4);
            Grenade.GrenadeList[v7].yvel = Grenade.GrenadeList[v7].field_10 * (EngineUtils.sin(pPlayerSpr.getAng() & 0x7FF) >> 4);
            Globals.nPlayerGrenade[a1] = -1;
        }
    }

    public static void BuildGrenade(int a1) {
        if (nGrenadesFree != 0) {
            int nGrenade = Grenade.GrabGrenade();
            int nPlayer = Globals.PlayerList[a1].spriteId;
            int spr = Main.engine.insertsprite(Globals.nPlayerViewSect[a1], 201);
            Sprite pPlayerSpr = Main.boardService.getSprite(nPlayer);
            Sprite pSprite = Main.boardService.getSprite(spr);
            if (pPlayerSpr == null || pSprite == null) {
                return;
            }
            pSprite.setX(pPlayerSpr.getX());
            pSprite.setY(pPlayerSpr.getY());
            pSprite.setZ(pPlayerSpr.getZ() - 3840);
            pSprite.setShade(-64);
            pSprite.setXrepeat(20);
            pSprite.setYrepeat(20);
            pSprite.setCstat(32768);
            pSprite.setPicnum(1);
            pSprite.setPal(0);
            pSprite.setClipdist(30);
            pSprite.setXoffset(0);
            pSprite.setYoffset(0);
            pSprite.setAng(pPlayerSpr.getAng());
            pSprite.setYvel(0);
            pSprite.setOwner(nPlayer);
            pSprite.setXvel(0);
            pSprite.setZvel(0);
            pSprite.setHitag(0);
            pSprite.setLotag(RunList.HeadRun() + 1);
            pSprite.setExtra(-1);
            Grenade.GrenadeList[nGrenade].field_E = 90;
            Grenade.GrenadeList[nGrenade].field_2 = 0;
            Grenade.GrenadeList[nGrenade].field_0 = 16;
            Grenade.GrenadeList[nGrenade].field_10 = -1;
            Grenade.GrenadeList[nGrenade].nSprite = spr;
            Grenade.GrenadeList[nGrenade].ActionSeq = 0;
            Grenade.GrenadeList[nGrenade].field_C = 0;
            Grenade.GrenadeList[nGrenade].field_6 = RunList.AddRunRec(pSprite.getLotag() - 1, 0xF0000 | nGrenade);
            Grenade.GrenadeList[nGrenade].field_8 = RunList.AddRunRec(RunList.NewRun, 0xF0000 | nGrenade);
            Grenade.nGrenadePlayer[nGrenade] = a1;
            Globals.nPlayerGrenade[a1] = nGrenade;
        }
    }

    public static void ExplodeGrenade(int a1) {
        int nPlayerSpr;
        Sprite pPlayerSpr;
        int v18;
        int v16;
        int nPlayer = nGrenadePlayer[a1];
        int spr = Grenade.GrenadeList[a1].nSprite;
        Grenade.GrenadeList[a1].field_C = 1;
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            return;
        }
        short sectnum = pSprite.getSectnum();
        Sector sec = Main.boardService.getSector(sectnum);
        if (sec == null) {
            return;
        }
        if ((Globals.SectFlag[sectnum] & 0x2000) != 0) {
            v16 = 75;
            v18 = 60;
        } else if (pSprite.getZ() >= sec.getFloorz()) {
            v16 = 34;
            v18 = 150;
        } else {
            v16 = 36;
            v18 = 200;
        }
        if (Grenade.GrenadeList[a1].field_10 < 0 && (pPlayerSpr = Main.boardService.getSprite(nPlayerSpr = Globals.PlayerList[nPlayer].spriteId)) != null) {
            pSprite.setZ(pPlayerSpr.getZ());
            pSprite.setX(pPlayerSpr.getX() + (EngineUtils.sin(pPlayerSpr.getAng() + 512 & 0x7FF) >> 5));
            pSprite.setY(pPlayerSpr.getY() + (EngineUtils.sin(pPlayerSpr.getAng() & 0x7FF) >> 5));
            Main.engine.changespritesect(spr, pPlayerSpr.getSectnum());
            if (Globals.PlayerList[nPlayer].invisibility == 0) {
                Globals.PlayerList[nPlayer].HealthAmount = 1;
            }
        }
        int force = Bullet.BulletInfo[4].force;
        if (Globals.nPlayerDouble[nPlayer] > 0) {
            force = 2 * Bullet.BulletInfo[4].force;
        }
        Sprites.RadialDamageEnemy(spr, force, Bullet.BulletInfo[4].inf_10);
        Anim.BuildAnim(-1, v16, 0, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), v18, 4);
        Light.AddFlash(pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 128);
        Grenade.nGrenadePlayer[a1] = -1;
        Grenade.DestroyGrenade(a1);
    }

    public static void FuncGrenade(int nStack, int ignored, int RunPtr) {
        int nGrenade = RunList.RunData[RunPtr].getObject();
        if (nGrenade < 0 || nGrenade >= 50) {
            throw new AssertException("nGrenade>=0 && nGrenade<MAX_GRENADES");
        }
        int nSprite = Grenade.GrenadeList[nGrenade].nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nSeq = Grenade.GrenadeList[nGrenade].field_C != 0 ? Seq.SeqOffsets[34] : Grenade.GrenadeList[nGrenade].ActionSeq + Seq.SeqOffsets[33];
        switch (nStack & 0x7F0000) {
            case 131072: {
                int v10 = Grenade.GrenadeList[nGrenade].field_2 >> 8;
                Seq.MoveSequence(nSprite, nSeq, v10);
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, v10));
                --Grenade.GrenadeList[nGrenade].field_E;
                if (Grenade.GrenadeList[nGrenade].field_E == 0) {
                    int nPlayer = nGrenadePlayer[nGrenade];
                    if (Grenade.GrenadeList[nGrenade].field_10 < 0) {
                        Globals.PlayerList[nPlayer].weaponState = 0;
                        Globals.PlayerList[nPlayer].seqOffset = 0;
                        if (Globals.PlayerList[nPlayer].AmmosAmount[4] != 0) {
                            Globals.PlayerList[nPlayer].weaponFire = 0;
                        } else {
                            Weapons.SelectNewWeapon(nPlayer);
                            Globals.PlayerList[nPlayer].currentWeapon = Globals.PlayerList[nPlayer].newWeapon;
                            Globals.PlayerList[nPlayer].newWeapon = -1;
                        }
                    }
                    Grenade.ExplodeGrenade(nGrenade);
                    return;
                }
                if (Grenade.GrenadeList[nGrenade].field_10 < 0) {
                    return;
                }
                Grenade.GrenadeList[nGrenade].field_2 += Grenade.GrenadeList[nGrenade].field_0;
                int v19 = Grenade.GrenadeList[nGrenade].field_2 >> 8;
                if (v19 < 0) {
                    Grenade.GrenadeList[nGrenade].field_2 += Seq.SeqSize[nSeq] << 8;
                } else if (v19 >= Seq.SeqSize[nSeq]) {
                    if (Grenade.GrenadeList[nGrenade].field_C != 0) {
                        Grenade.DestroyGrenade(nGrenade);
                        return;
                    }
                    Grenade.GrenadeList[nGrenade].field_2 = 0;
                }
                if (Grenade.GrenadeList[nGrenade].field_C != 0) {
                    return;
                }
                short zvel = pSprite.getZvel();
                Sprites.Gravity(nSprite);
                int hitMove = Main.engine.movesprite(nSprite, Grenade.GrenadeList[nGrenade].xvel, Grenade.GrenadeList[nGrenade].yvel, pSprite.getZvel(), pSprite.getClipdist() >> 1, pSprite.getClipdist() >> 1, 1);
                if (hitMove == 0) {
                    return;
                }
                if ((hitMove & 0x20000) != 0) {
                    if (zvel != 0) {
                        if (Globals.SectDamage[pSprite.getSectnum()] > 0) {
                            Grenade.ExplodeGrenade(nGrenade);
                            return;
                        }
                        Grenade.GrenadeList[nGrenade].field_0 = Globals.totalmoves;
                        Sound.D3PlayFX(Sound.StaticSound[3], nSprite);
                        pSprite.setZvel(-(zvel >> 1));
                        if (pSprite.getZvel() > -1280) {
                            Sound.D3PlayFX(Sound.StaticSound[5], nSprite);
                            Grenade.GrenadeList[nGrenade].field_0 = 0;
                            Grenade.GrenadeList[nGrenade].field_2 = 0;
                            pSprite.setZvel(0);
                            Grenade.GrenadeList[nGrenade].ActionSeq = 1;
                        }
                    }
                    Grenade.GrenadeList[nGrenade].field_0 = 255 - 2 * Random.RandomByte();
                    Grenade.GrenadeList[nGrenade].xvel -= Grenade.GrenadeList[nGrenade].xvel >> 4;
                    Grenade.GrenadeList[nGrenade].yvel -= Grenade.GrenadeList[nGrenade].yvel >> 4;
                }
                switch (hitMove & 0xE000) {
                    case 32768: {
                        Grenade.BounceGrenade(nGrenade, Main.engine.GetWallNormal(hitMove & 0x1FFF));
                        Grenade.GrenadeList[nGrenade].field_2 = 0;
                        return;
                    }
                    case 49152: {
                        Sprite hitSprite = Main.boardService.getSprite(hitMove & 0x1FFF);
                        if (hitSprite != null) {
                            Grenade.BounceGrenade(nGrenade, hitSprite.getAng());
                            Grenade.GrenadeList[nGrenade].field_2 = 0;
                        }
                        return;
                    }
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get((short)(nStack & 0xFFFF));
                Seq.PlotSequence(tsp, nSeq, Grenade.GrenadeList[nGrenade].field_2 >> 8, 1);
                return;
            }
            case 655360: {
                if (nSprite == Globals.nRadialSpr || Grenade.GrenadeList[nGrenade].field_C != 0 || Sprites.CheckRadialDamage(nSprite) <= 280) break;
                Grenade.GrenadeList[nGrenade].field_E = Random.RandomSize(4) + 1;
            }
        }
    }
}

