/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Anubis;
import ru.m210projects.Powerslave.Enemies.Fish;
import ru.m210projects.Powerslave.Enemies.LavaDude;
import ru.m210projects.Powerslave.Enemies.Lion;
import ru.m210projects.Powerslave.Enemies.Mummy;
import ru.m210projects.Powerslave.Enemies.Queen;
import ru.m210projects.Powerslave.Enemies.Ra;
import ru.m210projects.Powerslave.Enemies.Rat;
import ru.m210projects.Powerslave.Enemies.Rex;
import ru.m210projects.Powerslave.Enemies.Roach;
import ru.m210projects.Powerslave.Enemies.Scorp;
import ru.m210projects.Powerslave.Enemies.Set;
import ru.m210projects.Powerslave.Enemies.Spider;
import ru.m210projects.Powerslave.Enemies.Wasp;
import ru.m210projects.Powerslave.Energy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Grenade;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Menus.MenuCorruptGame;
import ru.m210projects.Powerslave.Menus.PSMenuUserContent;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.PSSector;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Screens.GameScreen;
import ru.m210projects.Powerslave.Slide;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.SpiritHead;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Switch;
import ru.m210projects.Powerslave.Type.EpisodeInfo;
import ru.m210projects.Powerslave.Type.LSInfo;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.View;
import ru.m210projects.Powerslave.Weapons;

public class LoadSave {
    public static final String savsign = "LOBO";
    public static final int gdxSave = 100;
    public static final int currentGdxSave = 101;
    public static final int SAVENAME = 32;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final char[] filenum = new char[4];
    public static FileEntry nSaveFile;
    public static String nSaveName;
    public static boolean gClassicMode;
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static final SafeLoader loader;
    public static final LSInfo lsInf;
    public static int quickslot;
    public static FileEntry lastload;

    public static void FindSaves(Directory dir) {
        for (Entry file : dir) {
            if (!file.isExtension("sav") || !(file instanceof FileEntry)) continue;
            try {
                InputStream is = file.getInputStream();
                try {
                    short nVersion;
                    String signature = StreamUtils.readString(is, 4);
                    if (signature.isEmpty() || !signature.equals(savsign) || (nVersion = StreamUtils.readShort(is)) < 100) continue;
                    long time = StreamUtils.readLong(is);
                    String savname = StreamUtils.readString(is, 32);
                    Main.game.pSavemgr.add(savname, time, (FileEntry)file);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        Main.game.pSavemgr.sort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int lsReadLoadData(FileEntry file) {
        if (file.exists()) {
            ArtEntry pic = Main.engine.getTile(SaveManager.Screenshot);
            if (!(pic instanceof DynamicArtEntry) || !pic.exists()) {
                pic = Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            try (InputStream is = file.getInputStream();){
                int nVersion = LoadSave.checkSave(is) & 0xFFFF;
                lsInf.clear();
                if (nVersion == 101) {
                    String addon;
                    LoadSave.lsInf.date = Main.game.date.getDate(StreamUtils.readLong(is));
                    StreamUtils.skip(is, 32);
                    lsInf.read(is);
                    boolean hasCapt = StreamUtils.readBoolean(is);
                    if (hasCapt) {
                        ((DynamicArtEntry)pic).copyData(StreamUtils.readBytes(is, 16000));
                    }
                    LoadSave.lsInf.addonfile = null;
                    if (StreamUtils.readByte(is) == 2 && !(addon = FileUtils.getFullName(StreamUtils.readDataString(is).toLowerCase())).isEmpty()) {
                        LoadSave.lsInf.addonfile = "Addon: " + addon;
                    }
                    int n2 = 1;
                    return n2;
                }
                LoadSave.lsInf.info = "Incompatible ver. " + nVersion + " != " + 101;
                int n = -1;
                return n;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        lsInf.clear();
        return -1;
    }

    public static int checkSave(InputStream is) throws IOException {
        String signature = StreamUtils.readString(is, 4);
        if (!signature.equals(savsign)) {
            return 0;
        }
        return StreamUtils.readShort(is);
    }

    public static boolean checkfile(InputStream is) throws IOException {
        int nVersion = LoadSave.checkSave(is);
        if (nVersion != 101) {
            return false;
        }
        return loader.load(is);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadgame(FileEntry fil) {
        if (!fil.exists()) return false;
        try (InputStream is = fil.getInputStream();){
            Console.out.println("debug: start loadgame()", OsdColor.BLUE);
            boolean status = LoadSave.checkfile(is);
            if (status) {
                LoadSave.load();
                if (lastload == null || !lastload.exists()) {
                    lastload = fil;
                }
                if (gClassicMode) {
                    nSaveFile = fil;
                    nSaveName = LoadSave.loader.savename;
                } else {
                    nSaveFile = Directory.DUMMY_ENTRY;
                    nSaveName = null;
                }
                boolean bl2 = true;
                return bl2;
            }
            View.StatusMessage(500, "Incompatible version of saved game found!", Globals.nLocalPlayer);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Console.out.println(e.toString(), OsdColor.RED);
        }
        return false;
    }

    private static void load() {
        Main.gDemoScreen.onLoad();
        LoadSave.LoadGDXBlock();
        gClassicMode = LoadSave.loader.gClassicMode;
        Globals.nBestLevel = LoadSave.loader.best;
        if (gClassicMode) {
            View.zoom = 768;
            Globals.nPlayerWeapons[Globals.nLocalPlayer] = LoadSave.loader.nPlayerWeapons[Globals.nLocalPlayer];
            Globals.PlayerList[Globals.nLocalPlayer].currentWeapon = LoadSave.loader.PlayerList[Globals.nLocalPlayer].currentWeapon;
            Globals.nPlayerClip[Globals.nLocalPlayer] = LoadSave.loader.nPlayerClip[Globals.nLocalPlayer];
            int nAmmo = Globals.PlayerList[Globals.nLocalPlayer].AmmosAmount[1];
            if (nAmmo >= 6) {
                nAmmo = 6;
            }
            Globals.nPistolClip[Globals.nLocalPlayer] = nAmmo;
            Globals.nPlayerItem[Globals.nLocalPlayer] = LoadSave.loader.nPlayerItem[Globals.nLocalPlayer];
            Globals.PlayerList[Globals.nLocalPlayer].copy(LoadSave.loader.PlayerList[Globals.nLocalPlayer]);
            Globals.nPlayerLives[Globals.nLocalPlayer] = LoadSave.loader.nPlayerLives[Globals.nLocalPlayer];
            Player.SetPlayerItem(Globals.nLocalPlayer, Globals.nPlayerItem[Globals.nLocalPlayer]);
            Weapons.CheckClip(Globals.nLocalPlayer);
            Main.game.nNetMode = BuildGame.NetMode.Single;
            Main.gGameScreen.changemap(LoadSave.loader.level, null);
            View.StatusMessage(500, "Game loaded", Globals.nLocalPlayer);
            System.gc();
        } else {
            Object.InitElev();
            LoadSave.loadFM();
            Main.game.doPrecache(() -> {
                Main.game.nNetMode = BuildGame.NetMode.Single;
                Main.gGameScreen.gNameShowTime = 500;
                if (Globals.mUserFlag == Main.UserFlag.Addon) {
                    Globals.boardfilename = Main.game.getCache().getEntry(Globals.gCurrentEpisode.gMapInfo.get((int)(Globals.levelnum - 1)).path, true);
                }
                Sound.sndCheckUserMusic(Globals.boardfilename);
                Main.game.changeScreen(Main.gGameScreen);
                Main.game.gPaused = false;
                Main.engine.getPaletteManager().LoadTorch(Light.bTorch);
                Player.SetPlayerItem(Globals.nLocalPlayer, Globals.nPlayerItem[Globals.nLocalPlayer]);
                View.SetAirFrame();
                View.RefreshStatus();
                if (loader.getMessage() != null) {
                    View.StatusMessage(2000, loader.getMessage(), Mmulti.myconnectindex);
                } else {
                    View.StatusMessage(500, "Game loaded", Globals.nLocalPlayer);
                }
                System.gc();
                Main.game.pNet.ResetTimers();
                Main.game.pNet.ready2send = true;
            });
        }
    }

    public static void LoadGDXBlock() {
        Globals.boardfilename = LoadSave.loader.boardfilename;
        if (LoadSave.loader.warp_on == 0) {
            Globals.mUserFlag = Main.UserFlag.None;
            PSMenuUserContent.resetEpisodeResources(Globals.gOriginalEpisode);
        } else if (LoadSave.loader.warp_on == 1) {
            Globals.mUserFlag = Main.UserFlag.UserMap;
            PSMenuUserContent.resetEpisodeResources(null);
        } else if (LoadSave.loader.warp_on == 2) {
            Globals.mUserFlag = Main.UserFlag.Addon;
            PSMenuUserContent.checkEpisodeResources(LoadSave.loader.addon);
        }
    }

    public static void loadMap() {
        Main.boardService.setBoard(new Board(null, LoadSave.loader.sector, LoadSave.loader.wall, LoadSave.loader.sprite));
    }

    private static void loadPlayer() {
        Globals.PlayerCount = 1;
        Globals.PlayerList[Globals.nLocalPlayer].copy(LoadSave.loader.PlayerList[Globals.nLocalPlayer]);
        Mmulti.connecthead = LoadSave.loader.connecthead;
        System.arraycopy(LoadSave.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 8);
        Light.bTorch = LoadSave.loader.bTorch;
        Globals.nFreeze = LoadSave.loader.nFreeze;
        Globals.nXDamage[Globals.nLocalPlayer] = LoadSave.loader.nXDamage;
        Globals.nYDamage[Globals.nLocalPlayer] = LoadSave.loader.nYDamage;
        Globals.nDoppleSprite[Globals.nLocalPlayer] = LoadSave.loader.nDoppleSprite;
        Globals.nPlayerClip[Globals.nLocalPlayer] = LoadSave.loader.nPlayerClip[Globals.nLocalPlayer];
        Globals.nPistolClip[Globals.nLocalPlayer] = LoadSave.loader.nPistolClip[Globals.nLocalPlayer];
        Globals.nPlayerTorch[Globals.nLocalPlayer] = LoadSave.loader.nPlayerTorch;
        Globals.nPlayerWeapons[Globals.nLocalPlayer] = LoadSave.loader.nPlayerWeapons[Globals.nLocalPlayer];
        Globals.nPlayerLives[Globals.nLocalPlayer] = LoadSave.loader.nPlayerLives[Globals.nLocalPlayer];
        Globals.nPlayerItem[Globals.nLocalPlayer] = LoadSave.loader.nPlayerItem[Globals.nLocalPlayer];
        Globals.nPlayerInvisible[Globals.nLocalPlayer] = LoadSave.loader.nPlayerInvisible;
        Globals.nPlayerDouble[Globals.nLocalPlayer] = LoadSave.loader.nPlayerDouble;
        Globals.nPlayerViewSect[Globals.nLocalPlayer] = LoadSave.loader.nPlayerViewSect;
        Globals.nPlayerFloorSprite[Globals.nLocalPlayer] = LoadSave.loader.nPlayerFloorSprite;
        Globals.nPlayerScore[Globals.nLocalPlayer] = LoadSave.loader.nPlayerScore;
        Globals.nPlayerGrenade[Globals.nLocalPlayer] = LoadSave.loader.nPlayerGrenade;
        Globals.nPlayerSnake[Globals.nLocalPlayer] = LoadSave.loader.nPlayerSnake;
        Globals.nDestVertPan[Globals.nLocalPlayer] = LoadSave.loader.nDestVertPan;
        Globals.dVertPan[Globals.nLocalPlayer] = LoadSave.loader.dVertPan;
        Globals.nDeathType[Globals.nLocalPlayer] = LoadSave.loader.nDeathType;
        Globals.nQuake[Globals.nLocalPlayer] = LoadSave.loader.nQuake;
        Globals.bTouchFloor[Globals.nLocalPlayer] = LoadSave.loader.bTouchFloor;
        Globals.initx = LoadSave.loader.initx;
        Globals.inity = LoadSave.loader.inity;
        Globals.initz = LoadSave.loader.initz;
        Globals.inita = LoadSave.loader.inita;
        Globals.initsect = LoadSave.loader.initsect;
        Engine.show2dsector.copy(LoadSave.loader.show2dsector);
        Engine.show2dwall.copy(LoadSave.loader.show2dwall);
        Engine.show2dsprite.copy(LoadSave.loader.show2dsprite);
        Globals.nPlayerPushSound[Globals.nLocalPlayer] = -1;
        Globals.nTauntTimer[Globals.nLocalPlayer] = Random.RandomSize(3) + 3;
        Globals.nPlayerPushSect[Globals.nLocalPlayer] = -1;
        Globals.nPlayerSwear[Globals.nLocalPlayer] = 4;
        Globals.nTemperature[Globals.nLocalPlayer] = 0;
        Weapons.SetWeaponStatus(Globals.nLocalPlayer);
    }

    private static void loadSprites() {
        LoadSave.loadEnemies();
        Bullet.loadBullets(loader);
        Grenade.loadGrenades(loader);
        Sprites.loadBubbles(loader);
        Snake.loadSnakes(loader);
        Object.loadObjects(loader);
        Object.loadTraps(loader);
        Object.loadDrips(loader);
        Globals.nCreaturesLeft = LoadSave.loader.nCreaturesLeft;
        Globals.nCreaturesMax = LoadSave.loader.nCreaturesMax;
        SpiritHead.nSpiritSprite = LoadSave.loader.nSpiritSprite;
        Globals.nMagicCount = LoadSave.loader.nMagicCount;
        Map.nRegenerates = LoadSave.loader.nRegenerates;
        Map.nFirstRegenerate = LoadSave.loader.nFirstRegenerate;
        Globals.nNetStartSprites = LoadSave.loader.nNetStartSprites;
        Globals.nCurStartSprite = LoadSave.loader.nCurStartSprite;
        Globals.nNetPlayerCount = LoadSave.loader.nNetPlayerCount;
        System.arraycopy(LoadSave.loader.nNetStartSprite, 0, Globals.nNetStartSprite, 0, 8);
        System.arraycopy(LoadSave.loader.nChunkSprite, 0, Sprites.nChunkSprite, 0, Sprites.nChunkSprite.length);
        System.arraycopy(LoadSave.loader.nBodyGunSprite, 0, Sprites.nBodyGunSprite, 0, Sprites.nBodyGunSprite.length);
        System.arraycopy(LoadSave.loader.nBodySprite, 0, Sprites.nBodySprite, 0, Sprites.nBodySprite.length);
        Sprites.nCurChunkNum = LoadSave.loader.nCurChunkNum;
        Sprites.nCurBodyNum = LoadSave.loader.nCurBodyNum;
        Sprites.nCurBodyGunNum = LoadSave.loader.nCurBodyGunNum;
        Sprites.nBodyTotal = LoadSave.loader.nBodyTotal;
        Sprites.nChunkTotal = LoadSave.loader.nChunkTotal;
        Globals.nRadialSpr = LoadSave.loader.nRadialSpr;
        Globals.nRadialDamage = LoadSave.loader.nRadialDamage;
        Globals.nDamageRadius = LoadSave.loader.nDamageRadius;
        Globals.nRadialOwner = LoadSave.loader.nRadialOwner;
        Globals.nRadialBullet = LoadSave.loader.nRadialBullet;
        Globals.nDronePitch = LoadSave.loader.nDronePitch;
        Globals.nFinaleSpr = LoadSave.loader.nFinaleSpr;
        Globals.nFinaleStage = LoadSave.loader.nFinaleStage;
        Globals.lFinaleStart = LoadSave.loader.lFinaleStart;
        Globals.nSmokeSparks = LoadSave.loader.nSmokeSparks;
    }

    private static void loadEnemies() {
        Anubis.loadAnubis(loader);
        Fish.loadFish(loader);
        LavaDude.loadLava(loader);
        Lion.loadLion(loader);
        Mummy.loadMummy(loader);
        Queen.loadQueen(loader);
        Ra.loadRa(loader);
        Rat.loadRat(loader);
        Rex.loadRex(loader);
        Roach.loadRoach(loader);
        Scorp.loadScorp(loader);
        Set.loadSet(loader);
        Spider.loadSpider(loader);
        Wasp.loadWasp(loader);
    }

    private static void loadSectors() {
        Light.loadLights(loader);
        Object.loadElevs(loader);
        Object.loadBobs(loader);
        PSSector.loadMoves(loader);
        Object.loadTrails(loader);
        PSSector.loadPushBlocks(loader);
        Slide.loadSlide(loader);
        Switch.loadSwitches(loader);
        PSSector.loadLinks(loader);
        PSSector.loadSecExtra(loader);
        Globals.nEnergyChan = LoadSave.loader.nEnergyChan;
        Globals.nEnergyBlocks = LoadSave.loader.nEnergyBlocks;
        Globals.nEnergyTowers = LoadSave.loader.nEnergyTowers;
        Map.nSwitchSound = LoadSave.loader.nSwitchSound;
        Map.nStoneSound = LoadSave.loader.nStoneSound;
        Map.nElevSound = LoadSave.loader.nElevSound;
        Map.nStopSound = LoadSave.loader.nStopSound;
        Globals.lCountDown = LoadSave.loader.lCountDown;
        Globals.nAlarmTicks = LoadSave.loader.nAlarmTicks;
        Globals.nRedTicks = LoadSave.loader.nRedTicks;
        Globals.nClockVal = LoadSave.loader.nClockVal;
        Globals.nButtonColor = LoadSave.loader.nButtonColor;
        Engine.pskyoff[0] = 0;
        Engine.pskyoff[1] = 0;
        Engine.pskyoff[2] = 0;
        Engine.pskyoff[3] = 0;
        Engine.parallaxtype = 0;
        Engine.visibility = 1024;
        Renderer renderer = Main.game.getRenderer();
        renderer.setParallaxOffset(256);
        Engine.pskybits = (short)2;
    }

    private static void loadFM() {
        Globals.levelnum = LoadSave.loader.level;
        Globals.lastlevel = LoadSave.loader.lastlevel;
        LoadSave.loadMap();
        Anim.loadAnm(loader);
        LoadSave.loadSprites();
        LoadSave.loadSectors();
        Object.loadWallFaces(loader);
        RunList.loadRunList(loader);
        LoadSave.loadPlayer();
        Random.loadRandom(loader);
        Palette.GrabPalette();
        if (Globals.levelnum == 20) {
            Energy.InitEnergyTile();
            GameScreen.InitClockTile();
        }
        Globals.totalmoves = LoadSave.loader.totalmoves;
        Globals.moveframes = LoadSave.loader.moveframes;
    }

    public static void quicksave() {
        if (Mmulti.numplayers > 1 || gClassicMode) {
            return;
        }
        if (Globals.PlayerList[Globals.nLocalPlayer].HealthAmount != 0) {
            gQuickSaving = true;
        }
    }

    public static boolean canLoad(FileEntry fil) {
        if (fil.exists()) {
            boolean bl;
            block11: {
                InputStream is = fil.getInputStream();
                try {
                    int nVersion = LoadSave.checkSave(is) & 0xFFFF;
                    if (nVersion != 101 && nVersion >= 100) {
                        EpisodeInfo addon = loader.LoadGDXHeader(is);
                        if (LoadSave.loader.level <= 20 && LoadSave.loader.warp_on != 1) {
                            MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[12];
                            menu.setRunnable(() -> {
                                EpisodeInfo game = addon != null ? addon : Globals.gOriginalEpisode;
                                Globals.levelnew = LoadSave.loader.level;
                                if (gClassicMode) {
                                    nSaveFile = fil;
                                    nSaveName = LoadSave.loader.savename;
                                } else {
                                    nSaveFile = Directory.DUMMY_ENTRY;
                                    nSaveName = null;
                                }
                                Main.gGameScreen.newgame(game, Globals.levelnew, LoadSave.loader.gClassicMode);
                                Globals.nBestLevel = LoadSave.loader.best;
                            });
                            Main.game.menu.mOpen(menu, -1);
                        }
                    }
                    boolean bl2 = bl = nVersion == 101;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return bl;
        }
        return false;
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1 || gClassicMode) {
            return;
        }
        FileEntry loadFile = Main.game.pSavemgr.getLast();
        if (LoadSave.canLoad(loadFile)) {
            Main.game.changeScreen(Main.gLoadingScreen);
            Main.gLoadingScreen.init(() -> {
                if (!LoadSave.loadgame(loadFile)) {
                    Main.game.setPrevScreen();
                    if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                        Main.game.pNet.ready2send = true;
                        View.StatusMessage(500, "Incompatible version of saved game found!", Globals.nLocalPlayer);
                    }
                }
            });
        }
    }

    public static String makeNum(int num) {
        LoadSave.filenum[3] = (char)(num % 10 + 48);
        LoadSave.filenum[2] = (char)(num / 10 % 10 + 48);
        LoadSave.filenum[1] = (char)(num / 100 % 10 + 48);
        LoadSave.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static void SaveVersion(OutputStream os, int nVersion) throws IOException {
        StreamUtils.writeString(os, savsign);
        StreamUtils.writeShort(os, nVersion);
    }

    public static void SaveHeader(OutputStream os, String savename, long time, int level, int best, boolean gClassicMode) throws IOException {
        LoadSave.SaveVersion(os, 101);
        StreamUtils.writeLong(os, time);
        StreamUtils.writeString(os, savename, 32);
        StreamUtils.writeByte(os, gClassicMode ? 1 : 0);
        StreamUtils.writeShort(os, level);
        StreamUtils.writeShort(os, best);
    }

    public static void SaveGDXBlock(OutputStream os) throws IOException {
        boolean hasCapt = Main.gGameScreen != null && Main.gGameScreen.captBuffer != null;
        StreamUtils.writeByte(os, hasCapt ? 1 : 0);
        if (hasCapt) {
            StreamUtils.writeBytes(os, Main.gGameScreen.captBuffer);
            Main.gGameScreen.captBuffer = null;
        }
        int warp_on = 0;
        if (Globals.mUserFlag == Main.UserFlag.UserMap) {
            warp_on = 1;
        }
        if (Globals.mUserFlag == Main.UserFlag.Addon) {
            warp_on = 2;
        }
        StreamUtils.writeByte(os, warp_on);
        if (warp_on == 2) {
            StreamUtils.writeDataString(os, Globals.gCurrentEpisode.getPath());
        }
        if (Globals.boardfilename != null && Globals.boardfilename.exists()) {
            if (Globals.boardfilename instanceof FileEntry) {
                StreamUtils.writeDataString(os, ((FileEntry)Globals.boardfilename).getPath().toString());
            } else {
                StreamUtils.writeDataString(os, Globals.boardfilename.getName());
            }
        } else {
            StreamUtils.writeDataString(os, "");
        }
    }

    public static void savegame(Directory dir, String savename, String filename) {
        block9: {
            FileEntry file = dir.getEntry(filename);
            if (file.exists() && !file.delete()) {
                View.StatusMessage(500, "Game not saved. Access denied!", Globals.nLocalPlayer);
                return;
            }
            Path path = dir.getPath().resolve(filename);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                long time = Main.game.date.getCurrentDate();
                LoadSave.save(os, savename, time, Globals.levelnum, Globals.nBestLevel, gClassicMode);
                file = dir.addEntry(path);
                if (file.exists()) {
                    Main.game.pSavemgr.add(savename, time, file);
                    lastload = file;
                    View.StatusMessage(500, "Game saved", Globals.nLocalPlayer);
                    break block9;
                }
                throw new FileNotFoundException(filename);
            }
            catch (Exception e) {
                View.StatusMessage(500, "Game not saved. " + e, Globals.nLocalPlayer);
            }
        }
    }

    private static void save(OutputStream os, String savename, long time, int level, int best, boolean classic) throws IOException {
        LoadSave.SaveHeader(os, savename, time, level, best, classic);
        LoadSave.SaveGDXBlock(os);
        if (classic) {
            StreamUtils.writeShort(os, Globals.nPlayerWeapons[Globals.nLocalPlayer]);
            StreamUtils.writeShort(os, Globals.PlayerList[Globals.nLocalPlayer].currentWeapon);
            StreamUtils.writeShort(os, Globals.nPlayerClip[Globals.nLocalPlayer]);
            StreamUtils.writeShort(os, Globals.nPlayerItem[Globals.nLocalPlayer]);
            Globals.PlayerList[Globals.nLocalPlayer].writeObject(os, false);
            StreamUtils.writeShort(os, Globals.nPlayerLives[Globals.nLocalPlayer]);
        } else {
            LoadSave.saveFM(os);
        }
    }

    private static void saveFM(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, Globals.lastlevel);
        LoadSave.saveMap(os);
        Anim.saveAnm(os);
        LoadSave.saveSprites(os);
        LoadSave.saveSectors(os);
        Object.saveWallFaces(os);
        RunList.saveRunList(os);
        LoadSave.savePlayer(os);
        Random.saveRandom(os);
        StreamUtils.writeInt(os, Globals.totalmoves);
        StreamUtils.writeInt(os, Globals.moveframes);
    }

    private static void saveMap(OutputStream os) throws IOException {
        Board board = Main.boardService.getBoard();
        Sector[] sectors = board.getSectors();
        StreamUtils.writeInt(os, sectors.length);
        for (Sector s : sectors) {
            s.writeObject(os);
        }
        Wall[] walls = board.getWalls();
        StreamUtils.writeInt(os, walls.length);
        for (Wall wal : walls) {
            wal.writeObject(os);
        }
        List<Sprite> sprites = board.getSprites();
        StreamUtils.writeInt(os, sprites.size());
        for (Sprite s : sprites) {
            s.writeObject(os);
        }
    }

    private static void savePlayer(OutputStream os) throws IOException {
        Globals.PlayerList[Globals.nLocalPlayer].writeObject(os, true);
        StreamUtils.writeShort(os, Mmulti.connecthead);
        for (short val : Mmulti.connectpoint2) {
            StreamUtils.writeShort(os, val);
        }
        StreamUtils.writeByte(os, Light.bTorch);
        StreamUtils.writeInt(os, Globals.nFreeze);
        StreamUtils.writeInt(os, Globals.nXDamage[Globals.nLocalPlayer]);
        StreamUtils.writeInt(os, Globals.nYDamage[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nDoppleSprite[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerClip[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPistolClip[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerTorch[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerWeapons[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerLives[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerItem[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerInvisible[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerDouble[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerViewSect[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerFloorSprite[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerScore[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerGrenade[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nPlayerSnake[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, (short)Globals.nDestVertPan[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.dVertPan[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nDeathType[Globals.nLocalPlayer]);
        StreamUtils.writeShort(os, Globals.nQuake[Globals.nLocalPlayer]);
        StreamUtils.writeByte(os, Globals.bTouchFloor[Globals.nLocalPlayer] ? 1 : 0);
        StreamUtils.writeInt(os, Globals.initx);
        StreamUtils.writeInt(os, Globals.inity);
        StreamUtils.writeInt(os, Globals.initz);
        StreamUtils.writeShort(os, Globals.inita);
        StreamUtils.writeShort(os, Globals.initsect);
        Engine.show2dsector.writeObject(os);
        Engine.show2dwall.writeObject(os);
        Engine.show2dsprite.writeObject(os);
    }

    private static void saveEnemies(OutputStream os) throws IOException {
        Anubis.saveAnubis(os);
        Fish.saveFish(os);
        LavaDude.saveLava(os);
        Lion.saveLion(os);
        Mummy.saveMummy(os);
        Queen.saveQueen(os);
        Ra.saveRa(os);
        Rat.saveRat(os);
        Rex.saveRex(os);
        Roach.saveRoach(os);
        Scorp.saveScorp(os);
        Set.saveSet(os);
        Spider.saveSpider(os);
        Wasp.saveWasp(os);
    }

    private static void saveSprites(OutputStream os) throws IOException {
        LoadSave.saveEnemies(os);
        Bullet.saveBullets(os);
        Grenade.saveGrenades(os);
        Sprites.saveBubbles(os);
        Snake.saveSnakes(os);
        Object.saveObjects(os);
        Object.saveTraps(os);
        Object.saveDrips(os);
        StreamUtils.writeShort(os, Globals.nCreaturesLeft);
        StreamUtils.writeShort(os, Globals.nCreaturesMax);
        StreamUtils.writeShort(os, SpiritHead.nSpiritSprite);
        StreamUtils.writeShort(os, Globals.nMagicCount);
        StreamUtils.writeShort(os, Map.nRegenerates);
        StreamUtils.writeShort(os, Map.nFirstRegenerate);
        StreamUtils.writeShort(os, Globals.nNetStartSprites);
        StreamUtils.writeShort(os, Globals.nCurStartSprite);
        StreamUtils.writeShort(os, Globals.nNetPlayerCount);
        for (int v : Globals.nNetStartSprite) {
            StreamUtils.writeShort(os, v);
        }
        for (int v : Sprites.nChunkSprite) {
            StreamUtils.writeShort(os, v);
        }
        for (int v : Sprites.nBodyGunSprite) {
            StreamUtils.writeShort(os, v);
        }
        for (int v : Sprites.nBodySprite) {
            StreamUtils.writeShort(os, v);
        }
        StreamUtils.writeShort(os, Sprites.nCurChunkNum);
        StreamUtils.writeShort(os, Sprites.nCurBodyNum);
        StreamUtils.writeShort(os, Sprites.nCurBodyGunNum);
        StreamUtils.writeShort(os, Sprites.nBodyTotal);
        StreamUtils.writeShort(os, Sprites.nChunkTotal);
        StreamUtils.writeShort(os, Globals.nRadialSpr);
        StreamUtils.writeShort(os, Globals.nRadialDamage);
        StreamUtils.writeShort(os, Globals.nDamageRadius);
        StreamUtils.writeShort(os, Globals.nRadialOwner);
        StreamUtils.writeShort(os, Globals.nRadialBullet);
        StreamUtils.writeShort(os, Globals.nDronePitch);
        StreamUtils.writeShort(os, Globals.nFinaleSpr);
        StreamUtils.writeShort(os, Globals.nFinaleStage);
        StreamUtils.writeShort(os, Globals.lFinaleStart);
        StreamUtils.writeShort(os, Globals.nSmokeSparks);
    }

    private static void saveSectors(OutputStream os) throws IOException {
        Light.saveLights(os);
        Object.saveElevs(os);
        Object.saveBobs(os);
        PSSector.saveMoves(os);
        Object.saveTrails(os);
        PSSector.savePushBlocks(os);
        Slide.saveSlide(os);
        Switch.saveSwitches(os);
        PSSector.saveLinks(os);
        PSSector.saveSecExtra(os);
        StreamUtils.writeShort(os, Globals.nEnergyChan);
        StreamUtils.writeShort(os, Globals.nEnergyBlocks);
        StreamUtils.writeShort(os, Globals.nEnergyTowers);
        StreamUtils.writeShort(os, Map.nSwitchSound);
        StreamUtils.writeShort(os, Map.nStoneSound);
        StreamUtils.writeShort(os, Map.nElevSound);
        StreamUtils.writeShort(os, Map.nStopSound);
        StreamUtils.writeInt(os, Globals.lCountDown);
        StreamUtils.writeShort(os, Globals.nAlarmTicks);
        StreamUtils.writeShort(os, Globals.nRedTicks);
        StreamUtils.writeShort(os, Globals.nClockVal);
        StreamUtils.writeShort(os, Globals.nButtonColor);
    }

    static {
        gClassicMode = false;
        loader = new SafeLoader();
        lsInf = new LSInfo();
        quickslot = 0;
    }
}

