/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.ByteArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.LogSender;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Pattern.ScreenAdapters.MessageScreen;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Types.MemLog;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.commands.OsdValueRange;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Powerslave.Config;
import ru.m210projects.Powerslave.Factory.PSEngine;
import ru.m210projects.Powerslave.Factory.PSFactory;
import ru.m210projects.Powerslave.Factory.PSInput;
import ru.m210projects.Powerslave.Factory.PSMenuHandler;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.LoadSave;
import ru.m210projects.Powerslave.Menus.MainMenu;
import ru.m210projects.Powerslave.Menus.MenuCorruptGame;
import ru.m210projects.Powerslave.Menus.MenuGame;
import ru.m210projects.Powerslave.Menus.NewAddon;
import ru.m210projects.Powerslave.Menus.PSMenuUserContent;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Screens.CinemaScreen;
import ru.m210projects.Powerslave.Screens.DemoScreen;
import ru.m210projects.Powerslave.Screens.GameScreen;
import ru.m210projects.Powerslave.Screens.LoadingScreen;
import ru.m210projects.Powerslave.Screens.LogoScreen2;
import ru.m210projects.Powerslave.Screens.MapScreen;
import ru.m210projects.Powerslave.Screens.MenuScreen;
import ru.m210projects.Powerslave.Screens.PSLogoScreen;
import ru.m210projects.Powerslave.Screens.PSMessageScreen;
import ru.m210projects.Powerslave.Screens.PSMovieScreen;
import ru.m210projects.Powerslave.Screens.PrecacheScreen;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.EpisodeEntry;
import ru.m210projects.Powerslave.Type.EpisodeInfo;
import ru.m210projects.Powerslave.Type.Input;
import ru.m210projects.Powerslave.Type.MapInfo;
import ru.m210projects.Powerslave.Type.PlayerSave;
import ru.m210projects.Powerslave.Type.PlayerStruct;

public class Main
extends BuildGame {
    public static final String appdef = "psgdx.def";
    public static Main game;
    public static PSEngine engine;
    public static BoardService boardService;
    public static Config cfg;
    public static LoadingScreen gLoadingScreen;
    public static GameScreen gGameScreen;
    public static DemoScreen gDemoScreen;
    public static MapScreen gMap;
    public static PSLogoScreen gLogoScreen;
    public static LogoScreen2 gLogoScreen2;
    public static PSMovieScreen gMovieScreen;
    public static MenuScreen gMenuScreen;
    public static CinemaScreen gCinemaScreen;
    private final int LOGO1 = 3349;
    public PSMenuHandler menu;
    public final Runnable rMenu = new Runnable(){

        @Override
        public void run() {
            Main.this.resetState();
            engine.setbrightness(cfg.getPaletteGamma(), engine.getPaletteManager().getBasePalette());
            if (Mmulti.numplayers > 1 || Main.gDemoScreen.demofiles.isEmpty() || Main.cfg.gDemoSeq == 0 || !gDemoScreen.showDemo()) {
                Main.this.changeScreen(gMenuScreen);
            }
            if (!Main.this.menu.gShowMenu) {
                Main.this.menu.mOpen(Main.this.menu.mMenus[0], -1);
            }
        }
    };
    public final Runnable toLogo3 = new Runnable(){

        @Override
        public void run() {
            game.changeScreen(gLogoScreen2.setCallback(Main.this.rMenu));
        }
    };
    public final Runnable logo = new Runnable(){
        final Runnable cutscene = new Runnable(){

            @Override
            public void run() {
                if (gMovieScreen.open("book.mov")) {
                    game.changeScreen(gMovieScreen.setCallback(Main.this.toLogo3).escSkipping(true));
                } else {
                    game.changeScreen(gCinemaScreen.setNum(2).setSkipping(Main.this.toLogo3));
                }
            }
        };

        @Override
        public void run() {
            Main.this.changeScreen(gLogoScreen.setTime(2.0f).setTile(Seq.GetSeqPicnum(59, 0, 0)).setCallback(this.cutscene).setSkipping(Main.this.toLogo3));
        }
    };

    public Main(List<String> args, GameConfig bcfg, String name, String version, boolean isRelease) throws IOException {
        super(args, bcfg, name, version, isRelease);
        game = this;
        cfg = (Config)bcfg;
    }

    @Override
    protected MessageScreen createMessage(String header, String text, MessageType type) {
        return new PSMessageScreen(this, header, text, type);
    }

    @Override
    public GameProcessor createGameProcessor() {
        return new PSInput(this);
    }

    @Override
    public BuildFactory getFactory() {
        return new PSFactory(this);
    }

    @Override
    public boolean init() {
        boardService = engine.getBoardService();
        this.ConsoleInit();
        for (int i = 0; i < 8; ++i) {
            Globals.PlayerList[i] = new PlayerStruct();
            Player.sPlayerSave[i] = new PlayerSave();
            Globals.sPlayerInput[i] = new Input();
        }
        Sound.sndInit();
        Random.InitRandom();
        Sound.LoadFX();
        Seq.LoadSequences();
        this.InitOriginalEpisodes();
        byte[] remapbuf = new byte[256];
        for (int i = 0; i < 255; ++i) {
            remapbuf[i] = (byte)(99 + (i & 8));
        }
        engine.getPaletteManager().makePalookup(20, remapbuf, 0, 0, 0, 1);
        Gdx.app.postRunnable(Palette::GrabPalette);
        Globals.nItemTextIndex = this.FindGString("ITEMS");
        Arrays.fill(Globals.nPlayerLives, 3);
        Globals.nBestLevel = 0;
        Main.game.pNet.ResetTimers();
        Directory gameDir = this.cache.getGameDirectory();
        Console.out.println("Initializing def-scripts...");
        this.cache.loadGdxDef(this.baseDef, appdef, "psgdx.dat");
        if (this.pCfg.isAutoloadFolder()) {
            Console.out.println("Initializing autoload folder");
            block11: for (Entry file : gameDir.getDirectory(gameDir.getEntry("autoload"))) {
                switch (file.getExtension()) {
                    case "PK3": 
                    case "ZIP": {
                        Group group = this.cache.newGroup(file);
                        Entry def = group.getEntry(appdef);
                        if (!def.exists()) continue block11;
                        this.cache.addGroup(group, CacheResourceMap.CachePriority.NORMAL);
                        this.baseDef.loadScript(file.getName(), def);
                        break;
                    }
                    case "DEF": {
                        this.baseDef.loadScript(file);
                    }
                }
            }
        }
        LoadSave.FindSaves(this.getUserDirectory());
        Sound.searchCDtracks();
        FileEntry filgdx = gameDir.getEntry(appdef);
        if (filgdx.exists()) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[1] = new MenuGame(this);
        this.menu.mMenus[11] = new NewAddon(this);
        this.menu.mMenus[12] = new MenuCorruptGame(this);
        gLoadingScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gDemoScreen = new DemoScreen(this);
        gMap = new MapScreen(this);
        gLogoScreen = new PSLogoScreen(this);
        gLogoScreen2 = new LogoScreen2(this, 1.0f);
        gMovieScreen = new PSMovieScreen(this);
        gMenuScreen = new MenuScreen(this);
        gCinemaScreen = new CinemaScreen(this);
        gDemoScreen.demoscan(gameDir);
        System.gc();
        MemLog.log("create");
        return true;
    }

    @Override
    public void onDropEntry(FileEntry entry) {
        if (!entry.isExtension("map")) {
            return;
        }
        Console.out.println("Start dropped map: " + entry.getName());
        gGameScreen.newgame(entry, 0, false);
    }

    private void InitOriginalEpisodes() {
        Directory dir = this.cache.getGameDirectory();
        Globals.gTrainingEpisode = new EpisodeInfo("Training", new EpisodeEntry.Addon(dir, dir.getDirectoryEntry()));
        Globals.gTrainingEpisode.gMapInfo.add(new MapInfo("lev0.map", "Training"));
        String[] sMapName = new String[]{"Abu Simbel", "Dendur", "Kalabsh", "El Subua", "El Derr", "Abu Ghurab", "Philae", "El Kab", "Aswan", "Set Boss", "Qubbet el Hawa", "Abydos", "Edufu", "West Bank", "Luxor", "Karnak", "Saqqara", "Mittrahn", "Kilmaatikahn Boss", "Alien Mothership"};
        Globals.gOriginalEpisode = new EpisodeInfo("Original", new EpisodeEntry.Addon(dir, dir.getDirectoryEntry()));
        for (int i = 0; i < 20; ++i) {
            Globals.gOriginalEpisode.gMapInfo.add(new MapInfo("lev" + (i + 1) + ".map", sMapName[i]));
        }
        PSMenuUserContent.episodeManager.putEpisode(Globals.gTrainingEpisode);
        PSMenuUserContent.episodeManager.putEpisode(Globals.gOriginalEpisode);
    }

    private void ConsoleInit() {
        Console.out.println("Initializing on-screen display system");
        Console.out.getPrompt().setVersion(this.getTitle(), OsdColor.YELLOW, 10);
        Console.out.registerCommand(new OsdValueRange("changemap", "", Globals.levelnum, 0.0f, 20.0f){

            @Override
            public float getValue() {
                return Globals.levelnum;
            }

            @Override
            protected void setCheckedValue(float value) {
                Globals.levelnum = (int)value;
            }
        });
    }

    public void resetState() {
        this.menu.mClose();
        this.menu.mOpen(this.menu.mMenus[0], -1);
        PSMenuUserContent.resetEpisodeResources(Globals.gOriginalEpisode);
        LoadSave.gAutosaveRequest = false;
        Globals.levelnum = 0;
        Globals.levelnew = 0;
        Globals.nBestLevel = -1;
        Globals.mUserFlag = UserFlag.None;
        Globals.boardfilename = Directory.DUMMY_ENTRY;
        LoadSave.lastload = null;
        Sound.StopAllSounds();
        if (Sound.MusicPlaying() && Sound.currTrack != 19) {
            Sound.StopMusic();
        }
    }

    public int FindGString(String string) {
        int i = 0;
        while (true) {
            if (Globals.gString[i].equals(string)) {
                return i + 1;
            }
            if (Globals.gString[i].equals("EOF")) break;
            ++i;
        }
        return -1;
    }

    @Override
    public void show() {
        if (PSMenuUserContent.usecustomarts) {
            PSMenuUserContent.resetEpisodeResources(null);
        }
        this.changeScreen(gLogoScreen.setTime(2.0f).setTile(3349).setCallback(this.logo).setSkipping(this.toLogo3));
    }

    @Override
    public DefaultPrecacheScreen getPrecacheScreen(Runnable readyCallback, PrecacheListener listener) {
        return new PrecacheScreen(readyCallback, listener);
    }

    @Override
    public LogSender getLogSender() {
        return new LogSender(this){

            @Override
            public byte[] reportData() {
                byte[] out;
                Sprite pSprite;
                String report = "Mapname: " + Globals.boardfilename;
                report = report + "\r\n";
                report = report + "UserFlag: " + (Object)((Object)Globals.mUserFlag);
                report = report + "\r\n";
                if (Globals.PlayerList[Mmulti.myconnectindex] != null && boardService.isValidSprite(Globals.PlayerList[Mmulti.myconnectindex].spriteId) && (pSprite = boardService.getSprite(Globals.PlayerList[Mmulti.myconnectindex].spriteId)) != null) {
                    report = report + "PlayerX " + pSprite.getX();
                    report = report + "\r\n";
                    report = report + "PlayerY " + pSprite.getY();
                    report = report + "\r\n";
                    report = report + "PlayerZ " + pSprite.getZ();
                    report = report + "\r\n";
                    report = report + "PlayerAng " + pSprite.getAng();
                    report = report + "\r\n";
                    report = report + "PlayerSect: " + pSprite.getSectnum();
                    report = report + "\r\n";
                }
                if (Globals.mUserFlag == UserFlag.UserMap) {
                    ByteArray array = new ByteArray();
                    byte[] data = Globals.boardfilename.getBytes();
                    report = report + "\r\n<------Start Map data------->\r\n";
                    array.addAll(report.getBytes());
                    array.addAll(data);
                    array.addAll("\r\n<------End Map data------->\r\n".getBytes());
                    out = Arrays.copyOf(array.items, array.size);
                } else {
                    out = report.getBytes();
                }
                return out;
            }
        };
    }

    public void EndGame() {
        Sound.StopAllSounds();
        Sound.StopMusic();
        this.changeScreen(gLogoScreen.setTime(2.0f).setTile(3349).setCallback(this.logo).setSkipping(this.toLogo3));
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;

    }
}

