/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Menus;

import java.util.List;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.grp.GrpFile;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Menus.NewAddon;
import ru.m210projects.Powerslave.Menus.PSTitle;
import ru.m210projects.Powerslave.Type.EpisodeEntry;
import ru.m210projects.Powerslave.Type.EpisodeInfo;
import ru.m210projects.Powerslave.Type.EpisodeManager;

public class PSMenuUserContent
extends BuildMenu {
    public static final EpisodeManager episodeManager = new EpisodeManager();
    private static GrpFile usergroup;
    public static boolean usecustomarts;
    private final Main app;

    public PSMenuUserContent(Main app) {
        super(app.pMenu);
        this.app = app;
        PSTitle title = new PSTitle("User content", 160, 15, 0);
        int width = 240;
        MenuFileBrowser list = new MenuFileBrowser(app, app.getFont(3), app.getFont(0), app.getFont(3), 40, 55, width, 1, 17, 3352){

            @Override
            public void init() {
                this.registerExtension("map", 0, 0);
                this.registerExtension("zip", 5, 1);
                this.registerExtension("pk3", 5, 1);
                this.registerClass(EpisodeEntry.Addon.class, 5, 2);
            }

            @Override
            public void handleDirectory(Directory dir) {
                EpisodeInfo ep = episodeManager.getEpisode(dir.getDirectoryEntry());
                if (ep != null) {
                    if (ep.equals(Globals.gOriginalEpisode)) {
                        return;
                    }
                    this.addFile(ep.getEpisodeEntry());
                }
            }

            @Override
            public void handleFile(FileEntry file) {
                EpisodeInfo ep;
                if (file.isExtension("map")) {
                    Directory dir = file.getParent();
                    EpisodeInfo addon = episodeManager.getEpisode(dir.getDirectoryEntry());
                    if (addon != null) {
                        for (int j = 0; j < addon.maps(); ++j) {
                            if (!file.getName().equalsIgnoreCase(addon.gMapInfo.get((int)j).path)) continue;
                            return;
                        }
                    }
                    this.addFile(file);
                } else if ((file.isExtension("zip") || file.isExtension("pk3")) && (ep = episodeManager.getEpisode(file)) != null) {
                    this.addFile(ep.getEpisodeEntry());
                }
            }

            @Override
            public void invoke(FileEntry fil) {
                switch (fil.getExtension()) {
                    case "MAP": {
                        PSMenuUserContent.this.launchMap(fil);
                        this.app.pMenu.mClose();
                        break;
                    }
                    case "GRP": 
                    case "ZIP": 
                    case "PK3": {
                        PSMenuUserContent.this.launchEpisode(episodeManager.getEpisode(fil));
                        break;
                    }
                    default: {
                        if (!(fil instanceof EpisodeEntry)) break;
                        PSMenuUserContent.this.launchEpisode(episodeManager.getEpisode(fil));
                    }
                }
            }

            @Override
            protected void drawHeader(Renderer renderer, int x1, int x2, int y) {
                this.app.getFont(1).drawTextScaled(renderer, x1, y, this.dirs, 0.5f, -32, this.topPal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
                this.app.getFont(1).drawTextScaled(renderer, x2 + 13, y, this.ffs, 0.5f, -32, this.topPal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
            }
        };
        list.topPal = 20;
        this.addItem(title, false);
        this.addItem(list, true);
    }

    public static void resetEpisodeResources(EpisodeInfo def) {
        Console.out.println("Resetting custom resources", OsdColor.GREEN);
        if (usergroup != null) {
            Main.game.getCache().removeGroup(usergroup);
        }
        usergroup = null;
        Globals.gCurrentEpisode = def;
        if (!usecustomarts) {
            Main.game.setDefs(Main.game.baseDef);
            return;
        }
        System.err.println("Reset to default resources");
        if (Main.engine.loadpics() == 0) {
            throw new AssertException("ART files not found " + Main.game.getCache().getGameDirectory().getPath().resolve(Main.engine.getTileManager().getTilesPath()));
        }
        if (!Main.game.setDefs(Main.game.baseDef)) {
            Main.game.baseDef.apply();
        }
        usecustomarts = false;
    }

    public static void checkEpisodeResources(EpisodeInfo addon) {
        if (addon.equals(Globals.gCurrentEpisode)) {
            return;
        }
        PSMenuUserContent.resetEpisodeResources(Globals.gOriginalEpisode);
        usergroup = new GrpFile("RemovableGroup");
        EpisodeEntry.Addon addonEntry = addon.getEpisodeEntry();
        Group parent = addonEntry.getGroup();
        DefScript addonScript = new DefScript(Main.game.baseDef, addonEntry.getFileEntry());
        if (!(parent instanceof Directory)) {
            try {
                Entry res = parent.getEntry("psgdx.def");
                if (res.exists()) {
                    addonScript.loadScript(parent.getName() + " script", res);
                }
                PSMenuUserContent.searchEpisodeResources(parent, usergroup);
            }
            catch (Exception e) {
                throw new WarningException("Error found in " + addonEntry.getName() + "\r\n" + e.getMessage());
            }
        } else if (!Main.game.getCache().isGameDirectory(parent)) {
            PSMenuUserContent.searchEpisodeResources(parent, usergroup);
            Entry def = parent.getEntry("psgdx.def");
            if (def.exists()) {
                addonScript.loadScript(def);
            }
        }
        Main.game.getCache().addGroup(usergroup, CacheResourceMap.CachePriority.HIGHEST);
        PSMenuUserContent.InitGroupResources(addonScript, usergroup.getEntries());
        Globals.gCurrentEpisode = addon;
        Main.game.setDefs(addonScript);
    }

    private static void searchEpisodeResources(Group container, GrpFile resourceHolder) {
        for (Entry file : container.getEntries()) {
            Group subContainer = Directory.DUMMY_DIRECTORY;
            if (file.isDirectory() && file instanceof FileEntry) {
                subContainer = ((FileEntry)file).getDirectory();
            } else if (file.isExtension("pk3") || file.isExtension("zip") || file.isExtension("grp") || file.isExtension("rff")) {
                subContainer = Main.game.getCache().newGroup(file);
            }
            if (!((Object)subContainer).equals(Directory.DUMMY_DIRECTORY)) {
                PSMenuUserContent.searchEpisodeResources(subContainer, resourceHolder);
                continue;
            }
            resourceHolder.addEntry(file);
        }
    }

    public static void InitGroupResources(DefScript addonScript, List<Entry> list) {
        for (Entry res : list) {
            switch (res.getExtension()) {
                case "ART": {
                    Main.engine.loadpic(res);
                    usecustomarts = true;
                    break;
                }
                case "DEF": {
                    if (res.getName().equalsIgnoreCase("psgdx.def")) break;
                    addonScript.loadScript(res.getName() + " script", res);
                    Console.out.println("Found def-script. Loading " + res.getName());
                }
            }
        }
    }

    private void launchEpisode(EpisodeInfo ep) {
        if (ep == null) {
            return;
        }
        ((NewAddon)this.app.menu.mMenus[11]).setAddon(ep);
        this.app.pMenu.mOpen(this.app.menu.mMenus[11], -1);
    }

    private void launchMap(FileEntry fil) {
        if (fil == null) {
            return;
        }
        Main.gGameScreen.newgame(fil, 0, false);
    }
}

