/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.math.Vector2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Switch;
import ru.m210projects.Powerslave.Type.BlockInfo;
import ru.m210projects.Powerslave.Type.MoveSectStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Type.TrailPointStruct;
import ru.m210projects.Powerslave.View;

public class PSSector {
    public static int overridesect;
    public static final int[] NearSector;
    public static int NearCount;
    public static int LinkCount;
    public static final byte[][] LinkMap;
    private static final Vector2 tmpVec;

    public static Vector2 MoveSector(int nObject, int angle, int xvec, int yvec) {
        Sector pObject = Main.boardService.getSector(nObject);
        if (pObject != null) {
            int block_y;
            int block_x;
            int v4;
            int v5;
            Wall wall = Main.boardService.getWall(pObject.getWallptr());
            if (wall == null) {
                return tmpVec.setZero();
            }
            if (angle < 0) {
                v5 = yvec;
                v4 = xvec;
                angle = Main.engine.GetMyAngle(xvec, yvec);
            } else {
                v4 = EngineUtils.sin(angle + 512 & 0x7FF) << 6;
                v5 = EngineUtils.sin(angle & 0x7FF) << 6;
            }
            int v53 = pObject.getFloorz();
            int flags = Globals.SectFlag[nObject] & 0x2000;
            BlockInfo bInfo = Globals.sBlockInfo[pObject.getExtra()];
            int oldx = block_x = bInfo.cx;
            int oldy = block_y = bInfo.cy;
            int nSector = nObject;
            short nNextSector = wall.getNextsector();
            Sector nextSec = Main.boardService.getSector(nNextSector);
            int z1 = 0;
            int z2 = 0;
            if (nextSec != null) {
                if (flags != 0) {
                    z2 = pObject.getCeilingz();
                    z1 = nextSec.getCeilingz() + 256;
                    pObject.setCeilingz(nextSec.getCeilingz());
                } else {
                    z2 = pObject.getFloorz();
                    z1 = nextSec.getFloorz() - 256;
                    pObject.setFloorz(nextSec.getFloorz());
                }
            }
            Main.engine.clipmove(block_x, block_y, z1, nSector, v4, v5, bInfo.field_8, 0, 0, 0x1000040);
            if (Engine.clipmove_sectnum > -1) {
                block_x = Engine.clipmove_x;
                block_y = Engine.clipmove_y;
                nSector = Engine.clipmove_sectnum;
            }
            int dx = block_x - oldx;
            int dy = block_y - oldy;
            if (nSector == nNextSector || nSector == nObject) {
                if (flags == 0) {
                    block_x = oldx;
                    block_y = oldy;
                    Main.engine.clipmove(block_x, block_y, z2, nSector, v4, v5, bInfo.field_8, 0, 0, 0x1000040);
                    if (Engine.clipmove_sectnum > -1) {
                        block_x = Engine.clipmove_x;
                        block_y = Engine.clipmove_y;
                    }
                    if (Pragmas.klabs(dx) > Pragmas.klabs(block_x - oldx)) {
                        dx = block_x - oldx;
                    }
                    if (Pragmas.klabs(dy) > Pragmas.klabs(block_y - oldy)) {
                        dy = block_y - oldy;
                    }
                }
            } else {
                dx = 0;
                dy = 0;
            }
            if ((dx | dy) != 0) {
                Sprite pSprite;
                int i;
                ListNode<Sprite> next;
                ListNode<Sprite> node = Main.boardService.getSectNode(nObject);
                while (node != null) {
                    next = node.getNext();
                    i = node.getIndex();
                    pSprite = node.get();
                    Main.game.pInt.setsprinterpolate(i, pSprite);
                    if (pSprite.getStatnum() >= 99) {
                        if (flags != 0 || pSprite.getZ() != z2 || (pSprite.getCstat() & 0x8000) != 0) {
                            block_x = pSprite.getX();
                            block_y = pSprite.getY();
                            nSector = nObject;
                            Main.engine.clipmove(block_x, block_y, pSprite.getZ(), nSector, -dx, -dy, 4 * pSprite.getClipdist(), 0, 0, 65537);
                            if (Engine.clipmove_sectnum > -1) {
                                pSprite.setZ(Engine.clipmove_z);
                                nSector = Engine.clipmove_sectnum;
                            }
                            if (nSector >= 0 && nSector < 1024 && nSector != nObject) {
                                Main.engine.mychangespritesect(i, nSector);
                            }
                        }
                    } else {
                        pSprite.setX(pSprite.getX() + dx);
                        pSprite.setY(pSprite.getY() + dy);
                    }
                    node = next;
                }
                node = Main.boardService.getSectNode(nNextSector);
                while (node != null) {
                    next = node.getNext();
                    i = node.getIndex();
                    pSprite = node.get();
                    if (pSprite.getStatnum() >= 99) {
                        block_x = pSprite.getX();
                        block_y = pSprite.getY();
                        nSector = nNextSector;
                        int dist = 4 * pSprite.getClipdist();
                        Main.engine.clipmove(block_x, block_y, pSprite.getZ(), nSector, (long)(-dx) - (long)EngineUtils.sin(angle + 512 & 0x7FF) * (long)dist, (long)(-dy) - (long)EngineUtils.sin(angle) * (long)dist, dist, 0, 0, 65537);
                        if (Engine.clipmove_sectnum > -1) {
                            pSprite.setZ(Engine.clipmove_z);
                            nSector = Engine.clipmove_sectnum;
                        }
                        if (nSector != nNextSector && (nSector == nObject || nNextSector == nObject)) {
                            if (nSector != nObject || v53 >= pSprite.getZ()) {
                                if (nSector >= 0 && nSector < 1024) {
                                    Main.engine.mychangespritesect(i, nSector);
                                }
                            } else {
                                Main.engine.movesprite(i, (dx << 14) + EngineUtils.sin(angle + 512 & 0x7FF) * pSprite.getClipdist(), (dy << 14) + pSprite.getClipdist() * EngineUtils.sin(angle), 0, 0, 0, 0);
                            }
                        }
                    }
                    node = next;
                }
                for (short i2 = pObject.getWallptr(); i2 < pObject.getWallptr() + pObject.getWallnum(); i2 = (short)(i2 + 1)) {
                    Wall w = Main.boardService.getWall(i2);
                    if (w == null) continue;
                    Main.engine.dragpoint(i2, dx + w.getX(), dy + w.getY());
                }
                bInfo.cx += dx;
                bInfo.cy += dy;
            }
            dx <<= 14;
            dy <<= 14;
            if (flags == 0) {
                for (ListNode<Sprite> node = Main.boardService.getSectNode(nObject); node != null; node = node.getNext()) {
                    int i = node.getIndex();
                    Sprite pSprite = node.get();
                    if (pSprite.getStatnum() < 99 || z2 != pSprite.getZ() || (pSprite.getCstat() & 0x8000) != 0) continue;
                    nSector = nObject;
                    Main.game.pInt.setsprinterpolate(i, pSprite);
                    Main.engine.clipmove(pSprite.getX(), pSprite.getY(), pSprite.getZ(), nSector, dx, dy, 4 * pSprite.getClipdist(), 5120, -5120, 65537);
                    if (Engine.clipmove_sectnum <= -1) continue;
                    pSprite.setX(Engine.clipmove_x);
                    pSprite.setY(Engine.clipmove_y);
                    pSprite.setZ(Engine.clipmove_z);
                }
            }
            if (flags != 0) {
                pObject.setCeilingz(z2);
            } else {
                pObject.setFloorz(z2);
            }
            tmpVec.set(dx, dy);
        } else {
            tmpVec.set(xvec, yvec);
        }
        return tmpVec;
    }

    public static int feebtag(int x, int y, int z, int sectnum, int a6, int dist) {
        Sector sector = Main.boardService.getSector(sectnum);
        if (sector == null) {
            return -1;
        }
        int out = -1;
        int sec = sectnum;
        for (ListNode<Wall> wn = sector.getWallNode(); wn != null; wn = wn.getNext()) {
            if (sec != -1) {
                for (ListNode<Sprite> node = Main.boardService.getSectNode(sec); node != null; node = node.getNext()) {
                    int v15;
                    Sprite pSprite = node.get();
                    if (pSprite.getStatnum() < 900 || (pSprite.getCstat() & 0x8000) != 0) continue;
                    int v11 = pSprite.getX() - x;
                    int v14 = pSprite.getY() - y;
                    int v13 = pSprite.getZ() - z;
                    if (v13 >= 5120 || v13 <= -25600 || (v15 = EngineUtils.sqrt(v14 * v14 + v11 * v11)) >= dist || (pSprite.getStatnum() == 950 || pSprite.getStatnum() == 949) && (a6 & 1) != 0 || (pSprite.getStatnum() == 912 || pSprite.getStatnum() == 913) && (a6 & 2) != 0) continue;
                    dist = v15;
                    out = node.getIndex();
                }
            }
            sec = wn.get().getNextsector();
        }
        return out;
    }

    public static void DoMovingSects() {
        for (int i = 0; i < Globals.nMoveSects; ++i) {
            Sector sec;
            int v2;
            MoveSectStruct v0 = Globals.sMoveSect[i];
            if (v0.field_0 == -1 || (v2 = v0.field_E) != -1 && RunList.channel[v2].field_4 == 0 || (sec = Main.boardService.getSector(v0.field_0)) == null) continue;
            BlockInfo v3 = Globals.sBlockInfo[sec.getExtra()];
            if (v0.field_4 == -1) {
                int v5;
                int v4 = v0.field_6;
                if ((v4 & 0x20) != 0) {
                    RunList.ChangeChannel(v0.field_E, 0);
                }
                if ((v5 = v4 & 0x10) != 0) {
                    Globals.sMoveDir[i] = -Globals.sMoveDir[i];
                    v0.field_4 = Globals.sMoveDir[i] <= 0 ? Globals.sTrail[v0.field_2].field_4 : Globals.sTrail[v0.field_2].field_0;
                } else {
                    v0.field_4 = Globals.sTrail[v0.field_2].field_0;
                }
            }
            TrailPointStruct v9 = Globals.sTrailPoint[v0.field_4];
            int dx = v9.x - v3.cx;
            int dy = v9.y - v3.cy;
            int ang = Main.engine.GetMyAngle(dx, dy) & 0x7FF;
            int v29 = 16 * EngineUtils.sin(ang) * v0.field_A;
            int v30 = 16 * EngineUtils.sin(ang + 512 & 0x7FF) * v0.field_A;
            int v16 = dx << 14;
            int v20 = dy << 14;
            if (Pragmas.klabs(v30) > Pragmas.klabs(v16) || Pragmas.klabs(v29) > Pragmas.klabs(v20)) {
                v29 = v20;
                v30 = v16;
                v0.field_4 = Globals.sMoveDir[i] <= 0 ? Globals.nTrailPointPrev[v0.field_4] : Globals.nTrailPointNext[v0.field_4];
            }
            if (v0.field_8 != -1) {
                Vector2 vec = PSSector.MoveSector(v0.field_8, -1, v30, v29);
                v30 = (int)vec.x;
                v29 = (int)vec.y;
            }
            int v28 = v30;
            int v27 = v29;
            Vector2 vec = PSSector.MoveSector(v0.field_0, -1, v30, v29);
            v30 = (int)vec.x;
            v29 = (int)vec.y;
            if (v30 == v28 && v29 == v27) continue;
            PSSector.MoveSector(v0.field_8, -1, v28, v27);
            PSSector.MoveSector(v0.field_8, -1, v30, v29);
        }
    }

    public static Vector2 CheckSectorFloor(int nSector, int z, int dx, int dy) {
        tmpVec.set(dx, dy);
        Sector sec = Main.boardService.getSector(nSector);
        if (sec != null && Globals.SectSpeed[nSector] != 0) {
            int v10 = Globals.SectFlag[nSector] & 0x7FF;
            if (z >= sec.getFloorz()) {
                PSSector.tmpVec.x += (float)(Globals.SectSpeed[nSector] * 8 * EngineUtils.sin(v10 + 512 & 0x7FF));
                PSSector.tmpVec.y += (float)(Globals.SectSpeed[nSector] * 8 * EngineUtils.sin(v10 & 0x7FF));
            } else if ((Globals.SectFlag[nSector] & 0x800) != 0) {
                PSSector.tmpVec.x += (float)(Globals.SectSpeed[nSector] * 16 * EngineUtils.sin(v10 + 512 & 0x7FF));
                PSSector.tmpVec.y += (float)(Globals.SectSpeed[nSector] * 16 * EngineUtils.sin(v10 & 0x7FF));
            }
        }
        return tmpVec;
    }

    public static void saveSecExtra(OutputStream os) throws IOException {
        for (int i = 0; i < 1024; ++i) {
            StreamUtils.writeShort(os, Globals.SectSoundSect[i]);
            StreamUtils.writeShort(os, Globals.SectSound[i]);
            StreamUtils.writeShort(os, Globals.SectAbove[i]);
            StreamUtils.writeShort(os, Globals.SectBelow[i]);
            StreamUtils.writeShort(os, Globals.SectDepth[i]);
            StreamUtils.writeShort(os, Globals.SectFlag[i]);
            StreamUtils.writeShort(os, Globals.SectSpeed[i]);
            StreamUtils.writeShort(os, Globals.SectDamage[i]);
        }
    }

    public static void loadSecExtra(SafeLoader loader, InputStream is) throws IOException {
        for (int i = 0; i < 1024; ++i) {
            loader.SectSoundSect[i] = StreamUtils.readShort(is);
            loader.SectSound[i] = StreamUtils.readShort(is);
            loader.SectAbove[i] = StreamUtils.readShort(is);
            loader.SectBelow[i] = StreamUtils.readShort(is);
            loader.SectDepth[i] = StreamUtils.readShort(is);
            loader.SectFlag[i] = StreamUtils.readShort(is);
            loader.SectSpeed[i] = StreamUtils.readShort(is);
            loader.SectDamage[i] = StreamUtils.readShort(is);
        }
    }

    public static void loadSecExtra(SafeLoader loader) {
        System.arraycopy(loader.SectSoundSect, 0, Globals.SectSoundSect, 0, 1024);
        System.arraycopy(loader.SectSound, 0, Globals.SectSound, 0, 1024);
        System.arraycopy(loader.SectAbove, 0, Globals.SectAbove, 0, 1024);
        System.arraycopy(loader.SectBelow, 0, Globals.SectBelow, 0, 1024);
        System.arraycopy(loader.SectDepth, 0, Globals.SectDepth, 0, 1024);
        System.arraycopy(loader.SectFlag, 0, Globals.SectFlag, 0, 1024);
        System.arraycopy(loader.SectSpeed, 0, Globals.SectSpeed, 0, 1024);
        System.arraycopy(loader.SectDamage, 0, Globals.SectDamage, 0, 1024);
    }

    public static void SnapSectors(int a1, int a2, int a3) {
        Sector v3 = Main.boardService.getSector(a1);
        Sector v4 = Main.boardService.getSector(a2);
        if (v3 == null || v4 == null) {
            return;
        }
        int v29 = v3.getWallnum();
        int v30 = v4.getWallnum();
        int i = 0;
        while (i < v29) {
            int v5 = v4.getWallptr();
            int v6 = 0x7FFFFFF;
            int v7 = v3.getWallptr();
            int j = 0;
            int v9 = 0x7FFFFFF;
            int v31 = 0;
            Wall w7 = Main.boardService.getWall(v7);
            if (w7 != null) {
                int v26 = w7.getX();
                int v24 = w7.getY();
                while (j < v30) {
                    Wall w5 = Main.boardService.getWall(v7);
                    if (w5 != null) {
                        int v11 = v26 - w5.getX();
                        int v12 = v24 - w5.getY();
                        int v13 = v26 - w5.getX();
                        if (v13 < 0) {
                            v13 = -v13;
                        }
                        int v22 = v13;
                        int v14 = v12;
                        if (v12 < 0) {
                            v14 = -v12;
                        }
                        int v23 = v14 + v22;
                        int v15 = v6;
                        if (v6 < 0) {
                            v15 = -v6;
                        }
                        int v21 = v15;
                        int v16 = v9;
                        if (v9 < 0) {
                            v16 = -v9;
                        }
                        if (v23 < v16 + v21) {
                            v31 = v5;
                            v6 = v11;
                            v9 = v12;
                        }
                    }
                    ++j;
                    ++v5;
                }
            }
            ++i;
            ++v7;
            Wall w31 = Main.boardService.getWall(v31);
            if (w31 == null) continue;
            Main.engine.dragpoint(v31, v6 + w31.getX(), v9 + w31.getY());
        }
        if (a3 != 0) {
            Sector s2 = Main.boardService.getSector(a2);
            Sector s1 = Main.boardService.getSector(a1);
            if (s1 != null && s2 != null) {
                s2.setCeilingz(s1.getFloorz());
            }
        }
        if ((Globals.SectFlag[a1] & 0x1000) != 0) {
            Map.SnapBobs(a1, a2);
        }
    }

    public static int FindWallSprites(int a1) {
        Sprite s;
        Sector sec = Main.boardService.getSector(a1);
        if (sec == null) {
            return -1;
        }
        int miny = Integer.MAX_VALUE;
        int maxy = -2147483646;
        int minx = Integer.MAX_VALUE;
        int maxx = -2147483646;
        for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
            Wall w = wn.get();
            if (minx > w.getX()) {
                minx = w.getX();
            }
            if (maxx < w.getX()) {
                maxx = w.getX();
            }
            if (miny > w.getY()) {
                miny = w.getY();
            }
            if (maxy >= w.getY()) continue;
            maxy = w.getY();
        }
        int x1 = minx - 5;
        int y1 = miny - 5;
        int x2 = maxx + 5;
        int y2 = maxy + 5;
        int spr = -1;
        for (int i = 0; i < 4096; ++i) {
            Sprite s2 = Main.boardService.getSprite(i);
            if (s2 == null || s2.getLotag() != 0 || (s2.getCstat() & 0x50) != 80 || s2.getX() < x1 || x2 < s2.getX() || s2.getY() < y1 || s2.getY() > y2) continue;
            s2.setOwner(spr);
            spr = i;
        }
        if (spr == -1 && (s = Main.boardService.getSprite(spr = Main.engine.insertsprite(a1, 401))) != null) {
            s.setX((x2 + x1) / 2);
            s.setY((y2 + y1) / 2);
            s.setZ(sec.getFloorz());
            s.setCstat(32768);
            s.setOwner(-1);
            s.setLotag(0);
            s.setHitag(0);
        }
        return spr;
    }

    public static int BuildLink(int a1, int ... a2) {
        int v2 = -1;
        if (LinkCount > 0) {
            v2 = --LinkCount;
            for (int v3 = 0; v3 < 8; ++v3) {
                int v5 = -1;
                if (v3 < a1) {
                    v5 = a2[v3];
                }
                PSSector.LinkMap[v2][v3] = (byte)v5;
            }
        }
        return v2;
    }

    public static void saveLinks(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, LinkCount);
        for (int i = 0; i < 1024; ++i) {
            for (int j = 0; j < 8; ++j) {
                StreamUtils.writeByte(os, LinkMap[i][j]);
            }
        }
    }

    public static void loadLinks(SafeLoader loader, InputStream is) throws IOException {
        loader.LinkCount = StreamUtils.readShort(is);
        for (int i = 0; i < 1024; ++i) {
            for (int j = 0; j < 8; ++j) {
                loader.LinkMap[i][j] = StreamUtils.readByte(is);
            }
        }
    }

    public static void loadLinks(SafeLoader loader) {
        LinkCount = loader.LinkCount;
        for (int i = 0; i < 1024; ++i) {
            System.arraycopy(loader.LinkMap[i], 0, LinkMap[i], 0, 8);
        }
    }

    public static void ProcessSectorTag(int nSector, int nLotag, int nHitag) {
        Sector sec = Main.boardService.getSector(nSector);
        if (sec == null) {
            return;
        }
        int nChannel = RunList.AllocChannel(nHitag % 1000);
        int[] v263 = new int[8];
        int var_24 = nHitag / 1000 << 12;
        int v269 = 4 * Gameutils.BClipLow(nLotag / 1000, 1);
        int v270 = 100 * v269;
        switch (nLotag % 1000 - 1) {
            case 0: 
            case 69: 
            case 70: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getCeilingz(), -1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getCeilingz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, PSSector.BuildLink(1, 1), nSector, var_24));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 60));
                break;
            }
            case 1: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getCeilingz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, PSSector.BuildLink(1, 1), nSector, var_24));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 60));
                break;
            }
            case 4: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz() + 1, -1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getCeilingz()));
                break;
            }
            case 5: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), 400, 400, 2, nNext.getFloorz(), sec.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, PSSector.BuildLink(2, 1, 1), nSector));
                sec.setFloorz(nNext.getFloorz());
                return;
            }
            case 6: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, PSSector.BuildLink(1, 1), nSector));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwNotOnPause(nChannel, PSSector.BuildLink(2, -1, 0), nSector, 8));
                break;
            }
            case 7: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz() + 1, 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                break;
            }
            case 8: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 150));
                break;
            }
            case 9: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, PSSector.BuildLink(1, 1), nSector));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwNotOnPause(nChannel, PSSector.BuildLink(2, -1, 0), nSector, 8));
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 37: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                break;
            }
            case 11: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 150));
                break;
            }
            case 12: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwReady(nChannel, PSSector.BuildLink(2, 1, 0)));
                break;
            }
            case 15: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), 200, v270, 2, sec.getCeilingz(), sec.getFloorz() - 8));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, PSSector.BuildLink(1, 1), nSector));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwReady(nChannel, PSSector.BuildLink(2, -1, 0)));
                break;
            }
            case 16: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), 200, v270, 2, sec.getCeilingz(), sec.getFloorz() - 8));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwReady(nChannel, PSSector.BuildLink(2, -1, 0)));
                break;
            }
            case 17: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), 200, v270, 2, sec.getFloorz(), sec.getCeilingz() + (sec.getFloorz() - sec.getCeilingz()) / 2));
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), 200, v270, 2, sec.getCeilingz(), (sec.getFloorz() - sec.getCeilingz()) / 2 + sec.getCeilingz() - 8));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, PSSector.BuildLink(1, 1), nSector));
                break;
            }
            case 20: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, PSSector.BuildLink(2, 1, 1), nSector));
                break;
            }
            case 23: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getCeilingz(), -1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getCeilingz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 60));
                break;
            }
            case 24: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 300));
                break;
            }
            case 25: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 450));
                break;
            }
            case 26: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 600));
                break;
            }
            case 27: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 900));
                break;
            }
            case 30: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), Short.MAX_VALUE, Short.MAX_VALUE, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, PSSector.BuildLink(1, 1), nSector));
                break;
            }
            case 31: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), Short.MAX_VALUE, Short.MAX_VALUE, 2, sec.getFloorz(), nNext.getFloorz()));
                break;
            }
            case 32: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getCeilingz(), -1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(20, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, nNext.getCeilingz(), sec.getFloorz()));
                break;
            }
            case 33: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getCeilingz(), -1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(28, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, nNext.getCeilingz(), sec.getFloorz()));
                break;
            }
            case 34: 
            case 35: {
                ++Globals.nEnergyTowers;
                int i = PSSector.BuildEnergyBlock(nSector);
                if (nLotag == 36) {
                    Globals.nFinaleSpr = i;
                }
                return;
            }
            case 36: 
            case 67: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                break;
            }
            case 38: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), Short.MAX_VALUE, Short.MAX_VALUE, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, PSSector.BuildLink(1, 1), nSector));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwNotOnPause(nChannel, PSSector.BuildLink(2, -1, 0), nSector, 8));
                break;
            }
            case 39: {
                PSSector.AddMovingSector(nSector, nLotag, nHitag % 1000, 2);
                return;
            }
            case 40: {
                PSSector.AddMovingSector(nSector, nLotag, nHitag % 1000, 18);
                return;
            }
            case 41: {
                PSSector.AddMovingSector(nSector, nLotag, nHitag % 1000, 58);
                return;
            }
            case 42: {
                PSSector.AddMovingSector(nSector, nLotag, nHitag % 1000, 122);
                return;
            }
            case 43: {
                PSSector.AddMovingSector(nSector, nLotag, nHitag % 1000, 90);
                return;
            }
            case 44: {
                PSSector.CreatePushBlock(nSector);
                return;
            }
            case 47: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getCeilingz(), -1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), 200, v270, 2, sec.getCeilingz(), nNext.getCeilingz()));
                break;
            }
            case 48: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getCeilingz(), -1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), 200, v270, 2, sec.getCeilingz(), nNext.getCeilingz()));
                break;
            }
            case 50: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), 200, v270, 2, sec.getFloorz(), sec.getCeilingz() + (sec.getFloorz() - sec.getCeilingz()) / 2));
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), 200, v270, 2, sec.getCeilingz(), sec.getCeilingz() + (sec.getFloorz() - sec.getCeilingz()) / 2 - 8));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwReady(nChannel, PSSector.BuildLink(2, 1, 0)));
                break;
            }
            case 51: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getCeilingz() + (sec.getFloorz() - sec.getCeilingz()) / 2, sec.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getCeilingz() + (sec.getFloorz() - sec.getCeilingz()) / 2, sec.getCeilingz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, PSSector.BuildLink(1, 1), nSector, var_24));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 60));
                break;
            }
            case 52: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getCeilingz() + (sec.getFloorz() - sec.getCeilingz()) / 2, sec.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getCeilingz() + (sec.getFloorz() - sec.getCeilingz()) / 2, sec.getCeilingz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 150));
                break;
            }
            case 53: 
            case 54: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getCeilingz(), -1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getCeilingz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, PSSector.BuildLink(1, 1), nSector, var_24));
                break;
            }
            case 55: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getCeilingz(), -1, -1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getCeilingz()));
                break;
            }
            case 56: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getCeilingz(), nNext.getFloorz()));
                break;
            }
            case 57: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, PSSector.BuildLink(1, 1), nSector, var_24));
            }
            case 62: {
                Sector nNext;
                if (nLotag % 1000 == 63) {
                    Globals.nEnergyChan = nChannel;
                }
                if ((nNext = PSSector.getNextSectorNeighbor(nSector, sec.getCeilingz(), -1, -1)) == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getCeilingz()));
                break;
            }
            case 58: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, PSSector.BuildLink(1, 1), nSector));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwNotOnPause(nChannel, PSSector.BuildLink(1, 1), nSector, 60));
                break;
            }
            case 60: {
                Sector v212;
                int i;
                v263[0] = sec.getFloorz();
                for (i = 1; i < 8 && (v212 = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, -1)) != null; ++i) {
                    v263[i] = v212.getFloorz();
                }
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, i, v263));
                break;
            }
            case 61: {
                Sector v220;
                int i;
                v263[0] = sec.getFloorz();
                for (i = 1; i < 8 && (v220 = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1)) != null; ++i) {
                    v263[i] = v220.getFloorz();
                }
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, i, v263));
                break;
            }
            case 63: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, PSSector.BuildLink(2, 0, 0), nSector));
                break;
            }
            case 74: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, PSSector.FindWallSprites(nSector), v270, v270, 2, sec.getCeilingz(), sec.getFloorz()));
                break;
            }
            case 22: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), Short.MAX_VALUE, 200, 2, sec.getFloorz(), nNext.getFloorz()));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, PSSector.BuildLink(2, -1, 0), 60 * v269));
                break;
            }
            case 49: {
                Sector nNext = PSSector.getNextSectorNeighbor(nSector, sec.getFloorz(), 1, 1);
                if (nNext == null) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, PSSector.FindWallSprites(nSector), Short.MAX_VALUE, 200, 2, nNext.getFloorz(), sec.getFloorz()));
                break;
            }
            case 79: {
                int n = nSector;
                Globals.SectFlag[n] = Globals.SectFlag[n] | 0x8000;
            }
        }
    }

    private static Sector getNextSectorNeighbor(int sectnum, int thez, int topbottom, int direction) {
        int index = Main.engine.nextsectorneighborz(sectnum, thez, topbottom, direction);
        return Main.boardService.getSector(index);
    }

    private static int GrabPushBlock() {
        if (Map.nPushBlocks < 100) {
            if (Globals.sBlockInfo[Map.nPushBlocks] == null) {
                Globals.sBlockInfo[Map.nPushBlocks] = new BlockInfo();
            } else {
                Globals.sBlockInfo[Map.nPushBlocks].clear();
            }
            return Map.nPushBlocks++;
        }
        return -1;
    }

    public static void savePushBlocks(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, Map.nPushBlocks);
        for (int i = 0; i < Map.nPushBlocks; ++i) {
            Globals.sBlockInfo[i].save(os);
        }
    }

    public static void loadPushBlocks(SafeLoader loader) {
        Map.nPushBlocks = loader.nPushBlocks;
        for (int i = 0; i < loader.nPushBlocks; ++i) {
            if (Globals.sBlockInfo[i] == null) {
                Globals.sBlockInfo[i] = new BlockInfo();
            }
            Globals.sBlockInfo[i].copy(loader.sBlockInfo[i]);
        }
    }

    public static void loadPushBlocks(SafeLoader loader, InputStream is) throws IOException {
        loader.nPushBlocks = StreamUtils.readShort(is);
        for (int i = 0; i < loader.nPushBlocks; ++i) {
            if (loader.sBlockInfo[i] == null) {
                loader.sBlockInfo[i] = new BlockInfo();
            }
            loader.sBlockInfo[i].load(is);
        }
    }

    private static void CreatePushBlock(int a1) {
        int block = PSSector.GrabPushBlock();
        BlockInfo binfo = Globals.sBlockInfo[block];
        Sector sec = Main.boardService.getSector(a1);
        if (sec == null) {
            return;
        }
        int wx = 0;
        int wy = 0;
        for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
            wx += wn.get().getX();
            wy += wn.get().getY();
        }
        binfo.cx = wx / sec.getWallnum();
        binfo.cy = wy / sec.getWallnum();
        int i = Main.engine.insertsprite(a1, 0);
        Sprite spr = Main.boardService.getSprite(i);
        if (spr != null) {
            binfo.sprite = i;
            spr.setX(binfo.cx);
            spr.setY(binfo.cy);
            spr.setZ(sec.getFloorz() - 256);
            spr.setCstat(32768);
            int clipdist = 0;
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall w = wn.get();
                int dist = EngineUtils.sqrt((binfo.cx - w.getX()) * (binfo.cx - w.getX()) + (binfo.cy - w.getY()) * (binfo.cy - w.getY()));
                if (dist <= clipdist) continue;
                clipdist = dist;
            }
            binfo.field_8 = clipdist;
            spr.setClipdist(4 * clipdist & 0xFF);
            sec.setExtra(block);
        }
    }

    public static void AddMovingSector(int a1, int a2, int a3, int a4) {
        if (Globals.nMoveSects >= 50) {
            throw new AssertException("Too many moving sectors");
        }
        PSSector.CreatePushBlock(a1);
        Globals.sMoveDir[Globals.nMoveSects] = 1;
        if (Globals.sMoveSect[Globals.nMoveSects] == null) {
            Globals.sMoveSect[Globals.nMoveSects] = new MoveSectStruct();
        }
        MoveSectStruct v10 = Globals.sMoveSect[Globals.nMoveSects++];
        v10.field_2 = Object.FindTrail(a3);
        v10.field_4 = -1;
        v10.field_8 = -1;
        v10.field_6 = a4;
        v10.field_A = a2 / 1000 + 1;
        v10.field_0 = a1;
        v10.field_E = (a4 & 8) != 0 ? RunList.AllocChannel(a3 % 1000) : -1;
        Sector sec = Main.boardService.getSector(a1);
        if (sec != null) {
            sec.setFloorstat(sec.getFloorstat() | 0x40);
        }
    }

    public static void saveMoves(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, Globals.nMoveSects);
        for (i = 0; i < 50; ++i) {
            StreamUtils.writeByte(os, Globals.sMoveDir[i]);
        }
        for (i = 0; i < Globals.nMoveSects; ++i) {
            Globals.sMoveSect[i].save(os);
        }
    }

    public static void loadMoves(SafeLoader loader, InputStream is) throws IOException {
        int i;
        loader.nMoveSects = StreamUtils.readShort(is);
        for (i = 0; i < 50; ++i) {
            loader.sMoveDir[i] = StreamUtils.readByte(is);
        }
        for (i = 0; i < loader.nMoveSects; ++i) {
            if (loader.sMoveSect[i] == null) {
                loader.sMoveSect[i] = new MoveSectStruct();
            }
            loader.sMoveSect[i].load(is);
        }
    }

    public static void loadMoves(SafeLoader loader) {
        Globals.nMoveSects = loader.nMoveSects;
        System.arraycopy(loader.sMoveDir, 0, Globals.sMoveDir, 0, Globals.nMoveSects);
        for (int i = 0; i < loader.nMoveSects; ++i) {
            if (Globals.sMoveSect[i] == null) {
                Globals.sMoveSect[i] = new MoveSectStruct();
            }
            Globals.sMoveSect[i].copy(loader.sMoveSect[i]);
        }
    }

    private static int BuildEnergyBlock(int nSector) {
        Sector sec = Main.boardService.getSector(nSector);
        if (sec == null) {
            return -1;
        }
        int wx = 0;
        int wy = 0;
        for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
            Wall w = wn.get();
            wx += w.getX();
            wy += w.getY();
            w.setPal(0);
            w.setShade(50);
            w.setPicnum(3621);
        }
        int cx = wx / sec.getWallnum();
        int cy = wy / sec.getWallnum();
        short nextsec = sec.getWallNode().get().getNextsector();
        int i = Main.engine.insertsprite(nSector, 406);
        Sprite spr = Main.boardService.getSprite(i);
        Sector s = Main.boardService.getSector(nextsec);
        if (spr != null && s != null) {
            spr.setX(cx);
            spr.setY(cy);
            spr.setZ(s.getFloorz());
            spr.setXrepeat(Gameutils.BClipHigh(s.getFloorz() - sec.getFloorz() >> 8, 255));
            spr.setCstat(32768);
            spr.setXvel(0);
            spr.setYvel(0);
            spr.setZvel(0);
            spr.setLotag(RunList.HeadRun() + 1);
            spr.setHitag(0);
            spr.setOwner(RunList.AddRunRec(spr.getLotag() - 1, 0x250000 | i));
            spr.setExtra(-1);
            sec.setExtra(i);
            ++Globals.nEnergyBlocks;
            return i;
        }
        return -1;
    }

    public static void FuncEnergyBlock(int nStack, int nDamage, int RunPtr) {
        int nEnergy = RunList.RunData[RunPtr].getObject();
        Sprite pEnergy = Main.boardService.getSprite(nEnergy);
        if (pEnergy == null) {
            return;
        }
        short nSector = pEnergy.getSectnum();
        Sector sec = Main.boardService.getSector(nSector);
        if (sec == null) {
            return;
        }
        if (sec.getExtra() != -1) {
            switch (nStack & 0x7F0000) {
                case 655360: {
                    sec.setFloorz(pEnergy.getZ());
                    pEnergy.setZ(pEnergy.getZ() - 256);
                    nDamage = Sprites.CheckRadialDamage(nEnergy);
                    pEnergy.setZ(pEnergy.getZ() + 256);
                    sec.setFloorz(sec.getFloorz());
                }
                case 524288: {
                    if (nDamage <= 0) break;
                    if ((nDamage >>= 2) < pEnergy.getXrepeat()) {
                        pEnergy.setXrepeat(pEnergy.getXrepeat() - nDamage);
                        int spr = Main.engine.insertsprite(Bullet.lasthitsect, 0);
                        Sprite s = Main.boardService.getSprite(spr);
                        if (s == null) break;
                        s.setAng(nStack);
                        s.setX(Bullet.lasthitx);
                        s.setY(Bullet.lasthity);
                        s.setZ(Bullet.lasthitz);
                        Object.BuildSpark(spr, 0);
                        Main.engine.mydeletesprite(spr);
                        break;
                    }
                    pEnergy.setXrepeat(0);
                    PSSector.ExplodeEnergyBlock(nEnergy);
                }
            }
        }
    }

    private static void ExplodeEnergyBlock(int nEnergy) {
        Sprite pEnergy = Main.boardService.getSprite(nEnergy);
        if (pEnergy == null) {
            return;
        }
        Sector pSector = Main.boardService.getSector(pEnergy.getSectnum());
        if (pSector == null) {
            return;
        }
        for (ListNode<Wall> wn = pSector.getWallNode(); wn != null; wn = wn.getNext()) {
            Wall pNext = Main.boardService.getWall(wn.get().getNextwall());
            if (pNext == null) continue;
            if (pNext.getPal() >= 4) {
                pNext.setPal(7);
            } else {
                pNext.setPal(0);
            }
            pNext.setShade(50);
        }
        if (pSector.getFloorpal() >= 4) {
            pSector.setFloorpal(7);
        } else {
            pSector.setFloorpal(0);
        }
        pSector.setFloorshade(50);
        pSector.setExtra(-1);
        pSector.setFloorz(pEnergy.getZ());
        pEnergy.setZ((pEnergy.getZ() + pSector.getFloorz()) / 2);
        Object.BuildSpark(nEnergy, 3);
        pEnergy.setCstat(0);
        pEnergy.setXrepeat(100);
        Sound.PlayFX2(Sound.StaticSound[78], nEnergy);
        pEnergy.setXrepeat(0);
        --Globals.nEnergyTowers;
        for (int i = 0; i < 20; ++i) {
            pEnergy.setAng(Random.RandomSize(11));
            Object.BuildSpark(nEnergy, 1);
        }
        Palette.TintPalette(16, 16, 16);
        if (Globals.nEnergyTowers == 1) {
            RunList.ChangeChannel(Globals.nEnergyChan, 1);
            View.StatusMessage(1000, "TAKE OUT THE CONTROL CENTER!", -1);
        } else if (Globals.nEnergyTowers != 0) {
            View.StatusMessage(500, Globals.nEnergyTowers + " TOWERS REMAINING", -1);
        } else {
            Globals.nFinaleSpr = nEnergy;
            Globals.lFinaleStart = Gameutils.BClipLow(Main.engine.getTotalClock(), 1);
            for (int s = 0; s < Main.boardService.getSectorCount(); ++s) {
                Sector pSec = Main.boardService.getSector(s);
                if (pSec == null) continue;
                if (pSec.getCeilingpal() == 1) {
                    pSec.setCeilingpal(0);
                }
                if (pSec.getFloorpal() == 1) {
                    pSec.setFloorpal(0);
                }
                for (ListNode<Wall> wn = pSec.getWallNode(); wn != null; wn = wn.getNext()) {
                    Wall wall = wn.get();
                    if (wall.getPal() != 1) continue;
                    wall.setPal(0);
                }
            }
            PSSector.KillCreatures();
        }
        Main.engine.changespritestat(nEnergy, 0);
    }

    private static void KillCreatures() {
        for (int statnum = 99; statnum < 108; ++statnum) {
            if (statnum == 100) continue;
            for (ListNode<Sprite> node = Main.boardService.getStatNode(statnum); node != null; node = node.getNext()) {
                Sprites.DamageEnemy(node.getIndex(), -1, 1600);
            }
        }
    }

    static {
        NearSector = new int[Engine.MAXSECTORS];
        LinkMap = new byte[1024][8];
        tmpVec = new Vector2();
    }
}

