/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Anubis;
import ru.m210projects.Powerslave.Enemies.Fish;
import ru.m210projects.Powerslave.Enemies.LavaDude;
import ru.m210projects.Powerslave.Enemies.Lion;
import ru.m210projects.Powerslave.Enemies.Mummy;
import ru.m210projects.Powerslave.Enemies.Queen;
import ru.m210projects.Powerslave.Enemies.Ra;
import ru.m210projects.Powerslave.Enemies.Rat;
import ru.m210projects.Powerslave.Enemies.Rex;
import ru.m210projects.Powerslave.Enemies.Roach;
import ru.m210projects.Powerslave.Enemies.Scorp;
import ru.m210projects.Powerslave.Enemies.Set;
import ru.m210projects.Powerslave.Enemies.Spider;
import ru.m210projects.Powerslave.Enemies.Wasp;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Grenade;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.PSSector;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Slide;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Switch;
import ru.m210projects.Powerslave.Type.Channel;
import ru.m210projects.Powerslave.Type.FuncProc;
import ru.m210projects.Powerslave.Type.RunData;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class RunList {
    public static final int MAXRUN = 25600;
    public static int ChannelList;
    public static int ChannelLast;
    public static final Channel[] channel;
    public static int NewRun;
    public static int RunCount;
    public static int RunChain;
    public static boolean word_966BE;
    public static int nStackCount;
    public static final int[] RunFree;
    public static final RunData[] RunData;
    public static final int[] sRunStack;
    private static final FuncProc[] funclist;

    public static int GrabRun() {
        if (RunCount <= 0 || RunCount > 25600) {
            throw new AssertException("RunCount >0 && RunCount<=MAXRUN");
        }
        return RunFree[--RunCount];
    }

    public static void saveRunList(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeInt(os, RunCount);
        StreamUtils.writeInt(os, NewRun);
        StreamUtils.writeInt(os, RunChain);
        for (i = 0; i < 25600; ++i) {
            StreamUtils.writeShort(os, RunFree[i]);
        }
        for (i = 0; i < 25600; ++i) {
            RunData[i].save(os);
        }
        StreamUtils.writeInt(os, ChannelList);
        StreamUtils.writeInt(os, ChannelLast);
        for (Channel value : channel) {
            value.save(os);
        }
    }

    public static void loadRunList(SafeLoader loader, InputStream is) throws IOException {
        int i;
        loader.RunCount = StreamUtils.readInt(is);
        loader.NewRun = StreamUtils.readInt(is);
        loader.RunChain = StreamUtils.readInt(is);
        for (i = 0; i < 25600; ++i) {
            loader.RunFree[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < 25600; ++i) {
            if (loader.RunData[i] == null) {
                loader.RunData[i] = new RunData();
            }
            loader.RunData[i].load(is);
        }
        loader.ChannelList = StreamUtils.readInt(is);
        loader.ChannelLast = StreamUtils.readInt(is);
        for (i = 0; i < channel.length; ++i) {
            if (loader.channel[i] == null) {
                loader.channel[i] = new Channel();
            }
            loader.channel[i].load(is);
        }
    }

    public static void loadRunList(SafeLoader loader) {
        int i;
        RunCount = loader.RunCount;
        NewRun = loader.NewRun;
        RunChain = loader.RunChain;
        System.arraycopy(loader.RunFree, 0, RunFree, 0, 25600);
        for (i = 0; i < 25600; ++i) {
            if (RunData[i] == null) {
                RunList.RunData[i] = new RunData();
            }
            RunData[i].copy(loader.RunData[i]);
        }
        ChannelList = loader.ChannelList;
        ChannelLast = loader.ChannelLast;
        for (i = 0; i < channel.length; ++i) {
            if (channel[i] == null) {
                RunList.channel[i] = new Channel();
            }
            channel[i].copy(loader.channel[i]);
        }
    }

    public static void FreeRun(int run) {
        if (RunCount < 0 || RunCount >= 25600) {
            throw new AssertException("RunCount >= 0 && RunCount<MAXRUN: " + RunCount);
        }
        if (run < 0 || run >= 25600) {
            throw new AssertException("run>=0 && run<MAXRUN: " + run);
        }
        RunList.RunFree[RunList.RunCount] = run;
        RunData[run].clear();
        ++RunCount;
    }

    public static int HeadRun() {
        int run = RunList.GrabRun();
        RunList.RunData[run].RunPtr = -1;
        RunList.RunData[run].RunNum = -1;
        return run;
    }

    public static void InitRun() {
        int ptr;
        RunCount = 25600;
        nStackCount = 0;
        for (int i = 0; i < 25600; ++i) {
            if (RunData[i] == null) {
                RunList.RunData[i] = new RunData();
            }
            RunList.RunFree[i] = i;
            RunData[i].clear();
        }
        RunChain = ptr = RunList.HeadRun();
        NewRun = ptr;
        for (int i = 0; i < 8; ++i) {
            Globals.PlayerList[i].RunFunc = -1;
        }
        Globals.nRadialSpr = -1;
    }

    public static void UnlinkRun(int RunNum) {
        if (RunCount < 0 || RunCount >= 25600) {
            throw new AssertException("RunNum >= 0 && RunNum<MAXRUN: " + RunCount);
        }
        RunData data = RunData[RunNum];
        if (RunNum == RunChain) {
            RunChain = data.RunPtr;
        } else {
            if (data.RunNum >= 0) {
                RunList.RunData[data.RunNum].RunPtr = data.RunPtr;
            }
            if (data.RunPtr >= 0) {
                RunList.RunData[data.RunPtr].RunNum = data.RunNum;
            }
        }
    }

    public static void InsertRun(int RunLst, int RunNum) {
        if (RunLst < 0 || RunLst >= 25600) {
            throw new AssertException("RunLst >= 0 && RunLst<MAXRUN: " + RunLst);
        }
        if (RunNum < 0 || RunNum >= 25600) {
            throw new AssertException(" RunNum >= 0 && RunNum<MAXRUN: " + RunNum);
        }
        RunData data = RunData[RunNum];
        data.RunNum = RunLst;
        data.RunPtr = RunList.RunData[RunLst].RunPtr;
        if (data.RunPtr >= 0) {
            RunList.RunData[data.RunPtr].RunNum = RunNum;
        }
        RunList.RunData[RunLst].RunPtr = RunNum;
    }

    public static int AddRunRec(int RunLst, int RunEvent2) {
        int RunNum = RunList.GrabRun();
        RunData[RunNum].setEvent(RunEvent2);
        RunList.InsertRun(RunLst, RunNum);
        return RunNum;
    }

    public static void DoSubRunRec(int RunPtr) {
        if (RunPtr < 0 || RunPtr >= 25600) {
            throw new AssertException("RunPtr>=0 && RunPtr<MAXRUN: " + RunPtr);
        }
        RunList.UnlinkRun(RunPtr);
        RunList.FreeRun(RunPtr);
    }

    public static void CleanRunRecs() {
        int NxtPtr = RunChain;
        if (NxtPtr >= 0) {
            if (NxtPtr >= 25600) {
                throw new AssertException("NxtPtr<MAXRUN: " + NxtPtr);
            }
            NxtPtr = RunList.RunData[RunList.RunChain].RunPtr;
        }
        while (true) {
            int RunPtr;
            if ((RunPtr = NxtPtr) < 0) {
                return;
            }
            if (RunPtr >= 25600) break;
            NxtPtr = RunList.RunData[NxtPtr].RunPtr;
            if (RunData[RunPtr].getFunc() >= 0) continue;
            RunList.DoSubRunRec(RunPtr);
        }
        throw new AssertException("RunPtr<MAXRUN");
    }

    public static void SubRunRec(int RunPtr) {
        if (RunPtr < 0 || RunPtr >= 25600) {
            throw new AssertException("RunPtr>=0 && RunPtr<MAXRUN: " + RunPtr);
        }
        RunData[RunPtr].setEvent(-Globals.totalmoves);
    }

    public static void SendMessageToRunRec(int RunPtr, int nStack, int nDamage) {
        int func = RunData[RunPtr].getFunc();
        if (func >= 0 && func <= funclist.length) {
            funclist[func].run(nStack, nDamage, RunPtr);
        }
    }

    public static void ExplodeSignalRun() {
        int NxtPtr = RunChain;
        if (NxtPtr >= 0) {
            if (NxtPtr >= 25600) {
                throw new AssertException("NxtPtr<MAXRUN: " + NxtPtr);
            }
            NxtPtr = RunList.RunData[NxtPtr].RunPtr;
        }
        while (true) {
            int RunPtr;
            if ((RunPtr = NxtPtr) < 0) {
                return;
            }
            if (RunPtr >= 25600) break;
            NxtPtr = RunList.RunData[NxtPtr].RunPtr;
            if (RunData[RunPtr].getObject() < 0) continue;
            RunList.SendMessageToRunRec(RunPtr, 655360, 0);
        }
        throw new AssertException("RunPtr<MAXRUN");
    }

    public static void PushMoveRun(int nStack) {
        if (nStackCount < 200) {
            RunList.sRunStack[RunList.nStackCount] = nStack;
            ++nStackCount;
        }
    }

    public static int PopMoveRun() {
        if (nStackCount <= 0) {
            throw new AssertException(" PopMoveRun() called inappropriately");
        }
        return sRunStack[--nStackCount];
    }

    public static void SignalRun(int RunNum, int nStack) {
        int NxtPtr = RunNum;
        if (NxtPtr == RunChain && word_966BE) {
            RunList.PushMoveRun(nStack);
        } else {
            while (true) {
                int RunPtr;
                word_966BE = true;
                if (NxtPtr >= 0) {
                    if (NxtPtr >= 25600) {
                        throw new AssertException("NxtPtr<MAXRUN");
                    }
                    NxtPtr = RunList.RunData[NxtPtr].RunPtr;
                }
                while ((RunPtr = NxtPtr) >= 0) {
                    if (RunPtr >= 25600) {
                        throw new AssertException("RunPtr<MAXRUN");
                    }
                    NxtPtr = RunList.RunData[NxtPtr].RunPtr;
                    if (RunData[RunPtr].getObject() < 0) continue;
                    RunList.SendMessageToRunRec(RunPtr, nStack, 0);
                }
                word_966BE = false;
                if (nStackCount == 0) break;
                nStack = RunList.PopMoveRun();
                NxtPtr = RunChain;
            }
        }
    }

    public static void InitChan() {
        ChannelList = -1;
        ChannelLast = -1;
        for (int i = 0; i < channel.length; ++i) {
            if (channel[i] == null) {
                RunList.channel[i] = new Channel();
            }
            RunList.channel[i].head = RunList.HeadRun();
            RunList.channel[i].next = -1;
            RunList.channel[i].field_4 = -1;
            RunList.channel[i].field_6 = 0;
        }
    }

    public static void ChangeChannel(int ch, int a2) {
        if (RunList.channel[ch].next < 0) {
            int tmp = ChannelList;
            ChannelList = ch;
            RunList.channel[ch].next = tmp;
        }
        RunList.channel[ch].field_4 = a2;
        RunList.channel[ch].field_6 |= 2;
    }

    public static void ReadyChannel(int ch) {
        if (RunList.channel[ch].next < 0) {
            int tmp = ChannelList;
            ChannelList = ch;
            RunList.channel[ch].next = tmp;
        }
        RunList.channel[ch].field_6 |= 1;
    }

    public static void ProcessChannels() {
        int ch1;
        do {
            int ch2 = -1;
            ch1 = -1;
            while (ChannelList >= 0) {
                Channel v2 = channel[ChannelList];
                int v3 = v2.field_6;
                int next = v2.next;
                if ((v3 & 2) != 0) {
                    v2.field_6 ^= 2;
                    RunList.SignalRun(v2.head, ChannelList | 0x10000);
                }
                if ((v3 & 1) != 0) {
                    v2.field_6 ^= 1;
                    RunList.SignalRun(v2.head, 196608);
                }
                if (v2.field_6 != 0) {
                    if (ch1 == -1) {
                        ch1 = ChannelList;
                    } else {
                        RunList.channel[ch2].next = ChannelList;
                    }
                    ch2 = ChannelList;
                } else {
                    RunList.channel[RunList.ChannelList].next = -1;
                }
                ChannelList = next;
            }
            ChannelList = ch1;
        } while (ch1 != -1);
    }

    public static int FindChannel(int ch) {
        for (int i = 0; i < channel.length; ++i) {
            if (RunList.channel[i].field_4 != -1) continue;
            RunList.channel[i].field_4 = ch;
            return i;
        }
        return -1;
    }

    public static int AllocChannel(int ch) {
        if (ch != 0) {
            for (int i = 0; i < channel.length; ++i) {
                if (RunList.channel[i].field_4 != ch) continue;
                return i;
            }
        }
        return RunList.FindChannel(ch);
    }

    public static void ExecObjects() {
        RunList.ProcessChannels();
        RunList.SignalRun(RunChain, 131072);
    }

    static {
        channel = new Channel[4096];
        RunCount = -1;
        RunFree = new int[25600];
        RunData = new RunData[25600];
        sRunStack = new int[200];
        funclist = new FuncProc[]{Object::FuncElev, Switch::FuncSwReady, Switch::FuncSwPause, Switch::FuncSwStepOn, Switch::FuncSwNotOnPause, Switch::FuncSwPressSector, Switch::FuncSwPressWall, Object::FuncWallFace, Slide::FuncSlide, Anubis::FuncAnubis, Player::FuncPlayer, Bullet::FuncBullet, Spider::FuncSpider, Sprites::FuncCreatureChunk, Mummy::FuncMummy, Grenade::FuncGrenade, Anim::FuncAnim, Snake::FuncSnake, Fish::FuncFish, Lion::FuncLion, Sprites::FuncBubble, LavaDude::FuncLava, LavaDude::FuncLavaLimb, Object::FuncObject, Rex::FuncRex, Set::FuncSet, Queen::FuncQueen, Queen::FuncQueenHead, Roach::FuncRoach, Queen::FuncQueenEgg, Wasp::FuncWasp, Object::FuncTrap, Fish::FuncFishLimb, Ra::FuncRa, Scorp::FuncScorp, Set::FuncSoul, Rat::FuncRat, PSSector::FuncEnergyBlock, Object::FuncSpark};
    }
}

