/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Screens;

import com.badlogic.gdx.Gdx;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.AbstractRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Powerslave.Cinema;
import ru.m210projects.Powerslave.Config;
import ru.m210projects.Powerslave.Energy;
import ru.m210projects.Powerslave.Factory.PSMenuHandler;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.LoadSave;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Menus.MenuInterfaceSet;
import ru.m210projects.Powerslave.Menus.PSMenuUserContent;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.PSSector;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Screens.DemoScreen;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.SpiritHead;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.EpisodeInfo;
import ru.m210projects.Powerslave.Type.Input;
import ru.m210projects.Powerslave.Type.PlayerStruct;
import ru.m210projects.Powerslave.View;
import ru.m210projects.Powerslave.Weapons;

public class GameScreen
extends GameAdapter {
    public int gNameShowTime;
    private final Main game;
    protected final boolean[] gameKeyState;
    private int nonsharedtimer;

    public GameScreen(Main game) {
        super(game, Main.gLoadingScreen);
        this.game = game;
        this.gameKeyState = new boolean[game.pCfg.getKeymap().length + 1];
    }

    public static void DoClockBeep() {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(407); node != null; node = node.getNext()) {
            Sound.PlayFX2(Sound.StaticSound[74], node.getIndex());
        }
    }

    public static void InitClockTile() {
        DynamicArtEntry artEntry = Main.engine.allocatepermanenttile(Main.engine.getTile(3603));
        Arrays.fill(artEntry.getBytes(), (byte)-1);
    }

    public static void DrawClock() {
        int nCount = Globals.lCountDown / 30;
        if (nCount != Globals.nClockVal) {
            ArtEntry dst = Main.engine.getTile(3603);
            if (!(dst instanceof DynamicArtEntry && dst.exists() || (dst = Main.engine.allocatepermanenttile(dst)).hasSize())) {
                return;
            }
            Arrays.fill(dst.getBytes(), (byte)-1);
            Globals.nClockVal = nCount;
            GameScreen.DoClockBeep();
            int x = 49;
            while (nCount != 0) {
                int nNumber = 3606 + (nCount & 0xF);
                ArtEntry pic = Main.engine.getTile(nNumber);
                if (!(pic instanceof DynamicArtEntry && pic.exists() || (pic = Main.engine.allocatepermanenttile(pic)).hasSize())) {
                    return;
                }
                GameScreen.CopyTileToBitmap((DynamicArtEntry)pic, (DynamicArtEntry)dst, x - pic.getWidth() / 2, 32 - pic.getHeight() / 2);
                x -= 15;
                nCount /= 16;
            }
            ((DynamicArtEntry)dst).invalidate();
        }
        Energy.DoEnergyTile();
    }

    private static void DoRedAlert(int a1) {
        if (a1 != 0) {
            Globals.nAlarmTicks = 69;
            Globals.nRedTicks = 30;
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(405); node != null; node = node.getNext()) {
            if (a1 == 0) continue;
            Sprite spr = node.get();
            Sound.PlayFXAtXYZ(Sound.StaticSound[73], spr.getX(), spr.getY(), spr.getZ(), spr.getSectnum());
            Light.AddFlash(spr.getSectnum(), spr.getX(), spr.getY(), spr.getZ(), 192);
        }
    }

    public static void CopyTileToBitmap(DynamicArtEntry src, DynamicArtEntry dst, int cx, int cy) {
        byte[] pSource = src.getBytes();
        byte[] pDest = dst.getBytes();
        int sptr = 0;
        int dptr = dst.getHeight() * cx + cy;
        for (int i = 0; i < src.getWidth(); ++i) {
            for (int j = 0; j < src.getHeight(); ++j) {
                byte col;
                if ((col = pSource[sptr++]) == -1 || dptr + j >= pDest.length) continue;
                pDest[dptr + j] = col;
            }
            dptr += dst.getHeight();
        }
    }

    @Override
    public void show() {
        super.show();
        Main.gDemoScreen.onStopPlaying();
        Sound.sndPlayMusic();
    }

    protected void UpdateInputs(BuildNet net) {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Input src = (Input)net.gFifoInput[net.gNetFifoTail & 0xFF][i];
            Globals.sPlayerInput[i].Copy(src);
            if ((Globals.sPlayerInput[i].bits & 2) != 0) {
                this.game.gPaused = !this.game.gPaused;
                this.sndHandlePause(this.game.gPaused);
            }
            i = Mmulti.connectpoint2[i];
        }
        ++net.gNetFifoTail;
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        Palette.FixPalette();
        this.UpdateInputs(net);
        if (this.game.gPaused || !DemoScreen.isDemoPlaying() && !DemoScreen.isDemoScreen(this) && (this.game.menu.gShowMenu || Console.out.isShowing())) {
            return;
        }
        Sound.UpdateSounds();
        if (Globals.levelnum == 20) {
            --Globals.lCountDown;
            GameScreen.DrawClock();
            if (Globals.nRedTicks != 0 && --Globals.nRedTicks <= 0) {
                GameScreen.DoRedAlert(0);
            }
            --Globals.nButtonColor;
            if (--Globals.nAlarmTicks <= 0) {
                GameScreen.DoRedAlert(1);
            }
            if (Globals.lCountDown <= 0) {
                Cinema.DoFailedFinalScene();
            }
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Globals.PlayerList[i].UpdatePlayerLoc();
            i = Mmulti.connectpoint2[i];
        }
        Light.UndoFlashes();
        Light.DoLights();
        if (Globals.nFreeze != 0) {
            if (Globals.gCurrentEpisode != Globals.gOriginalEpisode) {
                if (Globals.mUserFlag == Main.UserFlag.UserMap) {
                    Gdx.app.postRunnable(() -> {
                        Globals.nPlayerLives[0] = 0;
                        this.game.EndGame();
                    });
                } else {
                    Globals.levelnew = Globals.levelnum + 1;
                }
            } else if (Globals.nFreeze == 1 || Globals.nFreeze == 2) {
                SpiritHead.DoSpiritHead();
                if (Main.cfg.bSubtitles && Globals.nFreeze == 2 && SpiritHead.nHeadStage == 5 && Cinema.nHeight + Cinema.nCrawlY > 0 && Main.engine.getTotalClock() >= Cinema.nextclock) {
                    Cinema.nextclock = Main.engine.getTotalClock() + 14;
                    --Cinema.nCrawlY;
                }
            }
        } else {
            RunList.ExecObjects();
            RunList.CleanRunRecs();
        }
        View.MoveStatus();
        Sprites.DoBubbleMachines();
        Object.DoDrips();
        PSSector.DoMovingSects();
        Object.DoRegenerates();
        if (Globals.followmode) {
            Globals.followx += Globals.followvel * EngineUtils.sin(2560 - (Globals.followa += (int)Globals.followang) & 0x7FF) >> 10;
            Globals.followy += Globals.followvel * EngineUtils.sin(1024 - Globals.followa & 0x7FF) >> 10;
            Globals.followx += Globals.followsvel * EngineUtils.sin(1024 - Globals.followa & 0x7FF) >> 10;
            Globals.followy -= Globals.followsvel * EngineUtils.sin(2560 - Globals.followa & 0x7FF) >> 10;
        }
        if (Globals.levelnum == 20) {
            Object.DoFinale();
            if (Globals.lCountDown < 1800 && Globals.nDronePitch < 2400 && Globals.lFinaleStart == 0) {
                Globals.nDronePitch += 64;
                Sound.BendAmbientSound();
            }
        }
        if (Globals.totalvel[Globals.nLocalPlayer] != 0) {
            Weapons.bobangle += 56;
            Weapons.bobangle &= 0x7FF;
        } else {
            Weapons.bobangle = 0;
        }
        ++Globals.totalmoves;
        --Globals.moveframes;
        Map.checkNextMap();
    }

    @Override
    public void DrawWorld(float smooth) {
        int fz;
        Sector sec;
        if (Globals.PlayerList[Globals.nLocalPlayer].spriteId == -1) {
            return;
        }
        Renderer renderer = this.game.getRenderer();
        Sprite pPlayer = Main.boardService.getSprite(Globals.PlayerList[Globals.nLocalPlayer].spriteId);
        if (pPlayer == null) {
            return;
        }
        PlayerStruct pp = Globals.PlayerList[0];
        int nSector = -1;
        if (Globals.nSnakeCam >= 0) {
            Sprite pSnake = Main.boardService.getSprite(Snake.SnakeList[Globals.nSnakeCam].nSprite[0]);
            if (pSnake != null) {
                Globals.nCamerax = pSnake.getX();
                Globals.nCameray = pSnake.getY();
                Globals.nCameraz = pSnake.getZ();
                Globals.nCameraa = pSnake.getAng();
                Globals.nCamerapan = 92.0f;
                nSector = pSnake.getSectnum();
                Interpolation.ILoc oldLoc = this.game.pInt.getsprinterpolate(Snake.SnakeList[Globals.nSnakeCam].nSprite[0]);
                if (oldLoc != null) {
                    Globals.nCamerax = oldLoc.x + Pragmas.mulscale(Globals.nCamerax - oldLoc.x, (int)smooth, 16);
                    Globals.nCameray = oldLoc.y + Pragmas.mulscale(Globals.nCameray - oldLoc.y, (int)smooth, 16);
                    Globals.nCameraz = oldLoc.z + Pragmas.mulscale(Globals.nCameraz - oldLoc.z, (int)smooth, 16);
                    Globals.nCameraa = oldLoc.ang + Pragmas.mulscale((pSnake.getAng() - oldLoc.ang + 1024 & 0x7FF) - 1024, (int)smooth, 16);
                }
                Main.engine.getPaletteManager().setGreenPal();
            }
        } else {
            Main.engine.getPaletteManager().restoreGreenPal();
            Globals.nCamerax = pPlayer.getX();
            Globals.nCameray = pPlayer.getY();
            Globals.nCameraz = pPlayer.getZ() + pp.eyelevel;
            Globals.nCameraa = pp.ang;
            Globals.nCamerapan = pp.horiz;
            nSector = Globals.nPlayerViewSect[Globals.nLocalPlayer];
        }
        if (nSector != -1 && Globals.initsect != -1) {
            Map.UpdateMap();
        }
        if (Globals.bCamera) {
            if (!this.game.menu.gShowMenu && !Console.out.isShowing() || DemoScreen.isDemoPlaying()) {
                Globals.nCamerax = pp.prevView.x + Pragmas.mulscale(Globals.nCamerax - pp.prevView.x, (int)smooth, 16);
                Globals.nCameray = pp.prevView.y + Pragmas.mulscale(Globals.nCameray - pp.prevView.y, (int)smooth, 16);
                Globals.nCameraz = pp.prevView.z + Pragmas.mulscale(Globals.nCameraz - pp.prevView.z, (int)smooth, 16);
                Globals.nCameraa = pp.prevView.ang + (Gameutils.BClampAngle(Globals.nCameraa + 1024.0f - pp.prevView.ang) - 1024.0f) * smooth / 65536.0f;
            }
            Main.engine.clipmove(Globals.nCamerax, Globals.nCameray, Globals.nCameraz, nSector, (int)(-2000.0 * Gameutils.BCosAngle(Globals.nCameraa)), (int)(-2000.0 * Gameutils.BSinAngle(Globals.nCameraa)), 64, 0, 0, 0x1000040);
            Globals.nCamerapan = 92.0f;
            if (Engine.clipmove_sectnum != -1) {
                Globals.nCamerax = Engine.clipmove_x;
                Globals.nCameray = Engine.clipmove_y;
                Globals.nCameraz = Engine.clipmove_z;
                nSector = Engine.clipmove_sectnum;
            }
        } else if (Globals.nSnakeCam == -1) {
            if (!this.game.menu.gShowMenu && !Console.out.isShowing() || DemoScreen.isDemoPlaying()) {
                Globals.nCamerax = pp.prevView.x + Pragmas.mulscale(Globals.nCamerax - pp.prevView.x, (int)smooth, 16);
                Globals.nCameray = pp.prevView.y + Pragmas.mulscale(Globals.nCameray - pp.prevView.y, (int)smooth, 16);
                Globals.nCameraz = pp.prevView.z + Pragmas.mulscale(Globals.nCameraz - pp.prevView.z, (int)smooth, 16);
                Globals.nCameraa = pp.prevView.ang + (Gameutils.BClampAngle(Globals.nCameraa + 1024.0f - pp.prevView.ang) - 1024.0f) * smooth / 65536.0f;
                Globals.nCamerapan = pp.prevView.horiz + (pp.horiz - pp.prevView.horiz) * smooth / 65536.0f;
            }
            if ((sec = Main.boardService.getSector(pPlayer.getSectnum())) != null && (Globals.nCameraz += Globals.nQuake[Globals.nLocalPlayer]) > sec.getFloorz()) {
                Globals.nCameraz = sec.getFloorz();
            }
            Globals.nCameraa += (float)((Globals.nQuake[Globals.nLocalPlayer] >> 7) % 31);
        }
        if ((sec = Main.boardService.getSector(nSector)) == null) {
            return;
        }
        int cz = sec.getCeilingz() + 2048;
        if (cz > Globals.nCameraz) {
            Globals.nCameraz = cz;
        }
        if ((fz = sec.getFloorz() - 2048) < Globals.nCameraz) {
            Globals.nCameraz = fz;
        }
        Globals.nCamerapan += 8.0f;
        if (Globals.nFreeze != 0 || View.nOverhead != 2) {
            renderer.drawrooms(Globals.nCamerax, Globals.nCameray, Globals.nCameraz, Globals.nCameraa, Globals.nCamerapan, nSector);
            View.analyzesprites((int)smooth);
            renderer.drawmasks();
        }
        if (Globals.nFreeze == 0 && View.nOverhead > 0) {
            if (Globals.followmode) {
                Globals.nCamerax = Globals.followx;
                Globals.nCameray = Globals.followy;
                Globals.nCameraa = Globals.followa;
            }
            if (View.nOverhead == 2) {
                renderer.clearview(96);
                renderer.drawmapview(Globals.nCamerax, Globals.nCameray, View.zoom, (int)Globals.nCameraa);
            }
            renderer.drawoverheadmap(Globals.nCamerax, Globals.nCameray, View.zoom, (short)Globals.nCameraa);
            if (Globals.followmode) {
                this.game.getFont(0).drawTextScaled(renderer, 5, 25, "Follow mode", 1.0f, 0, 0, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, true);
            }
            if (Globals.mUserFlag == Main.UserFlag.UserMap) {
                this.game.getFont(0).drawTextScaled(renderer, 5, 15, "User map: " + Globals.boardfilename, 1.0f, 0, 7, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, true);
            } else if (Globals.levelnum > 0 && Globals.gCurrentEpisode.gMapInfo.get(Globals.levelnum - 1) != null) {
                this.game.getFont(0).drawTextScaled(renderer, 5, 15, Globals.gCurrentEpisode.gMapInfo.get((int)(Globals.levelnum - 1)).title, 1.0f, 0, 7, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, true);
            }
        }
    }

    @Override
    public void DrawHud(float smooth) {
        Renderer renderer = this.game.getRenderer();
        if (this.game.gPaused) {
            this.game.getFont(1).drawTextScaled(renderer, 160, 80, "PAUSE", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
        }
        if (Globals.nFreeze != 0) {
            Globals.nSnakeCam = -1;
            if (Globals.nFreeze == 2) {
                if (SpiritHead.nHeadStage == 4) {
                    int spr = Globals.PlayerList[Globals.nLocalPlayer].spriteId;
                    Sprite pFreeze = Main.boardService.getSprite(spr);
                    if (pFreeze == null) {
                        return;
                    }
                    pFreeze.setCstat(pFreeze.getCstat() | 0x8000);
                    int dang = (int)(Globals.nCameraa - (float)pFreeze.getAng());
                    if (Pragmas.klabs(dang) > 10) {
                        Globals.inita -= dang >> 3;
                        return;
                    }
                    if (Main.cfg.bSubtitles) {
                        if (Globals.levelnum == 1) {
                            Cinema.ReadyCinemaText(1);
                        } else {
                            Cinema.ReadyCinemaText(5);
                        }
                    }
                    SpiritHead.nHeadStage = (short)5;
                } else if (Main.cfg.bSubtitles && !Cinema.AdvanceCinemaText()) {
                    Globals.levelnew = Globals.levelnum + 1;
                }
            }
            return;
        }
        if (Globals.nSnakeCam >= 0) {
            this.game.getFont(0).drawTextScaled(renderer, 160, 5, "S E R P E N T C A M", 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
            return;
        }
        if (View.nOverhead != 2) {
            Weapons.DrawWeapons();
        }
        if (!this.game.menu.gShowMenu || this.game.menu.getCurrentMenu() instanceof MenuInterfaceSet) {
            View.DrawStatus();
            if (this.game.isCurrentScreen(Main.gGameScreen) && Main.engine.getTotalClock() < this.gNameShowTime) {
                Transparent transp = Transparent.None;
                if (Main.engine.getTotalClock() > this.gNameShowTime - 20) {
                    transp = Transparent.Bit1;
                }
                if (Main.engine.getTotalClock() > this.gNameShowTime - 10) {
                    transp = Transparent.Bit2;
                }
                if (Main.cfg.showMapInfo != 0 && !this.game.menu.gShowMenu) {
                    if (Globals.mUserFlag != Main.UserFlag.UserMap && Globals.levelnum > 0) {
                        if (Globals.gCurrentEpisode.gMapInfo.get(Globals.levelnum - 1) != null) {
                            this.game.getFont(1).drawTextScaled(renderer, 160, 100, Globals.gCurrentEpisode.gMapInfo.get((int)(Globals.levelnum - 1)).title, 1.0f, -128, 0, TextAlign.Center, transp, ConvertType.Normal, true);
                        }
                    } else if (Globals.boardfilename != null) {
                        this.game.getFont(1).drawTextScaled(renderer, 160, 100, Globals.boardfilename.getName(), 1.0f, -128, 0, TextAlign.Center, transp, ConvertType.Normal, true);
                    }
                }
            }
            int y = 155;
            if (Main.cfg.nScreenSize == 0) {
                y = 195;
            }
            View.viewDrawStats(5, y, Main.cfg.gStatSize);
        }
    }

    @Override
    public void processInput(GameProcessor processor) {
        if (Globals.nFreeze == 0 && View.nOverhead != 0) {
            int j = Main.engine.getTotalClock() - this.nonsharedtimer;
            this.nonsharedtimer += j;
            if (processor.isGameKeyPressed(GameKeys.Enlarge_Screen)) {
                View.zoom += Pragmas.mulscale(j, Math.max(View.zoom, 256), 6);
            }
            if (processor.isGameKeyPressed(GameKeys.Shrink_Screen)) {
                View.zoom -= Pragmas.mulscale(j, Math.max(View.zoom, 256), 6);
            }
            if (View.zoom > 2048) {
                View.zoom = 2048;
            }
            if (View.zoom < 48) {
                View.zoom = 48;
            }
        }
    }

    @Override
    public void PostFrame(BuildNet net) {
        PSMenuHandler menu = this.game.menu;
        if (LoadSave.gAutosaveRequest) {
            if (LoadSave.gClassicMode) {
                if (LoadSave.nSaveName == null) {
                    if (!menu.isOpened(menu.mMenus[4])) {
                        menu.mOpen(menu.mMenus[4], -1);
                    }
                } else if (this.captBuffer != null) {
                    LoadSave.savegame(this.game.getUserDirectory(), LoadSave.nSaveName, LoadSave.nSaveFile.getName());
                    LoadSave.gAutosaveRequest = false;
                } else {
                    Main.gGameScreen.capture(160, 100);
                }
            } else if (this.captBuffer != null) {
                LoadSave.savegame(this.game.getUserDirectory(), "[autosave]", "autosave.sav");
                LoadSave.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
        if (LoadSave.gQuickSaving) {
            if (this.captBuffer != null) {
                LoadSave.savegame(this.game.getUserDirectory(), "[quicksave_" + LoadSave.quickslot + "]", "quicksav" + LoadSave.quickslot + ".sav");
                LoadSave.quickslot ^= 1;
                LoadSave.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
        if (Palette.nPalDiff != 0) {
            Renderer renderer = this.game.getRenderer();
            AbstractRenderer.DEFAULT_SCREEN_FADE.set(Math.min(63, Palette.rtint) << 2, Math.min(63, Palette.gtint) << 2, Math.min(63, Palette.btint) << 2, Palette.nPalDiff | 0x80);
            renderer.showScreenFade(AbstractRenderer.DEFAULT_SCREEN_FADE);
        }
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (super.gameKeyDown(gameKey)) {
            return true;
        }
        PSMenuHandler menu = this.game.menu;
        if (!DemoScreen.isDemoPlaying() && Globals.nFreeze != 0) {
            if (GameKeys.Menu_Toggle.equals(gameKey) || GameKeys.Open.equals(gameKey)) {
                Globals.levelnew = Globals.levelnum + 1;
            }
            return false;
        }
        if (GameKeys.Menu_Toggle.equals(gameKey)) {
            Sound.StopAllSounds();
            if (DemoScreen.isDemoPlaying()) {
                menu.mOpen(menu.mMenus[0], -1);
            } else {
                menu.mOpen(menu.mMenus[1], -1);
            }
        }
        if (View.nOverhead != 0) {
            if (Config.PsKeys.Map_Follow_Mode.equals(gameKey)) {
                boolean bl = Globals.followmode = !Globals.followmode;
                if (Globals.followmode) {
                    Globals.followx = Globals.initx;
                    Globals.followy = Globals.inity;
                    Globals.followa = Globals.inita;
                }
                View.StatusMessage(500, "Follow mode " + (Globals.followmode ? "ON" : "OFF"), Globals.nLocalPlayer);
            }
        } else {
            if (GameKeys.Enlarge_Screen.equals(gameKey) && Main.cfg.nScreenSize > 0) {
                Main.cfg.nScreenSize = Gameutils.BClipLow(Main.cfg.nScreenSize - 1, 0);
            }
            if (GameKeys.Shrink_Screen.equals(gameKey) && Main.cfg.nScreenSize < 2) {
                Main.cfg.nScreenSize = Gameutils.BClipHigh(Main.cfg.nScreenSize + 1, 2);
            }
        }
        if (GameKeys.Map_Toggle.equals(gameKey)) {
            this.setOverHead(View.nOverhead);
        }
        if (Config.PsKeys.Show_SoundSetup.equals(gameKey)) {
            menu.mOpen(menu.mMenus[6], -1);
        }
        if (Config.PsKeys.Show_Options.equals(gameKey)) {
            menu.mOpen(menu.mMenus[5], -1);
        }
        if (Config.PsKeys.Toggle_messages.equals(gameKey)) {
            boolean bl = Main.cfg.gShowMessages = !Main.cfg.gShowMessages;
            if (Main.cfg.gShowMessages) {
                View.StatusMessage(500, "Messages on", Globals.nLocalPlayer);
            }
        }
        if (!DemoScreen.isDemoPlaying()) {
            if (Config.PsKeys.Show_SaveMenu.equals(gameKey)) {
                if (Mmulti.numplayers > 1 || LoadSave.gClassicMode) {
                    return false;
                }
                if (Globals.PlayerList[Globals.nLocalPlayer].HealthAmount != 0) {
                    Main.gGameScreen.capture(160, 100);
                    menu.mOpen(menu.mMenus[4], -1);
                }
            }
            if (Config.PsKeys.Show_LoadMenu.equals(gameKey)) {
                if (Mmulti.numplayers > 1) {
                    return false;
                }
                menu.mOpen(menu.mMenus[3], -1);
            }
            if (Config.PsKeys.Quicksave.equals(gameKey)) {
                LoadSave.quicksave();
            }
            if (Config.PsKeys.Quickload.equals(gameKey)) {
                LoadSave.quickload();
            }
            if (Config.PsKeys.AutoRun.equals(gameKey)) {
                Main.cfg.gAutoRun = !Main.cfg.gAutoRun;
                View.StatusMessage(500, "Autorun " + (Main.cfg.gAutoRun ? "ON" : "OFF"), Globals.nLocalPlayer);
            }
            if (Config.PsKeys.Third_View.equals(gameKey)) {
                Globals.bCamera = !Globals.bCamera;
                View.StatusMessage(500, "Third person view " + (Globals.bCamera ? "ON" : "OFF"), Globals.nLocalPlayer);
            }
        }
        if (Config.PsKeys.Quit.equals(gameKey)) {
            menu.mOpen(menu.mMenus[8], -1);
        }
        if (Config.PsKeys.Gamma.equals(gameKey)) {
            menu.mOpen(menu.mMenus[7], -1);
        }
        if (Config.PsKeys.Make_Screenshot.equals(gameKey)) {
            this.makeScreenshot();
        }
        return true;
    }

    protected void setOverHead(int mode) {
        switch (mode) {
            case 0: {
                if (Main.cfg.gOverlayMap != 0) {
                    View.nOverhead = 1;
                    break;
                }
                View.nOverhead = 2;
                break;
            }
            case 1: {
                if (Main.cfg.gOverlayMap == 1) {
                    View.nOverhead = 0;
                    break;
                }
                View.nOverhead = 2;
                break;
            }
            default: {
                View.nOverhead = 0;
            }
        }
    }

    protected void makeScreenshot() {
        String name = Globals.mUserFlag == Main.UserFlag.UserMap ? "scr-" + Globals.boardfilename.getName() + "-xxxx.png" : "scr-map" + Globals.levelnum + "-xxxx.png";
        Renderer renderer = this.game.getRenderer();
        String filename = renderer.screencapture(this.game.cache.getGameDirectory(), name);
        if (filename != null) {
            View.StatusMessage(500, filename + " saved", Globals.nLocalPlayer);
        } else {
            View.StatusMessage(500, "Screenshot not saved. Access denied!", Globals.nLocalPlayer);
        }
    }

    @Override
    public void sndHandlePause(boolean pause) {
        Sound.sndHandlePause(pause);
    }

    @Override
    protected boolean prepareboard(Entry entry) {
        if (!Map.LoadLevel(entry, Globals.levelnew)) {
            return false;
        }
        this.gNameShowTime = 500;
        Sound.StopAllSounds();
        Globals.levelnew = -1;
        Globals.lastlevel = Globals.levelnum;
        View.nOverhead = 0;
        this.game.gPaused = false;
        Engine.show2dsector.clear();
        Engine.show2dwall.clear();
        Engine.show2dsprite.clear();
        for (int i = 0; i < Mmulti.numplayers; ++i) {
            Player.SetSavePoint(i, Globals.initx, Globals.inity, Globals.initz, Globals.initsect, Globals.inita);
            Player.RestartPlayer(i);
            Player.InitPlayerKeys(i);
        }
        Main.gDemoScreen.onPrepareboard(this);
        if (!DemoScreen.isDemoPlaying()) {
            Sound.StopMusic();
        }
        View.UpdateScreenSize();
        View.InitStatus();
        this.game.pNet.ResetNetwork();
        this.game.pNet.ResetTimers();
        this.game.pNet.ready2send = false;
        Globals.totalmoves = 0;
        Palette.GrabPalette();
        Globals.moveframes = 0;
        View.RefreshStatus();
        Sound.sndCheckUserMusic(entry);
        return true;
    }

    public void changemap(int num, Runnable prestart) {
        if (num < 1) {
            return;
        }
        Globals.boardfilename = this.game.getCache().getEntry(Globals.gCurrentEpisode.gMapInfo.get((int)(num - 1)).path, true);
        Globals.levelnew = num;
        String name = "Loading " + Globals.gCurrentEpisode.gMapInfo.get((int)(num - 1)).title;
        this.loadboard(Globals.boardfilename, prestart).setTitle(name);
    }

    public void training() {
        this.newgame(Globals.gTrainingEpisode, 1, true);
    }

    public void newgame(java.lang.Object item, int nLevel, boolean classic) {
        Sound.userMusicEntry = null;
        Globals.nBestLevel = nLevel - 1;
        Globals.lastlevel = -1;
        View.zoom = 768;
        LoadSave.lastload = null;
        Globals.bCamera = false;
        this.pNet.ready2send = false;
        this.game.nNetMode = BuildGame.NetMode.Single;
        LoadSave.gClassicMode = classic;
        Main.UserFlag flag = Main.UserFlag.None;
        if (item instanceof EpisodeInfo) {
            EpisodeInfo game = (EpisodeInfo)item;
            if (!game.equals(Globals.gTrainingEpisode) && !game.equals(Globals.gOriginalEpisode)) {
                PSMenuUserContent.checkEpisodeResources(game);
                flag = Main.UserFlag.Addon;
                Console.out.println("Start user episode: " + game.Title);
            } else {
                PSMenuUserContent.resetEpisodeResources(game);
            }
        } else if (item instanceof FileEntry) {
            flag = Main.UserFlag.UserMap;
            Globals.boardfilename = (Entry)item;
            Globals.levelnum = 0;
            Globals.levelnew = 0;
            PSMenuUserContent.resetEpisodeResources(null);
            Console.out.println("Start user map: " + ((FileEntry)item).getName());
        }
        Globals.mUserFlag = flag;
        Globals.PlayerCount = 0;
        for (int i = 0; i < Mmulti.numplayers; ++i) {
            int nPlayer = Player.GrabPlayer();
            if (nPlayer == -1) {
                System.err.println("Can't create local player");
                return;
            }
            Player.InitPlayerInventory(nPlayer);
        }
        if (!LoadSave.gClassicMode) {
            Globals.PlayerList[Globals.nLocalPlayer].HealthAmount = 800;
            if (Globals.nNetPlayerCount != 0) {
                Globals.PlayerList[Globals.nLocalPlayer].HealthAmount = 1600;
            }
        }
        if (Globals.mUserFlag == Main.UserFlag.UserMap) {
            Main.gGameScreen.loadboard(Globals.boardfilename, null).setTitle("Loading " + Globals.boardfilename);
        } else if (Globals.gCurrentEpisode != null) {
            if (Globals.gCurrentEpisode.equals(Globals.gOriginalEpisode)) {
                Main.gMap.showMap(nLevel, nLevel, Globals.nBestLevel);
            } else {
                this.changemap(nLevel, null);
            }
        } else {
            this.game.show();
        }
    }

    public boolean isOriginal() {
        return false;
    }
}

