/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Slide {
    public static int PointCount;
    public static final int[] PointFree;
    public static int SlideCount;
    public static final int[] SlideFree;
    public static final PointStruct[] PointList;
    public static final SlideStruct[] SlideData;
    public static final SlideStruct2[] SlideData2;

    public static void InitPoint() {
        PointCount = 0;
        for (int i = 0; i < 1024; ++i) {
            Slide.PointFree[i] = i;
            if (PointList[i] != null) continue;
            Slide.PointList[i] = new PointStruct();
        }
    }

    public static void saveSlide(OutputStream os) throws IOException {
        Slide.saveData(os);
        Slide.savePoints(os);
    }

    public static void loadSlide(SafeLoader loader, InputStream is) throws IOException {
        Slide.loadData(loader, is);
        Slide.loadPoints(loader, is);
    }

    public static void loadSlide(SafeLoader loader) {
        Slide.loadData(loader);
        Slide.loadPoints(loader);
    }

    private static void saveData(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, SlideCount);
        for (i = SlideCount; i < 128; ++i) {
            SlideData[i].save(os);
            SlideData2[i].save(os);
        }
        for (i = 0; i < 128; ++i) {
            StreamUtils.writeShort(os, SlideFree[i]);
        }
    }

    private static void loadData(SafeLoader loader, InputStream is) throws IOException {
        int i;
        for (i = loader.SlideCount = (int)StreamUtils.readShort(is); i < 128; ++i) {
            if (loader.SlideData[i] == null) {
                loader.SlideData[i] = new SlideStruct();
            }
            loader.SlideData[i].load(is);
            if (loader.SlideData2[i] == null) {
                loader.SlideData2[i] = new SlideStruct2();
            }
            loader.SlideData2[i].load(is);
        }
        for (i = 0; i < 128; ++i) {
            loader.SlideFree[i] = StreamUtils.readShort(is);
        }
    }

    private static void loadData(SafeLoader loader) {
        SlideCount = loader.SlideCount;
        for (int i = loader.SlideCount; i < 128; ++i) {
            if (SlideData[i] == null) {
                Slide.SlideData[i] = new SlideStruct();
            }
            SlideData[i].copy(loader.SlideData[i]);
            if (SlideData2[i] == null) {
                Slide.SlideData2[i] = new SlideStruct2();
            }
            SlideData2[i].copy(loader.SlideData2[i]);
        }
        System.arraycopy(loader.SlideFree, 0, SlideFree, 0, 128);
    }

    private static void savePoints(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, PointCount);
        for (i = 0; i < PointCount; ++i) {
            PointList[i].save(os);
        }
        for (i = 0; i < 1024; ++i) {
            StreamUtils.writeShort(os, PointFree[i]);
        }
    }

    private static void loadPoints(SafeLoader loader, InputStream is) throws IOException {
        int i;
        loader.PointCount = StreamUtils.readShort(is);
        for (i = 0; i < loader.PointCount; ++i) {
            if (loader.PointList[i] == null) {
                loader.PointList[i] = new PointStruct();
            }
            loader.PointList[i].load(is);
        }
        for (i = 0; i < 1024; ++i) {
            loader.PointFree[i] = StreamUtils.readShort(is);
        }
    }

    private static void loadPoints(SafeLoader loader) {
        PointCount = loader.PointCount;
        for (int i = 0; i < loader.PointCount; ++i) {
            if (PointList[i] == null) {
                Slide.PointList[i] = new PointStruct();
            }
            PointList[i].copy(loader.PointList[i]);
        }
        System.arraycopy(loader.PointFree, 0, PointFree, 0, 1024);
    }

    public static int GrabPoint() {
        return PointFree[PointCount++];
    }

    public static void InitSlide() {
        SlideCount = 128;
        for (int i = 0; i < SlideCount; ++i) {
            Slide.SlideFree[i] = i;
            if (SlideData2[i] == null) {
                Slide.SlideData2[i] = new SlideStruct2();
            }
            if (SlideData[i] != null) continue;
            Slide.SlideData[i] = new SlideStruct();
        }
    }

    public static int IdentifySector(int a1) {
        for (int i = 0; i < Main.boardService.getSectorCount(); ++i) {
            Sector sec = Main.boardService.getSector(i);
            if (sec == null) continue;
            for (int j = 0; j < sec.getWallnum(); ++j) {
                if (sec.getWallptr() + j != a1) continue;
                return i;
            }
        }
        return -1;
    }

    public static int BuildSlide(int a1, int a2, int a3, int a4, int a5, int a6, int a7) {
        int v14;
        if (SlideCount <= 0) {
            throw new AssertException("Too many slides!");
        }
        --SlideCount;
        int sect = Slide.IdentifySector(a2);
        Sector sec = Main.boardService.getSector(sect);
        if (sec == null) {
            return -1;
        }
        Slide.SlideData2[Slide.SlideCount].channel = a1;
        Slide.SlideData2[Slide.SlideCount].field_4 = -1;
        Slide.SlideData2[Slide.SlideCount].field_2 = v14 = Slide.GrabPoint();
        Slide.PointList[v14].field_E = -1;
        Slide.PointList[v14].field_0 = sect;
        int startWall = sec.getWallptr();
        int endWall = sec.getWallptr() + sec.getWallnum();
        block0: for (int w = startWall; w < endWall; ++w) {
            Wall pWall = Main.boardService.getWall(w);
            if (pWall == null) continue;
            int i = Slide.SlideData2[Slide.SlideCount].field_2;
            while (i >= 0) {
                if (pWall.getNextsector() == Slide.PointList[i].field_0) break block0;
                i = Slide.PointList[i].field_E;
            }
            if (pWall.getNextsector() < 0) continue;
            int v24 = Slide.GrabPoint();
            Slide.PointList[v24].field_E = Slide.SlideData2[Slide.SlideCount].field_2;
            Slide.PointList[v24].field_0 = pWall.getNextsector();
            Slide.SlideData2[Slide.SlideCount].field_2 = v24;
        }
        Slide.SlideData[Slide.SlideCount].nWall1 = a2;
        Slide.SlideData[Slide.SlideCount].nWall2 = a3;
        Slide.SlideData[Slide.SlideCount].nWall3 = a5;
        Slide.SlideData[Slide.SlideCount].nWall4 = a6;
        Wall w2 = Main.boardService.getWall(a2);
        Wall w3 = Main.boardService.getWall(a3);
        Wall w4 = Main.boardService.getWall(a4);
        Wall w5 = Main.boardService.getWall(a5);
        Wall w6 = Main.boardService.getWall(a6);
        Wall w7 = Main.boardService.getWall(a7);
        if (w2 != null && w3 != null && w4 != null && w5 != null && w6 != null && w7 != null) {
            Slide.SlideData[Slide.SlideCount].x1 = w2.getX();
            Slide.SlideData[Slide.SlideCount].y1 = w2.getY();
            Slide.SlideData[Slide.SlideCount].x2 = w5.getX();
            Slide.SlideData[Slide.SlideCount].y2 = w5.getY();
            Slide.SlideData[Slide.SlideCount].x3 = w3.getX();
            Slide.SlideData[Slide.SlideCount].y3 = w3.getY();
            Slide.SlideData[Slide.SlideCount].x4 = w6.getX();
            Slide.SlideData[Slide.SlideCount].y4 = w6.getY();
            Slide.SlideData[Slide.SlideCount].x5 = w4.getX();
            Slide.SlideData[Slide.SlideCount].y5 = w4.getY();
            Slide.SlideData[Slide.SlideCount].x6 = w7.getX();
            Slide.SlideData[Slide.SlideCount].y6 = w7.getY();
            int spr = Main.engine.insertsprite(sect, 899);
            Sprite pSprite = Main.boardService.getSprite(spr);
            if (pSprite != null) {
                Slide.SlideData2[Slide.SlideCount].field_6 = spr;
                pSprite.setCstat(32768);
                pSprite.setX(w2.getX());
                pSprite.setY(w2.getY());
                pSprite.setZ(sec.getFloorz());
            }
        }
        Slide.SlideData2[Slide.SlideCount].field_8 = 0;
        return 0x80000 | SlideCount;
    }

    public static void FuncSlide(int nStack, int ignored, int RunPtr) {
        int nSlide = RunList.RunData[RunPtr].getObject();
        if (nSlide < 0 || nSlide >= 128) {
            throw new AssertException("slide>=0 && slide<MAXSLIDE");
        }
        int nChannel = RunList.channel[Slide.SlideData2[nSlide].channel].field_4;
        switch (nStack & 0x7F0000) {
            case 131072: {
                int v4 = 0;
                if (nChannel == 1) {
                    int nWall3;
                    Wall pWall3;
                    int nWall1;
                    Wall pWall1;
                    int nWall = Slide.SlideData[nSlide].nWall2;
                    Wall pWall = Main.boardService.getWall(nWall);
                    if (pWall == null) break;
                    int wx = pWall.getX();
                    int wy = pWall.getY();
                    int xvel = Object.LongSeek(wx, Slide.SlideData[nSlide].x5, 20, 20);
                    wx = Object.longSeek_out;
                    int yvel = Object.LongSeek(wy, Slide.SlideData[nSlide].y5, 20, 20);
                    wy = Object.longSeek_out;
                    Main.engine.dragpoint(nWall, wx, wy);
                    Main.engine.movesprite(Slide.SlideData2[nSlide].field_6, xvel << 14, yvel << 14, 0, 0, 0, 1);
                    if (xvel == 0 && yvel == 0) {
                        v4 = 1;
                    }
                    if ((pWall1 = Main.boardService.getWall(nWall1 = Slide.SlideData[nSlide].nWall1)) == null) break;
                    Main.engine.dragpoint(nWall1, xvel + pWall1.getX(), yvel + pWall1.getY());
                    int nWall4 = Slide.SlideData[nSlide].nWall4;
                    Wall pWall4 = Main.boardService.getWall(nWall4);
                    if (pWall4 == null) break;
                    wx = pWall4.getX();
                    wy = pWall4.getY();
                    xvel = Object.LongSeek(wx, Slide.SlideData[nSlide].x6, 20, 20);
                    wx = Object.longSeek_out;
                    yvel = Object.LongSeek(wy, Slide.SlideData[nSlide].y6, 20, 20);
                    wy = Object.longSeek_out;
                    Main.engine.dragpoint(nWall4, wx, wy);
                    if (yvel == 0 && xvel == 0) {
                        ++v4;
                    }
                    if ((pWall3 = Main.boardService.getWall(nWall3 = Slide.SlideData[nSlide].nWall3)) == null) break;
                    Main.engine.dragpoint(nWall3, xvel + pWall3.getX(), yvel + pWall3.getY());
                } else if (nChannel == 0) {
                    int nWall4;
                    Wall pWall4;
                    int nWall2;
                    Wall pWall2;
                    int nWall = Slide.SlideData[nSlide].nWall1;
                    Wall pWall = Main.boardService.getWall(nWall);
                    if (pWall == null) break;
                    int wx = pWall.getX();
                    int wy = pWall.getY();
                    int xvel = Object.LongSeek(wx, Slide.SlideData[nSlide].x1, 20, 20);
                    wx = Object.longSeek_out;
                    int yvel = Object.LongSeek(wy, Slide.SlideData[nSlide].y1, 20, 20);
                    wy = Object.longSeek_out;
                    Main.engine.dragpoint(nWall, wx, wy);
                    if (xvel == 0 && yvel == 0) {
                        v4 = 1;
                    }
                    if ((pWall2 = Main.boardService.getWall(nWall2 = Slide.SlideData[nSlide].nWall2)) == null) break;
                    Main.engine.dragpoint(nWall2, xvel + pWall2.getX(), yvel + pWall2.getY());
                    int nWall3 = Slide.SlideData[nSlide].nWall3;
                    Wall pWall3 = Main.boardService.getWall(nWall3);
                    if (pWall3 == null) break;
                    wx = pWall3.getX();
                    wy = pWall3.getY();
                    xvel = Object.LongSeek(wx, Slide.SlideData[nSlide].x2, 20, 20);
                    wx = Object.longSeek_out;
                    yvel = Object.LongSeek(wy, Slide.SlideData[nSlide].y2, 20, 20);
                    wy = Object.longSeek_out;
                    Main.engine.dragpoint(nWall3, wx, wy);
                    if (yvel == 0 && xvel == 0) {
                        ++v4;
                    }
                    if ((pWall4 = Main.boardService.getWall(nWall4 = Slide.SlideData[nSlide].nWall4)) == null) break;
                    Main.engine.dragpoint(nWall4, xvel + pWall4.getX(), yvel + pWall4.getY());
                }
                if (v4 >= 2) {
                    RunList.SubRunRec(Slide.SlideData2[nSlide].field_4);
                    Slide.SlideData2[nSlide].field_4 = -1;
                    Sound.D3PlayFX(Sound.StaticSound[Map.nStopSound], Slide.SlideData2[nSlide].field_6);
                    RunList.ReadyChannel(Slide.SlideData2[nSlide].channel);
                }
                return;
            }
            case 65536: {
                if (Slide.SlideData2[nSlide].field_4 >= 0) {
                    RunList.SubRunRec(Slide.SlideData2[nSlide].field_4);
                    Slide.SlideData2[nSlide].field_4 = -1;
                }
                if (nChannel != 0 && nChannel != 1) break;
                Slide.SlideData2[nSlide].field_4 = RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].getEvent());
                if (Slide.SlideData2[nSlide].field_8 == nChannel) break;
                Sound.D3PlayFX(Sound.StaticSound[23], Slide.SlideData2[nSlide].field_6);
                Slide.SlideData2[nSlide].field_8 = nChannel;
            }
        }
    }

    static {
        PointFree = new int[1024];
        SlideFree = new int[128];
        PointList = new PointStruct[1024];
        SlideData = new SlideStruct[128];
        SlideData2 = new SlideStruct2[128];
    }

    public static class PointStruct {
        public int field_0;
        public int field_2;
        public int field_4;
        public int field_6;
        public int field_8;
        public int field_A;
        public int field_C;
        public int field_E;

        public void save(OutputStream os) throws IOException {
            StreamUtils.writeShort(os, this.field_0);
            StreamUtils.writeShort(os, this.field_2);
            StreamUtils.writeShort(os, this.field_4);
            StreamUtils.writeShort(os, this.field_6);
            StreamUtils.writeShort(os, this.field_8);
            StreamUtils.writeShort(os, this.field_A);
            StreamUtils.writeShort(os, this.field_C);
            StreamUtils.writeShort(os, this.field_E);
        }

        public void load(InputStream is) throws IOException {
            this.field_0 = StreamUtils.readShort(is);
            this.field_2 = StreamUtils.readShort(is);
            this.field_4 = StreamUtils.readShort(is);
            this.field_6 = StreamUtils.readShort(is);
            this.field_8 = StreamUtils.readShort(is);
            this.field_A = StreamUtils.readShort(is);
            this.field_C = StreamUtils.readShort(is);
            this.field_E = StreamUtils.readShort(is);
        }

        public void copy(PointStruct src) {
            this.field_0 = src.field_0;
            this.field_2 = src.field_2;
            this.field_4 = src.field_4;
            this.field_6 = src.field_6;
            this.field_8 = src.field_8;
            this.field_A = src.field_A;
            this.field_C = src.field_C;
            this.field_E = src.field_E;
        }
    }

    public static class SlideStruct {
        public static final int size = 64;
        public int nWall1;
        public int nWall2;
        public int nWall3;
        public int nWall4;
        public int x1;
        public int y1;
        public int x2;
        public int y2;
        public int x3;
        public int y3;
        public int x4;
        public int y4;
        public int x5;
        public int y5;
        public int x6;
        public int y6;

        public void save(OutputStream os) throws IOException {
            StreamUtils.writeInt(os, this.nWall1);
            StreamUtils.writeInt(os, this.nWall2);
            StreamUtils.writeInt(os, this.nWall3);
            StreamUtils.writeInt(os, this.nWall4);
            StreamUtils.writeInt(os, this.x1);
            StreamUtils.writeInt(os, this.y1);
            StreamUtils.writeInt(os, this.x2);
            StreamUtils.writeInt(os, this.y2);
            StreamUtils.writeInt(os, this.x3);
            StreamUtils.writeInt(os, this.y3);
            StreamUtils.writeInt(os, this.x4);
            StreamUtils.writeInt(os, this.y4);
            StreamUtils.writeInt(os, this.x5);
            StreamUtils.writeInt(os, this.y5);
            StreamUtils.writeInt(os, this.x6);
            StreamUtils.writeInt(os, this.y6);
        }

        public void load(InputStream is) throws IOException {
            this.nWall1 = StreamUtils.readInt(is);
            this.nWall2 = StreamUtils.readInt(is);
            this.nWall3 = StreamUtils.readInt(is);
            this.nWall4 = StreamUtils.readInt(is);
            this.x1 = StreamUtils.readInt(is);
            this.y1 = StreamUtils.readInt(is);
            this.x2 = StreamUtils.readInt(is);
            this.y2 = StreamUtils.readInt(is);
            this.x3 = StreamUtils.readInt(is);
            this.y3 = StreamUtils.readInt(is);
            this.x4 = StreamUtils.readInt(is);
            this.y4 = StreamUtils.readInt(is);
            this.x5 = StreamUtils.readInt(is);
            this.y5 = StreamUtils.readInt(is);
            this.x6 = StreamUtils.readInt(is);
            this.y6 = StreamUtils.readInt(is);
        }

        public void copy(SlideStruct src) {
            this.nWall1 = src.nWall1;
            this.nWall2 = src.nWall2;
            this.nWall3 = src.nWall3;
            this.nWall4 = src.nWall4;
            this.x1 = src.x1;
            this.y1 = src.y1;
            this.x2 = src.x2;
            this.y2 = src.y2;
            this.x3 = src.x3;
            this.y3 = src.y3;
            this.x4 = src.x4;
            this.y4 = src.y4;
            this.x5 = src.x5;
            this.y5 = src.y5;
            this.x6 = src.x6;
            this.y6 = src.y6;
        }
    }

    public static class SlideStruct2 {
        public static final int size = 10;
        public int channel;
        public int field_2;
        public int field_4;
        public int field_6;
        public int field_8;

        public void save(OutputStream os) throws IOException {
            StreamUtils.writeShort(os, this.channel);
            StreamUtils.writeShort(os, this.field_2);
            StreamUtils.writeShort(os, this.field_4);
            StreamUtils.writeShort(os, this.field_6);
            StreamUtils.writeShort(os, this.field_8);
        }

        public void load(InputStream is) throws IOException {
            this.channel = StreamUtils.readShort(is);
            this.field_2 = StreamUtils.readShort(is);
            this.field_4 = StreamUtils.readShort(is);
            this.field_6 = StreamUtils.readShort(is);
            this.field_8 = StreamUtils.readShort(is);
        }

        public void copy(SlideStruct2 src) {
            this.channel = src.channel;
            this.field_2 = src.field_2;
            this.field_4 = src.field_4;
            this.field_6 = src.field_6;
            this.field_8 = src.field_8;
        }
    }
}

