/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Sound;

public class SpiritHead {
    public static int nSpiritSprite;
    public static short nHeadStage;
    public static boolean nTalkTime;
    private static short nSpiritRepeatX;
    private static short nSpiritRepeatY;
    private static short nMouthTile;
    private static short nPixels;
    private static int nHeadTimeStart;
    private static int lHeadStartClock;
    private static int lNextStateChange;
    private static int nPixelsToShow;
    private static int nPupData;
    private static ByteBuffer pPupData;
    private static int word_964E6;
    private static int word_964E8;
    private static int word_964EA;
    private static int word_964EC;
    private static final byte[] pixelval;
    private static final byte[] origx;
    private static final byte[] origy;
    private static final byte[] velx;
    private static final byte[] vely;
    private static final int[] curx;
    private static final int[] cury;
    private static final byte[] destvelx;
    private static final byte[] destvely;

    public static void InitSpiritHead() {
        nPixels = 0;
        Sprite pSpiritSprite = Main.boardService.getSprite(nSpiritSprite);
        if (pSpiritSprite == null) {
            return;
        }
        nSpiritRepeatX = pSpiritSprite.getXrepeat();
        nSpiritRepeatY = pSpiritSprite.getYrepeat();
        ArtEntry art590 = Main.engine.getTile(590);
        ArtEntry art592 = Main.engine.getTile(592);
        if (!art590.hasSize() || !art592.hasSize()) {
            return;
        }
        byte[] data590 = art590.getBytes();
        byte[] data592 = art592.getBytes();
        for (int i = 0; i < Engine.MAXSPRITES; ++i) {
            Sprite sprite = Main.boardService.getSprite(i);
            if (sprite == null || sprite.getStatnum() == 0) continue;
            sprite.setCstat(sprite.getCstat() | 0x8000);
        }
        int ptr = 0;
        int ox = -48;
        for (int x = 0; x < 97; ++x) {
            int oy = -53;
            for (int y = 0; y < 106; ++y) {
                if (data592[ptr] != -1) {
                    SpiritHead.pixelval[SpiritHead.nPixels] = data590[106 * x + y];
                    SpiritHead.origx[SpiritHead.nPixels] = (byte)ox;
                    SpiritHead.origy[SpiritHead.nPixels] = (byte)oy;
                    SpiritHead.curx[SpiritHead.nPixels] = 0;
                    SpiritHead.cury[SpiritHead.nPixels] = 0;
                    SpiritHead.vely[SpiritHead.nPixels] = 0;
                    SpiritHead.velx[SpiritHead.nPixels] = 0;
                    SpiritHead.destvelx[SpiritHead.nPixels] = (byte)(Random.RandomSize(2) + 1);
                    if (velx[nPixels] > 0) {
                        SpiritHead.destvelx[SpiritHead.nPixels] = -destvelx[nPixels];
                    }
                    SpiritHead.destvely[SpiritHead.nPixels] = (byte)(Random.RandomSize(2) + 1);
                    if (vely[nPixels] > 0) {
                        SpiritHead.destvely[SpiritHead.nPixels] = -destvely[nPixels];
                    }
                    nPixels = (short)(nPixels + 1);
                }
                ++ptr;
                ++oy;
            }
            ++ox;
        }
        DynamicArtEntry pic = Main.engine.allocatepermanenttile(591, 194, 212);
        Arrays.fill(pic.getBytes(), (byte)-1);
        pSpiritSprite.setYrepeat(140);
        pSpiritSprite.setXrepeat(140);
        pSpiritSprite.setPicnum(591);
        pSpiritSprite.setCstat(pSpiritSprite.getCstat() & 0xFFFF7FFF);
        nHeadStage = 0;
        nHeadTimeStart = Main.engine.getTotalClock();
        nPixelsToShow = 0;
        if (Globals.levelnum == 1) {
            Sound.playCDtrack(3, false);
        } else {
            Sound.playCDtrack(7, false);
        }
        Sound.StartSwirlies();
        lNextStateChange = Main.engine.getTotalClock();
        lHeadStartClock = Main.engine.getTotalClock();
        if (Globals.levelnum > 0) {
            pPupData = ByteBuffer.wrap(Main.game.cache.getEntry("LEV" + Globals.levelnum + ".PUP", true).getBytes());
            pPupData.order(ByteOrder.LITTLE_ENDIAN);
            nPupData = pPupData.capacity();
        }
        nMouthTile = 0;
        nTalkTime = true;
        Sound.UpdateSounds();
        pic.invalidate();
    }

    public static void DoSpiritHead() {
        Sprite pSpiritSprite;
        Globals.PlayerList[0].horiz += (Globals.nDestVertPan[0] - Globals.PlayerList[0].horiz) / 4.0f;
        ArtEntry picHead = Main.engine.getTile(591);
        if (!(picHead instanceof DynamicArtEntry) || !picHead.exists()) {
            return;
        }
        DynamicArtEntry pic591 = (DynamicArtEntry)Main.engine.getTile(591);
        switch (nHeadStage) {
            case 0: 
            case 1: {
                Arrays.fill(pic591.getBytes(), (byte)-1);
                break;
            }
            case 5: {
                if (lNextStateChange <= Main.engine.getTotalClock()) {
                    if (nPupData != 0) {
                        short clock = pPupData.getShort();
                        if ((nPupData -= 2) > 0) {
                            lNextStateChange = lHeadStartClock + clock - 10;
                            nTalkTime = !nTalkTime;
                        } else {
                            nTalkTime = false;
                            nPupData = 0;
                        }
                    } else if (!Main.cfg.bSubtitles) {
                        Globals.levelnew = Globals.levelnum + 1;
                    }
                }
                if (--word_964E8 <= 0) {
                    word_964EA = 2 * Random.RandomBit();
                    word_964E8 = Random.RandomSize(5) + 4;
                }
                int tilenum = 592;
                if (--word_964EC < 3) {
                    tilenum = 593;
                    if (word_964EC <= 0) {
                        word_964EC = Random.RandomSize(6) + 4;
                    }
                }
                SpiritHead.CopyHeadToWorkTile(word_964EA + tilenum);
                if (nTalkTime) {
                    if (nMouthTile < 2) {
                        nMouthTile = (short)(nMouthTile + 1);
                    }
                } else if (nMouthTile != 0) {
                    nMouthTile = (short)(nMouthTile - 1);
                }
                if (nMouthTile != 0) {
                    int sizx;
                    int srctile = nMouthTile + 598;
                    ArtEntry pic = Main.engine.getTile(srctile);
                    if (!(pic instanceof DynamicArtEntry && pic.exists() || (pic = Main.engine.allocatepermanenttile(pic)).exists())) {
                        return;
                    }
                    int sizy = pic.getHeight();
                    int workptr = 212 * (97 - sizx / 2) + 159 - sizy;
                    int srcptr = 0;
                    for (sizx = pic.getWidth(); sizx > 0; --sizx) {
                        System.arraycopy(pic.getBytes(), srcptr, pic591.getBytes(), workptr, sizy);
                        workptr += 212;
                        srcptr += sizy;
                    }
                }
                pic591.invalidate();
                return;
            }
        }
        nPixelsToShow = 15 * (Main.engine.getTotalClock() - nHeadTimeStart);
        if (nPixelsToShow > nPixels) {
            nPixelsToShow = nPixels;
        }
        if ((pSpiritSprite = Main.boardService.getSprite(nSpiritSprite)) == null) {
            return;
        }
        switch (nHeadStage) {
            case 3: {
                Palette.FixPalette();
                if (Palette.nPalDiff == 0) {
                    Globals.nFreeze = 2;
                    nHeadStage = (short)(nHeadStage + 1);
                }
                return;
            }
            case 0: 
            case 1: 
            case 2: {
                Sound.UpdateSwirlies();
                if (pSpiritSprite.getShade() > -127) {
                    pSpiritSprite.setShade(pSpiritSprite.getShade() - 1);
                }
                if (--word_964E6 < 0) {
                    SpiritHead.DimSector(pSpiritSprite.getSectnum());
                    word_964E6 = 5;
                }
                if (nHeadStage == 0) {
                    if (Main.engine.getTotalClock() - nHeadTimeStart > 480) {
                        nHeadStage = 1;
                        nHeadTimeStart = Main.engine.getTotalClock() + 480;
                    }
                    byte[] data591 = pic591.getBytes();
                    for (int i = 0; i < nPixelsToShow; ++i) {
                        int y;
                        int x;
                        if (destvely[i] >= 0) {
                            int n = i;
                            vely[n] = (byte)(vely[n] + 1);
                            if (vely[n] >= destvely[i]) {
                                SpiritHead.destvely[i] = (byte)(-(Random.RandomSize(2) + 1));
                            }
                        } else {
                            int n = i;
                            vely[n] = (byte)(vely[n] - 1);
                            if (vely[n] <= destvely[i]) {
                                SpiritHead.destvely[i] = (byte)(Random.RandomSize(2) + 1);
                            }
                        }
                        if (destvelx[i] >= 0) {
                            int n = i;
                            velx[n] = (byte)(velx[n] + 1);
                            if (velx[n] >= destvelx[i]) {
                                SpiritHead.destvelx[i] = (byte)(-(Random.RandomSize(2) + 1));
                            }
                        } else {
                            int n = i;
                            velx[n] = (byte)(velx[n] - 1);
                            if (velx[n] <= destvelx[i]) {
                                SpiritHead.destvelx[i] = (byte)(Random.RandomSize(2) + 1);
                            }
                        }
                        if ((x = (curx[i] >> 8) + velx[i]) < 97) {
                            if (x < -96) {
                                x = 0;
                                SpiritHead.velx[i] = 0;
                            }
                        } else {
                            x = 0;
                            SpiritHead.velx[i] = 0;
                        }
                        if ((y = (cury[i] >> 8) + vely[i]) < 106) {
                            if (y < -105) {
                                y = 0;
                                SpiritHead.vely[i] = 0;
                            }
                        } else {
                            y = 0;
                            SpiritHead.vely[i] = 0;
                        }
                        SpiritHead.curx[i] = x << 8;
                        SpiritHead.cury[i] = y << 8;
                        data591[212 * (x + 97) + 106 + y] = pixelval[i++];
                    }
                    pic591.invalidate();
                }
                if (nHeadStage != 1) break;
                if (pSpiritSprite.getXrepeat() > nSpiritRepeatX) {
                    pSpiritSprite.setXrepeat(pSpiritSprite.getXrepeat() - 2);
                    if (pSpiritSprite.getXrepeat() < nSpiritRepeatX) {
                        pSpiritSprite.setXrepeat(nSpiritRepeatX);
                    }
                }
                if (pSpiritSprite.getYrepeat() > nSpiritRepeatY) {
                    pSpiritSprite.setYrepeat(pSpiritSprite.getYrepeat() - 2);
                    if (pSpiritSprite.getYrepeat() < nSpiritRepeatY) {
                        pSpiritSprite.setYrepeat(nSpiritRepeatY);
                    }
                }
                int nCount = 0;
                byte[] data591 = pic591.getBytes();
                for (int i = 0; i < nPixels; ++i) {
                    int dy;
                    int dx;
                    if (origx[i] << 8 == curx[i] || Pragmas.klabs((origx[i] << 8) - curx[i]) >= 8) {
                        dx = (origx[i] << 8) - curx[i] >> 3;
                    } else {
                        dx = 0;
                        SpiritHead.curx[i] = origx[i] << 8;
                    }
                    if (origy[i] << 8 == cury[i] || Pragmas.klabs((origy[i] << 8) - cury[i]) >= 8) {
                        dy = (origy[i] << 8) - cury[i] >> 3;
                    } else {
                        dy = 0;
                        SpiritHead.cury[i] = origy[i] << 8;
                    }
                    if ((dx | dy) != 0) {
                        int n = i;
                        curx[n] = curx[n] + dx;
                        int n2 = i;
                        cury[n2] = cury[n2] + dy;
                        ++nCount;
                    }
                    data591[(SpiritHead.cury[i] >> 8) + 212 * ((SpiritHead.curx[i] >> 8) + 97) + 106] = pixelval[i];
                }
                if (Main.engine.getTotalClock() - lHeadStartClock > 600) {
                    SpiritHead.CopyHeadToWorkTile(590);
                }
                if (nCount < 15 * nPixels / 16) {
                    Sound.SoundBigEntrance();
                    Light.AddGlow(pSpiritSprite.getSectnum(), 20);
                    Light.AddFlash(pSpiritSprite.getSectnum(), pSpiritSprite.getX(), pSpiritSprite.getY(), pSpiritSprite.getZ(), 128);
                    nHeadStage = (short)3;
                    Palette.TintPalette(63, 63, 63);
                    SpiritHead.CopyHeadToWorkTile(592);
                }
                pic591.invalidate();
            }
        }
    }

    private static void CopyHeadToWorkTile(int nTile) {
        ArtEntry src = Main.engine.getTile(nTile);
        if (!(src instanceof DynamicArtEntry && src.exists() || (src = Main.engine.allocatepermanenttile(src)).exists())) {
            return;
        }
        int workptr = 10441;
        int srcptr = 0;
        ArtEntry pic = Main.engine.getTile(591);
        if (!(pic instanceof DynamicArtEntry) || !pic.exists()) {
            return;
        }
        for (int i = 0; i < 97; ++i) {
            System.arraycopy(src.getBytes(), srcptr, pic.getBytes(), workptr, 106);
            workptr += 212;
            srcptr += 106;
        }
    }

    private static void DimSector(int sectnum) {
        Sector pSector = Main.boardService.getSector(sectnum);
        if (pSector == null) {
            return;
        }
        int w = pSector.getWallptr();
        int i = 0;
        while (i < pSector.getWallnum()) {
            Wall wall = Main.boardService.getWall(w);
            if (wall != null && wall.getShade() < 40) {
                wall.setShade(wall.getShade() + 1);
            }
            ++i;
            ++w;
        }
        if (pSector.getFloorshade() < 40) {
            pSector.setFloorshade(pSector.getFloorshade() + 1);
        }
        if (pSector.getCeilingshade() < 40) {
            pSector.setCeilingshade(pSector.getCeilingshade() + 1);
        }
    }

    static {
        pixelval = new byte[10282];
        origx = new byte[10282];
        origy = new byte[10282];
        velx = new byte[10282];
        vely = new byte[10282];
        curx = new int[10282];
        cury = new int[10282];
        destvelx = new byte[10282];
        destvely = new byte[10282];
    }
}

