/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.PSSector;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.Channel;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Type.SwitchStruct;
import ru.m210projects.Powerslave.View;

public class Switch {
    public static final int MAXSWITCH = 1024;
    public static int SwitchCount;
    public static final SwitchStruct[] SwitchData;

    public static void InitSwitch() {
        SwitchCount = 1024;
        for (int i = 0; i < 1024; ++i) {
            if (SwitchData[i] == null) {
                Switch.SwitchData[i] = new SwitchStruct();
            }
            SwitchData[i].clear();
        }
    }

    public static void saveSwitches(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, SwitchCount);
        for (int i = SwitchCount; i < 1024; ++i) {
            SwitchData[i].save(os);
        }
    }

    public static void loadSwitches(SafeLoader loader, InputStream is) throws IOException {
        for (int i = loader.SwitchCount = (int)StreamUtils.readShort(is); i < 1024; ++i) {
            if (loader.SwitchData[i] == null) {
                loader.SwitchData[i] = new SwitchStruct();
            }
            loader.SwitchData[i].load(is);
        }
    }

    public static void loadSwitches(SafeLoader loader) {
        SwitchCount = loader.SwitchCount;
        for (int i = loader.SwitchCount; i < 1024; ++i) {
            if (SwitchData[i] == null) {
                Switch.SwitchData[i] = new SwitchStruct();
            }
            SwitchData[i].copy(loader.SwitchData[i]);
        }
    }

    public static int BuildSwStepOn(int a1, int a2, int a3) {
        if (SwitchCount <= 0 || a2 < 0 || a3 < 0) {
            throw new AssertException("Too many switches!");
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = a1;
        Switch.SwitchData[Switch.SwitchCount].nLink = a2;
        Switch.SwitchData[Switch.SwitchCount].nSector = a3;
        Switch.SwitchData[Switch.SwitchCount].field_C = -1;
        return SwitchCount | 0x30000;
    }

    public static void FuncSwStepOn(int nStack, int ignored, int a3) {
        int sw = RunList.RunData[a3].getObject();
        if (sw < 0 || sw >= 1024) {
            throw new AssertException("sw>=0 && sw<MAXSWITCH");
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        if (pChannel.field_4 == -1) {
            return;
        }
        byte v16 = PSSector.LinkMap[pSwitch.nLink][pChannel.field_4];
        int nSector = pSwitch.nSector;
        Sector sec = Main.boardService.getSector(nSector);
        if (sec == null) {
            return;
        }
        if ((nStack & 0x7F0000) == 65536) {
            if (pSwitch.field_C >= 0) {
                RunList.SubRunRec(pSwitch.field_C);
                pSwitch.field_C = -1;
            }
            if (v16 >= 0) {
                pSwitch.field_C = RunList.AddRunRec(sec.getLotag() - 1, RunList.RunData[a3].getEvent());
            }
        } else if ((nStack & 0x7F0000) == 327680 && v16 != pChannel.field_4) {
            Wall wall = Main.boardService.getWall(sec.getWallptr());
            if (wall != null) {
                Sound.PlayFXAtXYZ(Sound.StaticSound[Map.nSwitchSound], wall.getX(), wall.getY(), sec.getFloorz(), nSector);
            }
            RunList.ChangeChannel(pSwitch.nChannel, PSSector.LinkMap[pSwitch.nLink][pChannel.field_4]);
        }
    }

    public static int BuildSwReady(int a1, int a2) {
        if (SwitchCount <= 0 || a2 < 0) {
            throw new AssertException("Too many switch readys!");
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = a1;
        Switch.SwitchData[Switch.SwitchCount].nLink = a2;
        return 0x10000 | SwitchCount;
    }

    public static void FuncSwReady(int nStack, int ignored, int a3) {
        int sw = RunList.RunData[a3].getObject();
        if (sw < 0 || sw >= 1024) {
            throw new AssertException("sw>=0 && sw<MAXSWITCH");
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        if ((nStack & 0x7F0000) == 196608 && PSSector.LinkMap[pSwitch.nLink][pChannel.field_4] >= 0) {
            RunList.ChangeChannel(pSwitch.nChannel, PSSector.LinkMap[pSwitch.nLink][pChannel.field_4]);
        }
    }

    public static int BuildSwNotOnPause(int nChannel, int nLink, int nSector, int nPause) {
        if (SwitchCount <= 0 || nLink < 0 || nSector < 0) {
            throw new AssertException("Too many switches!");
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = nChannel;
        Switch.SwitchData[Switch.SwitchCount].nLink = nLink;
        Switch.SwitchData[Switch.SwitchCount].nPause = nPause;
        Switch.SwitchData[Switch.SwitchCount].nSector = nSector;
        Switch.SwitchData[Switch.SwitchCount].field_8 = -1;
        Switch.SwitchData[Switch.SwitchCount].field_C = -1;
        return SwitchCount | 0x40000;
    }

    public static void FuncSwNotOnPause(int nStack, int ignored, int RunPtr) {
        int sw = RunList.RunData[RunPtr].getObject();
        if (sw < 0 || sw >= 1024) {
            throw new AssertException("sw>=0 && sw<MAXSWITCH");
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        switch (nStack & 0x7F0000) {
            case 65536: {
                if (pSwitch.field_C >= 0) {
                    RunList.SubRunRec(pSwitch.field_C);
                    pSwitch.field_C = -1;
                }
                if (pSwitch.field_8 < 0) break;
                RunList.SubRunRec(pSwitch.field_8);
                pSwitch.field_8 = -1;
                break;
            }
            case 131072: {
                pSwitch.field_0 -= 4;
                if (pSwitch.field_0 > 0) break;
                RunList.ChangeChannel(pSwitch.nChannel, PSSector.LinkMap[pSwitch.nLink][pChannel.field_4]);
                break;
            }
            case 196608: {
                if (PSSector.LinkMap[pSwitch.nLink][pChannel.field_4] < 0 || pSwitch.field_8 != -1) break;
                pSwitch.field_8 = RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].getEvent());
                pSwitch.field_0 = pSwitch.nPause;
                Sector sec = Main.boardService.getSector(pSwitch.nSector);
                if (sec == null) break;
                pSwitch.field_C = RunList.AddRunRec(sec.getLotag() - 1, RunList.RunData[RunPtr].getEvent());
                break;
            }
            case 327680: {
                pSwitch.field_0 = pSwitch.nPause;
            }
        }
    }

    public static int BuildSwPause(int a1, int a2, int a3) {
        for (int i = 1023; i >= SwitchCount; --i) {
            if (a1 != Switch.SwitchData[i].nChannel || Switch.SwitchData[i].nPause == 0) continue;
            return i | 0x20000;
        }
        if (SwitchCount <= 0 || a2 < 0) {
            throw new AssertException("Too many switches!");
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = a1;
        Switch.SwitchData[Switch.SwitchCount].nLink = a2;
        Switch.SwitchData[Switch.SwitchCount].nPause = a3;
        Switch.SwitchData[Switch.SwitchCount].field_8 = -1;
        return SwitchCount | 0x20000;
    }

    public static void FuncSwPause(int nStack, int ignored, int a3) {
        int sw = RunList.RunData[a3].getObject();
        if (sw < 0 || sw >= 1024) {
            throw new AssertException("sw>=0 && sw<MAXSWITCH");
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        switch (nStack & 0x7F0000) {
            case 65536: {
                if (pSwitch.field_8 < 0) break;
                RunList.SubRunRec(pSwitch.field_8);
                pSwitch.field_8 = -1;
                break;
            }
            case 131072: {
                if (--pSwitch.field_0 > 0) break;
                RunList.SubRunRec(pSwitch.field_8);
                pSwitch.field_8 = -1;
                RunList.ChangeChannel(pSwitch.nChannel, PSSector.LinkMap[pSwitch.nLink][pChannel.field_4]);
                break;
            }
            case 196608: {
                if (PSSector.LinkMap[pSwitch.nLink][pChannel.field_4] < 0 || pSwitch.field_8 >= 0) break;
                pSwitch.field_8 = RunList.AddRunRec(RunList.NewRun, RunList.RunData[a3].getEvent());
                int nPause = pSwitch.nPause;
                if (nPause <= 0) {
                    nPause = 100;
                }
                pSwitch.field_0 = nPause;
            }
        }
    }

    public static int BuildSwPressSector(int a1, int a2, int a3, int a4) {
        if (SwitchCount <= 0 || a2 < 0 || a3 < 0) {
            throw new AssertException("Too many switches!");
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = a1;
        Switch.SwitchData[Switch.SwitchCount].nLink = a2;
        Switch.SwitchData[Switch.SwitchCount].nSector = a3;
        Switch.SwitchData[Switch.SwitchCount].field_12 = a4;
        Switch.SwitchData[Switch.SwitchCount].field_C = -1;
        return SwitchCount | 0x50000;
    }

    public static void FuncSwPressSector(int nStack, int ignored, int a3) {
        Sector sec;
        int sw = RunList.RunData[a3].getObject();
        if (sw < 0 || sw >= 1024) {
            throw new AssertException("sw>=0 && sw<MAXSWITCH");
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        short plr = (short)(nStack & 0xFFFF);
        if ((nStack & 0x7F0000) == 262144) {
            if ((pSwitch.field_12 & Globals.PlayerList[plr].KeysBitMask) == pSwitch.field_12) {
                RunList.ChangeChannel(pSwitch.nChannel, PSSector.LinkMap[pSwitch.nLink][pChannel.field_4]);
                return;
            }
            if (pSwitch.field_12 != 0) {
                Sprite spr = Main.boardService.getSprite(Globals.PlayerList[plr].spriteId);
                if (spr != null) {
                    Sound.PlayFXAtXYZ(Sound.StaticSound[Map.nSwitchSound], spr.getX(), spr.getY(), 0, spr.getSectnum());
                }
                View.StatusMessage(300, "YOU NEED THE KEY FOR THIS DOOR", plr);
            }
            return;
        }
        if (pSwitch.field_C >= 0) {
            RunList.SubRunRec(pSwitch.field_C);
            pSwitch.field_C = -1;
        }
        if (PSSector.LinkMap[pSwitch.nLink][pChannel.field_4] >= 0 && (sec = Main.boardService.getSector(pSwitch.nSector)) != null) {
            pSwitch.field_C = RunList.AddRunRec(sec.getLotag() - 1, RunList.RunData[a3].getEvent());
        }
    }

    public static int BuildSwPressWall(int a1, int a2, int a3) {
        if (SwitchCount <= 0 || a2 < 0 || a3 < 0) {
            throw new AssertException("Too many switches!");
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = a1;
        Switch.SwitchData[Switch.SwitchCount].nLink = a2;
        Switch.SwitchData[Switch.SwitchCount].nWall = a3;
        Switch.SwitchData[Switch.SwitchCount].field_10 = -1;
        return SwitchCount | 0x60000;
    }

    public static void FuncSwPressWall(int nStack, int ignored, int a3) {
        int sw = RunList.RunData[a3].getObject();
        if (sw < 0 || sw >= 1024) {
            throw new AssertException("sw>=0 && sw<MAXSWITCH");
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        if (pChannel.field_4 == -1) {
            return;
        }
        Wall wall = Main.boardService.getWall(pSwitch.nWall);
        byte pLinkMap = PSSector.LinkMap[pSwitch.nLink][pChannel.field_4];
        if ((nStack & 0x7F0000) == 196608) {
            if (pSwitch.field_10 >= 0) {
                RunList.SubRunRec(pSwitch.field_10);
                pSwitch.field_10 = -1;
            }
            if (pLinkMap >= 0 && wall != null) {
                pSwitch.field_10 = RunList.AddRunRec(wall.getLotag() - 1, RunList.RunData[a3].getEvent());
            }
        } else if ((nStack & 0x7F0000) == 262144 && wall != null) {
            RunList.ChangeChannel(pSwitch.nChannel, pLinkMap);
            if (pLinkMap < 0 || PSSector.LinkMap[pSwitch.nLink][pLinkMap] < 0) {
                RunList.SubRunRec(pSwitch.field_10);
                pSwitch.field_10 = -1;
            }
            Sound.PlayFXAtXYZ(Sound.StaticSound[Map.nSwitchSound], wall.getX(), wall.getY(), 0, pSwitch.nSector);
        }
    }

    static {
        SwitchData = new SwitchStruct[1024];
    }
}

