/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Type.PLocation;

public class PlayerStruct {
    public final PLocation prevView = new PLocation();
    public int nPlayer;
    public int HealthAmount;
    public int animCount;
    public int anim_;
    public int spriteId;
    public int mummified;
    public int network;
    public int invisibility;
    public int AirAmount;
    public int seq;
    public int AirMaskAmount;
    public int KeysBitMask;
    public int MagicAmount;
    public final byte[] ItemsAmount = new byte[8];
    public final int[] AmmosAmount = new int[9];
    public int currentWeapon;
    public int seqOffset;
    public int weaponFire;
    public int newWeapon;
    public int weaponState;
    public int lastWeapon;
    public int RunFunc;
    public int turnAround;
    public int lastUsedWeapon;
    public float ang;
    public float horiz;
    public int eyelevel;
    public boolean crouch_toggle;

    public static int size(boolean isGDX) {
        if (isGDX) {
            return 79;
        }
        return 64;
    }

    public Sprite getSprite() {
        return Main.boardService.getSprite(this.spriteId);
    }

    public void UpdatePlayerLoc() {
        Sprite psp = Main.boardService.getSprite(this.spriteId);
        if (psp == null) {
            return;
        }
        Interpolation.ILoc oldLoc = Main.game.pInt.getsprinterpolate(this.spriteId);
        if (oldLoc != null) {
            oldLoc.x = psp.getX();
            oldLoc.y = psp.getY();
            oldLoc.z = psp.getZ();
        } else {
            Main.game.pInt.setsprinterpolate(this.spriteId, psp);
        }
        Main.game.pInt.setsprinterpolate(Globals.nDoppleSprite[this.nPlayer], Main.boardService.getSprite(Globals.nDoppleSprite[this.nPlayer]));
        this.prevView.x = psp.getX();
        this.prevView.y = psp.getY();
        this.prevView.z = psp.getZ() + this.eyelevel;
        this.prevView.ang = this.ang;
        this.prevView.horiz = this.horiz;
    }

    public void writeObject(OutputStream os, boolean isGDX) throws IOException {
        StreamUtils.writeShort(os, this.HealthAmount);
        StreamUtils.writeShort(os, this.animCount);
        StreamUtils.writeShort(os, this.anim_);
        StreamUtils.writeShort(os, this.spriteId);
        StreamUtils.writeShort(os, this.mummified);
        StreamUtils.writeShort(os, this.network);
        StreamUtils.writeShort(os, this.invisibility);
        StreamUtils.writeShort(os, this.AirAmount);
        StreamUtils.writeShort(os, this.seq);
        StreamUtils.writeShort(os, this.AirMaskAmount);
        StreamUtils.writeShort(os, this.KeysBitMask);
        StreamUtils.writeShort(os, this.MagicAmount);
        StreamUtils.writeBytes(os, this.ItemsAmount);
        for (int i = 0; i < 9; ++i) {
            StreamUtils.writeShort(os, this.AmmosAmount[i]);
        }
        StreamUtils.writeShort(os, this.currentWeapon);
        StreamUtils.writeShort(os, this.seqOffset);
        StreamUtils.writeShort(os, this.weaponFire);
        StreamUtils.writeShort(os, this.newWeapon);
        StreamUtils.writeShort(os, this.weaponState);
        StreamUtils.writeShort(os, this.lastWeapon);
        StreamUtils.writeShort(os, this.RunFunc);
        if (isGDX) {
            StreamUtils.writeShort(os, this.turnAround);
            StreamUtils.writeShort(os, this.lastUsedWeapon);
            StreamUtils.writeFloat(os, this.ang);
            StreamUtils.writeFloat(os, this.horiz);
            StreamUtils.writeShort(os, this.eyelevel);
            StreamUtils.writeByte(os, this.crouch_toggle ? 1 : 0);
        }
    }

    public void readObject(InputStream is, boolean isGDX) throws IOException {
        this.HealthAmount = StreamUtils.readShort(is);
        this.animCount = StreamUtils.readShort(is);
        this.anim_ = StreamUtils.readShort(is);
        this.spriteId = StreamUtils.readShort(is);
        this.mummified = StreamUtils.readShort(is);
        this.network = StreamUtils.readShort(is);
        this.invisibility = StreamUtils.readShort(is);
        this.AirAmount = StreamUtils.readShort(is);
        this.seq = StreamUtils.readShort(is);
        this.AirMaskAmount = StreamUtils.readShort(is);
        this.KeysBitMask = StreamUtils.readShort(is);
        this.MagicAmount = StreamUtils.readShort(is);
        StreamUtils.readBytes(is, this.ItemsAmount);
        for (int i = 0; i < 9; ++i) {
            this.AmmosAmount[i] = StreamUtils.readShort(is);
        }
        this.currentWeapon = StreamUtils.readShort(is);
        this.seqOffset = StreamUtils.readShort(is);
        this.weaponFire = StreamUtils.readShort(is);
        this.newWeapon = StreamUtils.readShort(is);
        this.weaponState = StreamUtils.readShort(is);
        this.lastWeapon = StreamUtils.readShort(is);
        this.RunFunc = StreamUtils.readShort(is);
        if (isGDX) {
            this.turnAround = StreamUtils.readShort(is);
            this.lastUsedWeapon = StreamUtils.readShort(is);
            this.ang = StreamUtils.readFloat(is);
            this.horiz = StreamUtils.readFloat(is);
            this.eyelevel = StreamUtils.readShort(is);
            this.crouch_toggle = StreamUtils.readBoolean(is);
        }
    }

    public void reset() {
        this.HealthAmount = 0;
        this.animCount = 0;
        this.anim_ = 0;
        this.spriteId = 0;
        this.mummified = 0;
        this.network = 0;
        this.invisibility = 0;
        this.AirAmount = 0;
        this.seq = 0;
        this.AirMaskAmount = 0;
        this.KeysBitMask = 0;
        this.MagicAmount = 0;
        Arrays.fill(this.ItemsAmount, (byte)0);
        Arrays.fill(this.AmmosAmount, 0);
        this.currentWeapon = 0;
        this.seqOffset = 0;
        this.weaponFire = 0;
        this.newWeapon = 0;
        this.weaponState = 0;
        this.lastWeapon = 0;
        this.RunFunc = 0;
        this.turnAround = 0;
        this.lastUsedWeapon = 0;
        this.ang = 0.0f;
        this.horiz = 92.0f;
        this.eyelevel = -14080;
        this.crouch_toggle = false;
    }

    public void copy(PlayerStruct src) {
        this.HealthAmount = src.HealthAmount;
        this.animCount = src.animCount;
        this.anim_ = src.anim_;
        this.spriteId = src.spriteId;
        this.mummified = src.mummified;
        this.network = src.network;
        this.invisibility = src.invisibility;
        this.AirAmount = src.AirAmount;
        this.seq = src.seq;
        this.AirMaskAmount = src.AirMaskAmount;
        this.KeysBitMask = src.KeysBitMask;
        this.MagicAmount = src.MagicAmount;
        System.arraycopy(src.ItemsAmount, 0, this.ItemsAmount, 0, this.ItemsAmount.length);
        System.arraycopy(src.AmmosAmount, 0, this.AmmosAmount, 0, this.AmmosAmount.length);
        this.currentWeapon = src.currentWeapon;
        this.seqOffset = src.seqOffset;
        this.weaponFire = src.weaponFire;
        this.newWeapon = src.newWeapon;
        this.weaponState = src.weaponState;
        this.lastWeapon = src.lastWeapon;
        this.RunFunc = src.RunFunc;
        this.turnAround = src.turnAround;
        this.lastUsedWeapon = src.lastUsedWeapon;
        this.ang = src.ang;
        this.horiz = src.horiz;
        this.eyelevel = src.eyelevel;
        this.crouch_toggle = src.crouch_toggle;
    }
}

