/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.OsdFunc;
import ru.m210projects.Redneck.Factory.RREngine;
import ru.m210projects.Redneck.Factory.RRMenuHandler;
import ru.m210projects.Redneck.Factory.RRNetwork;
import ru.m210projects.Redneck.Factory.RROsdFunc;
import ru.m210projects.Redneck.Factory.RRPolygdx;
import ru.m210projects.Redneck.Factory.RRPolymost;
import ru.m210projects.Redneck.Factory.RRRenderer;
import ru.m210projects.Redneck.Factory.RRSliderDrawable;
import ru.m210projects.Redneck.Factory.RRSoftware;
import ru.m210projects.Redneck.Fonts.ConsoleFont;
import ru.m210projects.Redneck.Fonts.GameFont;
import ru.m210projects.Redneck.Fonts.MenuFont;
import ru.m210projects.Redneck.Fonts.MiniFont;
import ru.m210projects.Redneck.Main;

public class RRFactory
extends BuildFactory {
    private final Main app;

    public RRFactory(Main app) {
        super("redneck.grp");
        this.app = app;
        OsdColor.DEFAULT.setPal(100);
    }

    @Override
    public void drawInitScreen() {
        RRRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, 2542, 0, 0, 10);
    }

    @Override
    public Engine engine() throws Exception {
        Main.engine = new RREngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new RRSoftware(this.app.pCfg);
        }
        if (type == Renderer.RenderType.PolyGDX) {
            return new RRPolygdx(this.app.pCfg);
        }
        return new RRPolymost(this.app.pCfg);
    }

    @Override
    public DefScript getBaseDef(Engine engine) {
        return new DefScript(engine);
    }

    @Override
    public OsdFunc getOsdFunc() {
        return new RROsdFunc();
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = new RRMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(5){

            @Override
            protected Font init(int i) {
                switch (i) {
                    case 0: {
                        return new MiniFont(((RRFactory)RRFactory.this).app.pEngine);
                    }
                    case 1: {
                        return new GameFont(((RRFactory)RRFactory.this).app.pEngine);
                    }
                    case 2: {
                        return new MenuFont(((RRFactory)RRFactory.this).app.pEngine);
                    }
                    case 3: {
                        return new ConsoleFont(((RRFactory)RRFactory.this).app.pEngine);
                    }
                }
                return EngineUtils.getLargeFont();
            }
        };
    }

    @Override
    public BuildNet net() {
        return new RRNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new RRSliderDrawable();
    }
}

