/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Main;

public class RRMapSettings
implements IOverheadMapSettings {
    @Override
    public boolean isShowSprites(IOverheadMapSettings.MapView view) {
        return view != IOverheadMapSettings.MapView.Polygons;
    }

    @Override
    public boolean isShowFloorSprites() {
        return false;
    }

    @Override
    public boolean isShowRedWalls() {
        return true;
    }

    @Override
    public boolean isShowAllPlayers() {
        return Globals.ud.coop == 1;
    }

    @Override
    public boolean isSpriteVisible(IOverheadMapSettings.MapView view, int index) {
        if (view == IOverheadMapSettings.MapView.Polygons) {
            return true;
        }
        Sprite spr = Main.boardService.getSprite(index);
        if (spr == null || spr.getCstat() == 257 || Globals.ps[Globals.screenpeek].i == index) {
            return false;
        }
        return (spr.getCstat() & 0x101) != 0;
    }

    @Override
    public boolean isWallVisible(int w, int s) {
        Wall wal = Main.boardService.getWall(w);
        if (wal != null) {
            Sector sec = Main.boardService.getSector(s);
            Sector nextsec = Main.boardService.getSector(wal.getNextsector());
            if (nextsec != null && sec != null) {
                Wall nextwal = Main.boardService.getWall(wal.getNextwall());
                return (nextsec.getCeilingz() != sec.getCeilingz() || nextsec.getFloorz() != sec.getFloorz() || nextwal != null && ((wal.getCstat() | nextwal.getCstat()) & 0x30) != 0) && !this.isFullMap() && !Engine.show2dsector.getBit(wal.getNextsector());
            }
        }
        return true;
    }

    @Override
    public int getWallColor(int w, int s) {
        Wall wal = Main.boardService.getWall(w);
        if (wal == null) {
            return 0;
        }
        Sector nextsec = Main.boardService.getSector(wal.getNextsector());
        if (nextsec != null) {
            int col = !Engine.show2dsector.getBit(wal.getNextsector()) ? 24 : -1;
            return col;
        }
        return 24;
    }

    @Override
    public int getSpriteColor(int s) {
        Sprite spr = Main.boardService.getSprite(s);
        if (spr == null) {
            return 0;
        }
        int col = 71;
        if ((spr.getCstat() & 1) != 0) {
            col = 234;
        }
        return col;
    }

    @Override
    public int getPlayerSprite(int player) {
        if (Globals.ud.scrollmode && player == Globals.screenpeek) {
            return -1;
        }
        return Globals.ps[player].i;
    }

    @Override
    public int getPlayerZoom(int player, int czoom) {
        int j = Pragmas.klabs(Globals.ps[player].truefz - Globals.ps[player].posz) >> 8;
        Sprite psp = Main.boardService.getSprite(Globals.ps[player].i);
        if (psp == null) {
            return j;
        }
        j = czoom * (psp.getYrepeat() + j);
        if (j < 22000) {
            j = 22000;
        } else if (j > 131072) {
            j = 131072;
        }
        return j;
    }

    @Override
    public int getPlayerPicnum(int p) {
        if (Globals.ps[p].OnMotorcycle) {
            return 7169;
        }
        if (Globals.ps[p].OnBoat) {
            return 7191;
        }
        if (Globals.ps[p].getPlayerSprite().getXvel() > 16 && Globals.ps[p].on_ground) {
            return 3840 + (Main.engine.getTotalClock() >> 4 & 3);
        }
        return 3840;
    }

    @Override
    public boolean isFullMap() {
        return false;
    }

    @Override
    public boolean isScrollMode() {
        return Globals.ud.scrollmode;
    }

    @Override
    public int getViewPlayer() {
        return Globals.screenpeek;
    }

    @Override
    public int getWallX(int w) {
        Wall wal = Main.boardService.getWall(w);
        if (wal != null) {
            return wal.getX();
        }
        return 0;
    }

    @Override
    public int getWallY(int w) {
        Wall wal = Main.boardService.getWall(w);
        if (wal != null) {
            return wal.getY();
        }
        return 0;
    }

    @Override
    public int getSpriteX(int spr) {
        Sprite sp = Main.boardService.getSprite(spr);
        if (sp != null) {
            return sp.getX();
        }
        return 0;
    }

    @Override
    public int getSpriteY(int spr) {
        Sprite sp = Main.boardService.getSprite(spr);
        if (sp != null) {
            return sp.getY();
        }
        return 0;
    }

    @Override
    public int getSpritePicnum(int spr) {
        Sprite sp = Main.boardService.getSprite(spr);
        if (sp != null) {
            return sp.getPicnum();
        }
        return 0;
    }
}

