/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Menus;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Redneck.Factory.RRMenuHandler;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Menus.RRTitle;
import ru.m210projects.Redneck.Menus.RUserContent;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.GameInfo;
import ru.m210projects.Redneck.filehandle.EpisodeEntry;

public class NetworkMenu
extends BuildMenu {
    private final Main app;
    private int mGameType = 1;
    private int mEpisodeId = 0;
    private int mLevelId = 0;
    private int mDifficulty = 2;
    private int mMonsters = 0;
    private int mFFire = 0;
    private int mMarkers = 1;
    private String mContent = "";
    private Object currentFile;
    private final int[] netEpisodeInfo = new int[3];
    private final MenuProc mLevelsUpdate;
    private final MenuConteiner mMenuLevel;
    private final MenuConteiner mMenuEpisode;
    private final MenuConteiner mMenuDifficulty;

    public NetworkMenu(final Main app) {
        super(app.pMenu);
        this.app = app;
        final RRMenuHandler menu = app.menu;
        this.addItem(new RRTitle("NETWORK GAME"), false);
        MenuConteiner pItem = new MenuConteiner(this, "Content", app.getFont(2), 20, 45, 280, new String[]{""}, 0, null){
            final /* synthetic */ NetworkMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                switch (opt) {
                    case ENTER: 
                    case LMB: {
                        RUserContent usercont = (RUserContent)menu.mMenus[16];
                        if (!usercont.showmain) {
                            usercont.setShowMain(true);
                        }
                        Sounds.StopAllSounds();
                        handler.mOpen(usercont, -1);
                        return false;
                    }
                }
                return this.m_pMenu.mNavigation(opt);
            }

            @Override
            public void open() {
                if (!app.isCurrentScreen(Main.gGameScreen)) {
                    this.this$0.setEpisode(Globals.defGame);
                }
            }

            @Override
            public void draw(MenuHandler handler) {
                this.list[0] = this.this$0.mContent.toCharArray();
                super.draw(handler);
            }
        };
        pItem.listFont = app.getFont(1);
        MenuConteiner mMenuGame = new MenuConteiner("GAME TYPE", app.getFont(1), 20, 70, 280, null, 0, (handler, pItem18) -> {
            MenuConteiner item = (MenuConteiner)pItem18;
            this.mGameType = item.num;
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[3][];
                    this.list[0] = "DUKEMATCH (SPAWN)".toCharArray();
                    this.list[1] = "COOPERATIVE PLAY".toCharArray();
                    this.list[2] = "DUKEMATCH (NO SPAWN)".toCharArray();
                }
                this.num = NetworkMenu.this.mGameType;
            }
        };
        this.mLevelsUpdate = (handler, pItem17) -> {
            MenuConteiner item = (MenuConteiner)pItem17;
            if (this.currentFile instanceof GameInfo) {
                GameInfo mGameInfo = (GameInfo)this.currentFile;
                int size = mGameInfo.episodes[this.netEpisodeInfo[this.mEpisodeId]].nMaps;
                if (item.list == null || item.list.length != size) {
                    item.list = new char[size][];
                }
                for (int i = 0; i < size; ++i) {
                    item.list[i] = mGameInfo.episodes[this.netEpisodeInfo[this.mEpisodeId]].getMapTitle(i).toCharArray();
                }
            } else {
                item.list = new char[1][];
                item.list[0] = "None".toCharArray();
            }
            item.num = 0;
            this.mLevelId = 0;
        };
        this.mMenuLevel = new MenuConteiner("LEVEL", app.getFont(1), 20, 90, 280, null, 0, (handler, pItem16) -> {
            MenuConteiner item = (MenuConteiner)pItem16;
            this.mLevelId = item.num;
        }){

            @Override
            public void open() {
                this.num = NetworkMenu.this.mLevelId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(NetworkMenu.this.currentFile instanceof GameInfo);
                this.text = ("LEVEL " + (NetworkMenu.this.mLevelId + 1)).toCharArray();
                super.draw(handler);
            }
        };
        this.mMenuEpisode = new MenuConteiner("EPISODE", app.getFont(1), 20, 80, 280, null, 0, (handler, pItem15) -> {
            MenuConteiner item = (MenuConteiner)pItem15;
            this.mEpisodeId = item.num;
            this.mLevelsUpdate.run(menu, this.mMenuLevel);
        }){

            @Override
            public void open() {
                this.num = NetworkMenu.this.mEpisodeId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(NetworkMenu.this.currentFile instanceof GameInfo);
                this.text = ("EPISODE " + (NetworkMenu.this.mEpisodeId + 1)).toCharArray();
                super.draw(handler);
            }
        };
        int pos = 90;
        this.mMenuDifficulty = new MenuConteiner("MONSTERS", app.getFont(1), 20, pos += 12, 280, null, 0, (handler, pItem14) -> {
            MenuConteiner item = (MenuConteiner)pItem14;
            this.mMonsters = item.num == 0 ? 1 : 0;
            this.mDifficulty = item.num - 1;
        }){

            @Override
            public void open() {
                this.num = NetworkMenu.this.mDifficulty + 1;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(NetworkMenu.this.currentFile instanceof GameInfo);
                super.draw(handler);
            }
        };
        MenuSwitch mMenuMarkers = new MenuSwitch("MARKERS", app.getFont(1), 20, pos += 12, 280, this.mMarkers == 1, (handler, pItem13) -> {
            MenuSwitch sw = (MenuSwitch)pItem13;
            this.mMarkers = sw.value ? 1 : 0;
        }, "Yes", "No");
        MenuSwitch mMenuFFire = new MenuSwitch("FRIENDLY FIRE", app.getFont(1), 20, pos += 12, 280, this.mFFire == 1, (handler, pItem12) -> {
            MenuSwitch sw = (MenuSwitch)pItem12;
            this.mFFire = sw.value ? 1 : 0;
        }, "Yes", "No"){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(NetworkMenu.this.mGameType == 1);
                super.draw(handler);
            }
        };
        MenuButton mStart = this.getMenuButton(app, pos);
        this.addItem(pItem, true);
        this.addItem(mMenuGame, false);
        this.addItem(this.mMenuEpisode, false);
        this.addItem(this.mMenuLevel, false);
        this.addItem(this.mMenuDifficulty, false);
        this.addItem(mMenuMarkers, false);
        this.addItem(mMenuFFire, false);
        this.addItem(mStart, false);
    }

    @NotNull
    private MenuButton getMenuButton(Main app, int pos) {
        MenuProc mNetStart = (handler, pItem1) -> {
            Globals.pNetInfo.nGameType = this.mGameType;
            Globals.pNetInfo.nEpisode = this.currentFile instanceof Entry ? this.mEpisodeId : this.netEpisodeInfo[this.mEpisodeId];
            Globals.pNetInfo.nLevel = this.mLevelId;
            Globals.pNetInfo.nDifficulty = this.mDifficulty;
            Globals.pNetInfo.nMonsters = this.mMonsters;
            Globals.pNetInfo.nRespawnMonsters = 0;
            Globals.pNetInfo.nRespawnInventory = 0;
            Globals.pNetInfo.nRespawnItem = 0;
            Globals.pNetInfo.nMarkers = this.mMarkers;
            Globals.pNetInfo.nFriendlyFire = this.mFFire;
            System.err.println("nNetType " + Globals.pNetInfo.nGameType);
            System.err.println("nNetDifficulty " + Globals.pNetInfo.nDifficulty);
            System.err.println("nNetMonsters " + Globals.pNetInfo.nMonsters);
            System.err.println("nNetMarkers " + Globals.pNetInfo.nMarkers);
            System.err.println("nNetFFire " + Globals.pNetInfo.nFriendlyFire);
            if (Mmulti.numplayers >= 2) {
                byte[] packbuf = app.net.packbuf;
                packbuf[0] = -4;
                int ptr = 1;
                LittleEndian.putInt(packbuf, ptr, Mmulti.myconnectindex);
                LittleEndian.putInt(packbuf, ptr += 4, app.net.nNetVersion);
                System.arraycopy(Globals.pNetInfo.getBytes(), 0, packbuf, ptr += 4, Globals.pNetInfo.sizeof);
                ptr += Globals.pNetInfo.sizeof;
                short i = Mmulti.connecthead;
                while (i >= 0) {
                    if (i != Mmulti.myconnectindex) {
                        Mmulti.sendpacket(i, packbuf, ptr);
                    }
                    if (Mmulti.myconnectindex != Mmulti.connecthead) break;
                    i = Mmulti.connectpoint2[i];
                }
            }
            if (app.net.WaitForAllPlayers(0)) {
                Main.gGameScreen.newgame(true, this.currentFile, this.netEpisodeInfo[this.mEpisodeId], this.mLevelId, this.mDifficulty);
            }
        };
        return new MenuButton("START GAME", app.getFont(2), 20, pos + 15, 280, 1, 0, null, -1, mNetStart, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(Mmulti.myconnectindex == Mmulti.connecthead && NetworkMenu.this.currentFile != null);
                super.draw(handler);
            }
        };
    }

    private void updateUserEpisodeList(GameInfo gInfo) {
        int i;
        Arrays.fill(this.netEpisodeInfo, -1);
        int nEpisodes = 0;
        for (i = 0; i < 3; ++i) {
            if (gInfo.episodes[i] == null || gInfo.episodes[i].nMaps == 0) continue;
            this.netEpisodeInfo[nEpisodes++] = i;
        }
        if (this.mMenuEpisode.list == null || this.mMenuEpisode.list.length != nEpisodes) {
            this.mMenuEpisode.list = new char[nEpisodes][];
        }
        for (i = 0; i < nEpisodes; ++i) {
            this.mMenuEpisode.list[i] = gInfo.episodes[this.netEpisodeInfo[i]].Title.toCharArray();
        }
        if (this.mMenuDifficulty.list == null) {
            this.mMenuDifficulty.list = new char[5][];
        }
        this.mMenuDifficulty.list[0] = "NONE".toCharArray();
        for (i = 0; i < 4; ++i) {
            this.mMenuDifficulty.list[1 + i] = gInfo.skillnames[i].toCharArray();
        }
    }

    public Object getFile() {
        return this.currentFile;
    }

    public void setEpisode(GameInfo ini) {
        if (ini == null || this.currentFile == ini) {
            return;
        }
        Console.out.println("Send episode " + ini.getEpisodeEntry().getFileEntry().getRelativePath());
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(this.getEpisodeContentData(ini.getEpisodeEntry()), 0)) {
            String msg = this.getString("  is missing content: ", ini.title);
            Console.out.println(msg, OsdColor.RED);
            if (!Console.out.isShowing()) {
                Console.out.onToggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = ini;
        this.mContent = ini.title;
        this.mEpisodeId = 0;
        this.mMenuEpisode.num = 0;
        this.updateUserEpisodeList(ini);
        this.mLevelsUpdate.run(this.app.pMenu, this.mMenuLevel);
    }

    private String getString(String x, String ini) {
        StringBuilder msg = new StringBuilder();
        short i = Mmulti.connecthead;
        while (i >= 0) {
            if (this.app.net.gContentFound[i] != 1) {
                if (this.app.net.gContentFound[i] == 2) {
                    msg.append(Globals.ud.user_name[i]).append("(wrong checksum)").append(", ");
                } else {
                    msg.append(Globals.ud.user_name[i]).append(", ");
                }
            }
            i = Mmulti.connectpoint2[i];
        }
        msg = new StringBuilder(msg.substring(0, msg.length() - 2));
        msg.append(x).append(ini);
        return msg.toString();
    }

    public void setMap(FileEntry map) {
        if (map == null || this.currentFile == map) {
            return;
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(this.getUserMapContentData(map), 0)) {
            String msg = this.getString(" haven't content: ", map.getName());
            Console.out.println(msg, OsdColor.RED);
            if (!Console.out.isShowing()) {
                Console.out.onToggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = map;
        this.mContent = map.getName();
        if (this.mMenuEpisode.list != null) {
            this.mMenuEpisode.list[0] = "None".toCharArray();
        }
        this.mMenuEpisode.num = 0;
        this.mEpisodeId = 0;
        if (this.mMenuLevel.list != null) {
            this.mMenuLevel.list[0] = "Usermap".toCharArray();
        }
        this.mMenuLevel.num = 0;
        this.mLevelId = 0;
        if (this.mMenuDifficulty.list == null) {
            this.mMenuDifficulty.list = new char[5][];
        }
        this.mMenuDifficulty.list[0] = "NONE".toCharArray();
        for (int i = 0; i < 4; ++i) {
            this.mMenuDifficulty.list[1 + i] = Globals.defGame.skillnames[i].toCharArray();
        }
    }

    private byte[] getEpisodeContentData(EpisodeEntry episodeEntry) {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            StreamUtils.writeBoolean(os, true);
            StreamUtils.writeDataString(os, episodeEntry.getFileEntry().getRelativePath().toString());
            StreamUtils.writeLong(os, Mmulti.numplayers > 1 ? episodeEntry.getFileEntry().getChecksum() : 0L);
            boolean isPacked = episodeEntry.isPackageEpisode();
            StreamUtils.writeBoolean(os, isPacked);
            if (isPacked) {
                StreamUtils.writeDataString(os, episodeEntry.getConFile().getName());
            }
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
                return new byte[0];
            }
        }
        os.close();
        return byArray;
    }

    private byte[] getUserMapContentData(FileEntry entry) {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            StreamUtils.writeBoolean(os, false);
            StreamUtils.writeDataString(os, entry.getRelativePath().toString());
            StreamUtils.writeLong(os, Mmulti.numplayers > 1 ? entry.getChecksum() : 0L);
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
                return new byte[0];
            }
        }
        os.close();
        return byArray;
    }
}

