/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck;

import java.util.List;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.grp.GrpFile;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Redneck.Actors;
import ru.m210projects.Redneck.Fonts.GameFont;
import ru.m210projects.Redneck.Fonts.MenuFont;
import ru.m210projects.Redneck.Gamedef;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Types.EpisodeManager;
import ru.m210projects.Redneck.Types.GameInfo;
import ru.m210projects.Redneck.Types.Script;
import ru.m210projects.Redneck.filehandle.EpisodeEntry;
import ru.m210projects.Redneck.filehandle.UserEntry;

public class ResourceHandler {
    public static final EpisodeManager episodeManager = new EpisodeManager();
    public static boolean usecustomarts;
    private static GrpFile usergroup;

    public static void resetEpisodeResources() {
        Console.out.println("Resetting custom resources", OsdColor.GREEN);
        if (usergroup != null) {
            Main.game.getCache().removeGroup(usergroup);
        }
        usergroup = null;
        Globals.currentGame = Globals.defGame;
        for (int i = 0; i < 500; ++i) {
            Globals.Sound[i].ptr = null;
            Globals.Sound[i].setGlobalSound((Globals.currentGame.getCON().soundm[i] & 0x10) != 0);
        }
        if (!usecustomarts) {
            Main.game.setDefs(Main.game.baseDef);
            return;
        }
        System.err.println("Reset to default resources");
        if (Main.engine.loadpics() == 0) {
            throw new AssertException("ART files not found " + Main.game.getCache().getGameDirectory().getPath().resolve(Main.engine.getTileManager().getTilesPath()));
        }
        if (!Main.game.setDefs(Main.game.baseDef)) {
            Main.game.baseDef.apply();
            ((GameFont)Main.game.getFont(1)).update();
            ((MenuFont)Main.game.getFont(2)).update();
        }
        ResourceHandler.InitSpecialTextures();
        Actors.BowlReset();
        usecustomarts = false;
    }

    public static void InitSpecialTextures() {
        Main.engine.allocatepermanenttile(1089, 0, 0);
        Main.engine.allocatepermanenttile(13, 0, 0);
        Main.engine.allocatepermanenttile(0, 0, 0);
    }

    private static void InitGroupResources(List<Entry> list) {
        for (Entry res : list) {
            if (!res.isExtension("art")) continue;
            Main.engine.loadpic(res);
            usecustomarts = true;
        }
    }

    private static void searchEpisodeResources(Group container, GrpFile resourceHolder) {
        for (Entry file : container.getEntries()) {
            Group subContainer = Directory.DUMMY_DIRECTORY;
            if (file.isDirectory() && file instanceof FileEntry) {
                subContainer = ((FileEntry)file).getDirectory();
            } else if (file.isExtension("pk3") || file.isExtension("zip") || file.isExtension("grp") || file.isExtension("rff")) {
                subContainer = Main.game.getCache().newGroup(file);
            }
            if (!((Object)subContainer).equals(Directory.DUMMY_DIRECTORY)) {
                ResourceHandler.searchEpisodeResources(subContainer, resourceHolder);
                continue;
            }
            resourceHolder.addEntry(new UserEntry(file));
        }
    }

    public static void checkEpisodeResources(GameInfo addon) {
        DefScript addonScript;
        if (addon == null) {
            return;
        }
        if (addon.equals(Globals.currentGame)) {
            return;
        }
        ResourceHandler.resetEpisodeResources();
        usergroup = new GrpFile("RemovableGroup");
        EpisodeEntry addonEntry = addon.getEpisodeEntry();
        Group parent = addonEntry.getGroup();
        if (addonEntry.isPackageEpisode()) {
            addonScript = new DefScript(Main.game.baseDef, addonEntry.getFileEntry());
            try {
                Entry res = parent.getEntry("rrgdx.def");
                if (res.exists()) {
                    addonScript.loadScript(parent.getName() + " script", res);
                }
                ResourceHandler.searchEpisodeResources(parent, usergroup);
            }
            catch (Exception e) {
                throw new AssertException("Error found in " + ((EpisodeEntry.Pack)addonEntry).getName() + "\r\n" + e);
            }
        } else {
            addonScript = new DefScript(Main.game.baseDef, addonEntry.getFileEntry());
            if (!Main.game.getCache().isGameDirectory(parent)) {
                ResourceHandler.searchEpisodeResources(parent, usergroup);
                Entry def = parent.getEntry("rrgdx.def");
                if (def.exists()) {
                    addonScript.loadScript(def);
                }
            }
        }
        if (addon.title.equals("Route 66")) {
            Main.engine.loadpic(parent.getEntry("TILESA66.ART"));
            Main.engine.loadpic(parent.getEntry("TILESB66.ART"));
            usecustomarts = true;
        }
        Gamedef.error = 0;
        Main.game.getCache().addGroup(usergroup, CacheResourceMap.CachePriority.HIGHEST);
        ResourceHandler.InitGroupResources(usergroup.getEntries());
        if (addon.getCON() == null) {
            Script script = Gamedef.loaduserdef(addonEntry.getConFile());
            addon.setCON(script);
        }
        if (Gamedef.error == 0) {
            Globals.currentGame = addon;
            for (int i = 0; i < 500; ++i) {
                Globals.Sound[i].setGlobalSound((Globals.currentGame.getCON().soundm[i] & 0x10) != 0);
            }
        } else {
            throw new WarningException("\nErrors found in " + addonEntry.getConFile().getName() + " file.");
        }
        Main.game.setDefs(addonScript);
    }

    public static GameInfo levelGetEpisode(Entry entry) {
        List<EpisodeEntry> list;
        if (entry == null || !entry.exists()) {
            return null;
        }
        if (entry instanceof FileEntry && !(list = episodeManager.getEpisodeEntries((FileEntry)entry)).isEmpty()) {
            if (entry.isDirectory() || entry.isExtension("grp")) {
                return episodeManager.getEpisode(list.get(0));
            }
            for (EpisodeEntry episodeEntry : list) {
                if (!episodeEntry.getConFile().equals(entry)) continue;
                return episodeManager.getEpisode(episodeEntry);
            }
        }
        return null;
    }
}

