/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Screens;

import com.badlogic.gdx.Screen;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.LoadSave;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Player;
import ru.m210projects.Redneck.ResourceHandler;
import ru.m210projects.Redneck.Screens.GameScreen;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.GameInfo;
import ru.m210projects.Redneck.Types.PlayerStruct;
import ru.m210projects.Redneck.View;
import ru.m210projects.Redneck.filehandle.DemoFile;
import ru.m210projects.Redneck.filehandle.DemoRecorder;

public class DemoScreen
extends GameScreen {
    public int nDemonum = -1;
    public final Map<Group, List<Entry>> demofiles = new HashMap<Group, List<Entry>>();
    public DemoFile demfile;
    protected final Entry lastDemoEntry = Directory.DUMMY_ENTRY;

    public DemoScreen(Main game) {
        super(game);
    }

    @Override
    public void show() {
        LoadSave.lastload = null;
    }

    @Override
    public void hide() {
        Globals.ud.user_name[Mmulti.myconnectindex] = Main.cfg.getpName();
    }

    public boolean showDemo(Entry entry, Entry ini) {
        this.onStopRecord();
        this.demfile = null;
        try (InputStream is = entry.getInputStream();){
            this.demfile = new DemoFile(is);
        }
        catch (Exception e) {
            Console.out.println("Can't play the demo file: " + entry.getName(), OsdColor.RED);
            return false;
        }
        Player.InitPlayers();
        boolean bl = Globals.mFakeMultiplayer = this.demfile.multimode > 1;
        if (Globals.mFakeMultiplayer) {
            Globals.nFakePlayers = this.demfile.multimode;
        }
        if (Mmulti.numplayers > 1) {
            Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
        }
        Globals.ud.volume_number = this.demfile.volume_number;
        Globals.ud.level_number = this.demfile.level_number;
        Globals.ud.player_skill = this.demfile.player_skill;
        Globals.ud.coop = this.demfile.coop;
        Globals.ud.ffire = this.demfile.ffire;
        Globals.ud.multimode = this.demfile.multimode;
        Globals.ud.monsters_off = this.demfile.monsters_off;
        Globals.ud.respawn_monsters = this.demfile.respawn_monsters;
        Globals.ud.respawn_items = this.demfile.respawn_items;
        Globals.ud.respawn_inventory = this.demfile.respawn_inventory;
        Globals.ud.playerai = this.demfile.playerai;
        System.arraycopy(this.demfile.user_name, 0, Globals.ud.user_name, 0, 16);
        Globals.boardfilename = Main.game.getCache().getEntry(this.demfile.boardfilename, true);
        for (int i = 0; i < Globals.ud.multimode; ++i) {
            Globals.ps[i].aim_mode = this.demfile.aim_mode[i];
            Globals.ps[i].auto_aim = this.demfile.version >= 147 ? this.demfile.auto_aim[i] : 1;
        }
        Globals.ud.god = false;
        Globals.ud.showallmap = 0;
        Globals.ud.eog = 0;
        Globals.ud.cashman = 0;
        Globals.ud.scrollmode = false;
        Globals.ud.clipping = false;
        Globals.ud.overhead_on = 0;
        Globals.ud.recstat = 2;
        GameInfo addon = ResourceHandler.levelGetEpisode(ini);
        if (this.demfile.addon != null) {
            addon = this.demfile.addon;
        }
        Main.gDemoScreen.newgame(Globals.mFakeMultiplayer, addon, Globals.ud.volume_number, Globals.ud.level_number, Globals.ud.player_skill);
        Console.out.println("Playing demo " + entry.getName());
        return true;
    }

    public List<Entry> checkDemoEntry(Group group) {
        if (this.demofiles.containsKey(group)) {
            return this.demofiles.get(group);
        }
        this.nDemonum = -1;
        List<Entry> demos = group.stream().filter(this::isDemoFile).sorted(Entry::compareTo).collect(Collectors.toList());
        if (demos.isEmpty()) {
            int k;
            int which_demo = 1;
            do {
                k = which_demo;
                char[] d = "demo_.dmo".toCharArray();
                d[4] = which_demo == 10 ? 120 : (char)(48 + which_demo);
                String name = String.copyValueOf(d);
                Entry entry = Main.game.getCache().getEntry(name, true);
                if (!this.isDemoFile(entry)) break;
                demos.add(entry);
            } while (k != ++which_demo);
        }
        this.demofiles.put(group, demos);
        Console.out.println("There are " + demos.size() + " demo(s) in the loop", OsdColor.YELLOW);
        if (Main.cfg.gDemoSeq == 2) {
            int nextnum = this.nDemonum;
            if (demos.size() > 1) {
                while (nextnum == this.nDemonum) {
                    nextnum = (int)(Math.random() * (double)demos.size());
                }
            }
            this.nDemonum = nextnum;
        }
        return demos;
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.game.doPrecache(() -> {
            startboard.run();
            this.pNet.ResetTimers();
            Globals.lockclock = 0;
            this.pNet.ready2send = false;
        });
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (this.gameKeyDownCommon(gameKey, false)) {
            return true;
        }
        if (GameKeys.Enlarge_Screen.equals(gameKey)) {
            if (Globals.ud.screen_size > 0) {
                Sounds.sound(158);
                this.enlargeScreen();
            }
            return true;
        }
        if (GameKeys.Shrink_Screen.equals(gameKey)) {
            if (Globals.ud.screen_size < 3) {
                Sounds.sound(158);
                this.shrinkScreen();
            }
            return true;
        }
        return true;
    }

    @Override
    public void render(float delta) {
        if (Mmulti.numplayers > 1) {
            this.pNet.GetPackets();
        }
        this.DemoRender();
        float smoothratio = 65536.0f;
        if (!Main.game.gPaused && ((smoothratio = (float)this.pEngine.getTimer().getsmoothratio(delta)) < 0.0f || smoothratio > 65536.0f)) {
            smoothratio = Gameutils.BClipRange(smoothratio, 0.0f, 65536.0f);
        }
        Main.game.pInt.dointerpolations(smoothratio);
        this.DrawWorld(smoothratio);
        this.DrawHud(smoothratio);
        Main.game.pInt.restoreinterpolations();
        View.operatefta();
        if (Globals.ud.last_camsprite != Globals.ud.camerasprite) {
            Globals.ud.last_camsprite = Globals.ud.camerasprite;
        }
        if (this.pMenu.gShowMenu) {
            this.pMenu.mDrawMenu();
        }
        this.PostFrame(this.pNet);
        this.pEngine.nextpage(delta);
    }

    private void DemoRender() {
        this.pNet.ready2send = false;
        if (!Main.game.isCurrentScreen(this)) {
            return;
        }
        if (!Main.game.gPaused && this.demfile != null) {
            while (Main.engine.getTotalClock() >= Globals.lockclock + 4) {
                short j = Mmulti.connecthead;
                while (j >= 0) {
                    this.pNet.gFifoInput[this.pNet.gNetFifoHead[j] & 0xFF][j].Copy(this.demfile.recsync[this.demfile.rcnt][j]);
                    short s = j;
                    this.pNet.gNetFifoHead[s] = this.pNet.gNetFifoHead[s] + 1;
                    --this.demfile.reccnt;
                    j = Mmulti.connectpoint2[j];
                }
                if (this.demfile.reccnt <= 0) {
                    this.demfile = null;
                    Group group = this.lastDemoEntry.getParent();
                    if (!this.showDemo(group)) {
                        Main.game.changeScreen(Main.gMenuScreen);
                    }
                    return;
                }
                ++this.demfile.rcnt;
                Main.game.pInt.clearinterpolations();
                this.ProcessFrame(this.pNet);
            }
        } else {
            Globals.lockclock = Main.engine.getTotalClock();
        }
    }

    public boolean showDemo(Group group) {
        List<Entry> list = this.checkDemoEntry(group);
        switch (Main.cfg.gDemoSeq) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.nDemonum < list.size() - 1) {
                    ++this.nDemonum;
                    break;
                }
                this.nDemonum = 0;
                break;
            }
            case 2: {
                int nextnum = this.nDemonum;
                if (list.size() > 1) {
                    while (nextnum == this.nDemonum) {
                        nextnum = (int)(Math.random() * (double)list.size());
                    }
                }
                this.nDemonum = Gameutils.BClipRange(nextnum, 0, list.size() - 1);
            }
        }
        if (!list.isEmpty()) {
            boolean result = this.showDemo(list.get(this.nDemonum), null);
            if (!result) {
                list.remove(this.nDemonum);
                return this.showDemo(group);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean IsOriginalGame() {
        return this.demfile.version <= 108;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDemoFile(Entry file) {
        if (!file.exists()) return false;
        if (!file.isExtension("dmo")) return false;
        try (InputStream is = file.getInputStream();){
            StreamUtils.skip(is, 4);
            int version = StreamUtils.readUnsignedByte(is);
            if (version != 108) {
                if (version != 147) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isRecordEnabled() {
        return Globals.ud.m_recstat == 1;
    }

    public void onPrepareboard(GameScreen screen) {
        if (screen != this && DemoScreen.isDemoPlaying()) {
            Main.gDemoScreen.onStopPlaying();
        }
        if (DemoScreen.isDemoPlaying() && this.demfile != null && this.demfile.version >= 147) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                PlayerStruct p = Globals.ps[i];
                this.demfile.playerInfos[i].restore(p);
                i = Mmulti.connectpoint2[i];
            }
        }
        if (screen != this && Main.gDemoScreen.isRecordEnabled()) {
            Globals.ud.m_recstat = 0;
            int democount = 0;
            do {
                int a = democount / 1000 % 10;
                int b = democount / 100 % 10;
                int c = democount / 10 % 10;
                int d = democount % 10;
                String fn = "demo" + a + b + c + d + ".dmo";
                if (Main.game.getCache().getGameDirectory().getEntry(fn).exists()) continue;
                try {
                    Path path = Main.game.getCache().getGameDirectory().getPath().resolve(fn);
                    Globals.ud.rec = new DemoRecorder(new FileOutputStream(path.toFile()), path, 147);
                    Console.out.println("Start recording to " + fn);
                    Globals.ud.recstat = 1;
                }
                catch (Exception e) {
                    Console.out.println("Can't start demo record: " + e, OsdColor.RED);
                }
                break;
            } while (++democount < 9999);
        }
    }

    public static boolean isDemoPlaying() {
        return Globals.ud.recstat == 2;
    }

    public static boolean isDemoScreen(Screen screen) {
        return screen == Main.gDemoScreen;
    }

    public boolean isDemoRecording() {
        return Globals.ud.recstat == 1;
    }

    public void onLoad() {
        this.onStopRecord();
        this.demfile = null;
        Globals.ud.recstat = 0;
    }

    public void onStopPlaying() {
        this.demfile = null;
        Globals.ud.recstat = 0;
    }

    public void onRecord() {
        if (Globals.ud.rec != null) {
            Globals.ud.rec.record();
        }
    }

    public void onStopRecord() {
        if (Globals.ud.rec == null) {
            return;
        }
        Globals.ud.rec.close();
        Globals.ud.rec = null;
        Globals.ud.recstat = 0;
    }
}

