/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Screens;

import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Redneck.Actors;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Premap;

public class PrecacheScreen
extends DefaultPrecacheScreen {
    public PrecacheScreen(Runnable toLoad, PrecacheListener listener) {
        super(Main.game, toLoad, listener);
        this.addQueue("Preload sounds...", this::precachenecessarysounds);
        this.addQueue("Preload floor and ceiling tiles...", () -> {
            Sector[] sectors;
            for (Sector sec : sectors = Main.boardService.getBoard().getSectors()) {
                this.addTile(sec.getFloorpicnum());
                this.addTile(sec.getCeilingpicnum());
            }
            this.doprecache(0);
            for (Sector sec : sectors) {
                if ((sec.getCeilingstat() & 1) == 0) continue;
                if (sec.getCeilingpicnum() == 1031) {
                    for (int j = 0; j < 5; ++j) {
                        this.addTile(sec.getCeilingpicnum() + j);
                    }
                    continue;
                }
                this.addTile(sec.getCeilingpicnum());
            }
            this.doprecache(1);
        });
        this.addQueue("Preload wall tiles...", () -> {
            for (Wall wall : Main.boardService.getBoard().getWalls()) {
                int j;
                this.addTile(wall.getPicnum());
                switch (wall.getPicnum()) {
                    case 1045: {
                        for (j = 0; j < 3; ++j) {
                            this.addTile(wall.getPicnum() + j);
                        }
                        break;
                    }
                    case 2878: 
                    case 2879: 
                    case 2898: 
                    case 2899: {
                        this.addTile(wall.getPicnum());
                        break;
                    }
                    case 164: 
                    case 165: 
                    case 166: {
                        for (int k = 164; k < 166; ++k) {
                            this.addTile(k);
                        }
                        break;
                    }
                }
                if (wall.getOverpicnum() < 0) continue;
                this.addTile(wall.getOverpicnum());
                if (wall.getOverpicnum() != 242) continue;
                for (j = 0; j < 3; ++j) {
                    this.addTile(242 + j);
                }
            }
            this.doprecache(0);
        });
        this.addQueue("Preload sprite tiles...", () -> {
            this.cachegoodsprites();
            for (int i = 0; i < Main.boardService.getSectorCount(); ++i) {
                for (ListNode<Sprite> j = Main.boardService.getSectNode(i); j != null; j = j.getNext()) {
                    Sprite spr = j.get();
                    if (spr.getXrepeat() == 0 || spr.getYrepeat() == 0 || (spr.getCstat() & 0x8000) != 0) continue;
                    this.cachespritenum(spr);
                }
            }
            this.doprecache(1);
        });
    }

    @Override
    public void draw(String title, int i) {
        Renderer renderer = this.game.getRenderer();
        renderer.clearview(129);
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, 2542, 0, 0, 74);
        if (Main.mUserFlag != Main.UserFlag.UserMap || Globals.boardfilename == null) {
            this.game.getFont(2).drawTextScaled(renderer, 160, 90, "Entering ", 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            if (Globals.currentGame.episodes[Globals.ud.volume_number] != null) {
                this.game.getFont(2).drawTextScaled(renderer, 160, 114, Globals.currentGame.episodes[Globals.ud.volume_number].getMapTitle(Globals.ud.level_number), 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            }
        } else {
            this.game.getFont(2).drawTextScaled(renderer, 160, 90, "Entering usermap", 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            this.game.getFont(2).drawTextScaled(renderer, 160, 114, Globals.boardfilename.getName(), 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        }
        this.game.getFont(1).drawTextScaled(renderer, 160, 146, title, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
    }

    private void precachenecessarysounds() {
        for (int i = 0; i < 500; ++i) {
            if (Globals.Sound[i].ptr != null) continue;
            Premap.getsound(i);
        }
    }

    private void cachespritenum(Sprite sp) {
        int j;
        if (Globals.ud.monsters_off && Actors.badguy(sp)) {
            return;
        }
        int maxc = 1;
        switch (sp.getPicnum()) {
            case 3845: {
                maxc = 0;
                if (Globals.ud.multimode <= 1) break;
                maxc = 5;
                for (j = 1420; j < 1526; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 2121: 
            case 2122: {
                break;
            }
            case 4162: {
                for (j = 4096; j < 4248; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 4260: {
                for (j = 4060; j <= 4095; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 4260; j <= 4340; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 4352: {
                for (j = 4352; j < 4457; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 4504: {
                for (j = 4464; j < 4511; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 4649: {
                for (j = (int)((short)(sp.getPicnum() - 41)); j < sp.getPicnum() - 1; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 4748; j <= 4762; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 4770: {
                for (j = 4770; j <= 4799; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 5890: 
            case 5891: {
                for (j = 5890; j <= 5994; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 5995: {
                for (j = 5995; j <= 6111; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 6145; j <= 6249; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 6401: {
                for (j = 6401; j <= 6484; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 6558; j <= 6641; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 6658: 
            case 6659: {
                for (j = 6658; j <= 6702; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 6705; j <= 6916; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 6920; j <= 6992; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 7030: {
                for (j = 7030; j <= 7034; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 7035: {
                for (j = 7035; j <= 7037; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 7280: {
                for (j = 7280; j <= 7334; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 7336; j <= 7385; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 8705: {
                for (j = 8705; j <= 8783; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 8785; j <= 8792; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 8795; j <= 8889; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 5120: {
                for (j = (int)sp.getPicnum(); j < sp.getPicnum() + 141; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 5290; j <= 5304; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 5317: {
                maxc = 56;
                break;
            }
            case 5376: {
                for (j = 5376; j <= 8783; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 5602; j < 5620; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 5595: {
                maxc = 14;
                break;
            }
            case 5635: {
                maxc = 214;
                break;
            }
            case 4916: {
                maxc = 6;
                break;
            }
            case 4861: {
                maxc = 34;
                break;
            }
            case 4945: 
            case 4946: {
                maxc = 68;
                break;
            }
            case 1427: {
                maxc = 9;
                break;
            }
            case 1273: 
            case 1324: {
                maxc = 3;
                break;
            }
            case 1930: {
                maxc = 7;
                break;
            }
            case 5270: 
            case 5274: 
            case 5278: 
            case 5282: 
            case 5286: {
                maxc = 4;
            }
        }
        for (j = (int)sp.getPicnum(); j < sp.getPicnum() + maxc; j = (int)((short)(j + 1))) {
            this.addTile(j);
        }
    }

    private void cachegoodsprites() {
        int i;
        this.addTile(1647);
        if (Globals.ud.multimode > 1) {
            this.addTile(1650);
            this.addTile(1643);
        }
        for (i = 1657; i < 1667; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3374; i < 3379; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        this.addTile(20);
        this.addTile(33);
        this.addTile(30);
        this.addTile(31);
        this.addTile(1645);
        this.addTile(1648);
        this.addTile(1652);
        this.addTile(1653);
        this.addTile(1654);
        this.addTile(1655);
        this.addTile(1656);
        this.addTile(1689);
        this.addTile(1692);
        this.addTile(1649);
        for (i = 920; i < 924; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 930; i < 939; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 514; i < 608; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 632; i < 714; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 718; i < 781; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3340; i < 3348; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3328; i < 3339; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3350; i < 3359; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3370; i < 3373; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3380; i < 3383; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1702; i < 1704; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1752; i < 1757; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3360; i < 3367; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3383; i < 3388; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3395; i < 3398; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3415; i < 3419; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3427; i < 3429; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        this.addTile(3438);
        for (i = 3445; i < 3448; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 3452; i < 3459; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 21; i <= 29; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 40; i <= 62; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        this.addTile(32);
        for (i = 1764; i <= 1767; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1079; i < 1082; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1494; i < 1508; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1539; i < 1553; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1441; i < 1462; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        this.addTile(1212);
        for (i = 1463; i < 1488; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1515; i < 1523; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1595; i < 1624; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1554; i < 1558; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1391; i < 1395; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
    }
}

