/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Types;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ShortArray;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.ResourceHandler;
import ru.m210projects.Redneck.Types.ANIMATION;
import ru.m210projects.Redneck.Types.Animwalltype;
import ru.m210projects.Redneck.Types.GameInfo;
import ru.m210projects.Redneck.Types.PlayerOrig;
import ru.m210projects.Redneck.Types.PlayerStruct;
import ru.m210projects.Redneck.Types.Weaponhit;

public class SafeLoader {
    public final int MAXJAILDOORS = 32;
    public final int MAXMINECARDS = 16;
    public final int MAXTORCHES = 64;
    public final int MAXLIGHTNINS = 64;
    public final int MAXAMBIENTS = 64;
    public final int MAXGEOMETRY = 64;
    public Entry boardfilename;
    public GameInfo addon;
    public String addonFileName;
    public String addonPackedConName;
    public byte warp_on;
    public final short[] spriteq = new short[1024];
    public short spriteqloc;
    public short spriteqamount = (short)64;
    public short numanimwalls;
    public final int[] msx = new int[2048];
    public final int[] msy = new int[2048];
    public final short[][] cyclers = new short[256][6];
    public short numcyclers;
    public final short[] mirrorwall = new short[64];
    public final short[] mirrorsector = new short[64];
    public short mirrorcnt;
    public final Animwalltype[] animwall = new Animwalltype[512];
    public final PlayerOrig[] po = new PlayerOrig[16];
    public final PlayerStruct[] ps = new PlayerStruct[16];
    public final Array<Weaponhit> hittype = new Array(true, 4096, Weaponhit.class);
    public final BitMap show2dsector = new BitMap(1024);
    public final BitMap shadeEffect = new BitMap(1024);
    public final int[] jailspeed = new int[32];
    public final int[] jaildistance = new int[32];
    public final short[] jailsect = new short[32];
    public final short[] jaildirection = new short[32];
    public final short[] jailunique = new short[32];
    public final short[] jailsound = new short[32];
    public final short[] jailstatus = new short[32];
    public final int[] jailcount2 = new int[32];
    public final int[] minespeed = new int[16];
    public final int[] minefulldist = new int[16];
    public final int[] minedistance = new int[16];
    public final short[] minechild = new short[16];
    public final short[] mineparent = new short[16];
    public final short[] minedirection = new short[16];
    public final short[] minesound = new short[16];
    public final short[] minestatus = new short[16];
    public final short[] torchsector = new short[64];
    public final byte[] torchshade = new byte[64];
    public final short[] torchflags = new short[64];
    public final short[] lightninsector = new short[64];
    public final short[] lightninshade = new short[64];
    public final short[] ambienttype = new short[64];
    public final short[] ambientid = new short[64];
    public final short[] ambienthitag = new short[64];
    public final short[] geomsector = new short[64];
    public final short[] geoms1 = new short[64];
    public final int[] geomx1 = new int[64];
    public final int[] geomy1 = new int[64];
    public final int[] geomz1 = new int[64];
    public final short[] geoms2 = new short[64];
    public final int[] geomx2 = new int[64];
    public final int[] geomy2 = new int[64];
    public final int[] geomz2 = new int[64];
    public boolean plantProcess = false;
    public int numlightnineffects;
    public int numtorcheffects;
    public int numgeomeffects;
    public int numjaildoors;
    public int numminecart;
    public int numambients;
    public int UFO_SpawnCount;
    public int UFO_SpawnTime;
    public int UFO_SpawnHulk;
    public short gEndGame;
    public short gEndFirstEpisode;
    public short BellTime;
    public int BellSound;
    public short word_119BE0;
    public int WindDir;
    public int WindTime;
    public int mamaspawn_count;
    public int fakebubba_spawn;
    public int dword_119C08;
    public final IntArray actorscrptr = new IntArray(Engine.MAXTILES);
    public final ShortArray actortype = new ShortArray(Engine.MAXTILES);
    public final int[] script = new int[20460];
    public int gAnimationCount = 0;
    public final ANIMATION[] gAnimationData = new ANIMATION[512];
    public final short[] pskyoff = new short[256];
    public short pskybits;
    public short earthquaketime;
    public int parallaxyscale;
    public short camsprite;
    public short numplayersprites;
    public short connecthead;
    public final short[] connectpoint2 = new short[16];
    public final short[][] frags = new short[16][16];
    public int randomseed;
    public short global_random;
    public int multimode;
    public int volume_number;
    public int level_number;
    public int player_skill;
    public short from_bonus;
    public short secretlevel;
    public boolean respawn_monsters;
    public boolean respawn_items;
    public boolean respawn_inventory;
    public int eog;
    public boolean god;
    public int auto_run;
    public int crosshair;
    public boolean monsters_off;
    public int last_level;
    public int coop;
    public int marker;
    public int ffire;
    public final short[] rorsector = new short[16];
    public final byte[] rortype = new byte[16];
    public int rorcnt;
    public Sector[] sector;
    public Wall[] wall;
    public List<Sprite> sprite;
    private String message;

    public SafeLoader() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.ps[i] = new PlayerStruct();
            this.po[i] = new PlayerOrig();
        }
        for (i = 0; i < 512; ++i) {
            this.gAnimationData[i] = new ANIMATION();
        }
        for (i = 0; i < 512; ++i) {
            this.animwall[i] = new Animwalltype();
        }
    }

    public boolean load(InputStream is) {
        this.message = null;
        this.hittype.clear();
        this.actorscrptr.clear();
        this.actortype.clear();
        try {
            this.addon = this.LoadGDXHeader(is);
            this.MapLoad(is);
            this.StuffLoad(is);
            this.ConLoad(is);
            this.AnimationLoad(is);
            this.GameInfoLoad(is);
            if (this.warp_on == 1 && this.addon == null) {
                this.message = "Can't find user episode file: " + this.addonFileName;
                this.warp_on = (byte)2;
                this.volume_number = 0;
                this.level_number = 7;
            }
            if (is.available() == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void AnimationLoad(InputStream is) throws IOException {
        for (int i = 0; i < 512; ++i) {
            short index = StreamUtils.readShort(is);
            byte type = StreamUtils.readByte(is);
            this.gAnimationData[i].id = index;
            this.gAnimationData[i].type = type;
            this.gAnimationData[i].ptr = null;
            this.gAnimationData[i].goal = StreamUtils.readInt(is);
            this.gAnimationData[i].vel = StreamUtils.readInt(is);
            this.gAnimationData[i].sect = StreamUtils.readShort(is);
        }
        this.gAnimationCount = StreamUtils.readInt(is);
    }

    public void ConLoad(InputStream is) throws IOException {
        int i;
        int len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            this.actortype.add((short)StreamUtils.readUnsignedByte(is));
        }
        len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            this.script[i] = StreamUtils.readInt(is);
        }
        len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            this.actorscrptr.add(StreamUtils.readInt(is));
        }
        len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            Weaponhit weaponhit = new Weaponhit();
            weaponhit.readObject(is);
            this.hittype.add(weaponhit);
        }
    }

    public void GameInfoLoad(InputStream is) throws IOException {
        int i;
        this.pskybits = StreamUtils.readShort(is);
        this.parallaxyscale = StreamUtils.readInt(is);
        for (i = 0; i < 256; ++i) {
            this.pskyoff[i] = StreamUtils.readShort(is);
        }
        this.earthquaketime = StreamUtils.readShort(is);
        this.from_bonus = StreamUtils.readShort(is);
        this.secretlevel = StreamUtils.readShort(is);
        this.respawn_monsters = StreamUtils.readBoolean(is);
        this.respawn_items = StreamUtils.readBoolean(is);
        this.respawn_inventory = StreamUtils.readBoolean(is);
        this.god = StreamUtils.readBoolean(is);
        this.auto_run = StreamUtils.readInt(is) == 1 ? 1 : 0;
        this.crosshair = StreamUtils.readInt(is) == 1 ? 1 : 0;
        this.monsters_off = StreamUtils.readBoolean(is);
        this.last_level = StreamUtils.readInt(is);
        this.eog = StreamUtils.readInt(is);
        this.coop = StreamUtils.readInt(is);
        this.marker = StreamUtils.readInt(is);
        this.ffire = StreamUtils.readInt(is);
        this.camsprite = StreamUtils.readShort(is);
        this.connecthead = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.connectpoint2[i] = StreamUtils.readShort(is);
        }
        this.numplayersprites = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.frags[i][j] = StreamUtils.readShort(is);
            }
        }
        this.randomseed = StreamUtils.readInt(is);
        this.global_random = StreamUtils.readShort(is);
    }

    public void StuffLoad(InputStream is) throws IOException {
        int i;
        this.numcyclers = StreamUtils.readShort(is);
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.cyclers[i][j] = StreamUtils.readShort(is);
            }
        }
        for (i = 0; i < 16; ++i) {
            this.ps[i].readObject(is);
        }
        for (i = 0; i < 16; ++i) {
            this.po[i].readObject(is);
        }
        this.numanimwalls = StreamUtils.readShort(is);
        for (i = 0; i < 512; ++i) {
            this.animwall[i].wallnum = StreamUtils.readShort(is);
            this.animwall[i].tag = StreamUtils.readInt(is);
        }
        for (i = 0; i < 2048; ++i) {
            this.msx[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 2048; ++i) {
            this.msy[i] = StreamUtils.readInt(is);
        }
        this.spriteqloc = StreamUtils.readShort(is);
        this.spriteqamount = StreamUtils.readShort(is);
        for (i = 0; i < 1024; ++i) {
            this.spriteq[i] = StreamUtils.readShort(is);
        }
        this.mirrorcnt = StreamUtils.readShort(is);
        for (i = 0; i < 64; ++i) {
            this.mirrorwall[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < 64; ++i) {
            this.mirrorsector[i] = StreamUtils.readShort(is);
        }
        this.show2dsector.readObject(is);
        this.shadeEffect.readObject(is);
        this.numjaildoors = StreamUtils.readInt(is);
        for (i = 0; i < 32; ++i) {
            this.jailspeed[i] = StreamUtils.readInt(is);
            this.jaildistance[i] = StreamUtils.readInt(is);
            this.jailsect[i] = StreamUtils.readShort(is);
            this.jaildirection[i] = StreamUtils.readShort(is);
            this.jailunique[i] = StreamUtils.readShort(is);
            this.jailsound[i] = StreamUtils.readShort(is);
            this.jailstatus[i] = StreamUtils.readShort(is);
            this.jailcount2[i] = StreamUtils.readInt(is);
        }
        this.numminecart = StreamUtils.readInt(is);
        for (i = 0; i < 16; ++i) {
            this.minespeed[i] = StreamUtils.readInt(is);
            this.minefulldist[i] = StreamUtils.readInt(is);
            this.minedistance[i] = StreamUtils.readInt(is);
            this.minechild[i] = StreamUtils.readShort(is);
            this.mineparent[i] = StreamUtils.readShort(is);
            this.minedirection[i] = StreamUtils.readShort(is);
            this.minesound[i] = StreamUtils.readShort(is);
            this.minestatus[i] = StreamUtils.readShort(is);
        }
        this.numtorcheffects = StreamUtils.readInt(is);
        for (i = 0; i < 64; ++i) {
            this.torchsector[i] = StreamUtils.readShort(is);
            this.torchshade[i] = StreamUtils.readByte(is);
            this.torchflags[i] = StreamUtils.readShort(is);
        }
        this.numlightnineffects = StreamUtils.readInt(is);
        for (i = 0; i < 64; ++i) {
            this.lightninsector[i] = StreamUtils.readShort(is);
            this.lightninshade[i] = StreamUtils.readShort(is);
        }
        this.numambients = StreamUtils.readInt(is);
        for (i = 0; i < 64; ++i) {
            this.ambienttype[i] = StreamUtils.readShort(is);
            this.ambientid[i] = StreamUtils.readShort(is);
            this.ambienthitag[i] = StreamUtils.readShort(is);
        }
        this.numgeomeffects = StreamUtils.readInt(is);
        for (i = 0; i < 64; ++i) {
            this.geomsector[i] = StreamUtils.readShort(is);
            this.geoms1[i] = StreamUtils.readShort(is);
            this.geomx1[i] = StreamUtils.readInt(is);
            this.geomy1[i] = StreamUtils.readInt(is);
            this.geomz1[i] = StreamUtils.readInt(is);
            this.geoms2[i] = StreamUtils.readShort(is);
            this.geomx2[i] = StreamUtils.readInt(is);
            this.geomy2[i] = StreamUtils.readInt(is);
            this.geomz2[i] = StreamUtils.readInt(is);
        }
        this.UFO_SpawnCount = StreamUtils.readShort(is);
        this.UFO_SpawnTime = StreamUtils.readShort(is);
        this.UFO_SpawnHulk = StreamUtils.readShort(is);
        this.gEndFirstEpisode = StreamUtils.readShort(is);
        this.gEndGame = StreamUtils.readShort(is);
        this.plantProcess = StreamUtils.readBoolean(is);
        this.BellTime = StreamUtils.readShort(is);
        this.BellSound = StreamUtils.readInt(is);
        this.word_119BE0 = StreamUtils.readShort(is);
        this.WindDir = StreamUtils.readInt(is);
        this.WindTime = StreamUtils.readInt(is);
        this.mamaspawn_count = StreamUtils.readInt(is);
        this.fakebubba_spawn = StreamUtils.readInt(is);
        this.dword_119C08 = StreamUtils.readInt(is);
    }

    public void MapLoad(InputStream is) throws Exception {
        int i;
        int i2;
        this.boardfilename = Directory.DUMMY_ENTRY;
        String name = StreamUtils.readString(is, 144);
        if (!name.isEmpty()) {
            this.boardfilename = Main.game.getCache().getEntry(name, true);
        }
        this.sector = new Sector[StreamUtils.readInt(is)];
        for (i2 = 0; i2 < this.sector.length; ++i2) {
            this.sector[i2] = new Sector().readObject(is);
        }
        this.wall = new Wall[StreamUtils.readInt(is)];
        for (i2 = 0; i2 < this.wall.length; ++i2) {
            this.wall[i2] = new Wall().readObject(is);
        }
        int numSprites = StreamUtils.readInt(is);
        this.sprite = new ArrayList<Sprite>(numSprites * 2);
        for (i = 0; i < numSprites; ++i) {
            this.sprite.add(new Sprite().readObject(is));
        }
        this.rorcnt = StreamUtils.readInt(is);
        for (i = 0; i < 16; ++i) {
            this.rorsector[i] = StreamUtils.readShort(is);
            this.rortype[i] = StreamUtils.readByte(is);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public GameInfo LoadGDXHeader(InputStream is) throws IOException {
        this.volume_number = -1;
        this.level_number = -1;
        this.player_skill = -1;
        this.warp_on = 0;
        this.addon = null;
        this.addonFileName = null;
        this.addonPackedConName = null;
        StreamUtils.skip(is, 40);
        this.multimode = StreamUtils.readInt(is);
        this.volume_number = StreamUtils.readInt(is);
        this.level_number = StreamUtils.readInt(is);
        this.player_skill = StreamUtils.readInt(is);
        StreamUtils.skip(is, 16000);
        this.LoadGDXBlock(is);
        if (this.warp_on == 1) {
            this.addon = SafeLoader.findAddon(this.addonFileName, this.addonPackedConName);
        }
        return this.addon;
    }

    public void LoadGDXBlock(InputStream is) throws IOException {
        this.warp_on = StreamUtils.readByte(is);
        if (this.warp_on == 1) {
            boolean isPacked = StreamUtils.readBoolean(is);
            this.addonFileName = StreamUtils.readDataString(is).toLowerCase();
            if (isPacked) {
                this.addonPackedConName = StreamUtils.readDataString(is).toLowerCase();
            }
        }
    }

    public static GameInfo findAddon(String addonFileName, String conName) {
        try {
            FileEntry addonEntry = Main.game.getCache().getGameDirectory().getEntry(FileUtils.getPath(addonFileName, new String[0]));
            if (addonEntry.exists()) {
                if (conName == null) {
                    conName = addonEntry.getName();
                }
                String finalIniName = conName;
                return ResourceHandler.episodeManager.getEpisodeEntries(addonEntry).stream().filter(e -> e.getConFile().getName().equalsIgnoreCase(finalIniName)).map(ResourceHandler.episodeManager::getEpisode).findAny().orElse(null);
            }
        }
        catch (Exception e2) {
            Console.out.println(e2.toString(), OsdColor.RED);
        }
        return null;
    }
}

