/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.filehandle;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Input;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Premap;
import ru.m210projects.Redneck.filehandle.EpisodeEntry;
import ru.m210projects.Redneck.filehandle.LZWOutputStream;

public class DemoRecorder {
    private final OutputStream os;
    private final Path filepath;
    public int reccnt;
    public int totalreccnt;
    public int recversion;

    public DemoRecorder(FileOutputStream os, Path filepath, int nVersion) throws IOException {
        int i;
        this.filepath = filepath;
        StreamUtils.writeInt(os, 0L);
        StreamUtils.writeByte(os, nVersion);
        StreamUtils.writeByte(os, Globals.ud.volume_number);
        StreamUtils.writeByte(os, Globals.ud.level_number);
        StreamUtils.writeByte(os, Globals.ud.player_skill);
        StreamUtils.writeByte(os, Globals.ud.coop);
        StreamUtils.writeByte(os, Globals.ud.ffire);
        StreamUtils.writeShort(os, Globals.ud.multimode);
        StreamUtils.writeShort(os, Globals.ud.monsters_off ? 1 : 0);
        StreamUtils.writeInt(os, Globals.ud.respawn_monsters ? 1L : 0L);
        StreamUtils.writeInt(os, Globals.ud.respawn_items ? 1L : 0L);
        StreamUtils.writeInt(os, Globals.ud.respawn_inventory ? 1L : 0L);
        StreamUtils.writeInt(os, Globals.ud.playerai);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeString(os, Globals.ud.user_name[i], 32);
        }
        if (nVersion >= 147) {
            if (Main.mUserFlag == Main.UserFlag.Addon && Globals.currentGame != null) {
                EpisodeEntry episodeEntry = Globals.currentGame.getEpisodeEntry();
                boolean isPacked = episodeEntry.isPackageEpisode();
                StreamUtils.writeBoolean(os, isPacked);
                StreamUtils.writeDataString(os, episodeEntry.getFileEntry().getRelativePath().toString());
                if (isPacked) {
                    StreamUtils.writeDataString(os, episodeEntry.getConFile().getName());
                }
            } else {
                StreamUtils.writeBoolean(os, false);
                StreamUtils.writeInt(os, 0L);
            }
            for (i = 0; i < Globals.ud.multimode; ++i) {
                Premap.PlayerInfo info = new Premap.PlayerInfo();
                info.set(Globals.ps[i]);
                info.writeObject(os);
            }
        }
        for (i = 0; i < Globals.ud.multimode; ++i) {
            StreamUtils.writeByte(os, Globals.ps[i].aim_mode);
            if (nVersion < 147) continue;
            StreamUtils.writeByte(os, Globals.ps[i].auto_aim);
        }
        this.totalreccnt = 0;
        this.reccnt = 0;
        this.recversion = nVersion;
        this.os = new LZWOutputStream(new BufferedOutputStream(os, 2520 * Input.sizeof(147)), Input.sizeof(147));
    }

    public void record() {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            try {
                Globals.sync[i].writeObject(this.os, this.recversion);
                ++this.reccnt;
                if (this.reccnt >= 2520) {
                    this.os.flush();
                    this.reccnt = 0;
                }
                ++this.totalreccnt;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
                this.close();
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    public void close() {
        try {
            this.os.close();
            try (OutputStream out = Files.newOutputStream(this.filepath, StandardOpenOption.WRITE);){
                StreamUtils.writeInt(out, this.totalreccnt);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        Console.out.println("Stop recording");
        Directory dir = Main.game.getCache().getGameDirectory();
        FileEntry entry = dir.addEntry(this.filepath);
        if (entry.exists()) {
            List demos = Main.gDemoScreen.demofiles.computeIfAbsent(dir, e -> new ArrayList());
            demos.add(entry);
        }
    }
}

