/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.filehandle;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class VOCDecoder
implements SoundData.Decoder {
    @Override
    public SoundData decode(Entry entry) {
        SoundData soundData;
        block23: {
            InputStream is = entry.getInputStream();
            try {
                int block;
                int blocktype;
                String signature = StreamUtils.readString(is, 20);
                if (!signature.equalsIgnoreCase("Creative Voice File\u001a")) {
                    throw new Exception("Wrong signature " + signature);
                }
                StreamUtils.skip(is, 2);
                short version = StreamUtils.readShort(is);
                short checksum = StreamUtils.readShort(is);
                if (~version + 4660 != checksum) {
                    throw new Exception("Version checksum error!");
                }
                ByteArrayOutputStream pcm = new ByteArrayOutputStream();
                int rate = 0;
                int channels = 1;
                int bits = 8;
                block13: while (is.available() > 4 && (blocktype = (block = StreamUtils.readInt(is)) & 0xFF) != 0) {
                    int blocklen = block >> 8;
                    switch (blocktype) {
                        case 1: {
                            rate = 1000000 / (256 - StreamUtils.readUnsignedByte(is));
                            if (StreamUtils.readByte(is) != 0) {
                                throw new Exception("Only 8-bit files supported");
                            }
                            channels = 1;
                            bits = 8;
                            pcm.write(StreamUtils.readBytes(is, Math.min(is.available(), blocklen - 2)));
                            continue block13;
                        }
                        case 2: {
                            pcm.write(StreamUtils.readBytes(is, Math.min(is.available(), blocklen)));
                            continue block13;
                        }
                        case 8: {
                            rate = StreamUtils.readShort(is);
                            rate = 256000000 / (65536 - (rate & 0xFFFF));
                            bits = 8;
                            if (StreamUtils.readByte(is) != 0) {
                                throw new Exception("Only 8-bit files supported");
                            }
                            if (StreamUtils.readByte(is) == 1) {
                                rate >>= 1;
                                channels = 2;
                                continue block13;
                            }
                            channels = 1;
                            continue block13;
                        }
                        case 9: {
                            rate = StreamUtils.readInt(is);
                            bits = StreamUtils.readUnsignedByte(is);
                            if (bits == 0) {
                                bits = 8;
                            }
                            channels = StreamUtils.readUnsignedByte(is);
                            int codec = StreamUtils.readUnsignedShort(is);
                            if (codec != 0 && codec != 4) {
                                throw new Exception("Only PCM files supported");
                            }
                            StreamUtils.skip(is, 4);
                            pcm.write(StreamUtils.readBytes(is, Math.min(is.available(), blocklen - 12)));
                            continue block13;
                        }
                    }
                    StreamUtils.skip(is, blocklen);
                }
                int samplelength = pcm.size();
                if (bits != 8 && samplelength % 2 == 1) {
                    ++samplelength;
                }
                ByteBuffer pcmData = ByteBuffer.allocateDirect(samplelength).order(ByteOrder.LITTLE_ENDIAN);
                pcmData.put(pcm.toByteArray());
                pcmData.rewind();
                soundData = new SoundData(rate, channels, bits, pcmData);
                if (is == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Console.out.print("VOC loader error: " + e, OsdColor.RED);
                    return null;
                }
            }
            is.close();
        }
        return soundData;
    }
}

