/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Factory;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.SpriteMap;
import ru.m210projects.Build.Types.collections.ValueSetter;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Tekwar.Factory.SectorVer6;
import ru.m210projects.Tekwar.Factory.SpriteVer6;
import ru.m210projects.Tekwar.Factory.TekBoard;
import ru.m210projects.Tekwar.Factory.WallVer6;
import ru.m210projects.Tekwar.Tekprep;
import ru.m210projects.Tekwar.Types.XTtrailertype;

public class TekBoardService
extends BoardService {
    public static final String TRAILERID = "**MAP_EXTS**";

    public TekBoardService() {
        this.registerBoard(6, SectorVer6.class, WallVer6.class, SpriteVer6.class);
    }

    @Override
    protected TekBoard loadBoard(Entry entry) throws IOException {
        boolean noext;
        Board b = super.loadBoard(entry);
        TekBoard tekBoard = new TekBoard(b.getPos(), b.getSectors(), b.getWalls(), b.getSprites());
        for (int i = 0; i < Engine.MAXSPRITES; ++i) {
            Tekprep.spriteXT[i].set(0);
        }
        XTtrailertype XTtrailer = tekBoard.getXTtrailer();
        try (InputStream is = entry.getInputStream();){
            StreamUtils.skip(is, (int)(entry.getSize() - 34L));
            XTtrailer.load(is);
        }
        boolean bl = noext = XTtrailer.ID == null || XTtrailer.ID.compareToIgnoreCase(TRAILERID) != 0;
        if (!noext) {
            try (InputStream is = entry.getInputStream();){
                StreamUtils.skip(is, XTtrailer.start);
                for (int i = 0; i < XTtrailer.numXTs; ++i) {
                    tekBoard.getXTsave().load(is);
                }
            }
        }
        return tekBoard;
    }

    @Override
    protected SpriteMap createSpriteMap(int listCount, List<Sprite> spriteList, int spriteCount, ValueSetter<Sprite> valueSetter) {
        return new SpriteMap(listCount, spriteList, spriteCount, valueSetter){

            @Override
            protected Sprite getInstance() {
                SpriteVer6 spr = new SpriteVer6();
                spr.setSectnum((short)Engine.MAXSECTORS);
                spr.setStatnum(1024);
                spr.setExtra(-1);
                return spr;
            }
        };
    }
}

