/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuVideoMode;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Tekwar.Menus.MenuInterfaceSet;
import ru.m210projects.Tekwar.Teksnd;

public class TekMenuHandler
extends MenuHandler {
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int LOADGAME = 3;
    public static final int SAVEGAME = 4;
    public static final int QUIT = 6;
    public static final int HELP = 7;
    public static final int AUDIOSET = 8;
    public static final int OPTIONS = 10;
    public static final int COLORCORR = 11;
    public static final int LASTSAVE = 12;
    public static final int CORRUPTLOAD = 13;
    private final Engine engine;
    private final BuildGame app;

    public TekMenuHandler(BuildGame app, int nMaxMenus) {
        super(app);
        this.mMenus = new BuildMenu[nMaxMenus];
        this.engine = app.pEngine;
        this.app = app;
    }

    @Override
    public void mDrawMenu() {
        Renderer renderer = this.game.getRenderer();
        if (!(this.app.pMenu.getCurrentMenu() instanceof BuildMenuList) && !(this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            int tile = 321;
            ArtEntry pic = this.engine.getTile(tile);
            int xdim = renderer.getWidth();
            int ydim = renderer.getHeight();
            float kt = (float)xdim / (float)ydim;
            float kv = (float)pic.getWidth() / (float)pic.getHeight();
            float scale = kv >= kt ? (float)(ydim + 1) / (float)pic.getHeight() : (float)(xdim + 1) / (float)pic.getWidth();
            renderer.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 0, 25);
        }
        if (!(this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            renderer.rotatesprite(0xA00000, 0x3C0000, 32768, 0, 1529, 0, 0, 1034);
            renderer.rotatesprite(0xA00000, 0xB40000, 32768, 0, 1530, 0, 0, 1034);
        }
        super.mDrawMenu();
    }

    @Override
    public int getShade(MenuItem item) {
        if (item != null && item.isFocused()) {
            return 16 - (this.engine.getTotalClock() & 0x3F);
        }
        return 0;
    }

    @Override
    public int getPal(Font font, MenuItem item) {
        if (item != null) {
            if (!item.isEnabled()) {
                return 2;
            }
            if (item.isFocused()) {
                return 4;
            }
            return item.pal;
        }
        return 0;
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.isMenuMouse()) {
            return;
        }
        Renderer renderer = this.game.getRenderer();
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(65536L, ydim, 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.getgMouseCursorSize(), 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        renderer.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8, 0, 0, xdim - 1, ydim - 1);
    }

    @Override
    public void mPostDraw(MenuItem item) {
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case Open: {
                if (this.mCount == 1) {
                    Teksnd.playsound(52, 0, 0, 0, 1);
                    break;
                }
                Teksnd.playsound(53, 0, 0, 0, 1);
                break;
            }
            case Close: {
                if (this.mCount == 1) {
                    Teksnd.playsound(53, 0, 0, 0, 1);
                    break;
                }
                Teksnd.playsound(54, 0, 0, 0, 1);
                break;
            }
            case UP: 
            case DW: {
                Teksnd.playsound(55, 0, 0, 0, 1);
                break;
            }
            case LEFT: 
            case RIGHT: 
            case ENTER: {
                if (opt == MenuHandler.MenuOpt.ENTER && item instanceof MenuConteiner && item.getClass().getEnclosingClass() == MenuVideoMode.class || !(item instanceof MenuSlider) && !(item instanceof MenuSwitch) && !(item instanceof MenuConteiner)) break;
                Teksnd.playsound(52, 0, 0, 0, 1);
                break;
            }
        }
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.isMenuMouse()) {
            return;
        }
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(16384L, ydim, 200L);
        if (this.mCount > 1) {
            ArtEntry pic = this.engine.getTile(9216);
            int shade = 4 + Pragmas.mulscale(16L, EngineUtils.sin(20 * this.engine.getTotalClock() & 0x7FF), 16);
            renderer.rotatesprite(0, ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, pic.getWidth() - 1, 16), ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(16384L, ydim, 200L);
        ArtEntry pic = this.engine.getTile(9216);
        int size = Pragmas.mulscale(pic.getWidth(), zoom, 16);
        int bx = 0;
        int by = ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16);
        if (mx >= bx && mx < bx + size) {
            return my >= by && my < by + size;
        }
        return false;
    }
}

