/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Screens;

import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.BuildSmacker.SMKAudio;
import ru.m210projects.BuildSmacker.SMKFile;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Teksnd;

public class CutsceneScreen
extends MovieScreen {
    public CutsceneScreen(BuildGame game) {
        super(game, Engine.MAXTILES - 3);
        this.nFlags |= 4;
    }

    @Override
    public void hide() {
        this.close();
    }

    @Override
    public boolean init(String path) {
        if (!Main.tekcfg.showCutscenes || this.isInited()) {
            return false;
        }
        return this.open(path);
    }

    @Override
    protected MovieScreen.MovieFile GetFile(String file) {
        try {
            return new SMKMovieFile(file);
        }
        catch (Exception e) {
            Console.out.println(e + ": " + file, OsdColor.RED);
            return null;
        }
    }

    @Override
    protected void StopAllSounds() {
        Teksnd.stopallsounds();
        Teksnd.sndStopMusic();
    }

    @Override
    protected byte[] DoDrawFrame(int num) {
        byte[] pic = this.mvfil.getFrame(num);
        if (((SMKMovieFile)this.mvfil).paletteChanged) {
            this.changepalette(this.mvfil.getPalette());
        }
        return pic;
    }

    @Override
    protected Font GetFont() {
        return this.game.getFont(0);
    }

    @Override
    protected void DrawEscText(Font font, int pal) {
        Renderer renderer = this.game.getRenderer();
        int shade = 16 + Pragmas.mulscale(32L, EngineUtils.sin(20 * this.engine.getTotalClock() & 0x7FF), 16);
        this.game.getFont(0).drawTextScaled(renderer, 160, 5, "Press ESC to skip", 1.0f, shade, 251, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
    }

    protected static class SMKMovieFile
    implements MovieScreen.MovieFile {
        protected SMKFile smkfil;
        protected boolean paletteChanged;
        protected Source audio;
        protected int sourceRate;
        protected int sourceBits;
        protected int sourceChannels;
        protected ByteBuffer sourceBuffer;

        public SMKMovieFile(String file) throws Exception {
            SMKAudio aud;
            Entry entry = Main.game.getCache().getEntry(file, true);
            if (!entry.exists()) {
                throw new FileNotFoundException();
            }
            ByteBuffer bb = ByteBuffer.wrap(entry.getBytes());
            bb.order(ByteOrder.LITTLE_ENDIAN);
            this.smkfil = new SMKFile(bb);
            this.smkfil.setEnable(SMKFile.Track.All, SMKFile.Track.Video.mask() | SMKFile.Track.Audio.mask());
            if (!Main.tekcfg.isNoSound() && (aud = this.smkfil.getAudio(0)) != null) {
                this.sourceRate = aud.getRate();
                this.sourceBits = aud.getBits().get();
                this.sourceChannels = aud.getChannels().get();
                if (this.sourceRate != 0 && this.sourceBits != 0) {
                    this.sourceBuffer = this.smkfil.getAudioBuffer(0);
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                    bb.rewind();
                }
            }
        }

        @Override
        public void playAudio() {
            if (Main.tekcfg.isNoSound()) {
                return;
            }
            if (this.sourceRate != 0 && this.sourceBits != 0 && this.sourceBuffer != null) {
                this.audio = Teksnd.newSound(this.sourceBuffer, this.sourceRate, this.sourceBits, this.sourceChannels, 255);
                if (this.audio != null) {
                    this.audio.play(1.0f);
                }
            }
        }

        @Override
        public int getFrames() {
            return this.smkfil.getFrames();
        }

        @Override
        public float getRate() {
            return (float)this.smkfil.getRate() / 1000.0f;
        }

        @Override
        public byte[] getFrame(int num) {
            this.paletteChanged = this.smkfil.setFrame(num) != 0;
            return this.smkfil.getVideoBuffer().array();
        }

        @Override
        public byte[] getPalette() {
            return this.smkfil.getPalette();
        }

        @Override
        public int getWidth() {
            return (short)this.smkfil.getWidth();
        }

        @Override
        public int getHeight() {
            return (short)this.smkfil.getHeight();
        }

        @Override
        public void close() {
            if (this.audio != null) {
                this.audio.stop();
            }
        }
    }
}

