/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Tekwar.Main;

public class PrecacheScreen
extends DefaultPrecacheScreen {
    public PrecacheScreen(Runnable toLoad, PrecacheListener listener) {
        super(Main.game, toLoad, listener);
        this.addQueue("Preload floor and ceiling tiles...", () -> {
            Sector[] sectors;
            for (Sector sec : sectors = Main.boardService.getBoard().getSectors()) {
                this.addTile(sec.getFloorpicnum());
                this.addTile(sec.getCeilingpicnum());
            }
            this.doprecache(0);
        });
        this.addQueue("Preload wall tiles...", () -> {
            for (Wall wall : Main.boardService.getBoard().getWalls()) {
                this.addTile(wall.getPicnum());
                if (wall.getOverpicnum() < 0) continue;
                this.addTile(wall.getOverpicnum());
            }
            this.doprecache(0);
        });
        this.addQueue("Preload sprite tiles...", () -> {
            for (int i = 0; i < Engine.MAXSPRITES; ++i) {
                Sprite sp = Main.boardService.getSprite(i);
                if (sp == null || sp.getStatnum() >= 1024) continue;
                this.addTile(sp.getPicnum());
            }
            this.doprecache(1);
        });
    }

    @Override
    protected void draw(String title, int index) {
        Renderer renderer = this.game.getRenderer();
        ArtEntry pic = renderer.getTile(406);
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        int frames = xdim / pic.getWidth();
        int x = 160;
        for (int i = 0; i <= frames; ++i) {
            renderer.rotatesprite(x << 16, 0x640000, 65536, 0, 406, 0, 0, 266, 0, 0, xdim - 1, ydim - 1);
            x += pic.getWidth();
        }
        this.game.getFont(0).drawTextScaled(renderer, 160, 100, "Loading...", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        this.game.getFont(0).drawTextScaled(renderer, 160, 120, title, 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
    }
}

