/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Tekwar.Animate;
import ru.m210projects.Tekwar.Factory.TekRenderer;
import ru.m210projects.Tekwar.Globals;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Player;
import ru.m210projects.Tekwar.Tekgun;
import ru.m210projects.Tekwar.Tekmap;
import ru.m210projects.Tekwar.Tekprep;
import ru.m210projects.Tekwar.Teksnd;
import ru.m210projects.Tekwar.Tekstat;
import ru.m210projects.Tekwar.Tektag;
import ru.m210projects.Tekwar.Types.ANIMATION;
import ru.m210projects.Tekwar.Types.LSInfo;
import ru.m210projects.Tekwar.Types.SafeLoader;
import ru.m210projects.Tekwar.View;

public class Tekldsv {
    public static final String savsign = "TKWR";
    public static final int gdxSave = 100;
    public static final int currentGdxSave = 103;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final char[] filenum = new char[4];
    public static boolean gQuickSaving;
    public static final LSInfo lsInf;
    public static FileEntry lastload;
    public static int quickslot;
    public static final SafeLoader loader;

    public static void FindSaves(Directory dir) {
        for (Entry file : dir) {
            if (!file.isExtension("sav") || !(file instanceof FileEntry)) continue;
            try {
                InputStream is = file.getInputStream();
                try {
                    short nVersion;
                    String signature = StreamUtils.readString(is, 4);
                    if (signature.isEmpty() || !signature.equals(savsign) || (nVersion = StreamUtils.readShort(is)) < 100) continue;
                    long time = StreamUtils.readLong(is);
                    String savname = StreamUtils.readString(is, 32);
                    Main.game.pSavemgr.add(savname, time, (FileEntry)file);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        Main.game.pSavemgr.sort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int lsReadLoadData(FileEntry file) {
        if (file.exists()) {
            ArtEntry pic = Main.engine.getTile(SaveManager.Screenshot);
            if (!(pic instanceof DynamicArtEntry) || !pic.exists()) {
                pic = Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            try (InputStream is = file.getInputStream();){
                int nVersion = Tekldsv.checkSave(is) & 0xFFFF;
                lsInf.clear();
                if (nVersion == 103) {
                    Tekldsv.lsInf.date = Main.game.date.getDate(StreamUtils.readLong(is));
                    StreamUtils.skip(is, 32);
                    lsInf.read(is);
                    if (is.available() <= 16000) {
                        int n = -1;
                        return n;
                    }
                    ((DynamicArtEntry)pic).copyData(StreamUtils.readBytes(is, 16000));
                    int n = 1;
                    return n;
                }
                Tekldsv.lsInf.info = "Incompatible ver. " + nVersion + " != " + 103;
                int n = -1;
                return n;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        lsInf.clear();
        return -1;
    }

    public static String makeNum(int num) {
        Tekldsv.filenum[3] = (char)(num % 10 + 48);
        Tekldsv.filenum[2] = (char)(num / 10 % 10 + 48);
        Tekldsv.filenum[1] = (char)(num / 100 % 10 + 48);
        Tekldsv.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static int checkSave(InputStream is) throws IOException {
        String signature = StreamUtils.readString(is, 4);
        if (!signature.equals(savsign)) {
            return 0;
        }
        return StreamUtils.readShort(is);
    }

    public static boolean checkfile(InputStream is) throws IOException {
        int nVersion = Tekldsv.checkSave(is);
        if (nVersion != 103) {
            return false;
        }
        return loader.load(is);
    }

    public static void LoadGDXBlock() {
        Main.mUserFlag = Tekldsv.loader.gUserMap ? Main.UserFlag.UserMap : Main.UserFlag.None;
        Main.boardfilename = Main.game.getCache().getEntry(Tekldsv.loader.boardfilename, true);
    }

    public static void load() {
        int i;
        Tekmap.mission = Tekldsv.loader.mission;
        Globals.gDifficulty = Tekldsv.loader.difficulty;
        Tekldsv.LoadGDXBlock();
        Tekldsv.PlayerLoad();
        Tekldsv.MapLoad();
        Tekldsv.SectorLoad();
        Tekldsv.AnimationLoad();
        Main.screenpeek = Mmulti.myconnectindex;
        Main.lockclock = Tekldsv.loader.lockclock;
        Main.engine.srand(Tekldsv.loader.randomseed);
        Main.hours = Tekldsv.loader.hours;
        Main.minutes = Tekldsv.loader.minutes;
        Main.seconds = Tekldsv.loader.seconds;
        Engine.visibility = Tekldsv.loader.visibility;
        Engine.parallaxtype = Tekldsv.loader.parallaxtype;
        TekRenderer renderer = Main.game.getRenderer();
        renderer.setParallaxOffset(Tekldsv.loader.parallaxyoffs);
        System.arraycopy(Tekldsv.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        Engine.pskybits = Tekldsv.loader.pskybits;
        Engine.parallaxvisibility = Tekldsv.loader.parallaxvisibility;
        Engine.show2dsector.copy(Tekldsv.loader.show2dsector);
        Engine.show2dwall.copy(Tekldsv.loader.show2dwall);
        Engine.show2dsprite.copy(Tekldsv.loader.show2dsprite);
        Engine.automapping = Tekldsv.loader.automapping;
        Tekgun.goreflag = Tekldsv.loader.goreflag;
        View.gViewMode = (byte)3;
        Tekldsv.tektagload();
        System.arraycopy(Tekldsv.loader.spriteXT, 0, Tekprep.spriteXT, 0, Engine.MAXSPRITES);
        Tekldsv.tekloadmissioninfo();
        if (Tekstat.sectflash == null) {
            Tekstat.sectflash = new Tekstat.sectflashtype();
        }
        Tekstat.sectflash.sectnum = 0;
        Tekstat.sectflash.ovis = '\u0000';
        Tekstat.sectflash.step = 0;
        for (i = 0; i < 4; ++i) {
            Tekprep.subwaysound[i] = -1;
        }
        i = Mmulti.connecthead;
        while (i >= 0) {
            Tekprep.initplayersprite((short)i);
            i = Mmulti.connectpoint2[i];
        }
        Main.game.doPrecache(() -> {
            Main.engine.getTimer().setTotalClock(Main.lockclock);
            Main.game.pNet.ototalclock = Main.lockclock;
            Main.game.gPaused = false;
            Main.game.changeScreen(Main.gGameScreen);
            Main.game.pNet.ready2send = true;
            Main.game.nNetMode = BuildGame.NetMode.Single;
            View.showmessage("GAME LOADED");
            if (Tekmap.generalplay == '\u0001') {
                Teksnd.startmusic((int)(7.0 * Math.random()));
            } else if (Tekmap.currentmapno <= 3) {
                Teksnd.menusong(1);
            } else {
                Teksnd.startmusic(Tekmap.mission);
            }
            System.gc();
            Console.out.println("debug: end loadgame()", OsdColor.BLUE);
        });
    }

    public static void tekloadmissioninfo() {
        System.arraycopy(Tekldsv.loader.symbols, 0, Tekmap.symbols, 0, 7);
        System.arraycopy(Tekldsv.loader.symbolsdeposited, 0, Tekmap.symbolsdeposited, 0, 7);
        Tekmap.currentmapno = Tekldsv.loader.currentmapno;
        Tekmap.numlives = Tekldsv.loader.numlives;
        Tekmap.mission_accomplished = Tekldsv.loader.mission_accomplished;
        Tekmap.civillianskilled = Tekldsv.loader.civillianskilled;
        Tekmap.generalplay = Tekldsv.loader.generalplay;
        Tekmap.singlemapmode = Tekldsv.loader.singlemapmode;
        Tekmap.allsymsdeposited = Tekldsv.loader.allsymsdeposited;
        Tekmap.killedsonny = Tekldsv.loader.killedsonny;
    }

    public static void tektagload() {
        Tektag.numanimates = Tekldsv.loader.numanimates;
        System.arraycopy(Tekldsv.loader.animpic, 0, Tektag.animpic, 0, Tektag.numanimates);
        Tektag.numdelayfuncs = Tekldsv.loader.numdelayfuncs;
        System.arraycopy(Tekldsv.loader.delayfunc, 0, Tektag.delayfunc, 0, Tektag.numdelayfuncs);
        System.arraycopy(Tekldsv.loader.onelev, 0, Tektag.onelev, 0, 16);
        Tektag.secnt = Tekldsv.loader.secnt;
        System.arraycopy(Tekldsv.loader.sectoreffect, 0, Tektag.sectoreffect, 0, Engine.MAXSECTORS);
        System.arraycopy(Tekldsv.loader.sexref, 0, Tektag.sexref, 0, Engine.MAXSECTORS);
        Tektag.numdoors = Tekldsv.loader.numdoors;
        System.arraycopy(Tekldsv.loader.doortype, 0, Tektag.doortype, 0, Tektag.numdoors);
        System.arraycopy(Tekldsv.loader.doorxref, 0, Tektag.doorxref, 0, Engine.MAXSECTORS);
        Tektag.numfloordoors = Tekldsv.loader.numfloordoors;
        System.arraycopy(Tekldsv.loader.floordoor, 0, Tektag.floordoor, 0, Tektag.numfloordoors);
        System.arraycopy(Tekldsv.loader.fdxref, 0, Tektag.fdxref, 0, Engine.MAXSECTORS);
        Tektag.numvehicles = Tekldsv.loader.numvehicles;
        System.arraycopy(Tekldsv.loader.sectorvehicle, 0, Tektag.sectorvehicle, 0, Tektag.numvehicles);
        Tektag.clearvehiclesoundindexes();
        System.arraycopy(Tekldsv.loader.elevator, 0, Tektag.elevator, 0, Engine.MAXSECTORS);
        Tektag.sprelevcnt = Tekldsv.loader.sprelevcnt;
        System.arraycopy(Tekldsv.loader.spriteelev, 0, Tektag.spriteelev, 0, Tektag.sprelevcnt);
        Tektag.totalmapsndfx = Tekldsv.loader.totalmapsndfx;
        System.arraycopy(Tekldsv.loader.mapsndfx, 0, Tektag.mapsndfx, 0, Tektag.totalmapsndfx);
        for (int i = 0; i < Tektag.totalmapsndfx; ++i) {
            if (Tektag.mapsndfx[i].type != 2 || Tektag.mapsndfx[i].id == -1) continue;
            Tektag.mapsndfx[i].id = Teksnd.playsound(Tektag.mapsndfx[i].snum, Tektag.mapsndfx[i].x, Tektag.mapsndfx[i].y, Tektag.mapsndfx[i].loops, 8);
        }
    }

    public static void quicksave() {
        if (Player.gPlayer[Mmulti.myconnectindex].health != 0) {
            gQuickSaving = true;
        }
    }

    public static boolean canLoad(FileEntry fil) {
        return fil.load(is -> {
            int nVersion = Tekldsv.checkSave(is) & 0xFFFF;
            if (nVersion != 103) {
                throw new IOException("Wrong file version");
            }
        });
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        FileEntry loadFile = Main.game.pSavemgr.getLast();
        if (Tekldsv.canLoad(loadFile)) {
            Main.game.changeScreen(Main.gLoadingScreen);
            Main.gLoadingScreen.init(() -> {
                if (!Tekldsv.loadgame(loadFile)) {
                    Main.game.setPrevScreen();
                    if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                        View.showmessage("Incompatible version of saved game found!");
                        Main.game.pNet.ready2send = true;
                    }
                }
            });
        }
    }

    public static void PlayerLoad() {
        Mmulti.numplayers = Tekldsv.loader.numplayers;
        System.arraycopy(Tekldsv.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 16);
        for (int i = 0; i < 16; ++i) {
            Player.gPlayer[i].copy(Tekldsv.loader.gPlayer[i]);
            Player.gPlayer[i].pInput.Copy(Tekldsv.loader.gPlayer[i].pInput);
        }
    }

    public static void MapLoad() {
        Main.boardService.setBoard(new Board(null, Tekldsv.loader.sector, Tekldsv.loader.wall, Tekldsv.loader.sprite));
    }

    public static void AnimationLoad() {
        int i;
        for (i = 0; i < 512; ++i) {
            Animate.gAnimationData[i].id = Tekldsv.loader.gAnimationData[i].id;
            Animate.gAnimationData[i].type = Tekldsv.loader.gAnimationData[i].type;
            Animate.gAnimationData[i].ptr = Tekldsv.loader.gAnimationData[i].ptr;
            Animate.gAnimationData[i].goal = Tekldsv.loader.gAnimationData[i].goal;
            Animate.gAnimationData[i].vel = Tekldsv.loader.gAnimationData[i].vel;
            Animate.gAnimationData[i].acc = Tekldsv.loader.gAnimationData[i].acc;
        }
        Animate.gAnimationCount = Tekldsv.loader.gAnimationCount;
        block6: for (i = Animate.gAnimationCount - 1; i >= 0; --i) {
            ANIMATION gAnm = Animate.gAnimationData[i];
            Object object = gAnm.ptr = Animate.getobject(gAnm.id, gAnm.type);
            switch (gAnm.type) {
                case 1: 
                case 2: {
                    Main.game.pInt.setwallinterpolate(gAnm.id, (Wall)object);
                    continue block6;
                }
                case 4: {
                    Main.game.pInt.setfloorinterpolate(gAnm.id, (Sector)object);
                    continue block6;
                }
                case 8: {
                    Main.game.pInt.setceilinterpolate(gAnm.id, (Sector)object);
                }
            }
        }
    }

    public static void SectorLoad() {
        int i;
        System.arraycopy(Tekldsv.loader.rotatespritelist, 0, Tektag.rotatespritelist, 0, Tekldsv.loader.rotatespritelist.length);
        Tektag.rotatespritecnt = Tekldsv.loader.rotatespritecnt;
        System.arraycopy(Tekldsv.loader.warpsectorlist, 0, Tektag.warpsectorlist, 0, Tekldsv.loader.warpsectorlist.length);
        Tektag.warpsectorcnt = Tekldsv.loader.warpsectorcnt;
        System.arraycopy(Tekldsv.loader.xpanningsectorlist, 0, Tektag.xpanningsectorlist, 0, Tekldsv.loader.xpanningsectorlist.length);
        Tektag.xpanningsectorcnt = Tekldsv.loader.xpanningsectorcnt;
        System.arraycopy(Tekldsv.loader.ypanningwalllist, 0, Tektag.ypanningwalllist, 0, Tekldsv.loader.ypanningwalllist.length);
        Tektag.ypanningwallcnt = Tekldsv.loader.ypanningwallcnt;
        System.arraycopy(Tekldsv.loader.floorpanninglist, 0, Tektag.floorpanninglist, 0, Tekldsv.loader.floorpanninglist.length);
        Tektag.floorpanningcnt = Tekldsv.loader.floorpanningcnt;
        System.arraycopy(Tekldsv.loader.dragsectorlist, 0, Tektag.dragsectorlist, 0, Tekldsv.loader.dragsectorlist.length);
        System.arraycopy(Tekldsv.loader.dragxdir, 0, Tektag.dragxdir, 0, Tekldsv.loader.dragxdir.length);
        System.arraycopy(Tekldsv.loader.dragydir, 0, Tektag.dragydir, 0, Tekldsv.loader.dragydir.length);
        Tektag.dragsectorcnt = Tekldsv.loader.dragsectorcnt;
        System.arraycopy(Tekldsv.loader.dragx1, 0, Tektag.dragx1, 0, Tekldsv.loader.dragx1.length);
        System.arraycopy(Tekldsv.loader.dragy1, 0, Tektag.dragy1, 0, Tekldsv.loader.dragy1.length);
        System.arraycopy(Tekldsv.loader.dragx2, 0, Tektag.dragx2, 0, Tekldsv.loader.dragx2.length);
        System.arraycopy(Tekldsv.loader.dragy2, 0, Tektag.dragy2, 0, Tekldsv.loader.dragy2.length);
        System.arraycopy(Tekldsv.loader.dragfloorz, 0, Tektag.dragfloorz, 0, Tekldsv.loader.dragfloorz.length);
        Tektag.swingcnt = Tekldsv.loader.swingcnt;
        for (i = 0; i < 32; ++i) {
            System.arraycopy(Tekldsv.loader.swingwall[i], 0, Tektag.swingwall[i], 0, Tekldsv.loader.swingwall[i].length);
        }
        System.arraycopy(Tekldsv.loader.swingsector, 0, Tektag.swingsector, 0, Tekldsv.loader.swingsector.length);
        System.arraycopy(Tekldsv.loader.swingangopen, 0, Tektag.swingangopen, 0, Tekldsv.loader.swingangopen.length);
        System.arraycopy(Tekldsv.loader.swingangclosed, 0, Tektag.swingangclosed, 0, Tekldsv.loader.swingangclosed.length);
        System.arraycopy(Tekldsv.loader.swingangopendir, 0, Tektag.swingangopendir, 0, Tekldsv.loader.swingangopendir.length);
        System.arraycopy(Tekldsv.loader.swingang, 0, Tektag.swingang, 0, Tekldsv.loader.swingang.length);
        System.arraycopy(Tekldsv.loader.swinganginc, 0, Tektag.swinganginc, 0, Tekldsv.loader.swinganginc.length);
        for (i = 0; i < 32; ++i) {
            System.arraycopy(Tekldsv.loader.swingx[i], 0, Tektag.swingx[i], 0, Tekldsv.loader.swingx[i].length);
        }
        for (i = 0; i < 32; ++i) {
            System.arraycopy(Tekldsv.loader.swingy[i], 0, Tektag.swingy[i], 0, Tekldsv.loader.swingy[i].length);
        }
        System.arraycopy(Tekldsv.loader.revolvesector, 0, Tektag.revolvesector, 0, Tekldsv.loader.revolvesector.length);
        System.arraycopy(Tekldsv.loader.revolveang, 0, Tektag.revolveang, 0, Tekldsv.loader.revolveang.length);
        Tektag.revolvecnt = Tekldsv.loader.revolvecnt;
        for (i = 0; i < 4; ++i) {
            System.arraycopy(Tekldsv.loader.revolvex[i], 0, Tektag.revolvex[i], 0, Tekldsv.loader.revolvex[i].length);
        }
        for (i = 0; i < 4; ++i) {
            System.arraycopy(Tekldsv.loader.revolvey[i], 0, Tektag.revolvey[i], 0, Tekldsv.loader.revolvey[i].length);
        }
        System.arraycopy(Tekldsv.loader.revolvepivotx, 0, Tektag.revolvepivotx, 0, Tekldsv.loader.revolvepivotx.length);
        System.arraycopy(Tekldsv.loader.revolvepivoty, 0, Tektag.revolvepivoty, 0, Tekldsv.loader.revolvepivoty.length);
        for (i = 0; i < 4; ++i) {
            System.arraycopy(Tekldsv.loader.subwaytracksector[i], 0, Tektag.subwaytracksector[i], 0, Tekldsv.loader.subwaytracksector[i].length);
        }
        System.arraycopy(Tekldsv.loader.subwaynumsectors, 0, Tektag.subwaynumsectors, 0, Tekldsv.loader.subwaynumsectors.length);
        Tektag.subwaytrackcnt = Tekldsv.loader.subwaytrackcnt;
        for (i = 0; i < 4; ++i) {
            System.arraycopy(Tekldsv.loader.subwaystop[i], 0, Tektag.subwaystop[i], 0, Tekldsv.loader.subwaystop[i].length);
        }
        System.arraycopy(Tekldsv.loader.subwaystopcnt, 0, Tektag.subwaystopcnt, 0, Tekldsv.loader.subwaystopcnt.length);
        System.arraycopy(Tekldsv.loader.subwaytrackx1, 0, Tektag.subwaytrackx1, 0, Tekldsv.loader.subwaytrackx1.length);
        System.arraycopy(Tekldsv.loader.subwaytracky1, 0, Tektag.subwaytracky1, 0, Tekldsv.loader.subwaytracky1.length);
        System.arraycopy(Tekldsv.loader.subwaytrackx2, 0, Tektag.subwaytrackx2, 0, Tekldsv.loader.subwaytrackx2.length);
        System.arraycopy(Tekldsv.loader.subwaytracky2, 0, Tektag.subwaytracky2, 0, Tekldsv.loader.subwaytracky2.length);
        System.arraycopy(Tekldsv.loader.subwayx, 0, Tektag.subwayx, 0, Tekldsv.loader.subwayx.length);
        System.arraycopy(Tekldsv.loader.subwaygoalstop, 0, Tektag.subwaygoalstop, 0, Tekldsv.loader.subwaygoalstop.length);
        System.arraycopy(Tekldsv.loader.subwayvel, 0, Tektag.subwayvel, 0, Tekldsv.loader.subwayvel.length);
        System.arraycopy(Tekldsv.loader.subwaypausetime, 0, Tektag.subwaypausetime, 0, Tekldsv.loader.subwaypausetime.length);
        System.arraycopy(Tekldsv.loader.waterfountainwall, 0, Tektag.waterfountainwall, 0, Tekldsv.loader.waterfountainwall.length);
        System.arraycopy(Tekldsv.loader.waterfountaincnt, 0, Tektag.waterfountaincnt, 0, Tekldsv.loader.waterfountaincnt.length);
        System.arraycopy(Tekldsv.loader.slimesoundcnt, 0, Tektag.slimesoundcnt, 0, Tekldsv.loader.slimesoundcnt.length);
    }

    public static boolean loadgame(FileEntry fil) {
        return fil.load(is -> {
            Console.out.println("debug: start loadgame()", OsdColor.BLUE);
            boolean status = Tekldsv.checkfile(is);
            if (status) {
                Tekldsv.load();
                if (lastload == null || !lastload.exists()) {
                    lastload = fil;
                }
                return;
            }
            View.showmessage("Incompatible version of saved game found!");
            throw new IOException("Incompatible version of saved game found!");
        });
    }

    public static void SectorSave(OutputStream os) throws IOException {
        int b;
        int a;
        int i;
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Tektag.rotatespritelist[i]);
        }
        StreamUtils.writeShort(os, Tektag.rotatespritecnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Tektag.warpsectorlist[i]);
        }
        StreamUtils.writeShort(os, Tektag.warpsectorcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Tektag.xpanningsectorlist[i]);
        }
        StreamUtils.writeShort(os, Tektag.xpanningsectorcnt);
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, Tektag.ypanningwalllist[i]);
        }
        StreamUtils.writeShort(os, Tektag.ypanningwallcnt);
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, Tektag.floorpanninglist[i]);
        }
        StreamUtils.writeShort(os, Tektag.floorpanningcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Tektag.dragsectorlist[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Tektag.dragxdir[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Tektag.dragydir[i]);
        }
        StreamUtils.writeShort(os, Tektag.dragsectorcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeInt(os, Tektag.dragx1[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeInt(os, Tektag.dragy1[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeInt(os, Tektag.dragx2[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeInt(os, Tektag.dragy2[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeInt(os, Tektag.dragfloorz[i]);
        }
        StreamUtils.writeShort(os, Tektag.swingcnt);
        for (a = 0; a < 32; ++a) {
            for (b = 0; b < 5; ++b) {
                StreamUtils.writeShort(os, Tektag.swingwall[a][b]);
            }
        }
        for (i = 0; i < 32; ++i) {
            StreamUtils.writeShort(os, Tektag.swingsector[i]);
        }
        for (i = 0; i < 32; ++i) {
            StreamUtils.writeShort(os, Tektag.swingangopen[i]);
        }
        for (i = 0; i < 32; ++i) {
            StreamUtils.writeShort(os, Tektag.swingangclosed[i]);
        }
        for (i = 0; i < 32; ++i) {
            StreamUtils.writeShort(os, Tektag.swingangopendir[i]);
        }
        for (i = 0; i < 32; ++i) {
            StreamUtils.writeShort(os, Tektag.swingang[i]);
        }
        for (i = 0; i < 32; ++i) {
            StreamUtils.writeShort(os, Tektag.swinganginc[i]);
        }
        for (a = 0; a < 32; ++a) {
            for (b = 0; b < 8; ++b) {
                StreamUtils.writeInt(os, Tektag.swingx[a][b]);
            }
        }
        for (a = 0; a < 32; ++a) {
            for (b = 0; b < 8; ++b) {
                StreamUtils.writeInt(os, Tektag.swingy[a][b]);
            }
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeShort(os, Tektag.revolvesector[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeShort(os, Tektag.revolveang[i]);
        }
        StreamUtils.writeShort(os, Tektag.revolvecnt);
        for (a = 0; a < 4; ++a) {
            for (b = 0; b < 16; ++b) {
                StreamUtils.writeInt(os, Tektag.revolvex[a][b]);
            }
        }
        for (a = 0; a < 4; ++a) {
            for (b = 0; b < 16; ++b) {
                StreamUtils.writeInt(os, Tektag.revolvey[a][b]);
            }
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.revolvepivotx[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.revolvepivoty[i]);
        }
        for (a = 0; a < 4; ++a) {
            for (b = 0; b < 128; ++b) {
                StreamUtils.writeShort(os, Tektag.subwaytracksector[a][b]);
            }
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeShort(os, Tektag.subwaynumsectors[i]);
        }
        StreamUtils.writeShort(os, Tektag.subwaytrackcnt);
        for (a = 0; a < 4; ++a) {
            for (b = 0; b < 8; ++b) {
                StreamUtils.writeInt(os, Tektag.subwaystop[a][b]);
            }
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.subwaystopcnt[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.subwaytrackx1[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.subwaytracky1[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.subwaytrackx2[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.subwaytracky2[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.subwayx[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.subwaygoalstop[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.subwayvel[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Tektag.subwaypausetime[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Tektag.waterfountainwall[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Tektag.waterfountaincnt[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Tektag.slimesoundcnt[i]);
        }
    }

    public static void PlayerSave(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, Mmulti.numplayers);
        for (int i = 0; i < 16; ++i) {
            Player.gPlayer[i].writeObject(os);
            Player.gPlayer[i].pInput.writeObject(os);
        }
    }

    public static void MapSave(OutputStream os) throws IOException {
        Board board = Main.boardService.getBoard();
        Sector[] sectors = board.getSectors();
        StreamUtils.writeInt(os, sectors.length);
        for (Sector s : sectors) {
            s.writeObject(os);
        }
        Wall[] walls = board.getWalls();
        StreamUtils.writeInt(os, walls.length);
        for (Wall wal : walls) {
            wal.writeObject(os);
        }
        List<Sprite> sprites = board.getSprites();
        StreamUtils.writeInt(os, sprites.size());
        for (Sprite s : sprites) {
            s.writeObject(os);
        }
    }

    public static void AnimationSave(OutputStream os) throws IOException {
        for (int i = 0; i < 512; ++i) {
            StreamUtils.writeShort(os, Animate.gAnimationData[i].id);
            StreamUtils.writeByte(os, Animate.gAnimationData[i].type);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].goal);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].vel);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].acc);
        }
        StreamUtils.writeInt(os, Animate.gAnimationCount);
    }

    public static void SaveVersion(OutputStream os, int nVersion) throws IOException {
        StreamUtils.writeString(os, savsign);
        StreamUtils.writeShort(os, nVersion);
    }

    public static void SaveGDXBlock(OutputStream os) throws IOException {
        if (Main.gGameScreen.captBuffer != null) {
            StreamUtils.writeBytes(os, Main.gGameScreen.captBuffer);
        } else {
            StreamUtils.writeBytes(os, new byte[16000]);
        }
        Main.gGameScreen.captBuffer = null;
        StreamUtils.writeByte(os, Main.mUserFlag == Main.UserFlag.UserMap ? 1 : 0);
        if (Main.boardfilename != null && Main.boardfilename.exists()) {
            if (Main.boardfilename instanceof FileEntry) {
                StreamUtils.writeString(os, ((FileEntry)Main.boardfilename).getPath().toString(), 144);
            } else {
                StreamUtils.writeString(os, Main.boardfilename.getName(), 144);
            }
        } else {
            StreamUtils.writeString(os, "", 144);
        }
    }

    public static void SaveHeader(OutputStream os, String savename, long time) throws IOException {
        Tekldsv.SaveVersion(os, 103);
        StreamUtils.writeLong(os, time);
        StreamUtils.writeString(os, savename, 32);
        StreamUtils.writeInt(os, Tekmap.mission);
        StreamUtils.writeInt(os, Globals.gDifficulty);
    }

    public static void savegame(Directory dir, String savename, String filename) {
        block9: {
            FileEntry file = dir.getEntry(filename);
            if (file.exists() && !file.delete()) {
                View.showmessage("Game not saved. Access denied!");
                return;
            }
            Path path = dir.getPath().resolve(filename);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                long time = Main.game.date.getCurrentDate();
                Tekldsv.save(os, savename, time);
                file = dir.addEntry(path);
                if (file.exists()) {
                    Main.game.pSavemgr.add(savename, time, file);
                    lastload = file;
                    View.showmessage("GAME SAVED");
                    break block9;
                }
                throw new FileNotFoundException(filename);
            }
            catch (Exception e) {
                View.showmessage("Game not saved! " + e);
            }
        }
    }

    public static void save(OutputStream os, String savename, long time) throws IOException {
        Tekldsv.SaveHeader(os, savename, time);
        Tekldsv.SaveGDXBlock(os);
        Tekldsv.PlayerSave(os);
        Tekldsv.MapSave(os);
        Tekldsv.SectorSave(os);
        Tekldsv.AnimationSave(os);
        StreamUtils.writeInt(os, Main.engine.getrand());
        StreamUtils.writeInt(os, Main.hours);
        StreamUtils.writeInt(os, Main.minutes);
        StreamUtils.writeInt(os, Main.seconds);
        StreamUtils.writeInt(os, Main.lockclock);
        StreamUtils.writeByte(os, Engine.parallaxtype);
        TekRenderer renderer = Main.game.getRenderer();
        StreamUtils.writeInt(os, renderer.getParallaxOffset());
        for (int i = 0; i < 256; ++i) {
            StreamUtils.writeShort(os, Engine.pskyoff[i]);
        }
        StreamUtils.writeShort(os, Engine.pskybits);
        StreamUtils.writeInt(os, Engine.visibility);
        StreamUtils.writeInt(os, Engine.parallaxvisibility);
        Engine.show2dsector.writeObject(os);
        Engine.show2dwall.writeObject(os);
        Engine.show2dsprite.writeObject(os);
        StreamUtils.writeByte(os, Engine.automapping);
        StreamUtils.writeByte(os, Tekgun.goreflag ? 1 : 0);
        Tekldsv.tektagsave(os);
        Tekldsv.tekstatsave(os);
        Tekldsv.teksavemissioninfo(os);
    }

    public static void tekstatsave(OutputStream os) throws IOException {
        for (int i = 0; i < Engine.MAXSPRITES; ++i) {
            Tekprep.spriteXT[i].writeObject(os);
        }
    }

    public static void teksavemissioninfo(OutputStream os) throws IOException {
        int i;
        for (i = 0; i < 7; ++i) {
            StreamUtils.writeByte(os, Tekmap.symbols[i] ? 1 : 0);
        }
        for (i = 0; i < 7; ++i) {
            StreamUtils.writeByte(os, Tekmap.symbolsdeposited[i] ? 1 : 0);
        }
        StreamUtils.writeInt(os, Tekmap.currentmapno);
        StreamUtils.writeByte(os, Tekmap.numlives);
        StreamUtils.writeByte(os, Tekmap.mission_accomplished);
        StreamUtils.writeInt(os, Tekmap.civillianskilled);
        StreamUtils.writeByte(os, Tekmap.generalplay);
        StreamUtils.writeByte(os, Tekmap.singlemapmode);
        StreamUtils.writeInt(os, Tekmap.allsymsdeposited);
        StreamUtils.writeInt(os, Tekmap.killedsonny);
    }

    public static void tektagsave(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeInt(os, Tektag.numanimates);
        for (i = 0; i < Tektag.numanimates; ++i) {
            Tektag.animpic[i].writeObject(os);
        }
        StreamUtils.writeShort(os, Tektag.numdelayfuncs);
        for (i = 0; i < Tektag.numdelayfuncs; ++i) {
            Tektag.delayfunc[i].writeObject(os);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeByte(os, (byte)(Tektag.onelev[i] ? 1 : 0));
        }
        StreamUtils.writeInt(os, Tektag.secnt);
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            Tektag.sectoreffect[i].writeObject(os);
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            StreamUtils.writeInt(os, Tektag.sexref[i]);
        }
        StreamUtils.writeInt(os, Tektag.numdoors);
        for (i = 0; i < Tektag.numdoors; ++i) {
            Tektag.doortype[i].writeObject(os);
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            StreamUtils.writeInt(os, Tektag.doorxref[i]);
        }
        StreamUtils.writeInt(os, Tektag.numfloordoors);
        for (i = 0; i < Tektag.numfloordoors; ++i) {
            Tektag.floordoor[i].writeObject(os);
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            StreamUtils.writeInt(os, Tektag.fdxref[i]);
        }
        StreamUtils.writeInt(os, Tektag.numvehicles);
        for (i = 0; i < Tektag.numvehicles; ++i) {
            Tektag.sectorvehicle[i].writeObject(os);
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            Tektag.elevator[i].writeObject(os);
        }
        StreamUtils.writeInt(os, Tektag.sprelevcnt);
        for (i = 0; i < Tektag.sprelevcnt; ++i) {
            Tektag.spriteelev[i].writeObject(os);
        }
        StreamUtils.writeInt(os, Tektag.totalmapsndfx);
        for (i = 0; i < Tektag.totalmapsndfx; ++i) {
            Tektag.mapsndfx[i].writeObject(os);
        }
    }

    static {
        lsInf = new LSInfo();
        quickslot = 0;
        loader = new SafeLoader();
    }
}

