/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Actor {
    public static final Animator DoActorDebris = new Animator(Actor::DoActorDebris);

    public static void DoScaleSprite(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (u.scale_speed != 0) {
            u.scale_value += u.scale_speed * 6;
            int scale_value = u.scale_value >> 8;
            if (u.scale_speed > 0) {
                if (scale_value > u.scale_tgt) {
                    u.scale_speed = 0;
                } else {
                    sp.setXrepeat(scale_value);
                    sp.setYrepeat(scale_value);
                }
            } else if (scale_value < u.scale_tgt) {
                u.scale_speed = 0;
            } else {
                sp.setXrepeat(scale_value);
                sp.setYrepeat(scale_value);
            }
        }
    }

    public static void DoActorDie(int SpriteNum, int weapon) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Sprites.change_sprite_stat(SpriteNum, 3);
        u.Flags |= Gameutils.SPR_DEAD;
        u.Flags &= ~(Gameutils.SPR_FALLING | Gameutils.SPR_JUMPING);
        u.floor_dist = Gameutils.Z(40);
        sp.setExtra(sp.getExtra() | Gameutils.SPRX_BREAKABLE);
        sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_BREAKABLE);
        if (weapon < 0) {
            switch (weapon) {
                case -9: 
                case -8: {
                    Sprites.ChangeState(SpriteNum, u.StateEnd);
                    u.RotNum = 0;
                }
            }
            return;
        }
        WangSprite wp = Main.boardService.getSprite(weapon);
        USER wu = Gameutils.getUser(weapon);
        if (wp == null || wu == null) {
            return;
        }
        WangSprite targetSpr = Main.boardService.getSprite(u.tgt_sp);
        block3 : switch (wu.ID) {
            case 1400: {
                Sprites.ChangeState(SpriteNum, u.StateEnd);
                u.RotNum = 0;
                sp.setXvel(sp.getXvel() << 1);
                u.ActorActionFunc = null;
                sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024));
                break;
            }
            case 4096: {
                if (u.ID == 4096) {
                    if (wu.WeaponNum != 0) {
                        Weapon.InitPlasmaFountain(wp, SpriteNum);
                        Weapon.InitPlasmaFountain(wp, SpriteNum);
                        Sound.PlaySound(430, sp, 0);
                        Sprites.ChangeState(SpriteNum, Ninja.s_NinjaDieSliced[0]);
                    } else {
                        if (Gameutils.RANDOM_RANGE(1000) > 500) {
                            Weapon.InitPlasmaFountain(Main.boardService.getSprite(weapon), SpriteNum);
                        }
                        Sprites.ChangeState(SpriteNum, u.StateEnd);
                        u.RotNum = 0;
                        u.ActorActionFunc = null;
                        sp.setXvel(200 + Gameutils.RANDOM_RANGE(200));
                        u.jump_speed = -200 - Gameutils.RANDOM_RANGE(250);
                        Actor.DoActorBeginJump(SpriteNum);
                        sp.setAng(wp.getAng());
                    }
                } else {
                    if (Gameutils.RANDOM_RANGE(1000) > 500) {
                        sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YFLIP);
                    }
                    Sprites.ChangeState(SpriteNum, u.StateEnd);
                    sp.setXvel(0);
                    u.jump_speed = 0;
                    Actor.DoActorBeginJump(SpriteNum);
                }
                u.RotNum = 0;
                u.ActorActionFunc = null;
                sp.setAng(wp.getAng());
                break;
            }
            case 1210: 
            case 1367: 
            case 1580: 
            case 2049: 
            case 3780: 
            case 4277: 
            case 4320: {
                Sprites.ChangeState(SpriteNum, u.StateEnd);
                u.RotNum = 0;
                break;
            }
            case 2146: {
                if (Gameutils.RANDOM_RANGE(1000) > 500) {
                    sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YFLIP);
                }
                Sprites.ChangeState(SpriteNum, u.StateEnd);
                u.RotNum = 0;
                if (u.ID == 1580 || u.ID == 4320) {
                    sp.setXvel(sp.getXvel() << 1);
                    u.jump_speed = -100 - Gameutils.RANDOM_RANGE(250);
                    Actor.DoActorBeginJump(SpriteNum);
                } else {
                    sp.setXvel(0);
                    u.jump_speed = -10 - Gameutils.RANDOM_RANGE(25);
                    Actor.DoActorBeginJump(SpriteNum);
                }
                u.ActorActionFunc = null;
                if (targetSpr == null) break;
                sp.setAng(Gameutils.NORM_ANGLE(EngineUtils.getAngle(targetSpr.getX() - sp.getX(), targetSpr.getY() - sp.getY()) + 1024));
                break;
            }
            case 2147: {
                if (Gameutils.RANDOM_RANGE(1000) > 500) {
                    sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YFLIP);
                }
                Sprites.ChangeState(SpriteNum, u.StateEnd);
                u.RotNum = 0;
                if (u.ID == 1580 || u.ID == 4320) {
                    sp.setXvel(75 + Gameutils.RANDOM_RANGE(100));
                    u.jump_speed = -100 - Gameutils.RANDOM_RANGE(150);
                } else {
                    sp.setXvel(100 + Gameutils.RANDOM_RANGE(200));
                    u.jump_speed = -100 - Gameutils.RANDOM_RANGE(250);
                }
                Actor.DoActorBeginJump(SpriteNum);
                u.ActorActionFunc = null;
                if (targetSpr == null) break;
                sp.setAng(Gameutils.NORM_ANGLE(EngineUtils.getAngle(targetSpr.getX() - sp.getX(), targetSpr.getY() - sp.getY()) + 1024));
                break;
            }
            default: {
                switch (u.ID) {
                    case 817: 
                    case 820: {
                        Sprites.ChangeState(SpriteNum, u.StateEnd);
                        break block3;
                    }
                }
                if (Gameutils.RANDOM_RANGE(1000) > 700) {
                    Weapon.InitPlasmaFountain(Main.boardService.getSprite(weapon), SpriteNum);
                }
                if (Gameutils.RANDOM_RANGE(1000) > 500) {
                    sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YFLIP);
                }
                Sprites.ChangeState(SpriteNum, u.StateEnd);
                u.RotNum = 0;
                u.ActorActionFunc = null;
                sp.setXvel(300 + Gameutils.RANDOM_RANGE(400));
                u.jump_speed = -300 - Gameutils.RANDOM_RANGE(350);
                Actor.DoActorBeginJump(SpriteNum);
                sp.setAng(wp.getAng());
            }
        }
        switch (u.ID) {
            case 1210: 
            case 1400: 
            case 4320: 
            case 5426: {
                sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YFLIP);
            }
        }
        u.ID = 0;
    }

    public static void DoDebrisCurrent(int spnum) {
        int ny;
        WangSprite sp = Main.boardService.getSprite(spnum);
        USER u = Gameutils.getUser(spnum);
        if (sp == null || u == null) {
            return;
        }
        Sect_User sectu = Sector.getSectUser(sp.getSectnum());
        if (sectu == null) {
            return;
        }
        int nx = (int)((long)MyTypes.DIV4(sectu.speed) * (long)EngineUtils.sin(Gameutils.NORM_ANGLE(sectu.ang + 512)) >> 14);
        int ret = Sprites.move_sprite(spnum, nx, ny = (int)((long)MyTypes.DIV4(sectu.speed) * (long)EngineUtils.sin(sectu.ang) >> 14), 0, u.ceiling_dist, u.floor_dist, 0, 6);
        if (ret != 0) {
            int rang = Gameutils.RANDOM_P2(2048);
            nx = (int)((long)MyTypes.DIV4(sectu.speed) * (long)EngineUtils.sin(Gameutils.NORM_ANGLE(sectu.ang + rang + 512)) >> 14);
            ny = (int)((long)MyTypes.DIV4(sectu.speed) * (long)EngineUtils.sin(Gameutils.NORM_ANGLE(sectu.ang + rang)) >> 14);
            Sprites.move_sprite(spnum, nx, ny, 0, u.ceiling_dist, u.floor_dist, 0, 6);
        }
        sp.setZ(u.loz);
    }

    public static boolean DoActorSectorDamage(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sp.getSectnum());
        Sect_User sectu = Sector.getSectUser(sp.getSectnum());
        if (u.Health <= 0) {
            return false;
        }
        if (sectu != null && sectu.damage != 0) {
            if (MyTypes.TEST(sectu.flags, Gameutils.SECTFU_DAMAGE_ABOVE_SECTOR)) {
                if ((u.DamageTics -= 3) < 0) {
                    u.DamageTics = 60;
                    u.Health -= sectu.damage;
                    if (u.Health <= 0) {
                        Weapon.UpdateSinglePlayKills(SpriteNum, null);
                        Actor.DoActorDie(SpriteNum, -8);
                        return true;
                    }
                }
            } else if (sectp != null && Gameutils.SPRITEp_BOS(sp) >= sectp.getFloorz() && (u.DamageTics -= 3) < 0) {
                u.DamageTics = 60;
                u.Health -= sectu.damage;
                if (u.Health <= 0) {
                    Weapon.UpdateSinglePlayKills(SpriteNum, null);
                    Actor.DoActorDie(SpriteNum, -8);
                    return true;
                }
            }
        }
        if (u.lo_sectp != -1 && u.hi_sectp != -1 && Pragmas.klabs(u.loz - u.hiz) < MyTypes.DIV2(Gameutils.SPRITE_SIZE_Z(SpriteNum))) {
            u.Health = 0;
            if (Shrap.SpawnShrap(SpriteNum, -9)) {
                Weapon.UpdateSinglePlayKills(SpriteNum, null);
                Weapon.SetSuicide(SpriteNum);
            }
            return true;
        }
        return false;
    }

    private static boolean move_debris(int SpriteNum, int xchange, int ychange) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return false;
        }
        u.moveSpriteReturn = Sprites.move_sprite(SpriteNum, xchange, ychange, 0, u.ceiling_dist, u.floor_dist, 0, 6);
        return u.moveSpriteReturn == 0;
    }

    public static void DoActorDebris(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sp.getSectnum());
        sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        switch (u.ID) {
            case 800: 
            case 4550: {
                Sprites.KillSprite(SpriteNum);
                return;
            }
            case 5426: {
                Main.engine.getzsofslope(sp.getSectnum(), sp.getX(), sp.getY(), Rooms.fz, Rooms.cz);
                u.hiz = Rooms.cz.get();
                u.loz = Rooms.fz.get();
                u.lo_sectp = sp.getSectnum();
                u.hi_sectp = sp.getSectnum();
                u.lo_sp = -1;
                u.hi_sp = -1;
            }
        }
        if (sectp != null && MyTypes.TEST(sectp.getExtra(), Gameutils.SECTFX_SINK)) {
            if (MyTypes.TEST(sectp.getExtra(), Gameutils.SECTFX_CURRENT)) {
                Actor.DoDebrisCurrent(SpriteNum);
            } else {
                int ny;
                int nx = 6 * EngineUtils.cos(sp.getAng()) >> 14;
                if (!Actor.move_debris(SpriteNum, nx, ny = 6 * EngineUtils.sin(sp.getAng()) >> 14)) {
                    sp.setAng(Gameutils.RANDOM_P2(2048));
                }
            }
            Sect_User su = Sector.getSectUser(sp.getSectnum());
            if (su != null && su.depth > 10) {
                u.WaitTics = u.WaitTics + 48 & 0x3FF;
                sp.setZ(u.loz - (Gameutils.Z(2) * EngineUtils.sin(u.WaitTics) >> 14));
            }
        } else {
            sp.setZ(u.loz);
        }
    }

    public static void DoFireFly(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int nx = 24 * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        int ny = 24 * EngineUtils.sin(sp.getAng()) >> 14;
        sp.setClipdist(64);
        if (!Sprites.move_actor(SpriteNum, nx, ny, 0)) {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024));
        }
        u.WaitTics = u.WaitTics + 12 & 0x7FF;
        sp.setZ(u.sz + (Gameutils.Z(32) * EngineUtils.sin(u.WaitTics) >> 14));
    }

    public static void KeepActorOnFloor(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sp.getSectnum());
        sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YFLIP);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            return;
        }
        int depth = 0;
        Sect_User losu = Sector.getSectUser(u.lo_sectp);
        if (u.lo_sectp != -1 && losu != null) {
            depth = losu.depth;
        }
        if (sectp != null && MyTypes.TEST(sectp.getExtra(), Gameutils.SECTFX_SINK) && depth > 35 && u.ActorActionSet != null && u.ActorActionSet.Swim != null) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_SWIMMING)) {
                if (u.getRot() != u.ActorActionSet.Run && u.getRot() != u.ActorActionSet.Swim && u.getRot() != u.ActorActionSet.Stand) {
                    u.Flags &= ~Gameutils.SPR_SWIMMING;
                    sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
                    u.oz = u.loz;
                    sp.setZ(u.loz);
                    return;
                }
                if (u.getRot() == u.ActorActionSet.Run) {
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Swim);
                }
                u.oz = u.loz - Gameutils.Z(depth);
                sp.setZ(u.oz);
            } else if (u.getRot() == u.ActorActionSet.Run || u.getRot() == u.ActorActionSet.Swim) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Swim);
                u.oz = u.loz - Gameutils.Z(depth);
                sp.setZ(u.oz);
                u.Flags |= Gameutils.SPR_SWIMMING;
                sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
            } else {
                u.Flags &= ~Gameutils.SPR_SWIMMING;
                sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
                u.oz = u.loz;
                sp.setZ(u.oz);
            }
            return;
        }
        u.Flags &= ~Gameutils.SPR_SWIMMING;
        sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_MOVED)) {
            u.oz = u.loz;
        } else {
            Rooms.FAFgetzrangepoint(sp.getX(), sp.getY(), sp.getZ(), sp.getSectnum(), Game.tmp_ptr[0], Game.tmp_ptr[1], Game.tmp_ptr[2].set(0), Game.tmp_ptr[3]);
            u.oz = Game.tmp_ptr[2].value;
        }
        sp.setZ(u.oz);
    }

    public static void DoActorBeginSlide(int SpriteNum, int ang, int vel, int dec) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.Flags |= Gameutils.SPR_SLIDING;
            u.slide_ang = ang;
            u.slide_vel = vel;
            u.slide_dec = dec;
        }
    }

    public static boolean DoActorSlide(int SpriteNum) {
        int ny;
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return false;
        }
        int nx = u.slide_vel * EngineUtils.sin(Gameutils.NORM_ANGLE(u.slide_ang + 512)) >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny = u.slide_vel * EngineUtils.sin(u.slide_ang) >> 14, 0)) {
            u.Flags &= ~Gameutils.SPR_SLIDING;
            return false;
        }
        u.slide_vel -= u.slide_dec * 6;
        if (u.slide_vel < 20) {
            u.Flags &= ~Gameutils.SPR_SLIDING;
        }
        return true;
    }

    public static void DoActorBeginJump(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = 8;
        if (u.ActorActionSet != null) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_DEAD)) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.DeathJump);
            } else {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Jump);
            }
        }
        u.StateFallOverride = null;
    }

    public static void DoActorJump(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int jump_adj = u.jump_grav * 6;
        if ((u.jump_speed += jump_adj) > 0) {
            Actor.DoActorBeginFall(SpriteNum);
            return;
        }
        sp.setZ(sp.getZ() + u.jump_speed * 6);
        if (sp.getZ() < u.hiz + Gameutils.Z(Gameutils.PIC_SIZY(SpriteNum))) {
            sp.setZ(u.hiz + Gameutils.Z(Gameutils.PIC_SIZY(SpriteNum)));
            u.jump_speed = -u.jump_speed;
            Actor.DoActorBeginFall(SpriteNum);
        }
    }

    public static void DoActorBeginFall(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        u.Flags |= Gameutils.SPR_FALLING;
        u.Flags &= ~Gameutils.SPR_JUMPING;
        u.jump_grav = 8;
        if (u.ActorActionSet != null) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_DEAD)) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.DeathFall);
            } else {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Fall);
            }
            if (u.StateFallOverride != null) {
                Sprites.NewStateGroup(SpriteNum, u.StateFallOverride);
            }
        }
        Actor.DoActorFall(SpriteNum);
    }

    public static void DoActorFall(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.jump_speed += u.jump_grav * 6;
        sp.setZ(sp.getZ() + u.jump_speed * 6);
        if (sp.getZ() > u.loz) {
            Actor.DoActorStopFall(SpriteNum);
        }
    }

    public static void DoActorStopFall(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        sp.setZ(u.loz);
        u.Flags &= ~(Gameutils.SPR_FALLING | Gameutils.SPR_JUMPING);
        sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YFLIP);
        WangSprite loSpr = Main.boardService.getSprite(u.lo_sp);
        if (loSpr != null && !MyTypes.TEST(loSpr.getCstat(), Gameutils.CSTAT_SPRITE_FLOOR)) {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024 + (Gameutils.RANDOM_P2(131072) >> 8)));
            u.jump_speed = -350;
            Actor.DoActorBeginJump(SpriteNum);
            return;
        }
        if (u.ActorActionSet != null) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_DEAD)) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Dead);
                Sound.PlaySound(73, sp, 0);
            } else {
                Sound.PlaySound(74, sp, 0);
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
                if (u.track >= 0 && u.jump_speed > 800 && u.ActorActionSet.Sit != null) {
                    u.WaitTics = 80;
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Sit);
                }
            }
        }
    }

    public static void DoActorDeathMove(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        int nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        int ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14;
        sp.setClipdist(48);
        Sprites.move_actor(SpriteNum, nx, ny, 0);
        Weapon.DoFindGroundPoint(SpriteNum);
    }

    public static void DoBeginJump(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = 8;
        Actor.DoJump(SpriteNum);
    }

    public static void DoJump(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int jump_adj = u.jump_grav * 6;
        if ((u.jump_speed += jump_adj) > 0) {
            Actor.DoBeginFall(SpriteNum);
            return;
        }
        sp.setZ(sp.getZ() + u.jump_speed * 6);
        if (sp.getZ() < u.hiz + Gameutils.Z(Gameutils.PIC_SIZY(SpriteNum))) {
            sp.setZ(u.hiz + Gameutils.Z(Gameutils.PIC_SIZY(SpriteNum)));
            u.jump_speed = -u.jump_speed;
            Actor.DoBeginFall(SpriteNum);
        }
    }

    public static void DoBeginFall(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        u.Flags |= Gameutils.SPR_FALLING;
        u.Flags &= ~Gameutils.SPR_JUMPING;
        u.jump_grav = 8;
        Actor.DoFall(SpriteNum);
    }

    public static void DoFall(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.jump_speed += u.jump_grav * 6;
        sp.setZ(sp.getZ() + u.jump_speed * 6);
        if (sp.getZ() > u.loz - u.floor_dist) {
            sp.setZ(u.loz - u.floor_dist);
            u.Flags &= ~Gameutils.SPR_FALLING;
        }
    }
}

