/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.util.Arrays;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Light;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.Break_Info;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Break {
    public static final int BF_TOUGH = MyTypes.BIT(0);
    public static final int BF_KILL = MyTypes.BIT(1);
    public static final int BF_BURN = MyTypes.BIT(2);
    public static final int BF_OVERRIDE_BLOCK = MyTypes.BIT(3);
    public static final int BF_FIRE_FALL = MyTypes.BIT(4);
    public static final int BF_LEAVE_BREAK = MyTypes.BIT(5);
    public static final int SHRAP_GLASS = 1;
    public static final int SHRAP_TREE_BARK = 2;
    public static final int SHRAP_PAPER = 4;
    public static final int SHRAP_BLOOD = 5;
    public static final int SHRAP_EXPLOSION = 6;
    public static final int SHRAP_LARGE_EXPLOSION = 7;
    public static final int SHRAP_METAL = 8;
    public static final int SHRAP_STONE = 9;
    public static final int SHRAP_PLANT = 10;
    public static final int SHRAP_GIBS = 11;
    public static final int SHRAP_WOOD = 12;
    public static final int SHRAP_GENERIC = 13;
    public static final int SHRAP_COIN = 15;
    public static final int SHRAP_METALMIX = 16;
    public static final int SHRAP_WOODMIX = 17;
    public static final int SHRAP_MARBELS = 18;
    public static final int SHRAP_PAPERMIX = 19;
    public static Break_Info GlobBreakInfo;
    public static final Break_Info[] WallBreakInfo;
    public static final Break_Info[] SpriteBreakInfo;

    public static Break_Info FindWallBreakInfo(Object picnum) {
        int i = Arrays.binarySearch(WallBreakInfo, picnum);
        if (i >= 0) {
            return WallBreakInfo[i];
        }
        return null;
    }

    public static Break_Info FindSpriteBreakInfo(Object picnum) {
        int i = Arrays.binarySearch(SpriteBreakInfo, picnum);
        if (i >= 0) {
            return SpriteBreakInfo[i];
        }
        return null;
    }

    public static void SortBreakInfo() {
        Arrays.sort(SpriteBreakInfo);
        Arrays.sort(WallBreakInfo);
    }

    public static void SetupWallForBreak(Wall WALL) {
        Break_Info break_info = Break.FindWallBreakInfo(WALL.getPicnum());
        if (break_info != null) {
            WALL.setLotag(307);
            WALL.setExtra(WALL.getExtra() | Gameutils.WALLFX_DONT_STICK);
            if (break_info.breaknum >= 0) {
                Gameutils.SET_GOTPIC(break_info.breaknum);
            }
        }
        if (WALL.getOverpicnum() > 0 && MyTypes.TEST(WALL.getCstat(), Gameutils.CSTAT_WALL_MASKED) && (break_info = Break.FindWallBreakInfo(WALL.getOverpicnum())) != null) {
            WALL.setLotag(307);
            WALL.setExtra(WALL.getExtra() | Gameutils.WALLFX_DONT_STICK);
        }
    }

    public static void SetupSpriteForBreak(Sprite sp) {
        short picnum = sp.getPicnum();
        if (sp.getLotag() == 257) {
            return;
        }
        Break_Info break_info = Break.FindSpriteBreakInfo(picnum);
        if (break_info != null) {
            if (MyTypes.TEST(break_info.flags, BF_OVERRIDE_BLOCK) && !MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_BLOCK)) {
                return;
            }
            if (MyTypes.TEST(break_info.flags, BF_BURN)) {
                sp.setExtra(sp.getExtra() | Gameutils.SPRX_BURNABLE);
            } else {
                sp.setExtra(sp.getExtra() | Gameutils.SPRX_BREAKABLE);
            }
            sp.setClipdist(Gameutils.SPRITEp_SIZE_X(sp));
            sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_BREAKABLE);
            if (break_info.breaknum >= 0) {
                Gameutils.SET_GOTPIC(break_info.breaknum);
            }
        }
    }

    public static int FindBreakSpriteMatch(int match) {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(45); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (Gameutils.SP_TAG2(sp) != match || sp.getPicnum() != 2307) continue;
            return node.getIndex();
        }
        return -1;
    }

    public static void AutoBreakWall(Wall WALL, int hitx, int hity, int hitz, int ang, int type) {
        int BreakSprite;
        WangSprite bsp;
        Break_Info break_info;
        Wall nwp;
        WALL.setLotag(0);
        if (WALL.getNextwall() >= 0 && (nwp = Main.boardService.getWall(WALL.getNextwall())) != null && nwp.getLotag() == 307 && nwp.getOverpicnum() > 0 && MyTypes.TEST(nwp.getCstat(), Gameutils.CSTAT_WALL_MASKED)) {
            nwp.setLotag(0);
        }
        if ((break_info = WALL.getOverpicnum() > 0 && MyTypes.TEST(WALL.getCstat(), Gameutils.CSTAT_WALL_MASKED) ? Break.FindWallBreakInfo(WALL.getOverpicnum()) : Break.FindWallBreakInfo(WALL.getPicnum())) == null) {
            return;
        }
        if (!Weapon.CheckBreakToughness(break_info, type)) {
            return;
        }
        if (hitx != Integer.MAX_VALUE && (bsp = Main.boardService.getSprite(BreakSprite = Rooms.COVERinsertsprite(0, 0))) != null) {
            bsp.setCstat(0);
            bsp.setExtra(0);
            bsp.setAng(ang);
            bsp.setPicnum(2307);
            bsp.setXrepeat(64);
            bsp.setYrepeat(64);
            Main.engine.setspritez(BreakSprite, hitx, hity, hitz);
            GlobBreakInfo = break_info;
            Shrap.SpawnShrap(BreakSprite, -1);
            GlobBreakInfo = null;
            Sprites.KillSprite(BreakSprite);
        }
        if (WALL.getOverpicnum() > 0 && MyTypes.TEST(WALL.getCstat(), Gameutils.CSTAT_WALL_MASKED)) {
            if (break_info.breaknum == -1) {
                Wall nwp2;
                WALL.setCstat(WALL.getCstat() & ~(Gameutils.CSTAT_WALL_MASKED | Gameutils.CSTAT_WALL_1WAY | Gameutils.CSTAT_WALL_BLOCK_HITSCAN | Gameutils.CSTAT_WALL_BLOCK));
                WALL.setOverpicnum(0);
                if (WALL.getNextwall() >= 0 && (nwp2 = Main.boardService.getWall(WALL.getNextwall())) != null) {
                    nwp2.setCstat(nwp2.getCstat() & ~(Gameutils.CSTAT_WALL_MASKED | Gameutils.CSTAT_WALL_1WAY | Gameutils.CSTAT_WALL_BLOCK_HITSCAN | Gameutils.CSTAT_WALL_BLOCK));
                    nwp2.setOverpicnum(0);
                }
            } else {
                Wall nwp3;
                WALL.setCstat(WALL.getCstat() & ~(Gameutils.CSTAT_WALL_BLOCK_HITSCAN | Gameutils.CSTAT_WALL_BLOCK));
                WALL.setOverpicnum(break_info.breaknum);
                if (WALL.getNextwall() >= 0 && (nwp3 = Main.boardService.getWall(WALL.getNextwall())) != null) {
                    nwp3.setCstat(nwp3.getCstat() & ~(Gameutils.CSTAT_WALL_BLOCK_HITSCAN | Gameutils.CSTAT_WALL_BLOCK));
                    nwp3.setOverpicnum(break_info.breaknum);
                }
            }
        } else if (break_info.breaknum == -1) {
            WALL.setPicnum(594);
        } else {
            WALL.setPicnum(break_info.breaknum);
            if (WALL.getHitag() < 0) {
                Break.DoWallBreakSpriteMatch(WALL.getHitag());
            }
        }
    }

    public static void UserBreakWall(Wall wp) {
        short match = wp.getHitag();
        int block_flags = Gameutils.CSTAT_WALL_BLOCK | Gameutils.CSTAT_WALL_BLOCK_HITSCAN;
        int type_flags = Gameutils.CSTAT_WALL_TRANSLUCENT | Gameutils.CSTAT_WALL_MASKED | Gameutils.CSTAT_WALL_1WAY;
        int flags = block_flags | type_flags;
        int SpriteNum = Break.FindBreakSpriteMatch(match);
        if (SpriteNum == -1) {
            Wall nw;
            Sector.DoSpawnSpotsForKill(match);
            wp.setCstat(wp.getCstat() & ~flags);
            wp.setLotag(0);
            wp.setHitag(0);
            if (wp.getNextwall() >= 0 && (nw = Main.boardService.getWall(wp.getNextwall())) != null) {
                nw.setCstat(nw.getCstat() & ~flags);
                nw.setLotag(0);
                nw.setHitag(0);
            }
            return;
        }
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (wp.getPicnum() == Gameutils.SP_TAG5(sp)) {
            return;
        }
        if (Gameutils.SP_TAG7(sp) <= 1) {
            Sector.DoSpawnSpotsForKill(match);
            Light.DoLightingMatch(match, -1);
            if (Gameutils.SP_TAG8(sp) == 0) {
                Wall nw;
                wp.setPicnum(Gameutils.SP_TAG5(sp));
                wp.setLotag(0);
                wp.setHitag(0);
                if (wp.getNextwall() >= 0 && (nw = Main.boardService.getWall(wp.getNextwall())) != null) {
                    nw.setLotag(0);
                    nw.setHitag(0);
                }
            } else if (Gameutils.SP_TAG8(sp) == 1) {
                Wall nw;
                wp.setCstat(wp.getCstat() & ~flags);
                wp.setLotag(0);
                wp.setHitag(0);
                if (wp.getNextwall() >= 0 && (nw = Main.boardService.getWall(wp.getNextwall())) != null) {
                    nw.setCstat(nw.getCstat() & ~flags);
                    nw.setLotag(0);
                    nw.setHitag(0);
                }
            } else if (Gameutils.SP_TAG8(sp) == 2) {
                Wall nw;
                wp.setPicnum(Gameutils.SP_TAG5(sp));
                wp.setCstat(wp.getCstat() & ~block_flags);
                wp.setLotag(0);
                wp.setHitag(0);
                if (wp.getNextwall() >= 0 && (nw = Main.boardService.getWall(wp.getNextwall())) != null) {
                    nw.setLotag(0);
                    nw.setHitag(0);
                    nw.setCstat(nw.getCstat() & ~block_flags);
                }
            }
        } else {
            wp.setPicnum(wp.getPicnum() + 1);
            Sector.DoSpawnSpotsForDamage(match);
        }
    }

    public static boolean WallBreakPosition(int w, LONGp resultSectnum, LONGp resultX, LONGp resultY, LONGp resultZ, LONGp resultAng) {
        Wall wp = Main.boardService.getWall(w);
        if (wp == null) {
            return false;
        }
        Wall nw = wp.getWall2();
        int wall_ang = Gameutils.NORM_ANGLE(EngineUtils.getAngle(nw.getX() - wp.getX(), nw.getY() - wp.getY()) + 512);
        resultSectnum.value = Break.SectorOfWall(w);
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(resultSectnum.value);
        if (sec == null) {
            return false;
        }
        resultX.value = MyTypes.DIV2(wp.getX() + wp.getX());
        resultY.value = MyTypes.DIV2(wp.getY() + wp.getY());
        if (wp.getNextwall() == -1) {
            resultZ.value = MyTypes.DIV2(sec.getFloorz() + sec.getCeilingz());
        } else {
            ru.m210projects.Build.Types.Sector nextSec = Main.boardService.getSector(wp.getNextsector());
            if (nextSec != null) {
                if (nextSec.getFloorz() == nextSec.getCeilingz()) {
                    resultZ.value = MyTypes.DIV2(sec.getFloorz() + sec.getCeilingz());
                } else if (nextSec.getFloorz() < sec.getFloorz()) {
                    resultZ.value = MyTypes.DIV2(nextSec.getFloorz() + sec.getFloorz());
                } else if (nextSec.getCeilingz() > sec.getCeilingz()) {
                    resultZ.value = MyTypes.DIV2(nextSec.getCeilingz() + sec.getCeilingz());
                }
            }
        }
        resultAng.value = wall_ang;
        int nx = Gameutils.MOVEx(128, wall_ang);
        int ny = Gameutils.MOVEy(128, wall_ang);
        resultX.value += nx;
        resultY.value += ny;
        resultSectnum.value = Main.engine.updatesectorz(resultX.value, resultY.value, resultZ.value, resultSectnum.value);
        if (resultSectnum.value == -1) {
            resultX.value = Integer.MAX_VALUE;
            return false;
        }
        return true;
    }

    public static void HitBreakWall(int wp, int hitx, int hity, int hitz, int ang, int type) {
        Wall wall = Main.boardService.getWall(wp);
        if (wall == null) {
            return;
        }
        short match = wall.getHitag();
        if (match > 0) {
            Break.UserBreakWall(wall);
            return;
        }
        Break.WallBreakPosition(wp, Game.tmp_ptr[4], Game.tmp_ptr[0].set(hitx), Game.tmp_ptr[1].set(hity), Game.tmp_ptr[2].set(hitz), Game.tmp_ptr[3].set(ang));
        hitx = Game.tmp_ptr[0].value;
        hity = Game.tmp_ptr[1].value;
        hitz = Game.tmp_ptr[2].value;
        ang = Game.tmp_ptr[3].value;
        Break.AutoBreakWall(wall, hitx, hity, hitz, ang, type);
    }

    public static void KillBreakSprite(int BreakSprite) {
        WangSprite bp = Main.boardService.getSprite(BreakSprite);
        USER bu = Gameutils.getUser(BreakSprite);
        Weapon.SpriteQueueDelete(BreakSprite);
        if (bu != null) {
            if (bp != null && bp.getStatnum() == 0) {
                Sprites.KillSprite(BreakSprite);
            } else {
                Weapon.SetSuicide(BreakSprite);
            }
        } else {
            Sprites.change_sprite_stat(BreakSprite, 48);
        }
    }

    public static boolean UserBreakSprite(int BreakSprite) {
        WangSprite bp = Main.boardService.getSprite(BreakSprite);
        if (bp == null) {
            return false;
        }
        short match = bp.getLotag();
        int SpriteNum = Break.FindBreakSpriteMatch(match);
        if (SpriteNum == -1) {
            Sector.DoMatchEverything(null, match, -1);
            Sound.DeleteNoSoundOwner(BreakSprite);
            Break.KillBreakSprite(BreakSprite);
            return true;
        }
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return false;
        }
        int match_extra = Gameutils.SP_TAG6(bp);
        if (bp.getPicnum() == Gameutils.SP_TAG5(sp)) {
            return true;
        }
        if (Gameutils.SP_TAG7(sp) <= 1) {
            Sector.DoMatchEverything(null, match_extra, -1);
            Light.DoLightingMatch(match_extra, 0);
            if (Gameutils.SP_TAG8(sp) == 0) {
                bp.setPicnum(Gameutils.SP_TAG5(sp));
                bp.setExtra(bp.getExtra() & ~Gameutils.SPRX_BREAKABLE);
            } else {
                if (Gameutils.SP_TAG8(sp) == 1) {
                    Sound.DeleteNoSoundOwner(BreakSprite);
                    Break.KillBreakSprite(BreakSprite);
                    return true;
                }
                if (Gameutils.SP_TAG8(sp) == 2) {
                    bp.setPicnum(Gameutils.SP_TAG5(sp));
                    if (Gameutils.SP_TAG8(sp) == 2) {
                        bp.setCstat(bp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                    }
                    bp.setExtra(bp.getExtra() & ~Gameutils.SPRX_BREAKABLE);
                }
            }
        } else {
            bp.setPicnum(bp.getPicnum() + 1);
            Sector.DoSpawnSpotsForDamage(match_extra);
        }
        return false;
    }

    public static boolean AutoBreakSprite(int BreakSprite, int type) {
        WangSprite bp = Main.boardService.getSprite(BreakSprite);
        if (bp == null) {
            return false;
        }
        Break_Info break_info = Break.FindSpriteBreakInfo(bp.getPicnum());
        if (bp.getHitag() < 0) {
            Break.DoWallBreakMatch(bp.getHitag());
        }
        if (break_info == null) {
            return false;
        }
        if (!Weapon.CheckBreakToughness(break_info, type)) {
            if (break_info.breaknum != -1) {
                if (!MyTypes.TEST(break_info.flags, BF_LEAVE_BREAK)) {
                    bp.setExtra(bp.getExtra() & ~Gameutils.SPRX_BREAKABLE);
                    bp.setCstat(bp.getCstat() & ~Gameutils.CSTAT_SPRITE_BREAKABLE);
                }
                bp.setPicnum(break_info.breaknum);
                GlobBreakInfo = break_info;
                Shrap.SpawnShrap(BreakSprite, -1);
                GlobBreakInfo = null;
                if (bp.getPicnum() == 3683) {
                    bp.setCstat(bp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                }
            }
            return false;
        }
        bp.setExtra(bp.getExtra() & ~Gameutils.SPRX_BREAKABLE);
        bp.setCstat(bp.getCstat() & ~Gameutils.CSTAT_SPRITE_BREAKABLE);
        GlobBreakInfo = break_info;
        Shrap.SpawnShrap(BreakSprite, -1);
        GlobBreakInfo = null;
        if (MyTypes.TEST(break_info.flags, BF_KILL) || break_info.breaknum == -1) {
            if (MyTypes.TEST(break_info.flags, BF_FIRE_FALL)) {
                Weapon.SpawnBreakFlames(BreakSprite);
            }
            bp.setCstat(bp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
            bp.setCstat(bp.getCstat() | Gameutils.CSTAT_SPRITE_INVISIBLE);
            Sound.DeleteNoSoundOwner(BreakSprite);
            Break.KillBreakSprite(BreakSprite);
            return true;
        }
        bp.setPicnum(break_info.breaknum);
        if (bp.getPicnum() == 3683) {
            bp.setCstat(bp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        }
        return false;
    }

    public static boolean NullActor(USER u) {
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SO_ATTACHED)) {
            return true;
        }
        if (u.State == null) {
            return true;
        }
        return u.ActorActionFunc == null;
    }

    public static boolean HitBreakSprite(int BreakSprite, int type) {
        WangSprite bp = Main.boardService.getSprite(BreakSprite);
        if (bp == null) {
            return false;
        }
        if (Gameutils.TEST_BOOL1(bp)) {
            if (Gameutils.TEST_BOOL2(bp)) {
                return false;
            }
            return Break.UserBreakSprite(BreakSprite);
        }
        USER bu = Gameutils.getUser(BreakSprite);
        if (bu != null && !Break.NullActor(bu)) {
            if (bp.getLotag() != 0) {
                Light.DoLightingMatch(bp.getLotag(), -1);
            }
            Shrap.SpawnShrap(BreakSprite, -1);
            bp.setExtra(bp.getExtra() & ~Gameutils.SPRX_BREAKABLE);
            return false;
        }
        return Break.AutoBreakSprite(BreakSprite, type);
    }

    public static int SectorOfWall(int theline) {
        int sectnum = -1;
        ru.m210projects.Build.Types.Sector[] sectors = Main.boardService.getBoard().getSectors();
        for (int i = 0; i < sectors.length; ++i) {
            short startwall = sectors[i].getWallptr();
            int endwall = sectors[i].getEndWall();
            if (theline < startwall || theline > endwall) continue;
            sectnum = i;
            break;
        }
        return sectnum;
    }

    public static void DoWallBreakMatch(int match) {
        Wall[] walls = Main.boardService.getBoard().getWalls();
        for (int i = 0; i < walls.length; ++i) {
            Wall wal = walls[i];
            if (wal == null || wal.getHitag() != match) continue;
            Break.WallBreakPosition(i, Game.tmp_ptr[4], Game.tmp_ptr[0].set(0), Game.tmp_ptr[1].set(0), Game.tmp_ptr[2].set(0), Game.tmp_ptr[3].set(0));
            int x = Game.tmp_ptr[0].value;
            int y = Game.tmp_ptr[1].value;
            int z = Game.tmp_ptr[2].value;
            int wall_ang = Game.tmp_ptr[3].value;
            wal.setHitag(0);
            Break.AutoBreakWall(wal, x, y, z, wall_ang, 0);
        }
    }

    public static void DoWallBreakSpriteMatch(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(2);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (sp.getHitag() == match) {
                Sprites.KillSprite(node.getIndex());
            }
            node = nexti;
        }
    }

    static {
        WallBreakInfo = new Break_Info[]{new Break_Info(60, -1, 8, BF_KILL), new Break_Info(82, -1, 8, BF_KILL), new Break_Info(1, 3593, 8), new Break_Info(253, 255, 1), new Break_Info(254, 255, 1), new Break_Info(282, -1, 1), new Break_Info(283, 4974, 8), new Break_Info(318, 599, 1), new Break_Info(486, -1, 8), new Break_Info(487, 3676, 8), new Break_Info(628, 3585, 8), new Break_Info(630, 3586, 8), new Break_Info(633, 608, 1), new Break_Info(634, 608, 1), new Break_Info(637, 3587, 8), new Break_Info(640, 3588, 8), new Break_Info(641, 3588, 8), new Break_Info(665, 3588, 8), new Break_Info(742, 3589, 15), new Break_Info(743, 3590, 15), new Break_Info(750, 608, 1), new Break_Info(2667, 608, 1), new Break_Info(2769, 3681, 1), new Break_Info(2676, 3591, 1), new Break_Info(2677, 3592, 1), new Break_Info(2687, 2727, 1), new Break_Info(2688, 2728, 1), new Break_Info(2732, 3594, 1), new Break_Info(2777, 3683, 8), new Break_Info(2778, 2757, 1), new Break_Info(2801, 3591, 1), new Break_Info(2804, 3595, 1), new Break_Info(2807, 3596, 1), new Break_Info(2810, 4989, 8), new Break_Info(4890, 4910, 8), new Break_Info(4891, 4911, 8), new Break_Info(4892, 4912, 8), new Break_Info(4893, 4913, 8), new Break_Info(4894, 4914, 8), new Break_Info(4895, 4915, 8), new Break_Info(3336, 4940, 15), new Break_Info(3337, 4941, 15), new Break_Info(4885, 4888, 8), new Break_Info(4887, 4889, 15), new Break_Info(3350, 4942, 1), new Break_Info(3351, 4943, 8), new Break_Info(3352, 4944, 8), new Break_Info(3353, 4945, 8), new Break_Info(4896, 4898, 8), new Break_Info(4897, 4899, 8), new Break_Info(3385, 4981, 16), new Break_Info(3389, 4982, 16), new Break_Info(3393, 4984, 16), new Break_Info(3397, 4983, 16), new Break_Info(3401, 4985, 16), new Break_Info(3405, 4986, 16), new Break_Info(3409, 4988, 16), new Break_Info(3413, 4987, 16), new Break_Info(253, 255, 16), new Break_Info(283, 4974, 16), new Break_Info(299, 4975, 16), new Break_Info(5078, 5079, 16), new Break_Info(5080, 5092, 18), new Break_Info(5083, 5093, 18), new Break_Info(5086, 5094, 18), new Break_Info(5089, 5095, 18), new Break_Info(4970, 4973, 8), new Break_Info(297, 4980, 8), new Break_Info(1, 4976, 8), new Break_Info(4917, 4918, 8), new Break_Info(4902, 4903, 8)};
        SpriteBreakInfo = new Break_Info[]{new Break_Info(60, -1, 8, BF_KILL), new Break_Info(82, -1, 8, BF_KILL), new Break_Info(138, -1, 13, BF_KILL), new Break_Info(253, 255, 1), new Break_Info(254, 255, 1), new Break_Info(270, -1, 4, BF_BURN), new Break_Info(271, -1, 4, BF_BURN), new Break_Info(272, -1, 12), new Break_Info(274, -1, 4, BF_BURN), new Break_Info(282, -1, 1), new Break_Info(283, -1, 8), new Break_Info(297, -1, 8), new Break_Info(299, -1, 8), new Break_Info(363, -1, 8, BF_KILL), new Break_Info(365, -1, 9, BF_TOUGH | BF_KILL), new Break_Info(366, -1, 8, BF_KILL, 5), new Break_Info(367, -1, 12, BF_KILL), new Break_Info(368, -1, 11, BF_KILL), new Break_Info(369, -1, 12, BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(371, -1, 12, BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(372, -1, 12, BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(374, -1, 9, BF_TOUGH | BF_KILL), new Break_Info(375, -1, 9, BF_TOUGH | BF_KILL), new Break_Info(376, -1, 12, BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(377, -1, 9, BF_KILL), new Break_Info(379, -1, 12, BF_KILL), new Break_Info(380, -1, 8, BF_KILL | BF_FIRE_FALL), new Break_Info(385, -1, 5, BF_KILL), new Break_Info(386, -1, 11, BF_KILL), new Break_Info(387, -1, 11, BF_KILL), new Break_Info(388, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(391, -1, 11, BF_KILL), new Break_Info(392, -1, 11, BF_KILL), new Break_Info(393, -1, 12, BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(394, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(395, -1, 11, BF_KILL), new Break_Info(396, -1, 8, BF_KILL | BF_FIRE_FALL), new Break_Info(397, -1, 8, BF_KILL | BF_FIRE_FALL), new Break_Info(398, -1, 8, BF_KILL | BF_FIRE_FALL), new Break_Info(399, -1, 8, BF_KILL | BF_FIRE_FALL), new Break_Info(400, -1, 13, BF_KILL), new Break_Info(401, -1, 12, BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(402, -1, 12, BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(407, -1, 8, BF_KILL), new Break_Info(408, -1, 4, BF_BURN), new Break_Info(409, -1, 4, BF_BURN), new Break_Info(415, -1, 8, BF_KILL | BF_FIRE_FALL, 5), new Break_Info(418, -1, 13, BF_KILL | BF_FIRE_FALL, 5), new Break_Info(422, -1, 8, BF_KILL), new Break_Info(423, -1, 5, BF_KILL), new Break_Info(424, -1, 5, BF_KILL), new Break_Info(425, -1, 5, BF_KILL), new Break_Info(428, -1, 8, BF_BURN), new Break_Info(430, -1, 9, BF_KILL | BF_FIRE_FALL), new Break_Info(431, -1, 9, BF_KILL | BF_FIRE_FALL), new Break_Info(432, -1, 9, BF_KILL | BF_FIRE_FALL), new Break_Info(433, -1, 9, BF_KILL | BF_FIRE_FALL), new Break_Info(434, -1, 9, BF_KILL | BF_FIRE_FALL), new Break_Info(435, -1, 9, BF_KILL | BF_FIRE_FALL), new Break_Info(436, -1, 9, BF_KILL | BF_FIRE_FALL), new Break_Info(437, -1, 9, BF_KILL | BF_FIRE_FALL), new Break_Info(438, -1, 11, BF_KILL), new Break_Info(441, -1, 12, BF_KILL), new Break_Info(442, -1, 9, BF_KILL), new Break_Info(443, -1, 9, BF_KILL | BF_FIRE_FALL), new Break_Info(453, -1, 12, BF_KILL), new Break_Info(458, -1, 9, BF_KILL), new Break_Info(459, -1, 9, BF_KILL), new Break_Info(460, -1, 8, BF_KILL), new Break_Info(461, -1, 8, BF_KILL), new Break_Info(462, -1, 8, BF_KILL), new Break_Info(463, -1, 9, BF_KILL), new Break_Info(467, -1, 9, BF_KILL), new Break_Info(468, -1, 12, BF_KILL), new Break_Info(475, -1, 1, BF_KILL), new Break_Info(481, -1, 13, BF_KILL), new Break_Info(482, -1, 12, BF_KILL), new Break_Info(483, -1, 12, BF_KILL | BF_TOUGH), new Break_Info(491, -1, 12, BF_KILL), new Break_Info(492, -1, 8, BF_KILL), new Break_Info(493, -1, 8, BF_KILL), new Break_Info(498, -1, 13, BF_KILL), new Break_Info(500, -1, 8, BF_KILL), new Break_Info(501, -1, 8, BF_KILL), new Break_Info(504, -1, 8, BF_KILL, 5), new Break_Info(505, -1, 5, BF_KILL, 5), new Break_Info(506, -1, 13, BF_KILL, 5), new Break_Info(507, -1, 1, BF_KILL), new Break_Info(508, -1, 1, BF_KILL), new Break_Info(509, -1, 1, BF_KILL), new Break_Info(510, -1, 1, BF_KILL), new Break_Info(511, -1, 8, BF_KILL), new Break_Info(512, -1, 8, BF_KILL | BF_FIRE_FALL, 5), new Break_Info(516, -1, 12, BF_BURN), new Break_Info(517, -1, 12, BF_BURN), new Break_Info(518, -1, 12, BF_BURN), new Break_Info(519, -1, 12, BF_FIRE_FALL | BF_KILL, 5), new Break_Info(520, -1, 12, BF_KILL), new Break_Info(521, -1, 12, BF_KILL | BF_FIRE_FALL), new Break_Info(537, -1, 8, BF_KILL | BF_FIRE_FALL), new Break_Info(541, -1, 12, BF_KILL | BF_FIRE_FALL), new Break_Info(586, -1, 8, BF_KILL), new Break_Info(590, -1, 8, BF_KILL), new Break_Info(591, -1, 8, BF_KILL), new Break_Info(593, 608, 1, BF_TOUGH), new Break_Info(604, -1, 8, BF_KILL), new Break_Info(613, -1, 7, BF_KILL), new Break_Info(614, -1, 8, BF_KILL), new Break_Info(615, -1, 8, BF_KILL), new Break_Info(618, -1, 1, BF_KILL), new Break_Info(646, -1, 8, BF_KILL), new Break_Info(647, -1, 7, BF_KILL), new Break_Info(648, -1, 7, BF_KILL), new Break_Info(649, -1, 8, BF_KILL), new Break_Info(656, -1, 8, BF_KILL), new Break_Info(657, -1, 8, BF_KILL), new Break_Info(658, -1, 7, BF_KILL), new Break_Info(659, -1, 8, BF_KILL, 5), new Break_Info(663, -1, 8, BF_KILL, 10), new Break_Info(664, -1, 8, BF_KILL, 5), new Break_Info(666, -1, 10, BF_KILL), new Break_Info(670, -1, 8, BF_KILL | BF_FIRE_FALL), new Break_Info(671, -1, 1, BF_KILL | BF_FIRE_FALL), new Break_Info(673, -1, 5, BF_KILL), new Break_Info(674, -1, 11, BF_KILL), new Break_Info(675, -1, 11, BF_KILL), new Break_Info(676, -1, 11, BF_KILL), new Break_Info(678, -1, 1, BF_KILL, 5), new Break_Info(679, -1, 1, BF_KILL, 5), new Break_Info(683, -1, 1, BF_KILL, 5), new Break_Info(684, -1, 1, BF_KILL, 5), new Break_Info(685, -1, 1, BF_KILL, 5), new Break_Info(686, -1, 4, BF_KILL, 5), new Break_Info(687, -1, 9, BF_KILL | BF_TOUGH), new Break_Info(688, -1, 9, BF_KILL | BF_TOUGH), new Break_Info(690, -1, 12, BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(692, -1, 12, BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(695, -1, 9, BF_KILL), new Break_Info(696, -1, 9, BF_KILL), new Break_Info(697, -1, 9, BF_KILL), new Break_Info(698, -1, 9, BF_KILL), new Break_Info(699, -1, 9, BF_TOUGH | BF_KILL), new Break_Info(702, -1, 9, BF_TOUGH | BF_KILL), new Break_Info(703, -1, 9, BF_TOUGH | BF_KILL), new Break_Info(704, -1, 9, BF_TOUGH | BF_KILL), new Break_Info(706, -1, 10, BF_KILL), new Break_Info(707, -1, 10, BF_KILL), new Break_Info(710, -1, 10, BF_KILL), new Break_Info(711, -1, 10, BF_KILL), new Break_Info(714, -1, 9, BF_KILL, 5), new Break_Info(721, -1, 11, BF_KILL), new Break_Info(722, -1, 11, BF_KILL), new Break_Info(723, -1, 11, BF_KILL), new Break_Info(724, -1, 11, BF_KILL), new Break_Info(725, -1, 10, BF_KILL), new Break_Info(730, -1, 13, BF_KILL), new Break_Info(744, -1, 1, BF_KILL, 5), new Break_Info(2563, -1, 4, BF_BURN), new Break_Info(2564, -1, 4, BF_BURN), new Break_Info(3570, -1, 12, BF_TOUGH | BF_BURN), new Break_Info(3571, -1, 12, BF_TOUGH | BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(3572, -1, 12, BF_TOUGH | BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(3573, -1, 12, BF_TOUGH | BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(3574, -1, 12, BF_TOUGH | BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(3575, -1, 12, BF_TOUGH | BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(3576, -1, 12, BF_TOUGH | BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(3577, -1, 12, BF_TOUGH | BF_KILL), new Break_Info(3578, -1, 12, BF_TOUGH | BF_KILL), new Break_Info(3579, -1, 12, BF_TOUGH | BF_KILL), new Break_Info(3580, -1, 12, BF_TOUGH | BF_KILL), new Break_Info(3581, -1, 12, BF_TOUGH | BF_BURN), new Break_Info(3582, -1, 12, BF_TOUGH | BF_BURN), new Break_Info(2640, -1, 9, BF_KILL, 5), new Break_Info(2641, -1, 9, BF_KILL), new Break_Info(2642, -1, 9, BF_KILL), new Break_Info(2680, -1, 13, BF_KILL), new Break_Info(2681, -1, 13, BF_KILL), new Break_Info(2682, -1, 13, BF_KILL), new Break_Info(2683, -1, 13, BF_KILL), new Break_Info(2684, -1, 13, BF_KILL), new Break_Info(2685, -1, 13, BF_KILL), new Break_Info(2687, 2727, 1), new Break_Info(2688, 2728, 1), new Break_Info(2699, -1, 12, BF_KILL), new Break_Info(2709, -1, 12, BF_TOUGH | BF_KILL), new Break_Info(2720, -1, 11, BF_KILL), new Break_Info(2721, -1, 11, BF_KILL), new Break_Info(2722, -1, 11, BF_KILL), new Break_Info(2723, -1, 11, BF_KILL), new Break_Info(2724, -1, 11, BF_KILL), new Break_Info(2725, -1, 5, BF_KILL), new Break_Info(2726, -1, 5, BF_KILL), new Break_Info(2719, -1, 1, BF_KILL), new Break_Info(2750, -1, 12, BF_KILL), new Break_Info(2676, 3591, 1), new Break_Info(2769, 3681, 1), new Break_Info(2777, 3683, 8, BF_TOUGH), new Break_Info(2778, 2757, 1), new Break_Info(3448, 3451, 8, BF_TOUGH | BF_KILL), new Break_Info(3449, -1, 4, BF_KILL), new Break_Info(3497, -1, 13, BF_KILL | BF_TOUGH), new Break_Info(3551, -1, 8, BF_KILL), new Break_Info(3552, -1, 8, BF_KILL), new Break_Info(3553, -1, 8, BF_KILL), new Break_Info(3554, -1, 8, BF_KILL), new Break_Info(3555, -1, 8, BF_KILL), new Break_Info(3556, -1, 8, BF_KILL), new Break_Info(3557, -1, 8, BF_KILL), new Break_Info(3558, -1, 12, BF_KILL), new Break_Info(3568, -1, 12, BF_BURN), new Break_Info(4994, -1, 8, BF_KILL), new Break_Info(4995, -1, 8, BF_KILL), new Break_Info(5010, -1, 12, BF_TOUGH | BF_BURN | BF_OVERRIDE_BLOCK), new Break_Info(5017, -1, 4, BF_KILL), new Break_Info(5018, -1, 4, BF_KILL), new Break_Info(5019, -1, 4, BF_KILL), new Break_Info(5060, -1, 8, BF_KILL), new Break_Info(5061, -1, 8, BF_KILL), new Break_Info(5073, -1, 11, BF_KILL), new Break_Info(4218, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(1133, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(1134, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(811, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(1440, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(1512, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(1643, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(1680, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(4226, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(4236, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(4421, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(4312, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(766, -1, 15, BF_KILL), new Break_Info(767, -1, 15, BF_KILL), new Break_Info(2700, -1, 4, BF_KILL), new Break_Info(2701, -1, 4, BF_KILL), new Break_Info(2702, -1, 4, BF_KILL), new Break_Info(2703, -1, 4, BF_KILL), new Break_Info(2704, -1, 4, BF_KILL), new Break_Info(2705, -1, 4, BF_KILL), new Break_Info(2218, -1, 8, BF_KILL), new Break_Info(689, -1, 8, BF_TOUGH | BF_KILL), new Break_Info(3354, -1, 8, BF_KILL), new Break_Info(3357, -1, 4, BF_KILL), new Break_Info(4886, -1, 1, BF_KILL), new Break_Info(646, 708, 8, BF_TOUGH | BF_KILL), new Break_Info(708, -1, 8, BF_TOUGH | BF_KILL), new Break_Info(656, -1, 8, BF_KILL), new Break_Info(663, -1, 8, BF_KILL), new Break_Info(664, -1, 8, BF_KILL), new Break_Info(691, -1, 8, BF_KILL), new Break_Info(5021, -1, 11, BF_KILL), new Break_Info(712, -1, 7, BF_KILL), new Break_Info(713, -1, 7, BF_KILL), new Break_Info(693, -1, 17, BF_KILL | BF_TOUGH), new Break_Info(5041, -1, 11, BF_KILL), new Break_Info(5042, 5077, 11, BF_TOUGH | BF_KILL), new Break_Info(5077, -1, 12, BF_TOUGH | BF_KILL), new Break_Info(3356, 3358, 12, BF_TOUGH | BF_KILL), new Break_Info(3358, -1, 12, BF_TOUGH | BF_KILL), new Break_Info(900, -1, 11, BF_KILL), new Break_Info(901, -1, 11, BF_KILL), new Break_Info(902, -1, 11, BF_KILL), new Break_Info(915, -1, 11, BF_KILL), new Break_Info(916, -1, 11, BF_KILL), new Break_Info(917, -1, 11, BF_KILL), new Break_Info(930, -1, 11, BF_KILL), new Break_Info(931, -1, 11, BF_KILL), new Break_Info(932, -1, 11, BF_KILL), new Break_Info(1670, -1, 11, BF_KILL), new Break_Info(2219, -1, 8, BF_KILL | BF_TOUGH), new Break_Info(4768, -1, 1, BF_KILL), new Break_Info(4792, -1, 1, BF_KILL), new Break_Info(4816, -1, 1, BF_KILL), new Break_Info(4840, -1, 1, BF_KILL), new Break_Info(4584, -1, 11, BF_KILL), new Break_Info(5062, -1, 12, BF_KILL | BF_TOUGH), new Break_Info(5063, 4947, 19, BF_KILL | BF_TOUGH | BF_LEAVE_BREAK), new Break_Info(4947, -1, 19, BF_KILL | BF_TOUGH), new Break_Info(1160, -1, 11, BF_KILL | BF_TOUGH), new Break_Info(5104, -1, 11, BF_KILL), new Break_Info(3795, -1, 11, BF_KILL), new Break_Info(470, -1, 11, BF_KILL), new Break_Info(5205, -1, 11, BF_KILL | BF_TOUGH)};
    }
}

