/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Ripper;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Bunny {
    public static final int BUNNY_RUN_RATE = 10;
    public static final int BUNNY_STAND_RATE = 12;
    public static final int BUNNY_SCREW_RATE = 16;
    public static final int BUNNY_SWIPE_RATE = 8;
    public static final Animator NullBunny = new Animator(Bunny::NullBunny);
    public static final int BUNNY_HEART_RATE = 14;
    public static final int BUNNY_PAIN_RATE = 38;
    public static final Animator DoBunnyPain = new Animator(Bunny::DoBunnyPain);
    public static final int BUNNY_JUMP_RATE = 25;
    public static final Animator DoBunnyMoveJump = new Animator(Bunny::DoBunnyMoveJump);
    public static final int BUNNY_FALL_RATE = 25;
    public static final Animator DoBunnyBeginJumpAttack = new Animator(Bunny::DoBunnyBeginJumpAttack);
    public static final int BUNNY_DIE_RATE = 16;
    public static final Animator BunnySpew = new Animator(Bunny::BunnySpew);
    public static final int BUNNY_DEAD_RATE = 8;
    public static final Animator DoActorDeathMove = new Animator(Actor::DoActorDeathMove);
    private static final Decision[] BunnyBattle = new Decision[]{new Decision(748, Ai.InitActorMoveCloser), new Decision(750, Ai.InitActorAlertNoise), new Decision(760, Ai.InitActorAttackNoise), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] BunnyOffense = new Decision[]{new Decision(600, Ai.InitActorMoveCloser), new Decision(700, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] BunnyBroadcast = new Decision[]{new Decision(21, Ai.InitActorAlertNoise), new Decision(51, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] BunnySurprised = new Decision[]{new Decision(500, Ai.InitActorRunAway), new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] BunnyEvasive = new Decision[]{new Decision(500, Ai.InitActorWanderAround), new Decision(1020, Ai.InitActorRunAway), new Decision(1024, Ai.InitActorAmbientNoise)};
    private static final Decision[] BunnyLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] BunnyCloseRange = new Decision[]{new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] BunnyWander = new Decision[]{new Decision(1024, Ai.InitActorReposition)};
    private static final Personality WhiteBunnyPersonality = new Personality(BunnyBattle, BunnyOffense, BunnyBroadcast, BunnySurprised, BunnyEvasive, BunnyLostTarget, BunnyCloseRange, BunnyCloseRange);
    private static final Personality BunnyPersonality = new Personality(BunnyEvasive, BunnyEvasive, BunnyEvasive, BunnyWander, BunnyWander, BunnyWander, BunnyEvasive, BunnyEvasive);
    private static final ATTRIBUTE BunnyAttrib = new ATTRIBUTE(new short[]{100, 120, 140, 180}, new short[]{5, 0, -2, -4}, 3, new int[]{428, 0, 424, 424, 426, 0, 0, 0, 0, 0});
    private static final ATTRIBUTE WhiteBunnyAttrib = new ATTRIBUTE(new short[]{200, 220, 340, 380}, new short[]{5, 0, -2, -4}, 3, new int[]{428, 0, 424, 424, 426, 0, 0, 0, 0, 0});
    private static final State[][] s_BunnyPain = new State[][]{{new State(4575, 38, DoBunnyPain).setNext()}, {new State(4575, 38, DoBunnyPain).setNext()}, {new State(4575, 38, DoBunnyPain).setNext()}, {new State(4575, 38, DoBunnyPain).setNext()}, {new State(4575, 38, DoBunnyPain).setNext()}};
    private static final EnemyStateGroup sg_BunnyPain = new EnemyStateGroup(s_BunnyPain[0], s_BunnyPain[1], s_BunnyPain[2], s_BunnyPain[3], s_BunnyPain[4]);
    private static final State[][] s_BunnyJump = new State[][]{{new State(4551, 25, DoBunnyMoveJump), new State(4552, 25, DoBunnyMoveJump).setNext()}, {new State(4556, 25, DoBunnyMoveJump), new State(4557, 25, DoBunnyMoveJump).setNext()}, {new State(4561, 25, DoBunnyMoveJump), new State(4562, 25, DoBunnyMoveJump).setNext()}, {new State(4566, 25, DoBunnyMoveJump), new State(4567, 25, DoBunnyMoveJump).setNext()}, {new State(4571, 25, DoBunnyMoveJump), new State(4572, 25, DoBunnyMoveJump).setNext()}};
    private static final EnemyStateGroup sg_BunnyJump = new EnemyStateGroup(s_BunnyJump[0], s_BunnyJump[1], s_BunnyJump[2], s_BunnyJump[3], s_BunnyJump[4]);
    private static final State[][] s_BunnyFall = new State[][]{{new State(4553, 25, DoBunnyMoveJump).setNext()}, {new State(4558, 25, DoBunnyMoveJump).setNext()}, {new State(4563, 25, DoBunnyMoveJump).setNext()}, {new State(4568, 25, DoBunnyMoveJump).setNext()}, {new State(4573, 25, DoBunnyMoveJump).setNext()}};
    private static final EnemyStateGroup sg_BunnyFall = new EnemyStateGroup(s_BunnyFall[0], s_BunnyFall[1], s_BunnyFall[2], s_BunnyFall[3], s_BunnyFall[4]);
    private static final State[] s_BunnyDie = new State[]{new State(4580, 16, NullBunny), new State(4580, Gameutils.SF_QUICK_CALL, BunnySpew), new State(4581, 16, NullBunny), new State(4582, 16, NullBunny), new State(4582, 16, NullBunny), new State(4584, 16, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_BunnyDie = new EnemyStateGroup(new State[][]{s_BunnyDie});
    private static final State[] s_BunnyDead = new State[]{new State(4580, 8, null), new State(4580, Gameutils.SF_QUICK_CALL, BunnySpew), new State(4581, 8, null), new State(4582, 8, null), new State(4584, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(4584, 8, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_BunnyDead = new EnemyStateGroup(new State[][]{s_BunnyDead});
    private static final State[] s_BunnyDeathJump = new State[]{new State(4580, 16, DoActorDeathMove).setNext()};
    private static final EnemyStateGroup sg_BunnyDeathJump = new EnemyStateGroup(new State[][]{s_BunnyDeathJump});
    private static final State[] s_BunnyDeathFall = new State[]{new State(4581, 16, DoActorDeathMove).setNext()};
    private static final EnemyStateGroup sg_BunnyDeathFall = new EnemyStateGroup(new State[][]{s_BunnyDeathFall});
    public static int Bunny_Count = 0;
    public static final Animator DoBunnyMove = new Animator(Bunny::DoBunnyMove);
    public static final Animator DoBunnyGrowUp = new Animator(Bunny::DoBunnyGrowUp);
    private static final State[][] s_BunnyRun = new State[][]{{new State(4550, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4551, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4552, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4553, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4554, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4554, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove)}, {new State(4555, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4556, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4557, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4558, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4559, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4559, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove)}, {new State(4560, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4561, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4562, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4563, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4564, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4564, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove)}, {new State(4565, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4566, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4567, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4568, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4569, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4569, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove)}, {new State(4570, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4571, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4572, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4573, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4574, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4574, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove)}};
    public static final Animator DoBunnyEat = new Animator(Bunny::DoBunnyEat);
    private static final State[][] s_BunnyStand = new State[][]{{new State(4550, 12, DoBunnyEat), new State(4554, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4554, 12, DoBunnyEat)}, {new State(4555, 12, DoBunnyEat), new State(4559, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4559, 12, DoBunnyEat)}, {new State(4560, 12, DoBunnyEat), new State(4564, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4564, 12, DoBunnyEat)}, {new State(4565, 12, DoBunnyEat), new State(4569, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4569, 12, DoBunnyEat)}, {new State(4570, 12, DoBunnyEat), new State(4574, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4574, 12, DoBunnyEat)}};
    public static final Animator DoBunnyScrew = new Animator(Bunny::DoBunnyScrew);
    private static final State[][] s_BunnyScrew = new State[][]{{new State(4550, 16, DoBunnyScrew), new State(4552, 16, DoBunnyScrew)}, {new State(4555, 16, DoBunnyScrew), new State(4557, 16, DoBunnyScrew)}, {new State(4560, 16, DoBunnyScrew), new State(4562, 16, DoBunnyScrew)}, {new State(4565, 16, DoBunnyScrew), new State(4567, 16, DoBunnyScrew)}, {new State(4570, 16, DoBunnyScrew), new State(4572, 16, DoBunnyScrew)}};
    public static final Animator InitBunnySlash = new Animator(Bunny::InitBunnySlash);
    private static final State[][] s_BunnySwipe = new State[][]{{new State(4575, 8, NullBunny), new State(4576, 8, NullBunny), new State(4576, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4577, 8, NullBunny), new State(4578, 8, NullBunny), new State(4578, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4578, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4578, 8, DoBunnyMove).setNext()}, {new State(4555, 8, NullBunny), new State(4556, 8, NullBunny), new State(4556, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4557, 8, NullBunny), new State(4558, 8, NullBunny), new State(4558, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4558, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4558, 8, DoBunnyMove).setNext()}, {new State(4560, 8, NullBunny), new State(4561, 8, NullBunny), new State(4561, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4562, 8, NullBunny), new State(4563, 8, NullBunny), new State(4563, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4563, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4563, 8, DoBunnyMove).setNext()}, {new State(4565, 8, NullBunny), new State(4566, 8, NullBunny), new State(4566, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4567, 8, NullBunny), new State(4568, 8, NullBunny), new State(4568, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4568, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4568, 8, DoBunnyMove).setNext()}, {new State(4570, 8, NullBunny), new State(4571, 8, NullBunny), new State(4571, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4572, 8, NullBunny), new State(4573, 8, NullBunny), new State(4573, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4573, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4573, 8, DoBunnyMove).setNext()}};
    public static final Animator DoBunnyStandKill = new Animator(Bunny::DoBunnyStandKill);
    private static final State[][] s_BunnyHeart = new State[][]{{new State(4575, 14, DoBunnyStandKill).setNext()}, {new State(4580, 14, DoBunnyStandKill).setNext()}, {new State(4580, 14, DoBunnyStandKill).setNext()}, {new State(4580, 14, DoBunnyStandKill).setNext()}, {new State(4580, 14, DoBunnyStandKill).setNext()}};
    private static final EnemyStateGroup sg_BunnyStand = new EnemyStateGroup(s_BunnyStand[0], s_BunnyStand[1], s_BunnyStand[2], s_BunnyStand[3], s_BunnyStand[4]);
    private static final EnemyStateGroup sg_BunnyRun = new EnemyStateGroup(s_BunnyRun[0], s_BunnyRun[1], s_BunnyRun[2], s_BunnyRun[3], s_BunnyRun[4]);
    private static final EnemyStateGroup sg_BunnyHeart = new EnemyStateGroup(s_BunnyHeart[0], s_BunnyHeart[1], s_BunnyHeart[2], s_BunnyHeart[3], s_BunnyHeart[4]);
    private static final EnemyStateGroup sg_BunnySwipe = new EnemyStateGroup(s_BunnySwipe[0], s_BunnySwipe[1], s_BunnySwipe[2], s_BunnySwipe[3], s_BunnySwipe[4]);
    private static final EnemyStateGroup sg_BunnyScrew = new EnemyStateGroup(s_BunnyScrew[0], s_BunnyScrew[1], s_BunnyScrew[2], s_BunnyScrew[3], s_BunnyScrew[4]);
    private static final Actor_Action_Set BunnyActionSet = new Actor_Action_Set(sg_BunnyStand, sg_BunnyRun, sg_BunnyJump, sg_BunnyFall, null, null, null, null, null, null, null, sg_BunnyPain, sg_BunnyDie, null, sg_BunnyDead, sg_BunnyDeathJump, sg_BunnyDeathFall, null, new short[]{1024}, null, new short[]{1024}, new StateGroup[]{sg_BunnyHeart, sg_BunnyRun}, null, null);
    private static final Actor_Action_Set BunnyWhiteActionSet = new Actor_Action_Set(sg_BunnyStand, sg_BunnyRun, sg_BunnyJump, sg_BunnyFall, null, null, null, null, null, null, null, sg_BunnyPain, sg_BunnyDie, null, sg_BunnyDead, sg_BunnyDeathJump, sg_BunnyDeathFall, new StateGroup[]{sg_BunnySwipe}, new short[]{1024}, new StateGroup[]{sg_BunnySwipe}, new short[]{1024}, new StateGroup[]{sg_BunnyHeart, sg_BunnySwipe}, null, null);

    public static void InitBunnyStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_BunnyStand, sg_BunnyRun, sg_BunnyJump, sg_BunnyFall, sg_BunnyPain, sg_BunnyDie, sg_BunnyDead, sg_BunnyDeathJump, sg_BunnyDeathFall, sg_BunnyHeart, sg_BunnySwipe, sg_BunnyScrew}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    public static void SetupBunny(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 4550, s_BunnyRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 10;
        }
        ++Bunny_Count;
        Sprites.ChangeState(SpriteNum, s_BunnyRun[0][0]);
        u.StateEnd = s_BunnyDie[0];
        u.setRot(sg_BunnyRun);
        u.ShellNum = 0;
        u.FlagOwner = 0;
        sp.setClipdist(37);
        if (sp.getPal() == 17) {
            Coolie.EnemyDefaults(SpriteNum, BunnyWhiteActionSet, WhiteBunnyPersonality);
            u.Attrib = WhiteBunnyAttrib;
            sp.setXrepeat(96);
            sp.setYrepeat(90);
            sp.setClipdist(50);
            if (!MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
                u.Health = 60;
            }
        } else if (sp.getPal() == 24) {
            Coolie.EnemyDefaults(SpriteNum, BunnyActionSet, BunnyPersonality);
            u.Attrib = BunnyAttrib;
            if (!MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
                u.Health = 20;
            }
            u.Flag1 = 0;
        } else {
            Coolie.EnemyDefaults(SpriteNum, BunnyActionSet, BunnyPersonality);
            u.Attrib = BunnyAttrib;
            u.spal = (byte)16;
            sp.setPal(16);
            u.Flag1 = Gameutils.SEC(5);
        }
        Ai.DoActorSetSpeed(SpriteNum, 3);
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        u.zclip = Gameutils.Z(16);
        u.floor_dist = Gameutils.Z(8);
        u.ceiling_dist = Gameutils.Z(8);
        u.lo_step = Gameutils.Z(16);
    }

    private static int RANDOM_NEG() {
        return Gameutils.RANDOM_P2(32768) - 16384;
    }

    private static void DoBunnyBeginJumpAttack(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite psp = Main.boardService.getSprite(u.tgt_sp);
        if (psp == null) {
            return;
        }
        int tang = EngineUtils.getAngle(psp.getX() - sp.getX(), psp.getY() - sp.getY());
        if (Sprites.move_sprite(SpriteNum, EngineUtils.sin(Gameutils.NORM_ANGLE(tang + 512)) >> 7, EngineUtils.sin(tang) >> 7, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_ACTOR, 6) != 0) {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024) + (Bunny.RANDOM_NEG() >> 6));
        } else {
            sp.setAng(Gameutils.NORM_ANGLE(tang + (Bunny.RANDOM_NEG() >> 6)));
        }
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ripper.PickJumpMaxSpeed(SpriteNum, -400);
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = 17;
        Sprites.DoActorZrange(SpriteNum);
        Actor.DoJump(SpriteNum);
    }

    private static void DoBunnyMoveJump(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            int nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
            int ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14;
            Sprites.move_actor(SpriteNum, nx, ny, 0);
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        Sprites.DoActorZrange(SpriteNum);
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    private static void DoPickCloseBunny(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int near_dist = 1000;
        int look_height = Gameutils.SPRITEp_TOS(sp);
        ListNode<Sprite> node = Main.boardService.getStatNode(2);
        while (node != null) {
            boolean ICanSee;
            int dist;
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite tsp = node.get();
            USER tu = Gameutils.getUser(i);
            if (tu != null && sp != tsp && tu.ID == 4550 && (dist = Gameutils.DISTANCE(tsp.getX(), tsp.getY(), sp.getX(), sp.getY())) <= near_dist && (ICanSee = Rooms.FAFcansee(sp.getX(), sp.getY(), look_height, sp.getSectnum(), tsp.getX(), tsp.getY(), Gameutils.SPRITEp_UPPER(tsp), tsp.getSectnum())) && dist < near_dist && tu.ID == 4550) {
                u.tgt_sp = u.lo_sp = i;
                return;
            }
            node = nexti;
        }
    }

    private static void DoBunnyQuickJump(int SpriteNum) {
        USER tu;
        int hitsprite;
        WangSprite tsp;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (u.spal != 24) {
            return;
        }
        if (u.lo_sp == -1 && Sprites.MoveSkip4 != 0) {
            Bunny.DoPickCloseBunny(SpriteNum);
        }
        if ((tsp = Main.boardService.getSprite(u.lo_sp)) != null) {
            hitsprite = u.lo_sp;
            tu = Gameutils.getUser(hitsprite);
            if (tu == null || tu.ID != 4550) {
                return;
            }
            if (sp.getXrepeat() != 64 || sp.getYrepeat() != 64) {
                return;
            }
            if (tsp.getXrepeat() != 64 || tsp.getYrepeat() != 64) {
                return;
            }
            if (tu.spal == sp.getPal() && Gameutils.RANDOM_RANGE(1000) > 995 && u.spal == 24 && tu.spal == 24) {
                Sound.PlaySound(424, sp, 1);
                Sound.PlaySound(426, tsp, 1);
                tu.Health = 0;
                JWeapon.InitBloodSpray(hitsprite, true, -1);
                if (Shrap.SpawnShrap(hitsprite, SpriteNum)) {
                    Weapon.SetSuicide(hitsprite);
                } else {
                    Actor.DoActorDie(hitsprite, SpriteNum);
                }
                --Bunny_Count;
                u.lo_sp = -1;
                return;
            }
        }
        if (tsp != null && u.spal == 24) {
            hitsprite = u.lo_sp;
            tu = Gameutils.getUser(hitsprite);
            if (tu == null || tu.ID != 4550) {
                return;
            }
            if (sp.getXrepeat() != 64 || sp.getYrepeat() != 64) {
                return;
            }
            if (tsp.getXrepeat() != 64 || tsp.getYrepeat() != 64) {
                return;
            }
            if (tu.ShellNum <= 0 && tu.WaitTics <= 0 && u.WaitTics <= 0 && MyTypes.TEST(tsp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                PlayerStr pp = null;
                if (Gameutils.RANDOM_RANGE(1000) < 995 && tu.spal != 16) {
                    return;
                }
                Ai.DoActorPickClosePlayer(SpriteNum);
                USER tgu = Gameutils.getUser(u.tgt_sp);
                if (tgu != null && tgu.PlayerP != -1) {
                    pp = Game.Player[tgu.PlayerP];
                }
                if (tu.spal != 16) {
                    if (tu.Flag1 > 0) {
                        return;
                    }
                    tu.FlagOwner = 1;
                    tu.Flag1 = Gameutils.SEC(10);
                    if (pp != null) {
                        int[] fagsnds = new int[]{456, 457, 458};
                        if (pp == Game.Player[Mmulti.myconnectindex]) {
                            int choose_snd = Gameutils.STD_RANDOM_RANGE(512) >> 8;
                            WangSprite tgt = Main.boardService.getSprite(u.tgt_sp);
                            if (tgt != null && Rooms.FAFcansee(sp.getX(), sp.getY(), Gameutils.SPRITEp_TOS(sp), sp.getSectnum(), pp.posx, pp.posy, pp.posz, pp.cursectnum) && Gameutils.FACING(sp, tgt)) {
                                Sound.PlayerSound(fagsnds[choose_snd], 13, pp);
                            }
                        }
                    }
                } else if (pp != null && Gameutils.RANDOM_RANGE(1000) > 200) {
                    int[] straightsnds = new int[]{452, 453, 454, 455};
                    if (pp == Game.Player[Mmulti.myconnectindex]) {
                        int choose_snd = Gameutils.STD_RANDOM_RANGE(768) >> 8;
                        WangSprite tgt = Main.boardService.getSprite(u.tgt_sp);
                        if (tgt != null && Rooms.FAFcansee(sp.getX(), sp.getY(), Gameutils.SPRITEp_TOS(sp), sp.getSectnum(), pp.posx, pp.posy, pp.posz, pp.cursectnum) && Gameutils.FACING(sp, tgt)) {
                            Sound.PlayerSound(straightsnds[choose_snd], 13, pp);
                        }
                    }
                }
                sp.setX(tsp.getX());
                sp.setY(tsp.getY());
                sp.setAng(tsp.getAng());
                sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024));
                Weapon.HelpMissileLateral(SpriteNum, 2000);
                sp.setAng(tsp.getAng());
                u.Vis = sp.getAng();
                tu.Vis = tsp.getAng();
                Sprites.NewStateGroup(SpriteNum, sg_BunnyScrew);
                Sprites.NewStateGroup(hitsprite, sg_BunnyScrew);
                if (Main.cfg.ParentalLock) {
                    sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_INVISIBLE);
                    tsp.setCstat(tsp.getCstat() | Gameutils.CSTAT_SPRITE_INVISIBLE);
                }
                u.WaitTics = tu.WaitTics = Gameutils.SEC(10);
            }
        }
    }

    private static void NullBunny(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoBunnyPain(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        Bunny.NullBunny(SpriteNum);
        if (u != null && (u.WaitTics -= 6) <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    public static void DoBunnyRipHeart(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        Sprites.NewStateGroup(SpriteNum, sg_BunnyHeart);
        u.WaitTics = 720;
        if (tsp != null) {
            tsp.setAng(EngineUtils.getAngle(sp.getX() - tsp.getX(), sp.getY() - tsp.getY()));
        }
    }

    private static void DoBunnyStandKill(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Bunny.NullBunny(SpriteNum);
        if (Gameutils.RANDOM_RANGE(1000) > 800) {
            Sound.PlaySound(424, sp, 0);
        }
        if ((u.WaitTics -= 6) <= 0) {
            Sprites.NewStateGroup(SpriteNum, sg_BunnyRun);
        }
    }

    private static void BunnyHatch(int Weapon2) {
        WangSprite wp = Main.boardService.getSprite(Weapon2);
        USER wu = Gameutils.getUser(Weapon2);
        if (wp == null) {
            return;
        }
        int rip_ang = Gameutils.RANDOM_P2(2048);
        int newsp = Rooms.COVERinsertsprite(wp.getSectnum(), 0);
        WangSprite np = Main.boardService.getSprite(newsp);
        if (np == null) {
            return;
        }
        ((Sprite)np).reset();
        np.setSectnum(wp.getSectnum());
        np.setStatnum(0);
        np.setX(wp.getX());
        np.setY(wp.getY());
        np.setZ(wp.getZ());
        np.setOwner(-1);
        np.setXrepeat(30);
        np.setYrepeat(24);
        np.setAng(rip_ang);
        np.setPal(0);
        Bunny.SetupBunny(newsp);
        USER nu = Gameutils.getUser(newsp);
        if (nu == null) {
            return;
        }
        np.setShade(wp.getShade());
        nu.Flags |= Gameutils.SPR_ACTIVE;
        if (Gameutils.RANDOM_RANGE(1000) > 500) {
            nu.spal = (byte)16;
            np.setPal(16);
        } else {
            nu.spal = (byte)24;
            np.setPal(24);
            if (Gameutils.RANDOM_RANGE(1000) > 500 && wu != null) {
                wu.Health = 0;
                --Bunny_Count;
                JWeapon.InitBloodSpray(Weapon2, true, -1);
                if (Shrap.SpawnShrap(Weapon2, newsp)) {
                    Weapon.SetSuicide(Weapon2);
                } else {
                    Actor.DoActorDie(Weapon2, newsp);
                }
            }
        }
        nu.ShellNum = 0;
        Sprites.NewStateGroup(newsp, nu.ActorActionSet.Jump);
        nu.ActorActionFunc = Ai.DoActorMoveJump;
        Ai.DoActorSetSpeed(newsp, 3);
        Ripper.PickJumpMaxSpeed(newsp, -600);
        nu.Flags |= Gameutils.SPR_JUMPING;
        nu.Flags &= ~Gameutils.SPR_FALLING;
        nu.jump_grav = 8;
        Sprites.DoActorZrange(newsp);
        Actor.DoActorJump(newsp);
    }

    public static int BunnyHatch2(int Weapon2) {
        WangSprite wp = Main.boardService.getSprite(Weapon2);
        if (wp == null) {
            return -1;
        }
        int newsp = Rooms.COVERinsertsprite(wp.getSectnum(), 0);
        WangSprite np = Main.boardService.getSprite(newsp);
        if (np == null) {
            return -1;
        }
        ((Sprite)np).reset();
        np.setSectnum(wp.getSectnum());
        np.setStatnum(0);
        np.setX(wp.getX());
        np.setY(wp.getY());
        np.setZ(wp.getZ());
        np.setOwner(-1);
        np.setXrepeat(30);
        np.setYrepeat(24);
        np.setAng(Gameutils.RANDOM_P2(2048));
        np.setPal(0);
        Bunny.SetupBunny(newsp);
        USER nu = Gameutils.getUser(newsp);
        if (nu == null) {
            return -1;
        }
        np.setShade(wp.getShade());
        nu.Flags |= Gameutils.SPR_ACTIVE;
        if (Gameutils.RANDOM_RANGE(1000) > 500) {
            nu.spal = (byte)16;
            np.setPal(16);
            nu.Flag1 = Gameutils.SEC(5);
        } else {
            nu.spal = (byte)24;
            np.setPal(24);
            nu.Flag1 = 0;
        }
        nu.ShellNum = 0;
        Sprites.NewStateGroup(newsp, nu.ActorActionSet.Jump);
        nu.ActorActionFunc = Ai.DoActorMoveJump;
        Ai.DoActorSetSpeed(newsp, 3);
        if (Gameutils.TEST_BOOL3(wp)) {
            Ripper.PickJumpMaxSpeed(newsp, -600 - Gameutils.RANDOM_RANGE(600));
            np.setXrepeat(64);
            np.setYrepeat(64);
            np.setXvel(150 + Gameutils.RANDOM_RANGE(1000));
            nu.Health = 1;
            np.setAng(np.getAng() - Gameutils.RANDOM_RANGE(128));
            np.setAng(np.getAng() + Gameutils.RANDOM_RANGE(128));
        } else {
            Ripper.PickJumpMaxSpeed(newsp, -600);
        }
        nu.Flags |= Gameutils.SPR_JUMPING;
        nu.Flags &= ~Gameutils.SPR_FALLING;
        nu.jump_grav = 8;
        nu.FlagOwner = 0;
        nu.active_range = 75000;
        Sprites.DoActorZrange(newsp);
        Actor.DoActorJump(newsp);
        return newsp;
    }

    private static void DoBunnyMove(int SpriteNum) {
        Sector sec;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
            sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
        }
        if (u.Health <= 0) {
            Weapon.SetSuicide(SpriteNum);
        }
        if (u.scale_speed != 0) {
            Actor.DoScaleSprite(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Bunny.DoBunnyQuickJump(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        if (Gameutils.RANDOM_RANGE(1000) > 985 && sp.getPal() != 17 && u.track < 0 && (sec = Main.boardService.getSector(sp.getSectnum())) != null) {
            switch (sec.getFloorpicnum()) {
                case 153: 
                case 154: 
                case 193: 
                case 219: 
                case 2636: 
                case 2689: 
                case 3561: 
                case 3562: 
                case 3563: 
                case 3564: {
                    Sprites.NewStateGroup(SpriteNum, sg_BunnyStand);
                    break;
                }
                default: {
                    sp.setAng(Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(131072) >> 6));
                    u.jump_speed = -350;
                    Actor.DoActorBeginJump(SpriteNum);
                    u.ActorActionFunc = Ai.DoActorMoveJump;
                }
            }
        }
    }

    private static void BunnySpew(int SpriteNum) {
        JWeapon.InitBloodSpray(SpriteNum, true, -1);
    }

    private static void DoBunnyEat(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Bunny.DoBunnyQuickJump(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        Sector sec = Main.boardService.getSector(sp.getSectnum());
        if (sec != null) {
            switch (sec.getFloorpicnum()) {
                case 153: 
                case 154: 
                case 193: 
                case 219: 
                case 2636: 
                case 2689: 
                case 3561: 
                case 3562: 
                case 3563: 
                case 3564: {
                    if (Gameutils.RANDOM_RANGE(1000) <= 970) break;
                    Sprites.NewStateGroup(SpriteNum, sg_BunnyRun);
                    break;
                }
                default: {
                    Sprites.NewStateGroup(SpriteNum, sg_BunnyRun);
                }
            }
        }
    }

    private static void DoBunnyScrew(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        if (Gameutils.RANDOM_RANGE(1000) > 990 && !Main.cfg.ParentalLock) {
            Sound.PlaySound(424, sp, 1);
        }
        u.WaitTics -= 6;
        if ((u.FlagOwner != 0 || u.spal == 16) && u.WaitTics > 0) {
            Sprites.NewStateGroup(SpriteNum, sg_BunnyScrew);
        }
        if (u.spal == 16 && u.WaitTics <= 0) {
            u.Flag1 = Gameutils.SEC(5);
            u.ShellNum = 1;
        }
        if (u.WaitTics <= 0) {
            sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
            u.FlagOwner = 0;
            Sprites.NewStateGroup(SpriteNum, sg_BunnyRun);
        }
    }

    private static void DoBunnyGrowUp(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (sp.getPal() == 17) {
            return;
        }
        if ((u.Counter -= 6) <= 0) {
            int xsiz = sp.getXrepeat() + 1;
            int ysiz = sp.getYrepeat() + 1;
            sp.setXrepeat(xsiz);
            sp.setYrepeat(ysiz);
            if (xsiz > 64) {
                sp.setXrepeat(64);
            }
            if (ysiz > 64) {
                sp.setYrepeat(64);
            }
            u.Counter = 60;
        }
        if (sp.getPal() != 16 && u.Flag1 > 0) {
            u.Flag1 -= 6;
        }
        if (sp.getPal() == 16 && u.ShellNum > 0 && (u.Flag1 -= 6) <= 0) {
            if (Bunny_Count < 20) {
                Sound.PlaySound(426, sp, 1);
                Bunny.BunnyHatch(SpriteNum);
            }
            u.ShellNum = 0;
        }
    }

    public static void InitBunnySlash(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        Sound.PlaySound(424, sp, 0);
        block0: for (int j : Weapon.StatDamageList) {
            ListNode<Sprite> node = Main.boardService.getStatNode(j);
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite hp = node.get();
                if (i == SpriteNum) continue block0;
                int dist = Gameutils.DISTANCE(hp.getX(), hp.getY(), sp.getX(), sp.getY());
                if (dist < Weapon.CLOSE_RANGE_DIST_FUDGE(sp, hp, 600) && Gameutils.FACING_RANGE(hp, sp, 150)) {
                    Weapon.DoDamage(i, SpriteNum);
                }
                node = nexti;
            }
        }
    }

    public static void BunnySaveable() {
        Saveable.SaveData(InitBunnySlash);
        Saveable.SaveData(DoActorDeathMove);
        Saveable.SaveData(DoBunnyBeginJumpAttack);
        Saveable.SaveData(DoBunnyMoveJump);
        Saveable.SaveData(NullBunny);
        Saveable.SaveData(DoBunnyPain);
        Saveable.SaveData(DoBunnyStandKill);
        Saveable.SaveData(DoBunnyMove);
        Saveable.SaveData(BunnySpew);
        Saveable.SaveData(DoBunnyEat);
        Saveable.SaveData(DoBunnyScrew);
        Saveable.SaveData(DoBunnyGrowUp);
        Saveable.SaveData(WhiteBunnyPersonality);
        Saveable.SaveData(BunnyPersonality);
        Saveable.SaveData(WhiteBunnyAttrib);
        Saveable.SaveData(BunnyAttrib);
        Saveable.SaveData(s_BunnyRun);
        Saveable.SaveGroup(sg_BunnyRun);
        Saveable.SaveData(s_BunnyStand);
        Saveable.SaveGroup(sg_BunnyStand);
        Saveable.SaveData(s_BunnyScrew);
        Saveable.SaveGroup(sg_BunnyScrew);
        Saveable.SaveData(s_BunnySwipe);
        Saveable.SaveGroup(sg_BunnySwipe);
        Saveable.SaveData(s_BunnyHeart);
        Saveable.SaveGroup(sg_BunnyHeart);
        Saveable.SaveData(s_BunnyPain);
        Saveable.SaveGroup(sg_BunnyPain);
        Saveable.SaveData(s_BunnyJump);
        Saveable.SaveGroup(sg_BunnyJump);
        Saveable.SaveData(s_BunnyFall);
        Saveable.SaveGroup(sg_BunnyFall);
        Saveable.SaveData(s_BunnyDie);
        Saveable.SaveGroup(sg_BunnyDie);
        Saveable.SaveData(s_BunnyDead);
        Saveable.SaveGroup(sg_BunnyDead);
        Saveable.SaveData(s_BunnyDeathJump);
        Saveable.SaveGroup(sg_BunnyDeathJump);
        Saveable.SaveData(s_BunnyDeathFall);
        Saveable.SaveGroup(sg_BunnyDeathFall);
        Saveable.SaveData(BunnyActionSet);
        Saveable.SaveData(BunnyWhiteActionSet);
    }
}

