/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Ripper;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Coolg {
    public static final int COOLG_RUN_RATE = 40;
    public static final int COOLG_FIRE_RATE = 12;
    public static final int COOLG_PAIN_RATE = 15;
    public static final int COOLG_DIE_RATE = 20;
    public static final int COOLG_DIE = 4307;
    public static final int COOLG_DEAD = 4312;
    public static final int COOLG_BIRTH_RATE = 20;
    public static final int COOLG_BIRTH = 4268;
    private static final Animator DoCoolgDeath = new Animator(Coolg::DoCoolgDeath);
    private static final Decision[] CoolgOffense = new Decision[]{new Decision(449, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] CoolgBroadcast = new Decision[]{new Decision(1, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] CoolgLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] CoolgCloseRange = new Decision[]{new Decision(800, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Decision[] CoolgTouchTarget = new Decision[]{new Decision(1024, Ai.InitActorAttack)};
    private static final ATTRIBUTE CoolgAttrib = new ATTRIBUTE(new short[]{60, 80, 150, 190}, new short[]{3, 0, -2, -3}, 3, new int[]{83, 81, 0, 84, 87, 80, 82, 85, 86, 0});
    private static final State[] s_CoolgDie = new State[]{new State(4307, 20, DoCoolgDeath), new State(4308, 20, DoCoolgDeath), new State(4309, 20, DoCoolgDeath), new State(4310, 20, DoCoolgDeath), new State(4311, 20, DoCoolgDeath), new State(4312, 20, DoCoolgDeath).setNext()};
    private static final EnemyStateGroup sg_CoolgDie = new EnemyStateGroup(new State[][]{s_CoolgDie});
    private static final State[] s_CoolgDead = new State[]{new State(4312, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(4312, 20, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_CoolgDead = new EnemyStateGroup(new State[][]{s_CoolgDead});
    private static final int COOLG_BOB_AMT = Gameutils.Z(8);
    private static final Animator DoCoolgMove = new Animator(Coolg::DoCoolgMove);
    private static final State[][] s_CoolgRun = new State[][]{{new State(4277, 40, DoCoolgMove), new State(4278, 40, DoCoolgMove), new State(4279, 40, DoCoolgMove), new State(4280, 40, DoCoolgMove)}, {new State(4281, 40, DoCoolgMove), new State(4282, 40, DoCoolgMove), new State(4283, 40, DoCoolgMove), new State(4284, 40, DoCoolgMove)}, {new State(4285, 40, DoCoolgMove), new State(4286, 40, DoCoolgMove), new State(4287, 40, DoCoolgMove), new State(4288, 40, DoCoolgMove)}, {new State(4289, 40, DoCoolgMove), new State(4290, 40, DoCoolgMove), new State(4291, 40, DoCoolgMove), new State(4292, 40, DoCoolgMove)}, {new State(4293, 40, DoCoolgMove), new State(4294, 40, DoCoolgMove), new State(4295, 40, DoCoolgMove), new State(4296, 40, DoCoolgMove)}};
    private static final EnemyStateGroup sg_CoolgRun = new EnemyStateGroup(s_CoolgRun[0], s_CoolgRun[1], s_CoolgRun[2], s_CoolgRun[3], s_CoolgRun[4]);
    private static final State[][] s_CoolgStand = new State[][]{{new State(4277, 40, DoCoolgMove).setNext()}, {new State(4281, 40, DoCoolgMove).setNext()}, {new State(4285, 40, DoCoolgMove).setNext()}, {new State(4289, 40, DoCoolgMove).setNext()}, {new State(4293, 40, DoCoolgMove).setNext()}};
    private static final EnemyStateGroup sg_CoolgStand = new EnemyStateGroup(s_CoolgStand[0], s_CoolgStand[1], s_CoolgStand[2], s_CoolgStand[3], s_CoolgStand[4]);
    private static final Animator DoCoolgCircle = new Animator(Coolg::DoCoolgCircle);
    private static final Animator InitCoolgCircle = new Animator(Coolg::InitCoolgCircle);
    private static final Decision[] CoolgBattle = new Decision[]{new Decision(50, InitCoolgCircle), new Decision(450, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] CoolgSurprised = new Decision[]{new Decision(100, InitCoolgCircle), new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] CoolgEvasive = new Decision[]{new Decision(20, InitCoolgCircle), new Decision(1024, Ai.InitActorRunAway)};
    private static final Personality CoolgPersonality = new Personality(CoolgBattle, CoolgOffense, CoolgBroadcast, CoolgSurprised, CoolgEvasive, CoolgLostTarget, CoolgCloseRange, CoolgTouchTarget);
    private static final Animator NullCoolg = new Animator(Coolg::NullCoolg);
    private static final State[][] s_CoolgAttack = new State[][]{{new State(4297, 24, NullCoolg), new State(4298, 24, NullCoolg), new State(4299, 24, NullCoolg), new State(4299, Gameutils.SF_QUICK_CALL, Ripper.InitCoolgFire), new State(4299, 12, NullCoolg), new State(4299, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4279, 12, DoCoolgMove).setNext()}, {new State(4300, 24, NullCoolg), new State(4301, 24, NullCoolg), new State(4302, 24, NullCoolg), new State(4302, Gameutils.SF_QUICK_CALL, Ripper.InitCoolgFire), new State(4302, 12, NullCoolg), new State(4302, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4279, 12, DoCoolgMove).setNext()}, {new State(4303, 24, NullCoolg), new State(4304, 24, NullCoolg), new State(4305, 24, NullCoolg), new State(4305, Gameutils.SF_QUICK_CALL, Ripper.InitCoolgFire), new State(4305, 12, NullCoolg), new State(4305, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4279, 12, DoCoolgMove).setNext()}, {new State(4289, 24, NullCoolg), new State(4290, 24, NullCoolg), new State(4291, 24, NullCoolg), new State(4291, Gameutils.SF_QUICK_CALL, Ripper.InitCoolgFire), new State(4291, 12, NullCoolg), new State(4291, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4279, 12, DoCoolgMove).setNext()}, {new State(4293, 24, NullCoolg), new State(4294, 24, NullCoolg), new State(4295, 24, NullCoolg), new State(4295, Gameutils.SF_QUICK_CALL, Ripper.InitCoolgFire), new State(4295, 12, NullCoolg), new State(4295, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4279, 12, DoCoolgMove).setNext()}};
    private static final EnemyStateGroup sg_CoolgAttack = new EnemyStateGroup(s_CoolgAttack[0], s_CoolgAttack[1], s_CoolgAttack[2], s_CoolgAttack[3], s_CoolgAttack[4]);
    private static final Animator DoCoolgPain = new Animator(Coolg::DoCoolgPain);
    private static final State[][] s_CoolgPain = new State[][]{{new State(4306, 15, DoCoolgPain), new State(4306, 15, DoCoolgPain).setNext()}, {new State(4281, 15, DoCoolgPain), new State(4281, 15, DoCoolgPain).setNext()}, {new State(4285, 15, DoCoolgPain), new State(4285, 15, DoCoolgPain).setNext()}, {new State(4289, 15, DoCoolgPain), new State(4289, 15, DoCoolgPain).setNext()}, {new State(4293, 15, DoCoolgPain), new State(4293, 15, DoCoolgPain).setNext()}};
    private static final EnemyStateGroup sg_CoolgPain = new EnemyStateGroup(s_CoolgPain[0], s_CoolgPain[1], s_CoolgPain[2], s_CoolgPain[3], s_CoolgPain[4]);
    private static final Actor_Action_Set CoolgActionSet = new Actor_Action_Set(sg_CoolgStand, sg_CoolgRun, null, null, null, null, null, null, null, null, null, sg_CoolgPain, sg_CoolgDie, null, sg_CoolgDead, null, null, new StateGroup[]{sg_CoolgAttack}, new short[]{1024}, new StateGroup[]{sg_CoolgAttack}, new short[]{1024}, null, null, null);
    private static final Animator DoCoolgBirth = new Animator(Coolg::DoCoolgBirth);
    private static final State[] s_CoolgBirth = new State[]{new State(4268, 20, null), new State(4269, 20, null), new State(4270, 20, null), new State(4271, 20, null), new State(4272, 20, null), new State(4273, 20, null), new State(4274, 20, null), new State(4275, 20, null), new State(4276, 20, null), new State(4276, 20, null), new State(4276, Gameutils.SF_QUICK_CALL, DoCoolgBirth).setNext()};

    public static void InitCoolgStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_CoolgStand, sg_CoolgRun, sg_CoolgPain, sg_CoolgDie, sg_CoolgDead, sg_CoolgAttack}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
        State.InitState(s_CoolgBirth);
    }

    private static void CoolgCommon(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        sp.setClipdist(50);
        u.floor_dist = Gameutils.Z(16);
        u.ceiling_dist = Gameutils.Z(20);
        u.sz = sp.getZ();
        sp.setXrepeat(42);
        sp.setYrepeat(42);
        sp.setExtra(sp.getExtra() | Gameutils.SPRX_PLAYER_OR_ENEMY);
    }

    public static void SetupCoolg(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 4277, s_CoolgRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 65;
        }
        Sprites.ChangeState(SpriteNum, s_CoolgRun[0][0]);
        u.Attrib = CoolgAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_CoolgDie[0];
        u.setRot(sg_CoolgRun);
        Coolie.EnemyDefaults(SpriteNum, CoolgActionSet, CoolgPersonality);
        u.Flags |= Gameutils.SPR_NO_SCAREDZ | Gameutils.SPR_XFLIP_TOGGLE;
        Coolg.CoolgCommon(SpriteNum);
    }

    public static void NewCoolg(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int newsp = Sprites.SpawnSprite(2, 4277, s_CoolgBirth[0], sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), 50);
        USER nu = Gameutils.getUser(newsp);
        WangSprite np = Main.boardService.getSprite(newsp);
        if (nu == null || np == null) {
            return;
        }
        Sprites.ChangeState(newsp, s_CoolgBirth[0]);
        nu.StateEnd = s_CoolgDie[0];
        nu.setRot(sg_CoolgRun);
        nu.spal = u.spal;
        np.setPal(nu.spal);
        nu.ActorActionSet = CoolgActionSet;
        np.setShade(sp.getShade());
        nu.Personality = CoolgPersonality;
        nu.Attrib = CoolgAttrib;
        ++Game.TotalKillable;
        Coolg.CoolgCommon(newsp);
    }

    private static void DoCoolgBirth(int newsp) {
        USER u = Gameutils.getUser(newsp);
        if (u == null) {
            return;
        }
        u.Health = 65;
        u.Attrib = CoolgAttrib;
        Ai.DoActorSetSpeed(newsp, 1);
        Sprites.ChangeState(newsp, s_CoolgRun[0][0]);
        u.StateEnd = s_CoolgDie[0];
        u.setRot(sg_CoolgRun);
        Coolie.EnemyDefaults(newsp, CoolgActionSet, CoolgPersonality);
        --Game.TotalKillable;
        u.Flags |= Gameutils.SPR_NO_SCAREDZ | Gameutils.SPR_XFLIP_TOGGLE;
        Coolg.CoolgCommon(newsp);
    }

    private static void NullCoolg(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        u.ShellNum -= 6;
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Coolg.DoCoolgMatchPlayerZ(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoCoolgMatchPlayerZ(int SpriteNum) {
        int bound;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return;
        }
        if (!MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_BLOCK) || !MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN)) {
            JWeapon.InitBloodSpray(SpriteNum, true, 105);
            JWeapon.InitBloodSpray(SpriteNum, true, 105);
            Weapon.UpdateSinglePlayKills(SpriteNum, null);
            Weapon.SetSuicide(SpriteNum);
        }
        int zdiff = Gameutils.SPRITEp_MID(tsp) - u.sz;
        int zdist = Gameutils.Z(20 + Gameutils.RANDOM_RANGE(100));
        if (Pragmas.klabs(zdiff) > zdist) {
            u.sz = zdiff > 0 ? (u.sz += 1020) : (u.sz -= 1020);
        }
        int loz = u.loz;
        int hiz = u.hiz;
        Sect_User su = Sector.getSectUser(u.lo_sectp);
        if (u.lo_sectp != -1 && su != null && su.depth != 0) {
            loz -= Gameutils.Z(su.depth) - Gameutils.Z(8);
        }
        if (u.sz > (bound = u.lo_sp != -1 ? loz - u.floor_dist : loz - u.floor_dist - COOLG_BOB_AMT)) {
            u.sz = bound;
        }
        if (u.sz < (bound = u.hi_sp != -1 ? hiz + u.ceiling_dist : hiz + u.ceiling_dist + COOLG_BOB_AMT)) {
            u.sz = bound;
        }
        u.sz = Math.min(u.sz, loz - u.floor_dist);
        u.sz = Math.max(u.sz, hiz + u.ceiling_dist);
        u.Counter = u.Counter + 48 & 0x7FF;
        sp.setZ(u.sz + (COOLG_BOB_AMT * EngineUtils.sin(u.Counter) >> 14));
        bound = u.hiz + u.ceiling_dist + COOLG_BOB_AMT;
        if (sp.getZ() < bound) {
            u.sz = bound + COOLG_BOB_AMT;
            sp.setZ(u.sz);
        }
    }

    private static void InitCoolgCircle(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.ActorActionFunc = DoCoolgCircle;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        Ai.DoActorSetSpeed(SpriteNum, 3);
        sp.setXvel(400);
        u.Counter2 = sp.getXvel() / 3;
        if (Gameutils.RANDOM_P2(1024) < 512) {
            u.Counter2 = -u.Counter2;
        }
        u.jump_speed = 400 + Gameutils.RANDOM_P2(256);
        if (Pragmas.klabs(u.sz - u.hiz) < Pragmas.klabs(u.sz - u.loz)) {
            u.jump_speed = -u.jump_speed;
        }
        u.WaitTics = (Gameutils.RANDOM_RANGE(3) + 1) * 120;
        u.ActorActionFunc.animatorInvoke(SpriteNum);
    }

    private static void DoCoolgCircle(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + u.Counter2));
        int nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        int ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny, 0)) {
            Ai.InitActorReposition.animatorInvoke(SpriteNum);
            return;
        }
        u.sz -= u.jump_speed * 6;
        int bound = u.hiz + u.ceiling_dist + COOLG_BOB_AMT;
        if (u.sz < bound) {
            u.sz = bound;
            Ai.InitActorReposition.animatorInvoke(SpriteNum);
            return;
        }
        if ((u.WaitTics -= 6) < 0) {
            Ai.InitActorReposition.animatorInvoke(SpriteNum);
            u.WaitTics = 0;
        }
    }

    private static void DoCoolgDeath(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_TRANSLUCENT);
        sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
        sp.setXrepeat(42);
        sp.setShade(-10);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
            Actor.DoFall(SpriteNum);
        } else {
            Weapon.DoFindGroundPoint(SpriteNum);
            u.floor_dist = 0;
            Actor.DoBeginFall(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        int nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        int ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14;
        u.moveSpriteReturn = Sprites.move_sprite(SpriteNum, nx, ny, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.DoFindGroundPoint(SpriteNum);
        if (sp.getZ() >= u.loz) {
            u.Flags &= ~(Gameutils.SPR_FALLING | Gameutils.SPR_SLIDING);
            sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YFLIP);
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Dead);
        }
    }

    private static void DoCoolgMove(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if ((u.ShellNum -= 6) <= 0) {
            switch (u.FlagOwner) {
                case 0: {
                    sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_TRANSLUCENT);
                    u.ShellNum = Gameutils.SEC(2);
                    break;
                }
                case 1: {
                    Sound.PlaySound(213, sp, 1);
                    sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_TRANSLUCENT);
                    sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_INVISIBLE);
                    u.ShellNum = Gameutils.SEC(1) + Gameutils.SEC(Gameutils.RANDOM_RANGE(2));
                    break;
                }
                case 2: {
                    sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_TRANSLUCENT);
                    sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
                    u.ShellNum = Gameutils.SEC(2);
                    break;
                }
                case 3: {
                    Sound.PlaySound(213, sp, 1);
                    sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_TRANSLUCENT);
                    sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
                    u.ShellNum = Gameutils.SEC(2) + Gameutils.SEC(Gameutils.RANDOM_RANGE(3));
                    break;
                }
                default: {
                    u.FlagOwner = 0;
                }
            }
            ++u.FlagOwner;
            if (u.FlagOwner > 3) {
                u.FlagOwner = 0;
            }
        }
        if (u.FlagOwner - 1 == 0) {
            sp.setXrepeat(sp.getXrepeat() - 1);
            sp.setShade(sp.getShade() + 1);
            if (sp.getXrepeat() < 4) {
                sp.setXrepeat(4);
            }
            if (sp.getShade() > 126) {
                sp.setShade(127);
                sp.setHitag(9998);
            }
        } else if (u.FlagOwner - 1 == 2) {
            sp.setHitag(0);
            sp.setXrepeat(sp.getXrepeat() + 1);
            sp.setShade(sp.getShade() - 1);
            if (sp.getXrepeat() > 42) {
                sp.setXrepeat(42);
            }
            if (sp.getShade() < -10) {
                sp.setShade(-10);
            }
        } else if (u.FlagOwner == 0) {
            sp.setXrepeat(42);
            sp.setShade(-10);
            sp.setHitag(0);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        if (Gameutils.RANDOM_P2(1024) < 32 && !MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
            Weapon.InitCoolgDrip(SpriteNum);
        }
        Coolg.DoCoolgMatchPlayerZ(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoCoolgPain(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        Coolg.NullCoolg(SpriteNum);
        if ((u.WaitTics -= 6) <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    public static void CoolgSaveable() {
        Saveable.SaveData(DoCoolgBirth);
        Saveable.SaveData(NullCoolg);
        Saveable.SaveData(InitCoolgCircle);
        Saveable.SaveData(DoCoolgCircle);
        Saveable.SaveData(DoCoolgDeath);
        Saveable.SaveData(DoCoolgMove);
        Saveable.SaveData(DoCoolgPain);
        Saveable.SaveData(CoolgPersonality);
        Saveable.SaveData(CoolgAttrib);
        Saveable.SaveData(s_CoolgRun);
        Saveable.SaveGroup(sg_CoolgRun);
        Saveable.SaveData(s_CoolgStand);
        Saveable.SaveGroup(sg_CoolgStand);
        Saveable.SaveData(s_CoolgAttack);
        Saveable.SaveGroup(sg_CoolgAttack);
        Saveable.SaveData(s_CoolgPain);
        Saveable.SaveGroup(sg_CoolgPain);
        Saveable.SaveData(s_CoolgDie);
        Saveable.SaveGroup(sg_CoolgDie);
        Saveable.SaveData(s_CoolgDead);
        Saveable.SaveGroup(sg_CoolgDead);
        Saveable.SaveData(s_CoolgBirth);
        Saveable.SaveData(CoolgActionSet);
    }
}

