/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Eel {
    public static final int EEL_RUN_RATE = 20;
    public static final int EEL_FIRE_RATE = 12;
    public static final int EEL_DIE_RATE = 20;
    private static final Animator InitEelFire = new Animator(Eel::InitEelFire);
    private static final Animator DoEelDeath = new Animator(Eel::DoEelDeath);
    private static final Decision[] EelBattle = new Decision[]{new Decision(649, Ai.InitActorMoveCloser), new Decision(650, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] EelOffense = new Decision[]{new Decision(649, Ai.InitActorMoveCloser), new Decision(750, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] EelBroadcast = new Decision[]{new Decision(3, Ai.InitActorAlertNoise), new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] EelSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] EelEvasive = new Decision[]{new Decision(790, Ai.InitActorRunAway), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] EelLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] EelCloseRange = new Decision[]{new Decision(950, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Decision[] EelTouchTarget = new Decision[]{new Decision(1024, Ai.InitActorAttack)};
    private static final Personality EelPersonality = new Personality(EelBattle, EelOffense, EelBroadcast, EelSurprised, EelEvasive, EelLostTarget, EelCloseRange, EelTouchTarget);
    private static final ATTRIBUTE EelAttrib = new ATTRIBUTE(new short[]{100, 110, 120, 130}, new short[]{3, 0, -2, -3}, 3, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final State[] s_EelDie = new State[]{new State(3795, 20, DoEelDeath), new State(3795, 20, DoEelDeath), new State(3795, 20, DoEelDeath), new State(3795, 20, DoEelDeath), new State(3795, 20, DoEelDeath), new State(3795, 20, DoEelDeath).setNext()};
    private static final EnemyStateGroup sg_EelDie = new EnemyStateGroup(new State[][]{s_EelDie});
    private static final State[] s_EelDead = new State[]{new State(3795, 20, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_EelDead = new EnemyStateGroup(new State[][]{s_EelDead});
    private static final int EEL_BOB_AMT = Gameutils.Z(4);
    private static final Animator NullEel = new Animator(Eel::NullEel);
    private static final Animator DoEelMove = new Animator(Eel::DoEelMove);
    private static final State[][] s_EelRun = new State[][]{{new State(3780, 20, DoEelMove), new State(3781, 20, DoEelMove), new State(3782, 20, DoEelMove), new State(3781, 20, DoEelMove)}, {new State(3783, 20, DoEelMove), new State(3784, 20, DoEelMove), new State(3785, 20, DoEelMove), new State(3784, 20, DoEelMove)}, {new State(3786, 20, DoEelMove), new State(3787, 20, DoEelMove), new State(3788, 20, DoEelMove), new State(3787, 20, DoEelMove)}, {new State(3789, 20, DoEelMove), new State(3790, 20, DoEelMove), new State(3791, 20, DoEelMove), new State(3790, 20, DoEelMove)}, {new State(3792, 20, DoEelMove), new State(3793, 20, DoEelMove), new State(3794, 20, DoEelMove), new State(3793, 20, DoEelMove)}};
    private static final EnemyStateGroup sg_EelRun = new EnemyStateGroup(s_EelRun[0], s_EelRun[1], s_EelRun[2], s_EelRun[3], s_EelRun[4]);
    private static final State[][] s_EelStand = new State[][]{{new State(3780, 20, DoEelMove).setNext()}, {new State(3783, 20, DoEelMove).setNext()}, {new State(3786, 20, DoEelMove).setNext()}, {new State(3789, 20, DoEelMove).setNext()}, {new State(3792, 20, DoEelMove).setNext()}};
    private static final EnemyStateGroup sg_EelStand = new EnemyStateGroup(s_EelStand[0], s_EelStand[1], s_EelStand[2], s_EelStand[3], s_EelStand[4]);
    private static final State[][] s_EelAttack = new State[][]{{new State(3760, 24, NullEel), new State(3761, 24, NullEel), new State(3762, 24, NullEel), new State(3762, Gameutils.SF_QUICK_CALL, InitEelFire), new State(3762, 12, NullEel), new State(3763, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(3783, 12, DoEelMove).setNext()}, {new State(3763, 24, NullEel), new State(3764, 24, NullEel), new State(3765, 24, NullEel), new State(3765, Gameutils.SF_QUICK_CALL, InitEelFire), new State(3765, 12, NullEel), new State(3766, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(3783, 12, DoEelMove).setNext()}, {new State(3766, 24, NullEel), new State(3767, 24, NullEel), new State(3768, 24, NullEel), new State(3768, Gameutils.SF_QUICK_CALL, InitEelFire), new State(3768, 12, NullEel), new State(3769, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(3783, 12, DoEelMove).setNext()}, {new State(3789, 24, NullEel), new State(3790, 24, NullEel), new State(3791, 24, NullEel), new State(3791, Gameutils.SF_QUICK_CALL, InitEelFire), new State(3791, 12, NullEel), new State(3792, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(3783, 12, DoEelMove).setNext()}, {new State(3792, 24, NullEel), new State(3793, 24, NullEel), new State(3794, 24, NullEel), new State(3794, Gameutils.SF_QUICK_CALL, InitEelFire), new State(3794, 12, NullEel), new State(3795, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(3783, 12, DoEelMove).setNext()}};
    private static final EnemyStateGroup sg_EelAttack = new EnemyStateGroup(s_EelAttack[0], s_EelAttack[1], s_EelAttack[2], s_EelAttack[3], s_EelAttack[4]);
    private static final Actor_Action_Set EelActionSet = new Actor_Action_Set(sg_EelStand, sg_EelRun, null, null, null, sg_EelRun, null, null, sg_EelStand, null, null, sg_EelStand, sg_EelDie, null, sg_EelDead, null, null, new StateGroup[]{sg_EelAttack}, new short[]{1024}, new StateGroup[]{sg_EelAttack}, new short[]{1024}, null, null, null);

    public static void InitEelStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_EelRun, sg_EelStand, sg_EelDie, sg_EelAttack, sg_EelDead}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    private static void EelCommon(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        sp.setClipdist(25);
        u.floor_dist = Gameutils.Z(16);
        u.ceiling_dist = Gameutils.Z(20);
        u.sz = sp.getZ();
        sp.setXrepeat(35);
        sp.setYrepeat(27);
        u.Radius = 400;
    }

    public static void SetupEel(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 3780, s_EelRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 40;
        }
        Sprites.ChangeState(SpriteNum, s_EelRun[0][0]);
        u.Attrib = EelAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_EelDie[0];
        u.setRot(sg_EelRun);
        Coolie.EnemyDefaults(SpriteNum, EelActionSet, EelPersonality);
        u.Flags |= Gameutils.SPR_NO_SCAREDZ | Gameutils.SPR_XFLIP_TOGGLE;
        Eel.EelCommon(SpriteNum);
        u.Flags &= ~Gameutils.SPR_SHADOW;
        u.zclip = Gameutils.Z(8);
    }

    private static void NullEel(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Eel.DoEelMatchPlayerZ(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoEelMatchPlayerZ(int SpriteNum) {
        WangSprite hisp;
        int dist;
        WangSprite losp;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return;
        }
        ru.m210projects.Build.Types.Sector s = Main.boardService.getSector(sp.getSectnum());
        if (s != null && Gameutils.FAF_ConnectArea(sp.getSectnum())) {
            if (u.hi_sectp != -1) {
                u.hiz = s.getCeilingz() + Gameutils.Z(16);
                u.hi_sectp = sp.getSectnum();
            } else if (u.hiz < s.getCeilingz() + Gameutils.Z(16)) {
                u.hiz = s.getCeilingz() + Gameutils.Z(16);
            }
        }
        int zdiff = Gameutils.SPRITEp_BOS(tsp) - Gameutils.Z(8) - u.sz;
        int zdist = Gameutils.Z(20 + Gameutils.RANDOM_RANGE(64));
        if (Pragmas.klabs(zdiff) > zdist) {
            u.sz = zdiff > 0 ? (u.sz += 960) : (u.sz -= 960);
        }
        int loz = u.loz;
        int hiz = u.hiz;
        Sect_User su = Sector.getSectUser(u.lo_sectp);
        if (u.lo_sectp != -1 && su != null && su.depth != 0) {
            loz -= Gameutils.Z(su.depth) - Gameutils.Z(8);
        }
        int bound = (losp = Main.boardService.getSprite(u.lo_sp)) != null && u.tgt_sp == u.hi_sp ? ((dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), losp.getX(), losp.getY())) <= 300 ? u.sz : loz - u.floor_dist) : loz - u.floor_dist - EEL_BOB_AMT;
        if (u.sz > bound) {
            u.sz = bound;
        }
        bound = (hisp = Main.boardService.getSprite(u.hi_sp)) != null && u.tgt_sp == u.hi_sp ? ((dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), hisp.getX(), hisp.getY())) <= 300 ? u.sz : hiz + u.ceiling_dist) : hiz + u.ceiling_dist + EEL_BOB_AMT;
        if (u.sz < bound) {
            u.sz = bound;
        }
        u.sz = Math.min(u.sz, loz - u.floor_dist);
        u.sz = Math.max(u.sz, hiz + u.ceiling_dist);
        u.Counter = u.Counter + 48 + 12 & 0x7FF;
        sp.setZ(u.sz + (EEL_BOB_AMT * EngineUtils.sin(u.Counter) >> 14));
        bound = u.hiz + u.ceiling_dist + EEL_BOB_AMT;
        if (sp.getZ() < bound) {
            u.sz = bound + EEL_BOB_AMT;
            sp.setZ(u.sz);
        }
    }

    public static void InitEelFire(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        for (int j : Weapon.StatDamageList) {
            ListNode<Sprite> node = Main.boardService.getStatNode(j);
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite hp = node.get();
                USER hu = Gameutils.getUser(i);
                if (i != SpriteNum && i == u.tgt_sp && (hu == null || Gameutils.FindDistance3D(sp.getX() - hp.getX(), sp.getY() - hp.getY(), sp.getZ() - hp.getZ() >> 4) <= hu.Radius + u.Radius)) {
                    int dist = Gameutils.DISTANCE(hp.getX(), hp.getY(), sp.getX(), sp.getY());
                    if (dist < Weapon.CLOSE_RANGE_DIST_FUDGE(sp, hp, 600) && Gameutils.FACING_RANGE(hp, sp, 150)) {
                        Sound.PlaySound(395, sp, 0);
                        Weapon.DoDamage(i, SpriteNum);
                    } else {
                        Ai.InitActorReposition.animatorInvoke(SpriteNum);
                    }
                }
                node = nexti;
            }
        }
    }

    private static void DoEelDeath(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
            Actor.DoFall(SpriteNum);
        } else {
            Weapon.DoFindGroundPoint(SpriteNum);
            u.floor_dist = 0;
            Actor.DoBeginFall(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        int nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        int ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14;
        u.moveSpriteReturn = Sprites.move_sprite(SpriteNum, nx, ny, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.DoFindGroundPoint(SpriteNum);
        if (sp.getZ() >= u.loz) {
            u.Flags &= ~(Gameutils.SPR_FALLING | Gameutils.SPR_SLIDING);
            if (Gameutils.RANDOM_RANGE(1000) > 500) {
                sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_XFLIP);
            }
            if (Gameutils.RANDOM_RANGE(1000) > 500) {
                sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YFLIP);
            }
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Dead);
        }
    }

    private static void DoEelMove(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (Sprites.SpriteOverlap(SpriteNum, u.tgt_sp)) {
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.CloseAttack[0]);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        Eel.DoEelMatchPlayerZ(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static void EelSaveable() {
        Saveable.SaveData(NullEel);
        Saveable.SaveData(InitEelFire);
        Saveable.SaveData(DoEelDeath);
        Saveable.SaveData(DoEelMove);
        Saveable.SaveData(EelPersonality);
        Saveable.SaveData(EelAttrib);
        Saveable.SaveData(s_EelRun);
        Saveable.SaveGroup(sg_EelRun);
        Saveable.SaveData(s_EelStand);
        Saveable.SaveGroup(sg_EelStand);
        Saveable.SaveData(s_EelAttack);
        Saveable.SaveGroup(sg_EelAttack);
        Saveable.SaveData(s_EelDie);
        Saveable.SaveGroup(sg_EelDie);
        Saveable.SaveData(s_EelDead);
        Saveable.SaveGroup(sg_EelDead);
        Saveable.SaveData(EelActionSet);
    }
}

