/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Goro {
    public static final int GORO_PAIN_R0 = 1489;
    public static final int GORO_PAIN_R1 = 1492;
    public static final int GORO_PAIN_R2 = 1495;
    public static final int GORO_PAIN_R3 = 1481;
    public static final int GORO_PAIN_R4 = 1485;
    public static final int GORO_RUN_RATE = 18;
    public static final int GORO_CHOP_RATE = 14;
    public static final int GORO_SPELL_RATE = 6;
    public static final int GORO_SPELL_PAUSE = 30;
    public static final int GORO_STAND_RATE = 12;
    public static final int GORO_PAIN_RATE = 12;
    public static final int GORO_DIE_RATE = 16;
    private static final Animator DoGoroMove = new Animator(Goro::DoGoroMove);
    private static final Animator NullGoro = new Animator(Goro::NullGoro);
    private static final Animator InitGoroChop = new Animator(Goro::InitGoroChop);
    private static final Animator InitEnemyFireball = new Animator(Goro::InitEnemyFireball);
    private static final Animator DoGoroPain = new Animator(Goro::DoGoroPain);
    private static final Decision[] GoroBattle = new Decision[]{new Decision(697, Ai.InitActorMoveCloser), new Decision(700, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] GoroOffense = new Decision[]{new Decision(797, Ai.InitActorMoveCloser), new Decision(800, Ai.InitActorAttackNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] GoroBroadcast = new Decision[]{new Decision(3, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] GoroSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] GoroEvasive = new Decision[]{new Decision(10, Ai.InitActorEvade), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] GoroLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] GoroCloseRange = new Decision[]{new Decision(700, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality GoroPersonality = new Personality(GoroBattle, GoroOffense, GoroBroadcast, GoroSurprised, GoroEvasive, GoroLostTarget, GoroCloseRange, GoroCloseRange);
    private static final ATTRIBUTE GoroAttrib = new ATTRIBUTE(new short[]{160, 180, 200, 230}, new short[]{3, 0, -2, -3}, 3, new int[]{101, 102, 0, 103, 104, 106, 105, 0, 0, 0});
    private static final State[][] s_GoroRun = new State[][]{{new State(1469, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1470, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1471, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1472, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove)}, {new State(1473, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1474, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1475, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1476, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove)}, {new State(1477, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1478, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1479, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1480, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove)}, {new State(1481, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1482, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1483, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1484, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove)}, {new State(1485, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1486, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1487, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1488, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove)}};
    private static final EnemyStateGroup sg_GoroRun = new EnemyStateGroup(s_GoroRun[0], s_GoroRun[1], s_GoroRun[2], s_GoroRun[3], s_GoroRun[4]);
    private static final State[][] s_GoroChop = new State[][]{{new State(1489, 14, NullGoro), new State(1490, 14, NullGoro), new State(1491, 14, NullGoro), new State(1491, Gameutils.SF_QUICK_CALL, InitGoroChop), new State(1491, 14, NullGoro), new State(1491, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1491, 14, DoGoroMove).setNext()}, {new State(1492, 14, NullGoro), new State(1493, 14, NullGoro), new State(1494, 14, NullGoro), new State(1494, Gameutils.SF_QUICK_CALL, InitGoroChop), new State(1494, 14, NullGoro), new State(1494, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1494, 14, DoGoroMove).setNext()}, {new State(1495, 14, NullGoro), new State(1496, 14, NullGoro), new State(1497, 14, NullGoro), new State(1497, Gameutils.SF_QUICK_CALL, InitGoroChop), new State(1497, 14, NullGoro), new State(1497, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1497, 14, DoGoroMove).setNext()}, {new State(1481, 14, NullGoro), new State(1482, 14, NullGoro), new State(1483, 14, NullGoro), new State(1483, Gameutils.SF_QUICK_CALL, InitGoroChop), new State(1483, 14, NullGoro), new State(1483, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1483, 14, DoGoroMove).setNext()}, {new State(1485, 14, NullGoro), new State(1486, 14, NullGoro), new State(1487, 14, NullGoro), new State(1487, Gameutils.SF_QUICK_CALL, InitGoroChop), new State(1487, 14, NullGoro), new State(1487, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1487, 14, DoGoroMove).setNext()}};
    private static final EnemyStateGroup sg_GoroChop = new EnemyStateGroup(s_GoroChop[0], s_GoroChop[1], s_GoroChop[2], s_GoroChop[3], s_GoroChop[4]);
    private static final State[][] s_GoroSpell = new State[][]{{new State(1513, 30, NullGoro), new State(1514, 30, NullGoro), new State(1514, 6, InitEnemyFireball), new State(1514, 6, NullGoro), new State(1514, 6, InitEnemyFireball), new State(1514, 6, NullGoro), new State(1514, 6, InitEnemyFireball), new State(1514, 30, NullGoro), new State(1514, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1514, 6, DoGoroMove).setNext()}, {new State(1515, 30, NullGoro), new State(1516, 30, NullGoro), new State(1516, 6, InitEnemyFireball), new State(1516, 6, NullGoro), new State(1516, 6, InitEnemyFireball), new State(1516, 6, NullGoro), new State(1516, 6, InitEnemyFireball), new State(1516, 30, NullGoro), new State(1516, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1516, 6, DoGoroMove).setNext()}, {new State(1517, 30, NullGoro), new State(1518, 30, NullGoro), new State(1518, 6, InitEnemyFireball), new State(1518, 6, NullGoro), new State(1518, 6, InitEnemyFireball), new State(1518, 6, NullGoro), new State(1518, 6, InitEnemyFireball), new State(1518, 30, NullGoro), new State(1518, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1518, 6, DoGoroMove).setNext()}, {new State(1481, 30, NullGoro), new State(1482, 30, NullGoro), new State(1482, 6, InitEnemyFireball), new State(1482, 6, NullGoro), new State(1482, 6, InitEnemyFireball), new State(1482, 6, NullGoro), new State(1482, 6, InitEnemyFireball), new State(1482, 30, NullGoro), new State(1482, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1482, 6, DoGoroMove).setNext()}, {new State(1485, 30, NullGoro), new State(1486, 30, NullGoro), new State(1486, 6, InitEnemyFireball), new State(1486, 6, NullGoro), new State(1486, 6, InitEnemyFireball), new State(1486, 6, NullGoro), new State(1486, 6, InitEnemyFireball), new State(1486, 30, NullGoro), new State(1486, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1486, 6, DoGoroMove).setNext()}};
    private static final EnemyStateGroup sg_GoroSpell = new EnemyStateGroup(s_GoroSpell[0], s_GoroSpell[1], s_GoroSpell[2], s_GoroSpell[3], s_GoroSpell[4]);
    private static final State[][] s_GoroStand = new State[][]{{new State(1489, 12, DoGoroMove).setNext()}, {new State(1492, 12, DoGoroMove).setNext()}, {new State(1495, 12, DoGoroMove).setNext()}, {new State(1481, 12, DoGoroMove).setNext()}, {new State(1485, 12, DoGoroMove).setNext()}};
    private static final EnemyStateGroup sg_GoroStand = new EnemyStateGroup(s_GoroStand[0], s_GoroStand[1], s_GoroStand[2], s_GoroStand[3], s_GoroStand[4]);
    private static final State[][] s_GoroPain = new State[][]{{new State(1489, 12, DoGoroPain).setNext()}, {new State(1492, 12, DoGoroPain).setNext()}, {new State(1495, 12, DoGoroPain).setNext()}, {new State(1481, 12, DoGoroPain).setNext()}, {new State(1485, 12, DoGoroPain).setNext()}};
    private static final EnemyStateGroup sg_GoroPain = new EnemyStateGroup(s_GoroPain[0], s_GoroPain[1], s_GoroPain[2], s_GoroPain[3], s_GoroPain[4]);
    private static final State[] s_GoroDie = new State[]{new State(1504, 16, NullGoro), new State(1505, 16, NullGoro), new State(1506, 16, NullGoro), new State(1507, 16, NullGoro), new State(1508, 16, NullGoro), new State(1509, 16, NullGoro), new State(1510, 16, NullGoro), new State(1511, 16, NullGoro), new State(1512, 16, NullGoro), new State(1512, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(1512, 16, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_GoroDie = new EnemyStateGroup(new State[][]{s_GoroDie});
    private static final State[] s_GoroDead = new State[]{new State(1512, 16, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_GoroDead = new EnemyStateGroup(new State[][]{s_GoroDead});
    private static final Actor_Action_Set GoroActionSet = new Actor_Action_Set(sg_GoroStand, sg_GoroRun, null, null, null, null, null, null, null, null, null, sg_GoroPain, sg_GoroDie, null, sg_GoroDead, null, null, new StateGroup[]{sg_GoroChop}, new short[]{1024}, new StateGroup[]{sg_GoroSpell}, new short[]{1024}, null, null, null);

    public static void InitGoroStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_GoroStand, sg_GoroRun, sg_GoroPain, sg_GoroDie, sg_GoroDead, sg_GoroChop, sg_GoroSpell}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    public static void SetupGoro(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 1469, s_GoroRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 200;
        }
        Sprites.ChangeState(SpriteNum, s_GoroRun[0][0]);
        u.Attrib = GoroAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_GoroDie[0];
        u.setRot(sg_GoroRun);
        Coolie.EnemyDefaults(SpriteNum, GoroActionSet, GoroPersonality);
        sp.setClipdist(128);
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
    }

    public static void InitEnemyFireball(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite fp = null;
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return;
        }
        Sound.PlaySound(187, sp, 0);
        sp.setAng(Gameutils.NORM_ANGLE(EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY())));
        int size_z = Gameutils.Z(Gameutils.SPRITEp_SIZE_Y(sp));
        int nz = sp.getZ() - size_z + MyTypes.DIV4(size_z) + MyTypes.DIV8(size_z) + Gameutils.Z(4);
        int xchange = Gameutils.MOVEx(800, sp.getAng());
        int ychange = Gameutils.MOVEy(800, sp.getAng());
        for (int i = 0; i < 2; ++i) {
            int w = Sprites.SpawnSprite(4, 2036, Weapon.s_Fireball[0], sp.getSectnum(), sp.getX(), sp.getY(), nz, sp.getAng(), 800);
            WangSprite wp = Main.boardService.getSprite(w);
            USER wu = Gameutils.getUser(w);
            if (wp == null || wu == null) {
                return;
            }
            wp.setHitag(9999);
            wp.setXrepeat(20);
            wp.setYrepeat(20);
            wp.setShade(-40);
            Sprites.SetOwner(SpriteNum, w);
            wp.setZvel(0);
            wp.setClipdist(4);
            wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() + Weapon.lat_ang[i]));
            Weapon.HelpMissileLateral(w, 500);
            wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() - Weapon.lat_ang[i]));
            wu.xchange = xchange;
            wu.ychange = ychange;
            Weapon.MissileSetPos(w, Weapon.DoFireball, 700);
            if (i == 0) {
                fp = wp;
                int dist = EngineUtils.sqrt(Gameutils.SQ(wp.getX() - tsp.getX()) + Gameutils.SQ(wp.getY() - tsp.getY()));
                int targ_z = tsp.getZ() - MyTypes.DIV2(Gameutils.Z(Gameutils.SPRITEp_SIZE_Y(sp)));
                if (dist == 0) continue;
                wu.zchange = (short)(800 * (targ_z - wp.getZ()) / dist);
                wp.setZvel(wu.zchange);
                continue;
            }
            wu.zchange = fp.getZvel();
            wp.setZvel(wu.zchange);
        }
    }

    public static void InitGoroChop(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        Sound.PlaySound(106, sp, 0);
        block0: for (int stat = 0; stat < Weapon.StatDamageList.length; stat = (int)((short)(stat + 1))) {
            ListNode<Sprite> node = Main.boardService.getStatNode(Weapon.StatDamageList[stat]);
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite hp = node.get();
                if (i == SpriteNum) continue block0;
                int dist = Gameutils.DISTANCE(hp.getX(), hp.getY(), sp.getX(), sp.getY());
                if (dist < Weapon.CLOSE_RANGE_DIST_FUDGE(sp, hp, 700) && Gameutils.FACING_RANGE(hp, sp, 150)) {
                    Sound.PlaySound(107, sp, 0);
                    Weapon.DoDamage(i, SpriteNum);
                }
                node = nexti;
            }
        }
    }

    private static void NullGoro(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoGoroPain(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        Goro.NullGoro(SpriteNum);
        if (u != null && (u.WaitTics -= 6) <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    private static void DoGoroMove(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static void GoroSaveable() {
        Saveable.SaveData(InitGoroChop);
        Saveable.SaveData(InitEnemyFireball);
        Saveable.SaveData(NullGoro);
        Saveable.SaveData(DoGoroPain);
        Saveable.SaveData(DoGoroMove);
        Saveable.SaveData(GoroPersonality);
        Saveable.SaveData(GoroAttrib);
        Saveable.SaveData(s_GoroRun);
        Saveable.SaveGroup(sg_GoroRun);
        Saveable.SaveData(s_GoroChop);
        Saveable.SaveGroup(sg_GoroChop);
        Saveable.SaveData(s_GoroSpell);
        Saveable.SaveGroup(sg_GoroSpell);
        Saveable.SaveData(s_GoroStand);
        Saveable.SaveGroup(sg_GoroStand);
        Saveable.SaveData(s_GoroPain);
        Saveable.SaveGroup(sg_GoroPain);
        Saveable.SaveData(s_GoroDie);
        Saveable.SaveData(s_GoroDead);
        Saveable.SaveGroup(sg_GoroDie);
        Saveable.SaveGroup(sg_GoroDead);
        Saveable.SaveData(GoroActionSet);
    }
}

