/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Lava {
    private static final Animator DoLavaMove = new Animator(Lava::DoLavaMove);
    private static final Animator NullLava = new Animator(Lava::NullLava);
    private static final Animator InitLavaThrow = new Animator(Lava::InitLavaThrow);
    private static final Animator InitLavaFlame = new Animator(Animator.NULL);
    public static final int LAVA_STAND_RATE = 12;
    public static final int LAVA_RUN_RATE = 24;
    public static final int LAVA_THROW_RATE = 9;
    public static final int LAVA_FLAME_RATE = 18;
    public static final int LAVA_DIE_RATE = 20;
    private static final Decision[] LavaBattle = new Decision[]{new Decision(600, Ai.InitActorMoveCloser), new Decision(700, Ai.InitActorAlertNoise), new Decision(710, Ai.InitActorRunAway), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] LavaOffense = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(800, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] LavaBroadcast = new Decision[]{new Decision(21, Ai.InitActorAlertNoise), new Decision(51, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] LavaSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] LavaEvasive = new Decision[]{new Decision(10, Ai.InitActorEvade), new Decision(1024, null)};
    private static final Decision[] LavaLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] LavaCloseRange = new Decision[]{new Decision(700, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality LavaPersonality = new Personality(LavaBattle, LavaOffense, LavaBroadcast, LavaSurprised, LavaEvasive, LavaLostTarget, LavaCloseRange, LavaCloseRange);
    private static final ATTRIBUTE LavaAttrib = new ATTRIBUTE(new short[]{200, 220, 240, 270}, new short[]{3, 0, -2, -3}, 3, new int[]{132, 135, 137, 139, 141, 133, 134, 136, 138, 140});
    private static final State[][] s_LavaStand = new State[][]{{new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}};
    private static final State[][] s_LavaRun = new State[][]{{new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}};
    private static final State[][] s_LavaThrow = new State[][]{{new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}};
    private static final State[][] s_LavaFlame = new State[][]{{new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}};
    private static final State[] s_LavaDie = new State[]{new State(2355, 20, NullLava), new State(2355, 20, Actor.DoActorDebris).setNext()};
    private static final State[] s_LavaDead = new State[]{new State(2355, 20, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_LavaStand = new EnemyStateGroup(s_LavaStand[0], s_LavaStand[1], s_LavaStand[2], s_LavaStand[3], s_LavaStand[4]);
    private static final EnemyStateGroup sg_LavaRun = new EnemyStateGroup(s_LavaRun[0], s_LavaRun[1], s_LavaRun[2], s_LavaRun[3], s_LavaRun[4]);
    private static final EnemyStateGroup sg_LavaDie = new EnemyStateGroup(new State[][]{s_LavaDie});
    private static final EnemyStateGroup sg_LavaDead = new EnemyStateGroup(new State[][]{s_LavaDead});
    private static final EnemyStateGroup sg_LavaFlame = new EnemyStateGroup(s_LavaFlame[0], s_LavaFlame[1], s_LavaFlame[2], s_LavaFlame[3], s_LavaFlame[4]);
    private static final EnemyStateGroup sg_LavaThrow = new EnemyStateGroup(s_LavaThrow[0], s_LavaThrow[1], s_LavaThrow[2], s_LavaThrow[3], s_LavaThrow[4]);
    private static final Actor_Action_Set LavaActionSet = new Actor_Action_Set(sg_LavaStand, sg_LavaRun, null, null, null, null, null, null, null, null, null, null, sg_LavaDie, null, sg_LavaDead, null, null, new StateGroup[]{sg_LavaFlame}, new short[]{1024}, new StateGroup[]{sg_LavaFlame, sg_LavaThrow, sg_LavaThrow, sg_LavaThrow}, new short[]{256, 512, 768, 1024}, null, null, null);

    public static void InitLavaStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_LavaStand, sg_LavaRun, sg_LavaDie, sg_LavaDead, sg_LavaFlame, sg_LavaThrow}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    public static void SetupLava(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 2355, s_LavaRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 100;
        }
        Sprites.ChangeState(SpriteNum, s_LavaRun[0][0]);
        u.Attrib = LavaAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_LavaDie[0];
        u.setRot(sg_LavaRun);
        Coolie.EnemyDefaults(SpriteNum, LavaActionSet, LavaPersonality);
        sp.setXrepeat(110);
        sp.setYrepeat(110);
        sp.setClipdist(128);
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE | Gameutils.SPR_ELECTRO_TOLERANT;
        u.loz = sp.getZ();
    }

    private static void NullLava(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoLavaMove(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static boolean InitLavaThrow(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return false;
        }
        int nang = EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY());
        sp.setAng(nang);
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = Gameutils.SPRITEp_TOS(sp) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp));
        int w = Sprites.SpawnSprite(4, 2196, Weapon.s_LavaBoulder[0], sp.getSectnum(), nx, ny, nz, nang, 500);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return false;
        }
        Sprites.SetOwner(SpriteNum, w);
        wp.setHitag(9999);
        wp.setYrepeat(72);
        wp.setXrepeat(72);
        wp.setShade(-15);
        wp.setZvel(0);
        wp.setAng(nang);
        if (Gameutils.RANDOM_P2(1024) > 512) {
            wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_XFLIP);
        }
        if (Gameutils.RANDOM_P2(1024) > 512) {
            wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YFLIP);
        }
        wu.Radius = 200;
        wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        wp.setClipdist(64);
        wu.ceiling_dist = Gameutils.Z(14);
        wu.floor_dist = Gameutils.Z(14);
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel();
        Weapon.MissileSetPos(w, Weapon.DoLavaBoulder, 1200);
        tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return false;
        }
        int dist = Game.Distance(wp.getX(), wp.getY(), tsp.getX(), tsp.getY());
        if (dist != 0) {
            wu.zchange = (short)(wp.getXvel() * (Gameutils.SPRITEp_UPPER(tsp) - wp.getZ()) / dist);
            wp.setZvel(wu.zchange);
        }
        return w != 0;
    }

    public static void LavaSaveable() {
        Saveable.SaveData(InitLavaThrow);
        Saveable.SaveData(InitLavaFlame);
        Saveable.SaveData(NullLava);
        Saveable.SaveData(DoLavaMove);
        Saveable.SaveData(LavaPersonality);
        Saveable.SaveData(LavaAttrib);
        Saveable.SaveData(s_LavaStand);
        Saveable.SaveGroup(sg_LavaStand);
        Saveable.SaveData(s_LavaRun);
        Saveable.SaveGroup(sg_LavaRun);
        Saveable.SaveData(s_LavaThrow);
        Saveable.SaveGroup(sg_LavaThrow);
        Saveable.SaveData(s_LavaFlame);
        Saveable.SaveGroup(sg_LavaFlame);
        Saveable.SaveData(s_LavaDie);
        Saveable.SaveData(s_LavaDead);
        Saveable.SaveGroup(sg_LavaDie);
        Saveable.SaveGroup(sg_LavaDead);
        Saveable.SaveData(LavaActionSet);
    }
}

