/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Ripper2;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Ripper {
    public static final Animator InitCoolgFire = new Animator(Ripper::InitCoolgFire);
    public static final int RIPPER_RUN_RATE = 16;
    private static final Animator InitRipperHang = new Animator(Ripper::InitRipperHang);
    public static final int RIPPER_STAND_RATE = 12;
    private static final Animator DoRipperMove = new Animator(Ripper::DoRipperMove);
    public static final int RIPPER_SWIPE_RATE = 8;
    public static final int RIPPER_SPEW_RATE = 8;
    private static final Animator DoRipperStandHeart = new Animator(Ripper::DoRipperStandHeart);
    public static final int RIPPER_HEART_RATE = 14;
    private static final Animator DoRipperHang = new Animator(Ripper::DoRipperHang);
    public static final int RIPPER_HANG_RATE = 14;
    public static final int RIPPER_PAIN_RATE = 38;
    private static final Animator DoRipperMoveJump = new Animator(Ripper::DoRipperMoveJump);
    public static final int RIPPER_JUMP_RATE = 25;
    public static final int RIPPER_FALL_RATE = 25;
    private static final Animator DoRipperHangJF = new Animator(Ripper::DoRipperHangJF);
    public static final int RIPPER_JUMP_ATTACK_RATE = 35;
    public static final int RIPPER_HANG_JUMP_RATE = 20;
    public static final int RIPPER_DIE_RATE = 16;
    public static final int RIPPER_DEAD_RATE = 8;
    private static final Animator NullRipper = new Animator(Ripper::NullRipper);
    private static final Animator DoRipperPain = new Animator(Ripper::DoRipperPain);
    private static final Animator DoRipperBeginJumpAttack = new Animator(Ripper::DoRipperBeginJumpAttack);
    private static final Decision[] RipperBattle = new Decision[]{new Decision(748, Ai.InitActorMoveCloser), new Decision(750, Ai.InitActorAlertNoise), new Decision(755, Ai.InitActorAttackNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] RipperOffense = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(710, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] RipperBroadcast = new Decision[]{new Decision(3, Ai.InitActorAlertNoise), new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] RipperCloseRange = new Decision[]{new Decision(900, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Decision[] RipperLostTarget = new Decision[]{new Decision(980, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final ATTRIBUTE RipperAttrib = new ATTRIBUTE(new short[]{200, 220, 240, 280}, new short[]{5, 0, -2, -4}, 3, new int[]{95, 96, 97, 98, 99, 100, 0, 0, 0, 0});
    private static final State[][] s_RipperPain = new State[][]{{new State(1620, 38, DoRipperPain).setNext()}, {new State(1620, 38, DoRipperPain).setNext()}, {new State(1620, 38, DoRipperPain).setNext()}, {new State(1620, 38, DoRipperPain).setNext()}, {new State(1620, 38, DoRipperPain).setNext()}};
    private static final EnemyStateGroup sg_RipperPain = new EnemyStateGroup(s_RipperPain[0], s_RipperPain[1], s_RipperPain[2], s_RipperPain[3], s_RipperPain[4]);
    private static final State[] s_RipperDie = new State[]{new State(1640, 16, NullRipper), new State(1641, 16, NullRipper), new State(1642, 16, NullRipper), new State(1643, 16, NullRipper), new State(1643, 16, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_RipperDie = new EnemyStateGroup(new State[][]{s_RipperDie});
    private static final State[] s_RipperDead = new State[]{new State(1642, 8, null), new State(1643, 8, null), new State(1643, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(1643, 8, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_RipperDead = new EnemyStateGroup(new State[][]{s_RipperDead});
    private static final Decision[] RipperSurprised = new Decision[]{new Decision(30, InitRipperHang), new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Animator DoActorDeathMove = new Animator(Actor::DoActorDeathMove);
    private static final Decision[] RipperEvasive = new Decision[]{new Decision(6, InitRipperHang), new Decision(1024, null)};
    private static final State[] s_RipperDeathJump = new State[]{new State(1640, 16, DoActorDeathMove).setNext()};
    private static final Personality RipperPersonality = new Personality(RipperBattle, RipperOffense, RipperBroadcast, RipperSurprised, RipperEvasive, RipperLostTarget, RipperCloseRange, RipperCloseRange);
    private static final EnemyStateGroup sg_RipperDeathJump = new EnemyStateGroup(new State[][]{s_RipperDeathJump});
    private static final State[] s_RipperDeathFall = new State[]{new State(1641, 16, DoActorDeathMove).setNext()};
    private static final State[][] s_RipperRun = new State[][]{{new State(1580, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1581, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1582, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1583, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove)}, {new State(1584, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1585, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1586, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1587, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove)}, {new State(1588, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1589, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1590, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1591, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove)}, {new State(1592, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1593, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1594, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1595, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove)}, {new State(1596, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1597, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1598, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1599, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove)}};
    private static final EnemyStateGroup sg_RipperDeathFall = new EnemyStateGroup(new State[][]{s_RipperDeathFall});
    private static final State[][] s_RipperStand = new State[][]{{new State(1620, 12, DoRipperMove).setNext()}, {new State(1622, 12, DoRipperMove).setNext()}, {new State(1624, 12, DoRipperMove).setNext()}, {new State(1626, 12, DoRipperMove).setNext()}, {new State(1628, 12, DoRipperMove).setNext()}};
    private static final State[][] s_RipperSwipe = new State[][]{{new State(1600, 8, NullRipper), new State(1601, 8, NullRipper), new State(1601, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1602, 8, NullRipper), new State(1603, 8, NullRipper), new State(1603, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1603, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1603, 8, DoRipperMove).setNext()}, {new State(1604, 8, NullRipper), new State(1605, 8, NullRipper), new State(1605, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1606, 8, NullRipper), new State(1607, 8, NullRipper), new State(1607, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1607, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1607, 8, DoRipperMove).setNext()}, {new State(1608, 8, NullRipper), new State(1609, 8, NullRipper), new State(1609, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1610, 8, NullRipper), new State(1611, 8, NullRipper), new State(1611, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1611, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1611, 8, DoRipperMove).setNext()}, {new State(1612, 8, NullRipper), new State(1613, 8, NullRipper), new State(1613, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1614, 8, NullRipper), new State(1615, 8, NullRipper), new State(1615, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1615, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1615, 8, DoRipperMove).setNext()}, {new State(1616, 8, NullRipper), new State(1617, 8, NullRipper), new State(1617, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1618, 8, NullRipper), new State(1619, 8, NullRipper), new State(1619, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1619, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1619, 8, DoRipperMove).setNext()}};
    private static final State[][] s_RipperSpew = new State[][]{{new State(1600, 8, NullRipper), new State(1601, 8, NullRipper), new State(1601, Gameutils.SF_QUICK_CALL, InitCoolgFire), new State(1602, 8, NullRipper), new State(1603, 8, NullRipper), new State(1603, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1603, 8, DoRipperMove).setNext()}, {new State(1604, 8, NullRipper), new State(1605, 8, NullRipper), new State(1605, Gameutils.SF_QUICK_CALL, InitCoolgFire), new State(1606, 8, NullRipper), new State(1607, 8, NullRipper), new State(1607, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1607, 8, DoRipperMove).setNext()}, {new State(1608, 8, NullRipper), new State(1609, 8, NullRipper), new State(1609, Gameutils.SF_QUICK_CALL, InitCoolgFire), new State(1610, 8, NullRipper), new State(1611, 8, NullRipper), new State(1611, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1611, 8, DoRipperMove).setNext()}, {new State(1612, 8, NullRipper), new State(1613, 8, NullRipper), new State(1613, Gameutils.SF_QUICK_CALL, InitCoolgFire), new State(1614, 8, NullRipper), new State(1615, 8, NullRipper), new State(1615, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1615, 8, DoRipperMove).setNext()}, {new State(1616, 8, NullRipper), new State(1617, 8, NullRipper), new State(1617, Gameutils.SF_QUICK_CALL, InitCoolgFire), new State(1618, 8, NullRipper), new State(1619, 8, NullRipper), new State(1619, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1619, 8, DoRipperMove).setNext()}};
    private static final State[][] s_RipperHeart = new State[][]{{new State(1635, 14, DoRipperStandHeart).setNext()}, {new State(1635, 14, DoRipperStandHeart).setNext()}, {new State(1635, 14, DoRipperStandHeart).setNext()}, {new State(1635, 14, DoRipperStandHeart).setNext()}, {new State(1635, 14, DoRipperStandHeart).setNext()}};
    private static final State[][] s_RipperHang = new State[][]{{new State(1645, 14, DoRipperHang).setNext()}, {new State(1645, 14, DoRipperHang).setNext()}, {new State(1639, 14, DoRipperHang).setNext()}, {new State(1637, 14, DoRipperHang).setNext()}, {new State(1635, 14, DoRipperHang).setNext()}};
    private static final State[][] s_RipperJump = new State[][]{{new State(1620, 25, NullRipper), new State(1621, 25, DoRipperMoveJump).setNext()}, {new State(1622, 25, NullRipper), new State(1623, 25, DoRipperMoveJump).setNext()}, {new State(1624, 25, NullRipper), new State(1625, 25, DoRipperMoveJump).setNext()}, {new State(1626, 25, NullRipper), new State(1627, 25, DoRipperMoveJump).setNext()}, {new State(1628, 25, NullRipper), new State(1629, 25, DoRipperMoveJump).setNext()}};
    private static final State[][] s_RipperFall = new State[][]{{new State(1621, 25, DoRipperMoveJump).setNext()}, {new State(1623, 25, DoRipperMoveJump).setNext()}, {new State(1625, 25, DoRipperMoveJump).setNext()}, {new State(1627, 25, DoRipperMoveJump).setNext()}, {new State(1629, 25, DoRipperMoveJump).setNext()}};
    private static final State[][] s_RipperJumpAttack = new State[][]{{new State(1620, 35, NullRipper), new State(1620, Gameutils.SF_QUICK_CALL, DoRipperBeginJumpAttack), new State(1621, 35, DoRipperMoveJump).setNext()}, {new State(1622, 35, NullRipper), new State(1622, Gameutils.SF_QUICK_CALL, DoRipperBeginJumpAttack), new State(1623, 35, DoRipperMoveJump).setNext()}, {new State(1624, 35, NullRipper), new State(1624, Gameutils.SF_QUICK_CALL, DoRipperBeginJumpAttack), new State(1625, 35, DoRipperMoveJump).setNext()}, {new State(1626, 35, NullRipper), new State(1626, Gameutils.SF_QUICK_CALL, DoRipperBeginJumpAttack), new State(1627, 35, DoRipperMoveJump).setNext()}, {new State(1628, 35, NullRipper), new State(1628, Gameutils.SF_QUICK_CALL, DoRipperBeginJumpAttack), new State(1629, 35, DoRipperMoveJump).setNext()}};
    private static final State[][] s_RipperHangJump = new State[][]{{new State(1620, 20, NullRipper), new State(1621, 20, DoRipperHangJF).setNext()}, {new State(1622, 20, NullRipper), new State(1623, 20, DoRipperHangJF).setNext()}, {new State(1624, 20, NullRipper), new State(1625, 20, DoRipperHangJF).setNext()}, {new State(1626, 20, NullRipper), new State(1627, 20, DoRipperHangJF).setNext()}, {new State(1628, 20, NullRipper), new State(1629, 20, DoRipperHangJF).setNext()}};
    private static final State[][] s_RipperHangFall = new State[][]{{new State(1621, 25, DoRipperHangJF).setNext()}, {new State(1623, 25, DoRipperHangJF).setNext()}, {new State(1625, 25, DoRipperHangJF).setNext()}, {new State(1627, 25, DoRipperHangJF).setNext()}, {new State(1629, 25, DoRipperHangJF).setNext()}};
    private static final EnemyStateGroup sg_RipperStand = new EnemyStateGroup(s_RipperStand[0], s_RipperStand[1], s_RipperStand[2], s_RipperStand[3], s_RipperStand[4]);
    private static final EnemyStateGroup sg_RipperRun = new EnemyStateGroup(s_RipperRun[0], s_RipperRun[1], s_RipperRun[2], s_RipperRun[3], s_RipperRun[4]);
    private static final EnemyStateGroup sg_RipperJump = new EnemyStateGroup(s_RipperJump[0], s_RipperJump[1], s_RipperJump[2], s_RipperJump[3], s_RipperJump[4]);
    private static final EnemyStateGroup sg_RipperFall = new EnemyStateGroup(s_RipperFall[0], s_RipperFall[1], s_RipperFall[2], s_RipperFall[3], s_RipperFall[4]);
    private static final EnemyStateGroup sg_RipperSpew = new EnemyStateGroup(s_RipperSpew[0], s_RipperSpew[1], s_RipperSpew[2], s_RipperSpew[3], s_RipperSpew[4]);
    private static final EnemyStateGroup sg_RipperJumpAttack = new EnemyStateGroup(s_RipperJumpAttack[0], s_RipperJumpAttack[1], s_RipperJumpAttack[2], s_RipperJumpAttack[3], s_RipperJumpAttack[4]);
    private static final EnemyStateGroup sg_RipperHeart = new EnemyStateGroup(s_RipperHeart[0], s_RipperHeart[1], s_RipperHeart[2], s_RipperHeart[3], s_RipperHeart[4]);
    private static final EnemyStateGroup sg_RipperHang = new EnemyStateGroup(s_RipperHang[0], s_RipperHang[1], s_RipperHang[2], s_RipperHang[3], s_RipperHang[4]);
    private static final EnemyStateGroup sg_RipperSwipe = new EnemyStateGroup(s_RipperSwipe[0], s_RipperSwipe[1], s_RipperSwipe[2], s_RipperSwipe[3], s_RipperSwipe[4]);
    private static final EnemyStateGroup sg_RipperHangJump = new EnemyStateGroup(s_RipperHangJump[0], s_RipperHangJump[1], s_RipperHangJump[2], s_RipperHangJump[3], s_RipperHangJump[4]);
    private static final EnemyStateGroup sg_RipperHangFall = new EnemyStateGroup(s_RipperHangFall[0], s_RipperHangFall[1], s_RipperHangFall[2], s_RipperHangFall[3], s_RipperHangFall[4]);
    private static final Actor_Action_Set RipperActionSet = new Actor_Action_Set(sg_RipperStand, sg_RipperRun, sg_RipperJump, sg_RipperFall, null, null, null, null, null, null, null, sg_RipperPain, sg_RipperDie, null, sg_RipperDead, sg_RipperDeathJump, sg_RipperDeathFall, new StateGroup[]{sg_RipperSwipe, sg_RipperSpew}, new short[]{800, 1024}, new StateGroup[]{sg_RipperJumpAttack, sg_RipperSpew}, new short[]{400, 1024}, new StateGroup[]{sg_RipperHeart, sg_RipperHang}, null, null);
    private static final Actor_Action_Set RipperBrownActionSet = new Actor_Action_Set(sg_RipperStand, sg_RipperRun, sg_RipperJump, sg_RipperFall, null, null, null, null, null, null, null, sg_RipperPain, sg_RipperDie, null, sg_RipperDead, sg_RipperDeathJump, sg_RipperDeathFall, new StateGroup[]{sg_RipperSwipe}, new short[]{1024}, new StateGroup[]{sg_RipperJumpAttack, sg_RipperSwipe}, new short[]{800, 1024}, new StateGroup[]{sg_RipperHeart, sg_RipperHang}, null, null);

    public static void InitRipperStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_RipperStand, sg_RipperRun, sg_RipperJump, sg_RipperFall, sg_RipperPain, sg_RipperDie, sg_RipperDead, sg_RipperDeathJump, sg_RipperDeathFall, sg_RipperSpew, sg_RipperJumpAttack, sg_RipperHeart, sg_RipperHang, sg_RipperSwipe, sg_RipperHangJump, sg_RipperHangFall}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    public static void SetupRipper(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 1580, s_RipperRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 35;
        }
        Sprites.ChangeState(SpriteNum, s_RipperRun[0][0]);
        u.Attrib = RipperAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 3);
        u.StateEnd = s_RipperDie[0];
        u.setRot(sg_RipperRun);
        sp.setXrepeat(64);
        sp.setYrepeat(64);
        if (sp.getPal() == 7) {
            Coolie.EnemyDefaults(SpriteNum, RipperBrownActionSet, RipperPersonality);
            sp.setXrepeat(106);
            sp.setYrepeat(90);
            if (!MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
                u.Health = 500;
            }
            sp.setClipdist(sp.getClipdist() + 32);
        } else {
            Coolie.EnemyDefaults(SpriteNum, RipperActionSet, RipperPersonality);
        }
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
    }

    private static int GetJumpHeight(int jump_speed, int jump_grav) {
        jump_speed = Pragmas.klabs(jump_speed);
        int jump_iterations = jump_speed / (jump_grav * 6);
        int height = jump_speed * jump_iterations * 6;
        height = MyTypes.DIV256(height);
        return MyTypes.DIV2(height);
    }

    public static int PickJumpSpeed(int SpriteNum, int pix_height) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return 0;
        }
        u.jump_speed = -600;
        u.jump_grav = 8;
        while (Ripper.GetJumpHeight(u.jump_speed, u.jump_grav) <= pix_height + 20) {
            u.jump_speed -= 100;
        }
        return u.jump_speed;
    }

    public static void PickJumpMaxSpeed(int SpriteNum, int max_speed) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.jump_speed = max_speed;
        u.jump_grav = 8;
        int zh = Gameutils.SPRITEp_TOS(sp);
        while (zh - Gameutils.Z(Ripper.GetJumpHeight(u.jump_speed, u.jump_grav)) - Gameutils.Z(16) <= u.hiz) {
            u.jump_speed += 100;
            if (u.jump_speed <= -200) continue;
            break;
        }
    }

    private static void InitRipperHang(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        boolean Found = false;
        for (int dang = 0; dang < 2048; dang += 128) {
            int tang = Gameutils.NORM_ANGLE(sp.getAng() + dang);
            Rooms.FAFhitscan(sp.getX(), sp.getY(), sp.getZ() - Gameutils.SPRITEp_SIZE_Z(sp), sp.getSectnum(), EngineUtils.sin(Gameutils.NORM_ANGLE(tang + 512)), EngineUtils.sin(tang), 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
            int hitsect = Engine.pHitInfo.hitsect;
            int hitwall = Engine.pHitInfo.hitwall;
            int hitx = Engine.pHitInfo.hitx;
            int hity = Engine.pHitInfo.hity;
            if (hitsect == -1) continue;
            int dist = Game.Distance(sp.getX(), sp.getY(), hitx, hity);
            if (hitwall < 0 || dist < 2000 || dist > 7000) continue;
            Found = true;
            sp.setAng(tang);
            break;
        }
        if (!Found) {
            Ai.InitActorDecide(SpriteNum);
            return;
        }
        Sprites.NewStateGroup(SpriteNum, sg_RipperHangJump);
        u.StateFallOverride = sg_RipperHangFall;
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ripper.PickJumpMaxSpeed(SpriteNum, -800);
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = 8;
        Actor.DoJump(SpriteNum);
    }

    private static void DoRipperHang(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if ((u.WaitTics -= 6) > 0) {
            return;
        }
        Sprites.NewStateGroup(SpriteNum, sg_RipperJumpAttack);
        u.Tics += u.State.Tics;
    }

    private static void DoRipperMoveHang(int SpriteNum) {
        int ny;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14, 0) && MyTypes.DTEST(u.moveSpriteReturn, -536870912) == Integer.MIN_VALUE) {
            int hitwall = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Special[1]);
            u.WaitTics = 2 + (Gameutils.RANDOM_P2(1024) >> 8) * 120;
            Wall wal = Main.boardService.getWall(hitwall);
            if (wal != null) {
                sp.setAng(Gameutils.NORM_ANGLE(wal.getWallAngle() - 512));
            }
        }
    }

    private static void DoRipperHangJF(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper.DoRipperQuickJump(SpriteNum) != 0) {
                return;
            }
            Ai.InitActorDecide(SpriteNum);
        }
        Ripper.DoRipperMoveHang(SpriteNum);
    }

    private static int RANDOM_NEG() {
        return Gameutils.RANDOM_P2(32768) - 16384;
    }

    private static void DoRipperBeginJumpAttack(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite psp = Main.boardService.getSprite(u.tgt_sp);
        if (psp == null) {
            return;
        }
        int tang = EngineUtils.getAngle(psp.getX() - sp.getX(), psp.getY() - sp.getY());
        if (Sprites.move_sprite(SpriteNum, EngineUtils.sin(Gameutils.NORM_ANGLE(tang + 512)) >> 7, EngineUtils.sin(tang) >> 7, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_ACTOR, 6) != 0) {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024 + (Ripper.RANDOM_NEG() >> 6)));
        } else {
            sp.setAng(Gameutils.NORM_ANGLE(tang + (Ripper.RANDOM_NEG() >> 6)));
        }
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ripper.PickJumpMaxSpeed(SpriteNum, -400);
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = 17;
        Sprites.DoActorZrange(SpriteNum);
        Actor.DoJump(SpriteNum);
    }

    private static void DoRipperMoveJump(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper.DoRipperQuickJump(SpriteNum) != 0) {
                return;
            }
            Ai.InitActorDecide(SpriteNum);
        }
        Ripper.DoRipperMoveHang(SpriteNum);
    }

    private static int DoRipperQuickJump(int SpriteNum) {
        WangSprite tsp;
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && u.lo_sp != -1 && (tsp = Main.boardService.getSprite(u.lo_sp)) != null && MyTypes.TEST(tsp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY)) {
            Sprites.NewStateGroup(SpriteNum, sg_RipperJumpAttack);
            u.Tics = 30;
            return 1;
        }
        return 0;
    }

    private static void NullRipper(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoRipperPain(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        Ripper.NullRipper(SpriteNum);
        if (u != null && (u.WaitTics -= 6) <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    public static void DoRipperRipHeart(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return;
        }
        Sprites.NewStateGroup(SpriteNum, sg_RipperHeart);
        u.WaitTics = 720;
        tsp.setAng(EngineUtils.getAngle(sp.getX() - tsp.getX(), sp.getY() - tsp.getY()));
    }

    private static void DoRipperStandHeart(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        Ripper.NullRipper(SpriteNum);
        if ((u.WaitTics -= 6) <= 0) {
            Sprites.NewStateGroup(SpriteNum, sg_RipperRun);
        }
    }

    private static void DoRipperMove(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (u.scale_speed != 0) {
            Actor.DoScaleSprite(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper.DoRipperQuickJump(SpriteNum) != 0) {
                return;
            }
            Actor.KeepActorOnFloor(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static boolean InitCoolgFire(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return false;
        }
        int nang = Gameutils.NORM_ANGLE(EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY()));
        sp.setAng(nang);
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = sp.getZ() - Gameutils.Z(16);
        Sound.PlaySound(85, sp, 1);
        int w = Sprites.SpawnSprite(4, 2430, Weapon.s_CoolgFire[0], sp.getSectnum(), nx, ny, nz, tsp.getAng(), 400);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return false;
        }
        Sprites.SetOwner(SpriteNum, w);
        wp.setHitag(9999);
        wp.setYrepeat(18);
        wp.setXrepeat(18);
        wp.setShade(-40);
        wp.setZvel(0);
        wp.setAng(nang);
        wp.setClipdist(8);
        wu.ceiling_dist = Gameutils.Z(4);
        wu.floor_dist = Gameutils.Z(4);
        if (u.ID == 1580) {
            wu.spal = (byte)27;
            wp.setPal(27);
        } else {
            wu.spal = (byte)25;
            wp.setPal(25);
        }
        Sound.PlaySound(40, wp, 5);
        int dist = Game.Distance(nx, ny, tsp.getX(), tsp.getY());
        if (dist != 0) {
            wp.setZvel(wp.getXvel() * (Gameutils.SPRITEp_UPPER(tsp) - nz) / dist);
        }
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel();
        nx = (int)(728L * (long)EngineUtils.sin(Gameutils.NORM_ANGLE(nang + 512)) >> 14);
        ny = (int)(728L * (long)EngineUtils.sin(nang) >> 14);
        Sprites.move_missile(w, nx, ny, 0, wu.ceiling_dist, wu.floor_dist, 0, 3);
        return w != 0;
    }

    public static void RipperSaveable() {
        Saveable.SaveData(InitCoolgFire);
        Saveable.SaveData(DoActorDeathMove);
        Saveable.SaveData(InitRipperHang);
        Saveable.SaveData(DoRipperHang);
        Saveable.SaveData(DoRipperHangJF);
        Saveable.SaveData(DoRipperBeginJumpAttack);
        Saveable.SaveData(DoRipperMoveJump);
        Saveable.SaveData(NullRipper);
        Saveable.SaveData(DoRipperPain);
        Saveable.SaveData(DoRipperStandHeart);
        Saveable.SaveData(DoRipperMove);
        Saveable.SaveData(RipperPersonality);
        Saveable.SaveData(RipperAttrib);
        Saveable.SaveData(s_RipperRun);
        Saveable.SaveGroup(sg_RipperRun);
        Saveable.SaveData(s_RipperStand);
        Saveable.SaveGroup(sg_RipperStand);
        Saveable.SaveData(s_RipperSwipe);
        Saveable.SaveGroup(sg_RipperSwipe);
        Saveable.SaveData(s_RipperSpew);
        Saveable.SaveGroup(sg_RipperSpew);
        Saveable.SaveData(s_RipperHeart);
        Saveable.SaveGroup(sg_RipperHeart);
        Saveable.SaveData(s_RipperHang);
        Saveable.SaveGroup(sg_RipperHang);
        Saveable.SaveData(s_RipperPain);
        Saveable.SaveGroup(sg_RipperPain);
        Saveable.SaveData(s_RipperJump);
        Saveable.SaveGroup(sg_RipperJump);
        Saveable.SaveData(s_RipperFall);
        Saveable.SaveGroup(sg_RipperFall);
        Saveable.SaveData(s_RipperJumpAttack);
        Saveable.SaveGroup(sg_RipperJumpAttack);
        Saveable.SaveData(s_RipperHangJump);
        Saveable.SaveGroup(sg_RipperHangJump);
        Saveable.SaveData(s_RipperHangFall);
        Saveable.SaveGroup(sg_RipperHangFall);
        Saveable.SaveData(s_RipperDie);
        Saveable.SaveData(s_RipperDead);
        Saveable.SaveGroup(sg_RipperDie);
        Saveable.SaveGroup(sg_RipperDead);
        Saveable.SaveData(s_RipperDeathJump);
        Saveable.SaveData(s_RipperDeathFall);
        Saveable.SaveGroup(sg_RipperDeathJump);
        Saveable.SaveGroup(sg_RipperDeathFall);
        Saveable.SaveData(RipperActionSet);
        Saveable.SaveData(RipperBrownActionSet);
    }
}

