/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Hornet;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Ripper;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Weapon;

public class Ripper2 {
    public static final Animator NullRipper2 = new Animator(Ripper2::NullRipper2);
    public static final Animator ChestRipper2 = new Animator(Ripper2::ChestRipper2);
    public static final Animator InitRipper2Charge = new Animator(Ripper2::InitRipper2Charge);
    public static final Animator DoRipper2Pain = new Animator(Ripper2::DoRipper2Pain);
    public static final Animator InitRipper2Hang = new Animator(Ripper2::InitRipper2Hang);
    public static final Animator DoRipper2BeginJumpAttack = new Animator(Ripper2::DoRipper2BeginJumpAttack);
    public static final Animator DoRipper2Move = new Animator(Ripper2::DoRipper2Move);
    private static final Decision[] Ripper2Broadcast = new Decision[]{new Decision(3, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] Ripper2LostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    public static final Animator DoRipper2MoveJump = new Animator(Ripper2::DoRipper2MoveJump);
    private static final Decision[] Ripper2CloseRange = new Decision[]{new Decision(1024, Ai.InitActorAttack)};
    private static final ATTRIBUTE Ripper2Attrib = new ATTRIBUTE(new short[]{100, 120, 300, 380}, new short[]{5, 0, -2, -4}, 3, new int[]{313, 314, 315, 316, 317, 318, 0, 0, 0, 0});
    public static final Animator InitRipperSlash = new Animator(Ripper2::InitRipperSlash);
    private static final int RIPPER2_RUN_RATE = 16;
    public static final Animator DoRipper2StandHeart = new Animator(Ripper2::DoRipper2StandHeart);
    private static final int RIPPER2_STAND_RATE = 12;
    public static final Animator DoRipper2Hang = new Animator(Ripper2::DoRipper2Hang);
    private static final int RIPPER2_RUNFAST_RATE = 14;
    private static final int RIPPER2_JUMP_RATE = 25;
    private static final int RIPPER2_DIE_RATE = 18;
    public static final Animator DoRipper2HangJF = new Animator(Ripper2::DoRipper2HangJF);
    private static final State[] s_Ripper2Die = new State[]{new State(4414, 18, NullRipper2), new State(4415, 18, NullRipper2), new State(4416, 18, NullRipper2), new State(4417, 18, NullRipper2), new State(4418, 18, NullRipper2), new State(4419, 18, NullRipper2), new State(4420, 18, NullRipper2), new State(4421, 18, Actor.DoActorDebris).setNext()};
    private static final Decision[] Ripper2Battle = new Decision[]{new Decision(879, InitRipper2Charge), new Decision(883, Ai.InitActorAttackNoise), new Decision(900, InitRipper2Hang), new Decision(1024, Ai.InitActorAttack)};
    private static final EnemyStateGroup sg_Ripper2Die = new EnemyStateGroup(new State[][]{s_Ripper2Die});
    private static final Decision[] Ripper2Offense = new Decision[]{new Decision(789, Ai.InitActorMoveCloser), new Decision(790, Ai.InitActorAttackNoise), new Decision(800, InitRipper2Hang), new Decision(1024, Ai.InitActorAttack)};
    private static final int RIPPER2_SWIPE_RATE = 14;
    private static final int RIPPER2_MEKONG_RATE = 18;
    private static final Decision[] Ripper2Surprised = new Decision[]{new Decision(40, InitRipper2Hang), new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final int RIPPER2_HEART_RATE = 20;
    private static final Decision[] Ripper2Evasive = new Decision[]{new Decision(10, Ai.InitActorMoveCloser), new Decision(1024, InitRipper2Charge)};
    private static final int RIPPER2_HANG_RATE = 14;
    private static final int RIPPER2_PAIN_RATE = 38;
    private static final State[][] s_Ripper2Pain = new State[][]{{new State(4414, 38, DoRipper2Pain).setNext()}, {new State(4414, 38, DoRipper2Pain).setNext()}, {new State(4414, 38, DoRipper2Pain).setNext()}, {new State(4414, 38, DoRipper2Pain).setNext()}, {new State(4414, 38, DoRipper2Pain).setNext()}};
    private static final Personality Ripper2Personality = new Personality(Ripper2Battle, Ripper2Offense, Ripper2Broadcast, Ripper2Surprised, Ripper2Evasive, Ripper2LostTarget, Ripper2CloseRange, Ripper2CloseRange);
    private static final EnemyStateGroup sg_Ripper2Pain = new EnemyStateGroup(s_Ripper2Pain[0], s_Ripper2Pain[1], s_Ripper2Pain[2], s_Ripper2Pain[3], s_Ripper2Pain[4]);
    private static final int RIPPER2_FALL_RATE = 25;
    private static final int RIPPER2_JUMP_ATTACK_RATE = 35;
    private static final State[][] s_Ripper2Run = new State[][]{{new State(4320, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4321, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4322, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4323, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4324, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4325, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4326, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4327, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4328, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4329, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4330, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4331, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4332, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4333, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4334, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4335, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4336, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4337, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4338, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4339, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}};
    private static final int RIPPER2_HANG_JUMP_RATE = 20;
    private static final State[] s_Ripper2DeathJump = new State[]{new State(4414, 18, Ninja.DoActorDeathMove).setNext()};
    private static final State[][] s_Ripper2Stand = new State[][]{{new State(4377, 12, DoRipper2Move).setNext()}, {new State(4381, 12, DoRipper2Move).setNext()}, {new State(4385, 12, DoRipper2Move).setNext()}, {new State(4389, 12, DoRipper2Move).setNext()}, {new State(4393, 12, DoRipper2Move).setNext()}};
    private static final EnemyStateGroup sg_Ripper2DeathJump = new EnemyStateGroup(new State[][]{s_Ripper2DeathJump});
    private static final State[] s_Ripper2DeathFall = new State[]{new State(4415, 18, Ninja.DoActorDeathMove).setNext()};
    private static final State[][] s_Ripper2RunFast = new State[][]{{new State(4340, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4341, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4342, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4343, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4344, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4345, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4346, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4347, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4348, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4349, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4350, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4351, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4352, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4353, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4354, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4355, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4356, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4357, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4358, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4359, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}};
    private static final EnemyStateGroup sg_Ripper2DeathFall = new EnemyStateGroup(new State[][]{s_Ripper2DeathFall});
    private static final int RIPPER2_DEAD_RATE = 8;
    private static final State[][] s_Ripper2Jump = new State[][]{{new State(4374, 25, NullRipper2), new State(4375, 25, DoRipper2MoveJump).setNext()}, {new State(4378, 25, NullRipper2), new State(4379, 25, DoRipper2MoveJump).setNext()}, {new State(4382, 25, NullRipper2), new State(4383, 25, DoRipper2MoveJump).setNext()}, {new State(4386, 25, NullRipper2), new State(4387, 25, DoRipper2MoveJump).setNext()}, {new State(4390, 25, NullRipper2), new State(4391, 25, DoRipper2MoveJump).setNext()}};
    private static final State[] s_Ripper2Dead = new State[]{new State(4414, 18, NullRipper2), new State(4415, 18, NullRipper2), new State(4416, 18, NullRipper2), new State(4417, 18, NullRipper2), new State(4418, 18, NullRipper2), new State(4419, 18, NullRipper2), new State(4420, 18, NullRipper2), new State(4421, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(4421, 8, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_Ripper2Dead = new EnemyStateGroup(new State[][]{s_Ripper2Dead});
    private static VOC3D riphearthandle = null;
    private static final State[][] s_Ripper2Swipe = new State[][]{{new State(4394, 14, NullRipper2), new State(4395, 14, NullRipper2), new State(4395, Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4396, 14, NullRipper2), new State(4397, 14, NullRipper2), new State(4397, Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4397, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4397, 14, DoRipper2Move).setNext()}, {new State(4398, 14, NullRipper2), new State(4399, 14, NullRipper2), new State(4399, Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4400, 14, NullRipper2), new State(4401, 14, NullRipper2), new State(4401, Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4401, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4401, 14, DoRipper2Move).setNext()}, {new State(4402, 14, NullRipper2), new State(4403, 14, NullRipper2), new State(4403, Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4404, 14, NullRipper2), new State(4405, 14, NullRipper2), new State(4405, Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4405, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4405, 14, DoRipper2Move).setNext()}, {new State(4406, 14, NullRipper2), new State(4407, 14, NullRipper2), new State(4407, Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4408, 14, NullRipper2), new State(4409, 14, NullRipper2), new State(4409, Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4409, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4409, 14, DoRipper2Move).setNext()}, {new State(4410, 14, NullRipper2), new State(4411, 14, NullRipper2), new State(4411, Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4412, 14, NullRipper2), new State(4413, 14, NullRipper2), new State(4413, Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4413, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4413, 14, DoRipper2Move).setNext()}};
    private static final State[][] s_Ripper2Kong = new State[][]{{new State(4360, 18, NullRipper2), new State(4360, Gameutils.SF_QUICK_CALL, ChestRipper2), new State(4361, 18, NullRipper2), new State(4362, 18, NullRipper2), new State(4363, 18, NullRipper2), new State(4363, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4360, 18, DoRipper2Move).setNext()}, {new State(4363, 18, NullRipper2), new State(4360, Gameutils.SF_QUICK_CALL, ChestRipper2), new State(4364, 18, NullRipper2), new State(4365, 18, NullRipper2), new State(4366, 18, NullRipper2), new State(4366, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4363, 18, DoRipper2Move).setNext()}, {new State(4366, 18, NullRipper2), new State(4360, Gameutils.SF_QUICK_CALL, ChestRipper2), new State(4367, 18, NullRipper2), new State(4368, 18, NullRipper2), new State(4369, 18, NullRipper2), new State(4369, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4366, 18, DoRipper2Move).setNext()}, {new State(4369, 18, NullRipper2), new State(4360, Gameutils.SF_QUICK_CALL, ChestRipper2), new State(4370, 18, NullRipper2), new State(4371, 18, NullRipper2), new State(4372, 18, NullRipper2), new State(4372, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4369, 18, DoRipper2Move).setNext()}, {new State(4372, 18, NullRipper2), new State(4360, Gameutils.SF_QUICK_CALL, ChestRipper2), new State(4373, 18, NullRipper2), new State(4374, 18, NullRipper2), new State(4375, 18, NullRipper2), new State(4375, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4372, 18, DoRipper2Move).setNext()}};
    private static final State[][] s_Ripper2Heart = new State[][]{{new State(4422, 20, DoRipper2StandHeart), new State(4423, 20, DoRipper2StandHeart)}, {new State(4422, 20, DoRipper2StandHeart), new State(4423, 20, DoRipper2StandHeart)}, {new State(4422, 20, DoRipper2StandHeart), new State(4423, 20, DoRipper2StandHeart)}, {new State(4422, 20, DoRipper2StandHeart), new State(4423, 20, DoRipper2StandHeart)}, {new State(4422, 20, DoRipper2StandHeart), new State(4423, 20, DoRipper2StandHeart)}};
    private static final State[][] s_Ripper2Hang = new State[][]{{new State(4369, 14, DoRipper2Hang).setNext()}, {new State(4370, 14, DoRipper2Hang).setNext()}, {new State(4371, 14, DoRipper2Hang).setNext()}, {new State(4372, 14, DoRipper2Hang).setNext()}, {new State(4373, 14, DoRipper2Hang).setNext()}};
    private static final State[][] s_Ripper2Fall = new State[][]{{new State(4376, 25, DoRipper2MoveJump).setNext()}, {new State(4380, 25, DoRipper2MoveJump).setNext()}, {new State(4384, 25, DoRipper2MoveJump).setNext()}, {new State(4388, 25, DoRipper2MoveJump).setNext()}, {new State(4392, 25, DoRipper2MoveJump).setNext()}};
    private static final State[][] s_Ripper2JumpAttack = new State[][]{{new State(4374, 35, NullRipper2), new State(4374, Gameutils.SF_QUICK_CALL, DoRipper2BeginJumpAttack), new State(4376, 35, DoRipper2MoveJump), new State(4375, 35, DoRipper2MoveJump).setNext()}, {new State(4378, 35, NullRipper2), new State(4378, Gameutils.SF_QUICK_CALL, DoRipper2BeginJumpAttack), new State(4380, 35, DoRipper2MoveJump), new State(4379, 35, DoRipper2MoveJump).setNext()}, {new State(4382, 35, NullRipper2), new State(4382, Gameutils.SF_QUICK_CALL, DoRipper2BeginJumpAttack), new State(4384, 35, DoRipper2MoveJump), new State(4379, 35, DoRipper2MoveJump).setNext()}, {new State(4386, 35, NullRipper2), new State(4386, Gameutils.SF_QUICK_CALL, DoRipper2BeginJumpAttack), new State(4388, 35, DoRipper2MoveJump), new State(4379, 35, DoRipper2MoveJump).setNext()}, {new State(4390, 35, NullRipper2), new State(4390, Gameutils.SF_QUICK_CALL, DoRipper2BeginJumpAttack), new State(4392, 35, DoRipper2MoveJump), new State(4379, 35, DoRipper2MoveJump).setNext()}};
    private static final State[][] s_Ripper2HangJump = new State[][]{{new State(4374, 20, NullRipper2), new State(4375, 20, DoRipper2HangJF).setNext()}, {new State(4378, 20, NullRipper2), new State(4379, 20, DoRipper2HangJF).setNext()}, {new State(4382, 20, NullRipper2), new State(4383, 20, DoRipper2HangJF).setNext()}, {new State(4386, 20, NullRipper2), new State(4387, 20, DoRipper2HangJF).setNext()}, {new State(4390, 20, NullRipper2), new State(4391, 20, DoRipper2HangJF).setNext()}};
    private static final State[][] s_Ripper2HangFall = new State[][]{{new State(4376, 25, DoRipper2HangJF).setNext()}, {new State(4380, 25, DoRipper2HangJF).setNext()}, {new State(4384, 25, DoRipper2HangJF).setNext()}, {new State(4388, 25, DoRipper2HangJF).setNext()}, {new State(4392, 25, DoRipper2HangJF).setNext()}};
    private static final EnemyStateGroup sg_Ripper2Stand = new EnemyStateGroup(s_Ripper2Stand[0], s_Ripper2Stand[1], s_Ripper2Stand[2], s_Ripper2Stand[3], s_Ripper2Stand[4]);
    private static final EnemyStateGroup sg_Ripper2Run = new EnemyStateGroup(s_Ripper2Run[0], s_Ripper2Run[1], s_Ripper2Run[2], s_Ripper2Run[3], s_Ripper2Run[4]);
    private static final EnemyStateGroup sg_Ripper2RunFast = new EnemyStateGroup(s_Ripper2RunFast[0], s_Ripper2RunFast[1], s_Ripper2RunFast[2], s_Ripper2RunFast[3], s_Ripper2RunFast[4]);
    private static final EnemyStateGroup sg_Ripper2Jump = new EnemyStateGroup(s_Ripper2Jump[0], s_Ripper2Jump[1], s_Ripper2Jump[2], s_Ripper2Jump[3], s_Ripper2Jump[4]);
    private static final EnemyStateGroup sg_Ripper2Swipe = new EnemyStateGroup(s_Ripper2Swipe[0], s_Ripper2Swipe[1], s_Ripper2Swipe[2], s_Ripper2Swipe[3], s_Ripper2Swipe[4]);
    private static final EnemyStateGroup sg_Ripper2Kong = new EnemyStateGroup(s_Ripper2Kong[0], s_Ripper2Kong[1], s_Ripper2Kong[2], s_Ripper2Kong[3], s_Ripper2Kong[4]);
    private static final EnemyStateGroup sg_Ripper2Heart = new EnemyStateGroup(s_Ripper2Heart[0], s_Ripper2Heart[1], s_Ripper2Heart[2], s_Ripper2Heart[3], s_Ripper2Heart[4]);
    private static final EnemyStateGroup sg_Ripper2Fall = new EnemyStateGroup(s_Ripper2Fall[0], s_Ripper2Fall[1], s_Ripper2Fall[2], s_Ripper2Fall[3], s_Ripper2Fall[4]);
    private static final EnemyStateGroup sg_Ripper2JumpAttack = new EnemyStateGroup(s_Ripper2JumpAttack[0], s_Ripper2JumpAttack[1], s_Ripper2JumpAttack[2], s_Ripper2JumpAttack[3], s_Ripper2JumpAttack[4]);
    private static final EnemyStateGroup sg_Ripper2HangJump = new EnemyStateGroup(s_Ripper2HangJump[0], s_Ripper2HangJump[1], s_Ripper2HangJump[2], s_Ripper2HangJump[3], s_Ripper2HangJump[4]);
    private static final EnemyStateGroup sg_Ripper2HangFall = new EnemyStateGroup(s_Ripper2HangFall[0], s_Ripper2HangFall[1], s_Ripper2HangFall[2], s_Ripper2HangFall[3], s_Ripper2HangFall[4]);
    private static final EnemyStateGroup sg_Ripper2Hang = new EnemyStateGroup(s_Ripper2Hang[0], s_Ripper2Hang[1], s_Ripper2Hang[2], s_Ripper2Hang[3], s_Ripper2Hang[4]);
    private static final Actor_Action_Set Ripper2ActionSet = new Actor_Action_Set(sg_Ripper2Stand, sg_Ripper2Run, sg_Ripper2Jump, sg_Ripper2Fall, null, null, null, null, null, null, null, sg_Ripper2Pain, sg_Ripper2Die, null, sg_Ripper2Dead, sg_Ripper2DeathJump, sg_Ripper2DeathFall, new StateGroup[]{sg_Ripper2Swipe}, new short[]{1024}, new StateGroup[]{sg_Ripper2JumpAttack, sg_Ripper2Kong}, new short[]{500, 1024}, new StateGroup[]{sg_Ripper2Heart, sg_Ripper2Hang}, null, null);
    private static final Actor_Action_Set Ripper2BrownActionSet = new Actor_Action_Set(sg_Ripper2Stand, sg_Ripper2Run, sg_Ripper2Jump, sg_Ripper2Fall, null, null, null, null, null, null, null, sg_Ripper2Pain, sg_Ripper2Die, null, sg_Ripper2Dead, sg_Ripper2DeathJump, sg_Ripper2DeathFall, new StateGroup[]{sg_Ripper2Swipe}, new short[]{1024}, new StateGroup[]{sg_Ripper2JumpAttack, sg_Ripper2Kong}, new short[]{400, 1024}, new StateGroup[]{sg_Ripper2Heart, sg_Ripper2Hang}, null, null);

    public static void InitRipper2States() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_Ripper2Stand, sg_Ripper2Run, sg_Ripper2RunFast, sg_Ripper2Jump, sg_Ripper2Swipe, sg_Ripper2Kong, sg_Ripper2Heart, sg_Ripper2Pain, sg_Ripper2Fall, sg_Ripper2JumpAttack, sg_Ripper2HangJump, sg_Ripper2HangFall, sg_Ripper2Hang, sg_Ripper2Die, sg_Ripper2Dead, sg_Ripper2DeathJump, sg_Ripper2DeathFall}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    public static void SetupRipper2(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 4320, s_Ripper2Run[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 200;
        }
        Sprites.ChangeState(SpriteNum, s_Ripper2Run[0][0]);
        u.Attrib = Ripper2Attrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_Ripper2Die[0];
        u.setRot(sg_Ripper2Run);
        sp.setClipdist(128);
        sp.setXrepeat(55);
        sp.setYrepeat(55);
        if (sp.getPal() == 7) {
            Coolie.EnemyDefaults(SpriteNum, Ripper2BrownActionSet, Ripper2Personality);
            sp.setXrepeat(sp.getXrepeat() + 40);
            sp.setYrepeat(sp.getYrepeat() + 40);
            if (!MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
                u.Health = 500;
            }
            sp.setClipdist(sp.getClipdist() + 32);
        } else {
            Coolie.EnemyDefaults(SpriteNum, Ripper2ActionSet, Ripper2Personality);
        }
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
    }

    public static void InitRipper2Hang(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        boolean Found = false;
        for (int dang = 0; dang < 2048; dang += 128) {
            int tang = Gameutils.NORM_ANGLE(sp.getAng() + dang);
            Rooms.FAFhitscan(sp.getX(), sp.getY(), sp.getZ() - Gameutils.SPRITEp_SIZE_Z(sp), sp.getSectnum(), EngineUtils.sin(Gameutils.NORM_ANGLE(tang + 512)), EngineUtils.sin(tang), 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
            int hitsect = Engine.pHitInfo.hitsect;
            int hitwall = Engine.pHitInfo.hitwall;
            int hitx = Engine.pHitInfo.hitx;
            int hity = Engine.pHitInfo.hity;
            if (hitsect == -1) continue;
            int dist = Game.Distance(sp.getX(), sp.getY(), hitx, hity);
            if (hitwall < 0 || dist < 2000 || dist > 7000) continue;
            Found = true;
            sp.setAng(tang);
            break;
        }
        if (!Found) {
            Ai.InitActorDecide(SpriteNum);
            return;
        }
        Sprites.NewStateGroup(SpriteNum, sg_Ripper2HangJump);
        u.StateFallOverride = sg_Ripper2HangFall;
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ripper.PickJumpMaxSpeed(SpriteNum, -(Gameutils.RANDOM_RANGE(400) + 100));
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = 8;
        Actor.DoJump(SpriteNum);
    }

    public static void DoRipper2Hang(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if ((u.WaitTics -= 6) > 0) {
            return;
        }
        Sprites.NewStateGroup(SpriteNum, sg_Ripper2JumpAttack);
        u.Tics += u.State.Tics;
    }

    public static void DoRipper2MoveHang(int SpriteNum) {
        int ny;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14, 0) && MyTypes.DTEST(u.moveSpriteReturn, -536870912) == Integer.MIN_VALUE) {
            WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
            if (tsp == null) {
                return;
            }
            if (Pragmas.klabs(sp.getZ() - tsp.getZ()) > 64000) {
                return;
            }
            int hitwall = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Special[1]);
            u.WaitTics = Gameutils.RANDOM_P2(262144) >> 8 > 500 ? (Gameutils.RANDOM_P2(512) >> 8) * 120 : 0;
            Wall wal = Main.boardService.getWall(hitwall);
            if (wal != null) {
                sp.setAng(Gameutils.NORM_ANGLE(wal.getWallAngle() - 512));
            }
        }
    }

    public static void DoRipper2HangJF(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper2.DoRipper2QuickJump(SpriteNum) != 0) {
                return;
            }
            Ai.InitActorDecide(SpriteNum);
        }
        Ripper2.DoRipper2MoveHang(SpriteNum);
    }

    private static int RANDOM_NEG() {
        return Gameutils.RANDOM_P2(32768) - 16384;
    }

    public static void DoRipper2BeginJumpAttack(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite psp = Main.boardService.getSprite(u.tgt_sp);
        if (psp == null) {
            return;
        }
        int tang = EngineUtils.getAngle(psp.getX() - sp.getX(), psp.getY() - sp.getY());
        if (Sprites.move_sprite(SpriteNum, EngineUtils.sin(Gameutils.NORM_ANGLE(tang + 512)) >> 7, EngineUtils.sin(tang) >> 7, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_ACTOR, 6) != 0) {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024 + (Ripper2.RANDOM_NEG() >> 6)));
        } else {
            sp.setAng(Gameutils.NORM_ANGLE(tang));
        }
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ripper.PickJumpMaxSpeed(SpriteNum, -(Gameutils.RANDOM_RANGE(400) + 100));
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = 8;
        Sprites.DoActorZrange(SpriteNum);
        Actor.DoJump(SpriteNum);
    }

    public static void DoRipper2MoveJump(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper2.DoRipper2QuickJump(SpriteNum) != 0) {
                return;
            }
            Ai.InitActorDecide(SpriteNum);
        }
        Ripper2.DoRipper2MoveHang(SpriteNum);
    }

    public static int DoRipper2QuickJump(int SpriteNum) {
        WangSprite tsp;
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return 0;
        }
        if (u.lo_sp != -1 && (tsp = Main.boardService.getSprite(u.lo_sp)) != null && MyTypes.TEST(tsp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY)) {
            Sprites.NewStateGroup(SpriteNum, sg_Ripper2JumpAttack);
            u.Tics = 30;
            return 1;
        }
        return 0;
    }

    public static void NullRipper2(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static void DoRipper2Pain(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        Ripper2.NullRipper2(SpriteNum);
        if (u != null && (u.WaitTics -= 6) <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    public static void DoRipper2RipHeart(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return;
        }
        Sprites.NewStateGroup(SpriteNum, sg_Ripper2Heart);
        u.WaitTics = 720;
        tsp.setAng(EngineUtils.getAngle(sp.getX() - tsp.getX(), sp.getY() - tsp.getY()));
    }

    private static void DoRipper2StandHeart(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Ripper2.NullRipper2(SpriteNum);
        if (riphearthandle != null && !riphearthandle.isActive()) {
            riphearthandle = Sound.PlaySound(318, sp, 0);
        }
        if ((u.WaitTics -= 6) <= 0) {
            Sprites.NewStateGroup(SpriteNum, sg_Ripper2Run);
        }
    }

    public static void Ripper2Hatch(int Weapon2) {
        WangSprite wp = Main.boardService.getSprite(Weapon2);
        if (wp == null) {
            return;
        }
        int rip_ang = Gameutils.RANDOM_P2(2048);
        int newsp = Rooms.COVERinsertsprite(wp.getSectnum(), 0);
        WangSprite np = Main.boardService.getSprite(newsp);
        if (np == null) {
            return;
        }
        ((Sprite)np).reset();
        np.setSectnum(wp.getSectnum());
        np.setStatnum(0);
        np.setX(wp.getX());
        np.setY(wp.getY());
        np.setZ(wp.getZ());
        np.setOwner(-1);
        np.setXrepeat(64);
        np.setYrepeat(64);
        np.setAng(rip_ang);
        np.setPal(0);
        np.setShade(-10);
        Ripper2.SetupRipper2(newsp);
        USER nu = Gameutils.getUser(newsp);
        if (nu == null) {
            return;
        }
        nu.Flags |= Gameutils.SPR_ACTIVE;
        Sprites.NewStateGroup(newsp, nu.ActorActionSet.Jump);
        nu.ActorActionFunc = Ai.DoActorMoveJump;
        Ai.DoActorSetSpeed(newsp, 3);
        Ripper.PickJumpMaxSpeed(newsp, -600);
        nu.Flags |= Gameutils.SPR_JUMPING;
        nu.Flags &= ~Gameutils.SPR_FALLING;
        nu.jump_grav = 8;
        Sprites.DoActorZrange(newsp);
        Actor.DoJump(newsp);
    }

    public static void DoRipper2Move(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (sp.getHitag() == 1008 && sp.getLotag() == 1) {
            Hornet.DoCheckSwarm(SpriteNum);
        }
        if (u.scale_speed != 0) {
            Actor.DoScaleSprite(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper2.DoRipper2QuickJump(SpriteNum) != 0) {
                return;
            }
            Actor.KeepActorOnFloor(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static void InitRipper2Charge(int SpriteNum) {
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ai.InitActorMoveCloser.animatorInvoke(SpriteNum);
        Sprites.NewStateGroup(SpriteNum, sg_Ripper2RunFast);
    }

    public static void ChestRipper2(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        Sound.PlaySound(431, sp, 1);
    }

    public static void InitRipperSlash(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        Sound.PlaySound(315, sp, 0);
        block0: for (int stat = 0; stat < Weapon.StatDamageList.length; stat = (int)((short)(stat + 1))) {
            ListNode<Sprite> node = Main.boardService.getStatNode(Weapon.StatDamageList[stat]);
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite hp = node.get();
                USER hu = Gameutils.getUser(i);
                if (i == SpriteNum) continue block0;
                if ((u == null || hu == null || Gameutils.FindDistance3D(sp.getX() - hp.getX(), sp.getY() - hp.getY(), sp.getZ() - hp.getZ() >> 4) <= hu.Radius + u.Radius) && Gameutils.DISTANCE(hp.getX(), hp.getY(), sp.getX(), sp.getY()) < Weapon.CLOSE_RANGE_DIST_FUDGE(sp, hp, 600) && Gameutils.FACING_RANGE(hp, sp, 150)) {
                    Weapon.DoDamage(i, SpriteNum);
                }
                node = nexti;
            }
        }
    }

    public static void Ripper2Saveable() {
        Saveable.SaveData(InitRipperSlash);
        Saveable.SaveData(InitRipper2Hang);
        Saveable.SaveData(DoRipper2Hang);
        Saveable.SaveData(DoRipper2HangJF);
        Saveable.SaveData(DoRipper2BeginJumpAttack);
        Saveable.SaveData(DoRipper2MoveJump);
        Saveable.SaveData(NullRipper2);
        Saveable.SaveData(DoRipper2Pain);
        Saveable.SaveData(DoRipper2StandHeart);
        Saveable.SaveData(DoRipper2Move);
        Saveable.SaveData(InitRipper2Charge);
        Saveable.SaveData(ChestRipper2);
        Saveable.SaveData(Ripper2Personality);
        Saveable.SaveData(Ripper2Attrib);
        Saveable.SaveData(s_Ripper2Run);
        Saveable.SaveGroup(sg_Ripper2Run);
        Saveable.SaveData(s_Ripper2RunFast);
        Saveable.SaveGroup(sg_Ripper2RunFast);
        Saveable.SaveData(s_Ripper2Stand);
        Saveable.SaveGroup(sg_Ripper2Stand);
        Saveable.SaveData(s_Ripper2Swipe);
        Saveable.SaveGroup(sg_Ripper2Swipe);
        Saveable.SaveData(s_Ripper2Kong);
        Saveable.SaveGroup(sg_Ripper2Kong);
        Saveable.SaveData(s_Ripper2Heart);
        Saveable.SaveGroup(sg_Ripper2Heart);
        Saveable.SaveData(s_Ripper2Hang);
        Saveable.SaveGroup(sg_Ripper2Hang);
        Saveable.SaveData(s_Ripper2Pain);
        Saveable.SaveGroup(sg_Ripper2Pain);
        Saveable.SaveData(s_Ripper2Jump);
        Saveable.SaveGroup(sg_Ripper2Jump);
        Saveable.SaveData(s_Ripper2Fall);
        Saveable.SaveGroup(sg_Ripper2Fall);
        Saveable.SaveData(s_Ripper2JumpAttack);
        Saveable.SaveGroup(sg_Ripper2JumpAttack);
        Saveable.SaveData(s_Ripper2HangJump);
        Saveable.SaveGroup(sg_Ripper2HangJump);
        Saveable.SaveData(s_Ripper2HangFall);
        Saveable.SaveGroup(sg_Ripper2HangFall);
        Saveable.SaveData(s_Ripper2Die);
        Saveable.SaveData(s_Ripper2Dead);
        Saveable.SaveGroup(sg_Ripper2Die);
        Saveable.SaveGroup(sg_Ripper2Dead);
        Saveable.SaveData(s_Ripper2DeathJump);
        Saveable.SaveData(s_Ripper2DeathFall);
        Saveable.SaveGroup(sg_Ripper2DeathJump);
        Saveable.SaveGroup(sg_Ripper2DeathFall);
        Saveable.SaveData(Ripper2ActionSet);
        Saveable.SaveData(Ripper2BrownActionSet);
    }
}

