/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Skull {
    public static final int SKULL_RATE = 10;
    public static final ATTRIBUTE SkullAttrib = new ATTRIBUTE(new short[]{60, 80, 100, 130}, new short[]{3, 0, -2, -3}, 3, new int[]{115, 0, 0, 0, 116, 117, 0, 0, 0, 0});
    public static final int SKULL_EXPLODE_RATE = 11;
    public static final int BETTY_RATE = 10;
    public static final int BETTY_EXPLODE_RATE = 11;
    public static final int BETTY_EXPLODE = 817;
    public static final int BETTY_BOB_AMT = Gameutils.Z(16);
    private static final Animator DoSkullJump = new Animator(Skull::DoSkullJump);
    private static final Animator DoSkullSpawnShrap = new Animator(Skull::DoSkullSpawnShrap);
    public static final State[] s_SkullExplode = new State[]{new State(825, 1, null), new State(825, Gameutils.SF_QUICK_CALL, Weapon.DoDamageTest), new State(825, 11, null), new State(826, 11, null), new State(827, Gameutils.SF_QUICK_CALL, DoSkullSpawnShrap), new State(827, 11, null), new State(828, 11, null), new State(829, 11, null), new State(830, 11, null), new State(831, 11, null), new State(832, 11, null), new State(833, 11, null), new State(834, 11, null), new State(835, 11, null), new State(836, 11, null), new State(837, 11, null), new State(838, 11, null), new State(838, 11, Weapon.DoSuicide).setNext()};
    private static final Animator DoBettyJump = new Animator(Skull::DoBettyJump);
    private static final State[][] s_SkullJump = new State[][]{{new State(820, 10, DoSkullJump).setNext()}, {new State(821, 10, DoSkullJump).setNext()}, {new State(822, 10, DoSkullJump).setNext()}, {new State(823, 10, DoSkullJump).setNext()}, {new State(824, 10, DoSkullJump).setNext()}};
    private static final EnemyStateGroup sg_SkullJump = new EnemyStateGroup(s_SkullJump[0], s_SkullJump[1], s_SkullJump[2], s_SkullJump[3], s_SkullJump[4]);
    private static final Animator DoSerpRing = new Animator(Skull::DoSerpRing);
    public static final State[][] s_SkullRing = new State[][]{{new State(820, 10, DoSerpRing).setNext()}, {new State(821, 10, DoSerpRing).setNext()}, {new State(822, 10, DoSerpRing).setNext()}, {new State(823, 10, DoSerpRing).setNext()}, {new State(824, 10, DoSerpRing).setNext()}};
    public static final EnemyStateGroup sg_SkullRing = new EnemyStateGroup(s_SkullRing[0], s_SkullRing[1], s_SkullRing[2], s_SkullRing[3], s_SkullRing[4]);
    private static final Animator DoSkullWait = new Animator(Skull::DoSkullWait);
    public static final State[][] s_SkullWait = new State[][]{{new State(820, 10, DoSkullWait).setNext()}, {new State(821, 10, DoSkullWait).setNext()}, {new State(822, 10, DoSkullWait).setNext()}, {new State(823, 10, DoSkullWait).setNext()}, {new State(824, 10, DoSkullWait).setNext()}};
    public static final EnemyStateGroup sg_SkullWait = new EnemyStateGroup(s_SkullWait[0], s_SkullWait[1], s_SkullWait[2], s_SkullWait[3], s_SkullWait[4]);
    private static final int SKULL_BOB_AMT = Gameutils.Z(16);
    private static final ATTRIBUTE BettyAttrib = new ATTRIBUTE(new short[]{60, 80, 100, 130}, new short[]{3, 0, -2, -3}, 3, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final State[][] s_BettyJump = new State[][]{{new State(817, 10, DoBettyJump).setNext()}, {new State(817, 10, DoBettyJump).setNext()}, {new State(817, 10, DoBettyJump).setNext()}, {new State(817, 10, DoBettyJump).setNext()}, {new State(817, 10, DoBettyJump).setNext()}};
    private static final EnemyStateGroup sg_BettyJump = new EnemyStateGroup(s_BettyJump[0], s_BettyJump[1], s_BettyJump[2], s_BettyJump[3], s_BettyJump[4]);
    private static final Animator DoBettyWait = new Animator(Skull::DoBettyWait);
    private static final State[][] s_BettyWait = new State[][]{{new State(817, 10, DoBettyWait), new State(818, 10, DoBettyWait), new State(819, 10, DoBettyWait)}, {new State(817, 10, DoBettyWait), new State(818, 10, DoBettyWait), new State(819, 10, DoBettyWait)}, {new State(817, 10, DoBettyWait), new State(818, 10, DoBettyWait), new State(819, 10, DoBettyWait)}, {new State(817, 10, DoBettyWait), new State(818, 10, DoBettyWait), new State(819, 10, DoBettyWait)}, {new State(817, 10, DoBettyWait), new State(818, 10, DoBettyWait), new State(819, 10, DoBettyWait)}};
    private static final EnemyStateGroup sg_BettyWait = new EnemyStateGroup(s_BettyWait[0], s_BettyWait[1], s_BettyWait[2], s_BettyWait[3], s_BettyWait[4]);
    private static final State[] s_BettyExplode = new State[]{new State(817, Gameutils.SF_QUICK_CALL, Weapon.DoDamageTest), new State(817, 11, Weapon.DoSuicide)};

    public static void InitSkullStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_SkullWait, sg_SkullJump, sg_BettyWait, sg_BettyJump, sg_SkullRing}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
        State.InitState(s_SkullExplode);
        State.InitState(s_BettyExplode);
    }

    public static void SetupSkull(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 820, s_SkullWait[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 4;
        }
        Sprites.ChangeState(SpriteNum, s_SkullWait[0][0]);
        u.Attrib = SkullAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_SkullExplode[0];
        u.setRot(sg_SkullWait);
        u.ID = 820;
        Coolie.EnemyDefaults(SpriteNum, null, null);
        sp.setClipdist(48);
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        u.Radius = 400;
        if (Gameutils.SPRITEp_BOS(sp) > u.loz - Gameutils.Z(16)) {
            sp.setZ(u.loz + Gameutils.Z(Gameutils.SPRITEp_YOFF(sp)));
            u.loz = sp.getZ();
            sp.setZ(sp.getZ() + Gameutils.SPRITEp_SIZE_TOS(sp) - Gameutils.Z(3));
        } else {
            u.Counter = Gameutils.RANDOM_P2(2048);
            u.sz = sp.getZ();
        }
    }

    private static void DoSkullMove(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int dax = Gameutils.MOVEx(sp.getXvel(), sp.getAng());
        int day = Gameutils.MOVEy(sp.getXvel(), sp.getAng());
        short daz = sp.getZvel();
        u.moveSpriteReturn = Sprites.move_missile(SpriteNum, dax, day, daz, Gameutils.Z(16), Gameutils.Z(16), Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.DoFindGroundPoint(SpriteNum);
    }

    public static void DoSkullBeginDeath(int SpriteNum) {
        USER ou;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (sp.getOwner() >= 0 && (ou = Gameutils.getUser(sp.getOwner())) != null) {
            --ou.Counter;
        }
        sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        switch (sp.getHitag()) {
            case 1: {
                int num_ord = sp.getLotag() != 0 ? (int)sp.getLotag() : 2;
                if (num_ord > 3) {
                    num_ord = 3;
                }
                for (int i = 0; i < num_ord; ++i) {
                    sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + i * 1024));
                    JWeapon.InitSpriteChemBomb(SpriteNum);
                }
                break;
            }
            case 2: {
                int num_ord = sp.getLotag() != 0 ? (int)sp.getLotag() : 5;
                if (num_ord > 10) {
                    num_ord = 10;
                }
                for (int i = 0; i < num_ord; ++i) {
                    sp.setAng(Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(2048)));
                    JWeapon.InitCaltrops(SpriteNum);
                }
                break;
            }
            case 3: {
                Weapon.UpdateSinglePlayKills(SpriteNum, null);
                JWeapon.InitFlashBomb(SpriteNum);
                break;
            }
            case 4: {
                int num_ord = sp.getLotag() != 0 ? (int)sp.getLotag() : 5;
                if (num_ord > 10) {
                    num_ord = 10;
                }
                for (int i = 0; i < num_ord; ++i) {
                    sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + i * (2048 / num_ord)));
                    Weapon.InitSpriteGrenade(SpriteNum);
                }
                break;
            }
            default: {
                Weapon.SpawnMineExp(SpriteNum);
                for (int i = 0; i < 3; ++i) {
                    sp.setAng(Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(2048)));
                    JWeapon.InitPhosphorus(SpriteNum);
                }
            }
        }
        u.RotNum = 0;
        u.Tics = 0;
        u.ID = 820;
        u.Radius = Weapon.DamageData[23].radius;
        u.OverlapZ = Gameutils.Z(64);
        Sprites.change_sprite_stat(SpriteNum, 3);
        sp.setShade(-40);
        Weapon.SpawnLittleExp(SpriteNum);
        Weapon.SetSuicide(SpriteNum);
    }

    private static void DoSkullJump(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (sp.getXvel() != 0) {
            Skull.DoSkullMove(SpriteNum);
        } else {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 384));
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
            Actor.DoJump(SpriteNum);
        } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
            Actor.DoFall(SpriteNum);
            if (sp.getXvel() != 0) {
                WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
                if (tsp == null) {
                    return;
                }
                int dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), tsp.getX(), tsp.getY());
                if (dist < 1000 && Sprites.SpriteOverlapZ(SpriteNum, u.tgt_sp, Gameutils.Z(32))) {
                    Weapon.UpdateSinglePlayKills(SpriteNum, null);
                    Skull.DoSkullBeginDeath(SpriteNum);
                    return;
                }
                if (sp.getZ() > u.loz - Gameutils.Z(36)) {
                    sp.setZ(u.loz - Gameutils.Z(36));
                    Weapon.UpdateSinglePlayKills(SpriteNum, null);
                    Skull.DoSkullBeginDeath(SpriteNum);
                }
            } else if (u.jump_speed > 200) {
                Weapon.UpdateSinglePlayKills(SpriteNum, null);
                Skull.DoSkullBeginDeath(SpriteNum);
            }
        } else {
            Weapon.UpdateSinglePlayKills(SpriteNum, null);
            Skull.DoSkullBeginDeath(SpriteNum);
        }
    }

    private static void DoSkullBob(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.Counter = u.Counter + 48 + 12 & 0x7FF;
        sp.setZ(u.sz + (SKULL_BOB_AMT * EngineUtils.sin(u.Counter) >> 14) + (MyTypes.DIV2(SKULL_BOB_AMT) * EngineUtils.sin(u.Counter) >> 14));
    }

    private static void DoSkullSpawnShrap(int SpriteNum) {
        Shrap.SpawnShrap(SpriteNum, -1);
    }

    private static void DoSkullWait(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return;
        }
        int dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), tsp.getX(), tsp.getY());
        Ai.DoActorPickClosePlayer(SpriteNum);
        if ((u.WaitTics -= 6) <= 0) {
            Sound.PlaySound(116, sp, 0);
            u.WaitTics = Gameutils.SEC(3) + Gameutils.RANDOM_RANGE(360);
        }
        if (sp.getZ() > u.loz) {
            if (dist < 3500) {
                sp.setXvel(0);
                u.jump_speed = -600;
                Sprites.NewStateGroup(SpriteNum, sg_SkullJump);
                Actor.DoBeginJump(SpriteNum);
            }
        } else {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 288));
            Skull.DoSkullBob(SpriteNum);
            if (dist < 8000) {
                sp.setAng(EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY()));
                sp.setXvel(128 + (Gameutils.RANDOM_P2(65536) >> 8));
                u.jump_speed = -700;
                Sprites.NewStateGroup(SpriteNum, sg_SkullJump);
                Actor.DoBeginJump(SpriteNum);
            }
        }
    }

    public static void SetupBetty(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 817, s_BettyWait[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 4;
        }
        Sprites.ChangeState(SpriteNum, s_BettyWait[0][0]);
        u.Attrib = BettyAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_BettyExplode[0];
        u.setRot(sg_BettyWait);
        u.ID = 817;
        Coolie.EnemyDefaults(SpriteNum, null, null);
        sp.setClipdist(48);
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        u.Radius = 400;
        if (Gameutils.SPRITEp_BOS(sp) > u.loz - Gameutils.Z(16)) {
            sp.setZ(u.loz + Gameutils.Z(Gameutils.SPRITEp_YOFF(sp)));
            u.loz = sp.getZ();
            sp.setZ(sp.getZ() + Gameutils.SPRITEp_SIZE_TOS(sp) - Gameutils.Z(3));
        } else {
            u.Counter = Gameutils.RANDOM_P2(2048);
            u.sz = sp.getZ();
        }
    }

    private static void DoBettyMove(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int dax = Gameutils.MOVEx(sp.getXvel(), sp.getAng());
        int day = Gameutils.MOVEy(sp.getXvel(), sp.getAng());
        short daz = sp.getZvel();
        u.moveSpriteReturn = Sprites.move_missile(SpriteNum, dax, day, daz, Gameutils.Z(16), Gameutils.Z(16), Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.DoFindGroundPoint(SpriteNum);
    }

    public static void DoBettyBeginDeath(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        switch (sp.getHitag()) {
            case 1: {
                int num_ord = sp.getLotag() != 0 ? (int)sp.getLotag() : 2;
                if (num_ord > 3) {
                    num_ord = 3;
                }
                for (int i = 0; i < num_ord; ++i) {
                    sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + i * 1024));
                    JWeapon.InitSpriteChemBomb(SpriteNum);
                }
                break;
            }
            case 2: {
                int num_ord = sp.getLotag() != 0 ? (int)sp.getLotag() : 5;
                if (num_ord > 10) {
                    num_ord = 10;
                }
                for (int i = 0; i < num_ord; ++i) {
                    sp.setAng(Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(2048)));
                    JWeapon.InitCaltrops(SpriteNum);
                }
                break;
            }
            case 3: {
                JWeapon.InitFlashBomb(SpriteNum);
                break;
            }
            case 4: {
                int num_ord = sp.getLotag() != 0 ? (int)sp.getLotag() : 5;
                if (num_ord > 10) {
                    num_ord = 10;
                }
                for (int i = 0; i < num_ord; ++i) {
                    sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + i * (2048 / num_ord)));
                    Weapon.InitSpriteGrenade(SpriteNum);
                }
                break;
            }
            default: {
                for (int i = 0; i < 5; ++i) {
                    sp.setAng(Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(2048)));
                    JWeapon.InitPhosphorus(SpriteNum);
                    Weapon.SpawnMineExp(SpriteNum);
                }
            }
        }
        u.RotNum = 0;
        u.Tics = 0;
        u.ID = 817;
        u.Radius = Weapon.DamageData[23].radius;
        u.OverlapZ = Gameutils.Z(64);
        Sprites.change_sprite_stat(SpriteNum, 3);
        sp.setShade(-40);
        Weapon.SpawnLittleExp(SpriteNum);
        Weapon.SetSuicide(SpriteNum);
    }

    private static void DoBettyJump(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (sp.getXvel() != 0) {
            Skull.DoBettyMove(SpriteNum);
        } else {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 384));
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
            Actor.DoJump(SpriteNum);
        } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
            Actor.DoFall(SpriteNum);
            if (sp.getXvel() != 0) {
                WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
                if (tsp == null) {
                    return;
                }
                int dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), tsp.getX(), tsp.getY());
                if (dist < 1000 && Sprites.SpriteOverlapZ(SpriteNum, u.tgt_sp, Gameutils.Z(32))) {
                    Weapon.UpdateSinglePlayKills(SpriteNum, null);
                    Skull.DoBettyBeginDeath(SpriteNum);
                    return;
                }
                if (sp.getZ() > u.loz - Gameutils.Z(36)) {
                    sp.setZ(u.loz - Gameutils.Z(36));
                    Weapon.UpdateSinglePlayKills(SpriteNum, null);
                    Skull.DoBettyBeginDeath(SpriteNum);
                }
            } else if (u.jump_speed > 200) {
                Weapon.UpdateSinglePlayKills(SpriteNum, null);
                Skull.DoBettyBeginDeath(SpriteNum);
            }
        } else {
            Weapon.UpdateSinglePlayKills(SpriteNum, null);
            Skull.DoBettyBeginDeath(SpriteNum);
        }
    }

    private static void DoBettyBob(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.Counter = u.Counter + 48 + 12 & 0x7FF;
        sp.setZ(u.sz + (BETTY_BOB_AMT * EngineUtils.sin(u.Counter) >> 14) + (MyTypes.DIV2(BETTY_BOB_AMT) * EngineUtils.sin(u.Counter) >> 14));
    }

    private static void DoBettyWait(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return;
        }
        int dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), tsp.getX(), tsp.getY());
        Ai.DoActorPickClosePlayer(SpriteNum);
        if ((u.WaitTics -= 6) <= 0) {
            Sound.PlaySound(26, sp, 0);
            u.WaitTics = Gameutils.SEC(3);
        }
        if (sp.getZ() > u.loz) {
            if (dist < 3500) {
                sp.setXvel(0);
                u.jump_speed = -600;
                Sprites.NewStateGroup(SpriteNum, sg_BettyJump);
                Actor.DoBeginJump(SpriteNum);
            }
        } else {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 288));
            Skull.DoBettyBob(SpriteNum);
            if (dist < 8000) {
                sp.setAng(EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY()));
                sp.setXvel(128 + (Gameutils.RANDOM_P2(65536) >> 8));
                u.jump_speed = -700;
                Sprites.NewStateGroup(SpriteNum, sg_BettyJump);
                Actor.DoBeginJump(SpriteNum);
            }
        }
    }

    public static void DoSerpRing(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        USER u = Gameutils.getUser(Weapon2);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        USER ou = Gameutils.getUser(sp.getOwner());
        if (sp.getOwner() == -1 || ou != null && ou.RotNum < 5) {
            Weapon.UpdateSinglePlayKills(Weapon2, null);
            Skull.DoSkullBeginDeath(Weapon2);
            u.ID = 822;
            return;
        }
        WangSprite osp = Main.boardService.getSprite(sp.getOwner());
        if (osp == null) {
            return;
        }
        sp.setX(osp.getX());
        sp.setY(osp.getY());
        sp.setZ(sp.getZ() + sp.getZvel());
        if (sp.getZ() > osp.getZ() - u.sz) {
            sp.setZ(osp.getZ() - u.sz);
        }
        if (u.Counter2 == 0) {
            u.Dist += 96;
            if (u.Dist > u.TargetDist) {
                u.Counter2 = 1;
            }
        }
        u.slide_ang = Gameutils.NORM_ANGLE(u.slide_ang + sp.getYvel());
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 336));
        } else {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() - 336));
        }
        sp.setX(sp.getX() + (u.Dist * EngineUtils.sin(Gameutils.NORM_ANGLE(u.slide_ang + 512)) >> 14));
        sp.setY(sp.getY() + (u.Dist * EngineUtils.sin(u.slide_ang) >> 14));
        Main.engine.setsprite(Weapon2, sp.getX(), sp.getY(), sp.getZ());
        Main.engine.getzsofslope(sp.getSectnum(), sp.getX(), sp.getY(), Rooms.fz, Rooms.cz);
        if (sp.getZ() > Rooms.fz.get()) {
            sp.setZ(Rooms.fz.get());
        }
        if (sp.getZ() < Rooms.cz.get() + Gameutils.SPRITEp_SIZE_Z(sp)) {
            sp.setZ(Rooms.cz.get() + Gameutils.SPRITEp_SIZE_Z(sp));
        }
        if (u.Counter2 > 0 && ou != null) {
            USER tu = Gameutils.getUser(ou.tgt_sp);
            if (!(tsp == null || tu != null && tu.PlayerP != -1 && MyTypes.TEST(Game.Player[tu.PlayerP].Flags, Gameutils.PF_DEAD))) {
                int sectnum;
                u.tgt_sp = ou.tgt_sp;
                int dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), tsp.getX(), tsp.getY());
                if ((dist < 18000 && Gameutils.RANDOM_P2(65536) >> 5 < 16 || sp.getOwner() != -1 && ou.Counter < 4) && (sectnum = Rooms.COVERupdatesector(sp.getX(), sp.getY(), sp.getSectnum())) != -1 && Ai.CanSeePlayer(Weapon2)) {
                    u.ID = 820;
                    sp.setAng(EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY()));
                    sp.setXvel(dist >> 5);
                    sp.setXvel(sp.getXvel() + MyTypes.DIV2(sp.getXvel()));
                    sp.setXvel(sp.getXvel() + (Gameutils.RANDOM_P2(32768) >> 8));
                    u.jump_speed = -800;
                    Sprites.change_sprite_stat(Weapon2, 2);
                    Sprites.NewStateGroup(Weapon2, sg_SkullJump);
                    Actor.DoBeginJump(Weapon2);
                }
            }
        }
    }

    public static void SkullSaveable() {
        Saveable.SaveData(DoSerpRing);
        Saveable.SaveData(DoSkullJump);
        Saveable.SaveData(DoSkullSpawnShrap);
        Saveable.SaveData(DoSkullWait);
        Saveable.SaveData(DoBettyJump);
        Saveable.SaveData(DoBettyWait);
        Saveable.SaveData(s_SkullWait);
        Saveable.SaveGroup(sg_SkullWait);
        Saveable.SaveData(SkullAttrib);
        Saveable.SaveData(s_SkullRing);
        Saveable.SaveGroup(sg_SkullRing);
        Saveable.SaveData(s_SkullJump);
        Saveable.SaveGroup(sg_SkullJump);
        Saveable.SaveData(s_SkullExplode);
        Saveable.SaveData(s_BettyWait);
        Saveable.SaveGroup(sg_BettyWait);
        Saveable.SaveData(BettyAttrib);
        Saveable.SaveData(s_BettyJump);
        Saveable.SaveGroup(sg_BettyJump);
        Saveable.SaveData(s_BettyExplode);
    }
}

