/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Sumo;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Weapon;

public class Zilla {
    private static final Animator DoZillaMove = new Animator(Zilla::DoZillaMove);
    private static final Animator DoZillaStomp = new Animator(Zilla::DoZillaStomp);
    private static final Animator NullZilla = new Animator(Zilla::NullZilla);
    private static final Animator InitZillaRail = new Animator(Zilla::InitZillaRail);
    private static final Animator InitZillaRocket = new Animator(Zilla::InitZillaRocket);
    private static final Animator DoZillaDeathMelt = new Animator(Zilla::DoZillaDeathMelt);
    public static final Weapon.MISSILE_PLACEMENT[] mp2 = new Weapon.MISSILE_PLACEMENT[]{new Weapon.MISSILE_PLACEMENT(3600, 400, 512), new Weapon.MISSILE_PLACEMENT(5400, 400, 512), new Weapon.MISSILE_PLACEMENT(6600, 400, 512), new Weapon.MISSILE_PLACEMENT(3600, 400, -512), new Weapon.MISSILE_PLACEMENT(5400, 400, -512), new Weapon.MISSILE_PLACEMENT(6600, 400, -512)};
    private static VOC3D handle;
    private static boolean alreadydid;
    private static final Decision[] ZillaBattle;
    private static final Decision[] ZillaOffense;
    private static final Decision[] ZillaBroadcast;
    private static final Decision[] ZillaSurprised;
    private static final Decision[] ZillaEvasive;
    private static final Decision[] ZillaLostTarget;
    private static final Decision[] ZillaCloseRange;
    private static final Personality ZillaPersonality;
    private static final ATTRIBUTE ZillaAttrib;
    public static final int ZILLA_RATE = 48;
    private static final State[][] s_ZillaRun;
    private static final State[][] s_ZillaStand;
    public static final int ZILLA_PAIN_RATE = 30;
    private static final State[][] s_ZillaPain;
    public static final int ZILLA_RAIL_RATE = 12;
    private static final State[][] s_ZillaRail;
    public static final int ZILLA_ROCKET_RATE = 12;
    private static final State[][] s_ZillaRocket;
    public static final int ZILLA_UZI_RATE = 8;
    private static final State[][] s_ZillaUzi;
    public static final int ZILLA_DIE_RATE = 30;
    private static final State[] s_ZillaDie;
    private static final State[] s_ZillaDead;
    private static final EnemyStateGroup sg_ZillaStand;
    private static final EnemyStateGroup sg_ZillaRun;
    private static final EnemyStateGroup sg_ZillaPain;
    private static final EnemyStateGroup sg_ZillaDie;
    private static final EnemyStateGroup sg_ZillaDead;
    private static final EnemyStateGroup sg_ZillaRail;
    private static final EnemyStateGroup sg_ZillaUzi;
    private static final EnemyStateGroup sg_ZillaRocket;
    private static final Actor_Action_Set ZillaActionSet;

    public static void InitZillaStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_ZillaStand, sg_ZillaRun, sg_ZillaPain, sg_ZillaDie, sg_ZillaDead, sg_ZillaRail, sg_ZillaUzi, sg_ZillaRocket}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
                if (sg != sg_ZillaRocket) continue;
                sg.getGroup()[rot][6].setNext(sg.getGroup()[rot][5]);
            }
        }
    }

    public static void SetupZilla(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 5426, s_ZillaRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 6000;
        }
        if (Game.Skill == 0) {
            u.Health = 2000;
        }
        if (Game.Skill == 1) {
            u.Health = 4000;
        }
        Sprites.ChangeState(SpriteNum, s_ZillaRun[0][0]);
        u.Attrib = ZillaAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_ZillaDie[0];
        u.setRot(sg_ZillaRun);
        Coolie.EnemyDefaults(SpriteNum, ZillaActionSet, ZillaPersonality);
        sp.setClipdist(128);
        sp.setXrepeat(97);
        sp.setYrepeat(79);
        alreadydid = false;
    }

    public static void InitZillaRail(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Sound.PlaySound(269, sp, 12);
        u.Vis = 128;
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = Gameutils.SPRITEp_TOS(sp);
        int w = Sprites.SpawnSprite(4, 2017, Weapon.s_Rail[0][0], sp.getSectnum(), nx, ny, nz, sp.getAng(), 1200);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return;
        }
        Sprites.SetOwner(SpriteNum, w);
        wp.setYrepeat(52);
        wp.setXrepeat(52);
        wp.setShade(-15);
        int zvel = 14500;
        wu.RotNum = 5;
        Sprites.NewStateGroup(w, Weapon.WeaponStateGroup.sg_Rail);
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 3500;
        wu.ceiling_dist = Gameutils.Z(1);
        wu.floor_dist = Gameutils.Z(1);
        wp.setCstat(wp.getCstat() | (Gameutils.CSTAT_SPRITE_YCENTER | Gameutils.CSTAT_SPRITE_INVISIBLE));
        wp.setCstat(wp.getCstat() | (Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        int oclipdist = sp.getClipdist();
        sp.setClipdist(0);
        wp.setClipdist(8);
        wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() + 512));
        Weapon.HelpMissileLateral(w, 700);
        wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() - 512));
        if (Gameutils.SpriteInUnderwaterArea(wp)) {
            wu.Flags |= Gameutils.SPR_UNDERWATER;
        }
        if (Weapon.TestMissileSetPos(w, Weapon.DoRailStart, 1200, zvel)) {
            sp.setClipdist(oclipdist);
            Sprites.KillSprite(w);
            return;
        }
        sp.setClipdist(oclipdist);
        wp.setZvel(zvel >> 1);
        if (Weapon.WeaponAutoAim(SpriteNum, w, 32, 0) == -1) {
            wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() - 4));
        } else {
            zvel = wp.getZvel();
        }
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = zvel;
    }

    private static void NullZilla(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Main.engine.getzsofslope(sp.getSectnum(), sp.getX(), sp.getY(), Rooms.fz, Rooms.cz);
        u.loz = Rooms.fz.get();
        u.hiz = Rooms.cz.get();
        u.lo_sectp = sp.getSectnum();
        u.hi_sectp = sp.getSectnum();
        u.lo_sp = -1;
        u.hi_sp = -1;
        sp.setZ(u.loz);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static boolean InitZillaRocket(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return false;
        }
        int w = -1;
        Sound.PlaySound(94, sp, 0);
        int nang = EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY());
        sp.setAng(nang);
        for (int i = 0; i < mp2.length; ++i) {
            int nx = sp.getX();
            int ny = sp.getY();
            int nz = sp.getZ() - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)) - Gameutils.Z(8);
            w = Sprites.SpawnSprite(4, 2016, Weapon.s_Rocket[0][0], sp.getSectnum(), nx, ny, nz - Gameutils.Z(8), tsp.getAng(), 500);
            WangSprite wp = Main.boardService.getSprite(w);
            USER wu = Gameutils.getUser(w);
            if (wp == null || wu == null) {
                return false;
            }
            Sprites.SetOwner(SpriteNum, w);
            wp.setYrepeat(28);
            wp.setXrepeat(28);
            wp.setShade(-15);
            wp.setZvel(0);
            wp.setAng(nang);
            wp.setClipdist(16);
            wu.RotNum = 5;
            Sprites.NewStateGroup(w, Weapon.WeaponStateGroup.sg_Rocket);
            wu.Radius = 200;
            wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
            wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
            wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
            wu.zchange = wp.getZvel();
            if (i != 1 && i != 4) {
                wu.spal = (byte)17;
                wp.setPal(17);
            } else {
                wu.Flags |= Gameutils.SPR_FIND_PLAYER;
                wu.spal = (byte)20;
                wp.setPal(20);
            }
            if (Zilla.mp2[i].dist_over != 0) {
                wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() + Zilla.mp2[i].ang));
                Weapon.HelpMissileLateral(w, Zilla.mp2[i].dist_over);
                wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() - Zilla.mp2[i].ang));
            }
            Weapon.MissileSetPos(w, Weapon.DoBoltThinMan, Zilla.mp2[i].dist_out);
            int dist = Game.Distance(wp.getX(), wp.getY(), tsp.getX(), tsp.getY());
            if (dist == 0) continue;
            wu.zchange = (short)(wp.getXvel() * (Gameutils.SPRITEp_UPPER(tsp) - wp.getZ()) / dist);
            wp.setZvel(wu.zchange);
        }
        return w != 0;
    }

    private static void DoZillaMove(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (handle != null && !handle.isActive()) {
            int choose = Gameutils.STD_RANDOM_RANGE(1000);
            if (choose > 990) {
                handle = Sound.PlaySound(584, sp, 0);
            } else if (choose > 985) {
                handle = Sound.PlaySound(584, sp, 0);
            } else if (choose > 980) {
                handle = Sound.PlaySound(584, sp, 0);
            } else if (choose > 975) {
                handle = Sound.PlaySound(584, sp, 0);
            }
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoZillaStomp(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        Sound.PlaySound(615, sp, 1);
    }

    private static void DoZillaDeathMelt(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (Gameutils.RANDOM_RANGE(1000) > 800) {
            Weapon.SpawnGrenadeExp(SpriteNum);
        }
        u.ID = 5426;
        u.Flags &= ~(Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING | Gameutils.SPR_MOVED);
        if (!Main.cfg.isMuteMusic() && !alreadydid) {
            Sound.CDAudio_Play(Sound.RedBookSong[Game.Level], true);
            alreadydid = true;
        }
        Main.engine.getzsofslope(sp.getSectnum(), sp.getX(), sp.getY(), Rooms.fz, Rooms.cz);
        u.loz = Rooms.fz.get();
        u.hiz = Rooms.cz.get();
        u.lo_sectp = sp.getSectnum();
        u.hi_sectp = sp.getSectnum();
        u.lo_sp = -1;
        u.hi_sp = -1;
        sp.setZ(u.loz);
        Sumo.BossSpriteNum[2] = -2;
    }

    public static void ZillaSaveable() {
        Saveable.SaveData(InitZillaRail);
        Saveable.SaveData(InitZillaRocket);
        Saveable.SaveData(NullZilla);
        Saveable.SaveData(DoZillaMove);
        Saveable.SaveData(DoZillaStomp);
        Saveable.SaveData(DoZillaDeathMelt);
        Saveable.SaveData(ZillaPersonality);
        Saveable.SaveData(ZillaAttrib);
        Saveable.SaveData(s_ZillaRun);
        Saveable.SaveGroup(sg_ZillaRun);
        Saveable.SaveData(s_ZillaStand);
        Saveable.SaveGroup(sg_ZillaStand);
        Saveable.SaveData(s_ZillaPain);
        Saveable.SaveGroup(sg_ZillaPain);
        Saveable.SaveData(s_ZillaRail);
        Saveable.SaveGroup(sg_ZillaRail);
        Saveable.SaveData(s_ZillaRocket);
        Saveable.SaveGroup(sg_ZillaRocket);
        Saveable.SaveData(s_ZillaUzi);
        Saveable.SaveGroup(sg_ZillaUzi);
        Saveable.SaveData(s_ZillaDie);
        Saveable.SaveGroup(sg_ZillaDie);
        Saveable.SaveData(s_ZillaDead);
        Saveable.SaveGroup(sg_ZillaDead);
        Saveable.SaveData(ZillaActionSet);
    }

    static {
        alreadydid = false;
        ZillaBattle = new Decision[]{new Decision(100, Ai.InitActorRunAway), new Decision(690, Ai.InitActorMoveCloser), new Decision(692, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
        ZillaOffense = new Decision[]{new Decision(100, Ai.InitActorRunAway), new Decision(690, Ai.InitActorMoveCloser), new Decision(692, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
        ZillaBroadcast = new Decision[]{new Decision(2, Ai.InitActorAlertNoise), new Decision(4, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
        ZillaSurprised = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(703, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorDecide)};
        ZillaEvasive = new Decision[]{new Decision(1024, Ai.InitActorWanderAround)};
        ZillaLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
        ZillaCloseRange = new Decision[]{new Decision(1024, Ai.InitActorAttack)};
        ZillaPersonality = new Personality(ZillaBattle, ZillaOffense, ZillaBroadcast, ZillaSurprised, ZillaEvasive, ZillaLostTarget, ZillaCloseRange, ZillaCloseRange);
        ZillaAttrib = new ATTRIBUTE(new short[]{100, 100, 100, 100}, new short[]{3, 0, 0, 0}, 3, new int[]{590, 590, 592, 591, 592, 0, 0, 0, 0, 0});
        s_ZillaRun = new State[][]{{new State(5426, 48, DoZillaMove), new State(5427, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5427, 48, DoZillaMove), new State(5428, 48, DoZillaMove), new State(5429, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5429, 48, DoZillaMove)}, {new State(5422, 48, DoZillaMove), new State(5423, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5423, 48, DoZillaMove), new State(5424, 48, DoZillaMove), new State(5425, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5425, 48, DoZillaMove)}, {new State(5418, 48, DoZillaMove), new State(5419, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5419, 48, DoZillaMove), new State(5420, 48, DoZillaMove), new State(5421, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5421, 48, DoZillaMove)}, {new State(5414, 48, DoZillaMove), new State(5415, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5415, 48, DoZillaMove), new State(5416, 48, DoZillaMove), new State(5417, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5417, 48, DoZillaMove)}, {new State(5410, 48, DoZillaMove), new State(5411, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5411, 48, DoZillaMove), new State(5412, 48, DoZillaMove), new State(5413, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5413, 48, DoZillaMove)}};
        s_ZillaStand = new State[][]{{new State(5426, 48, DoZillaMove).setNext()}, {new State(5422, 48, DoZillaMove).setNext()}, {new State(5418, 48, DoZillaMove).setNext()}, {new State(5414, 48, DoZillaMove).setNext()}, {new State(5410, 48, DoZillaMove).setNext()}};
        s_ZillaPain = new State[][]{{new State(5524, 30, NullZilla), new State(5524, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5523, 30, NullZilla), new State(5523, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5522, 30, NullZilla), new State(5522, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5521, 30, NullZilla), new State(5521, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5520, 30, NullZilla), new State(5520, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}};
        s_ZillaRail = new State[][]{{new State(5466, 12, NullZilla), new State(5467, 12, NullZilla), new State(5468, 12, NullZilla), new State(5469, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5466, 12, NullZilla), new State(5467, 12, NullZilla), new State(5468, 12, NullZilla), new State(5469, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5466, 12, NullZilla), new State(5467, 12, NullZilla), new State(5468, 12, NullZilla), new State(5469, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5469, 12, NullZilla), new State(5469, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5462, 12, NullZilla), new State(5463, 12, NullZilla), new State(5464, 12, NullZilla), new State(5465, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5462, 12, NullZilla), new State(5463, 12, NullZilla), new State(5464, 12, NullZilla), new State(5465, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5462, 12, NullZilla), new State(5463, 12, NullZilla), new State(5464, 12, NullZilla), new State(5465, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5465, 12, NullZilla), new State(5465, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5458, 12, NullZilla), new State(5459, 12, NullZilla), new State(5460, 12, NullZilla), new State(5461, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5458, 12, NullZilla), new State(5459, 12, NullZilla), new State(5460, 12, NullZilla), new State(5461, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5458, 12, NullZilla), new State(5459, 12, NullZilla), new State(5460, 12, NullZilla), new State(5461, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5461, 12, NullZilla), new State(5461, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5454, 12, NullZilla), new State(5455, 12, NullZilla), new State(5456, 12, NullZilla), new State(5457, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5454, 12, NullZilla), new State(5455, 12, NullZilla), new State(5456, 12, NullZilla), new State(5457, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5454, 12, NullZilla), new State(5455, 12, NullZilla), new State(5456, 12, NullZilla), new State(5457, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5457, 12, NullZilla), new State(5457, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5450, 12, NullZilla), new State(5451, 12, NullZilla), new State(5452, 12, NullZilla), new State(5453, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5450, 12, NullZilla), new State(5451, 12, NullZilla), new State(5452, 12, NullZilla), new State(5453, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5450, 12, NullZilla), new State(5451, 12, NullZilla), new State(5452, 12, NullZilla), new State(5453, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5453, 12, NullZilla), new State(5453, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}};
        s_ZillaRocket = new State[][]{{new State(5446, 12, NullZilla), new State(5447, 12, NullZilla), new State(5448, 48, NullZilla), new State(5448, Gameutils.SF_QUICK_CALL, InitZillaRocket), new State(5448, 48, NullZilla), new State(5449, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5449, 120, NullZilla)}, {new State(5442, 12, NullZilla), new State(5443, 12, NullZilla), new State(5444, 48, NullZilla), new State(5444, Gameutils.SF_QUICK_CALL, InitZillaRocket), new State(5444, 48, NullZilla), new State(5445, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5445, 120, NullZilla)}, {new State(5438, 12, NullZilla), new State(5439, 12, NullZilla), new State(5440, 48, NullZilla), new State(5440, Gameutils.SF_QUICK_CALL, InitZillaRocket), new State(5440, 48, NullZilla), new State(5441, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5441, 120, NullZilla)}, {new State(5434, 12, NullZilla), new State(5435, 12, NullZilla), new State(5436, 48, NullZilla), new State(5436, Gameutils.SF_QUICK_CALL, InitZillaRocket), new State(5436, 48, NullZilla), new State(5437, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5437, 120, NullZilla)}, {new State(5430, 12, NullZilla), new State(5431, 12, NullZilla), new State(5432, 48, NullZilla), new State(5432, Gameutils.SF_QUICK_CALL, InitZillaRocket), new State(5432, 48, NullZilla), new State(5433, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5433, 120, NullZilla)}};
        s_ZillaUzi = new State[][]{{new State(5506, 8, NullZilla), new State(5506, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide).setNext()}, {new State(5502, 8, NullZilla), new State(5502, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide).setNext()}, {new State(5498, 8, NullZilla), new State(5498, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide).setNext()}, {new State(5494, 8, NullZilla), new State(5494, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide).setNext()}, {new State(5490, 8, NullZilla), new State(5490, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide).setNext()}};
        s_ZillaDie = new State[]{new State(5510, 450, DoZillaDeathMelt), new State(5511, 30, NullZilla), new State(5512, 30, NullZilla), new State(5513, 30, NullZilla), new State(5514, 30, NullZilla), new State(5515, 30, NullZilla), new State(5516, 30, NullZilla), new State(5517, 90, NullZilla), new State(5518, 30, Actor.DoActorDebris).setNext()};
        s_ZillaDead = new State[]{new State(5518, 30, Actor.DoActorDebris).setNext()};
        sg_ZillaStand = new EnemyStateGroup(s_ZillaStand[0], s_ZillaStand[1], s_ZillaStand[2], s_ZillaStand[3], s_ZillaStand[4]);
        sg_ZillaRun = new EnemyStateGroup(s_ZillaRun[0], s_ZillaRun[1], s_ZillaRun[2], s_ZillaRun[3], s_ZillaRun[4]);
        sg_ZillaPain = new EnemyStateGroup(s_ZillaPain[0], s_ZillaPain[1], s_ZillaPain[2], s_ZillaPain[3], s_ZillaPain[4]);
        sg_ZillaDie = new EnemyStateGroup(new State[][]{s_ZillaDie});
        sg_ZillaDead = new EnemyStateGroup(new State[][]{s_ZillaDead});
        sg_ZillaRail = new EnemyStateGroup(s_ZillaRail[0], s_ZillaRail[1], s_ZillaRail[2], s_ZillaRail[3], s_ZillaRail[4]);
        sg_ZillaUzi = new EnemyStateGroup(s_ZillaUzi[0], s_ZillaUzi[1], s_ZillaUzi[2], s_ZillaUzi[3], s_ZillaUzi[4]);
        sg_ZillaRocket = new EnemyStateGroup(s_ZillaRocket[0], s_ZillaRocket[1], s_ZillaRocket[2], s_ZillaRocket[3], s_ZillaRocket[4]);
        ZillaActionSet = new Actor_Action_Set(sg_ZillaStand, sg_ZillaRun, null, null, null, null, null, null, null, null, null, sg_ZillaPain, sg_ZillaDie, null, sg_ZillaDead, null, null, new StateGroup[]{sg_ZillaUzi, sg_ZillaRail}, new short[]{950, 1024}, new StateGroup[]{sg_ZillaUzi, sg_ZillaRocket, sg_ZillaRail}, new short[]{400, 950, 1024}, null, null, null);
    }
}

