/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.osd.CommandResponse;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.commands.OsdCommand;
import ru.m210projects.Wang.Factory.WangBoardService;
import ru.m210projects.Wang.Factory.WangPaletteManager;
import ru.m210projects.Wang.Factory.WangTimer;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Type.LONGp;

public class WangEngine
extends Engine {
    public static String randomStack = "";

    public WangEngine(BuildGame game) throws Exception {
        super(game);
        this.inittimer(game.pCfg.isLegacyTimer(), 120, 3);
        Console.out.registerCommand(new OsdCommand("fastdemo", "fastdemo \"demo speed\""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (argv.length != 1) {
                    return CommandResponse.DESCRIPTION_RESPONSE;
                }
                try {
                    WangEngine.this.getTimer().setSkipTicks(Math.max(0, Integer.parseInt(argv[0])));
                }
                catch (Exception e) {
                    return CommandResponse.BAD_ARGUMENT_RESPONSE;
                }
                return CommandResponse.OK_RESPONSE;
            }
        });
    }

    @Override
    public void inittimer(boolean isLegacy, int tickspersecond, int frameTicks) {
        int totalclock = 0;
        if (this.timer != null) {
            totalclock = this.timer.getTotalClock();
        }
        this.timer = isLegacy ? new WangTimer.Legacy(tickspersecond, frameTicks) : new WangTimer(tickspersecond, frameTicks);
        this.timer.setTotalClock(totalclock);
    }

    @Override
    protected BoardService createBoardService() {
        return new WangBoardService();
    }

    @Override
    public WangBoardService getBoardService() {
        return (WangBoardService)this.boardService;
    }

    @Override
    public PaletteManager loadpalette() throws Exception {
        return new WangPaletteManager(this);
    }

    public Interpolation getInterpolation(int type) {
        if (Game.nInterpolation >= 2) {
            switch (type) {
                case 2: {
                    return Main.game.pIntSkip2;
                }
                case 4: {
                    return Main.game.pIntSkip4;
                }
            }
        }
        return this.game.pInt;
    }

    @Override
    public int clipmove(int x, int y, int z, int sectnum, long xvect, long yvect, int walldist, int ceildist, int flordist, int cliptype) {
        this.clipmove.setTraceNum(clipmoveboxtracenum);
        return super.clipmove(x, y, z, sectnum, xvect, yvect, walldist, ceildist, flordist, cliptype);
    }

    public void dragpoint(int moveskip, int pointhighlight, int dax, int day) {
        if (Game.nInterpolation == 1) {
            super.dragpoint(pointhighlight, dax, day);
            return;
        }
        Wall wall = this.boardService.getWall(pointhighlight);
        if (wall == null) {
            return;
        }
        Interpolation pInt = this.getInterpolation(moveskip);
        pInt.setwallinterpolate(pointhighlight, wall);
        wall.setX(dax);
        wall.setY(day);
        int cnt = MAXWALLS;
        int tempshort = pointhighlight;
        block0: do {
            Wall lwall;
            Wall tempWall;
            if ((tempWall = this.boardService.getWall(tempshort)) == null) {
                return;
            }
            Wall nwall = this.boardService.getWall(tempWall.getNextwall());
            if (nwall != null) {
                tempshort = nwall.getPoint2();
                tempWall = this.boardService.getWall(tempshort);
                if (tempWall == null) continue;
                pInt.setwallinterpolate(tempshort, tempWall);
                tempWall.setX(dax);
                tempWall.setY(day);
                continue;
            }
            tempshort = pointhighlight;
            while ((lwall = this.boardService.getWall(this.lastwall(tempshort))) != null && lwall.getNextwall() >= 0) {
                tempshort = lwall.getNextwall();
                tempWall = this.boardService.getWall(tempshort);
                if (tempWall != null) {
                    pInt.setwallinterpolate(tempshort, tempWall);
                    tempWall.setX(dax);
                    tempWall.setY(day);
                }
                if (tempshort != pointhighlight && --cnt > 0) continue;
                break block0;
            }
            break;
        } while (tempshort != pointhighlight && --cnt > 0);
    }

    @Override
    public int krand() {
        this.randomseed = this.randomseed * 21 + 1 & 0xFFFF;
        return this.randomseed;
    }

    public void getzrange(int x, int y, int z, int sectnum, LONGp hiz, LONGp ceilhit, LONGp loz, LONGp florhit, int walldist, int cliptype) {
        super.getzrange(x, y, z, sectnum, walldist, cliptype);
        if (hiz != null) {
            hiz.value = zr_ceilz;
        }
        if (ceilhit != null) {
            ceilhit.value = zr_ceilhit;
        }
        if (loz != null) {
            loz.value = zr_florz;
        }
        if (florhit != null) {
            florhit.value = zr_florhit;
        }
    }

    public void setspritez(int spritenum, int newx, int newy, int newz) {
        Sprite sprite = this.boardService.getSprite(spritenum);
        if (sprite == null) {
            return;
        }
        sprite.setX(newx);
        sprite.setY(newy);
        sprite.setZ(newz);
        int tempsectnum = this.updatesectorz(newx, newy, newz, sprite.getSectnum());
        if (tempsectnum < 0) {
            return;
        }
        if (tempsectnum != sprite.getSectnum()) {
            this.changespritesect(spritenum, tempsectnum);
        }
    }

    public void getzrangepoint(int x, int y, int z, int sectnum, LONGp ceilz, LONGp ceilhit, LONGp florz, LONGp florhit) {
        if (!this.boardService.isValidSector(sectnum)) {
            if (ceilz != null) {
                ceilz.value = Integer.MIN_VALUE;
            }
            if (ceilhit != null) {
                ceilhit.value = -1;
            }
            if (florz != null) {
                florz.value = Integer.MAX_VALUE;
            }
            if (florhit != null) {
                florhit.value = -1;
            }
            return;
        }
        this.getzsofslope(sectnum, x, y, Rooms.fz, Rooms.cz);
        if (ceilz != null) {
            ceilz.value = Rooms.cz.get();
        }
        if (florz != null) {
            florz.value = Rooms.fz.get();
        }
        if (ceilhit != null) {
            ceilhit.value = sectnum | 0x40000000;
        }
        if (florhit != null) {
            florhit.value = sectnum | 0x40000000;
        }
        for (ListNode<Sprite> node = this.boardService.getSectNode(sectnum); node != null; node = node.getNext()) {
            int j = node.getIndex();
            Sprite spr = node.get();
            short cstat = spr.getCstat();
            if ((cstat & 0x31) != 33) continue;
            int daz = spr.getZ();
            if ((cstat & 0x40) != 0 && z > daz == ((cstat & 8) == 0)) continue;
            short tilenum = spr.getPicnum();
            ArtEntry pic = this.getTile(tilenum);
            byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
            byte yoff = (byte)(pic.getOffsetY() + spr.getYoffset());
            if ((cstat & 4) != 0) {
                xoff = -xoff;
            }
            if ((cstat & 8) != 0) {
                yoff = -yoff;
            }
            int cosang = EngineUtils.sin(Gameutils.NORM_ANGLE(spr.getAng() + 512));
            int sinang = EngineUtils.sin(Gameutils.NORM_ANGLE(spr.getAng()));
            int xspan = pic.getWidth();
            int dax = ((xspan >> 1) + xoff) * spr.getXrepeat();
            int yspan = pic.getHeight();
            int day = ((yspan >> 1) + yoff) * spr.getYrepeat();
            int x1 = spr.getX() + Pragmas.dmulscale(sinang, dax, cosang, day, 16) - x;
            int y1 = spr.getY() + Pragmas.dmulscale(sinang, day, -cosang, dax, 16) - y;
            int l = xspan * spr.getXrepeat();
            int x2 = x1 - Pragmas.mulscale(sinang, l, 16);
            int y2 = y1 + Pragmas.mulscale(cosang, l, 16);
            l = yspan * spr.getYrepeat();
            int k = -Pragmas.mulscale(cosang, l, 16);
            int x3 = x2 + k;
            int x4 = x1 + k;
            k = -Pragmas.mulscale(sinang, l, 16);
            int y3 = y2 + k;
            int y4 = y1 + k;
            boolean clipyou = false;
            if ((y1 ^ y2) < 0) {
                if ((x1 ^ x2) < 0) {
                    clipyou ^= x1 * y2 < x2 * y1 ^ y1 < y2;
                } else if (x1 >= 0) {
                    clipyou ^= true;
                }
            }
            if ((y2 ^ y3) < 0) {
                if ((x2 ^ x3) < 0) {
                    clipyou ^= x2 * y3 < x3 * y2 ^ y2 < y3;
                } else if (x2 >= 0) {
                    clipyou ^= true;
                }
            }
            if ((y3 ^ y4) < 0) {
                if ((x3 ^ x4) < 0) {
                    clipyou ^= x3 * y4 < x4 * y3 ^ y3 < y4;
                } else if (x3 >= 0) {
                    clipyou ^= true;
                }
            }
            if ((y4 ^ y1) < 0) {
                if ((x4 ^ x1) < 0) {
                    clipyou ^= x4 * y1 < x1 * y4 ^ y4 < y1;
                } else if (x4 >= 0) {
                    clipyou ^= true;
                }
            }
            if (!clipyou) continue;
            if (z > daz) {
                if (ceilz == null || daz <= ceilz.value) continue;
                ceilz.value = daz;
                if (ceilhit == null) continue;
                ceilhit.value = j | 0xC0000000;
                continue;
            }
            if (florz == null || daz >= florz.value) continue;
            florz.value = daz;
            if (florhit == null) continue;
            florhit.value = j | 0xC0000000;
        }
    }

    public void compare(Sprite src, Sprite dst) {
        Console.out.println("Comparing...", OsdColor.GREEN);
        if (dst.getX() != src.getX()) {
            Console.out.println("Not match x: " + dst.getX() + " != " + src.getX(), OsdColor.RED);
        }
        if (dst.getY() != src.getY()) {
            Console.out.println("Not match y: " + dst.getY() + " != " + src.getY(), OsdColor.RED);
        }
        if (dst.getZ() != src.getZ()) {
            Console.out.println("Not match z: " + dst.getZ() + " != " + src.getZ(), OsdColor.RED);
        }
        if (dst.getCstat() != src.getCstat()) {
            Console.out.println("Not match cstat: " + dst.getCstat() + " != " + src.getCstat(), OsdColor.RED);
        }
        if (dst.getPicnum() != src.getPicnum()) {
            Console.out.println("Not match picnum: " + dst.getPicnum() + " != " + src.getPicnum(), OsdColor.RED);
        }
        if (dst.getShade() != src.getShade()) {
            Console.out.println("Not match shade: " + dst.getShade() + " != " + src.getShade(), OsdColor.RED);
        }
        if (dst.getPal() != src.getPal()) {
            Console.out.println("Not match pal: " + dst.getPal() + " != " + src.getPal(), OsdColor.RED);
        }
        if (dst.getClipdist() != src.getClipdist()) {
            Console.out.println("Not match clipdist: " + dst.getClipdist() + " != " + src.getClipdist(), OsdColor.RED);
        }
        if (dst.getDetail() != src.getDetail()) {
            Console.out.println("Not match detail: " + dst.getDetail() + " != " + src.getDetail(), OsdColor.RED);
        }
        if (dst.getXrepeat() != src.getXrepeat()) {
            Console.out.println("Not match xrepeat: " + dst.getXrepeat() + " != " + src.getXrepeat(), OsdColor.RED);
        }
        if (dst.getYrepeat() != src.getYrepeat()) {
            Console.out.println("Not match xrepeat: " + dst.getYrepeat() + " != " + src.getYrepeat(), OsdColor.RED);
        }
        if (dst.getXoffset() != src.getXoffset()) {
            Console.out.println("Not match xoffset: " + dst.getXoffset() + " != " + src.getXoffset(), OsdColor.RED);
        }
        if (dst.getYoffset() != src.getYoffset()) {
            Console.out.println("Not match yoffset: " + dst.getYoffset() + " != " + src.getYoffset(), OsdColor.RED);
        }
        if (dst.getSectnum() != src.getSectnum()) {
            Console.out.println("Not match sectnum: " + dst.getSectnum() + " != " + src.getSectnum(), OsdColor.RED);
        }
        if (dst.getStatnum() != src.getStatnum()) {
            Console.out.println("Not match statnum: " + dst.getStatnum() + " != " + src.getStatnum(), OsdColor.RED);
        }
        if (dst.getAng() != src.getAng()) {
            Console.out.println("Not match ang: " + dst.getAng() + " != " + src.getAng(), OsdColor.RED);
        }
        if (dst.getOwner() != src.getOwner()) {
            Console.out.println("Not match owner: " + dst.getOwner() + " != " + src.getOwner(), OsdColor.RED);
        }
        if (dst.getXvel() != src.getXvel()) {
            Console.out.println("Not match xvel: " + dst.getXvel() + " != " + src.getXvel(), OsdColor.RED);
        }
        if (dst.getYvel() != src.getYvel()) {
            Console.out.println("Not match yvel: " + dst.getYvel() + " != " + src.getYvel(), OsdColor.RED);
        }
        if (dst.getZvel() != src.getZvel()) {
            Console.out.println("Not match zvel: " + dst.getZvel() + " != " + src.getZvel(), OsdColor.RED);
        }
        if (dst.getLotag() != src.getLotag()) {
            Console.out.println("Not match lotag: " + dst.getLotag() + " != " + src.getLotag(), OsdColor.RED);
        }
        if (dst.getHitag() != src.getHitag()) {
            Console.out.println("Not match hitag: " + dst.getHitag() + " != " + src.getHitag(), OsdColor.RED);
        }
        if (dst.getExtra() != src.getExtra()) {
            Console.out.println("Not match extra: " + dst.getExtra() + " != " + src.getExtra(), OsdColor.RED);
        }
        Console.out.println("Compare completed", OsdColor.GREEN);
    }
}

