/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import java.io.IOException;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.Types.Color;
import ru.m210projects.Build.Types.DefaultFastColorLookup;
import ru.m210projects.Build.Types.DefaultPaletteLoader;
import ru.m210projects.Build.Types.DefaultPaletteManager;
import ru.m210projects.Build.Types.FastColorLookup;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;

public class WangPaletteManager
extends DefaultPaletteManager {
    public static byte[] tempbuf = new byte[256];
    public static final COLOR_MAP BrownRipper = new COLOR_MAP(31, 32, 1, 64);
    public static final COLOR_MAP SkelGore = new COLOR_MAP(16, 16, 112, 144);
    public static final COLOR_MAP ElectroGore = new COLOR_MAP(16, 16, 112, 208);
    public static final COLOR_MAP MenuHighlight = new COLOR_MAP(16, 16, 112, 240);
    public static final COLOR_MAP[][] PlayerColorMap = new COLOR_MAP[][]{{new COLOR_MAP(32, 32, 192, 32)}, {new COLOR_MAP(32, 31, 192, 1)}, {new COLOR_MAP(32, 16, 192, 224)}, {new COLOR_MAP(32, 16, 192, 96)}, {new COLOR_MAP(32, 16, 192, 128)}, {new COLOR_MAP(32, 16, 192, 160)}, {new COLOR_MAP(32, 16, 192, 176)}, {new COLOR_MAP(32, 32, 192, 192)}, {new COLOR_MAP(32, 32, 192, 64)}, {new COLOR_MAP(32, 16, 192, 112)}, {new COLOR_MAP(32, 16, 192, 16)}, {new COLOR_MAP(32, 16, 192, 144)}, {new COLOR_MAP(32, 16, 192, 208)}, {new COLOR_MAP(32, 16, 192, 240)}, {new COLOR_MAP(32, 16, 192, 240)}};
    public static final COLOR_MAP[] AllToRed = new COLOR_MAP[]{new COLOR_MAP(31, 16, 1, 112), new COLOR_MAP(32, 16, 32, 112), new COLOR_MAP(32, 16, 64, 112), new COLOR_MAP(16, 16, 96, 112), new COLOR_MAP(16, 16, 128, 112), new COLOR_MAP(16, 16, 144, 112), new COLOR_MAP(16, 16, 160, 112), new COLOR_MAP(16, 16, 176, 112), new COLOR_MAP(32, 16, 192, 112), new COLOR_MAP(16, 16, 224, 112), new COLOR_MAP(16, 16, 240, 112)};
    public static final COLOR_MAP[] AllToBlue = new COLOR_MAP[]{new COLOR_MAP(31, 32, 1, 192), new COLOR_MAP(32, 32, 32, 192), new COLOR_MAP(32, 32, 64, 192), new COLOR_MAP(16, 32, 96, 192), new COLOR_MAP(16, 32, 128, 192), new COLOR_MAP(16, 32, 144, 192), new COLOR_MAP(16, 32, 160, 192), new COLOR_MAP(16, 32, 176, 192), new COLOR_MAP(16, 32, 112, 192), new COLOR_MAP(16, 32, 224, 192), new COLOR_MAP(16, 32, 240, 192)};
    public static final COLOR_MAP[] AllToGreen = new COLOR_MAP[]{new COLOR_MAP(31, 16, 1, 176), new COLOR_MAP(32, 16, 32, 176), new COLOR_MAP(32, 16, 64, 176), new COLOR_MAP(16, 16, 96, 176), new COLOR_MAP(16, 16, 128, 176), new COLOR_MAP(16, 16, 144, 176), new COLOR_MAP(16, 16, 160, 176), new COLOR_MAP(16, 16, 176, 176), new COLOR_MAP(32, 16, 192, 176), new COLOR_MAP(16, 16, 112, 176), new COLOR_MAP(16, 16, 224, 176), new COLOR_MAP(16, 16, 240, 176)};
    public static final COLOR_MAP[] NinjaBasic = new COLOR_MAP[]{new COLOR_MAP(32, 16, 64, 16), new COLOR_MAP(32, 16, 32, 16), new COLOR_MAP(32, 31, 192, 1), new COLOR_MAP(16, 16, 160, 16), new COLOR_MAP(16, 16, 176, 16), new COLOR_MAP(16, 16, 128, 16)};
    public static final COLOR_MAP[] NinjaRed = new COLOR_MAP[]{new COLOR_MAP(16, 16, 80, 16), new COLOR_MAP(16, 16, 176, 80), new COLOR_MAP(16, 8, 48, 120), new COLOR_MAP(32, 16, 192, 112)};
    public static final COLOR_MAP[] NinjaGreen = new COLOR_MAP[]{new COLOR_MAP(16, 16, 80, 16), new COLOR_MAP(16, 16, 176, 80), new COLOR_MAP(16, 8, 48, 182), new COLOR_MAP(32, 16, 192, 176)};
    public static final COLOR_MAP[] Illuminate = new COLOR_MAP[]{new COLOR_MAP(16, 8, 1, 144), new COLOR_MAP(16, 8, 16, 144), new COLOR_MAP(16, 8, 32, 144), new COLOR_MAP(16, 8, 48, 144), new COLOR_MAP(16, 8, 64, 144), new COLOR_MAP(16, 8, 80, 144), new COLOR_MAP(16, 8, 96, 144), new COLOR_MAP(16, 8, 128, 144), new COLOR_MAP(16, 8, 160, 144), new COLOR_MAP(16, 8, 176, 144), new COLOR_MAP(32, 8, 192, 144), new COLOR_MAP(16, 8, 112, 144), new COLOR_MAP(16, 8, 224, 144), new COLOR_MAP(16, 8, 240, 144)};
    public static final Color WATER_FOG_COLOR = new Color(0, 0, 15, 0);

    public WangPaletteManager(Engine engine) throws IOException {
        super(engine, new DefaultPaletteLoader(Main.game.getCache().getEntry("palette.dat", true)){

            @Override
            public FastColorLookup getFastColorLookup() {
                return new DefaultFastColorLookup(this.getBasePalette(), 1, 1, 1);
            }
        });
        this.initPalette();
    }

    public void updateUnderwaterGLFog(int pal) {
        this.palookupfog[0] = Gameutils.SectorIsUnderwaterArea(Game.Player[Game.screenpeek].cursectnum) && pal == 9 ? WATER_FOG_COLOR : DEFAULT_COLOR;
    }

    public void initPalette() {
        int i;
        tempbuf = new byte[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            WangPaletteManager.tempbuf[i2] = (byte)i2;
        }
        this.makePalookup(9, tempbuf, 0, 0, 15, 1);
        int FOG_AMT = 15;
        this.makePalookup(1, tempbuf, FOG_AMT, FOG_AMT, FOG_AMT, 1);
        this.makePalookup(5, tempbuf, 11, 0, 0, 1);
        WangPaletteManager.MapColors(7, BrownRipper, 1);
        this.makePalookup(7, tempbuf, 0, 0, 0, 1);
        WangPaletteManager.MapColors(10, SkelGore, 1);
        this.makePalookup(10, tempbuf, 0, 0, 0, 1);
        WangPaletteManager.MapColors(3, ElectroGore, 1);
        this.makePalookup(3, tempbuf, 0, 0, 0, 1);
        WangPaletteManager.MapColors(2, MenuHighlight, 1);
        this.makePalookup(2, tempbuf, 0, 0, 0, 1);
        WangPaletteManager.MapColors(4, NinjaBasic[0], 1);
        for (i = 1; i < NinjaBasic.length; ++i) {
            WangPaletteManager.MapColors(4, NinjaBasic[i], 0);
        }
        this.makePalookup(4, tempbuf, 0, 0, 0, 1);
        WangPaletteManager.MapColors(6, NinjaRed[0], 1);
        for (i = 1; i < NinjaRed.length; ++i) {
            WangPaletteManager.MapColors(6, NinjaRed[i], 0);
        }
        this.makePalookup(6, tempbuf, 0, 0, 0, 1);
        WangPaletteManager.MapColors(8, NinjaGreen[0], 1);
        for (i = 1; i < NinjaGreen.length; ++i) {
            WangPaletteManager.MapColors(8, NinjaGreen[i], 0);
        }
        this.makePalookup(8, tempbuf, 0, 0, 0, 1);
        WangPaletteManager.MapColors(11, AllToGreen[0], 1);
        for (i = 1; i < AllToGreen.length; ++i) {
            WangPaletteManager.MapColors(11, AllToGreen[i], 0);
        }
        this.makePalookup(11, tempbuf, 0, 0, 0, 1);
        WangPaletteManager.MapColors(14, AllToRed[0], 1);
        for (i = 1; i < AllToRed.length; ++i) {
            WangPaletteManager.MapColors(14, AllToRed[i], 0);
        }
        this.makePalookup(14, tempbuf, 0, 0, 0, 1);
        WangPaletteManager.MapColors(13, AllToBlue[0], 1);
        for (i = 1; i < AllToBlue.length; ++i) {
            WangPaletteManager.MapColors(13, AllToBlue[i], 0);
        }
        this.makePalookup(13, tempbuf, 0, 0, 0, 1);
        WangPaletteManager.MapColors(32, Illuminate[0], 1);
        for (i = 1; i < Illuminate.length; ++i) {
            WangPaletteManager.MapColors(32, Illuminate[i], 0);
        }
        this.makePalookup(32, tempbuf, 0, 0, 0, 1);
        for (int play = 0; play < 15; ++play) {
            WangPaletteManager.MapColors(16 + play, PlayerColorMap[play][0], 1);
            WangPaletteManager.MapColors(16 + play, PlayerColorMap[play][0], 0);
            this.makePalookup(16 + play, tempbuf, 0, 0, 0, 1);
        }
        for (i = 0; i < 256; ++i) {
            WangPaletteManager.tempbuf[i] = (byte)i;
        }
        for (i = 0; i < 32; ++i) {
            WangPaletteManager.tempbuf[32 + i] = (byte)(64 - i);
        }
        this.makePalookup(15, tempbuf, 0, 0, 0, 1);
    }

    private static void MapColors(int num, COLOR_MAP cm, int create) {
        int i;
        if (create != 0) {
            for (i = 0; i < 256; ++i) {
                WangPaletteManager.tempbuf[i] = (byte)i;
            }
        }
        if (cm.FromRange == 0 || num <= 0 || num >= 256) {
            return;
        }
        float inc = (float)cm.ToRange / (float)cm.FromRange;
        for (i = 0; i < cm.FromRange; ++i) {
            WangPaletteManager.tempbuf[i + cm.FromColor] = (byte)((float)i * inc + (float)cm.ToColor);
        }
    }

    public static class COLOR_MAP {
        public final int FromRange;
        public final int ToRange;
        public final int FromColor;
        public final int ToColor;

        public COLOR_MAP(int FromRange, int ToRange, int FromColor, int ToColor) {
            this.FromRange = FromRange;
            this.ToRange = ToRange;
            this.FromColor = FromColor;
            this.ToColor = ToColor;
        }
    }
}

