/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.io.IOException;
import java.util.Arrays;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.CommandResponse;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.commands.OsdCallback;
import ru.m210projects.Build.osd.commands.OsdValueRange;
import ru.m210projects.Wang.Border;
import ru.m210projects.Wang.Break;
import ru.m210projects.Wang.Draw;
import ru.m210projects.Wang.Enemies.Bunny;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Enemies.Sumo;
import ru.m210projects.Wang.Factory.DemoRecorder;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Factory.rts.RTSFile;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JSector;
import ru.m210projects.Wang.Light;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.Network.NetInfo;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.EpisodeEntry;
import ru.m210projects.Wang.Type.EpisodeInfo;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.LastLevelUser;
import ru.m210projects.Wang.Type.LevelInfo;
import ru.m210projects.Wang.Type.List;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Game {
    public static final int BACKBUTTON = 9216;
    public static final int MOUSECURSOR = 9217;
    public static final int ALTHUDLEFT = 9218;
    public static final int ALTHUDRIGHT = 9219;
    public static final int ANIM_INTRO = 0;
    public static final int ANIM_SERP = 1;
    public static final int ANIM_SUMO = 2;
    public static final int ANIM_ZILLA = 3;
    public static final int RECSYNCBUFSIZ = 2520;
    public static final EpisodeInfo pSharewareEp = new EpisodeInfo("Enter the Wang", "Four levels (Shareware Version)", new LevelInfo[]{new LevelInfo("$bullet.map", "e1l01.mid", "Seppuku Station", "0 : 55", "5 : 00"), new LevelInfo("$dozer.map", "e1l03.mid", "Zilla Construction", "4 : 59", "8 : 00"), new LevelInfo("$shrine.map", "e1l02.mid", "Master Leep's Temple", "3 : 16", "10 : 00"), new LevelInfo("$woods.map", "e1l04.mid", "Dark Woods of the Serpent", "7 : 06", "16 : 00")});
    public static final EpisodeInfo pOriginalEp = new EpisodeInfo("Code of Honor", "Eighteen levels (Full Version only)", new LevelInfo[]{new LevelInfo("$whirl.map", "yokoha03.mid", "Rising Son", "5 : 30", "10 : 00"), new LevelInfo("$tank.map", "nippon34.mid", "Killing Fields", "1 : 46", "4 : 00"), new LevelInfo("$boat.map", "execut11.mid", "Hara-Kiri Harbor", "1 : 56", "4 : 00"), new LevelInfo("$garden.map", "execut11.mid", "Zilla's Villa", "1 : 06", "2 : 00"), new LevelInfo("$outpost.map", "sanai.mid", "Monastery", "1 : 23", "3 : 00"), new LevelInfo("$hidtemp.map", "kotec2.mid", "Raider of the Lost Wang", "2 : 05", "4 : 10"), new LevelInfo("$plax1.map", "kotec2.mid", "Sumo Sky Palace", "6 : 32", "12 : 00"), new LevelInfo("$bath.map", "yokoha03.mid", "Bath House", "10 : 00", "10 : 00"), new LevelInfo("$airport.map", "nippon34.mid", "Unfriendly Skies", "2 : 59", "6 : 00"), new LevelInfo("$refiner.map", "kotoki12.mid", "Crude Oil", "2 : 40", "5 : 00"), new LevelInfo("$newmine.map", "hoshia02.mid", "Coolie Mines", "2 : 48", "6 : 00"), new LevelInfo("$subbase.map", "hoshia02.mid", "Subpen 7", "2 : 02", "4 : 00"), new LevelInfo("$rock.map", "kotoki12.mid", "The Great Escape", "3 : 18", "6 : 00"), new LevelInfo("$yamato.map", "sanai.mid", "Floating Fortress", "11 : 38", "20 : 00"), new LevelInfo("$seabase.map", "kotec2.mid", "Water Torture", "5 : 07", "10 : 00"), new LevelInfo("$volcano.map", "kotec2.mid", "Stone Rain", "9 : 15", "20 : 00"), new LevelInfo("$shore.map", "kotec2.mid", "Shanghai Shipwreck", "3 : 58", "8 : 00"), new LevelInfo("$auto.map", "kotec2.mid", "Auto Maul", "4 : 07", "8 : 00")});
    public static final EpisodeInfo pWangBangEp = new EpisodeInfo("Wang Bang", "Multiplayer maps", new LevelInfo[]{new LevelInfo("tank.map", "kotec2.mid", "Heavy Metal (DM only)", "10 : 00", "10 : 00"), new LevelInfo("$dmwoods.map", "kotec2.mid", "Ripper Valley (DM only)", "10 : 00", "10 : 00"), new LevelInfo("$dmshrin.map", "kotec2.mid", "House of Wang (DM only)", "10 : 00", "10 : 00"), new LevelInfo("$rush.map", "kotec2.mid", "Lo Wang Rally (DM only)", "10 : 00", "10 : 00"), new LevelInfo("shotgun.map", "kotec2.mid", "Ruins of the Ronin (CTF)", "10 : 00", "10 : 00"), new LevelInfo("$dmdrop.map", "kotec2.mid", "Killing Fields (CTF)", "10 : 00", "10 : 00")});
    public static final EpisodeInfo pWantonEp = new EpisodeInfo("Wanton Destr", "Twelve levels (Full Version only)", new LevelInfo[]{new LevelInfo("$whirl.map", "yokoha03.mid", "Chinatown", "5 : 30", "10 : 00"), new LevelInfo("$tank.map", "nippon34.mid", "Monastery", "1 : 46", "4 : 00"), new LevelInfo("$boat.map", "execut11.mid", "Trolley Yard", "1 : 56", "4 : 00"), new LevelInfo("$garden.map", "execut11.mid", "Restaurant", "1 : 06", "2 : 00"), new LevelInfo("$outpost.map", "sanai.mid", "Skyscraper", "1 : 23", "3 : 00"), new LevelInfo("$hidtemp.map", "kotec2.mid", "Airplane", "2 : 05", "4 : 10"), new LevelInfo("$plax1.map", "kotec2.mid", "Military Base", "6 : 32", "12 : 00"), new LevelInfo("$bath.map", "yokoha03.mid", "Train", "10 : 00", "10 : 00"), new LevelInfo("$airport.map", "nippon34.mid", "Auto Factory", "2 : 59", "6 : 00"), null, null, null, null, null, null, new LevelInfo("$volcano.map", "kotec2.mid", "Skyline", "9 : 15", "20 : 00"), new LevelInfo("$shore.map", "kotec2.mid", "Redwood Forest", "3 : 58", "8 : 00"), new LevelInfo("$auto.map", "kotec2.mid", "The Docks", "4 : 07", "8 : 00")});
    public static final EpisodeInfo pTwinDragonEp = new EpisodeInfo("Twin Dragon", "Thirteen levels (Full Version only)", new LevelInfo[]{new LevelInfo("$whirl.map", "yokoha03.mid", "Wang's Home", "5 : 30", "10 : 00"), new LevelInfo("$tank.map", "nippon34.mid", "City of Despair", "1 : 46", "4 : 00"), new LevelInfo("$boat.map", "execut11.mid", "Emergency Room", "1 : 56", "4 : 00"), new LevelInfo("$garden.map", "execut11.mid", "Hide and Seek", "1 : 06", "2 : 00"), new LevelInfo("$outpost.map", "sanai.mid", "Warehouse", "1 : 23", "3 : 00"), new LevelInfo("$hidtemp.map", "kotec2.mid", "Military Research Base", "2 : 05", "4 : 10"), new LevelInfo("$plax1.map", "kotec2.mid", "Toxic Waste", "6 : 32", "12 : 00"), new LevelInfo("$bath.map", "yokoha03.mid", "Crazy Train", "10 : 00", "10 : 00"), new LevelInfo("$airport.map", "nippon34.mid", "Fishing Village", "2 : 59", "6 : 00"), new LevelInfo("$refiner.map", "kotoki12.mid", "The Garden", "2 : 40", "5 : 00"), new LevelInfo("$newmine.map", "hoshia02.mid", "The Fortress", "2 : 48", "6 : 00"), null, null, null, null, new LevelInfo("$volcano.map", "kotec2.mid", "The Palace", "9 : 15", "20 : 00"), new LevelInfo("$shore.map", "kotec2.mid", "Prison Camp", "3 : 58", "8 : 00")});
    private static final char[] buffer = new char[256];
    public static int nInterpolation = 2;
    public static final boolean SW_SHAREWARE = false;
    public static Entry boardfilename;
    public static final LastLevelUser[] puser;
    public static final short PlaxBits = 0;
    public static final PlayerStr[] Player;
    public static int screenpeek;
    public static final boolean Global_PLock = false;
    public static int PlayingLevel;
    public static int Level;
    public static int Skill;
    public static boolean QuitFlag;
    public static boolean ExitLevel;
    public static boolean FinishedLevel;
    public static int FinishAnim;
    public static boolean GodMode;
    public static final boolean DebugActorFreeze = false;
    public static final boolean DebugActor = false;
    public static final boolean DebugAnim = false;
    public static final boolean DebugPanel = false;
    public static final boolean DebugSector = false;
    public static final boolean PlayerTrackingMode = false;
    public static final NetInfo pNetInfo;
    public static boolean MessageInputMode;
    public static int PlayClock;
    public static int Kills;
    public static int TotalKillable;
    public static int totalsynctics;
    public static final int RAND_MAX = Short.MAX_VALUE;
    public static final short HelpPage = 0;
    public static final short[] HelpPagePic;
    public static int ChopTics;
    public static int PlaxCeilGlobZadjust;
    public static int PlaxFloorGlobZadjust;
    public static DemoRecorder rec;
    public static boolean DemoRecording;
    public static boolean isDemoRecording;
    public static final GameInfo defGame;
    public static GameInfo currentGame;
    public static final LONGp[] tmp_ptr;

    public static void MapSetAll2D(byte fill) {
        Arrays.fill(Engine.show2dwall.getArray(), fill);
        Arrays.fill(Engine.show2dsprite.getArray(), fill);
        ru.m210projects.Build.Types.Sector[] sectors = Main.boardService.getBoard().getSectors();
        for (int i = 0; i < sectors.length; ++i) {
            ru.m210projects.Build.Types.Sector sec = sectors[i];
            if (sec.getCeilingpicnum() == 342 || sec.getFloorpicnum() == 342) continue;
            Engine.show2dsector.getArray()[i >> 3] = fill;
        }
    }

    public static void LoadLevel(Entry entry) {
        if (!entry.exists()) {
            throw new WarningException("Error opening map file \"" + entry.getName() + "\"");
        }
        Board board = Main.engine.loadboard(entry);
        BuildPos out = board.getPos();
        Game.Player[0].posx = out.x;
        Game.Player[0].posy = out.y;
        Game.Player[0].posz = out.z;
        Game.Player[0].pang = out.ang;
        Game.Player[0].cursectnum = out.sectnum;
    }

    public static void InitGame() throws IOException {
        Entry rtsEntry = Main.game.getCache().getEntry("sw.rts", true);
        if (rtsEntry.exists()) {
            RTSFile rts = new RTSFile(rtsEntry.getName(), rtsEntry::getInputStream);
            if (rts.getSize() != 0) {
                Console.out.println("Using .RTS file:" + rtsEntry.getName());
                Main.RTS_File = rts;
            }
        }
        ResourceHandler.episodeManager.putEpisode(defGame);
        Sector.InitAnim();
        Game.ConsoleInit();
        Sound.SoundStartup();
        Break.SortBreakInfo();
        Engine.parallaxtype = 1;
        Engine.pskyoff[0] = 0;
        Engine.pskybits = 0;
        Renderer renderer = Main.game.getRenderer();
        renderer.setParallaxScale(8192);
        Arrays.fill(Track.Track, null);
        for (int i = 0; i < 8; ++i) {
            Game.Player[i] = new PlayerStr();
            Game.puser[i] = new LastLevelUser();
        }
        Border.BorderSetView(Main.cfg.BorderNum);
    }

    public static void ConsoleInit() {
        Console.out.println("Initializing on-screen display system");
        Console.out.getPrompt().setVersion(Main.game.getTitle(), OsdColor.YELLOW, 10);
        Console.out.registerCommand(new OsdCallback("levelinfo", "", argv -> {
            String name = Main.mUserFlag != Main.UserFlag.UserMap || boardfilename == null ? currentGame.getMapTitle(Level) : boardfilename.getName();
            Console.out.println("LevelInfo:", OsdColor.GREEN);
            Console.out.println("   Mapname: " + name);
            Console.out.println("   Levelnum: " + Level);
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCallback("hitscan", "", argv -> {
            PlayerStr pp = Player[screenpeek];
            int daang = pp.getAnglei();
            int daz = (100 - pp.getHorizi()) * 2000;
            Main.engine.hitscan(pp.posx, pp.posy, pp.posz, pp.cursectnum, EngineUtils.sin(Gameutils.NORM_ANGLE(daang + 512)), EngineUtils.sin(Gameutils.NORM_ANGLE(daang)), daz, Engine.pHitInfo, -1);
            Console.out.println("Sprite : " + Engine.pHitInfo.hitsprite);
            WangSprite hitSpr = Main.boardService.getSprite(Engine.pHitInfo.hitsprite);
            if (hitSpr != null) {
                Console.out.println(hitSpr.toString());
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdValueRange("interpolationtype", "interpolationtype 0: disabled, 1: default, 2: wang enagled, 3: wang disabled", 0.0f, 3.0f){

            @Override
            public float getValue() {
                return nInterpolation;
            }

            @Override
            protected void setCheckedValue(float value) {
                nInterpolation = (int)value;
            }
        });
    }

    public static int Distance(int x1, int y1, int x2, int y2) {
        if ((x2 -= x1) < 0) {
            x2 = -x2;
        }
        if ((y2 -= y1) < 0) {
            y2 = -y2;
        }
        int min = Math.min(x2, y2);
        return x2 + y2 - MyTypes.DIV2(min);
    }

    public static void InitLevelGlobals() {
        ChopTics = 0;
        Draw.dimensionmode = 3;
        Draw.zoom = 768;
        Sprites.wait_active_check_offset = 0;
        PlaxCeilGlobZadjust = PlaxFloorGlobZadjust = Gameutils.Z(500);
        Engine.pskyoff[0] = 0;
        Engine.pskybits = 0;
        FinishedLevel = false;
        Sector.AnimCnt = 0;
        Weapon.left_foot = false;
        screenpeek = Mmulti.myconnectindex;
        Main.gNet.TimeLimitClock = Main.gNet.TimeLimit;
        Sumo.serpwasseen = false;
        Sumo.sumowasseen = false;
        Sumo.zillawasseen = false;
        Sumo.triedplay = false;
        Arrays.fill(Sumo.BossSpriteNum, -1);
    }

    public static void InitNewGame() {
        for (int i = 0; i < 8; ++i) {
            int ready_bak = Game.Player[i].playerreadyflag;
            Player[i].reset();
            Game.Player[i].playerreadyflag = ready_bak;
            puser[i].reset();
        }
    }

    public static void InitLevelGlobals2() {
        Game.InitTimingVars();
        Kills = 0;
        TotalKillable = 0;
        Bunny.Bunny_Count = 0;
    }

    public static boolean InitLevel(Entry levelMap, boolean NewGame2) {
        Sound.Terminate3DSounds();
        Game.InitLevelGlobals();
        if (Main.gDemoScreen.demfile == null) {
            Sound.CDAudio_Stop();
        }
        Game.InitLevelGlobals2();
        if (Level < 0) {
            Level = 0;
        }
        if (Level > 29) {
            Level = 1;
        }
        PlayingLevel = Level;
        if (NewGame2) {
            Game.InitNewGame();
        }
        try {
            Gameutils.clearUser();
            Game.LoadLevel(levelMap);
            ru.m210projects.Build.Types.Sector sec0 = Main.boardService.getSector(0);
            if (sec0 != null && sec0.getExtra() != -1) {
                short s = sec0.getExtra();
                Engine.visibility = s;
                ru.m210projects.Wang.Player.NormalVisibility = s;
                sec0.setExtra(0);
            } else {
                ru.m210projects.Wang.Player.NormalVisibility = Engine.visibility;
            }
            ru.m210projects.Wang.Player.InitAllPlayers(NewGame2);
            Weapon.QueueReset();
            Sprites.PreMapCombineFloors();
            ru.m210projects.Wang.Player.InitMultiPlayerInfo();
            Ninja.InitAllPlayerSprites(NewGame2);
            Game.InitTimingVars();
            Sprites.SpriteSetup();
            Sprites.SpriteSetupPost();
            Light.InitLighting();
            Track.TrackSetup();
            Ninja.PlayerPanelSetup();
            if (!Sector.SectorSetup()) {
                return false;
            }
            JSector.JS_InitMirrors();
            JSector.JS_InitLockouts();
            JSector.JS_ToggleLockouts();
            Track.PlaceSectorObjectsOnTracks();
            Track.PlaceActorsOnTracks();
            Track.PostSetupSectorObject();
            Rooms.SetupMirrorTiles();
            return true;
        }
        catch (Exception e) {
            Console.out.println("Load map exception: " + e);
            if (e.getMessage() != null) {
                Main.game.GameMessage("Load map exception:\r" + e.getMessage());
            } else {
                Main.game.GameMessage("Can't load the map " + levelMap);
            }
            return false;
        }
    }

    public static void TerminateLevel() {
        ListNode<Sprite> node;
        int pnum;
        System.err.println("TerminateLevel");
        Arrays.fill(Track.Track, null);
        Sound.StopFX();
        Sound.Terminate3DSounds();
        for (int stat = 21; stat < 21 + Mmulti.numplayers; ++stat) {
            pnum = stat - 21;
            for (node = Main.boardService.getStatNode(stat); node != null; node = node.getNext()) {
                int i = node.getIndex();
                USER u = Gameutils.getUser(i);
                if (u == null) continue;
                puser[pnum].copy(u);
            }
        }
        for (int stat = 0; stat < 1024; ++stat) {
            node = Main.boardService.getStatNode(stat);
            while (node != null) {
                ListNode<Sprite> nexti = node.getNext();
                Sprites.KillSprite(node.getIndex());
                node = nexti;
            }
        }
        Sector.clearSecUser();
        pnum = Mmulti.connecthead;
        while (pnum != -1) {
            PlayerStr pp = Player[pnum];
            Panel.pClearSpriteList(pp);
            pp.DoPlayerAction = null;
            pp.PlayerSprite = -1;
            pp.PlayerUnderSprite = -1;
            Arrays.fill(pp.HasKey, (byte)0);
            pp.CurWpn = null;
            Arrays.fill(pp.Wpn, null);
            Arrays.fill(pp.InventorySprite, null);
            Arrays.fill(pp.InventoryTics, (short)0);
            pp.Killer = -1;
            List.Init(pp.PanelSpriteList);
            pnum = Mmulti.connectpoint2[pnum];
        }
        JSector.JS_UnInitLockouts();
    }

    public static void InitPlayerGameSettings() {
        if (Main.game.nNetMode == BuildGame.NetMode.Single) {
            Game.Player[Mmulti.myconnectindex].Flags = Main.cfg.AutoAim ? (Game.Player[Mmulti.myconnectindex].Flags |= Gameutils.PF_AUTO_AIM) : (Game.Player[Mmulti.myconnectindex].Flags &= ~Gameutils.PF_AUTO_AIM);
        }
        Game.Player[Mmulti.myconnectindex].Flags = Main.cfg.AutoRun ? (Game.Player[Mmulti.myconnectindex].Flags |= Gameutils.PF_LOCK_RUN) : (Game.Player[Mmulti.myconnectindex].Flags &= ~Gameutils.PF_LOCK_RUN);
    }

    public static void InitTimingVars() {
        PlayClock = 0;
        totalsynctics = 0;
        Main.engine.srand(17);
        Main.game.pNet.ResetTimers();
        Sprites.MoveSkip8 = 2;
        Sprites.MoveSkip2 = false;
        Sprites.MoveSkip4 = 1;
        Main.gNet.MoveThingsCount = 0;
    }

    public static char[] getMapName(int num) {
        Arrays.fill(buffer, '\u0000');
        if (Main.mUserFlag != Main.UserFlag.UserMap || boardfilename == null) {
            String name = currentGame.getMapTitle(num);
            if (name != null) {
                name.getChars(0, Math.min(name.length(), buffer.length), buffer, 0);
            }
        } else {
            int size = boardfilename.getName().length();
            System.arraycopy(boardfilename.getName().toCharArray(), 0, buffer, 0, Math.min(size, buffer.length));
        }
        return buffer;
    }

    public static boolean isOriginal() {
        return Main.game.isCurrentScreen(Main.gDemoScreen) && Main.gDemoScreen.demfile != null && Main.gDemoScreen.demfile.nVersion == 1;
    }

    public static int swGetAddon() {
        int addon = 0;
        if (Game.currentGame.episode.length > 1 && Game.currentGame.episode[1] == pWantonEp) {
            addon = 1;
        }
        if (Game.currentGame.episode.length > 1 && Game.currentGame.episode[1] == pTwinDragonEp) {
            addon = 2;
        }
        return addon;
    }

    static {
        puser = new LastLevelUser[8];
        Player = new PlayerStr[8];
        FinishAnim = 0;
        GodMode = false;
        pNetInfo = new NetInfo();
        MessageInputMode = false;
        HelpPagePic = new short[]{5115, 5116, 5117};
        DemoRecording = false;
        isDemoRecording = false;
        currentGame = defGame = new GameInfo("Default", new EpisodeEntry.Addon(Main.game.cache.getGameDirectory(), Main.game.cache.getGameDirectory().getEntry(Main.game.mainGrp)), new EpisodeInfo[]{pSharewareEp, pOriginalEp, pWangBangEp}){

            @Override
            public LevelInfo getLevel(int num) {
                if (num < 1) {
                    return null;
                }
                if (num < 5) {
                    return this.episode[0] != null ? this.episode[0].gMapInfo[num - 1] : null;
                }
                if (num < 23) {
                    return this.episode[1] != null ? this.episode[1].gMapInfo[num - 5] : null;
                }
                return this.episode[2] != null ? this.episode[2].gMapInfo[num - 23] : null;
            }

            @Override
            public int getNumEpisode(int level) {
                if (level < 5) {
                    return 0;
                }
                if (level < 23) {
                    return 1;
                }
                return 2;
            }

            @Override
            public int getNumLevel(int level) {
                if (level < 5) {
                    return level - 1;
                }
                if (level < 23) {
                    return level - 5;
                }
                return level - 23;
            }
        };
        tmp_ptr = new LONGp[]{new LONGp(), new LONGp(), new LONGp(), new LONGp(), new LONGp(), new LONGp(), new LONGp(), new LONGp()};
    }
}

