/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Break;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Weapon;

public class JWeapon {
    private static final Animator BloodSprayFall = new Animator(JWeapon::BloodSprayFall);
    public static final Animator DoRadiationCloud = new Animator(JWeapon::DoRadiationCloud);
    public static final Animator DoChemBomb = new Animator(JWeapon::DoChemBomb);
    public static final Animator DoCaltrops = new Animator(JWeapon::DoCaltrops);
    public static final Animator DoCaltropsStick = new Animator(JWeapon::DoCaltropsStick);
    public static final Animator DoFlag = new Animator(JWeapon::DoFlag);
    public static final Animator DoCarryFlag = new Animator(JWeapon::DoCarryFlag);
    public static final Animator DoCarryFlagNoDet = new Animator(JWeapon::DoCarryFlagNoDet);
    public static final Animator DoPhosphorus = new Animator(JWeapon::DoPhosphorus);
    public static final Animator DoBloodSpray = new Animator(JWeapon::DoBloodSpray);
    public static final Animator DoWallBloodDrip = new Animator(JWeapon::DoWallBloodDrip);
    public static final int CHEMTICS = Gameutils.SEC(40);
    public static final int FLAG_DETONATE_STATE = 99;
    public static final int GOREDrip = 1562;
    public static final int BLOODSPRAY_RATE = 20;
    public static final State[] s_BloodSpray = new State[]{new State(1562, 20, BloodSprayFall), new State(1563, 20, BloodSprayFall), new State(1564, 20, BloodSprayFall), new State(1565, 20, BloodSprayFall), new State(1565, 100, Weapon.DoSuicide)};
    public static final int EXP_RATE = 2;
    public static final State[] s_PhosphorExp = new State[]{new State(3100, 2, null), new State(3101, 2, null), new State(3102, 2, null), new State(3103, 2, null), new State(3104, 2, null), new State(3105, 2, null), new State(3106, 2, null), new State(3107, 2, null), new State(3108, 2, null), new State(3109, 2, null), new State(3110, 2, null), new State(3111, 2, null), new State(3112, 2, null), new State(3113, 2, null), new State(3114, 2, null), new State(3115, 2, null), new State(3116, 2, null), new State(3117, 2, null), new State(3118, 2, null), new State(3119, 2, null), new State(3120, 100, Weapon.DoSuicide)};
    public static final int MUSHROOM_RATE = 25;
    public static final State[] s_NukeMushroom = new State[]{new State(3280, 25, null), new State(3281, 25, null), new State(3282, 25, null), new State(3283, 25, null), new State(3284, 25, null), new State(3285, 25, null), new State(3286, 25, null), new State(3287, 25, null), new State(3288, 25, null), new State(3289, 25, null), new State(3290, 25, null), new State(3291, 25, null), new State(3292, 25, null), new State(3293, 25, null), new State(3294, 25, null), new State(3295, 25, null), new State(3296, 25, null), new State(3297, 25, null), new State(3298, 25, null), new State(3299, 100, Weapon.DoSuicide)};
    public static final int RADIATION_RATE = 16;
    public static final State[] s_RadiationCloud = new State[]{new State(3258, 16, DoRadiationCloud), new State(3259, 16, DoRadiationCloud), new State(3260, 16, DoRadiationCloud), new State(3261, 16, DoRadiationCloud), new State(3262, 16, DoRadiationCloud), new State(3263, 16, DoRadiationCloud), new State(3264, 16, DoRadiationCloud), new State(3265, 16, DoRadiationCloud), new State(3266, 16, DoRadiationCloud), new State(3267, 16, DoRadiationCloud), new State(3268, 16, DoRadiationCloud), new State(3269, 16, DoRadiationCloud), new State(3270, 16, DoRadiationCloud), new State(3271, 16, DoRadiationCloud), new State(3272, 16, DoRadiationCloud), new State(3273, 16, DoRadiationCloud), new State(3274, 16, DoRadiationCloud), new State(3275, 16, DoRadiationCloud), new State(3276, 16, DoRadiationCloud), new State(3277, 100, Weapon.DoSuicide)};
    public static final int CHEMBOMB_FRAMES = 1;
    public static final int CHEMBOMB_R0 = 3038;
    public static final int CHEMBOMB_R1 = 3039;
    public static final int CHEMBOMB_R2 = 3040;
    public static final int CHEMBOMB_R3 = 3041;
    public static final int CHEMBOMB_R4 = 3042;
    public static final int CHEMBOMB = 3038;
    public static final int CHEMBOMB_RATE = 8;
    public static final State[] s_ChemBomb = new State[]{new State(3038, 8, DoChemBomb), new State(3039, 8, DoChemBomb), new State(3040, 8, DoChemBomb), new State(3041, 8, DoChemBomb), new State(3042, 8, DoChemBomb)};
    public static final int CALTROPS_R0 = 2217;
    public static final int CALTROPS_RATE = 8;
    public static final State[] s_Caltrops = new State[]{new State(2217, 8, DoCaltrops), new State(2218, 8, DoCaltrops), new State(2219, 8, DoCaltrops)};
    public static final State[] s_CaltropsStick = new State[]{new State(2219, 8, DoCaltropsStick).setNext()};
    public static final int FLAG = 2520;
    public static final int FLAG_RATE = 16;
    public static final State[] s_CarryFlag = new State[]{new State(2520, 16, DoCarryFlag), new State(2521, 16, DoCarryFlag), new State(2522, 16, DoCarryFlag)};
    public static final State[] s_CarryFlagNoDet = new State[]{new State(2520, 16, DoCarryFlagNoDet), new State(2521, 16, DoCarryFlagNoDet), new State(2522, 16, DoCarryFlagNoDet)};
    public static final State[] s_Flag = new State[]{new State(2520, 16, DoFlag), new State(2521, 16, DoFlag), new State(2522, 16, DoFlag)};
    public static final int PHOSPHORUS_RATE = 8;
    public static final State[] s_Phosphorus = new State[]{new State(1397, 8, DoPhosphorus), new State(1398, 8, DoPhosphorus)};
    public static final int CHUNK1 = 1685;
    public static final State[] s_BloodSprayChunk = new State[]{new State(1685, 8, DoBloodSpray), new State(1686, 8, DoBloodSpray), new State(1687, 8, DoBloodSpray), new State(1688, 8, DoBloodSpray), new State(1689, 8, DoBloodSpray), new State(1690, 8, DoBloodSpray)};
    public static final int DRIP = 1566;
    public static final State[] s_BloodSprayDrip = new State[]{new State(1566, 8, DoWallBloodDrip), new State(1567, 8, DoWallBloodDrip), new State(1568, 8, DoWallBloodDrip)};

    public static void InitJWeaponStates() {
        State.InitState(s_BloodSpray);
        State.InitState(s_PhosphorExp);
        State.InitState(s_NukeMushroom);
        State.InitState(s_RadiationCloud);
        State.InitState(s_ChemBomb);
        State.InitState(s_Caltrops);
        State.InitState(s_CaltropsStick);
        State.InitState(s_CarryFlag);
        State.InitState(s_CarryFlagNoDet);
        State.InitState(s_Flag);
        State.InitState(s_Phosphorus);
        State.InitState(s_BloodSprayChunk);
        State.InitState(s_BloodSprayDrip);
    }

    public static void DoWallBloodDrip(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (u.sz != u.sy) {
            if (sp.getZ() > u.sy && sp.getZ() < u.sz) {
                sp.setZvel(sp.getZvel() + 300);
                sp.setZ(sp.getZ() + sp.getZvel());
            } else {
                sp.setZvel(300 + Gameutils.RANDOM_RANGE(2300) >> 1);
                sp.setZ(sp.getZ() + sp.getZvel());
            }
        } else {
            sp.setZvel(300 + Gameutils.RANDOM_RANGE(2300) >> 1);
            sp.setZ(sp.getZ() + sp.getZvel());
        }
        if (sp.getZ() >= u.loz) {
            sp.setZ(u.loz);
            JWeapon.SpawnFloorSplash(SpriteNum);
            Sprites.KillSprite(SpriteNum);
        }
    }

    public static void SpawnMidSplash(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int newsp = Sprites.SpawnSprite(4, 1562, Weapon.s_GoreSplash[0], sp.getSectnum(), sp.getX(), sp.getY(), Gameutils.SPRITEp_MID(sp), sp.getAng(), 0);
        WangSprite np = Main.boardService.getSprite(newsp);
        USER nu = Gameutils.getUser(newsp);
        if (np == null || nu == null) {
            return;
        }
        np.setShade(-12);
        np.setXrepeat(70 - Gameutils.RANDOM_RANGE(20));
        np.setYrepeat(70 - Gameutils.RANDOM_RANGE(20));
        nu.ox = u.ox;
        nu.oy = u.oy;
        nu.oz = u.oz;
        np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        np.setCstat(np.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        if (Gameutils.RANDOM_P2(1024) < 512) {
            np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_XFLIP);
        }
        nu.xchange = 0;
        nu.ychange = 0;
        nu.zchange = 0;
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            nu.Flags |= Gameutils.SPR_UNDERWATER;
        }
    }

    public static void SpawnFloorSplash(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int newsp = Sprites.SpawnSprite(4, 1562, Weapon.s_GoreFloorSplash[0], sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), 0);
        WangSprite np = Main.boardService.getSprite(newsp);
        USER nu = Gameutils.getUser(newsp);
        if (np == null || nu == null) {
            return;
        }
        np.setShade(-12);
        np.setXrepeat(70 - Gameutils.RANDOM_RANGE(20));
        np.setYrepeat(70 - Gameutils.RANDOM_RANGE(20));
        nu.ox = u.ox;
        nu.oy = u.oy;
        nu.oz = u.oz;
        np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        np.setCstat(np.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        if (Gameutils.RANDOM_P2(1024) < 512) {
            np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_XFLIP);
        }
        nu.xchange = 0;
        nu.ychange = 0;
        nu.zchange = 0;
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            nu.Flags |= Gameutils.SPR_UNDERWATER;
        }
    }

    public static void DoBloodSpray(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        USER u = Gameutils.getUser(Weapon2);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            Weapon.ScaleSpriteVector(Weapon2, 50000);
        }
        u.Counter += 20;
        u.zchange += u.Counter;
        if (sp.getXvel() <= 2) {
            sp.setZ(sp.getZ() + (u.zchange >> 1));
            Main.engine.getzsofslope(sp.getSectnum(), sp.getX(), sp.getY(), Rooms.fz, Rooms.cz);
            if (sp.getZ() >= Rooms.fz.get()) {
                sp.setZ(Rooms.fz.get());
                JWeapon.SpawnFloorSplash(Weapon2);
                Sprites.KillSprite(Weapon2);
                return;
            }
        } else {
            u.moveSpriteReturn = Sprites.move_missile(Weapon2, u.xchange, u.ychange, u.zchange, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 6);
        }
        Weapon.MissileHitDiveArea(Weapon2);
        if (u.moveSpriteReturn != 0) {
            switch (MyTypes.DTEST(u.moveSpriteReturn, -536870912)) {
                case 0x20000000: {
                    Sprites.KillSprite(Weapon2);
                    return;
                }
                case -1073741824: {
                    int hitsprite = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
                    WangSprite hsp = Main.boardService.getSprite(hitsprite);
                    if (hsp == null) break;
                    if (MyTypes.TEST(hsp.getCstat(), Gameutils.CSTAT_SPRITE_WALL)) {
                        int wall_ang = Gameutils.NORM_ANGLE(hsp.getAng());
                        JWeapon.SpawnMidSplash(Weapon2);
                        Weapon.QueueWallBlood(Weapon2, hsp.getAng());
                        Weapon.WallBounce(Weapon2, wall_ang);
                        Weapon.ScaleSpriteVector(Weapon2, 32000);
                        break;
                    }
                    u.ychange = 0;
                    u.xchange = 0;
                    JWeapon.SpawnMidSplash(Weapon2);
                    Weapon.QueueWallBlood(Weapon2, hsp.getAng());
                    Sprites.KillSprite(Weapon2);
                    return;
                }
                case -2147483648: {
                    int hitwall = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
                    Wall wph = Main.boardService.getWall(hitwall);
                    if (wph == null) break;
                    if (wph.getLotag() == 307) {
                        Break.HitBreakWall(hitwall, sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), u.ID);
                        u.moveSpriteReturn = 0;
                        break;
                    }
                    Wall nw = wph.getWall2();
                    int wall_ang = Gameutils.NORM_ANGLE(EngineUtils.getAngle(nw.getX() - wph.getX(), nw.getY() - wph.getY()) + 512);
                    JWeapon.SpawnMidSplash(Weapon2);
                    int wb = Weapon.QueueWallBlood(Weapon2, Gameutils.NORM_ANGLE(wall_ang + 1024));
                    if (wb < 0) {
                        Sprites.KillSprite(Weapon2);
                        return;
                    }
                    WangSprite wbSpr = Main.boardService.getSprite(wb);
                    if (wbSpr == null || Rooms.FAF_Sector(wbSpr.getSectnum()) || Gameutils.FAF_ConnectArea(wbSpr.getSectnum())) {
                        Sprites.KillSprite(Weapon2);
                        return;
                    }
                    u.ychange = 0;
                    u.xchange = 0;
                    sp.setXvel(0);
                    sp.setYvel(0);
                    int siz = 70 - Gameutils.RANDOM_RANGE(25);
                    sp.setXrepeat(siz);
                    sp.setYrepeat(siz);
                    sp.setX(wbSpr.getX());
                    sp.setY(wbSpr.getY());
                    if (wbSpr.getYvel() >= 0) {
                        short wallnum = wbSpr.getYvel();
                        Wall wal = Main.boardService.getWall(wallnum);
                        if (wal != null && wal.getNextsector() >= 0) {
                            Main.engine.getzsofslope(wal.getNextsector(), sp.getX(), sp.getY(), Rooms.fz, Rooms.cz);
                            u.sy = Rooms.cz.get();
                            u.sz = Rooms.fz.get();
                        } else {
                            u.sy = u.sz;
                        }
                    }
                    sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
                    Sprites.ChangeState(Weapon2, s_BloodSprayDrip[0]);
                    break;
                }
                case 0x40000000: {
                    if (sp.getZ() > MyTypes.DIV2(u.hiz + u.loz)) {
                        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        Sect_User su = Sector.getSectUser(sp.getSectnum());
                        if (u.lo_sectp != -1 && su != null && su.depth != 0) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        u.ychange = 0;
                        u.xchange = 0;
                        JWeapon.SpawnFloorSplash(Weapon2);
                        Sprites.KillSprite(Weapon2);
                        return;
                    }
                    u.zchange = -u.zchange;
                    Weapon.ScaleSpriteVector(Weapon2, 32000);
                }
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE | Gameutils.SPR_UNDERWATER)) {
            int newsp = Sprites.SpawnSprite(4, 1562, s_BloodSpray[0], sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), 100);
            WangSprite np = Main.boardService.getSprite(newsp);
            USER nu = Gameutils.getUser(newsp);
            if (np == null || nu == null) {
                return;
            }
            Sprites.SetOwner(Weapon2, newsp);
            np.setShade(-12);
            np.setXrepeat(40 - Gameutils.RANDOM_RANGE(30));
            np.setYrepeat(40 - Gameutils.RANDOM_RANGE(30));
            nu.ox = u.ox;
            nu.oy = u.oy;
            nu.oz = u.oz;
            np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
            np.setCstat(np.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
            if (Gameutils.RANDOM_P2(1024) < 512) {
                np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_XFLIP);
            }
            if (Gameutils.RANDOM_P2(1024) < 512) {
                np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_YFLIP);
            }
            nu.xchange = u.xchange;
            nu.ychange = u.ychange;
            nu.zchange = u.zchange;
            Weapon.ScaleSpriteVector(newsp, 20000);
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                nu.Flags |= Gameutils.SPR_UNDERWATER;
            }
        }
    }

    public static void DoPhosphorus(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        USER u = Gameutils.getUser(Weapon2);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            Weapon.ScaleSpriteVector(Weapon2, 50000);
        }
        u.Counter += 40;
        u.zchange += u.Counter;
        u.moveSpriteReturn = Sprites.move_missile(Weapon2, u.xchange, u.ychange, u.zchange, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 12);
        Weapon.MissileHitDiveArea(Weapon2);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER) && Gameutils.RANDOM_P2(16384) >> 4 < 256) {
            Weapon.SpawnBubble(Weapon2);
        }
        if (u.moveSpriteReturn != 0) {
            switch (MyTypes.DTEST(u.moveSpriteReturn, -536870912)) {
                case 0x20000000: {
                    Sprites.KillSprite(Weapon2);
                    return;
                }
                case -1073741824: {
                    int hitsprite = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
                    WangSprite hsp = Main.boardService.getSprite(hitsprite);
                    if (hsp != null && MyTypes.TEST(hsp.getCstat(), Gameutils.CSTAT_SPRITE_WALL)) {
                        int wall_ang = Gameutils.NORM_ANGLE(hsp.getAng());
                        Weapon.WallBounce(Weapon2, wall_ang);
                        Weapon.ScaleSpriteVector(Weapon2, 32000);
                        break;
                    }
                    if (hsp != null && MyTypes.TEST(hsp.getExtra(), Gameutils.SPRX_BURNABLE)) {
                        USER hu = Gameutils.getUser(hitsprite);
                        if (hu == null) {
                            Sprites.SpawnUser(hitsprite, hsp.getPicnum(), null);
                        }
                        Weapon.SpawnFireballExp(Weapon2);
                        Weapon.SpawnFireballFlames(Weapon2, hitsprite);
                        Weapon.DoFlamesDamageTest(Weapon2);
                    }
                    u.ychange = 0;
                    u.xchange = 0;
                    Sprites.KillSprite(Weapon2);
                    return;
                }
                case -2147483648: {
                    int hitwall = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
                    Wall wph = Main.boardService.getWall(hitwall);
                    if (wph == null) break;
                    if (wph.getLotag() == 307) {
                        Break.HitBreakWall(hitwall, sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), u.ID);
                        u.moveSpriteReturn = 0;
                        break;
                    }
                    Wall nw = wph.getWall2();
                    int wall_ang = Gameutils.NORM_ANGLE(EngineUtils.getAngle(nw.getX() - wph.getX(), nw.getY() - wph.getY()) + 512);
                    Weapon.WallBounce(Weapon2, wall_ang);
                    Weapon.ScaleSpriteVector(Weapon2, 32000);
                    break;
                }
                case 0x40000000: {
                    int hitwall;
                    if (Weapon.SlopeBounce(Weapon2, Game.tmp_ptr[0])) {
                        int n = hitwall = Game.tmp_ptr[0].value != 0 ? 1 : 0;
                        if (hitwall != 0) {
                            Weapon.ScaleSpriteVector(Weapon2, 28000);
                            u.moveSpriteReturn = 0;
                            u.Counter = 0;
                            break;
                        }
                        if (sp.getZ() > MyTypes.DIV2(u.hiz + u.loz)) {
                            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                                u.Flags |= Gameutils.SPR_BOUNCE;
                                Weapon.ScaleSpriteVector(Weapon2, 32000);
                                u.zchange /= 6;
                                u.moveSpriteReturn = 0;
                                u.Counter = 0;
                                break;
                            }
                            u.ychange = 0;
                            u.xchange = 0;
                            Weapon.SpawnFireballExp(Weapon2);
                            Sprites.KillSprite(Weapon2);
                            return;
                        }
                        Weapon.ScaleSpriteVector(Weapon2, 32000);
                        break;
                    }
                    if (sp.getZ() > MyTypes.DIV2(u.hiz + u.loz)) {
                        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        Sect_User su = Sector.getSectUser(sp.getSectnum());
                        if (u.lo_sectp != -1 && su != null && su.depth != 0) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                            u.moveSpriteReturn = 0;
                            u.Counter = 0;
                            u.zchange = -u.zchange;
                            Weapon.ScaleSpriteVector(Weapon2, 32000);
                            u.zchange /= 6;
                            break;
                        }
                        u.ychange = 0;
                        u.xchange = 0;
                        Weapon.SpawnFireballExp(Weapon2);
                        Sprites.KillSprite(Weapon2);
                        return;
                    }
                    u.zchange = -u.zchange;
                    Weapon.ScaleSpriteVector(Weapon2, 32000);
                }
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE | Gameutils.SPR_UNDERWATER) && !MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
            int newsp = Sprites.SpawnSprite(6, 1748, s_PhosphorExp[0], sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), 100);
            WangSprite np = Main.boardService.getSprite(newsp);
            USER nu = Gameutils.getUser(newsp);
            if (np == null || nu == null) {
                return;
            }
            np.setHitag(9999);
            Sprites.SetOwner(Weapon2, newsp);
            np.setShade(-40);
            np.setXrepeat(12 + Gameutils.RANDOM_RANGE(10));
            np.setYrepeat(12 + Gameutils.RANDOM_RANGE(10));
            nu.ox = u.ox;
            nu.oy = u.oy;
            nu.oz = u.oz;
            np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
            np.setCstat(np.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
            if (Gameutils.RANDOM_P2(1024) < 512) {
                np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_XFLIP);
            }
            if (Gameutils.RANDOM_P2(1024) < 512) {
                np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_YFLIP);
            }
            nu.xchange = u.xchange;
            nu.ychange = u.ychange;
            nu.zchange = u.zchange;
            nu.spal = (byte)19;
            np.setPal(nu.spal);
            Weapon.ScaleSpriteVector(newsp, 20000);
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                nu.Flags |= Gameutils.SPR_UNDERWATER;
            }
        }
    }

    public static void DoChemBomb(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        USER u = Gameutils.getUser(Weapon2);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            Weapon.ScaleSpriteVector(Weapon2, 50000);
        }
        u.Counter += 20;
        u.zchange += u.Counter;
        u.moveSpriteReturn = Sprites.move_missile(Weapon2, u.xchange, u.ychange, u.zchange, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.MissileHitDiveArea(Weapon2);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER) && Gameutils.RANDOM_P2(16384) >> 4 < 256) {
            Weapon.SpawnBubble(Weapon2);
        }
        if (u.moveSpriteReturn != 0) {
            switch (MyTypes.DTEST(u.moveSpriteReturn, -536870912)) {
                case 0x20000000: {
                    Sprites.KillSprite(Weapon2);
                    return;
                }
                case -1073741824: {
                    int hitsprite;
                    WangSprite hsp;
                    if (!MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                        Sound.PlaySound(277, sp, 8);
                    }
                    if ((hsp = Main.boardService.getSprite(hitsprite = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn))) == null) break;
                    if (MyTypes.TEST(hsp.getCstat(), Gameutils.CSTAT_SPRITE_WALL)) {
                        int wall_ang = Gameutils.NORM_ANGLE(hsp.getAng());
                        Weapon.WallBounce(Weapon2, wall_ang);
                        Weapon.ScaleSpriteVector(Weapon2, 32000);
                        break;
                    }
                    if (u.WaitTics == CHEMTICS && !MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                        Sound.PlaySound(283, sp, 12);
                        VOC3D voc = Sound.PlaySound(276, sp, 12);
                        Sound.Set3DSoundOwner(Weapon2, voc);
                    }
                    u.ychange = 0;
                    u.xchange = 0;
                    u.WaitTics -= 12;
                    if (u.WaitTics <= 0) {
                        Sprites.KillSprite(Weapon2);
                    }
                    return;
                }
                case -2147483648: {
                    int hitwall = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
                    Wall wph = Main.boardService.getWall(hitwall);
                    if (wph == null) break;
                    if (wph.getLotag() == 307) {
                        Break.HitBreakWall(hitwall, sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), u.ID);
                        u.moveSpriteReturn = 0;
                        break;
                    }
                    if (!MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                        Sound.PlaySound(277, sp, 8);
                    }
                    Wall nw = wph.getWall2();
                    int wall_ang = Gameutils.NORM_ANGLE(EngineUtils.getAngle(nw.getX() - wph.getX(), nw.getY() - wph.getY()) + 512);
                    Weapon.WallBounce(Weapon2, wall_ang);
                    Weapon.ScaleSpriteVector(Weapon2, 32000);
                    break;
                }
                case 0x40000000: {
                    int hitwall;
                    if (Weapon.SlopeBounce(Weapon2, Game.tmp_ptr[0])) {
                        int n = hitwall = Game.tmp_ptr[0].value != 0 ? 1 : 0;
                        if (hitwall != 0) {
                            Weapon.ScaleSpriteVector(Weapon2, 28000);
                            u.moveSpriteReturn = 0;
                            u.Counter = 0;
                            break;
                        }
                        if (sp.getZ() > MyTypes.DIV2(u.hiz + u.loz)) {
                            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                                if (!MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                                    Sound.PlaySound(277, sp, 8);
                                }
                                u.Flags |= Gameutils.SPR_BOUNCE;
                                Weapon.ScaleSpriteVector(Weapon2, 32000);
                                u.zchange /= 6;
                                u.moveSpriteReturn = 0;
                                u.Counter = 0;
                                break;
                            }
                            if (u.WaitTics == CHEMTICS && !MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                                Sound.PlaySound(283, sp, 12);
                                VOC3D voc = Sound.PlaySound(276, sp, 12);
                                Sound.Set3DSoundOwner(Weapon2, voc);
                            }
                            JWeapon.SpawnRadiationCloud(Weapon2);
                            u.ychange = 0;
                            u.xchange = 0;
                            u.WaitTics -= 12;
                            if (u.WaitTics <= 0) {
                                Sprites.KillSprite(Weapon2);
                            }
                            return;
                        }
                        Weapon.ScaleSpriteVector(Weapon2, 32000);
                        break;
                    }
                    if (sp.getZ() > MyTypes.DIV2(u.hiz + u.loz)) {
                        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        Sect_User su = Sector.getSectUser(sp.getSectnum());
                        if (u.lo_sectp != -1 && su != null && su.depth != 0) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                            if (!MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                                Sound.PlaySound(277, sp, 8);
                            }
                            u.Flags |= Gameutils.SPR_BOUNCE;
                            u.moveSpriteReturn = 0;
                            u.Counter = 0;
                            u.zchange = -u.zchange;
                            Weapon.ScaleSpriteVector(Weapon2, 32000);
                            u.zchange /= 6;
                            break;
                        }
                        if (u.WaitTics == CHEMTICS && !MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                            Sound.PlaySound(283, sp, 12);
                            VOC3D voc = Sound.PlaySound(276, sp, 12);
                            Sound.Set3DSoundOwner(Weapon2, voc);
                        }
                        JWeapon.SpawnRadiationCloud(Weapon2);
                        u.ychange = 0;
                        u.xchange = 0;
                        u.WaitTics -= 12;
                        if (u.WaitTics <= 0) {
                            Sprites.KillSprite(Weapon2);
                        }
                        return;
                    }
                    u.zchange = -u.zchange;
                    Weapon.ScaleSpriteVector(Weapon2, 32000);
                }
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE | Gameutils.SPR_UNDERWATER) && !MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE)) {
            int newsp = Sprites.SpawnSprite(4, 1748, Weapon.s_Puff[0], sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), 100);
            WangSprite np = Main.boardService.getSprite(newsp);
            USER nu = Gameutils.getUser(newsp);
            if (np == null || nu == null) {
                return;
            }
            Sprites.SetOwner(Weapon2, newsp);
            np.setShade(-40);
            np.setXrepeat(40);
            np.setYrepeat(40);
            nu.ox = u.ox;
            nu.oy = u.oy;
            nu.oz = u.oz;
            np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
            np.setCstat(np.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
            nu.xchange = u.xchange;
            nu.ychange = u.ychange;
            nu.zchange = u.zchange;
            nu.spal = (byte)22;
            np.setPal(nu.spal);
            Weapon.ScaleSpriteVector(newsp, 20000);
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                nu.Flags |= Gameutils.SPR_UNDERWATER;
            }
        }
    }

    public static void DoCaltropsStick(int Weapon2) {
        USER u = Gameutils.getUser(Weapon2);
        if (u != null) {
            int n = u.Counter = u.Counter == 0 ? 1 : 0;
            if (u.Counter != 0) {
                Weapon.DoFlamesDamageTest(Weapon2);
            }
        }
    }

    public static void DoCaltrops(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        USER u = Gameutils.getUser(Weapon2);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            Weapon.ScaleSpriteVector(Weapon2, 50000);
            u.Counter += 20;
        } else {
            u.Counter += 70;
        }
        u.zchange += u.Counter;
        u.moveSpriteReturn = Sprites.move_missile(Weapon2, u.xchange, u.ychange, u.zchange, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.MissileHitDiveArea(Weapon2);
        if (u.moveSpriteReturn != 0) {
            switch (MyTypes.DTEST(u.moveSpriteReturn, -536870912)) {
                case 0x20000000: {
                    Sprites.KillSprite(Weapon2);
                    return;
                }
                case -1073741824: {
                    Sound.PlaySound(288, sp, 8);
                    int hitsprite = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
                    WangSprite hsp = Main.boardService.getSprite(hitsprite);
                    if (hsp != null && MyTypes.TEST(hsp.getCstat(), Gameutils.CSTAT_SPRITE_WALL)) {
                        int wall_ang = Gameutils.NORM_ANGLE(hsp.getAng());
                        Weapon.WallBounce(Weapon2, wall_ang);
                        Weapon.ScaleSpriteVector(Weapon2, 10000);
                        break;
                    }
                    u.ychange = 0;
                    u.xchange = 0;
                    break;
                }
                case -2147483648: {
                    int hitwall = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
                    Wall wph = Main.boardService.getWall(hitwall);
                    if (wph == null) {
                        return;
                    }
                    if (wph.getLotag() == 307) {
                        Break.HitBreakWall(hitwall, sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), u.ID);
                        u.moveSpriteReturn = 0;
                        break;
                    }
                    Sound.PlaySound(288, sp, 8);
                    Wall nw = wph.getWall2();
                    int wall_ang = Gameutils.NORM_ANGLE(EngineUtils.getAngle(nw.getX() - wph.getX(), nw.getY() - wph.getY()) + 512);
                    Weapon.WallBounce(Weapon2, wall_ang);
                    Weapon.ScaleSpriteVector(Weapon2, 1000);
                    break;
                }
                case 0x40000000: {
                    if (Weapon.SlopeBounce(Weapon2, Game.tmp_ptr[0])) {
                        boolean hitwall;
                        boolean bl = hitwall = Game.tmp_ptr[0].value != 0;
                        if (hitwall) {
                            Weapon.ScaleSpriteVector(Weapon2, 1000);
                            u.moveSpriteReturn = 0;
                            u.Counter = 0;
                            break;
                        }
                        if (sp.getZ() > MyTypes.DIV2(u.hiz + u.loz)) {
                            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                                Sound.PlaySound(288, sp, 8);
                                u.Flags |= Gameutils.SPR_BOUNCE;
                                Weapon.ScaleSpriteVector(Weapon2, 1000);
                                u.moveSpriteReturn = 0;
                                u.Counter = 0;
                                break;
                            }
                            u.ychange = 0;
                            u.xchange = 0;
                            sp.setExtra(sp.getExtra() | Gameutils.SPRX_BREAKABLE);
                            sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_BREAKABLE);
                            Sprites.ChangeState(Weapon2, s_CaltropsStick[0]);
                            return;
                        }
                        Weapon.ScaleSpriteVector(Weapon2, 1000);
                        break;
                    }
                    if (sp.getZ() > MyTypes.DIV2(u.hiz + u.loz)) {
                        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        Sect_User su = Sector.getSectUser(sp.getSectnum());
                        if (u.lo_sectp != -1 && su != null && su.depth != 0) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                            Sound.PlaySound(288, sp, 8);
                            u.Flags |= Gameutils.SPR_BOUNCE;
                            u.moveSpriteReturn = 0;
                            u.Counter = 0;
                            u.zchange = -u.zchange;
                            Weapon.ScaleSpriteVector(Weapon2, 1000);
                            break;
                        }
                        u.ychange = 0;
                        u.xchange = 0;
                        sp.setExtra(sp.getExtra() | Gameutils.SPRX_BREAKABLE);
                        sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_BREAKABLE);
                        Sprites.ChangeState(Weapon2, s_CaltropsStick[0]);
                        return;
                    }
                    u.zchange = -u.zchange;
                    Weapon.ScaleSpriteVector(Weapon2, 1000);
                }
            }
        }
    }

    public static void SpawnRadiationCloud(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (Sprites.MoveSkip4 == 0) {
            return;
        }
        if (u.ID == 3280 || u.ID == 3121) {
            if (u.Counter2++ > 16) {
                u.Counter2 = 0;
            }
        } else if (u.Counter2++ > 2) {
            u.Counter2 = 0;
        }
        if (u.Counter2 != 0) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            return;
        }
        int newsp = Sprites.SpawnSprite(4, 3258, s_RadiationCloud[0], sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ() - Gameutils.RANDOM_P2(Gameutils.Z(8)), sp.getAng(), 0);
        WangSprite np = Main.boardService.getSprite(newsp);
        USER nu = Gameutils.getUser(newsp);
        if (np == null || nu == null) {
            return;
        }
        Sprites.SetOwner(sp.getOwner(), newsp);
        nu.WaitTics = 120;
        np.setShade(-40);
        np.setXrepeat(32);
        np.setYrepeat(32);
        np.setClipdist(sp.getClipdist());
        np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        np.setCstat(np.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        nu.spal = (byte)22;
        np.setPal(nu.spal);
        np.setHitag(Gameutils.SECTFU_DONT_COPY_PALETTE);
        if (Gameutils.RANDOM_P2(1024) < 512) {
            np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_XFLIP);
        }
        np.setAng(Gameutils.RANDOM_P2(2048));
        np.setXvel(Gameutils.RANDOM_P2(32));
        nu.Counter = 0;
        nu.Counter2 = 0;
        if (u.ID == 3280 || u.ID == 3121) {
            nu.Radius = 2000;
            nu.xchange = Gameutils.MOVEx(np.getXvel() >> 2, np.getAng());
            nu.ychange = Gameutils.MOVEy(np.getXvel() >> 2, np.getAng());
            np.setZvel(Gameutils.Z(1) + Gameutils.RANDOM_P2(Gameutils.Z(2)));
        } else {
            nu.xchange = Gameutils.MOVEx(np.getXvel(), np.getAng());
            nu.ychange = Gameutils.MOVEy(np.getXvel(), np.getAng());
            np.setZvel(Gameutils.Z(4) + Gameutils.RANDOM_P2(Gameutils.Z(4)));
            nu.Radius = 4000;
        }
    }

    public static void DoRadiationCloud(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        sp.setX(sp.getX() + u.xchange);
        sp.setY(sp.getY() + u.ychange);
        sp.setZ(sp.getZ() - sp.getZvel());
        if (u.ID != 0) {
            Weapon.DoFlamesDamageTest(SpriteNum);
        }
    }

    public static void PlayerInitChemBomb(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        Sound.PlaySound(278, pp, 12);
        int nx = pp.posx;
        int ny = pp.posy;
        int nz = pp.posz + pp.bob_z + Gameutils.Z(8);
        int w = Sprites.SpawnSprite(4, 3038, s_ChemBomb[0], pp.cursectnum, nx, ny, nz, pp.getAnglei(), 420);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return;
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_CRAWLING)) {
            wp.setXvel(wp.getXvel() - MyTypes.DIV4(wp.getXvel()));
        }
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Sprites.SetOwner(pp.PlayerSprite, w);
        wp.setYrepeat(32);
        wp.setXrepeat(32);
        wp.setShade(-15);
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 200;
        wu.ceiling_dist = Gameutils.Z(3);
        wu.floor_dist = Gameutils.Z(3);
        wu.Counter = 0;
        wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_BLOCK);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING) || Gameutils.SpriteInUnderwaterArea(wp)) {
            wu.Flags |= Gameutils.SPR_UNDERWATER;
        }
        wp.setZvel((100 - pp.getHorizi()) * 128);
        Sprite psp = pp.getSprite();
        if (psp == null) {
            return;
        }
        int oclipdist = psp.getClipdist();
        psp.setClipdist(0);
        wp.setClipdist(0);
        Weapon.MissileSetPos(w, DoChemBomb, 1000);
        psp.setClipdist(oclipdist);
        wp.setClipdist(20);
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel() >> 1;
        wu.xchange += pp.xvect >> 14;
        wu.ychange += pp.yvect >> 14;
        wu.WaitTics = CHEMTICS;
    }

    public static void InitSpriteChemBomb(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Sound.PlaySound(278, sp, 12);
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = sp.getZ();
        int w = Sprites.SpawnSprite(4, 3038, s_ChemBomb[0], sp.getSectnum(), nx, ny, nz, sp.getAng(), 420);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return;
        }
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Sprites.SetOwner(SpriteNum, w);
        wp.setYrepeat(32);
        wp.setXrepeat(32);
        wp.setShade(-15);
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 200;
        wu.ceiling_dist = Gameutils.Z(3);
        wu.floor_dist = Gameutils.Z(3);
        wu.Counter = 0;
        wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_BLOCK);
        wp.setZvel((-100 - Gameutils.RANDOM_RANGE(100)) * 128);
        wp.setClipdist(20);
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel() >> 1;
        wu.WaitTics = CHEMTICS;
    }

    public static void InitChemBomb(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = sp.getZ();
        int w = Sprites.SpawnSprite(4, 3280, s_ChemBomb[0], sp.getSectnum(), nx, ny, nz, sp.getAng(), 420);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return;
        }
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Sprites.SetOwner(sp.getOwner(), w);
        wp.setYrepeat(32);
        wp.setXrepeat(32);
        wp.setShade(-15);
        wu.Radius = 200;
        wu.ceiling_dist = Gameutils.Z(3);
        wu.floor_dist = Gameutils.Z(3);
        wu.Counter = 0;
        wp.setCstat(wp.getCstat() | (Gameutils.CSTAT_SPRITE_YCENTER | Gameutils.CSTAT_SPRITE_INVISIBLE));
        wp.setCstat(wp.getCstat() & ~Gameutils.CSTAT_SPRITE_BLOCK);
        if (Gameutils.SpriteInUnderwaterArea(wp)) {
            wu.Flags |= Gameutils.SPR_UNDERWATER;
        }
        wp.setZvel((-100 - Gameutils.RANDOM_RANGE(100)) * 128);
        wp.setClipdist(0);
        if (u.ID == 3280 || u.ID == 3121 || u.ID == 1210) {
            wu.xchange = 0;
            wu.ychange = 0;
            wu.zchange = 0;
            wp.setXvel(0);
            wp.setYvel(0);
            wp.setZvel(0);
            wu.WaitTics = 4800;
        } else {
            wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
            wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
            wu.zchange = wp.getZvel() >> 1;
            wu.WaitTics = 360;
        }
    }

    public static void PlayerInitFlashBomb(PlayerStr pp) {
        Sound.PlaySound(283, pp, 12);
        Palette.SetFadeAmt(pp, -30, 1);
        Sprite sp = pp.getSprite();
        if (sp == null) {
            return;
        }
        block0: for (int j : Weapon.StatDamageList) {
            ListNode<Sprite> node = Main.boardService.getStatNode(j);
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite hp = node.get();
                USER hu = Gameutils.getUser(i);
                if (hu != null) {
                    if (i == pp.PlayerSprite) continue block0;
                    int dist = Gameutils.DISTANCE(hp.getX(), hp.getY(), sp.getX(), sp.getY());
                    if (dist <= 16384 && MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_BLOCK) && Rooms.FAFcansee(hp.getX(), hp.getY(), hp.getZ(), hp.getSectnum(), sp.getX(), sp.getY(), sp.getZ() - Gameutils.SPRITEp_SIZE_Z(sp), sp.getSectnum())) {
                        int damage = Weapon.GetDamage(i, pp.PlayerSprite, 31);
                        if (hu.sop_parent != -1) continue block0;
                        if (hu.PlayerP != -1) {
                            if (damage < -70) {
                                int choosesnd = Gameutils.RANDOM_RANGE(5);
                                Sound.PlayerSound(Sound.PlayerLowHealthPainVocs[choosesnd], 13, pp);
                            }
                            Palette.SetFadeAmt(Game.Player[hu.PlayerP], damage, 1);
                        } else {
                            Weapon.ActorPain(i);
                            JWeapon.SpawnFlashBombOnActor(i);
                        }
                    }
                }
                node = nexti;
            }
        }
    }

    public static void InitFlashBomb(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        PlayerStr pp = Game.Player[Game.screenpeek];
        if (sp == null) {
            return;
        }
        Sound.PlaySound(283, sp, 12);
        block0: for (int j : Weapon.StatDamageList) {
            ListNode<Sprite> node = Main.boardService.getStatNode(j);
            while (node != null) {
                int dist;
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite hp = node.get();
                USER hu = Gameutils.getUser(i);
                if (hu != null && (dist = Gameutils.DISTANCE(hp.getX(), hp.getY(), sp.getX(), sp.getY())) <= 16384 && MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_BLOCK) && Rooms.FAFcansee(hp.getX(), hp.getY(), hp.getZ(), hp.getSectnum(), sp.getX(), sp.getY(), sp.getZ() - Gameutils.SPRITEp_SIZE_Z(sp), sp.getSectnum())) {
                    int damage = Weapon.GetDamage(i, SpriteNum, 31);
                    if (hu.sop_parent != -1) continue block0;
                    if (hu.PlayerP != -1) {
                        if (damage < -70) {
                            int choosesnd = Gameutils.RANDOM_RANGE(5);
                            Sound.PlayerSound(Sound.PlayerLowHealthPainVocs[choosesnd], 13, pp);
                        }
                        Palette.SetFadeAmt(Game.Player[hu.PlayerP], damage, 1);
                    } else if (i != SpriteNum) {
                        Weapon.ActorPain(i);
                        JWeapon.SpawnFlashBombOnActor(i);
                    }
                }
                node = nexti;
            }
        }
    }

    public static void SpawnFlashBombOnActor(int enemy) {
        WangSprite ep = Main.boardService.getSprite(enemy);
        USER eu = Gameutils.getUser(enemy);
        if (ep == null || MyTypes.TEST(ep.getExtra(), Gameutils.SPRX_BURNABLE)) {
            return;
        }
        if (eu != null && eu.flame >= 0) {
            int sizez = Gameutils.SPRITEp_SIZE_Z(ep) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(ep));
            WangSprite np = Main.boardService.getSprite(eu.flame);
            USER nu = Gameutils.getUser(eu.flame);
            if (np == null || nu == null) {
                return;
            }
            nu.Counter = nu.Counter >= Gameutils.SPRITEp_SIZE_Z_2_YREPEAT(np, sizez) ? Gameutils.SPRITEp_SIZE_Z_2_YREPEAT(np, sizez) * 2 : (nu.Counter += Gameutils.SPRITEp_SIZE_Z_2_YREPEAT(np, 2048) * 2);
            if (nu.Counter >= 230) {
                nu.Counter = 230;
            }
            if (nu.WaitTics < 240) {
                nu.WaitTics = 240;
            }
            return;
        }
        int newsp = Sprites.SpawnSprite(4, 3212, Weapon.s_FireballFlames[0], ep.getSectnum(), ep.getX(), ep.getY(), ep.getZ(), ep.getAng(), 0);
        WangSprite np = Main.boardService.getSprite(newsp);
        USER nu = Gameutils.getUser(newsp);
        if (np == null || nu == null) {
            return;
        }
        if (eu != null) {
            eu.flame = newsp;
        }
        np.setXrepeat(16);
        np.setYrepeat(16);
        nu.Counter = enemy >= 0 ? Gameutils.SPRITEp_SIZE_Z_2_YREPEAT(np, Gameutils.SPRITEp_SIZE_Z(ep) >> 1) * 4 : 0;
        np.setShade(-40);
        np.setCstat(np.getCstat() | (Gameutils.CSTAT_SPRITE_YCENTER | Gameutils.CSTAT_SPRITE_INVISIBLE));
        np.setCstat(np.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        nu.Radius = 200;
        if (enemy >= 0) {
            Sprites.SetAttach(enemy, newsp);
        }
    }

    public static void PlayerInitCaltrops(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        Sound.PlaySound(278, pp, 12);
        int nx = pp.posx;
        int ny = pp.posy;
        int nz = pp.posz + pp.bob_z + Gameutils.Z(8);
        int w = Sprites.SpawnSprite(3, 2218, s_Caltrops[0], pp.cursectnum, nx, ny, nz, pp.getAnglei(), (420 + Gameutils.RANDOM_RANGE(420)) / 2);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return;
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_CRAWLING)) {
            wp.setXvel(wp.getXvel() - MyTypes.DIV4(wp.getXvel()));
        }
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Sprites.SetOwner(pp.PlayerSprite, w);
        wp.setYrepeat(64);
        wp.setXrepeat(64);
        wp.setShade(-15);
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 200;
        wu.ceiling_dist = Gameutils.Z(3);
        wu.floor_dist = Gameutils.Z(3);
        wu.Counter = 0;
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING) || Gameutils.SpriteInUnderwaterArea(wp)) {
            wu.Flags |= Gameutils.SPR_UNDERWATER;
        }
        wp.setZvel((100 - pp.getHorizi()) * 128);
        Sprite psp = pp.getSprite();
        if (psp == null) {
            return;
        }
        int oclipdist = psp.getClipdist();
        psp.setClipdist(0);
        wp.setClipdist(0);
        Weapon.MissileSetPos(w, DoCaltrops, 1000);
        psp.setClipdist(oclipdist);
        wp.setClipdist(20);
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel() >> 1;
        wu.xchange += pp.xvect >> 14;
        wu.ychange += pp.yvect >> 14;
        Break.SetupSpriteForBreak(wp);
    }

    public static void InitCaltrops(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Sound.PlaySound(278, sp, 12);
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = sp.getZ();
        int w = Sprites.SpawnSprite(3, 2218, s_Caltrops[0], sp.getSectnum(), nx, ny, nz, sp.getAng(), 210);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return;
        }
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Sprites.SetOwner(SpriteNum, w);
        wp.setYrepeat(64);
        wp.setXrepeat(64);
        wp.setShade(-15);
        wp.setClipdist(sp.getClipdist());
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 200;
        wu.ceiling_dist = Gameutils.Z(3);
        wu.floor_dist = Gameutils.Z(3);
        wu.Counter = 0;
        wp.setZvel((-100 - Gameutils.RANDOM_RANGE(100)) * 128);
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel() >> 1;
        Break.SetupSpriteForBreak(wp);
    }

    public static void InitPhosphorus(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Sound.PlaySound(187, sp, 1);
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = sp.getZ();
        int daang = Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(2048));
        int w = Sprites.SpawnSprite(6, 2010, s_Phosphorus[0], sp.getSectnum(), nx, ny, nz, daang, 140);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return;
        }
        wp.setHitag(9999);
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        wp.setShade(-128);
        wp.setYrepeat(64);
        wp.setXrepeat(64);
        wp.setShade(-15);
        if (sp.getClipdist() > 0) {
            wp.setClipdist(sp.getClipdist() - 1);
        } else {
            wp.setClipdist(sp.getClipdist());
        }
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 600;
        wu.ceiling_dist = Gameutils.Z(3);
        wu.floor_dist = Gameutils.Z(3);
        wu.Counter = 0;
        wp.setZvel((-100 - Gameutils.RANDOM_RANGE(100)) * 128);
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel() >> 1;
    }

    public static void InitBloodSpray(int SpriteNum, boolean dogib, int velocity) {
        int rnd;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int cnt = 1;
        if (dogib) {
            cnt = Gameutils.RANDOM_RANGE(3) + 1;
        }
        if ((rnd = Gameutils.RANDOM_RANGE(1000)) > 650) {
            Sound.PlaySound(395, sp, 0);
        } else if (rnd > 350) {
            Sound.PlaySound(396, sp, 0);
        } else {
            Sound.PlaySound(411, sp, 0);
        }
        int ang = sp.getAng();
        int vel = velocity;
        for (int i = 0; i < cnt; ++i) {
            if (velocity == -1) {
                vel = 105 + Gameutils.RANDOM_RANGE(320);
            } else if (velocity == -2) {
                vel = 105 + Gameutils.RANDOM_RANGE(100);
            }
            ang = dogib ? Gameutils.NORM_ANGLE(ang + 512 + Gameutils.RANDOM_RANGE(200)) : Gameutils.NORM_ANGLE(ang + 1024 + 256 - Gameutils.RANDOM_RANGE(256));
            int nx = sp.getX();
            int ny = sp.getY();
            int nz = Gameutils.SPRITEp_TOS(sp) - 20;
            int w = Sprites.SpawnSprite(4, 1562, s_BloodSprayChunk[0], sp.getSectnum(), nx, ny, nz, ang, vel * 2);
            WangSprite wp = Main.boardService.getSprite(w);
            USER wu = Gameutils.getUser(w);
            if (wp == null || wu == null) {
                return;
            }
            wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
            if (dogib) {
                wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
            } else {
                wp.setCstat(wp.getCstat() | (Gameutils.CSTAT_SPRITE_YCENTER | Gameutils.CSTAT_SPRITE_INVISIBLE));
            }
            wp.setShade(-12);
            Sprites.SetOwner(SpriteNum, w);
            wp.setYrepeat(64 - Gameutils.RANDOM_RANGE(35));
            wp.setXrepeat(64 - Gameutils.RANDOM_RANGE(35));
            wp.setShade(-15);
            wp.setClipdist(sp.getClipdist());
            wu.WeaponNum = u.WeaponNum;
            wu.Radius = 600;
            wu.ceiling_dist = Gameutils.Z(3);
            wu.floor_dist = Gameutils.Z(3);
            wu.Counter = 0;
            wp.setZvel((-10 - Gameutils.RANDOM_RANGE(50)) * 128);
            wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
            wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
            wu.zchange = wp.getZvel() >> 1;
            if (Weapon.GlobalSkipZrange) continue;
            Sprites.DoActorZrange(w);
        }
    }

    public static void BloodSprayFall(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp != null) {
            sp.setZ(sp.getZ() + 1500);
        }
    }

    public static void DoFlagScore(int pal) {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(0); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (sp.getPicnum() < 1900 || sp.getPicnum() > 1999) continue;
            if (sp.getPal() == pal) {
                sp.setPicnum(sp.getPicnum() + 1);
            }
            if (sp.getPicnum() <= 1999) continue;
            sp.setPicnum(1900);
        }
    }

    public static int DoFlagRangeTest(int Weapon2, int range) {
        WangSprite wp = Main.boardService.getSprite(Weapon2);
        if (wp == null) {
            return 0;
        }
        for (int i : Weapon.StatDamageList) {
            ListNode<Sprite> node = Main.boardService.getStatNode(i);
            while (node != null) {
                ListNode<Sprite> nexti = node.getNext();
                Sprite sp = node.get();
                int dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), wp.getX(), wp.getY());
                if (dist <= range && sp != wp && MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_BLOCK) && MyTypes.TEST(sp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY) && Rooms.FAFcansee(sp.getX(), sp.getY(), sp.getZ(), sp.getSectnum(), wp.getX(), wp.getY(), wp.getZ(), wp.getSectnum()) && (dist = Gameutils.FindDistance3D(wp.getX() - sp.getX(), wp.getY() - sp.getY(), wp.getZ() - sp.getZ() >> 4)) <= range) {
                    return node.getIndex();
                }
                node = nexti;
            }
        }
        return -1;
    }

    public static void DoCarryFlag(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        USER u = Gameutils.getUser(Weapon2);
        if (sp == null || u == null) {
            return;
        }
        WangSprite fp = Main.boardService.getSprite(u.FlagOwner);
        WangSprite ap = Main.boardService.getSprite(u.Attach);
        if (ap != null) {
            Main.engine.setspritez(Weapon2, ap.getX(), ap.getY(), Gameutils.SPRITEp_MID(ap));
            sp.setAng(Gameutils.NORM_ANGLE(ap.getAng() + 1536));
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_ACTIVE)) {
            if ((u.WaitTics -= 12) > 0) {
                return;
            }
            u.WaitTics = Gameutils.SEC(30);
            u.Counter2 = 0;
            u.Flags |= Gameutils.SPR_ACTIVE;
        }
        ++u.Counter;
        if (u.Counter > 1) {
            u.Counter = 0;
        }
        if (u.Counter == 0) {
            if (u.Counter2 < 99) {
                ap = Main.boardService.getSprite(u.Attach);
                USER au = Gameutils.getUser(u.Attach);
                if (au == null || au.Health <= 0) {
                    u.Counter2 = 99;
                    u.WaitTics = Gameutils.SEC(1) / 2;
                }
                if (ap != null) {
                    ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(ap.getSectnum());
                    if (fp != null && sec != null && sec.getHitag() == 9000 && sec.getLotag() == ap.getPal() && ap.getPal() != sp.getPal()) {
                        if (u.FlagOwner >= 0 && fp.getLotag() != 0) {
                            Sector.DoMatchEverything(null, fp.getLotag(), 1);
                        }
                        if (!Gameutils.TEST_BOOL1(fp)) {
                            Sound.PlaySound(55, ap, 0);
                            JWeapon.DoFlagScore(ap.getPal());
                            if (Gameutils.SP_TAG5(fp) > 0) {
                                fp.setDetail(fp.getDetail() + 1);
                                if (fp.getDetail() >= Gameutils.SP_TAG5(fp)) {
                                    fp.setDetail(0);
                                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(fp), 1);
                                }
                            }
                        }
                        Weapon.SetSuicide(Weapon2);
                    }
                }
            } else {
                u.Counter2 = 99;
                u.WaitTics = Gameutils.SEC(1) / 2;
            }
        }
        u.WaitTics -= 12;
        switch (u.Counter2) {
            case 0: {
                if (u.WaitTics >= Gameutils.SEC(30)) break;
                Sound.PlaySound(26, sp, 8);
                ++u.Counter2;
                break;
            }
            case 1: {
                if (u.WaitTics >= Gameutils.SEC(20)) break;
                Sound.PlaySound(26, sp, 8);
                ++u.Counter2;
                break;
            }
            case 2: {
                if (u.WaitTics >= Gameutils.SEC(10)) break;
                Sound.PlaySound(26, sp, 8);
                ++u.Counter2;
                break;
            }
            case 3: {
                if (u.WaitTics >= Gameutils.SEC(5)) break;
                Sound.PlaySound(26, sp, 8);
                ++u.Counter2;
                break;
            }
            case 4: {
                if (u.WaitTics >= Gameutils.SEC(4)) break;
                Sound.PlaySound(26, sp, 8);
                ++u.Counter2;
                break;
            }
            case 5: {
                if (u.WaitTics >= Gameutils.SEC(3)) break;
                Sound.PlaySound(26, sp, 8);
                ++u.Counter2;
                break;
            }
            case 6: {
                if (u.WaitTics >= Gameutils.SEC(2)) break;
                Sound.PlaySound(26, sp, 8);
                u.Counter2 = 99;
                break;
            }
            case 99: {
                Sound.PlaySound(26, sp, 8);
                ++u.Counter2;
                break;
            }
            case 100: {
                Weapon.SpawnGrenadeExp(Weapon2);
                Weapon.SetSuicide(Weapon2);
            }
        }
    }

    public static void DoCarryFlagNoDet(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        USER u = Gameutils.getUser(Weapon2);
        if (sp == null || u == null) {
            return;
        }
        WangSprite fp = Main.boardService.getSprite(u.FlagOwner);
        USER fu = Gameutils.getUser(u.FlagOwner);
        if (fu != null && u.FlagOwner >= 0) {
            fu.WaitTics = 3600;
        }
        USER au = null;
        WangSprite ap = Main.boardService.getSprite(u.Attach);
        if (ap != null) {
            au = Gameutils.getUser(u.Attach);
            Main.engine.setspritez(Weapon2, ap.getX(), ap.getY(), Gameutils.SPRITEp_MID(ap));
            sp.setAng(Gameutils.NORM_ANGLE(ap.getAng() + 1536));
            sp.setZ(ap.getZ() - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(ap)));
        }
        if (au == null || au.Health <= 0) {
            if (fu != null && u.FlagOwner >= 0) {
                fu.WaitTics = 0;
            }
            Weapon.SetSuicide(Weapon2);
            return;
        }
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(ap.getSectnum());
        if (sec != null && fp != null && sec.getHitag() == 9000 && sec.getLotag() == ap.getPal() && ap.getPal() != sp.getPal()) {
            if (fu != null && u.FlagOwner >= 0) {
                if (fp.getLotag() != 0) {
                    Sector.DoMatchEverything(null, fp.getLotag(), 1);
                }
                fu.WaitTics = 0;
            }
            if (!Gameutils.TEST_BOOL1(fp)) {
                Sound.PlaySound(55, ap, 0);
                JWeapon.DoFlagScore(ap.getPal());
                if (Gameutils.SP_TAG5(fp) > 0) {
                    fp.setDetail(fp.getDetail() + 1);
                    if (fp.getDetail() >= Gameutils.SP_TAG5(fp)) {
                        fp.setDetail(0);
                        Sector.DoMatchEverything(null, Gameutils.SP_TAG6(fp), 1);
                    }
                }
            }
            Weapon.SetSuicide(Weapon2);
        }
    }

    public static void SetCarryFlag(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        USER u = Gameutils.getUser(Weapon2);
        if (sp == null || u == null) {
            return;
        }
        u.Flags |= Gameutils.SPR_BOUNCE;
        sp.setCstat(sp.getCstat() | (Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        u.Counter = 0;
        Sprites.change_sprite_stat(Weapon2, 10);
        if (sp.getHitag() == 1) {
            Sprites.ChangeState(Weapon2, s_CarryFlagNoDet[0]);
        } else {
            Sprites.ChangeState(Weapon2, s_CarryFlag[0]);
        }
    }

    public static void DoFlag(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        USER u = Gameutils.getUser(Weapon2);
        if (sp == null || u == null) {
            return;
        }
        int hitsprite = JWeapon.DoFlagRangeTest(Weapon2, 1000);
        WangSprite hsp = Main.boardService.getSprite(hitsprite);
        if (hsp != null) {
            JWeapon.SetCarryFlag(Weapon2);
            if (MyTypes.TEST(hsp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                Sprites.SetAttach(hitsprite, Weapon2);
                u.sz = hsp.getZ() - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(hsp));
            }
        }
    }

    public static void InitShell(int SpriteNum, int ShellNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int id = 0;
        int velocity = 0;
        State p = null;
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = MyTypes.DIV2(Gameutils.SPRITEp_TOS(sp) + Gameutils.SPRITEp_BOS(sp));
        switch (ShellNum) {
            case -3: 
            case -2: {
                id = 2152;
                p = Weapon.s_UziShellShrap[0];
                velocity = 1500 + Gameutils.RANDOM_RANGE(1000);
                break;
            }
            case -4: {
                id = 2180;
                p = Weapon.s_ShotgunShellShrap[0];
                velocity = 2000 + Gameutils.RANDOM_RANGE(1000);
            }
        }
        int w = Sprites.SpawnSprite(6, id, p, sp.getSectnum(), nx, ny, nz, sp.getAng(), 64);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return;
        }
        wp.setZvel(-velocity);
        if (u.PlayerP != -1) {
            wp.setZ(wp.getZ() + (100 - Game.Player[u.PlayerP].getHorizi()) * 42);
        }
        switch (wu.ID) {
            case 2152: {
                wp.setZ(wp.getZ() - Gameutils.Z(13));
                if (ShellNum == -3) {
                    wp.setAng(sp.getAng());
                    Weapon.HelpMissileLateral(w, 2500);
                    wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() - 512));
                    Weapon.HelpMissileLateral(w, 1000);
                    wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() + 712));
                } else {
                    wp.setAng(sp.getAng());
                    Weapon.HelpMissileLateral(w, 2500);
                    wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() + 512));
                    Weapon.HelpMissileLateral(w, 1500);
                    wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() - 128));
                }
                wp.setAng(wp.getAng() + (Gameutils.RANDOM_P2(4096) >> 5) - MyTypes.DIV2(128));
                wp.setAng(Gameutils.NORM_ANGLE(wp.getAng()));
                wu.ShellNum = 0;
                wp.setXrepeat(13);
                wp.setYrepeat(13);
                break;
            }
            case 2180: {
                wp.setZ(wp.getZ() - Gameutils.Z(13));
                wp.setAng(sp.getAng());
                Weapon.HelpMissileLateral(w, 2500);
                wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() + 512));
                Weapon.HelpMissileLateral(w, 1300);
                wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() - 128 - 64));
                wp.setAng(wp.getAng() + (Gameutils.RANDOM_P2(4096) >> 5) - MyTypes.DIV2(128));
                wp.setAng(Gameutils.NORM_ANGLE(wp.getAng()));
                wu.ShellNum = 0;
                wp.setXrepeat(18);
                wp.setYrepeat(18);
            }
        }
        Sprites.SetOwner(SpriteNum, w);
        wp.setShade(-15);
        wu.ceiling_dist = Gameutils.Z(1);
        wu.floor_dist = Gameutils.Z(1);
        wu.Counter = 0;
        wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        wp.setCstat(wp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        wu.Flags &= ~(Gameutils.SPR_BOUNCE | Gameutils.SPR_UNDERWATER);
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel();
        wu.jump_speed = 200;
        wu.jump_speed += Gameutils.RANDOM_RANGE(400);
        wu.jump_speed = -wu.jump_speed;
        Actor.DoBeginJump(w);
        wu.jump_grav = 8;
    }

    public static void JWeaponSaveable() {
        Saveable.SaveData(BloodSprayFall);
        Saveable.SaveData(DoRadiationCloud);
        Saveable.SaveData(DoChemBomb);
        Saveable.SaveData(DoCaltrops);
        Saveable.SaveData(DoCaltropsStick);
        Saveable.SaveData(DoFlag);
        Saveable.SaveData(DoCarryFlag);
        Saveable.SaveData(DoCarryFlagNoDet);
        Saveable.SaveData(DoPhosphorus);
        Saveable.SaveData(DoBloodSpray);
        Saveable.SaveData(DoWallBloodDrip);
        Saveable.SaveData(s_BloodSpray);
        Saveable.SaveData(s_PhosphorExp);
        Saveable.SaveData(s_NukeMushroom);
        Saveable.SaveData(s_RadiationCloud);
        Saveable.SaveData(s_ChemBomb);
        Saveable.SaveData(s_Caltrops);
        Saveable.SaveData(s_CaltropsStick);
        Saveable.SaveData(s_CarryFlag);
        Saveable.SaveData(s_CarryFlagNoDet);
        Saveable.SaveData(s_Flag);
        Saveable.SaveData(s_Phosphorus);
        Saveable.SaveData(s_BloodSprayChunk);
        Saveable.SaveData(s_BloodSprayDrip);
    }
}

