/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuDifficulty;
import ru.m210projects.Wang.Menus.WangTitle;
import ru.m210projects.Wang.Type.EpisodeInfo;
import ru.m210projects.Wang.Type.GameInfo;

public class MenuNewAddon
extends BuildMenu {
    private static final int nMaxEpisodes = 2;
    private final List<char[]> mEpisodelist;
    private final List<char[]> mEpisodeDescr;
    private GameInfo game;
    private final MenuList mSlot;
    private final int[] episodeNum;

    public MenuNewAddon(final Main app) {
        super(app.pMenu);
        WangMenuHandler menu = app.menu;
        this.addItem(new WangTitle("USER EPISODE"), false);
        this.mEpisodelist = new ArrayList<char[]>();
        this.mEpisodeDescr = new ArrayList<char[]>();
        this.episodeNum = new int[2];
        MenuProc newEpProc = (handler, pItem) -> {
            MenuList button = (MenuList)pItem;
            MenuDifficulty next = (MenuDifficulty)menu.mMenus[4];
            next.setEpisode(this.game, this.episodeNum[button.l_nFocus]);
            menu.mOpen(next, -1);
        };
        this.mSlot = new MenuList(this, this.mEpisodelist, app.getFont(2), 35, 45, 320, 0, newEpProc, 2){
            final /* synthetic */ MenuNewAddon this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }

            @Override
            public int mFontOffset() {
                return this.font.getSize() + 17;
            }

            @Override
            public void draw(MenuHandler handler) {
                super.draw(handler);
                Renderer renderer = handler.getRenderer();
                if (!this.text.isEmpty()) {
                    int py = this.y;
                    for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < this.len; ++i) {
                        app.getFont(1).drawTextScaled(renderer, this.x, py + 17, (char[])this.this$0.mEpisodeDescr.get(i), 1.0f, 0, 4, TextAlign.Left, Transparent.None, ConvertType.Normal, false);
                        py += this.mFontOffset();
                    }
                }
            }
        };
        this.addItem(this.mSlot, true);
    }

    public void setEpisode(GameInfo game) {
        this.game = game;
        this.mEpisodelist.clear();
        this.mEpisodeDescr.clear();
        Arrays.fill(this.episodeNum, -1);
        for (int i = 0; i < 2; ++i) {
            EpisodeInfo episode = game.episode[i];
            if (episode == null || episode.Title.isEmpty() || episode.nMaps == 0) continue;
            this.episodeNum[this.mEpisodelist.size()] = i;
            this.mEpisodelist.add(episode.Title.toCharArray());
            this.mEpisodeDescr.add(episode.Description.toCharArray());
        }
        this.mSlot.len = this.mEpisodelist.size();
        this.mSlot.l_nMin = 0;
        this.mSlot.l_nFocus = 0;
    }
}

