/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Menus;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuLoadSave;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuPicnum;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlotList;
import ru.m210projects.Build.Pattern.MenuItems.MenuText;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.LoadSave;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.WangTitle;

public class MenuSave
extends MenuLoadSave {
    public MenuSave(BuildGame app) {
        super(app, app.getFont(0), 75, 50, 185, 240, 12, 16, 19, 2324, (handler, pItem) -> {
            String filename;
            MenuSlotList item = (MenuSlotList)pItem;
            Directory userDir = app.getUserDirectory();
            if (item.l_nFocus == 0) {
                int num = 0;
                while (true) {
                    if (num > 9999) {
                        return;
                    }
                    filename = "game" + LoadSave.makeNum(num) + ".sav";
                    if (userDir.getEntry(filename).exists()) {
                        ++num;
                        continue;
                    }
                    break;
                }
            } else {
                filename = item.getFileEntry().getName();
            }
            if (item.typed == null || item.typed.isEmpty()) {
                item.typed = filename;
            }
            LoadSave.savegame(userDir, item.typed, filename);
            handler.mClose();
        }, true);
        this.list.owncursor = true;
        this.list.pal = 16;
        this.list.helpPal = 16;
        this.list.questionFont = app.getFont(1);
        this.list.nListOffset = 15;
        this.list.backgroundPal = 4;
    }

    @Override
    protected void drawOwnCursor(int x, int y) {
        Renderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(x + 4 << 16, y + 1 << 16, 20000, 0, 2440 + (Main.engine.getTotalClock() >> 3) % 7, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP);
    }

    @Override
    public boolean loadData(FileEntry filename) {
        return LoadSave.lsReadLoadData(filename) != -1;
    }

    @Override
    public MenuTitle getTitle(BuildGame app, String text) {
        return new WangTitle(text);
    }

    @Override
    public MenuPicnum getPicnum(Engine draw, int x, int y) {
        return new MenuPicnum(draw, x - 70, y - 3, 2324, 2324, 0){

            @Override
            public void draw(MenuHandler handler) {
                Renderer renderer = Main.game.getRenderer();
                int ydim = renderer.getHeight();
                if (this.nTile != this.defTile) {
                    renderer.rotatesprite(this.x + 3 << 16, this.y << 16, 74752, 0, this.nTile, 0, 0, 26);
                } else {
                    renderer.rotatesprite(this.x + 94 << 16, this.y + 57 << 16, 37376, 0, this.nTile, 0, 0, 10, ru.m210projects.Build.Gameutils.coordsConvertXScaled(this.x, ConvertType.Normal), 0, ru.m210projects.Build.Gameutils.coordsConvertXScaled(this.x + 186, ConvertType.Normal), ydim - 1);
                }
            }

            @Override
            public void close() {
                Main.gGameScreen.captBuffer = null;
            }
        };
    }

    @Override
    public MenuText getInfo(BuildGame app, int x, int y) {
        return new MenuText(LoadSave.lsInf.info, app.getFont(0), x - 58, y + 100, 0){

            @Override
            public void draw(MenuHandler handler) {
                Renderer renderer = handler.getRenderer();
                int ty = this.y;
                if (LoadSave.lsInf.addonfile != null && !LoadSave.lsInf.addonfile.isEmpty()) {
                    this.font.drawTextScaled(renderer, this.x, ty, LoadSave.lsInf.addonfile, 1.0f, -128, 4, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
                    ty -= 10;
                }
                if (LoadSave.lsInf.date != null && !LoadSave.lsInf.date.isEmpty()) {
                    this.font.drawTextScaled(renderer, this.x, ty, LoadSave.lsInf.date, 1.0f, -128, 4, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
                    ty -= 10;
                }
                if (LoadSave.lsInf.info != null) {
                    this.font.drawTextScaled(renderer, this.x, ty, LoadSave.lsInf.info, 1.0f, -128, 4, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
                }
            }
        };
    }
}

