/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Menus;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuDifficulty;
import ru.m210projects.Wang.Menus.MenuNewAddon;
import ru.m210projects.Wang.Menus.Network.MenuNetwork;
import ru.m210projects.Wang.Menus.WangTitle;
import ru.m210projects.Wang.Screens.DemoScreen;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.EpisodeEntry;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.LevelInfo;
import ru.m210projects.Wang.Type.ResourceHandler;

public class MenuUserContent
extends BuildMenu {
    private final Main app;
    private final MenuFileBrowser list;
    private final HashMap<String, LevelInfo> originalMaps = new HashMap<String, LevelInfo>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("$bullet.map", Game.pSharewareEp.gMapInfo[1]);
            this.put("$dozer.map", Game.pSharewareEp.gMapInfo[2]);
            this.put("$shrine.map", Game.pSharewareEp.gMapInfo[3]);
            this.put("$woods.map", Game.pSharewareEp.gMapInfo[4]);
            this.put("$whirl.map", Game.pOriginalEp.gMapInfo[0]);
            this.put("$tank.map", Game.pOriginalEp.gMapInfo[1]);
            this.put("$boat.map", Game.pOriginalEp.gMapInfo[2]);
            this.put("$garden.map", Game.pOriginalEp.gMapInfo[3]);
            this.put("$outpost.map", Game.pOriginalEp.gMapInfo[4]);
            this.put("$hidtemp.map", Game.pOriginalEp.gMapInfo[5]);
            this.put("$plax1.map", Game.pOriginalEp.gMapInfo[6]);
            this.put("$bath.map", Game.pOriginalEp.gMapInfo[7]);
            this.put("$airport.map", Game.pOriginalEp.gMapInfo[8]);
            this.put("$refiner.map", Game.pOriginalEp.gMapInfo[9]);
            this.put("$newmine.map", Game.pOriginalEp.gMapInfo[10]);
            this.put("$subbase.map", Game.pOriginalEp.gMapInfo[11]);
            this.put("$rock.map", Game.pOriginalEp.gMapInfo[12]);
            this.put("$yamato.map", Game.pOriginalEp.gMapInfo[13]);
            this.put("$seabase.map", Game.pOriginalEp.gMapInfo[14]);
            this.put("$volcano.map", Game.pOriginalEp.gMapInfo[15]);
            this.put("$shore.map", Game.pOriginalEp.gMapInfo[16]);
            this.put("$auto.map", Game.pOriginalEp.gMapInfo[17]);
        }
    };
    public boolean showmain;

    public MenuUserContent(Main app) {
        super(app.pMenu);
        this.app = app;
        this.addItem(new WangTitle("User content"), false);
        int width = 240;
        this.list = new MenuFileBrowser(app, app.getFont(0), app.getFont(1), app.getFont(0), 40, 40, width, 1, 14, 2324){

            @Override
            protected void drawHeader(Renderer renderer, int x1, int x2, int y) {
                this.app.getFont(1).drawTextScaled(renderer, x1, y, this.dirs, 1.0f, -32, this.topPal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
                this.app.getFont(1).drawTextScaled(renderer, x2, y, this.ffs, 1.0f, -32, this.topPal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
            }

            @Override
            public void init() {
                this.registerExtension("map", 0, 0);
                this.registerExtension("grp", 19, 1);
                this.registerExtension("zip", 19, 1);
                this.registerExtension("pk3", 19, 1);
                this.registerExtension("dmo", 1, -1);
                this.registerClass(EpisodeEntry.Addon.class, 19, 2);
            }

            @Override
            public void handleDirectory(Directory dir) {
                GameInfo addon;
                if (this.app.pMenu.gShowMenu) {
                    Sound.PlaySound(1, null, 8);
                }
                if ((addon = ResourceHandler.episodeManager.getEpisode(dir.getDirectoryEntry())) != null) {
                    this.addFile((FileEntry)((Object)addon.getEpisodeEntry()));
                }
            }

            @Override
            public void handleFile(FileEntry fil) {
                switch (fil.getExtension()) {
                    case "MAP": {
                        LevelInfo map;
                        Directory dir = fil.getParent();
                        GameInfo addon = ResourceHandler.episodeManager.getEpisode(dir.getDirectoryEntry());
                        if (addon != null && (map = (LevelInfo)MenuUserContent.this.originalMaps.get(fil.getName().toLowerCase(Locale.ROOT))) != null) {
                            return;
                        }
                        this.addFile(fil);
                        break;
                    }
                    case "DMO": {
                        if (MenuUserContent.this.showmain || !DemoScreen.checkDemoEntry(fil)) break;
                        this.addFile(fil);
                        break;
                    }
                    case "GRP": 
                    case "PK3": 
                    case "ZIP": {
                        GameInfo addon = ResourceHandler.episodeManager.getEpisode(fil);
                        if (addon == null || !MenuUserContent.this.showmain && addon.equals(Game.defGame)) break;
                        this.addFile(fil);
                        break;
                    }
                }
            }

            @Override
            public void invoke(FileEntry fil) {
                switch (fil.getExtension()) {
                    case "MAP": {
                        MenuUserContent.this.launchMap(fil);
                        break;
                    }
                    case "GRP": 
                    case "ZIP": 
                    case "PK3": {
                        MenuUserContent.this.launchEpisode(ResourceHandler.episodeManager.getEpisode(fil));
                        break;
                    }
                    case "DMO": {
                        Directory parent = fil.getParent();
                        List<Entry> demoList = Main.gDemoScreen.checkDemoEntry(parent);
                        Main.gDemoScreen.nDemonum = demoList.indexOf(fil);
                        Main.gDemoScreen.showDemo(fil, null);
                        this.app.pMenu.mClose();
                        break;
                    }
                    default: {
                        if (!(fil instanceof EpisodeEntry)) break;
                        MenuUserContent.this.launchEpisode(ResourceHandler.episodeManager.getEpisode(fil));
                    }
                }
            }
        };
        this.list.topPal = 20;
        this.list.pathPal = 20;
        this.list.listPal = 4;
        this.addItem(this.list, true);
    }

    private void launchMap(FileEntry file) {
        if (file == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            MenuNetwork network = (MenuNetwork)this.app.menu.mMenus[11];
            network.setMap(file);
            this.app.menu.mMenuBack();
            return;
        }
        MenuDifficulty next = (MenuDifficulty)this.app.menu.mMenus[4];
        next.setMap(file);
        this.app.menu.mOpen(next, -1);
    }

    private void launchEpisode(GameInfo game) {
        if (game == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            MenuNetwork network = (MenuNetwork)this.app.menu.mMenus[11];
            network.setEpisode(game);
            this.app.menu.mMenuBack();
            return;
        }
        MenuNewAddon next = (MenuNewAddon)this.app.menu.mMenus[14];
        next.setEpisode(game);
        this.app.menu.mOpen(next, -1);
    }

    public void setShowMain(boolean show) {
        this.showmain = show;
        if (Main.game.getCache().isGameDirectory(this.list.getDirectory())) {
            this.list.refreshList();
        }
    }

    public boolean mFromNetworkMenu() {
        return this.app.menu.getLastMenu() == this.app.menu.mMenus[11];
    }
}

