/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.WangScreenFade;

public class Palette {
    public static final WangScreenFade WANG_SCREEN_FADE = new WangScreenFade("ScreenFade");
    public static final int MAXFADETICS = 5;
    public static final int COLOR_PAIN = 128;
    public static final int FADE_DAMAGE_FACTOR = 3;
    public static final int FORCERESET = 256;
    public static final int LT_GREY = 1;
    public static final int DK_GREY = 16;
    public static final int LT_BROWN = 32;
    public static final int DK_BROWN = 48;
    public static final int LT_TAN = 64;
    public static final int DK_TAN = 80;
    public static final int RUST_RED = 96;
    public static final int RED = 112;
    public static final int YELLOW = 128;
    public static final int BRIGHT_GREEN = 144;
    public static final int DK_GREEN = 160;
    public static final int GREEN = 176;
    public static final int LT_BLUE = 192;
    public static final int DK_BLUE = 208;
    public static final int PURPLE = 224;
    public static final int FIRE = 240;
    public static final int PALETTE_DEFAULT = 0;
    public static final int PALETTE_FOG = 1;
    public static final int PALETTE_MENU_HIGHLIGHT = 2;
    public static final int PALETTE_ELECTRO_GORE = 3;
    public static final int PALETTE_BASIC_NINJA = 4;
    public static final int PALETTE_DIVE_LAVA = 5;
    public static final int PALETTE_RED_NINJA = 6;
    public static final int PALETTE_BROWN_RIPPER = 7;
    public static final int PALETTE_GREEN_NINJA = 8;
    public static final int PALETTE_DIVE = 9;
    public static final int PALETTE_SKEL_GORE = 10;
    public static final int PALETTE_GREEN_LIGHTING = 11;
    public static final int PALETTE_BLUE_LIGHTING = 13;
    public static final int PALETTE_RED_LIGHTING = 14;
    public static final int PALETTE_SLUDGE = 15;
    public static final int PALETTE_PLAYER0 = 16;
    public static final int PAL_XLAT_BROWN = 16;
    public static final int PALETTE_PLAYER1 = 17;
    public static final int PAL_XLAT_LT_GREY = 17;
    public static final int PALETTE_PLAYER3 = 19;
    public static final int PALETTE_PLAYER4 = 20;
    public static final int PALETTE_PLAYER5 = 21;
    public static final int PALETTE_PLAYER6 = 22;
    public static final int PALETTE_PLAYER7 = 23;
    public static final int PALETTE_PLAYER8 = 24;
    public static final int PAL_XLAT_LT_TAN = 24;
    public static final int PALETTE_PLAYER9 = 25;
    public static final int PAL_XLAT_BRIGHT_GREEN = 27;
    public static final int PALETTE_ILLUMINATE = 32;
    public static final int PLAYER_COLOR_MAPS = 15;

    public static void SetFadeAmt(PlayerStr pp, int damage, int startcolor) {
        if (Pragmas.klabs(pp.FadeAmt) > 0 && startcolor == (pp.StartColor & 0xFF)) {
            return;
        }
        if (pp.StartColor == 1 && Pragmas.klabs(pp.FadeAmt) > 0) {
            return;
        }
        if (pp == Game.Player[Game.screenpeek]) {
            Palette.ResetPalette(pp, startcolor);
        }
        int fadedamage = damage < -150 && damage > -1000 ? 150 : (damage < -1000 ? Pragmas.klabs(damage + 1000) : Pragmas.klabs(damage));
        if (damage >= -5 && damage < 0) {
            fadedamage += 10;
        }
        if (startcolor == 128 && fadedamage > 100) {
            fadedamage = 100;
        }
        pp.FadeAmt = fadedamage / 3;
        if (pp.FadeAmt <= 0) {
            pp.FadeAmt = 0;
            return;
        }
        if (damage > 0) {
            pp.FadeAmt = 3;
        }
        pp.StartColor = (byte)startcolor;
        pp.FadeTics = 0;
        if (pp == Game.Player[Game.screenpeek]) {
            byte[] palette = Main.engine.getPaletteManager().getBasePalette();
            byte[] temp_pal = WANG_SCREEN_FADE.getPalette();
            int red = palette[3 * startcolor] & 0xFF;
            int green = palette[3 * startcolor + 1] & 0xFF;
            int blue = palette[3 * startcolor + 2] & 0xFF;
            int usereg = 0;
            for (int palreg = 0; palreg < 768; ++palreg) {
                int tmpreg1 = (temp_pal[palreg] & 0xFF) + (2 * pp.FadeAmt + 4);
                int tmpreg2 = (temp_pal[palreg] & 0xFF) - (2 * pp.FadeAmt + 4);
                if (tmpreg1 > 255) {
                    tmpreg1 = 255;
                }
                if (tmpreg2 < 0) {
                    tmpreg2 = 0;
                }
                if (usereg == 0) {
                    if ((temp_pal[palreg] & 0xFF) < red) {
                        temp_pal[palreg] = (byte)tmpreg1;
                        if ((temp_pal[palreg] & 0xFF) > red) {
                            temp_pal[palreg] = (byte)red;
                        }
                    } else if ((temp_pal[palreg] & 0xFF) > red && ((temp_pal[palreg] = (byte)tmpreg2) & 0xFF) < red) {
                        temp_pal[palreg] = (byte)red;
                    }
                } else if (usereg == 1) {
                    if ((temp_pal[palreg] & 0xFF) < green) {
                        temp_pal[palreg] = (byte)tmpreg1;
                        if ((temp_pal[palreg] & 0xFF) > green) {
                            temp_pal[palreg] = (byte)green;
                        }
                    } else if ((temp_pal[palreg] & 0xFF) > green && ((temp_pal[palreg] = (byte)tmpreg2) & 0xFF) < green) {
                        temp_pal[palreg] = (byte)green;
                    }
                } else if (usereg == 2) {
                    if ((temp_pal[palreg] & 0xFF) < blue) {
                        temp_pal[palreg] = (byte)tmpreg1;
                        if ((temp_pal[palreg] & 0xFF) > blue) {
                            temp_pal[palreg] = (byte)blue;
                        }
                    } else if ((temp_pal[palreg] & 0xFF) > blue && ((temp_pal[palreg] = (byte)tmpreg2) & 0xFF) < blue) {
                        temp_pal[palreg] = (byte)blue;
                    }
                }
                if (++usereg <= 2) continue;
                usereg = 0;
            }
            WANG_SCREEN_FADE.set(red, green, blue, pp.FadeAmt);
            WANG_SCREEN_FADE.setPalette(temp_pal);
            if (startcolor == 210 || startcolor == 148 || startcolor == 256) {
                PaletteManager paletteManager = Main.engine.getPaletteManager();
                Main.engine.setbrightness(paletteManager.getPaletteGamma(), temp_pal);
                if (Main.game.currentDef != null) {
                    TextureHDInfo hdInfo = Main.game.currentDef.texInfo;
                    if (startcolor == 210) {
                        hdInfo.setPaletteTint(255, 200, 240, 255, 0);
                    } else if (startcolor == 148) {
                        hdInfo.setPaletteTint(255, 230, 255, 150, 0);
                    } else {
                        hdInfo.setPaletteTint(255, 255, 255, 255, 0);
                    }
                }
            }
            if (damage < -1000) {
                pp.FadeAmt = 1000;
            }
        }
    }

    public static void DoPaletteFlash(PlayerStr pp) {
        if (pp.FadeAmt <= 1) {
            pp.FadeAmt = 0;
            pp.StartColor = 0;
            if (pp == Game.Player[Game.screenpeek]) {
                Palette.ResetPalette(pp, 256);
                Palette.DoPlayerDivePalette(pp);
                Palette.DoPlayerNightVisionPalette(pp);
            }
            return;
        }
        pp.FadeTics += 3;
        if (pp.FadeTics >= 5) {
            while (pp.FadeTics >= 5) {
                pp.FadeTics -= 5;
                --pp.FadeAmt;
            }
        } else {
            return;
        }
        if (pp.FadeAmt > 32) {
            return;
        }
        if (pp.FadeAmt <= 1) {
            pp.FadeAmt = 0;
            pp.StartColor = 0;
            if (pp == Game.Player[Game.screenpeek]) {
                Palette.ResetPalette(pp, 256);
                Palette.DoPlayerDivePalette(pp);
                Palette.DoPlayerNightVisionPalette(pp);
            }
        } else if (pp == Game.Player[Game.screenpeek]) {
            byte[] palette = Main.engine.getPaletteManager().getBasePalette();
            byte[] temp_pal = WANG_SCREEN_FADE.getPalette();
            for (int palreg = 0; palreg < 768; ++palreg) {
                int palcol = temp_pal[palreg] & 0xFF;
                int tmpreg1 = Math.min(255, palcol + 2);
                int tmpreg2 = Math.max(0, palcol - 2);
                int baseCol = palette[palreg] & 0xFF;
                if (palcol < baseCol) {
                    temp_pal[palreg] = (byte)tmpreg1;
                    if ((temp_pal[palreg] & 0xFF) <= baseCol) continue;
                    temp_pal[palreg] = palette[palreg];
                    continue;
                }
                if (palcol <= baseCol) continue;
                temp_pal[palreg] = (byte)tmpreg2;
                if ((temp_pal[palreg] & 0xFF) >= baseCol) continue;
                temp_pal[palreg] = palette[palreg];
            }
            int startColor = pp.StartColor & 0xFF;
            WANG_SCREEN_FADE.set(temp_pal[3 * startColor], temp_pal[3 * startColor + 1], temp_pal[3 * startColor + 2], pp.FadeAmt);
            WANG_SCREEN_FADE.setPalette(temp_pal);
        }
    }

    public static void DoPlayerDivePalette(PlayerStr pp) {
        if (pp != Game.Player[Game.screenpeek]) {
            return;
        }
        if ((pp.DeathType == 5 || MyTypes.TEST(Game.Player[Game.screenpeek].Flags, Gameutils.PF_DIVING)) && !MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING_IN_LAVA)) {
            Palette.SetFadeAmt(pp, -1005, 210);
        } else if ((pp.StartColor & 0xFF) == 210) {
            Palette.ResetPalette(pp, 256);
            pp.FadeAmt = 0;
        }
    }

    public static void DoPlayerNightVisionPalette(PlayerStr pp) {
        if (pp != Game.Player[Game.screenpeek]) {
            return;
        }
        if (pp.InventoryActive[3]) {
            Palette.SetFadeAmt(pp, -1005, 148);
            pp.NightVision = true;
        } else {
            if ((pp.StartColor & 0xFF) == 148) {
                Palette.ResetPalette(pp, 256);
                pp.FadeAmt = 0;
            }
            pp.NightVision = false;
        }
    }

    public static void ResetPalette(PlayerStr pp, int color) {
        pp.StartColor = 0;
        if (Main.game.currentDef != null) {
            TextureHDInfo hdInfo = Main.game.currentDef.texInfo;
            hdInfo.setPaletteTint(255, 255, 255, 255, 0);
        }
        PaletteManager paletteManager = Main.engine.getPaletteManager();
        WANG_SCREEN_FADE.set(0, 0, 0, 0);
        WANG_SCREEN_FADE.setPalette(paletteManager.getBasePalette());
        if (color == 210 || color == 148 || color == 256) {
            Main.engine.setbrightness(paletteManager.getPaletteGamma(), paletteManager.getBasePalette());
        }
    }
}

