/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import com.badlogic.gdx.Gdx;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Break;
import ru.m210projects.Wang.Draw;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Inv;
import ru.m210projects.Wang.JPlayer;
import ru.m210projects.Wang.JSector;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.LoadSave;
import ru.m210projects.Wang.MClip;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Quake;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.Func;
import ru.m210projects.Wang.Type.Input;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.List;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.Panel_Sprite_Func;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Remote_Control;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.Target_Sort;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Vis;
import ru.m210projects.Wang.Warp;
import ru.m210projects.Wang.Weapon;
import ru.m210projects.Wang.Weapons.Chops;
import ru.m210projects.Wang.Weapons.Fist;
import ru.m210projects.Wang.Weapons.Grenade;
import ru.m210projects.Wang.Weapons.Heart;
import ru.m210projects.Wang.Weapons.HotHead;
import ru.m210projects.Wang.Weapons.Micro;
import ru.m210projects.Wang.Weapons.Mine;
import ru.m210projects.Wang.Weapons.Rail;
import ru.m210projects.Wang.Weapons.Shotgun;
import ru.m210projects.Wang.Weapons.Star;
import ru.m210projects.Wang.Weapons.Sword;
import ru.m210projects.Wang.Weapons.Uzi;

public class Player {
    public static final Animator QueueFloorBlood = new Animator(Weapon::QueueFloorBlood);
    private static final Animator DoFootPrints = new Animator(Player::DoFootPrints);
    private static final Animator DoPlayerSpriteReset = new Animator(Player::DoPlayerSpriteReset);
    public static final int SO_DRIVE_SOUND = 2;
    public static final int SO_IDLE_SOUND = 1;
    public static final int PLAYER_HORIZ_MAX = 299;
    public static final int PLAYER_HORIZ_MIN = -99;
    public static final int PLAYER_HEIGHT = Gameutils.Z(58);
    public static final int PLAYER_CRAWL_HEIGHT = Gameutils.Z(36);
    public static final int PLAYER_SWIM_HEIGHT = Gameutils.Z(26);
    public static final int PLAYER_DIVE_HEIGHT = Gameutils.Z(26);
    public static final int PLAYER_STEP_HEIGHT = Gameutils.Z(30);
    public static final int PLAYER_CRAWL_STEP_HEIGHT = Gameutils.Z(8);
    public static final int PLAYER_DIVE_STEP_HEIGHT = Gameutils.Z(8);
    public static final int PLAYER_JUMP_STEP_HEIGHT = Gameutils.Z(48);
    public static final int PLAYER_FALL_STEP_HEIGHT = Gameutils.Z(24);
    public static final int PLAYER_RUN_FLOOR_DIST = PLAYER_HEIGHT - PLAYER_STEP_HEIGHT;
    public static final int PLAYER_CRAWL_FLOOR_DIST = PLAYER_CRAWL_HEIGHT - PLAYER_CRAWL_STEP_HEIGHT;
    public static final int PLAYER_WADE_FLOOR_DIST = PLAYER_HEIGHT - PLAYER_STEP_HEIGHT;
    public static final int PLAYER_JUMP_FLOOR_DIST = PLAYER_HEIGHT - PLAYER_JUMP_STEP_HEIGHT;
    public static final int PLAYER_FALL_FLOOR_DIST = PLAYER_HEIGHT - PLAYER_FALL_STEP_HEIGHT;
    public static final int PLAYER_DIVE_FLOOR_DIST = PLAYER_DIVE_HEIGHT - PLAYER_DIVE_STEP_HEIGHT;
    public static final int PLAYER_RUN_CEILING_DIST = Gameutils.Z(10);
    public static final int PLAYER_DIVE_CEILING_DIST = Gameutils.Z(22);
    public static final int PLAYER_CRAWL_CEILING_DIST = Gameutils.Z(12);
    public static final int PLAYER_JUMP_CEILING_DIST = Gameutils.Z(4);
    public static final int PLAYER_FALL_CEILING_DIST = Gameutils.Z(4);
    public static final int PLAYER_WADE_CEILING_DIST = Gameutils.Z(4);
    public static final int PLAYER_DIVE_MAX_SPEED = 1700;
    public static final int PLAYER_DIVE_INC = 600;
    public static final int PLAYER_DIVE_BOB_AMT = Gameutils.Z(8);
    public static final int PLAYER_DIVE_TIME = 1440;
    public static final int PLAYER_DIVE_DAMAGE_TIME = 50;
    public static final int PLAYER_FLY_MAX_SPEED = 2560;
    public static final int PLAYER_FLY_INC = 1000;
    public static final int PLAYER_FLY_BOB_AMT = Gameutils.Z(12);
    public static final int PLAYER_FALL_HEIGHT = Gameutils.Z(28);
    public static final int PLAYER_DEATH_HEIGHT = Gameutils.Z(16);
    public static final int PLAYER_DEAD_HEAD_FLOORZ_OFFSET = Gameutils.Z(7);
    public static final int PLAYER_NINJA_XREPEAT = 47;
    public static final int PLAYER_NINJA_YREPEAT = 33;
    public static final int PLAYER_MIN_HEIGHT = Gameutils.Z(20);
    public static final int PLAYER_CRAWL_WADE_DEPTH = 30;
    public static final int PLAYER_TURN_SCALE = 12;
    public static final int PLAYER_RUN_FRICTION = 50000;
    public static final int PLAYER_JUMP_FRICTION = 50000;
    public static final int PLAYER_FALL_FRICTION = 50000;
    public static final int PLAYER_WADE_FRICTION = 50000;
    public static final int PLAYER_FLY_FRICTION = 55808;
    public static final int PLAYER_CRAWL_FRICTION = 45056;
    public static final int PLAYER_DIVE_FRICTION = 49152;
    public static final int PLAYER_CLIMB_FRICTION = 45056;
    public static final int BOAT_FRICTION = 51968;
    public static final int TANK_FRICTION = 53248;
    public static final int PLAYER_SLIDE_FRICTION = 53248;
    public static final int PLAYER_JUMP_GRAV = 24;
    public static final int PLAYER_JUMP_AMT = -650;
    public static final int PLAYER_CLIMB_JUMP_AMT = -1100;
    public static final int MAX_JUMP_DURATION = 12;
    public static final int PlayerGravity = 24;
    public static final int PLAYER_STANDING_ROOM = Gameutils.Z(68);
    public static final int PLAYER_NINJA_RATE = 14;
    public static final int PLAYER_NINJA_STAND_RATE = 10;
    public static final int PLAYER_NINJA_JUMP_RATE = 24;
    public static final int PLAYER_NINJA_FALL_RATE = 16;
    public static final int PLAYER_NINJA_CLIMB_RATE = 20;
    public static final int PLAYER_NINJA_CRAWL_RATE = 14;
    public static final int PLAYER_NINJA_SWIM_RATE = 22;
    public static final int NINJA_HeadHurl_RATE = 16;
    public static final int NINJA_Head_RATE = 16;
    public static final int NINJA_HeadFly = 1134;
    public static final int NINJA_HeadFly_RATE = 16;
    public static final int NINJA_HeadHurl_FRAMES = 1;
    public static final int NINJA_HeadHurl_R0 = 1147;
    public static final int NINJA_HeadHurl_R1 = 1148;
    public static final int NINJA_HeadHurl_R2 = 1149;
    public static final int NINJA_HeadHurl_R3 = 1150;
    public static final int NINJA_HeadHurl_R4 = 1151;
    private static final State[][] s_PlayerHeadHurl = new State[][]{{new State(1147, 16, null).setNext()}, {new State(1148, 16, null).setNext()}, {new State(1149, 16, null).setNext()}, {new State(1150, 16, null).setNext()}, {new State(1151, 16, null).setNext()}};
    public static final int NINJA_DIE_RATE = 22;
    public static final int PLAYER_NINJA_FLY_RATE = 15;
    public static final int PLAYER_NINJA_FLY_R0 = 1200;
    public static final int PLAYER_NINJA_FLY_R1 = 1200;
    public static final int PLAYER_NINJA_FLY_R2 = 1200;
    public static final int PLAYER_NINJA_FLY_R3 = 1200;
    public static final int PLAYER_NINJA_FLY_R4 = 1200;
    public static final Panel_Sprite_Func pSetVisNorm = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            Player.SetVisNorm();
        }
    };
    public static final int PICK_DIST = 40000;
    public static final int HORIZ_SPEED = 16;
    public static final int MAX_SUICIDE = 11;
    public static final int MAX_KILL_NOTES = 16;
    public static final int PLAYER_DEATH_HORIZ_UP_VALUE = 165;
    public static final int PLAYER_DEATH_HORIZ_JUMP_VALUE = 150;
    public static final int PLAYER_DEATH_HORIZ_FALL_VALUE = 50;
    public static final String MSG_GAME_PAUSED = "Game Paused";
    private static final int PLAYER_NINJA_SWORD_RATE = 12;
    private static final int PLAYER_NINJA_PUNCH_RATE = 15;
    private static final int TURN_SHIFT = 2;
    private static final int ADJ_AMT = 8;
    private static final short[] angles = new short[]{30, -30};
    private static final int PLAYER_DEATH_GRAV = 8;
    private static final String[] SuicideNote = new String[]{"decided to do the graveyard tour.", "had enough and checked out.", "didn't fear the Reaper.", "dialed the 1-800-CYANIDE line.", "wasted himself.", "kicked his own ass.", "went out in blaze of his own glory.", "killed himself before anyone else could.", "needs shooting lessons.", "blew his head off.", "did everyone a favor and offed himself."};
    private static final Player_Action_Func[] PlayerDeathFunc = new Player_Action_Func[]{Player_Action_Func.DoPlayerDeathFlip, Player_Action_Func.DoPlayerDeathCrumble, Player_Action_Func.DoPlayerDeathExplode, Player_Action_Func.DoPlayerDeathFlip, Player_Action_Func.DoPlayerDeathExplode, Player_Action_Func.DoPlayerDeathDrown};
    private static final int ChopTimer = 3600;
    public static int NormalVisibility;
    public static final Target_Sort[] TargetSort;
    public static int TargetSortCount;
    private static final State[][] s_PlayerNinjaRun;
    private static final State[][] s_PlayerNinjaStand;
    private static final State[][] s_PlayerNinjaJump;
    private static final State[][] s_PlayerNinjaFall;
    private static final State[][] s_PlayerNinjaClimb;
    private static final State[][] s_PlayerNinjaCrawl;
    private static final State[][] s_PlayerNinjaSwim;
    private static final State[][] s_PlayerHeadFly;
    private static final State[][] s_PlayerHead;
    private static final State[][] s_PlayerDeath;
    private static final State[][] s_PlayerNinjaSword;
    private static final State[][] s_PlayerNinjaPunch;
    private static final State[][] s_PlayerNinjaFly;
    private static int count;
    private static final int[] x;
    private static final int[] y;
    private static final int[] ox;
    private static final int[] oy;
    private static VOC3D handle;
    private static final int[] angs;
    private static final int[] sf;
    private static final int[] UnderStatList;
    private static final boolean[] SpawnPositionUsed;
    private static final int[] MultiStatList;

    public static void InitPlayerStates() {
        for (PlayerStateGroup sg : PlayerStateGroup.values()) {
            for (int rot = 0; rot < 5; ++rot) {
                State.InitState(sg.group[rot]);
            }
        }
    }

    public static void DoPlayerSpriteThrow(PlayerStr pp) {
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING | Gameutils.PF_FLYING | Gameutils.PF_CRAWLING)) {
            USER pu = Gameutils.getUser(pp.PlayerSprite);
            if (pp.CurWpn == pp.Wpn[13] && pu != null && pu.getRot() != PlayerStateGroup.sg_PlayerNinjaSword) {
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaSword);
            } else {
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaPunch);
            }
        }
    }

    public static void DoPlayerSpriteReset(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null || u.PlayerP == -1) {
            return;
        }
        PlayerStr pp = Game.Player[u.PlayerP];
        if (pp.DoPlayerAction == Player_Action_Func.DoPlayerCrawl) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Crawl);
        } else if (MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
        } else {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
        }
    }

    public static void SetVisHigh() {
    }

    public static void SetVisNorm() {
    }

    public static int GetDeltaAngle(int ang1, int ang2) {
        if (Pragmas.klabs(ang1 - ang2) > 1024) {
            if (ang1 <= 1024) {
                ang1 += 2048;
            }
            if (ang2 <= 1024) {
                ang2 += 2048;
            }
        }
        return ang1 - ang2;
    }

    public static int DoPickTarget(int spnum, int max_delta_ang, int skip_targets) {
        WangSprite sp = Main.boardService.getSprite(spnum);
        if (sp == null) {
            return 0;
        }
        USER u = Gameutils.getUser(spnum);
        if (max_delta_ang == 0) {
            max_delta_ang = 1;
        }
        TargetSortCount = 0;
        if (TargetSort[0] == null) {
            Player.TargetSort[0] = new Target_Sort();
        }
        Player.TargetSort[0].sprite_num = -1;
        for (int j : Weapon.StatDamageList) {
            ListNode<Sprite> node = Main.boardService.getStatNode(j);
            while (node != null) {
                ListNode<Sprite> nexti;
                block10: {
                    Target_Sort ts;
                    int ndx;
                    int delta_ang;
                    int dist;
                    int i;
                    block12: {
                        block11: {
                            i = node.getIndex();
                            nexti = node.getNext();
                            Sprite ep = node.get();
                            USER eu = Gameutils.getUser(i);
                            if (eu == null || i == spnum || skip_targets != 2 && (skip_targets != 0 && MyTypes.TEST(eu.Flags, Gameutils.SPR_TARGETED) || eu.PlayerP != -1 && MyTypes.TEST(Game.Player[eu.PlayerP].Flags, Gameutils.PF_DEAD)) || (dist = Gameutils.FindDistance3D(sp.getX() - ep.getX(), sp.getY() - ep.getY(), sp.getZ() - ep.getZ() >> 4)) > 40000 || skip_targets != 2 && !MyTypes.TEST(ep.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY)) break block10;
                            int angle2 = Gameutils.NORM_ANGLE(EngineUtils.getAngle(ep.getX() - sp.getX(), ep.getY() - sp.getY()));
                            delta_ang = Pragmas.klabs(Player.GetDeltaAngle(sp.getAng(), angle2));
                            if (delta_ang > max_delta_ang) break block10;
                            int zh = u != null && u.PlayerP != -1 ? Game.Player[u.PlayerP].posz : Gameutils.SPRITEp_TOS(sp) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp));
                            int ezh = Gameutils.SPRITEp_TOS(ep) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(ep));
                            int ezhm = Gameutils.SPRITEp_TOS(ep) + MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(ep));
                            int ezhl = Gameutils.SPRITEp_BOS(ep) - MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(ep));
                            if (!Rooms.FAFcansee(sp.getX(), sp.getY(), zh, sp.getSectnum(), ep.getX(), ep.getY(), ezh, ep.getSectnum()) && !Rooms.FAFcansee(sp.getX(), sp.getY(), zh, sp.getSectnum(), ep.getX(), ep.getY(), ezhm, ep.getSectnum()) && !Rooms.FAFcansee(sp.getX(), sp.getY(), zh, sp.getSectnum(), ep.getX(), ep.getY(), ezhl, ep.getSectnum())) break block10;
                            if (TargetSortCount <= TargetSort.length - 1) break block11;
                            for (ndx = 0; ndx < TargetSort.length && ((ts = TargetSort[ndx]) == null || dist >= ts.dist); ++ndx) {
                            }
                            if (ndx != TargetSort.length) break block12;
                            break block10;
                        }
                        ndx = TargetSortCount;
                    }
                    if (TargetSort[ndx] == null) {
                        Player.TargetSort[ndx] = new Target_Sort();
                    }
                    ts = TargetSort[ndx];
                    ts.sprite_num = i;
                    ts.dang = delta_ang;
                    ts.dist = dist;
                    int ang_weight = (max_delta_ang - ts.dang << 16) / max_delta_ang;
                    int dist_weight = (MyTypes.DIV2(40000) - MyTypes.DIV2(ts.dist) << 16) / MyTypes.DIV2(40000);
                    ts.weight = (ang_weight + dist_weight * 4) / 5;
                    if (++TargetSortCount >= TargetSort.length) {
                        TargetSortCount = TargetSort.length;
                    }
                }
                node = nexti;
            }
        }
        if (TargetSortCount > 1) {
            Arrays.sort(TargetSort, 0, TargetSortCount);
        }
        if (TargetSort[0] != null) {
            return Player.TargetSort[0].sprite_num;
        }
        return -1;
    }

    public static void DoPlayerResetMovement(PlayerStr pp) {
        pp.xvect = 0;
        pp.yvect = 0;
        pp.oxvect = 0;
        pp.slide_xvect = 0;
        pp.slide_yvect = 0;
        pp.drive_angvel = 0.0f;
        pp.drive_oangvel = 0.0f;
        pp.Flags &= ~Gameutils.PF_PLAYER_MOVED;
    }

    public static void DoPlayerTeleportPause(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        pp.lastcursectnum = pp.cursectnum;
        if (u != null && (u.WaitTics -= 3) <= 0) {
            pp.Flags2 &= ~Gameutils.PF2_TELEPORTED;
            Player.DoPlayerResetMovement(pp);
            Player.DoPlayerBeginRun(pp);
        }
    }

    public static void DoPlayerTeleportToSprite(PlayerStr pp, Sprite sp) {
        pp.pang = pp.oang = (float)sp.getAng();
        pp.oposx = pp.oldposx = sp.getX();
        pp.posx = pp.oldposx;
        pp.oposy = pp.oldposy = sp.getY();
        pp.posy = pp.oldposy;
        pp.posz = pp.oposz = sp.getZ() - PLAYER_HEIGHT;
        pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
        pp.Flags2 |= Gameutils.PF2_TELEPORTED;
    }

    public static void DoPlayerTeleportToOffset(PlayerStr pp) {
        pp.oposx = pp.oldposx = pp.posx;
        pp.oposy = pp.oldposy = pp.posy;
        pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
        pp.Flags2 |= Gameutils.PF2_TELEPORTED;
    }

    public static void DoSpawnTeleporterEffect(Sprite sp) {
        int nx = Gameutils.MOVEx(512, sp.getAng());
        int ny = Gameutils.MOVEy(512, sp.getAng());
        int effect = Sprites.SpawnSprite(4, 0, Weapon.s_TeleportEffect[0], sp.getSectnum(), nx += sp.getX(), ny += sp.getY(), Gameutils.SPRITEp_TOS(sp) + Gameutils.Z(16), sp.getAng(), 0);
        WangSprite ep = Main.boardService.getSprite(effect);
        if (ep == null) {
            return;
        }
        Main.engine.setspritez(effect, ep.getX(), ep.getY(), ep.getZ());
        ep.setShade(-40);
        ep.setXrepeat(42);
        ep.setYrepeat(42);
        ep.setCstat(ep.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        ep.setCstat(ep.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        ep.setCstat(ep.getCstat() | Gameutils.CSTAT_SPRITE_WALL);
    }

    public static void DoSpawnTeleporterEffectPlace(Sprite sp) {
        int effect = Sprites.SpawnSprite(4, 0, Weapon.s_TeleportEffect[0], sp.getSectnum(), sp.getX(), sp.getY(), Gameutils.SPRITEp_TOS(sp) + Gameutils.Z(16), sp.getAng(), 0);
        WangSprite ep = Main.boardService.getSprite(effect);
        if (ep == null) {
            return;
        }
        Main.engine.setspritez(effect, ep.getX(), ep.getY(), ep.getZ());
        ep.setShade(-40);
        ep.setXrepeat(42);
        ep.setYrepeat(42);
        ep.setCstat(ep.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        ep.setCstat(ep.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        ep.setCstat(ep.getCstat() | Gameutils.CSTAT_SPRITE_WALL);
    }

    public static void DoPlayerWarpTeleporter(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        Sprite sp = pp.getSprite();
        Sprite sp_warp = Warp.WarpM(pp.posx, pp.posy, pp.posz, pp.cursectnum);
        if (sp == null || u == null || sp_warp == null) {
            return;
        }
        pp.posx = Warp.warp.x;
        pp.posy = Warp.warp.y;
        pp.posz = Warp.warp.z;
        pp.cursectnum = Warp.warp.sectnum;
        if (Gameutils.SP_TAG3(sp_warp) == 1) {
            Player.DoPlayerTeleportToOffset(pp);
            Player.UpdatePlayerSprite(pp);
        } else {
            Player.DoPlayerTeleportToSprite(pp, sp_warp);
            Sound.PlaySound(207, pp, 0);
            Player.DoPlayerResetMovement(pp);
            u.WaitTics = 30;
            Player.DoPlayerBeginRun(pp);
            pp.DoPlayerAction = Player_Action_Func.DoPlayerTeleportPause;
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
            Player.UpdatePlayerSprite(pp);
            Player.DoSpawnTeleporterEffect(sp);
            short pnum = Mmulti.connecthead;
            while (pnum != -1) {
                if (Game.Player[pnum] != pp) {
                    PlayerStr npp = Game.Player[pnum];
                    if (npp.cursectnum == pp.cursectnum) {
                        Panel.PlayerUpdateHealth(npp, -u.Health);
                        Weapon.PlayerCheckDeath(npp, pp.PlayerSprite);
                    }
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
        }
        u.ox = sp.getX();
        u.oy = sp.getY();
        u.oz = sp.getZ();
    }

    public static void DoPlayerSetWadeDepth(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(pp.lo_sectp);
        Sect_User su = Sector.getSectUser(pp.lo_sectp);
        pp.WadeDepth = 0;
        if (su == null || sectp == null) {
            return;
        }
        if (MyTypes.TEST(sectp.getExtra(), Gameutils.SECTFX_SINK) && pp.posz + PLAYER_HEIGHT > sectp.getFloorz() - Gameutils.Z(su.depth)) {
            pp.WadeDepth = su.depth;
        }
    }

    public static void DoPlayerHeight(PlayerStr pp) {
        int diff = pp.posz - (pp.loz - PLAYER_HEIGHT);
        pp.posz -= MyTypes.DIV4(diff) + MyTypes.DIV8(diff);
    }

    public static void DoPlayerJumpHeight(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(pp.lo_sectp);
        if (sectp != null && MyTypes.TEST(sectp.getExtra(), Gameutils.SECTFX_DYNAMIC_AREA) && pp.posz + PLAYER_HEIGHT > pp.loz) {
            pp.posz = pp.loz - PLAYER_HEIGHT;
            Player.DoPlayerBeginRun(pp);
        }
    }

    public static void DoPlayerCrawlHeight(PlayerStr pp) {
        int diff = pp.posz - (pp.loz - PLAYER_CRAWL_HEIGHT);
        pp.posz -= MyTypes.DIV4(diff) + MyTypes.DIV8(diff);
    }

    public static void DoPlayerTurn(PlayerStr pp) {
        float angvel;
        WangSprite underwaterSpr;
        int delta_ang;
        Sprite ppSpr = pp.getSprite();
        if (ppSpr == null) {
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_TURN_180)) {
            if (Gameutils.TEST_SYNC_KEY(pp, 25)) {
                if (Gameutils.FLAG_KEY_PRESSED(pp, 25)) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 25);
                    pp.turn180_target = Gameutils.NORM_ANGLE(pp.getAnglei() + 1024);
                    delta_ang = Player.GetDeltaAngle(pp.turn180_target, pp.getAnglei());
                    pp.pang = Gameutils.NORM_ANGLE(pp.getAnglei() + (Pragmas.klabs(delta_ang) >> 2));
                    pp.Flags |= Gameutils.PF_TURN_180;
                }
            } else {
                Gameutils.FLAG_KEY_RESET(pp, 25);
            }
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_TURN_180)) {
            delta_ang = Player.GetDeltaAngle(pp.turn180_target, pp.getAnglei());
            if (!Game.isOriginal()) {
                pp.pang += (float)(delta_ang >> 2);
                pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
            } else {
                pp.pang = Gameutils.NORM_ANGLE(pp.getAnglei() + (delta_ang >> 2));
            }
            ppSpr.setAng(pp.getAnglei());
            if (!WangNetwork.Prediction && (underwaterSpr = Main.boardService.getSprite(pp.PlayerUnderSprite)) != null) {
                underwaterSpr.setAng(pp.getAnglei());
            }
            if (Pragmas.klabs(delta_ang = Player.GetDeltaAngle(pp.turn180_target, pp.getAnglei())) < 12) {
                pp.pang = pp.turn180_target;
                pp.Flags &= ~Gameutils.PF_TURN_180;
            } else {
                return;
            }
        }
        if ((angvel = pp.input.angvel * 12.0f) != 0.0f) {
            if (!Game.isOriginal()) {
                angvel += angvel / 4.0f;
                pp.pang += angvel * 3.0f / 32.0f;
                pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
            } else {
                angvel += (float)MyTypes.DIV4((int)angvel);
                pp.pang += (float)MyTypes.DIV32((int)angvel * 3);
                pp.pang = Gameutils.NORM_ANGLE(pp.getAnglei());
            }
            ppSpr.setAng(pp.getAnglei());
            if (!WangNetwork.Prediction && (underwaterSpr = Main.boardService.getSprite(pp.PlayerUnderSprite)) != null) {
                underwaterSpr.setAng(pp.getAnglei());
            }
        }
    }

    public static void DoPlayerTurnBoat(PlayerStr pp) {
        float angvel;
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.drive_angspeed != 0) {
            pp.drive_oangvel = pp.drive_angvel;
            pp.drive_angvel = Pragmas.mulscale((int)pp.input.angvel, sop.drive_angspeed, 16);
            int angslide = sop.drive_angslide;
            angvel = pp.drive_angvel = (float)((int)((pp.drive_angvel + pp.drive_oangvel * (float)(angslide - 1)) / (float)angslide));
        } else {
            angvel = pp.input.angvel * 12.0f;
            if (!Game.isOriginal()) {
                angvel += angvel - angvel / 4.0f;
                angvel = angvel * 3.0f / 32.0f;
            } else {
                angvel += angvel - (float)MyTypes.DIV4((int)angvel);
                angvel = MyTypes.DIV32((int)angvel * 3);
            }
        }
        if (angvel != 0.0f) {
            if (!Game.isOriginal()) {
                pp.pang += angvel;
                pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
            } else {
                pp.pang = Gameutils.NORM_ANGLE((int)((float)pp.getAnglei() + angvel));
            }
            Sprite s = pp.getSprite();
            if (s != null) {
                s.setAng(pp.getAnglei());
            }
        }
    }

    public static void DoPlayerTurnTank(PlayerStr pp, int z, int floor_dist) {
        float angvel;
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.drive_angspeed != 0) {
            pp.drive_oangvel = pp.drive_angvel;
            pp.drive_angvel = Pragmas.mulscale((int)pp.input.angvel, sop.drive_angspeed, 16);
            long angslide = sop.drive_angslide;
            angvel = pp.drive_angvel = (float)((int)((pp.drive_angvel + pp.drive_oangvel * (float)(angslide - 1L)) / (float)angslide));
        } else {
            angvel = pp.input.angvel * 3.0f / 8.0f;
        }
        if (angvel != 0.0f && MClip.MultiClipTurn(pp, Gameutils.NORM_ANGLE((int)(pp.getAnglef() + angvel)), z, floor_dist)) {
            if (!Game.isOriginal()) {
                pp.pang += angvel;
                pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
            } else {
                pp.pang = Gameutils.NORM_ANGLE((int)((float)pp.getAnglei() + angvel));
            }
            Sprite s = pp.getSprite();
            if (s != null) {
                s.setAng(pp.getAnglei());
            }
        }
    }

    public static void DoPlayerTurnTankRect(PlayerStr pp, int[] x, int[] y, int[] ox, int[] oy) {
        float angvel;
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.drive_angspeed != 0) {
            pp.drive_oangvel = pp.drive_angvel;
            pp.drive_angvel = Pragmas.mulscale((int)pp.input.angvel, sop.drive_angspeed, 16);
            int angslide = sop.drive_angslide;
            angvel = pp.drive_angvel = (pp.drive_angvel + pp.drive_oangvel * (float)(angslide - 1)) / (float)angslide;
        } else {
            angvel = pp.input.angvel * 3.0f / 8.0f;
        }
        if (angvel != 0.0f && MClip.RectClipTurn(pp, Gameutils.NORM_ANGLE((int)(pp.getAnglef() + angvel)), x, y, ox, oy)) {
            if (!Game.isOriginal()) {
                pp.pang += angvel;
                pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
            } else {
                pp.pang = Gameutils.NORM_ANGLE((int)((float)pp.getAnglei() + angvel));
            }
            Sprite s = pp.getSprite();
            if (s != null) {
                s.setAng(pp.getAnglei());
            }
        }
    }

    public static void DoPlayerTurnTurret(PlayerStr pp) {
        float angvel;
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (!WangNetwork.Prediction) {
            int fifo_ndx = Main.game.pNet.gNetFifoTail - 2 & 0xFF;
            Input last_input = (Input)Main.game.pNet.gFifoInput[fifo_ndx][pp.pnum];
            if (pp.input.angvel != 0.0f && last_input.angvel == 0.0f) {
                Player.PlaySOsound(sop.mid_sector, 2);
            } else if (pp.input.angvel == 0.0f && last_input.angvel != 0.0f) {
                Player.PlaySOsound(sop.mid_sector, 1);
            }
        }
        if (sop.drive_angspeed != 0) {
            pp.drive_oangvel = pp.drive_angvel;
            pp.drive_angvel = pp.input.angvel * (float)sop.drive_angspeed / 65536.0f;
            int angslide = sop.drive_angslide;
            angvel = pp.drive_angvel = (pp.drive_angvel + pp.drive_oangvel * (float)(angslide - 1)) / (float)angslide;
        } else {
            angvel = pp.input.angvel * 3.0f / 4.0f;
        }
        if (angvel != 0.0f) {
            int diff;
            float new_ang = pp.getAnglef() + angvel;
            new_ang = Game.isOriginal() ? (float)Gameutils.NORM_ANGLE((int)((float)pp.getAnglei() + angvel)) : ru.m210projects.Build.Gameutils.BClampAngle(new_ang);
            if (sop.limit_ang_center >= 0 && Pragmas.klabs(diff = Player.GetDeltaAngle((int)new_ang, sop.limit_ang_center)) >= sop.limit_ang_delta) {
                new_ang = diff < 0 ? (float)(sop.limit_ang_center - sop.limit_ang_delta) : (float)(sop.limit_ang_center + sop.limit_ang_delta);
            }
            pp.pang = new_ang;
            Sprite s = pp.getSprite();
            if (s != null) {
                s.setAng(pp.getAnglei());
            }
        }
    }

    public static void SlipSlope(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(pp.cursectnum);
        if (sec == null) {
            return;
        }
        Sect_User sectu = Sector.getSectUser(pp.cursectnum);
        if (sectu == null || !MyTypes.TEST(sectu.flags, Gameutils.SECTFU_SLIDE_SECTOR) || !MyTypes.TEST(sec.getFloorstat(), Gameutils.FLOOR_STAT_SLOPE)) {
            return;
        }
        if (sec.getWallNode() == null) {
            return;
        }
        Wall wal = sec.getWallNode().get();
        int ang = Gameutils.NORM_ANGLE(wal.getWallAngle() + 512);
        pp.xvect += Pragmas.mulscale(EngineUtils.cos(ang), sec.getFloorheinum(), sectu.speed);
        pp.yvect += Pragmas.mulscale(EngineUtils.sin(ang), sec.getFloorheinum(), sectu.speed);
    }

    private static void PlayerAutoLook(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(pp.cursectnum);
        if (sec == null) {
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_FLYING | Gameutils.PF_SWIMMING | Gameutils.PF_DIVING | Gameutils.PF_CLIMBING | Gameutils.PF_JUMPING | Gameutils.PF_FALLING) && MyTypes.TEST(sec.getFloorstat(), Gameutils.FLOOR_STAT_SLOPE)) {
            int y;
            int x;
            if (Game.isOriginal()) {
                x = pp.posx + (EngineUtils.sin(pp.getAnglei() + 512 & 0x7FF) >> 5);
                y = pp.posy + (EngineUtils.sin(pp.getAnglei() & 0x7FF) >> 5);
            } else {
                x = (int)((double)pp.posx + ru.m210projects.Build.Gameutils.BCosAngle(pp.getAnglef()) / 32.0);
                y = (int)((double)pp.posy + ru.m210projects.Build.Gameutils.BSinAngle(pp.getAnglef()) / 32.0);
            }
            int tempsect = Rooms.COVERupdatesector(x, y, pp.cursectnum);
            if (tempsect >= 0) {
                int j = Main.engine.getflorzofslope(pp.cursectnum, pp.posx, pp.posy);
                int k = Main.engine.getflorzofslope(pp.cursectnum, x, y);
                if (pp.cursectnum == tempsect || Pragmas.klabs(Main.engine.getflorzofslope(tempsect, x, y) - k) <= 1024) {
                    pp.horizoff += (float)((j - k) * 160 >> 16);
                }
            }
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_CLIMBING)) {
            if (pp.horizoff < 100.0f) {
                pp.horizoff = Game.isOriginal() ? (pp.horizoff += (float)((100 - (int)pp.horizoff >> 3) + 1)) : (pp.horizoff += (100.0f - pp.horizoff) / 8.0f + 1.0f);
            }
        } else {
            if (pp.horizoff > 0.0f) {
                pp.horizoff = Game.isOriginal() ? (pp.horizoff -= (float)(((int)pp.horizoff >> 3) + 1)) : (pp.horizoff -= pp.horizoff / 8.0f + 1.0f);
            }
            if (pp.horizoff < 0.0f) {
                if (Game.isOriginal()) {
                    PlayerStr playerStr = pp;
                    playerStr.horizoff = playerStr.horizoff + (float)(((int)(-pp.horizoff) >> 3) + 1);
                } else {
                    PlayerStr playerStr = pp;
                    playerStr.horizoff = playerStr.horizoff + (-pp.horizoff / 8.0f + 1.0f);
                }
            }
        }
    }

    public static void DoPlayerHorizon(PlayerStr pp) {
        if (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_NONE && (Main.cfg.SlopeTilting || !Main.cfg.isgMouseAim())) {
            Player.PlayerAutoLook(pp);
        }
        if (pp.input.aimvel != 0.0f) {
            pp.horizbase += pp.input.aimvel;
            pp.Flags |= Gameutils.PF_LOCK_HORIZ | Gameutils.PF_LOOKING;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 8)) {
            pp.horizbase = 100.0f;
            pp.horiz = 100.0f;
            pp.horizoff = 0.0f;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 21) || Gameutils.TEST_SYNC_KEY(pp, 22)) {
            pp.Flags |= Gameutils.PF_LOCK_HORIZ | Gameutils.PF_LOOKING;
            if (Gameutils.TEST_SYNC_KEY(pp, 22)) {
                pp.horizbase -= 8.0f;
            }
            if (Gameutils.TEST_SYNC_KEY(pp, 21)) {
                pp.horizbase += 8.0f;
            }
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 12) || Gameutils.TEST_SYNC_KEY(pp, 13)) {
            pp.Flags &= ~Gameutils.PF_LOCK_HORIZ;
            pp.Flags |= Gameutils.PF_LOOKING;
            if (Gameutils.TEST_SYNC_KEY(pp, 13)) {
                pp.horizbase -= 16.0f;
            }
            if (Gameutils.TEST_SYNC_KEY(pp, 12)) {
                pp.horizbase += 16.0f;
            }
        }
        if (!(MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_HORIZ) || Gameutils.TEST_SYNC_KEY(pp, 12) || Gameutils.TEST_SYNC_KEY(pp, 13))) {
            if (pp.horizbase != 100.0f) {
                for (int i = 1; i != 0; --i) {
                    if (Game.isOriginal()) {
                        pp.horizbase += (float)(25 - ((int)pp.horizbase >> 2));
                        continue;
                    }
                    pp.horizbase += 25.0f - pp.horizbase / 4.0f;
                }
            } else {
                pp.Flags &= ~Gameutils.PF_LOOKING;
            }
        }
        pp.horizbase = Math.max(pp.horizbase, -99.0f);
        pp.horizbase = Math.min(pp.horizbase, 299.0f);
        if (pp.horizbase + pp.horizoff < -99.0f) {
            pp.horizoff = -99.0f - pp.horizbase;
        } else if (pp.horizbase + pp.horizoff > 299.0f) {
            pp.horizoff = 299.0f - pp.horizbase;
        }
        pp.horiz = pp.horizbase + pp.horizoff;
    }

    public static void DoPlayerBob(PlayerStr pp) {
        int amt;
        int dist = Game.Distance(pp.posx, pp.posy, pp.oldposx, pp.oldposy);
        if (dist > 512) {
            dist = 0;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 16) || MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_RUN)) {
            amt = Pragmas.mulscale(12L, (long)dist << 8, 16);
            dist = Pragmas.mulscale(dist, 26000L, 16);
        } else {
            amt = Pragmas.mulscale(5L, (long)dist << 9, 16);
            dist = Pragmas.mulscale(dist, 32000L, 16);
        }
        pp.bcnt += dist;
        pp.bcnt &= 0x7FF;
        pp.bob_z = Pragmas.mulscale(Gameutils.Z(amt), EngineUtils.sin(pp.bcnt), 14);
    }

    public static void DoPlayerBeginRecoil(PlayerStr pp, int pix_amt) {
        pp.Flags |= Gameutils.PF_RECOIL;
        pp.recoil_amt = pix_amt;
        pp.recoil_speed = 80;
        pp.recoil_ndx = 0;
        pp.recoil_horizoff = 0;
    }

    public static void DoPlayerRecoil(PlayerStr pp) {
        pp.recoil_ndx += pp.recoil_speed;
        if (EngineUtils.sin(pp.recoil_ndx) < 0) {
            pp.Flags &= ~Gameutils.PF_RECOIL;
            pp.recoil_horizoff = 0;
            return;
        }
        pp.recoil_horizoff = pp.recoil_amt * EngineUtils.sin(pp.recoil_ndx) >> 14;
    }

    public static void DoPlayerSpriteBob(PlayerStr pp, int player_height, int bob_amt, int bob_speed) {
        Sprite sp = pp.getSprite();
        if (sp == null) {
            return;
        }
        pp.bob_ndx = pp.bob_ndx + (3 << bob_speed) & 0x7FF;
        pp.bob_amt = bob_amt * EngineUtils.sin(pp.bob_ndx) >> 14;
        sp.setZ(pp.posz + player_height + pp.bob_amt);
    }

    public static void UpdatePlayerUnderSprite(PlayerStr pp) {
        Sprite over_sp = pp.getSprite();
        USER over_u = Gameutils.getUser(pp.PlayerSprite);
        if (over_sp == null || over_u == null) {
            return;
        }
        ru.m210projects.Build.Types.Sector over_sec = Main.boardService.getSector(over_sp.getSectnum());
        if (over_sec == null) {
            return;
        }
        if (WangNetwork.Prediction) {
            return;
        }
        int water_level_z = over_sec.getFloorz();
        boolean above_water = Gameutils.SPRITEp_BOS(over_sp) <= water_level_z;
        boolean in_dive_area = Gameutils.SpriteInDiveArea(over_sp);
        if (!in_dive_area || above_water) {
            if (pp.PlayerUnderSprite >= 0) {
                Sprites.KillSprite(pp.PlayerUnderSprite);
                pp.PlayerUnderSprite = -1;
            }
            return;
        }
        if (pp.PlayerUnderSprite < 0) {
            Ninja.SpawnPlayerUnderSprite(pp.pnum);
        }
        int SpriteNum = pp.PlayerUnderSprite;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        sp.setX(over_sp.getX());
        sp.setY(over_sp.getY());
        sp.setZ(over_sp.getZ());
        Main.engine.changespritesect(SpriteNum, over_sp.getSectnum());
        Weapon.SpriteWarpToUnderwater(SpriteNum);
        int zdiff = Gameutils.SPRITEp_BOS(over_sp) - water_level_z;
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sp.getSectnum());
        if (sec != null) {
            sp.setZ(sec.getCeilingz() + zdiff);
        }
        u.State = over_u.State;
        u.setRot(over_u.getRot());
        u.StateStart = over_u.StateStart;
        sp.setPicnum(over_sp.getPicnum());
    }

    public static void UpdatePlayerSprite(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(pp.cursectnum);
        if (sec == null || sp == null) {
            return;
        }
        Main.game.pInt.setsprinterpolate(pp.PlayerSprite, sp);
        sp.setX(pp.posx);
        sp.setY(pp.posy);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
            sp.setAng(pp.getAnglei());
            Player.UpdatePlayerUnderSprite(pp);
            return;
        }
        if (pp.sop_control != -1) {
            sp.setZ(sec.getFloorz());
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerCrawl) {
            sp.setZ(pp.posz + PLAYER_CRAWL_HEIGHT);
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerWade) {
            sp.setZ(pp.posz + PLAYER_HEIGHT);
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
            if (pp.WadeDepth > Gameutils.Z(29)) {
                Player.DoPlayerSpriteBob(pp, PLAYER_HEIGHT, Gameutils.Z(3), 3);
            }
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerDive) {
            sp.setZ(pp.posz + Gameutils.Z(10));
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerClimb) {
            sp.setZ(pp.posz + Gameutils.Z(17));
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerFly) {
            Player.DoPlayerSpriteBob(pp, PLAYER_HEIGHT, Gameutils.Z(6), 3);
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerJump || pp.DoPlayerAction == Player_Action_Func.DoPlayerFall || pp.DoPlayerAction == Player_Action_Func.DoPlayerForceJump) {
            sp.setZ(pp.posz + PLAYER_HEIGHT);
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerTeleportPause) {
            sp.setZ(pp.posz + PLAYER_HEIGHT);
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else {
            sp.setZ(pp.loz);
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        }
        Player.UpdatePlayerUnderSprite(pp);
        sp.setAng((int)pp.pang);
    }

    public static void DoPlayerZrange(PlayerStr pp) {
        Sprite psp = pp.getSprite();
        if (psp == null) {
            return;
        }
        short bakcstat = psp.getCstat();
        psp.setCstat(psp.getCstat() & ~Gameutils.CSTAT_SPRITE_BLOCK);
        Rooms.FAFgetzrange(pp.posx, pp.posy, pp.posz + Gameutils.Z(8), pp.cursectnum, Game.tmp_ptr[0].set(0), Game.tmp_ptr[1].set(0), Game.tmp_ptr[2].set(0), Game.tmp_ptr[3].set(0), (psp.getClipdist() << 2) - 8, Gameutils.CLIPMASK_PLAYER);
        psp.setCstat(bakcstat);
        pp.hiz = Game.tmp_ptr[0].value;
        int ceilhit = Game.tmp_ptr[1].value;
        pp.loz = Game.tmp_ptr[2].value;
        int florhit = Game.tmp_ptr[3].value;
        pp.hi_sectp = -1;
        pp.lo_sectp = -1;
        pp.hi_sp = -1;
        pp.lo_sp = -1;
        if (MyTypes.DTEST(ceilhit, -536870912) == -1073741824) {
            pp.hi_sp = Gameutils.NORM_HIT_INDEX(ceilhit);
        } else {
            pp.hi_sectp = Gameutils.NORM_HIT_INDEX(ceilhit);
        }
        if (MyTypes.DTEST(florhit, -536870912) == -1073741824) {
            pp.lo_sp = Gameutils.NORM_HIT_INDEX(florhit);
            WangSprite loSp = Main.boardService.getSprite(pp.lo_sp);
            USER lou = Gameutils.getUser(pp.lo_sp);
            if (loSp != null && lou != null && loSp.getStatnum() == 2 && lou.ID == 1095) {
                pp.lo_sectp = loSp.getSectnum();
                pp.loz = loSp.getZ();
                pp.lo_sp = -1;
            }
        } else {
            pp.lo_sectp = Gameutils.NORM_HIT_INDEX(florhit);
        }
    }

    private static void DoPlayerSlide(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        Sprite psp = pp.getSprite();
        if (psp == null || (pp.slide_xvect | pp.slide_yvect) == 0) {
            return;
        }
        if (pp.sop != -1) {
            return;
        }
        pp.slide_xvect = Pragmas.mulscale(pp.slide_xvect, 53248L, 16);
        pp.slide_yvect = Pragmas.mulscale(pp.slide_yvect, 53248L, 16);
        if (Pragmas.klabs(pp.slide_xvect) < 12800 && Pragmas.klabs(pp.slide_yvect) < 12800) {
            pp.slide_yvect = 0;
            pp.slide_xvect = 0;
        }
        int push_ret = Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, psp.getClipdist() << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.pushmove_sectnum != -1) {
            pp.posx = Engine.pushmove_x;
            pp.posy = Engine.pushmove_y;
            pp.posz = Engine.pushmove_z;
            pp.cursectnum = Engine.pushmove_sectnum;
        }
        if (push_ret < 0) {
            if (u != null && !MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
            return;
        }
        Main.engine.clipmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.slide_xvect, pp.slide_yvect, psp.getClipdist() << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.clipmove_sectnum != -1) {
            pp.posx = Engine.clipmove_x;
            pp.posy = Engine.clipmove_y;
            pp.posz = Engine.clipmove_z;
            pp.cursectnum = Engine.clipmove_sectnum;
        }
        Player.PlayerCheckValidMove(pp);
        push_ret = Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, psp.getClipdist() << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.pushmove_sectnum != -1) {
            pp.posx = Engine.pushmove_x;
            pp.posy = Engine.pushmove_y;
            pp.posz = Engine.pushmove_z;
            pp.cursectnum = Engine.pushmove_sectnum;
        }
        if (push_ret < 0 && u != null && !MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
            Panel.PlayerUpdateHealth(pp, -u.Health);
            Weapon.PlayerCheckDeath(pp, -1);
        }
    }

    public static void PlayerCheckValidMove(PlayerStr pp) {
        if (pp.cursectnum == -1) {
            pp.posx = pp.oldposx;
            pp.posy = pp.oldposy;
            pp.posz = pp.oldposz;
            pp.cursectnum = pp.lastcursectnum;
            if (count++ > 400) {
                count = 0;
                throw new WarningException("Player stuck");
            }
        }
    }

    public static void DoPlayerMenuKeys(PlayerStr pp) {
        if (Main.game.nNetMode == BuildGame.NetMode.Single) {
            if (Gameutils.TEST_SYNC_KEY(pp, 7)) {
                if (Gameutils.FLAG_KEY_PRESSED(pp, 7)) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 7);
                    pp.Flags ^= Gameutils.PF_AUTO_AIM;
                }
            } else {
                Gameutils.FLAG_KEY_RESET(pp, 7);
            }
        }
    }

    public static void PlayerSectorBound(PlayerStr pp, int amt) {
        Main.engine.getzsofslope(pp.cursectnum, pp.posx, pp.posy, Rooms.fz, Rooms.cz);
        if (pp.posz > Rooms.fz.get() - amt) {
            pp.posz = Rooms.fz.get() - amt;
        }
        if (pp.posz < Rooms.cz.get() + amt) {
            pp.posz = Rooms.cz.get() + amt;
        }
    }

    public static void PLAYER_RUN_LOCK(PlayerStr pp) {
        if (Gameutils.TEST_SYNC_KEY(pp, 10)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 10)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 10);
                pp.Flags ^= Gameutils.PF_LOCK_RUN;
                Main.cfg.AutoRun = MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_RUN);
                Text.PutStringInfo(pp, "Run mode " + (MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_RUN) ? "ON" : "OFF"));
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 10);
        }
    }

    public static void DoPlayerMove(PlayerStr pp) {
        Sprite psp = pp.getSprite();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (psp == null || u == null) {
            return;
        }
        Player.SlipSlope(pp);
        Player.PLAYER_RUN_LOCK(pp);
        Player.DoPlayerTurn(pp);
        pp.oldposx = pp.posx;
        pp.oldposy = pp.posy;
        pp.oldposz = pp.posz;
        pp.lastcursectnum = pp.cursectnum;
        pp.Flags = Gameutils.PLAYER_MOVING(pp) == 0 ? (pp.Flags &= ~Gameutils.PF_PLAYER_MOVED) : (pp.Flags |= Gameutils.PF_PLAYER_MOVED);
        Player.DoPlayerSlide(pp);
        pp.oxvect = pp.xvect;
        pp.oyvect = pp.yvect;
        pp.xvect += pp.input.vel * 3 * 2 << 6;
        pp.yvect += pp.input.svel * 3 * 2 << 6;
        int friction = pp.friction;
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_SWIMMING) && pp.WadeDepth != 0) {
            friction -= pp.WadeDepth * 100;
        }
        pp.xvect = Pragmas.mulscale(pp.xvect, friction, 16);
        pp.yvect = Pragmas.mulscale(pp.yvect, friction, 16);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_FLYING)) {
            pp.xvect = (pp.xvect + pp.oxvect) / 2;
            pp.yvect = (pp.yvect + pp.oyvect) / 2;
        } else if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING)) {
            pp.xvect = (pp.xvect + pp.oxvect * 2) / 3;
            pp.yvect = (pp.yvect + pp.oyvect * 2) / 3;
        }
        if (Pragmas.klabs(pp.xvect) < 12800 && Pragmas.klabs(pp.yvect) < 12800) {
            pp.yvect = 0;
            pp.xvect = 0;
        }
        psp.setXvel(Gameutils.FindDistance2D(pp.xvect, pp.yvect) >> 14);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_CLIP_CHEAT)) {
            int sectnum = pp.cursectnum;
            pp.posx += pp.xvect >> 14;
            pp.posy += pp.yvect >> 14;
            if ((sectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, sectnum)) != -1) {
                pp.cursectnum = sectnum;
            }
        } else {
            int push_ret = Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, psp.getClipdist() << 2, pp.ceiling_dist, pp.floor_dist - Gameutils.Z(16), Gameutils.CLIPMASK_PLAYER);
            if (Engine.pushmove_sectnum != -1) {
                pp.posx = Engine.pushmove_x;
                pp.posy = Engine.pushmove_y;
                pp.posz = Engine.pushmove_z;
                pp.cursectnum = Engine.pushmove_sectnum;
            }
            if (push_ret < 0 && !MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
            short save_cstat = psp.getCstat();
            psp.setCstat(psp.getCstat() & ~Gameutils.CSTAT_SPRITE_BLOCK);
            pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
            Main.engine.clipmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.xvect, pp.yvect, psp.getClipdist() << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
            if (Engine.clipmove_sectnum != -1) {
                pp.posx = Engine.clipmove_x;
                pp.posy = Engine.clipmove_y;
                pp.posz = Engine.clipmove_z;
                pp.cursectnum = Engine.clipmove_sectnum;
            }
            psp.setCstat(save_cstat);
            Player.PlayerCheckValidMove(pp);
            push_ret = Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, psp.getClipdist() << 2, pp.ceiling_dist, pp.floor_dist - Gameutils.Z(16), Gameutils.CLIPMASK_PLAYER);
            if (Engine.pushmove_sectnum != -1) {
                pp.posx = Engine.pushmove_x;
                pp.posy = Engine.pushmove_y;
                pp.posz = Engine.pushmove_z;
                pp.cursectnum = Engine.pushmove_sectnum;
            }
            if (push_ret < 0 && !MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
        }
        if (Warp.WarpPlane(pp.posx, pp.posy, pp.posz, pp.cursectnum) != null) {
            pp.posx = Warp.warp.x;
            pp.posy = Warp.warp.y;
            pp.posz = Warp.warp.z;
            pp.cursectnum = Warp.warp.sectnum;
            Player.PlayerWarpUpdatePos(pp);
        }
        Player.DoPlayerZrange(pp);
        Player.DoPlayerSetWadeDepth(pp);
        Player.DoPlayerHorizon(pp);
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(pp.cursectnum);
        if (sec != null && MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_DYNAMIC_AREA)) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_FLYING | Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
                if (pp.posz > pp.loz) {
                    pp.posz = pp.loz - PLAYER_HEIGHT;
                }
                if (pp.posz < pp.hiz) {
                    pp.posz = pp.hiz + PLAYER_HEIGHT;
                }
            } else if (MyTypes.TEST(pp.Flags, Gameutils.PF_SWIMMING | Gameutils.PF_DIVING)) {
                if (pp.posz > pp.loz) {
                    pp.posz = pp.loz - PLAYER_SWIM_HEIGHT;
                }
                if (pp.posz < pp.hiz) {
                    pp.posz = pp.hiz + PLAYER_SWIM_HEIGHT;
                }
            }
        }
    }

    public static void DoPlayerSectorUpdatePreMove(PlayerStr pp) {
        int sectnum = pp.cursectnum;
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(pp.cursectnum);
        if (sec == null) {
            return;
        }
        if (MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_DYNAMIC_AREA)) {
            if ((sectnum = Main.engine.updatesectorz(pp.posx, pp.posy, pp.posz, sectnum)) < 0) {
                sectnum = pp.cursectnum;
                sectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, sectnum);
            }
        } else if (Gameutils.FAF_ConnectArea(sectnum) && (sectnum = Main.engine.updatesectorz(pp.posx, pp.posy, pp.posz, sectnum)) < 0) {
            sectnum = pp.cursectnum;
            sectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, sectnum);
        }
        pp.cursectnum = sectnum;
    }

    public static void DoPlayerSectorUpdatePostMove(PlayerStr pp) {
        if (Gameutils.FAF_ConnectArea(pp.cursectnum)) {
            int sectnum = pp.cursectnum;
            pp.cursectnum = Main.engine.updatesectorz(pp.posx, pp.posy, pp.posz, sectnum);
            if (pp.cursectnum < 0) {
                pp.cursectnum = sectnum;
                Main.engine.getzsofslope(pp.cursectnum, pp.posx, pp.posy, Rooms.fz, Rooms.cz);
                if (pp.posz > Rooms.fz.get()) {
                    pp.posz = Rooms.fz.get();
                }
                if (pp.posz < Rooms.cz.get()) {
                    pp.posz = Rooms.cz.get();
                }
                pp.cursectnum = Main.engine.updatesectorz(pp.posx, pp.posy, pp.posz, pp.cursectnum);
            }
        } else {
            Player.PlayerSectorBound(pp, Gameutils.Z(1));
        }
    }

    public static void PlaySOsound(int sectnum, int sound_num) {
        ListNode<Sprite> node = Main.boardService.getSectNode(sectnum);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (sp.getStatnum() == 65) {
                Sector.DoSoundSpotStopSound(sp.getLotag());
                Sector.DoSoundSpotMatch(sp.getLotag(), sound_num, Sound.SoundType.SOUND_OBJECT_TYPE);
            }
            node = nexti;
        }
    }

    public static void StopSOsound(int sectnum) {
        ListNode<Sprite> node = Main.boardService.getSectNode(sectnum);
        while (node != null) {
            Sprite sp = node.get();
            ListNode<Sprite> nexti = node.getNext();
            if (sp.getStatnum() == 65) {
                Sector.DoSoundSpotStopSound(sp.getLotag());
            }
            node = nexti;
        }
    }

    public static void DoPlayerMoveBoat(PlayerStr pp) {
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (WangNetwork.Prediction) {
            return;
        }
        int fifo_ndx = Main.game.pNet.gNetFifoTail - 2 & 0xFF;
        Input last_input = (Input)Main.game.pNet.gFifoInput[fifo_ndx][pp.pnum];
        if (Pragmas.klabs(pp.input.vel | pp.input.svel) != 0 && Pragmas.klabs(last_input.vel | last_input.svel) == 0) {
            Player.PlaySOsound(sop.mid_sector, 2);
        } else if (Pragmas.klabs(pp.input.vel | pp.input.svel) == 0 && Pragmas.klabs(last_input.vel | last_input.svel) != 0) {
            Player.PlaySOsound(sop.mid_sector, 1);
        }
        Player.PLAYER_RUN_LOCK(pp);
        Player.DoPlayerTurnBoat(pp);
        pp.Flags = Gameutils.PLAYER_MOVING(pp) == 0 ? (pp.Flags &= ~Gameutils.PF_PLAYER_MOVED) : (pp.Flags |= Gameutils.PF_PLAYER_MOVED);
        pp.oxvect = pp.xvect;
        pp.oyvect = pp.yvect;
        if (sop.drive_speed != 0) {
            pp.xvect = Pragmas.mulscale(pp.input.vel, sop.drive_speed, 6);
            pp.yvect = Pragmas.mulscale(pp.input.svel, sop.drive_speed, 6);
            pp.xvect = (pp.xvect + pp.oxvect * (sop.drive_slide - 1)) / sop.drive_slide;
            pp.yvect = (pp.yvect + pp.oyvect * (sop.drive_slide - 1)) / sop.drive_slide;
        } else {
            pp.xvect += pp.input.vel * 3 * 2 << 6;
            pp.yvect += pp.input.svel * 3 * 2 << 6;
            pp.xvect = Pragmas.mulscale(pp.xvect, 51968L, 16);
            pp.yvect = Pragmas.mulscale(pp.yvect, 51968L, 16);
            pp.xvect = (pp.xvect + pp.oxvect * 5) / 6;
            pp.yvect = (pp.yvect + pp.oyvect * 5) / 6;
        }
        if (Pragmas.klabs(pp.xvect) < 12800 && Pragmas.klabs(pp.yvect) < 12800) {
            pp.yvect = 0;
            pp.xvect = 0;
        }
        pp.lastcursectnum = pp.cursectnum;
        int z = pp.posz + Gameutils.Z(10);
        int save_sectnum = pp.cursectnum;
        Track.OperateSectorObject(pp.sop, pp.getAnglef(), Integer.MAX_VALUE, Integer.MAX_VALUE, 1);
        pp.cursectnum = sop.op_main_sector;
        int floor_dist = Pragmas.klabs(z - sop.floor_loz);
        Main.engine.clipmove(pp.posx, pp.posy, z, pp.cursectnum, pp.xvect, pp.yvect, sop.clipdist, Gameutils.Z(4), floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.clipmove_sectnum != -1) {
            pp.posx = Engine.clipmove_x;
            pp.posy = Engine.clipmove_y;
            pp.cursectnum = Engine.clipmove_sectnum;
        }
        Track.OperateSectorObject(pp.sop, pp.getAnglef(), pp.posx, pp.posy, 1);
        pp.cursectnum = save_sectnum;
        Player.DoPlayerHorizon(pp);
    }

    public static void DoTankTreads(PlayerStr pp) {
        boolean reverse = false;
        if (WangNetwork.Prediction) {
            return;
        }
        int vel = Gameutils.FindDistance2D(pp.xvect >> 8, pp.yvect >> 8);
        int dot = Game.isOriginal() ? Gameutils.DOT_PRODUCT_2D(pp.xvect, pp.yvect, EngineUtils.sin(Gameutils.NORM_ANGLE(pp.getAnglei() + 512)), EngineUtils.sin(pp.getAnglei())) : Gameutils.DOT_PRODUCT_2D(pp.xvect, pp.yvect, (int)ru.m210projects.Build.Gameutils.BCosAngle(pp.getAnglef()), (int)ru.m210projects.Build.Gameutils.BSinAngle(pp.getAnglef()));
        if (dot < 0) {
            reverse = true;
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        int j = 0;
        while (sop.sector[j] != -1) {
            ListNode<Sprite> node = Main.boardService.getSectNode(sop.sector[j]);
            while (node != null) {
                ListNode<Sprite> nexti = node.getNext();
                Sprite sp = node.get();
                if (Gameutils.TEST_BOOL1(sp)) {
                    if (sp.getStatnum() == 89) {
                        if (reverse) {
                            if (!Gameutils.TEST_BOOL2(sp)) {
                                Gameutils.SET_BOOL2(sp);
                                sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024));
                            }
                        } else if (Gameutils.TEST_BOOL2(sp)) {
                            Gameutils.RESET_BOOL2(sp);
                            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024));
                        }
                        sp.setXvel(vel);
                    } else if (sp.getStatnum() == 87) {
                        if (reverse) {
                            if (!Gameutils.TEST_BOOL2(sp)) {
                                Gameutils.SET_BOOL2(sp);
                                sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024));
                            }
                        } else if (Gameutils.TEST_BOOL2(sp)) {
                            Gameutils.RESET_BOOL2(sp);
                            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024));
                        }
                        sp.setXvel(vel);
                    } else if (sp.getStatnum() == 88) {
                        if (reverse) {
                            if (!Gameutils.TEST_BOOL2(sp)) {
                                Gameutils.SET_BOOL2(sp);
                                sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024));
                            }
                        } else if (Gameutils.TEST_BOOL2(sp)) {
                            Gameutils.RESET_BOOL2(sp);
                            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024));
                        }
                        sp.setXvel(vel);
                    }
                }
                node = nexti;
            }
            ++j;
        }
    }

    public static void DriveCrush(PlayerStr pp, int[] x, int[] y) {
        Sprite sp;
        ListNode<Sprite> nexti;
        int i;
        if (Sprites.MoveSkip4 == 0) {
            return;
        }
        if ((pp.xvect | pp.yvect) == 0 && pp.input.angvel == 0.0f) {
            return;
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop_control];
        ListNode<Sprite> node = Main.boardService.getSectNode(sop.op_main_sector);
        while (node != null) {
            i = node.getIndex();
            nexti = node.getNext();
            sp = node.get();
            USER u = Gameutils.getUser(i);
            if (!(MClip.testpointinquad(sp.getX(), sp.getY(), x, y) == 0 || MyTypes.TEST(sp.getExtra(), Gameutils.SPRX_BREAKABLE) && Break.HitBreakSprite(i, 0) || sp.getStatnum() == 4 || sp.getPicnum() == 2307 || MyTypes.TEST(sp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY) && u != null && !MyTypes.TEST(u.Flags, Gameutils.SPR_DEAD) && !MyTypes.TEST(sp.getExtra(), Gameutils.SPRX_BREAKABLE) || MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE) || sp.getStatnum() > 47 || sp.getZ() < sop.crush_z)) {
                Weapon.SpriteQueueDelete(i);
                Sprites.KillSprite(i);
            }
            node = nexti;
        }
        node = Main.boardService.getStatNode(2);
        while (node != null) {
            block18: {
                block19: {
                    i = node.getIndex();
                    nexti = node.getNext();
                    sp = node.get();
                    if (MClip.testpointinquad(sp.getX(), sp.getY(), x, y) == 0 || sp.getZ() < sop.crush_z) break block18;
                    int vel = Gameutils.FindDistance2D(pp.xvect >> 8, pp.yvect >> 8);
                    if (vel >= 9000) break block19;
                    Actor.DoActorBeginSlide(i, EngineUtils.getAngle(pp.xvect, pp.yvect), vel / 8, 5);
                    if (Actor.DoActorSlide(i)) break block18;
                }
                Weapon.UpdateSinglePlayKills(i, pp);
                if (Shrap.SpawnShrap(i, -99)) {
                    Weapon.SetSuicide(i);
                } else {
                    Sprites.KillSprite(i);
                }
            }
            node = nexti;
        }
        node = Main.boardService.getStatNode(3);
        while (node != null) {
            i = node.getIndex();
            nexti = node.getNext();
            sp = node.get();
            if (MClip.testpointinquad(sp.getX(), sp.getY(), x, y) != 0 && sp.getZ() >= sop.crush_z) {
                Weapon.SpriteQueueDelete(i);
                Sprites.KillSprite(i);
            }
            node = nexti;
        }
        for (int stat = 0; stat < 8; ++stat) {
            ListNode<Sprite> node2 = Main.boardService.getStatNode(21 + stat);
            if (node2 == null) continue;
            int i2 = node2.getIndex();
            Sprite sp2 = node2.get();
            USER u = Gameutils.getUser(i2);
            if (u == null || u.PlayerP == pp.pnum || MClip.testpointinquad(sp2.getX(), sp2.getY(), x, y) == 0 || sp2.getZ() < sop.crush_z) continue;
            int damage = -(u.Health + 100);
            Weapon.PlayerDamageSlide(Game.Player[u.PlayerP], damage, pp.getAnglei());
            Panel.PlayerUpdateHealth(Game.Player[u.PlayerP], damage);
            Weapon.PlayerCheckDeath(Game.Player[u.PlayerP], pp.PlayerSprite);
        }
        int s = 0;
        while (sop.sector[s] != -1) {
            ListNode<Sprite> node3 = Main.boardService.getSectNode(sop.sector[s]);
            while (node3 != null) {
                int i3 = node3.getIndex();
                nexti = node3.getNext();
                Sprite sp3 = node3.get();
                if (sp3.getZ() >= sop.crush_z + Gameutils.Z(40) && MyTypes.TEST(sp3.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY) && sp3.getStatnum() == 2) {
                    if (Shrap.SpawnShrap(i3, -99)) {
                        Weapon.SetSuicide(i3);
                    } else {
                        Sprites.KillSprite(i3);
                    }
                }
                node3 = nexti;
            }
            ++s;
        }
    }

    public static void DoPlayerMoveTank(PlayerStr pp) {
        short save_cstat;
        Sprite psp = pp.getSprite();
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        int spnum = sop.sp_child;
        boolean RectClip = MyTypes.TEST(sop.flags, Gameutils.SOBJ_RECT_CLIP);
        USER u = Gameutils.getUser(spnum);
        if (psp == null || WangNetwork.Prediction) {
            return;
        }
        int fifo_ndx = Main.game.pNet.gNetFifoTail - 2 & 0xFF;
        Input last_input = (Input)Main.game.pNet.gFifoInput[fifo_ndx][pp.pnum];
        if (Pragmas.klabs(pp.input.vel | pp.input.svel) != 0 && Pragmas.klabs(last_input.vel | last_input.svel) == 0) {
            Player.PlaySOsound(sop.mid_sector, 2);
        } else if (Pragmas.klabs(pp.input.vel | pp.input.svel) == 0 && Pragmas.klabs(last_input.vel | last_input.svel) != 0) {
            Player.PlaySOsound(sop.mid_sector, 1);
        }
        Player.PLAYER_RUN_LOCK(pp);
        pp.Flags = Gameutils.PLAYER_MOVING(pp) == 0 ? (pp.Flags &= ~Gameutils.PF_PLAYER_MOVED) : (pp.Flags |= Gameutils.PF_PLAYER_MOVED);
        pp.oxvect = pp.xvect;
        pp.oyvect = pp.yvect;
        if (sop.drive_speed != 0) {
            pp.xvect = Pragmas.mulscale(pp.input.vel, sop.drive_speed, 6);
            pp.yvect = Pragmas.mulscale(pp.input.svel, sop.drive_speed, 6);
            pp.xvect = (pp.xvect + pp.oxvect * (sop.drive_slide - 1)) / sop.drive_slide;
            pp.yvect = (pp.yvect + pp.oyvect * (sop.drive_slide - 1)) / sop.drive_slide;
        } else {
            pp.xvect += pp.input.vel * 3 * 2 << 6;
            pp.yvect += pp.input.svel * 3 * 2 << 6;
            pp.xvect = Pragmas.mulscale(pp.xvect, 53248L, 16);
            pp.yvect = Pragmas.mulscale(pp.yvect, 53248L, 16);
            pp.xvect = (pp.xvect + pp.oxvect) / 2;
            pp.yvect = (pp.yvect + pp.oyvect) / 2;
        }
        if (Pragmas.klabs(pp.xvect) < 12800 && Pragmas.klabs(pp.yvect) < 12800) {
            pp.yvect = 0;
            pp.xvect = 0;
        }
        pp.lastcursectnum = pp.cursectnum;
        int z = pp.posz + Gameutils.Z(10);
        if (RectClip) {
            int wallcount = 0;
            int count = 0;
            int s = 0;
            while (sop.sector[s] != -1) {
                ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sop.sector[s]);
                if (sectp != null) {
                    for (ListNode<Wall> wn = sectp.getWallNode(); wn != null; wn = wn.getNext()) {
                        Wall wp = wn.get();
                        if (wp.getExtra() != 0 && MyTypes.DTEST(wp.getExtra(), Gameutils.WALLFX_LOOP_OUTER | Gameutils.WALLFX_LOOP_OUTER_SECONDARY) == Gameutils.WALLFX_LOOP_OUTER) {
                            Player.x[count] = wp.getX();
                            Player.y[count] = wp.getY();
                            Player.ox[count] = sop.xmid - sop.xorig[wallcount];
                            Player.oy[count] = sop.ymid - sop.yorig[wallcount];
                            ++count;
                        }
                        ++wallcount;
                    }
                }
                ++s;
            }
        }
        int save_sectnum = pp.cursectnum;
        Track.OperateSectorObject(pp.sop, pp.getAnglef(), Integer.MAX_VALUE, Integer.MAX_VALUE, 1);
        pp.cursectnum = sop.op_main_sector;
        int floor_dist = Pragmas.klabs(z - sop.floor_loz);
        if (RectClip) {
            save_cstat = psp.getCstat();
            psp.setCstat(psp.getCstat() & ~Gameutils.CSTAT_SPRITE_BLOCK);
            Player.DoPlayerTurnTankRect(pp, x, y, ox, oy);
            boolean ret = MClip.RectClipMove(pp, x, y);
            Player.DriveCrush(pp, x, y);
            psp.setCstat(save_cstat);
            if (!ret) {
                int vel = Gameutils.FindDistance2D(pp.xvect >> 8, pp.yvect >> 8);
                if (vel > 13000) {
                    int nx = MyTypes.DIV2(x[0] + x[1]);
                    int ny = MyTypes.DIV2(y[0] + y[1]);
                    ru.m210projects.Build.Types.Sector opSector = Main.boardService.getSector(pp.cursectnum);
                    if (u != null && opSector != null) {
                        Main.engine.hitscan(nx, ny, opSector.getFloorz() - Gameutils.Z(10), pp.cursectnum, Gameutils.MOVEx(256, pp.getAnglei()), Gameutils.MOVEy(256, pp.getAnglei()), 0, Engine.pHitInfo, Gameutils.CLIPMASK_PLAYER);
                        if (Gameutils.FindDistance2D(Engine.pHitInfo.hitx - nx, Engine.pHitInfo.hity - ny) < 800) {
                            u.moveSpriteReturn = Engine.pHitInfo.hitwall != -1 ? Engine.pHitInfo.hitwall | Integer.MIN_VALUE : (Engine.pHitInfo.hitsprite != -1 ? Engine.pHitInfo.hitsprite | 0xC0000000 : 0);
                            Weapon.VehicleMoveHit(spnum);
                        }
                        if (!MyTypes.TEST(sop.flags, Gameutils.SOBJ_NO_QUAKE)) {
                            Quake.SetPlayerQuake(pp);
                        }
                    }
                }
                if (vel > 12000) {
                    pp.oyvect = 0;
                    pp.oxvect = 0;
                    pp.yvect = 0;
                    pp.xvect = 0;
                }
            }
        } else if (u != null) {
            Player.DoPlayerTurnTank(pp, z, floor_dist);
            save_cstat = psp.getCstat();
            psp.setCstat(psp.getCstat() & ~Gameutils.CSTAT_SPRITE_BLOCK);
            if (sop.clipdist != 0) {
                u.moveSpriteReturn = Main.engine.clipmove(pp.posx, pp.posy, z, pp.cursectnum, pp.xvect, pp.yvect, sop.clipdist, Gameutils.Z(4), floor_dist, Gameutils.CLIPMASK_PLAYER);
                if (Engine.clipmove_sectnum != -1) {
                    pp.posx = Engine.clipmove_x;
                    pp.posy = Engine.clipmove_y;
                    pp.cursectnum = Engine.clipmove_sectnum;
                }
            } else {
                u.moveSpriteReturn = MClip.MultiClipMove(pp, z, floor_dist);
            }
            psp.setCstat(save_cstat);
            if (u.moveSpriteReturn != 0) {
                int vel = Gameutils.FindDistance2D(pp.xvect >> 8, pp.yvect >> 8);
                if (vel > 13000) {
                    Weapon.VehicleMoveHit(spnum);
                    pp.slide_xvect = -pp.xvect << 1;
                    pp.slide_yvect = -pp.yvect << 1;
                    if (!MyTypes.TEST(sop.flags, Gameutils.SOBJ_NO_QUAKE)) {
                        Quake.SetPlayerQuake(pp);
                    }
                }
                if (vel > 12000) {
                    pp.oyvect = 0;
                    pp.oxvect = 0;
                    pp.yvect = 0;
                    pp.xvect = 0;
                }
            }
        }
        Track.OperateSectorObject(pp.sop, pp.getAnglef(), pp.posx, pp.posy, 1);
        pp.cursectnum = save_sectnum;
        Player.DoPlayerHorizon(pp);
        Player.DoTankTreads(pp);
    }

    public static void DoPlayerMoveTurret(PlayerStr pp) {
        Player.PLAYER_RUN_LOCK(pp);
        Player.DoPlayerTurnTurret(pp);
        pp.Flags = Gameutils.PLAYER_MOVING(pp) == 0 ? (pp.Flags &= ~Gameutils.PF_PLAYER_MOVED) : (pp.Flags |= Gameutils.PF_PLAYER_MOVED);
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        Track.OperateSectorObject(pp.sop, pp.getAnglef(), sop.xmid, sop.ymid, 1);
        Player.DoPlayerHorizon(pp);
    }

    public static void DoPlayerBeginJump(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        pp.Flags |= Gameutils.PF_JUMPING;
        pp.Flags &= ~Gameutils.PF_FALLING;
        pp.Flags &= ~Gameutils.PF_CRAWLING;
        pp.Flags &= ~Gameutils.PF_LOCK_CRAWL;
        pp.floor_dist = PLAYER_JUMP_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_JUMP_CEILING_DIST;
        pp.friction = 50000;
        pp.jump_speed = -650 + pp.WadeDepth * 4;
        if (Player.DoPlayerWadeSuperJump(pp)) {
            pp.jump_speed = -650 - pp.WadeDepth * 5;
        }
        pp.JumpDuration = 12;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerJump;
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Jump);
    }

    public static void DoPlayerBeginForceJump(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        pp.Flags |= Gameutils.PF_JUMPING;
        pp.Flags &= ~(Gameutils.PF_FALLING | Gameutils.PF_CRAWLING | Gameutils.PF_CLIMBING | Gameutils.PF_LOCK_CRAWL);
        pp.JumpDuration = 12;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerForceJump;
        pp.floor_dist = PLAYER_JUMP_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_JUMP_CEILING_DIST;
        pp.friction = 50000;
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Jump);
    }

    public static void DoPlayerJump(PlayerStr pp) {
        if (!Gameutils.TEST_SYNC_KEY(pp, 19)) {
            Gameutils.FLAG_KEY_RESET(pp, 19);
        }
        for (int i = 0; i < 3; ++i) {
            if (Gameutils.TEST_SYNC_KEY(pp, 19) && pp.JumpDuration > 0) {
                pp.jump_speed -= 24;
                --pp.JumpDuration;
            }
            if ((pp.jump_speed += 24) > 0) {
                Player.DoPlayerBeginFall(pp);
                Player.DoPlayerFall(pp);
                return;
            }
            pp.posz += pp.jump_speed;
            if (Player.PlayerCeilingHit(pp, pp.hiz + Gameutils.Z(4))) {
                pp.posz = pp.hiz + Gameutils.Z(4);
                pp.jump_speed = -pp.jump_speed;
                Player.DoPlayerBeginFall(pp);
                Player.DoPlayerFall(pp);
                return;
            }
            if (!Player.PlayerFloorHit(pp, pp.loz - pp.floor_dist)) continue;
            pp.posz = pp.loz - pp.floor_dist;
            pp.jump_speed = 0;
            Player.PlayerSectorBound(pp, Gameutils.Z(1));
            Player.DoPlayerBeginRun(pp);
            Player.DoPlayerHeight(pp);
            return;
        }
        if (Player.PlayerFlyKey(pp)) {
            Player.DoPlayerBeginFly(pp);
            return;
        }
        if (Player.PlayerOnLadder(pp)) {
            Player.DoPlayerBeginClimb(pp);
            return;
        }
        Player.DoPlayerMove(pp);
        Player.DoPlayerJumpHeight(pp);
    }

    public static void DoPlayerForceJump(PlayerStr pp) {
        for (int i = 0; i < 3; ++i) {
            if ((pp.jump_speed += 24) > 0) {
                Player.DoPlayerBeginFall(pp);
                Player.DoPlayerFall(pp);
                return;
            }
            pp.posz += pp.jump_speed;
            if (!Player.PlayerCeilingHit(pp, pp.hiz + Gameutils.Z(4))) continue;
            pp.posz = pp.hiz + Gameutils.Z(4);
            pp.jump_speed = -pp.jump_speed;
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            return;
        }
        Player.DoPlayerMove(pp);
    }

    public static void DoPlayerBeginFall(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        pp.Flags |= Gameutils.PF_FALLING;
        pp.Flags &= ~Gameutils.PF_JUMPING;
        pp.Flags &= ~Gameutils.PF_CRAWLING;
        pp.Flags &= ~Gameutils.PF_LOCK_CRAWL;
        pp.floor_dist = PLAYER_FALL_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_FALL_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerFall;
        pp.friction = 50000;
        if (u.getRot() == u.ActorActionSet.Jump) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Fall);
        }
    }

    public static void StackedWaterSplash(PlayerStr pp) {
        int sectnum;
        Sprite psp;
        if (Gameutils.FAF_ConnectArea(pp.cursectnum) && (psp = pp.getSprite()) != null && Gameutils.SectorIsUnderwaterArea(sectnum = Main.engine.updatesectorz(pp.posx, pp.posy, Gameutils.SPRITEp_BOS(psp), pp.cursectnum))) {
            Sound.PlaySound(196, pp, 8);
        }
    }

    public static void DoPlayerFall(PlayerStr pp) {
        if (!Gameutils.TEST_SYNC_KEY(pp, 19)) {
            Gameutils.FLAG_KEY_RESET(pp, 19);
        }
        if (Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            Player.StackedWaterSplash(pp);
            Player.DoPlayerBeginDiveNoWarp(pp);
            return;
        }
        for (int i = 0; i < 3; ++i) {
            pp.jump_speed += 24;
            if (pp.jump_speed > 4100) {
                pp.jump_speed = 4100;
            }
            pp.posz += pp.jump_speed;
            if (pp.jump_speed > 2000) {
                Sound.PlayerSound(266, 13, pp);
                handle = pp.TalkVocHandle;
            } else if (pp.jump_speed > 1300 && !Main.cfg.isgMouseAim() && MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_HORIZ)) {
                pp.Flags &= ~Gameutils.PF_LOCK_HORIZ;
                pp.Flags |= Gameutils.PF_LOOKING;
            }
            int depth = Rooms.GetZadjustment(pp.cursectnum, 98) >> 8;
            if (depth == 0) {
                depth = pp.WadeDepth;
            }
            int recoil_amt = 0;
            if (depth <= 20) {
                recoil_amt = Math.min(pp.jump_speed * 6, Gameutils.Z(35));
            }
            if (Player.PlayerCeilingHit(pp, pp.hiz + pp.ceiling_dist)) {
                pp.posz = pp.hiz + pp.ceiling_dist;
            }
            if (!Player.PlayerFloorHit(pp, pp.loz - PLAYER_HEIGHT + recoil_amt)) continue;
            Sect_User sectu = Sector.getSectUser(pp.cursectnum);
            ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(pp.cursectnum);
            Player.PlayerSectorBound(pp, Gameutils.Z(1));
            if (sectu != null && sectp != null && MyTypes.DTEST(sectp.getExtra(), Gameutils.SECTFX_LIQUID_MASK) != 0) {
                Sound.PlaySound(196, pp, 8);
            } else if (pp.jump_speed > 1020) {
                Sound.PlaySound(57, pp, 9);
            }
            if (handle != null && handle.isActive()) {
                handle.stop();
                pp.PlayerTalking = false;
                handle = null;
            }
            if (Player.DoPlayerTestCrawl(pp) || Gameutils.TEST_SYNC_KEY(pp, 20)) {
                pp.posz = pp.loz - PLAYER_CRAWL_HEIGHT;
            } else {
                pp.posz += recoil_amt;
                Player.DoPlayerHeight(pp);
            }
            if (pp.jump_speed > 1700 && depth == 0) {
                USER u;
                Sound.PlayerSound(257, 9, pp);
                if (pp.jump_speed > 1700 && pp.jump_speed < 4000) {
                    Panel.PlayerUpdateHealth(pp, -((pp.jump_speed - 1700) / 40));
                } else if (pp.jump_speed >= 4000 && (u = Gameutils.getUser(pp.PlayerSprite)) != null) {
                    Panel.PlayerUpdateHealth(pp, -u.Health);
                    u.Health = 0;
                }
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
            if (Gameutils.TEST_SYNC_KEY(pp, 20)) {
                Player.StackedWaterSplash(pp);
                Player.DoPlayerBeginCrawl(pp);
                return;
            }
            if (Player.PlayerCanDiveNoWarp(pp)) {
                Player.DoPlayerBeginDiveNoWarp(pp);
                return;
            }
            Player.StackedWaterSplash(pp);
            Player.DoPlayerBeginRun(pp);
            return;
        }
        if (Player.PlayerFlyKey(pp)) {
            Player.DoPlayerBeginFly(pp);
            return;
        }
        if (Player.PlayerOnLadder(pp)) {
            Player.DoPlayerBeginClimb(pp);
            return;
        }
        Player.DoPlayerMove(pp);
    }

    public static void DoPlayerBeginClimb(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        if (sp == null) {
            return;
        }
        pp.Flags &= ~(Gameutils.PF_JUMPING | Gameutils.PF_FALLING);
        pp.Flags &= ~Gameutils.PF_CRAWLING;
        pp.Flags &= ~Gameutils.PF_LOCK_CRAWL;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerClimb;
        pp.Flags |= Gameutils.PF_CLIMBING | Gameutils.PF_WEAPON_DOWN;
        sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaClimb);
    }

    public static void DoPlayerClimb(PlayerStr pp) {
        int climb_amt;
        USER u = Gameutils.getUser(pp.PlayerSprite);
        Sprite sp = pp.getSprite();
        if (sp == null || u == null) {
            return;
        }
        if (WangNetwork.Prediction) {
            return;
        }
        pp.xvect += pp.input.vel * 3 * 2 << 6;
        pp.yvect += pp.input.svel * 3 * 2 << 6;
        pp.xvect = Pragmas.mulscale(pp.xvect, 45056L, 16);
        pp.yvect = Pragmas.mulscale(pp.yvect, 45056L, 16);
        if (Pragmas.klabs(pp.xvect) < 12800 && Pragmas.klabs(pp.yvect) < 12800) {
            pp.yvect = 0;
            pp.xvect = 0;
        }
        int climbvel = Gameutils.FindDistance2D(pp.xvect, pp.yvect) >> 9;
        int dot = Gameutils.DOT_PRODUCT_2D(pp.xvect, pp.yvect, EngineUtils.sin(Gameutils.NORM_ANGLE(pp.getAnglei() + 512)), EngineUtils.sin(pp.getAnglei()));
        if (dot < 0) {
            climbvel = -climbvel;
        }
        Player.PLAYER_RUN_LOCK(pp);
        if (Gameutils.TEST_SYNC_KEY(pp, 19)) {
            pp.Flags &= ~(Gameutils.PF_CLIMBING | Gameutils.PF_WEAPON_DOWN);
            sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
            Player.DoPlayerBeginJump(pp);
            return;
        }
        if (climbvel != 0) {
            for (int i = 3; i != 0; --i) {
                if (pp.posx != pp.lx) {
                    pp.posx = pp.posx < pp.lx ? (pp.posx += 8) : (pp.posx -= 8);
                    if (Pragmas.klabs(pp.posx - pp.lx) <= 8) {
                        pp.posx = pp.lx;
                    }
                }
                if (pp.posy != pp.ly) {
                    pp.posy = pp.posy < pp.ly ? (pp.posy += 8) : (pp.posy -= 8);
                    if (Pragmas.klabs(pp.posy - pp.ly) <= 8) {
                        pp.posy = pp.ly;
                    }
                }
                if (sp.getX() != u.sx) {
                    if (sp.getX() < u.sx) {
                        sp.setX(sp.getX() + 8);
                    } else if (sp.getX() > u.sx) {
                        sp.setX(sp.getX() - 8);
                    }
                    if (Pragmas.klabs(sp.getX() - u.sx) <= 8) {
                        sp.setX(u.sx);
                    }
                }
                if (sp.getY() == u.sy) continue;
                if (sp.getY() < u.sy) {
                    sp.setY(sp.getY() + 8);
                } else if (sp.getY() > u.sy) {
                    sp.setY(sp.getY() - 8);
                }
                if (Pragmas.klabs(sp.getY() - u.sy) > 8) continue;
                sp.setY(u.sy);
            }
        }
        Player.DoPlayerZrange(pp);
        if (climbvel > 0) {
            ru.m210projects.Build.Types.Sector ladderSec;
            climb_amt = (climbvel >> 4) * 8;
            pp.climb_ndx &= 0x3FF;
            pp.posz -= climb_amt;
            if (Player.PlayerCeilingHit(pp, pp.hiz)) {
                pp.posz = pp.hiz;
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaClimb);
            }
            if ((ladderSec = Main.boardService.getSector(pp.LadderSector)) != null && Player.PlayerCeilingHit(pp, pp.hiz + Gameutils.Z(4))) {
                pp.posz = ladderSec.getCeilingz() + Gameutils.Z(4);
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaClimb);
            }
            if (ladderSec == null || pp.posz < ladderSec.getFloorz() - Gameutils.Z(6)) {
                pp.jump_speed = -1100;
                pp.Flags &= ~(Gameutils.PF_CLIMBING | Gameutils.PF_WEAPON_DOWN);
                sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
                Player.DoPlayerBeginForceJump(pp);
            }
        } else if (climbvel < 0) {
            climb_amt = -(climbvel >> 4) * 8;
            pp.climb_ndx &= 0x3FF;
            pp.posz += climb_amt;
            if (Player.PlayerFloorHit(pp, pp.loz - Gameutils.Z(4) - PLAYER_HEIGHT)) {
                pp.posz = pp.loz - Gameutils.Z(4) - PLAYER_HEIGHT;
                pp.Flags &= ~(Gameutils.PF_CLIMBING | Gameutils.PF_WEAPON_DOWN);
                sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
                Player.DoPlayerBeginRun(pp);
                return;
            }
        } else {
            Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaClimb);
        }
        sp.setZ(pp.posz + PLAYER_HEIGHT);
        Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        Player.DoPlayerHorizon(pp);
        boolean LadderUpdate = false;
        if (Gameutils.FAF_ConnectArea(pp.cursectnum)) {
            pp.cursectnum = Main.engine.updatesectorz(pp.posx, pp.posy, pp.posz, pp.cursectnum);
            LadderUpdate = true;
        }
        if (Warp.WarpPlane(pp.posx, pp.posy, pp.posz, pp.cursectnum) != null) {
            pp.posx = Warp.warp.x;
            pp.posy = Warp.warp.y;
            pp.posz = Warp.warp.z;
            pp.cursectnum = Warp.warp.sectnum;
            Player.PlayerWarpUpdatePos(pp);
            LadderUpdate = true;
        }
        if (LadderUpdate) {
            WangSprite lsp;
            Main.engine.neartag(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.getAnglei(), Engine.neartag, 800, 3);
            Wall tagWall = Main.boardService.getWall(Engine.neartag.tagwall);
            Sprite psp = pp.getSprite();
            if (psp != null && tagWall != null && (lsp = Main.boardService.getSprite(Player.FindNearSprite(psp, 53))) != null) {
                int nx = Gameutils.MOVEx(100, lsp.getAng());
                int ny = Gameutils.MOVEy(100, lsp.getAng());
                pp.LadderAngle = Gameutils.NORM_ANGLE(lsp.getAng() + 1024);
                pp.LadderSector = tagWall.getNextsector();
                pp.lx = lsp.getX() + nx * 5;
                pp.ly = lsp.getY() + ny * 5;
                pp.pang = pp.LadderAngle;
            }
        }
    }

    public static boolean DoPlayerWadeSuperJump(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(pp.cursectnum);
        if (sec == null) {
            return false;
        }
        int zh = sec.getFloorz() - Gameutils.Z(pp.WadeDepth) - Gameutils.Z(2);
        if (WangNetwork.Prediction) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            Sprite psp;
            ru.m210projects.Build.Types.Sector hitSec;
            Rooms.FAFhitscan(pp.posx, pp.posy, zh, pp.cursectnum, EngineUtils.sin(Gameutils.NORM_ANGLE(pp.getAnglei() + angs[i] + 512)), EngineUtils.sin(Gameutils.NORM_ANGLE(pp.getAnglei() + angs[i])), 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
            Wall wall = Main.boardService.getWall(Engine.pHitInfo.hitwall);
            if (wall == null || Engine.pHitInfo.hitsect == -1 || (hitSec = Main.boardService.getSector(wall.getNextsector())) == null || Pragmas.klabs(hitSec.getFloorz() - pp.posz) >= Gameutils.Z(50) || (psp = pp.getSprite()) == null || Game.Distance(pp.posx, pp.posy, Engine.pHitInfo.hitx, Engine.pHitInfo.hity) >= (psp.getClipdist() << 2) + 256) continue;
            return true;
        }
        return false;
    }

    public static boolean PlayerFlyKey(PlayerStr pp) {
        if (!Game.GodMode) {
            return false;
        }
        if (Game.MessageInputMode) {
            return false;
        }
        boolean key = Gameutils.TEST_SYNC_KEY(pp, 15);
        if (key) {
            Gameutils.RESET_SYNC_KEY(pp, 15);
        }
        return key;
    }

    public static void DoPlayerBeginCrawl(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        pp.Flags &= ~(Gameutils.PF_FALLING | Gameutils.PF_JUMPING);
        pp.Flags |= Gameutils.PF_CRAWLING;
        pp.friction = 45056;
        pp.floor_dist = PLAYER_CRAWL_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_CRAWL_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerCrawl;
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Crawl);
    }

    public static boolean PlayerFallTest(PlayerStr pp, int player_height) {
        if (Pragmas.klabs(pp.posz - pp.loz) > player_height + PLAYER_FALL_HEIGHT) {
            ru.m210projects.Build.Types.Sector loSec = Main.boardService.getSector(pp.lo_sectp);
            return loSec == null || Pragmas.klabs(loSec.getFloorheinum()) <= 3000 || !MyTypes.TEST(loSec.getFloorstat(), Gameutils.FLOOR_STAT_SLOPE) || pp.lo_sectp != pp.lastcursectnum;
        }
        return false;
    }

    public static void DoPlayerCrawl(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector loSec;
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        if (Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            ru.m210projects.Build.Types.Sector psec = Main.boardService.getSector(pp.cursectnum);
            if (psec != null && Gameutils.FAF_ConnectArea(pp.cursectnum)) {
                pp.posz = psec.getCeilingz() + Gameutils.Z(12);
            }
            Player.DoPlayerBeginDiveNoWarp(pp);
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_CRAWL)) {
            if (Gameutils.TEST_SYNC_KEY(pp, 14)) {
                if (Gameutils.FLAG_KEY_PRESSED(pp, 14) && Pragmas.klabs(pp.loz - pp.hiz) >= PLAYER_STANDING_ROOM) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 14);
                    pp.Flags &= ~Gameutils.PF_CRAWLING;
                    Player.DoPlayerBeginRun(pp);
                    return;
                }
            } else {
                Gameutils.FLAG_KEY_RESET(pp, 14);
            }
            if (Gameutils.TEST_SYNC_KEY(pp, 19) && Pragmas.klabs(pp.loz - pp.hiz) >= PLAYER_STANDING_ROOM) {
                pp.Flags &= ~Gameutils.PF_CRAWLING;
                Player.DoPlayerBeginRun(pp);
                return;
            }
        } else if (!Gameutils.TEST_SYNC_KEY(pp, 20) && Pragmas.klabs(pp.loz - pp.hiz) >= PLAYER_STANDING_ROOM) {
            pp.Flags &= ~Gameutils.PF_CRAWLING;
            Player.DoPlayerBeginRun(pp);
            return;
        }
        if ((loSec = Main.boardService.getSector(pp.lo_sectp)) != null && MyTypes.TEST(loSec.getExtra(), Gameutils.SECTFX_CURRENT)) {
            Player.DoPlayerCurrent(pp);
        }
        Player.DoPlayerMove(pp);
        if (pp.WadeDepth > 30) {
            pp.Flags &= ~Gameutils.PF_CRAWLING;
            Player.DoPlayerBeginRun(pp);
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Crawl);
        }
        if (Player.PlayerFallTest(pp, PLAYER_CRAWL_HEIGHT)) {
            pp.jump_speed = Gameutils.Z(1);
            pp.Flags &= ~Gameutils.PF_CRAWLING;
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            return;
        }
        ru.m210projects.Build.Types.Sector psec = Main.boardService.getSector(pp.cursectnum);
        if (psec != null && MyTypes.TEST(psec.getExtra(), Gameutils.SECTFX_DYNAMIC_AREA)) {
            pp.posz = pp.loz - PLAYER_CRAWL_HEIGHT;
        }
        Player.DoPlayerBob(pp);
        Player.DoPlayerCrawlHeight(pp);
    }

    public static void DoPlayerBeginFly(PlayerStr pp) {
        pp.Flags &= ~(Gameutils.PF_FALLING | Gameutils.PF_JUMPING | Gameutils.PF_CRAWLING);
        pp.Flags |= Gameutils.PF_FLYING;
        pp.friction = 55808;
        pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerFly;
        pp.z_speed = -Gameutils.Z(10);
        pp.jump_speed = 0;
        pp.bob_amt = 0;
        pp.bob_ndx = 1024;
        Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaFly);
    }

    public static void PlayerWarpUpdatePos(PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return;
        }
        pp.oposx = pp.posx;
        pp.oposy = pp.posy;
        pp.oposz = pp.posz;
        Player.DoPlayerZrange(pp);
        Player.UpdatePlayerSprite(pp);
    }

    public static boolean PlayerCeilingHit(PlayerStr pp, int zlimit) {
        return pp.posz < zlimit;
    }

    public static boolean PlayerFloorHit(PlayerStr pp, int zlimit) {
        return pp.posz > zlimit;
    }

    public static void DoPlayerFly(PlayerStr pp) {
        if (Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            Player.DoPlayerBeginDiveNoWarp(pp);
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 20)) {
            pp.z_speed += 1000;
            if (pp.z_speed > 2560) {
                pp.z_speed = 2560;
            }
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 19)) {
            pp.z_speed -= 1000;
            if (pp.z_speed < -2560) {
                pp.z_speed = -2560;
            }
        }
        pp.z_speed = Pragmas.mulscale(pp.z_speed, 58000L, 16);
        pp.posz += pp.z_speed;
        if (Player.PlayerCeilingHit(pp, pp.hiz + PLAYER_FLY_BOB_AMT + Gameutils.Z(8))) {
            pp.posz = pp.hiz + PLAYER_FLY_BOB_AMT + Gameutils.Z(8);
            pp.z_speed = 0;
        }
        if (Player.PlayerFloorHit(pp, pp.loz - PLAYER_HEIGHT - PLAYER_FLY_BOB_AMT)) {
            pp.posz = pp.loz - PLAYER_HEIGHT - PLAYER_FLY_BOB_AMT;
            pp.z_speed = 0;
        }
        if (Player.PlayerFlyKey(pp)) {
            pp.Flags &= ~Gameutils.PF_FLYING;
            pp.bob_amt = 0;
            pp.bob_ndx = 0;
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            return;
        }
        Player.DoPlayerMove(pp);
    }

    public static int FindNearSprite(@NotNull Sprite sp, int stat) {
        if (sp == null) {
            Player.$$$reportNull$$$0(0);
        }
        int near_dist = 15000;
        int near_fp = -1;
        ListNode<Sprite> node = Main.boardService.getStatNode(stat);
        while (node != null) {
            ListNode<Sprite> next_fs = node.getNext();
            Sprite fp = node.get();
            int dist = Game.Distance(sp.getX(), sp.getY(), fp.getX(), fp.getY());
            if (dist < near_dist) {
                near_dist = dist;
                near_fp = node.getIndex();
            }
            node = next_fs;
        }
        return near_fp;
    }

    public static boolean PlayerOnLadder(PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return false;
        }
        Main.engine.neartag(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.getAnglei(), Engine.neartag, 1792, 3);
        short neartagwall = Engine.neartag.tagwall;
        int dir = Gameutils.DOT_PRODUCT_2D(pp.xvect, pp.yvect, EngineUtils.sin(Gameutils.NORM_ANGLE(pp.getAnglei() + 512)), EngineUtils.sin(pp.getAnglei()));
        if (dir < 0) {
            return false;
        }
        Wall nearWall = Main.boardService.getWall(neartagwall);
        if (nearWall == null || nearWall.getLotag() != 305) {
            return false;
        }
        Wall tagWall = null;
        for (short angle : angles) {
            Wall hitWall;
            Main.engine.neartag(pp.posx, pp.posy, pp.posz, pp.cursectnum, Gameutils.NORM_ANGLE(pp.getAnglei() + angle), Engine.neartag, 600, 3);
            int dist = Engine.neartag.taghitdist;
            tagWall = Main.boardService.getWall(Engine.neartag.tagwall);
            if (tagWall == null || dist < 100 || tagWall.getLotag() != 305) {
                return false;
            }
            Rooms.FAFhitscan(pp.posx, pp.posy, pp.posz, pp.cursectnum, EngineUtils.sin(Gameutils.NORM_ANGLE(pp.getAnglei() + angle + 512)), EngineUtils.sin(Gameutils.NORM_ANGLE(pp.getAnglei() + angle)), 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
            WangSprite hitSpr = Main.boardService.getSprite(Engine.pHitInfo.hitsprite);
            if (!(hitSpr != null ? MyTypes.TEST(hitSpr.getCstat(), Gameutils.CSTAT_SPRITE_BLOCK) && !MyTypes.TEST(hitSpr.getCstat(), Gameutils.CSTAT_SPRITE_WALL) : (hitWall = Main.boardService.getWall(Engine.pHitInfo.hitwall)) != null && hitWall.getLotag() != 305)) continue;
            return false;
        }
        Sprite psp = pp.getSprite();
        if (psp == null) {
            return false;
        }
        int lspi = Player.FindNearSprite(psp, 53);
        WangSprite lsp = Main.boardService.getSprite(lspi);
        if (lsp == null) {
            return false;
        }
        int nx = Gameutils.MOVEx(100, lsp.getAng());
        int ny = Gameutils.MOVEy(100, lsp.getAng());
        pp.LadderAngle = Gameutils.NORM_ANGLE(lsp.getAng() + 1024);
        pp.LadderSector = tagWall.getNextsector();
        pp.lx = lsp.getX() + nx * 5;
        pp.ly = lsp.getY() + ny * 5;
        pp.pang = pp.LadderAngle;
        return true;
    }

    public static boolean DoPlayerTestCrawl(PlayerStr pp) {
        return Pragmas.klabs(pp.loz - pp.hiz) < PLAYER_STANDING_ROOM;
    }

    public static boolean PlayerInDiveArea(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sectp;
        if (Main.boardService.getSector(pp.lo_sectp) != null && (sectp = Main.boardService.getSector(pp.cursectnum)) != null && MyTypes.TEST(sectp.getExtra(), Gameutils.SECTFX_DIVE_AREA)) {
            Player.CheckFootPrints(pp);
            return true;
        }
        return false;
    }

    public static boolean PlayerCanDive(PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return false;
        }
        if ((Gameutils.TEST_SYNC_KEY(pp, 20) || Gameutils.TEST_SYNC_KEY(pp, 14) || pp.jump_speed > 0) && Player.PlayerInDiveArea(pp)) {
            pp.posz += Gameutils.Z(20);
            pp.z_speed = Gameutils.Z(20);
            pp.jump_speed = 0;
            if (pp.posz > pp.loz - Gameutils.Z(pp.WadeDepth) - Gameutils.Z(2)) {
                Player.DoPlayerBeginDive(pp);
            }
            return true;
        }
        return false;
    }

    public static boolean PlayerCanDiveNoWarp(PlayerStr pp) {
        int sectnum;
        ru.m210projects.Build.Types.Sector sec;
        Sprite psp;
        if (WangNetwork.Prediction) {
            return false;
        }
        if (pp.jump_speed > 1400 && (psp = pp.getSprite()) != null && Gameutils.FAF_ConnectArea(pp.cursectnum) && (sec = Main.boardService.getSector(sectnum = Main.engine.updatesectorz(pp.posx, pp.posy, Gameutils.SPRITEp_BOS(psp), pp.cursectnum))) != null && Gameutils.SectorIsUnderwaterArea(sectnum)) {
            pp.cursectnum = sectnum;
            pp.posz = sec.getCeilingz();
            pp.posz += Gameutils.Z(20);
            pp.z_speed = Gameutils.Z(20);
            pp.jump_speed = 0;
            Sound.PlaySound(196, pp, 8);
            Player.DoPlayerBeginDiveNoWarp(pp);
            return true;
        }
        return false;
    }

    public static int GetOverlapSector(int x, int y, LONGp over, LONGp under) {
        Sect_User usu = Sector.getSectUser(under.value);
        Sect_User osu = Sector.getSectUser(over.value);
        if (usu != null && usu.number >= 30000 || osu != null && osu.number >= 30000) {
            return Player.GetOverlapSector2(x, y, over, under);
        }
        int found = 0;
        if (Main.engine.inside(x, y, over.value) != 0) {
            Player.sf[found] = over.value;
            ++found;
        }
        if (Main.engine.inside(x, y, under.value) != 0) {
            Player.sf[found] = under.value;
            ++found;
        }
        if (found == 0) {
            for (int i = 0; i < Main.boardService.getSectorCount() && found < 2; ++i) {
                if (Main.engine.inside(x, y, i) == 0) continue;
                Player.sf[found] = i;
                ++found;
            }
        }
        if (found == 0) {
            return 0;
        }
        if (found == 2) {
            ru.m210projects.Build.Types.Sector s0 = Main.boardService.getSector(sf[0]);
            ru.m210projects.Build.Types.Sector s1 = Main.boardService.getSector(sf[1]);
            if (s0 != null && s1 != null && s0.getFloorz() > s1.getFloorz()) {
                under.value = sf[0];
                over.value = sf[1];
            } else {
                under.value = sf[1];
                over.value = sf[0];
            }
        } else {
            over.value = sf[0];
            under.value = -1;
        }
        return found;
    }

    private static int GetOverlapSector2(int x, int y, LONGp over, LONGp under) {
        int found = 0;
        if (Main.engine.inside(x, y, over.value) != 0) {
            Player.sf[found] = over.value;
            ++found;
        }
        if (Main.engine.inside(x, y, under.value) != 0) {
            Player.sf[found] = under.value;
            ++found;
        }
        if (found == 0) {
            ListNode<Sprite> nexti;
            ListNode<Sprite> node = Main.boardService.getStatNode(49);
            while (node != null) {
                nexti = node.getNext();
                Sprite sp = (Sprite)node.get();
                if (Main.engine.inside(x, y, sp.getSectnum()) != 0) {
                    Player.sf[found] = sp.getSectnum();
                    ++found;
                }
                node = nexti;
            }
            for (Object i : (ListNode<Sprite>)UnderStatList) {
                ListNode<Sprite> node2 = Main.boardService.getStatNode((int)i);
                while (node2 != null) {
                    nexti = node2.getNext();
                    Sprite sp = node2.get();
                    if (sp.getLotag() != 0 && Main.engine.inside(x, y, sp.getSectnum()) != 0) {
                        Player.sf[found] = sp.getSectnum();
                        ++found;
                    }
                    node2 = nexti;
                }
            }
        }
        if (found == 0) {
            return 0;
        }
        if (found == 2) {
            ru.m210projects.Build.Types.Sector s0 = Main.boardService.getSector(sf[0]);
            ru.m210projects.Build.Types.Sector s1 = Main.boardService.getSector(sf[1]);
            if (s0 != null && s1 != null && s0.getFloorz() > s1.getFloorz()) {
                under.value = sf[0];
                over.value = sf[1];
            } else {
                under.value = sf[1];
                over.value = sf[0];
            }
        } else {
            over.value = sf[0];
            under.value = -1;
        }
        return found;
    }

    public static void DoPlayerWarpToUnderwater(PlayerStr pp) {
        Sect_User su;
        ru.m210projects.Build.Types.Sector s;
        ListNode<Sprite> nexti;
        USER u = Gameutils.getUser(pp.PlayerSprite);
        Sect_User sectu = Sector.getSectUser(pp.cursectnum);
        if (sectu == null || u == null || WangNetwork.Prediction) {
            return;
        }
        Sprite under_sp = null;
        Sprite over_sp = null;
        boolean Found = false;
        ListNode<Sprite> node = Main.boardService.getStatNode(49);
        while (node != null) {
            nexti = node.getNext();
            over_sp = node.get();
            s = Main.boardService.getSector(over_sp.getSectnum());
            su = Sector.getSectUser(over_sp.getSectnum());
            if (s != null && MyTypes.TEST(s.getExtra(), Gameutils.SECTFX_DIVE_AREA) && su != null && su.number == sectu.number) {
                Found = true;
                break;
            }
            node = nexti;
        }
        if (!Found) {
            return;
        }
        Found = false;
        node = Main.boardService.getStatNode(50);
        while (node != null) {
            nexti = node.getNext();
            under_sp = node.get();
            s = Main.boardService.getSector(under_sp.getSectnum());
            su = Sector.getSectUser(under_sp.getSectnum());
            if (s != null && MyTypes.TEST(s.getExtra(), Gameutils.SECTFX_UNDERWATER) && su != null && su.number == sectu.number) {
                Found = true;
                break;
            }
            node = nexti;
        }
        if (!Found) {
            return;
        }
        u.sx = over_sp.getX() - pp.posx;
        u.sy = over_sp.getY() - pp.posy;
        pp.posx = under_sp.getX() - u.sx;
        pp.posy = under_sp.getY() - u.sy;
        pp.cursectnum = Player.GetOverlapSector(pp.posx, pp.posy, Game.tmp_ptr[0].set(over_sp.getSectnum()), Game.tmp_ptr[1].set(under_sp.getSectnum())) == 2 ? Game.tmp_ptr[1].value : Game.tmp_ptr[0].value;
        ru.m210projects.Build.Types.Sector s2 = Main.boardService.getSector(under_sp.getSectnum());
        if (s2 != null) {
            pp.posz = s2.getCeilingz() + Gameutils.Z(6);
        }
        pp.oposx = pp.posx;
        pp.oposy = pp.posy;
        pp.oposz = pp.posz;
        Player.DoPlayerZrange(pp);
    }

    public static void DoPlayerWarpToSurface(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector s;
        Sect_User su;
        ru.m210projects.Build.Types.Sector s2;
        ListNode<Sprite> nexti;
        USER u = Gameutils.getUser(pp.PlayerSprite);
        Sect_User sectu = Sector.getSectUser(pp.cursectnum);
        Sprite under_sp = null;
        Sprite over_sp = null;
        boolean Found = false;
        if (sectu == null || u == null || WangNetwork.Prediction) {
            return;
        }
        ListNode<Sprite> node = Main.boardService.getStatNode(50);
        while (node != null) {
            nexti = node.getNext();
            under_sp = node.get();
            s2 = Main.boardService.getSector(under_sp.getSectnum());
            su = Sector.getSectUser(under_sp.getSectnum());
            if (s2 != null && MyTypes.TEST(s2.getExtra(), Gameutils.SECTFX_UNDERWATER) && su != null && su.number == sectu.number) {
                Found = true;
                break;
            }
            node = nexti;
        }
        if (!Found) {
            return;
        }
        Found = false;
        node = Main.boardService.getStatNode(49);
        while (node != null) {
            nexti = node.getNext();
            over_sp = node.get();
            s2 = Main.boardService.getSector(over_sp.getSectnum());
            su = Sector.getSectUser(over_sp.getSectnum());
            if (s2 != null && MyTypes.TEST(s2.getExtra(), Gameutils.SECTFX_DIVE_AREA) && su != null && su.number == sectu.number) {
                Found = true;
                break;
            }
            node = nexti;
        }
        if (!Found) {
            return;
        }
        u.sx = under_sp.getX() - pp.posx;
        u.sy = under_sp.getY() - pp.posy;
        pp.posx = over_sp.getX() - u.sx;
        pp.posy = over_sp.getY() - u.sy;
        if (Player.GetOverlapSector(pp.posx, pp.posy, Game.tmp_ptr[0].set(over_sp.getSectnum()), Game.tmp_ptr[1].set(under_sp.getSectnum())) != 0) {
            pp.cursectnum = Game.tmp_ptr[0].value;
        }
        if ((s = Main.boardService.getSector(over_sp.getSectnum())) != null) {
            pp.posz = s.getFloorz() - Gameutils.Z(2);
        }
        Player.DoPlayerZrange(pp);
        Player.DoPlayerSetWadeDepth(pp);
        pp.posz -= Gameutils.Z(pp.WadeDepth);
        pp.oposx = pp.posx;
        pp.oposy = pp.posy;
        pp.oposz = pp.posz;
    }

    public static void DoPlayerBeginDive(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (sp == null || u == null || WangNetwork.Prediction) {
            return;
        }
        if (pp.Bloody) {
            pp.Bloody = false;
        }
        pp.Flags |= Gameutils.PF_DIVING;
        Palette.DoPlayerDivePalette(pp);
        Palette.DoPlayerNightVisionPalette(pp);
        if (pp == Game.Player[Game.screenpeek]) {
            Sound.COVER_SetReverb(140);
            pp.Reverb = 140;
        }
        Weapon.SpawnSplash(pp.PlayerSprite);
        Player.DoPlayerWarpToUnderwater(pp);
        Sector.OperateTripTrigger(pp);
        pp.Flags &= ~(Gameutils.PF_JUMPING | Gameutils.PF_FALLING);
        pp.Flags &= ~Gameutils.PF_CRAWLING;
        pp.Flags &= ~Gameutils.PF_LOCK_CRAWL;
        pp.friction = 49152;
        pp.ceiling_dist = PLAYER_DIVE_CEILING_DIST;
        pp.floor_dist = PLAYER_DIVE_FLOOR_DIST;
        sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        pp.DoPlayerAction = Player_Action_Func.DoPlayerDive;
        pp.DiveTics = 1440;
        pp.DiveDamageTics = 0;
        Player.DoPlayerMove(pp);
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Dive);
        Player.DoPlayerDive(pp);
    }

    public static void DoPlayerBeginDiveNoWarp(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (sp == null || u == null || WangNetwork.Prediction) {
            return;
        }
        if (!Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            return;
        }
        if (pp.Bloody) {
            pp.Bloody = false;
        }
        if (pp == Game.Player[Game.screenpeek]) {
            Sound.COVER_SetReverb(140);
            pp.Reverb = 140;
        }
        Player.CheckFootPrints(pp);
        ru.m210projects.Build.Types.Sector loSec = Main.boardService.getSector(pp.lo_sectp);
        if (loSec != null && MyTypes.DTEST(loSec.getExtra(), Gameutils.SECTFX_LIQUID_MASK) == Gameutils.SECTFX_LIQUID_LAVA) {
            pp.Flags |= Gameutils.PF_DIVING_IN_LAVA;
            u.DamageTics = 0;
        }
        pp.Flags |= Gameutils.PF_DIVING;
        Palette.DoPlayerDivePalette(pp);
        Palette.DoPlayerNightVisionPalette(pp);
        pp.Flags &= ~(Gameutils.PF_JUMPING | Gameutils.PF_FALLING);
        pp.friction = 49152;
        pp.ceiling_dist = PLAYER_DIVE_CEILING_DIST;
        pp.floor_dist = PLAYER_DIVE_FLOOR_DIST;
        sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        pp.DoPlayerAction = Player_Action_Func.DoPlayerDive;
        pp.z_speed = 0;
        pp.DiveTics = 1440;
        pp.DiveDamageTics = 0;
        Player.DoPlayerMove(pp);
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Dive);
        Player.DoPlayerDive(pp);
    }

    public static void DoPlayerStopDiveNoWarp(PlayerStr pp) {
        Sprite psp = pp.getSprite();
        if (psp == null || WangNetwork.Prediction) {
            return;
        }
        if (pp.TalkVocHandle != null && pp.TalkVocHandle.isActive()) {
            pp.TalkVocHandle.stop();
            pp.TalkVocHandle = null;
            pp.TalkVocnum = -1;
            pp.PlayerTalking = false;
        }
        Sound.PlayerSound(476, 13, pp);
        pp.bob_amt = 0;
        pp.Flags &= ~(Gameutils.PF_DIVING | Gameutils.PF_DIVING_IN_LAVA);
        Palette.DoPlayerDivePalette(pp);
        Palette.DoPlayerNightVisionPalette(pp);
        psp.setCstat(psp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
        if (pp == Game.Player[Game.screenpeek]) {
            Sound.COVER_SetReverb(0);
            pp.Reverb = 0;
        }
        Player.DoPlayerZrange(pp);
    }

    public static void DoPlayerStopDive(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        if (sp == null || WangNetwork.Prediction) {
            return;
        }
        if (pp.TalkVocHandle != null && pp.TalkVocHandle.isActive()) {
            pp.TalkVocHandle.stop();
        }
        pp.TalkVocnum = -1;
        pp.TalkVocHandle = null;
        pp.PlayerTalking = false;
        Sound.PlayerSound(476, 13, pp);
        pp.bob_amt = 0;
        Player.DoPlayerWarpToSurface(pp);
        Player.DoPlayerBeginWade(pp);
        pp.Flags &= ~(Gameutils.PF_DIVING | Gameutils.PF_DIVING_IN_LAVA);
        Palette.DoPlayerDivePalette(pp);
        Palette.DoPlayerNightVisionPalette(pp);
        sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
        if (pp == Game.Player[Game.screenpeek]) {
            Sound.COVER_SetReverb(0);
            pp.Reverb = 0;
        }
    }

    public static void DoPlayerDiveMeter(PlayerStr pp) {
        if (pp != Game.Player[Mmulti.myconnectindex]) {
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING | Gameutils.PF_DIVING_IN_LAVA)) {
            return;
        }
        Renderer renderer = Main.game.getRenderer();
        int meterunit = 48;
        int metertics = pp.DiveTics / meterunit;
        if (metertics <= 0 && !MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING | Gameutils.PF_DIVING_IN_LAVA)) {
            return;
        }
        if (metertics <= 0) {
            return;
        }
        int y = Mmulti.numplayers < 2 ? 10 : (Mmulti.numplayers <= 4 ? 20 : 30);
        int color = metertics <= 12 && metertics > 6 ? 20 : (metertics <= 6 ? 25 : 22);
        renderer.rotatesprite(0xD00000, y << 16, 65536, 0, 5408, 1, 1, Gameutils.ROTATE_SPRITE_SCREEN_CLIP);
        renderer.rotatesprite(0x1090000, y << 16, 65536, 0, 5406 - metertics, 1, color, Gameutils.ROTATE_SPRITE_SCREEN_CLIP);
    }

    public static void DoPlayerDive(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector loSec;
        ru.m210projects.Build.Types.Sector psec = Main.boardService.getSector(pp.cursectnum);
        USER u = Gameutils.getUser(pp.PlayerSprite);
        Sect_User sectu = Sector.getSectUser(pp.cursectnum);
        if (psec == null || u == null) {
            return;
        }
        if (!Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            Player.DoPlayerStopDiveNoWarp(pp);
            Player.DoPlayerBeginRun(pp);
            return;
        }
        if ((pp.DiveTics -= 3) < 0 && (pp.DiveDamageTics -= 3) < 0) {
            pp.DiveDamageTics = 50;
            Sound.PlayerSound(502, 9, pp);
            Panel.PlayerUpdateHealth(pp, -3 - (Gameutils.RANDOM_RANGE(1792) >> 8));
            Weapon.PlayerCheckDeath(pp, -1);
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                return;
            }
        }
        if ((loSec = Main.boardService.getSector(pp.lo_sectp)) != null && MyTypes.TEST(loSec.getExtra(), Gameutils.SECTFX_CURRENT)) {
            Player.DoPlayerCurrent(pp);
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING_IN_LAVA) && (u.DamageTics -= 3) < 0) {
            u.DamageTics = 30;
            Panel.PlayerUpdateHealth(pp, -40);
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 20) || Gameutils.TEST_SYNC_KEY(pp, 14)) {
            pp.z_speed += 600;
            if (pp.z_speed > 1700) {
                pp.z_speed = 1700;
            }
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 19)) {
            pp.z_speed -= 600;
            if (pp.z_speed < -1700) {
                pp.z_speed = -1700;
            }
        }
        pp.z_speed = Pragmas.mulscale(pp.z_speed, 58000L, 16);
        if (Pragmas.klabs(pp.z_speed) < 16) {
            pp.z_speed = 0;
        }
        pp.posz += pp.z_speed;
        if (pp.z_speed < 0 && Gameutils.FAF_ConnectArea(pp.cursectnum) && pp.posz < psec.getCeilingz() + Gameutils.Z(10)) {
            int sectnum = pp.cursectnum;
            sectnum = Main.engine.updatesectorz(pp.posx, pp.posy, psec.getCeilingz() - Gameutils.Z(8), sectnum);
            if (sectnum >= 0 && !Gameutils.SectorIsUnderwaterArea(sectnum)) {
                pp.posz = psec.getCeilingz() - Gameutils.Z(8);
                pp.cursectnum = sectnum;
                Player.DoPlayerStopDiveNoWarp(pp);
                Player.DoPlayerBeginRun(pp);
                return;
            }
        }
        if (sectu != null && (sectu.number == 0 || MyTypes.TEST(sectu.flags, Gameutils.SECTFU_CANT_SURFACE))) {
            if (pp.posz < pp.hiz + pp.ceiling_dist) {
                pp.posz = pp.hiz + pp.ceiling_dist;
            }
        } else if (pp.posz < pp.hiz + Gameutils.Z(4) && pp.hi_sp == -1) {
            Player.DoPlayerStopDive(pp);
            return;
        }
        if (pp.posz >= pp.loz - PLAYER_DIVE_HEIGHT) {
            pp.posz = pp.loz - PLAYER_DIVE_HEIGHT;
        }
        if (Gameutils.PLAYER_MOVING(pp) == 0 && pp.z_speed == 0 && pp.up_speed == 0) {
            Player.DoPlayerSpriteBob(pp, PLAYER_DIVE_HEIGHT, PLAYER_DIVE_BOB_AMT, 3);
        } else if (Pragmas.klabs(pp.bob_amt) < Gameutils.Z(1)) {
            pp.bob_amt = 0;
            pp.bob_ndx = 0;
        } else {
            Player.DoPlayerSpriteBob(pp, PLAYER_DIVE_HEIGHT, PLAYER_DIVE_BOB_AMT, 3);
        }
        if (pp.posz + pp.bob_amt >= pp.loz - PLAYER_DIVE_HEIGHT) {
            pp.bob_ndx = Gameutils.NORM_ANGLE(pp.bob_ndx + (1536 - pp.bob_ndx) * 2);
            Player.DoPlayerSpriteBob(pp, PLAYER_DIVE_HEIGHT, PLAYER_DIVE_BOB_AMT, 3);
        }
        if (pp.posz + pp.bob_amt < pp.hiz + pp.ceiling_dist) {
            pp.bob_ndx = Gameutils.NORM_ANGLE(pp.bob_ndx + (512 - pp.bob_ndx) * 2);
            Player.DoPlayerSpriteBob(pp, PLAYER_DIVE_HEIGHT, PLAYER_DIVE_BOB_AMT, 3);
        }
        Player.DoPlayerMove(pp);
        if (!WangNetwork.Prediction && pp.z_speed != 0 && Gameutils.RANDOM_P2(32768) >> 5 < 64 || Gameutils.PLAYER_MOVING(pp) != 0 && Gameutils.RANDOM_P2(32768) >> 5 < 64) {
            Sound.PlaySound(158, pp, 0);
            int bubble = Weapon.SpawnBubble(pp.PlayerSprite);
            WangSprite bp = Main.boardService.getSprite(bubble);
            if (bp != null) {
                int nx = Gameutils.MOVEx(192, Gameutils.NORM_ANGLE(bp.getAng() + 1024));
                int ny = Gameutils.MOVEy(192, Gameutils.NORM_ANGLE(bp.getAng() + 1024));
                Sprites.move_sprite(bubble, nx, ny, 0, u.ceiling_dist, u.floor_dist, 0, 3);
            }
        }
    }

    public static boolean DoPlayerTestPlaxDeath(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(pp.lo_sectp);
        if (u != null && sec != null && MyTypes.TEST(sec.getFloorstat(), Gameutils.FLOOR_STAT_PLAX)) {
            Panel.PlayerUpdateHealth(pp, -u.Health);
            Weapon.PlayerCheckDeath(pp, -1);
            return true;
        }
        return false;
    }

    private static void DoPlayerCurrent(PlayerStr pp) {
        if (!Main.boardService.isValidSector(pp.cursectnum)) {
            return;
        }
        Sprite psp = pp.getSprite();
        Sect_User sectu = Sector.getSectUser(pp.cursectnum);
        if (psp == null || sectu == null) {
            return;
        }
        int xvect = sectu.speed * 3 * EngineUtils.sin(Gameutils.NORM_ANGLE(sectu.ang + 512)) >> 4;
        int yvect = sectu.speed * 3 * EngineUtils.sin(sectu.ang) >> 4;
        int push_ret = Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, psp.getClipdist() << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.pushmove_sectnum != -1) {
            pp.posx = Engine.pushmove_x;
            pp.posy = Engine.pushmove_y;
            pp.posz = Engine.pushmove_z;
            pp.cursectnum = Engine.pushmove_sectnum;
        }
        if (push_ret < 0) {
            USER u;
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD) && (u = Gameutils.getUser(pp.PlayerSprite)) != null) {
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
            return;
        }
        Main.engine.clipmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, xvect, yvect, psp.getClipdist() << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.clipmove_sectnum != -1) {
            pp.posx = Engine.clipmove_x;
            pp.posy = Engine.clipmove_y;
            pp.posz = Engine.clipmove_z;
            pp.cursectnum = Engine.clipmove_sectnum;
        }
        Player.PlayerCheckValidMove(pp);
        Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, psp.getClipdist() << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.pushmove_sectnum != -1) {
            pp.posx = Engine.pushmove_x;
            pp.posy = Engine.pushmove_y;
            pp.posz = Engine.pushmove_z;
            pp.cursectnum = Engine.pushmove_sectnum;
        }
    }

    public static void DoPlayerFireOutWater(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (WangNetwork.Prediction) {
            return;
        }
        if (u != null && pp.WadeDepth > 20) {
            if (u.flame >= 0) {
                Weapon.SetSuicide(u.flame);
            }
            u.flame = -2;
        }
    }

    public static void DoPlayerFireOutDeath(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null || WangNetwork.Prediction) {
            return;
        }
        if (u.flame >= 0) {
            Weapon.SetSuicide(u.flame);
        }
        u.flame = -2;
    }

    public static void DoPlayerBeginWade(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (Player.DoPlayerTestPlaxDeath(pp)) {
            return;
        }
        pp.Flags &= ~(Gameutils.PF_JUMPING | Gameutils.PF_FALLING);
        pp.Flags &= ~Gameutils.PF_CRAWLING;
        pp.friction = 50000;
        pp.floor_dist = PLAYER_WADE_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_WADE_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerWade;
        Player.DoPlayerFireOutWater(pp);
        if (pp.jump_speed > 100) {
            Weapon.SpawnSplash(pp.PlayerSprite);
        }
        if (pp.jump_speed > 0 && pp.jump_speed < 1300) {
            pp.jump_speed = 0;
        }
        if (u != null) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
        }
    }

    public static void DoPlayerWade(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        Player.DoPlayerFireOutWater(pp);
        if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
            ru.m210projects.Build.Types.Sector sec;
            if (Gameutils.FLAG_KEY_PRESSED(pp, 18) && (sec = Main.boardService.getSector(pp.cursectnum)) != null && MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_OPERATIONAL)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 18);
                Player.DoPlayerBeginOperate(pp);
                pp.bob_amt = 0;
                pp.bob_ndx = 0;
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 18);
        }
        if (Player.DoPlayerTestCrawl(pp) && pp.WadeDepth <= 30) {
            Player.DoPlayerBeginCrawl(pp);
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 20) && pp.WadeDepth <= 30) {
            Player.DoPlayerBeginCrawl(pp);
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 19)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 19)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 19);
                Player.DoPlayerBeginJump(pp);
                pp.bob_amt = 0;
                pp.bob_ndx = 0;
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 19);
        }
        if (Player.PlayerFlyKey(pp)) {
            Player.DoPlayerBeginFly(pp);
            pp.bob_amt = 0;
            pp.bob_ndx = 0;
            return;
        }
        if (Player.PlayerOnLadder(pp)) {
            Player.DoPlayerBeginClimb(pp);
            return;
        }
        ru.m210projects.Build.Types.Sector loSec = Main.boardService.getSector(pp.lo_sectp);
        if (loSec != null && MyTypes.TEST(loSec.getExtra(), Gameutils.SECTFX_CURRENT)) {
            Player.DoPlayerCurrent(pp);
        }
        Player.DoPlayerMove(pp);
        if (u != null) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
                if (u.getRot() != u.ActorActionSet.Run) {
                    Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
                }
            } else if (u.getRot() != u.ActorActionSet.Stand) {
                Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
            }
        }
        if (Pragmas.klabs(pp.posz - pp.loz) > PLAYER_HEIGHT + PLAYER_FALL_HEIGHT) {
            pp.jump_speed = Gameutils.Z(1);
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            return;
        }
        if (Player.PlayerCanDive(pp)) {
            pp.bob_amt = 0;
            pp.bob_ndx = 0;
            return;
        }
        if (Pragmas.klabs(pp.posz - pp.loz) > PLAYER_HEIGHT + PLAYER_FALL_HEIGHT) {
            pp.jump_speed = Gameutils.Z(1);
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            pp.bob_amt = 0;
            pp.bob_ndx = 0;
            return;
        }
        Player.DoPlayerBob(pp);
        Player.DoPlayerHeight(pp);
        if (pp.WadeDepth == 0) {
            Player.DoPlayerBeginRun(pp);
        }
    }

    public static void DoPlayerBeginOperateBoat(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerOperateBoat;
        if (MyTypes.TEST(Sprites.SectorObject[pp.sop].flags, Gameutils.SOBJ_HAS_WEAPON)) {
            pp.Flags |= Gameutils.PF_WEAPON_DOWN;
        }
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
    }

    public static void DoPlayerBeginOperateTank(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerOperateTank;
        if (MyTypes.TEST(Sprites.SectorObject[pp.sop].flags, Gameutils.SOBJ_HAS_WEAPON)) {
            pp.Flags |= Gameutils.PF_WEAPON_DOWN;
        }
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
    }

    public static void DoPlayerBeginOperateTurret(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerOperateTurret;
        if (MyTypes.TEST(Sprites.SectorObject[pp.sop].flags, Gameutils.SOBJ_HAS_WEAPON)) {
            pp.Flags |= Gameutils.PF_WEAPON_DOWN;
        }
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
    }

    public static void FindMainSector(int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.op_main_sector < 0) {
            int sx = sop.xmid;
            int sy = sop.ymid;
            Track.PlaceSectorObject(sopi, sop.ang, Integer.MAX_VALUE, Integer.MAX_VALUE);
            sop.op_main_sector = 0;
            sop.op_main_sector = Main.engine.updatesectorz(sx, sy, sop.zmid, sop.op_main_sector);
            Track.PlaceSectorObject(sopi, sop.ang, sx, sy);
        }
    }

    public static void DoPlayerOperateMatch(PlayerStr pp, boolean starting) {
        if (pp.sop == -1) {
            return;
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop == null) {
            return;
        }
        ListNode<Sprite> node = Main.boardService.getSectNode(sop.mid_sector);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (sp.getStatnum() == 500 && sp.getHitag() == 147) {
                if (starting) {
                    if (Gameutils.SP_TAG5(sp) == 0) break;
                    Sector.DoMatchEverything(pp, Gameutils.SP_TAG5(sp), -1);
                    break;
                }
                if (!Gameutils.TEST_BOOL2(sp) || Gameutils.SP_TAG5(sp) == 0) break;
                Sector.DoMatchEverything(pp, Gameutils.SP_TAG5(sp) + 1, -1);
                break;
            }
            node = nexti;
        }
    }

    public static void DoPlayerBeginOperate(PlayerStr pp) {
        int sopi = Track.PlayerOnObject(pp.cursectnum);
        if (sopi == -1) {
            Player.DoPlayerBeginRun(pp);
            return;
        }
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.controller != -1) {
            return;
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_REMOTE_ONLY)) {
            return;
        }
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            if (pp.InventoryAmount[1] != 0) {
                Inv.UseInventoryRepairKit(pp);
                USER u = Gameutils.getUser(sop.sp_child);
                if (u != null) {
                    sop.max_damage = (short)u.MaxHealth;
                    Track.VehicleSetSmoke(sop, null);
                    sop.flags &= ~Gameutils.SOBJ_BROKEN;
                }
            } else {
                Sound.PlayerSound(494, 9, pp);
                return;
            }
        }
        pp.sop = pp.sop_control = sopi;
        sop.controller = pp.PlayerSprite;
        pp.pang = sop.ang;
        pp.posx = sop.xmid;
        pp.posy = sop.ymid;
        pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
        Main.engine.getzsofslope(pp.cursectnum, pp.posx, pp.posy, Rooms.fz, Rooms.cz);
        pp.posz = Rooms.fz.get() - PLAYER_HEIGHT;
        pp.Flags &= ~(Gameutils.PF_CRAWLING | Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_LOCK_CRAWL);
        Player.DoPlayerOperateMatch(pp, true);
        int i = 0;
        while (sop.sp_num[i] != -1) {
            WangSprite s = Main.boardService.getSprite(sop.sp_num[i]);
            if (s != null && s.getStatnum() == 55) {
                sop.flags |= Gameutils.SOBJ_HAS_WEAPON;
                break;
            }
            ++i;
        }
        Player.DoPlayerResetMovement(pp);
        switch (sop.track) {
            case 98: {
                if ((pp.input.vel | pp.input.svel) != 0) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = Rooms.fz.get() - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateTank(pp);
                break;
            }
            case 96: 
            case 97: {
                if (pp.input.angvel != 0.0f) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = Rooms.fz.get() - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateTurret(pp);
                break;
            }
            case 99: {
                if ((pp.input.vel | pp.input.svel) != 0) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = Rooms.fz.get() - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateBoat(pp);
                break;
            }
        }
    }

    public static void DoPlayerBeginRemoteOperate(PlayerStr pp, int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        pp.sop_remote = pp.sop_control = sopi;
        pp.sop = pp.sop_control;
        sop.controller = pp.PlayerSprite;
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            if (pp.InventoryAmount[1] != 0) {
                USER u = Gameutils.getUser(sop.sp_child);
                if (u != null) {
                    Inv.UseInventoryRepairKit(pp);
                    sop.max_damage = (short)u.MaxHealth;
                    Track.VehicleSetSmoke(sop, null);
                    sop.flags &= ~Gameutils.SOBJ_BROKEN;
                }
            } else {
                Sound.PlayerSound(494, 9, pp);
                return;
            }
        }
        int save_sectnum = pp.cursectnum;
        pp.pang = sop.ang;
        pp.posx = sop.xmid;
        pp.posy = sop.ymid;
        pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
        Main.engine.getzsofslope(pp.cursectnum, pp.posx, pp.posy, Rooms.fz, Rooms.cz);
        pp.posz = Rooms.fz.get() - PLAYER_HEIGHT;
        pp.Flags &= ~(Gameutils.PF_CRAWLING | Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_LOCK_CRAWL);
        Player.DoPlayerOperateMatch(pp, true);
        int i = 0;
        while (sop.sp_num[i] != -1) {
            WangSprite s = Main.boardService.getSprite(sop.sp_num[i]);
            if (s != null && s.getStatnum() == 55) {
                sop.flags |= Gameutils.SOBJ_HAS_WEAPON;
                break;
            }
            ++i;
        }
        Player.DoPlayerResetMovement(pp);
        Player.PlayerToRemote(pp);
        Player.PlayerRemoteInit(pp);
        switch (sop.track) {
            case 98: {
                if ((pp.input.vel | pp.input.svel) != 0) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = Rooms.fz.get() - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateTank(pp);
                break;
            }
            case 96: 
            case 97: {
                if (pp.input.angvel != 0.0f) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = Rooms.fz.get() - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateTurret(pp);
                break;
            }
            case 99: {
                if ((pp.input.vel | pp.input.svel) != 0) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = Rooms.fz.get() - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateBoat(pp);
                break;
            }
            default: {
                return;
            }
        }
        Player.PlayerRemoteReset(pp, save_sectnum);
    }

    public static void PlayerRemoteReset(PlayerStr pp, int sectnum) {
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sectnum);
        WangSprite removeSpr = Main.boardService.getSprite(pp.remote_sprite);
        if (removeSpr == null || sec == null) {
            return;
        }
        pp.cursectnum = pp.lastcursectnum = sectnum;
        pp.posx = removeSpr.getX();
        pp.posy = removeSpr.getY();
        pp.posz = sec.getFloorz() - PLAYER_HEIGHT;
        pp.slide_yvect = 0;
        pp.slide_xvect = 0;
        pp.oyvect = 0;
        pp.oxvect = 0;
        pp.yvect = 0;
        pp.xvect = 0;
        Player.UpdatePlayerSprite(pp);
    }

    public static void PlayerRemoteInit(PlayerStr pp) {
        pp.remote.xvect = 0;
        pp.remote.yvect = 0;
        pp.remote.oxvect = 0;
        pp.remote.oyvect = 0;
        pp.remote.slide_xvect = 0;
        pp.remote.slide_yvect = 0;
    }

    public static void RemoteToPlayer(PlayerStr pp) {
        pp.cursectnum = pp.remote.cursectnum;
        pp.lastcursectnum = pp.remote.lastcursectnum;
        pp.posx = pp.remote.posx;
        pp.posy = pp.remote.posy;
        pp.posz = pp.remote.posz;
        pp.xvect = pp.remote.xvect;
        pp.yvect = pp.remote.yvect;
        pp.oxvect = pp.remote.oxvect;
        pp.oyvect = pp.remote.oyvect;
        pp.slide_xvect = pp.remote.slide_xvect;
        pp.slide_yvect = pp.remote.slide_yvect;
    }

    public static void PlayerToRemote(PlayerStr pp) {
        if (pp.remote == null) {
            pp.remote = new Remote_Control();
        }
        pp.remote.cursectnum = pp.cursectnum;
        pp.remote.lastcursectnum = pp.lastcursectnum;
        pp.remote.oposx = pp.remote.posx;
        pp.remote.oposy = pp.remote.posy;
        pp.remote.oposz = pp.remote.posz;
        pp.remote.posx = pp.posx;
        pp.remote.posy = pp.posy;
        pp.remote.posz = pp.posz;
        pp.remote.xvect = pp.xvect;
        pp.remote.yvect = pp.yvect;
        pp.remote.oxvect = pp.oxvect;
        pp.remote.oyvect = pp.oyvect;
        pp.remote.slide_xvect = pp.slide_xvect;
        pp.remote.slide_yvect = pp.slide_yvect;
    }

    public static void DoPlayerStopOperate(PlayerStr pp) {
        pp.Flags &= ~Gameutils.PF_WEAPON_DOWN;
        Player.DoPlayerResetMovement(pp);
        Player.DoTankTreads(pp);
        Player.DoPlayerOperateMatch(pp, false);
        Player.StopSOsound(Sprites.SectorObject[pp.sop].mid_sector);
        WangSprite remoteSpr = Main.boardService.getSprite(pp.remote_sprite);
        if (remoteSpr != null) {
            pp.pang = Gameutils.TEST_BOOL1(remoteSpr) ? (pp.oang = (float)remoteSpr.getAng()) : (pp.oang = (float)EngineUtils.getAngle(Sprites.SectorObject[pp.sop_remote].xmid - pp.posx, Sprites.SectorObject[pp.sop_remote].ymid - pp.posy));
        }
        if (pp.sop_control != -1) {
            Sprites.SectorObject[pp.sop_control].controller = -1;
        }
        pp.remote_sprite = -1;
        pp.sop_control = -1;
        pp.sop_riding = -1;
        pp.sop_remote = -1;
        pp.sop = -1;
        Player.DoPlayerBeginRun(pp);
    }

    public static void DoPlayerOperateTurret(PlayerStr pp) {
        if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 18)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 18);
                Player.DoPlayerStopOperate(pp);
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 18);
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            Player.DoPlayerStopOperate(pp);
            return;
        }
        int save_sectnum = pp.cursectnum;
        if (pp.sop_remote != -1) {
            Player.RemoteToPlayer(pp);
        }
        Player.DoPlayerMoveTurret(pp);
        if (pp.sop_remote != -1) {
            Player.PlayerToRemote(pp);
            Player.PlayerRemoteReset(pp, save_sectnum);
        }
    }

    public static void DoPlayerOperateBoat(PlayerStr pp) {
        if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 18)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 18);
                Player.DoPlayerStopOperate(pp);
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 18);
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            Player.DoPlayerStopOperate(pp);
            return;
        }
        int save_sectnum = pp.cursectnum;
        if (pp.sop_remote != -1) {
            Player.RemoteToPlayer(pp);
        }
        Player.DoPlayerMoveBoat(pp);
        if (pp.sop_remote != -1) {
            Player.PlayerToRemote(pp);
            Player.PlayerRemoteReset(pp, save_sectnum);
        }
    }

    public static void DoPlayerOperateTank(PlayerStr pp) {
        if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 18)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 18);
                Player.DoPlayerStopOperate(pp);
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 18);
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            Player.DoPlayerStopOperate(pp);
            return;
        }
        int save_sectnum = pp.cursectnum;
        if (pp.sop_remote != -1) {
            Player.RemoteToPlayer(pp);
        }
        Player.DoPlayerMoveTank(pp);
        if (pp.sop_remote != -1) {
            Player.PlayerToRemote(pp);
            Player.PlayerRemoteReset(pp, save_sectnum);
        }
    }

    public static void DoPlayerDeathJump(PlayerStr pp) {
        for (int i = 0; i < 3; ++i) {
            if ((pp.jump_speed += 8) > 0) {
                pp.Flags &= ~Gameutils.PF_JUMPING;
                pp.Flags |= Gameutils.PF_FALLING;
                Player.DoPlayerDeathFall(pp);
                return;
            }
            pp.posz += pp.jump_speed;
            if (!Player.PlayerCeilingHit(pp, pp.hiz + Gameutils.Z(4))) continue;
            pp.posz = pp.hiz + Gameutils.Z(4);
            pp.jump_speed = -pp.jump_speed;
            pp.Flags &= ~Gameutils.PF_JUMPING;
            pp.Flags |= Gameutils.PF_FALLING;
            Player.DoPlayerDeathFall(pp);
            return;
        }
    }

    public static void DoPlayerDeathFall(PlayerStr pp) {
        for (int i = 0; i < 3; ++i) {
            pp.jump_speed += 8;
            pp.posz += pp.jump_speed;
            ru.m210projects.Build.Types.Sector loSec = Main.boardService.getSector(pp.lo_sectp);
            int loz = loSec != null && MyTypes.TEST(loSec.getExtra(), Gameutils.SECTFX_SINK) ? loSec.getFloorz() : pp.loz;
            if (!Player.PlayerFloorHit(pp, loz - PLAYER_DEATH_HEIGHT)) continue;
            if (loz != pp.loz) {
                Weapon.SpawnSplash(pp.PlayerSprite);
            }
            if (Gameutils.RANDOM_RANGE(1000) > 500) {
                Sound.PlaySound(56, pp, 8);
            } else {
                Sound.PlaySound(410, pp, 8);
            }
            pp.posz = loz - PLAYER_DEATH_HEIGHT;
            pp.Flags &= ~Gameutils.PF_FALLING;
        }
    }

    public static String KilledPlayerMessage(PlayerStr pp, PlayerStr killer) {
        int rnd = Gameutils.STD_RANDOM_RANGE(16);
        String p1 = pp.getName();
        String p2 = killer.getName();
        if (pp.HitBy == killer.PlayerSprite) {
            return p1 + " was killed by " + p2 + ".";
        }
        switch (rnd) {
            case 0: {
                return p1 + " was wasted by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 1: {
                return p1 + " got his ass kicked by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 2: {
                return p1 + " bows down before the mighty power of " + p2 + ".";
            }
            case 3: {
                return p1 + " was killed by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 4: {
                return p1 + " got slapped down hard by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 5: {
                return p1 + " got on his knees before " + p2 + ".";
            }
            case 6: {
                return p1 + " was totally out classed by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 7: {
                return p1 + " got chewed apart by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 8: {
                return p1 + " was retired by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 9: {
                return p1 + " was greased by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 10: {
                return p1 + " was humbled lower than dirt by " + p2 + ".";
            }
            case 11: {
                return p2 + " beats " + p1 + " like a red headed step child.";
            }
            case 12: {
                return p1 + " begs for mercy as " + p2 + " terminates him with extreme prejudice.";
            }
            case 13: {
                return p1 + " falls before the superior skills of " + p2 + ".";
            }
            case 14: {
                return p2 + " gives " + p1 + " a beating he'll never forget.";
            }
            case 15: {
                return p2 + " puts the Smack Dab on " + p1 + " with his " + Weapon.DeathString(pp.HitBy);
            }
        }
        return null;
    }

    public static void DoPlayerDeathMessage(int pp, int nkiller) {
        boolean SEND_OK = false;
        String ds = null;
        PlayerStr killer = Game.Player[nkiller];
        int n = pp;
        killer.KilledPlayer[n] = killer.KilledPlayer[n] + 1;
        if (Game.Player[pp] == killer && pp == Mmulti.myconnectindex) {
            ds = Game.Player[pp].getName() + " " + SuicideNote[Gameutils.STD_RANDOM_RANGE(11)];
            SEND_OK = true;
        } else if (killer == Game.Player[Mmulti.myconnectindex]) {
            ds = Player.KilledPlayerMessage(Game.Player[pp], killer);
            SEND_OK = true;
        }
        if (SEND_OK) {
            Main.gNet.SendMessage(-1, ds);
            JPlayer.adduserquote(ds);
        }
    }

    public static void DoPlayerBeginDie(int ppnum) {
        Sprite psp;
        PlayerStr pp = Game.Player[ppnum];
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        if (WangNetwork.Prediction) {
            return;
        }
        if (Game.GodMode) {
            return;
        }
        if (pp.PlayerTalking) {
            if (pp.TalkVocHandle.isActive()) {
                pp.TalkVocHandle.stop();
            }
            pp.PlayerTalking = false;
            pp.TalkVocnum = -1;
            pp.TalkVocHandle = null;
        }
        int choosesnd = Gameutils.RANDOM_RANGE(5);
        Sound.PlayerSound(Sound.PlayerLowHealthPainVocs[choosesnd], 13, pp);
        if (Main.game.nNetMode == BuildGame.NetMode.Single && Mmulti.numplayers <= 1 && LoadSave.lastload != null && LoadSave.lastload.exists()) {
            Main.game.menu.mOpen(Main.game.menu.mMenus[16], -1);
        } else {
            int bak = Text.GlobInfoStringTime;
            Text.GlobInfoStringTime = 999;
            Text.PutStringInfo(pp, "Press \"USE\" or SPACE to restart");
            Text.GlobInfoStringTime = bak;
        }
        if (pp.sop_control != -1) {
            Player.DoPlayerStopOperate(pp);
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING)) {
            pp.DeathType = 5;
        }
        pp.Flags &= ~(Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_DIVING | Gameutils.PF_FLYING | Gameutils.PF_CLIMBING | Gameutils.PF_CRAWLING | Gameutils.PF_LOCK_CRAWL);
        pp.tilt_dest = 0;
        Sprites.ActorCoughItem(pp.PlayerSprite);
        if (Mmulti.numplayers > 1 || Main.gNet.FakeMultiplayer) {
            if (pp.Killer >= 0) {
                USER ku = Gameutils.getUser(pp.Killer);
                if (ku != null && ku.PlayerP != -1) {
                    if (pp.pnum == ku.PlayerP) {
                        Panel.PlayerUpdateKills(ppnum, -1);
                        Player.DoPlayerDeathMessage(ppnum, ppnum);
                    } else if (Main.gNet.TeamPlay) {
                        if (u.spal == ku.spal) {
                            Panel.PlayerUpdateKills(ppnum, -1);
                            Player.DoPlayerDeathMessage(ppnum, ku.PlayerP);
                        } else {
                            Panel.PlayerUpdateKills(ku.PlayerP, 1);
                            Player.DoPlayerDeathMessage(ppnum, ku.PlayerP);
                        }
                    } else {
                        Panel.PlayerUpdateKills(ku.PlayerP, 1);
                        Player.DoPlayerDeathMessage(ppnum, ku.PlayerP);
                    }
                }
            } else {
                Panel.PlayerUpdateKills(ppnum, -1);
                Player.DoPlayerDeathMessage(ppnum, ppnum);
            }
        }
        Inv.KillInventoryBar(pp);
        pp.Flags |= Gameutils.PF_LOCK_HORIZ;
        pp.friction = 50000;
        pp.slide_yvect = 0;
        pp.slide_xvect = 0;
        pp.floor_dist = PLAYER_WADE_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_WADE_CEILING_DIST;
        pp.DoPlayerAction = PlayerDeathFunc[pp.DeathType];
        pp.sop_control = -1;
        pp.sop_remote = -1;
        pp.sop_riding = -1;
        pp.sop = -1;
        pp.Flags &= ~Gameutils.PF_TWO_UZI;
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
        Panel.pWeaponForceRest(pp);
        if (pp.Chops != null) {
            Chops.ChopsSetRetract(pp);
        }
        if ((psp = pp.getSprite()) == null) {
            return;
        }
        switch (pp.DeathType) {
            case 5: {
                pp.Flags |= Gameutils.PF_JUMPING;
                u.ID = 4227;
                pp.jump_speed = -200;
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerDeath);
                Weapon.DoFindGround(pp.PlayerSprite);
                Actor.DoBeginJump(pp.PlayerSprite);
                u.jump_speed = -300;
                break;
            }
            case 0: 
            case 3: {
                pp.Flags |= Gameutils.PF_JUMPING;
                u.ID = 4227;
                pp.jump_speed = -300;
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerDeath);
                psp.setCstat(psp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                u.ceiling_dist = Gameutils.Z(10);
                u.floor_dist = Gameutils.Z(0);
                Weapon.DoFindGround(pp.PlayerSprite);
                Actor.DoBeginJump(pp.PlayerSprite);
                u.jump_speed = -400;
                break;
            }
            case 1: {
                Sound.PlaySound(58, pp, 8);
                pp.Flags |= Gameutils.PF_DEAD_HEAD | Gameutils.PF_JUMPING;
                pp.jump_speed = -300;
                u.slide_vel = 0;
                Shrap.SpawnShrap(pp.PlayerSprite, -1);
                psp.setCstat(psp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadFly);
                u.ID = 1142;
                psp.setXrepeat(48);
                psp.setYrepeat(48);
                JWeapon.InitBloodSpray(pp.PlayerSprite, true, 105);
                break;
            }
            case 2: {
                Sound.PlaySound(58, pp, 8);
                pp.Flags |= Gameutils.PF_DEAD_HEAD | Gameutils.PF_JUMPING;
                pp.jump_speed = -650;
                Shrap.SpawnShrap(pp.PlayerSprite, -1);
                psp.setCstat(psp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadFly);
                u.ID = 1142;
                psp.setXrepeat(48);
                psp.setYrepeat(48);
                JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
                JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
                JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
                break;
            }
            case 4: {
                Sound.PlaySound(61, pp, 8);
                pp.Flags |= Gameutils.PF_DEAD_HEAD | Gameutils.PF_JUMPING;
                pp.jump_speed = 200;
                u.slide_vel = 800;
                Shrap.SpawnShrap(pp.PlayerSprite, -1);
                psp.setCstat(psp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadFly);
                u.ID = 1142;
                psp.setXrepeat(48);
                psp.setYrepeat(48);
                JWeapon.InitBloodSpray(pp.PlayerSprite, true, 105);
                break;
            }
        }
        pp.Flags |= Gameutils.PF_DEAD;
        u.Flags &= ~Gameutils.SPR_BOUNCE;
        pp.Flags &= ~Gameutils.PF_HEAD_CONTROL;
    }

    public static void DoPlayerDeathHoriz(PlayerStr pp, int target, int speed) {
        if (pp.horiz > (float)target) {
            pp.horiz -= (float)speed;
            if (pp.horiz <= (float)target) {
                pp.horiz = target;
            }
        }
        if (pp.horiz < (float)target) {
            pp.horiz += (float)speed;
            if (pp.horiz >= (float)target) {
                pp.horiz = target;
            }
        }
    }

    public static void DoPlayerDeathZrange(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        Weapon.DoFindGround(pp.PlayerSprite);
        pp.loz = u.loz;
        pp.lo_sp = u.lo_sp;
        pp.lo_sectp = u.lo_sectp;
    }

    public static void DoPlayerDeathHurl(PlayerStr pp) {
        if ((Mmulti.numplayers > 1 || Main.gNet.FakeMultiplayer) && Gameutils.TEST_SYNC_KEY(pp, 17) && Gameutils.FLAG_KEY_PRESSED(pp, 17)) {
            pp.Flags |= Gameutils.PF_HEAD_CONTROL;
            Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadHurl);
            if (Sprites.MoveSkip4 == 0) {
                Shrap.SpawnShrap(pp.PlayerSprite, -1);
                if (Gameutils.RANDOM_RANGE(1000) > 400) {
                    Sound.PlayerSound(48, 9, pp);
                }
            }
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
            Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHead);
        }
    }

    public static void DoPlayerDeathFollowKiller(PlayerStr pp) {
        Player.DoPlayerDeathHoriz(pp, 165, 4);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD_HEAD) && pp.input.angvel != 0.0f || MyTypes.TEST(pp.Flags, Gameutils.PF_HEAD_CONTROL)) {
            Player.PLAYER_RUN_LOCK(pp);
            Player.DoPlayerTurn(pp);
            return;
        }
        WangSprite kp = Main.boardService.getSprite(pp.Killer);
        if (kp != null && Rooms.FAFcansee(kp.getX(), kp.getY(), Gameutils.SPRITEp_TOS(kp), kp.getSectnum(), pp.posx, pp.posy, pp.posz, pp.cursectnum)) {
            int ang2 = EngineUtils.getAngle(kp.getX() - pp.posx, kp.getY() - pp.posy);
            int delta_ang = Player.GetDeltaAngle(ang2, pp.getAnglei());
            pp.pang += (float)(delta_ang >> 4);
            pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
        }
    }

    public static void DoPlayerDeathRestart(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (sp == null || u == null) {
            return;
        }
        if (Player.PlayerFloorHit(pp, pp.loz - PLAYER_HEIGHT)) {
            if (pp.DeathType == 0 || pp.DeathType == 3) {
                Weapon.QueueLoWangs(pp.PlayerSprite);
            }
        } else {
            JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
            JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
            JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
        }
        Text.pClearTextLine(pp, Text.TEXT_INFO_LINE(0));
        Player.PlayerSpawnPosition(pp.pnum);
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
        sp.setPicnum(u.State.Pic);
        sp.setXrepeat(47);
        sp.setYrepeat(47);
        sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
        sp.setX(pp.posx);
        sp.setY(pp.posy);
        sp.setZ(pp.posz + PLAYER_HEIGHT);
        sp.setAng(pp.getAnglei());
        Player.DoSpawnTeleporterEffect(sp);
        Sound.PlaySound(207, pp, 0);
        Player.DoPlayerZrange(pp);
        pp.sop_control = -1;
        pp.sop_remote = -1;
        pp.sop_riding = -1;
        pp.sop = -1;
        pp.Flags &= ~(Gameutils.PF_WEAPON_DOWN | Gameutils.PF_WEAPON_RETRACT);
        pp.Flags &= ~Gameutils.PF_DEAD;
        pp.Flags &= ~Gameutils.PF_LOCK_HORIZ;
        sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
        sp.setCstat(sp.getCstat() | (Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        sp.setXrepeat(47);
        sp.setYrepeat(33);
        pp.horizbase = 100.0f;
        pp.horiz = 100.0f;
        Player.DoPlayerResetMovement(pp);
        u.ID = 4096;
        Ninja.PlayerDeathReset(pp);
        if (pp == Game.Player[Game.screenpeek]) {
            Palette.ResetPalette(pp, 256);
        }
        pp.NightVision = false;
        pp.FadeAmt = 0;
        Palette.DoPlayerDivePalette(pp);
        Palette.DoPlayerNightVisionPalette(pp);
        if (Mmulti.numplayers > 1 || Main.gNet.FakeMultiplayer) {
            Player.DoPlayerBeginRun(pp);
        } else if (Main.gDemoScreen.demfile != null) {
            if (Game.rec != null) {
                Game.rec.close();
            }
        } else {
            Game.ExitLevel = true;
        }
        Player.DoPlayerFireOutDeath(pp);
    }

    private static void DoPlayerDeathCheckKeys(PlayerStr pp) {
        if (Gameutils.TEST_SYNC_KEY(pp, 31)) {
            Player.DoPlayerDeathRestart(pp);
        }
    }

    public static void DoPlayerHeadDebris(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(pp.cursectnum);
        if (sectp == null) {
            return;
        }
        if (MyTypes.TEST(sectp.getExtra(), Gameutils.SECTFX_SINK)) {
            Player.DoPlayerSpriteBob(pp, Gameutils.Z(8), Gameutils.Z(4), 3);
        } else {
            pp.bob_amt = 0;
        }
    }

    public static void DoPlayerDeathCheckKick(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (sp == null || u == null) {
            return;
        }
        block0: for (int j : Weapon.StatDamageList) {
            ListNode<Sprite> node = Main.boardService.getStatNode(j);
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite hp = node.get();
                USER hu = Gameutils.getUser(i);
                if (hu != null) {
                    if (i == pp.PlayerSprite) continue block0;
                    if (MyTypes.TEST(hp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY) && Gameutils.DISTANCE(hp.getX(), hp.getY(), sp.getX(), sp.getY()) < hu.Radius + 100) {
                        pp.Killer = i;
                        u.slide_ang = EngineUtils.getAngle(sp.getX() - hp.getX(), sp.getY() - hp.getY());
                        u.slide_ang = Gameutils.NORM_ANGLE(u.slide_ang + (Gameutils.RANDOM_P2(4096) >> 5) - 64);
                        u.slide_vel = hp.getXvel() << 1;
                        u.Flags &= ~Gameutils.SPR_BOUNCE;
                        pp.jump_speed = -500;
                        Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadFly);
                        pp.Flags |= Gameutils.PF_JUMPING;
                        Shrap.SpawnShrap(pp.PlayerSprite, -1);
                        return;
                    }
                }
                node = nexti;
            }
        }
        Player.DoPlayerZrange(pp);
        if (Pragmas.klabs(pp.loz - pp.hiz) < Gameutils.SPRITEp_SIZE_Z(sp) - Gameutils.Z(8)) {
            u.slide_ang = Gameutils.RANDOM_P2(2048);
            u.slide_vel = 1000;
            u.Flags &= ~Gameutils.SPR_BOUNCE;
            pp.jump_speed = -100;
            Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadFly);
            pp.Flags |= Gameutils.PF_JUMPING;
            Shrap.SpawnShrap(pp.PlayerSprite, -1);
        }
    }

    public static void DoPlayerDeathMoveHead(PlayerStr pp) {
        int day;
        Sprite sp = pp.getSprite();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (sp == null || u == null) {
            return;
        }
        int dax = Gameutils.MOVEx(u.slide_vel, u.slide_ang);
        u.moveSpriteReturn = Sprites.move_sprite(pp.PlayerSprite, dax, day = Gameutils.MOVEy(u.slide_vel, u.slide_ang), 0, Gameutils.Z(16), Gameutils.Z(16), 1, 3);
        if (u.moveSpriteReturn != 0) {
            switch (MyTypes.DTEST(u.moveSpriteReturn, -536870912)) {
                case -1073741824: {
                    int hitsprite = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
                    WangSprite hsp = Main.boardService.getSprite(hitsprite);
                    if (hsp == null || !MyTypes.TEST(hsp.getCstat(), Gameutils.CSTAT_SPRITE_WALL)) break;
                    int wall_ang = Gameutils.NORM_ANGLE(hsp.getAng());
                    int dang = Player.GetDeltaAngle(u.slide_ang, wall_ang);
                    u.slide_ang = Gameutils.NORM_ANGLE(wall_ang + 1024 - dang);
                    Shrap.SpawnShrap(pp.PlayerSprite, -1);
                    break;
                }
                case -2147483648: {
                    int hitwall = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
                    Wall w = Main.boardService.getWall(hitwall);
                    if (w == null) break;
                    int wall_ang = Gameutils.NORM_ANGLE(w.getWallAngle() - 512);
                    int dang = Player.GetDeltaAngle(u.slide_ang, wall_ang);
                    u.slide_ang = Gameutils.NORM_ANGLE(wall_ang + 1024 - dang);
                    Shrap.SpawnShrap(pp.PlayerSprite, -1);
                    break;
                }
            }
        }
        pp.posx = sp.getX();
        pp.posy = sp.getY();
        pp.cursectnum = sp.getSectnum();
        int sectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
        if (sectnum < 0) {
            pp.cursectnum = pp.lv_sectnum;
            Main.engine.changespritesect(pp.PlayerSprite, pp.lv_sectnum);
            pp.posx = pp.lv_x;
            pp.posy = pp.lv_y;
            sp.setX(pp.lv_x);
            sp.setY(pp.lv_y);
        } else {
            pp.lv_sectnum = sectnum;
            pp.lv_x = pp.posx;
            pp.lv_y = pp.posy;
        }
    }

    public static void DoPlayerDeathFlip(PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return;
        }
        Player.DoPlayerDeathZrange(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING)) {
                Player.DoPlayerDeathJump(pp);
                Player.DoPlayerDeathHoriz(pp, 165, 2);
                if (!Sprites.MoveSkip2) {
                    Actor.DoJump(pp.PlayerSprite);
                }
            }
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_FALLING)) {
                Player.DoPlayerDeathFall(pp);
                Player.DoPlayerDeathHoriz(pp, 165, 4);
                if (!Sprites.MoveSkip2) {
                    Actor.DoFall(pp.PlayerSprite);
                }
            }
        } else {
            Player.DoPlayerDeathFollowKiller(pp);
        }
        Player.DoPlayerDeathCheckKeys(pp);
    }

    public static void DoPlayerDeathDrown(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        if (sp == null) {
            return;
        }
        if (WangNetwork.Prediction) {
            return;
        }
        Player.DoPlayerDeathZrange(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING)) {
                Player.DoPlayerDeathJump(pp);
                Player.DoPlayerDeathHoriz(pp, 165, 2);
                if (!Sprites.MoveSkip2) {
                    Actor.DoJump(pp.PlayerSprite);
                }
            }
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_FALLING)) {
                pp.posz += Gameutils.Z(2);
                if (!Sprites.MoveSkip2) {
                    sp.setZ(sp.getZ() + Gameutils.Z(4));
                }
                if (pp.posz > pp.loz - PLAYER_DEATH_HEIGHT) {
                    pp.posz = pp.loz - PLAYER_DEATH_HEIGHT;
                    pp.Flags &= ~Gameutils.PF_FALLING;
                }
            }
        }
        Player.DoPlayerDeathFollowKiller(pp);
        Player.DoPlayerDeathCheckKeys(pp);
    }

    public static void DoPlayerDeathBounce(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (sp == null || u == null) {
            return;
        }
        if (WangNetwork.Prediction) {
            return;
        }
        ru.m210projects.Build.Types.Sector loSec = Main.boardService.getSector(pp.lo_sectp);
        if (loSec != null && MyTypes.TEST(loSec.getExtra(), Gameutils.SECTFX_SINK)) {
            sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
            Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHead);
            u.slide_vel = 0;
            u.Flags |= Gameutils.SPR_BOUNCE;
            return;
        }
        u.Flags |= Gameutils.SPR_BOUNCE;
        pp.jump_speed = -300;
        u.slide_vel >>= 2;
        u.slide_ang = Gameutils.NORM_ANGLE((Gameutils.RANDOM_P2(16384) >> 8) - 32);
        pp.Flags |= Gameutils.PF_JUMPING;
        Shrap.SpawnShrap(pp.PlayerSprite, -1);
    }

    public static void DoPlayerDeathCrumble(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (sp == null || u == null) {
            return;
        }
        if (WangNetwork.Prediction) {
            return;
        }
        Player.DoPlayerDeathZrange(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING)) {
                Player.DoPlayerDeathJump(pp);
                Player.DoPlayerDeathHoriz(pp, 150, 4);
            }
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_FALLING)) {
                Player.DoPlayerDeathFall(pp);
                Player.DoPlayerDeathHoriz(pp, 50, 3);
            }
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
                if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                    Player.DoPlayerDeathBounce(pp);
                    return;
                }
                sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHead);
            } else {
                Player.DoPlayerDeathMoveHead(pp);
            }
        } else {
            Player.DoPlayerDeathCheckKick(pp);
            Player.DoPlayerDeathHurl(pp);
            Player.DoPlayerDeathFollowKiller(pp);
        }
        Player.DoPlayerDeathCheckKeys(pp);
        sp.setZ(pp.posz + PLAYER_DEAD_HEAD_FLOORZ_OFFSET);
        Player.DoPlayerHeadDebris(pp);
    }

    public static void DoPlayerDeathExplode(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (sp == null || u == null) {
            return;
        }
        if (WangNetwork.Prediction) {
            return;
        }
        Player.DoPlayerDeathZrange(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING)) {
                Player.DoPlayerDeathJump(pp);
                Player.DoPlayerDeathHoriz(pp, 150, 4);
            }
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_FALLING)) {
                Player.DoPlayerDeathFall(pp);
                Player.DoPlayerDeathHoriz(pp, 150, 3);
            }
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
                if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                    Player.DoPlayerDeathBounce(pp);
                    return;
                }
                sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHead);
            } else {
                Player.DoPlayerDeathMoveHead(pp);
            }
        } else {
            Player.DoPlayerDeathCheckKick(pp);
            Player.DoPlayerDeathHurl(pp);
            Player.DoPlayerDeathFollowKiller(pp);
        }
        Player.DoPlayerDeathCheckKeys(pp);
        sp.setZ(pp.posz + PLAYER_DEAD_HEAD_FLOORZ_OFFSET);
        Player.DoPlayerHeadDebris(pp);
    }

    public static void DoPlayerBeginRun(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        if (Player.DoPlayerTestCrawl(pp)) {
            Player.DoPlayerBeginCrawl(pp);
            return;
        }
        pp.Flags &= ~(Gameutils.PF_CRAWLING | Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_LOCK_CRAWL | Gameutils.PF_CLIMBING);
        if (pp.WadeDepth != 0) {
            Player.DoPlayerBeginWade(pp);
            return;
        }
        pp.friction = 50000;
        pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerRun;
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
        } else {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
        }
    }

    public static void DoPlayerRun(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sec;
        Sprite psp = pp.getSprite();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (psp == null || u == null) {
            return;
        }
        if (Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            Player.DoPlayerBeginDiveNoWarp(pp);
            return;
        }
        if (Player.DoPlayerTestCrawl(pp)) {
            Player.DoPlayerBeginCrawl(pp);
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 20)) {
            Player.DoPlayerBeginCrawl(pp);
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 19)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 19)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 19);
                pp.posz = pp.loz - PLAYER_HEIGHT;
                Player.DoPlayerBeginJump(pp);
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 19);
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 14)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 14)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 14);
                pp.Flags |= Gameutils.PF_LOCK_CRAWL;
                Player.DoPlayerBeginCrawl(pp);
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 14);
        }
        if (Player.PlayerFlyKey(pp)) {
            Player.DoPlayerBeginFly(pp);
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD) && !WangNetwork.Prediction) {
            if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
                sec = Main.boardService.getSector(pp.cursectnum);
                if (sec != null && Gameutils.FLAG_KEY_PRESSED(pp, 18)) {
                    int sp;
                    WangSprite spr;
                    if (MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_OPERATIONAL)) {
                        Gameutils.FLAG_KEY_RELEASE(pp, 18);
                        Player.DoPlayerBeginOperate(pp);
                        return;
                    }
                    if (MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_TRIGGER) && (spr = Main.boardService.getSprite(sp = Player.FindNearSprite(psp, 58))) != null && Gameutils.SP_TAG5(spr) == 0) {
                        pp.remote_sprite = sp;
                        Gameutils.FLAG_KEY_RELEASE(pp, 18);
                        Player.DoPlayerBeginRemoteOperate(pp, Gameutils.SP_TAG7(spr));
                        return;
                    }
                }
            } else {
                Gameutils.FLAG_KEY_RESET(pp, 18);
            }
        }
        Player.DoPlayerBob(pp);
        if (pp.WadeDepth != 0) {
            Player.DoPlayerBeginWade(pp);
            return;
        }
        if (Player.PlayerOnLadder(pp)) {
            Player.DoPlayerBeginClimb(pp);
            return;
        }
        Player.DoPlayerMove(pp);
        if (u.getRot() != PlayerStateGroup.sg_PlayerNinjaSword && u.getRot() != PlayerStateGroup.sg_PlayerNinjaPunch) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
                if (u.getRot() != u.ActorActionSet.Run) {
                    Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
                }
            } else if (u.getRot() != u.ActorActionSet.Stand) {
                Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
            }
        }
        if (Player.PlayerFallTest(pp, PLAYER_HEIGHT)) {
            pp.jump_speed = Gameutils.Z(1);
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            return;
        }
        sec = Main.boardService.getSector(pp.cursectnum);
        if (sec != null && MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_DYNAMIC_AREA)) {
            pp.posz = pp.loz - PLAYER_HEIGHT;
        }
        Player.DoPlayerHeight(pp);
    }

    public static void PlayerStateControl(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.Tics += 3;
        while (u.Tics >= MyTypes.DTEST(u.State.Tics, 65535)) {
            u.Tics -= MyTypes.DTEST(u.State.Tics, 65535);
            u.State = u.State.getNext();
            while (MyTypes.TEST(u.State.Tics, Gameutils.SF_QUICK_CALL)) {
                u.State.Animator.animatorInvoke(SpriteNum);
                if (!MyTypes.TEST(u.State.Tics, Gameutils.SF_QUICK_CALL)) continue;
                u.State = u.State.getNext();
            }
            if (u.State.Pic != 0) continue;
            Sprites.NewStateGroup(SpriteNum, u.State.getNextGroup());
        }
        if (u.RotNum > 1) {
            sp.setPicnum(u.getRot().getState((int)0).Pic);
        } else {
            sp.setPicnum(u.State.Pic);
        }
        if (MyTypes.TEST(u.State.Tics, Gameutils.SF_PLAYER_FUNC) && u.State.Animator != null) {
            u.State.Animator.animatorInvoke(SpriteNum);
        }
    }

    public static void MoveSkipSavePos() {
        USER u;
        Sprite sp;
        ListNode<Sprite> nexti;
        int i;
        ListNode<Sprite> node;
        int stat;
        Sprites.MoveSkip8 = Sprites.MoveSkip8 + 1 & 7;
        Sprites.MoveSkip4 = Sprites.MoveSkip4 + 1 & 3;
        Sprites.MoveSkip2 = !Sprites.MoveSkip2;
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            PlayerStr pp = Game.Player[pnum];
            pp.oposx = pp.posx;
            pp.oposy = pp.posy;
            pp.oposz = pp.posz;
            pp.oang = pp.pang;
            pp.ohoriz = pp.horiz;
            pp.obob_z = pp.bob_z;
            pp.obob_amt = pp.bob_amt;
            pnum = Mmulti.connectpoint2[pnum];
        }
        if (Sprites.MoveSkip4 == 0) {
            for (stat = 6; stat <= 9; ++stat) {
                node = Main.boardService.getStatNode(stat);
                while (node != null) {
                    i = node.getIndex();
                    nexti = node.getNext();
                    sp = node.get();
                    u = Gameutils.getUser(i);
                    if (u != null) {
                        u.ox = sp.getX();
                        u.oy = sp.getY();
                        u.oz = sp.getZ();
                    }
                    node = nexti;
                }
            }
        }
        if (!Sprites.MoveSkip2) {
            for (stat = 2; stat <= 5; ++stat) {
                node = Main.boardService.getStatNode(stat);
                while (node != null) {
                    i = node.getIndex();
                    nexti = node.getNext();
                    sp = node.get();
                    u = Gameutils.getUser(i);
                    if (u != null) {
                        u.ox = sp.getX();
                        u.oy = sp.getY();
                        u.oz = sp.getZ();
                    }
                    node = nexti;
                }
            }
        }
    }

    public static void PlayerTimers(PlayerStr pp) {
        Inv.InventoryTimer(pp);
    }

    public static void ChopsCheck(PlayerStr pp) {
        if (!Main.game.pMenu.gShowMenu && !MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD) && pp.sop_riding == -1 && Mmulti.numplayers <= 1) {
            if ((pp.input.bits | pp.input.vel | pp.input.svel) != 0 || pp.input.angvel != 0.0f || pp.input.aimvel != 0.0f || MyTypes.TEST(pp.Flags, Gameutils.PF_CLIMBING | Gameutils.PF_FALLING | Gameutils.PF_DIVING)) {
                if (pp.Chops != null) {
                    if (pp.sop_control == -1) {
                        pp.Flags &= ~Gameutils.PF_WEAPON_DOWN;
                    }
                    Chops.ChopsSetRetract(pp);
                }
                Game.ChopTics = 0;
            } else {
                Game.ChopTics += 3;
                if (pp.Chops == null) {
                    if (Game.ChopTics > 3600) {
                        Game.ChopTics = 0;
                        pp.Flags |= Gameutils.PF_WEAPON_DOWN;
                        Chops.InitChops(pp);
                    }
                } else if (Game.ChopTics > 3600) {
                    Game.ChopTics = 0;
                    pp.Flags &= ~Gameutils.PF_WEAPON_DOWN;
                    Chops.ChopsSetRetract(pp);
                }
            }
        }
    }

    public static void PlayerGlobal(PlayerStr pp) {
        Player.PlayerTimers(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_RECOIL)) {
            Player.DoPlayerRecoil(pp);
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_CLIP_CHEAT) && pp.hi_sectp != -1 && Main.boardService.getSector(pp.lo_sectp) != null) {
            USER u;
            int min_height = PLAYER_MIN_HEIGHT;
            if (Pragmas.klabs(pp.loz - pp.hiz) < min_height && (u = Gameutils.getUser(pp.PlayerSprite)) != null && !MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
        }
        if (pp.FadeAmt > 0 && Sprites.MoveSkip4 == 0) {
            Palette.DoPaletteFlash(pp);
        }
        if (pp.circle_camera_dist > 12000) {
            pp.circle_camera_ang = Gameutils.NORM_ANGLE(pp.circle_camera_ang + 14);
        }
        if (pp.camera_check_time_delay > 0) {
            pp.camera_check_time_delay -= 3;
            if (pp.camera_check_time_delay <= 0) {
                pp.camera_check_time_delay = 0;
            }
        }
    }

    public static void UpdateScrollingMessages() {
        for (int i = 0; i < 6; ++i) {
            if (JPlayer.user_quote_time[i] == 0) continue;
            int n = i;
            JPlayer.user_quote_time[n] = JPlayer.user_quote_time[n] - 1;
            if (JPlayer.user_quote_time[i] > 0) continue;
            JPlayer.user_quote_time[i] = 0;
        }
        JPlayer.quotebot = Main.cfg.BorderNum > 4 ? JPlayer.quotebotgoal : (Pragmas.klabs(JPlayer.quotebotgoal - JPlayer.quotebot) <= 16 ? (JPlayer.quotebot += Pragmas.ksgn(JPlayer.quotebotgoal - JPlayer.quotebot)) : JPlayer.quotebotgoal);
    }

    public static void MultiPlayLimits() {
        boolean Done = false;
        if (Game.ExitLevel) {
            return;
        }
        if (Main.gNet.MultiGameType != WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT) {
            return;
        }
        if (Main.gNet.KillLimit != 0) {
            short pnum = Mmulti.connecthead;
            while (pnum != -1) {
                PlayerStr pp = Game.Player[pnum];
                if (pp.Kills >= Main.gNet.KillLimit) {
                    Done = true;
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
        }
        if (Main.gNet.TimeLimit != 0) {
            Main.gNet.TimeLimitClock -= 3;
            if (Main.gNet.TimeLimitClock <= 0) {
                Done = true;
            }
        }
        if (Done) {
            Main.gNet.TimeLimitClock = Main.gNet.TimeLimit;
            if (Game.Level <= 22) {
                ++Game.Level;
            }
            Game.ExitLevel = true;
            Game.FinishedLevel = true;
        }
    }

    public static void domovethings(BuildNet net) {
        PlayerStr pp;
        int i = Mmulti.connecthead;
        while (i != -1) {
            pp = Game.Player[i];
            pp.input.Copy(net.gFifoInput[net.gNetFifoTail & 0xFF][i]);
            i = Mmulti.connectpoint2[i];
        }
        ++net.gNetFifoTail;
        Arrays.fill(Draw.bCopySpriteOffs, false);
        if (Main.gNet.MyCommPlayerQuit()) {
            return;
        }
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            Main.gNet.PauseMultiPlay();
        }
        net.CalcChecksum();
        if ((Main.game.gPaused || Main.gDemoScreen.demfile == null && WangNetwork.CommPlayers < 2 && !Main.game.isCurrentScreen(Main.gDemoScreen) && (Main.game.menu.gShowMenu || Console.out.isShowing())) && !Main.game.menu.isOpened(Main.game.menu.mMenus[16])) {
            return;
        }
        Player.UpdateScrollingMessages();
        ++Main.gNet.MoveThingsCount;
        if (Game.DemoRecording && Game.rec != null) {
            Game.rec.record();
        }
        int synctics = Main.engine.getTimer().getFrameTicks();
        Game.totalsynctics += synctics;
        Player.MoveSkipSavePos();
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            pp = Game.Player[pnum];
            Player.DoPlayerMenuKeys(pp);
            pnum = Mmulti.connectpoint2[pnum];
        }
        if (Main.game.gPaused) {
            return;
        }
        Game.PlayClock += synctics;
        if (Sound.rtsplaying > '\u0000') {
            Sound.rtsplaying = (char)(Sound.rtsplaying - '\u0001');
        }
        Sector.DoAnim(synctics);
        Sector.DoSector();
        Vis.ProcessVisOn();
        if (Sprites.MoveSkip4 == 0) {
            Quake.ProcessQuakeOn();
            Quake.ProcessQuakeSpot();
            JSector.JS_ProcessEchoSpot();
        }
        Sprites.SpriteControl();
        pnum = Mmulti.connecthead;
        while (pnum != -1) {
            Sector.GlobPlayerStr = pp = Game.Player[pnum];
            if (Mmulti.numplayers <= 1) {
                // empty if block
            }
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Player.LookupOperate(pp);
                Panel.WeaponOperate(pp);
                Sector.PlayerOperateEnv(pp);
            }
            Player.DoPlayerSectorUpdatePreMove(pp);
            Player.ChopsCheck(pp);
            pp.DoPlayerAction.invoke(pp);
            Player.UpdatePlayerSprite(pp);
            Panel.pSpriteControl(pp);
            Player.PlayerStateControl(pp.PlayerSprite);
            Player.DoPlayerSectorUpdatePostMove(pp);
            Player.PlayerGlobal(pp);
            pnum = Mmulti.connectpoint2[pnum];
        }
        Player.MultiPlayLimits();
        Sound.DoUpdateSounds3D();
        if (Sprites.MoveSkip8 == 0) {
            Sprites.MoveSkip8 = Sprites.MoveSkip8 + 1 & 0xF;
        }
        net.CorrectPrediction();
        if (Weapon.FinishTimer != 0 && (Weapon.FinishTimer -= synctics) <= 0) {
            Weapon.FinishTimer = 0;
            Game.ExitLevel = true;
            Game.FinishedLevel = true;
        }
        if (Game.ExitLevel) {
            Game.ExitLevel = false;
            if (Game.rec != null) {
                Game.rec.close();
            }
            System.err.println("LeaveMap");
            if (Mmulti.numplayers > 1 && Main.game.pNet.bufferJitter >= 0 && Mmulti.myconnectindex == Mmulti.connecthead) {
                for (i = 0; i <= Main.game.pNet.bufferJitter; ++i) {
                    Main.game.pNet.GetNetworkInput();
                }
            }
            if (!Main.game.pNet.WaitForAllPlayers(5000)) {
                Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
                return;
            }
            Main.game.pNet.ready2send = false;
            if (Main.game.isCurrentScreen(Main.gDemoScreen)) {
                return;
            }
            Gdx.app.postRunnable(Game::TerminateLevel);
            if (Game.FinishedLevel) {
                if (Game.FinishAnim != 0 && Main.gAnmScreen.init(Game.FinishAnim)) {
                    Main.game.changeScreen(Main.gAnmScreen.setCallback(() -> {
                        if (Game.Level != 4 && Game.Level != 20) {
                            ++Game.Level;
                        }
                        Main.game.changeScreen(Main.gStatisticScreen);
                    }).escSkipping(true));
                    return;
                }
                Main.game.changeScreen(Main.gStatisticScreen);
            } else if (!Main.gGameScreen.enterlevel(Main.gGameScreen.getTitle())) {
                Main.game.show();
            }
        }
    }

    private static void LookupOperate(PlayerStr pp) {
        pp.lookang -= pp.lookang >> 2;
        if (pp.lookang != 0 && pp.lookang >> 2 == 0) {
            pp.lookang -= Pragmas.ksgn(pp.lookang);
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 23)) {
            pp.lookang -= 152;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 24)) {
            pp.lookang += 152;
        }
    }

    public static void InitAllPlayers(boolean NewGame2) {
        PlayerStr pfirst = Game.Player[Mmulti.connecthead];
        pfirst.horizbase = 100.0f;
        pfirst.horiz = 100.0f;
        for (int ppi = 0; ppi < 8; ++ppi) {
            PlayerStr pp = Game.Player[ppi];
            pp.posx = pp.oposx = pfirst.posx;
            pp.posy = pp.oposy = pfirst.posy;
            pp.posz = pp.oposz = pfirst.posz;
            pp.pang = pp.oang = pfirst.pang;
            pp.horiz = pp.ohoriz = pfirst.horiz;
            pp.cursectnum = pfirst.cursectnum;
            pp.lastcursectnum = pfirst.cursectnum + 1;
            pp.horizbase = pfirst.horizbase;
            pp.oldposx = 0;
            pp.oldposy = 0;
            pp.climb_ndx = 10;
            pp.Killer = -1;
            pp.Kills = 0;
            pp.bcnt = 0;
            pp.UziShellLeftAlt = false;
            pp.UziShellRightAlt = false;
            pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
            pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
            pp.WpnGotOnceFlags = 0;
            pp.DoPlayerAction = Player_Action_Func.DoPlayerBeginRun;
            pp.KeyPressFlags = -1;
            Arrays.fill(pp.KilledPlayer, 0);
            if (NewGame2) {
                for (int i = 0; i < 7; ++i) {
                    pp.InventoryAmount[i] = 0;
                    pp.InventoryPercent[i] = 0;
                }
            }
            pp.FadeAmt = 0;
            pp.FadeTics = 0;
            pp.StartColor = 0;
            pp.horizoff = 0.0f;
            List.Init(pp.PanelSpriteList);
        }
    }

    public static int SearchSpawnPosition(PlayerStr pp) {
        int pos_num;
        boolean blocked;
        block0: do {
            ListNode<Sprite> node;
            if ((node = Main.boardService.getStatNode(600 + (pos_num = Gameutils.RANDOM_RANGE(8)))) == null) {
                return 0;
            }
            Sprite sp = node.get();
            blocked = false;
            short pnum = Mmulti.connecthead;
            while (pnum != -1) {
                PlayerStr opp = Game.Player[pnum];
                if (opp != pp && Gameutils.FindDistance3D(sp.getX() - opp.posx, sp.getY() - opp.posy, sp.getZ() - opp.posz >> 4) < 1000) {
                    blocked = true;
                    continue block0;
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
        } while (blocked);
        return pos_num;
    }

    public static void PlayerSpawnPosition(int pnum) {
        PlayerStr pp = Game.Player[pnum];
        ListNode<Sprite> spawn_sprite = null;
        int pos_num = pnum;
        for (int i = 0; i < 8; ++i) {
            if (SpawnPositionUsed[i]) continue;
            pos_num = i;
            break;
        }
        switch (Main.gNet.MultiGameType) {
            default: {
                break;
            }
            case MULTI_GAME_NONE: {
                spawn_sprite = Main.boardService.getStatNode(600);
                break;
            }
            case MULTI_GAME_COMMBAT: 
            case MULTI_GAME_AI_BOTS: {
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    pos_num = Player.SearchSpawnPosition(pp);
                }
                spawn_sprite = Main.boardService.getStatNode(600 + pos_num);
                break;
            }
            case MULTI_GAME_COOPERATIVE: {
                spawn_sprite = Main.boardService.getStatNode(610 + pos_num);
            }
        }
        Player.SpawnPositionUsed[pos_num] = true;
        if (spawn_sprite == null && (spawn_sprite = Main.boardService.getStatNode(600)) == null) {
            return;
        }
        Sprite sp = spawn_sprite.get();
        pp.posx = pp.oposx = sp.getX();
        pp.posy = pp.oposy = sp.getY();
        pp.posz = pp.oposz = sp.getZ();
        pp.pang = pp.oang = (float)sp.getAng();
        pp.cursectnum = sp.getSectnum();
        Main.engine.getzsofslope(pp.cursectnum, pp.posx, pp.posy, Rooms.fz, Rooms.cz);
        if (pp.posz > Rooms.fz.get() - PLAYER_HEIGHT) {
            pp.posz = pp.oposz = Rooms.fz.get() - PLAYER_HEIGHT;
        }
    }

    public static void InitMultiPlayerInfo() {
        PlayerStr pp = Game.Player[0];
        ListNode<Sprite> node = Main.boardService.getStatNode(0);
        while (node != null) {
            int SpriteNum = node.getIndex();
            ListNode<Sprite> NextSprite = node.getNext();
            Sprite sp = node.get();
            short tag = sp.getHitag();
            if (sp.getPicnum() == 2307) {
                switch (tag) {
                    case 42: {
                        Sprites.change_sprite_stat(SpriteNum, 600 + sp.getLotag());
                        break;
                    }
                    case 48: {
                        Sprites.change_sprite_stat(SpriteNum, 610 + sp.getLotag());
                    }
                }
            }
            node = NextSprite;
        }
        for (int stat = 0; stat < MultiStatList.length; ++stat) {
            if (Main.gNet.MultiGameType != WangNetwork.MultiGameTypes.MULTI_GAME_NONE && Main.boardService.getStatNode(MultiStatList[stat]) != null) continue;
            int start0 = Sprites.SpawnSprite(MultiStatList[stat], 2307, null, pp.cursectnum, pp.posx, pp.posy, pp.posz, pp.getAnglei(), 0);
            Gameutils.setUser(start0, null);
            WangSprite sp0 = Main.boardService.getSprite(start0);
            if (sp0 == null) continue;
            sp0.setPicnum(2307);
        }
        Arrays.fill(SpawnPositionUsed, false);
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            pp = Game.Player[pnum];
            switch (Main.gNet.MultiGameType) {
                default: {
                    break;
                }
                case MULTI_GAME_NONE: 
                case MULTI_GAME_COOPERATIVE: {
                    Player.PlayerSpawnPosition(pnum);
                    break;
                }
                case MULTI_GAME_COMMBAT: 
                case MULTI_GAME_AI_BOTS: {
                    Arrays.fill(Game.Player[0].HasKey, (byte)-1);
                    Arrays.fill(pp.HasKey, (byte)-1);
                    Player.PlayerSpawnPosition(pnum);
                }
            }
            pnum = Mmulti.connectpoint2[pnum];
        }
    }

    public static void DoFootPrints(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && u.PlayerP != -1) {
            if (Gameutils.FAF_ConnectArea(Game.Player[u.PlayerP].cursectnum)) {
                return;
            }
            if (Game.Player[u.PlayerP].NumFootPrints > 0) {
                Weapon.QueueFootPrint(SpriteNum);
            }
        }
    }

    public static void CheckFootPrints(PlayerStr pp) {
        if (pp.NumFootPrints <= 0 || Weapon.FootMode != Gameutils.FootType.WATER_FOOT) {
            pp.NumFootPrints = Gameutils.RANDOM_RANGE(10) + 3;
            Weapon.FootMode = Gameutils.FootType.WATER_FOOT;
        }
    }

    public static void PlayerSaveable() {
        Saveable.SaveData(DoPlayerSpriteReset);
        Saveable.SaveData(DoFootPrints);
        Saveable.SaveData(QueueFloorBlood);
        Saveable.SaveData(pSetVisNorm);
        Saveable.SaveData(s_PlayerNinjaRun);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaRun);
        Saveable.SaveData(s_PlayerNinjaStand);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaStand);
        Saveable.SaveData(s_PlayerNinjaJump);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaJump);
        Saveable.SaveData(s_PlayerNinjaFall);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaFall);
        Saveable.SaveData(s_PlayerNinjaClimb);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaClimb);
        Saveable.SaveData(s_PlayerNinjaCrawl);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaCrawl);
        Saveable.SaveData(s_PlayerNinjaSwim);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaSwim);
        Saveable.SaveData(s_PlayerHeadFly);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerHeadFly);
        Saveable.SaveData(s_PlayerHead);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerHead);
        Saveable.SaveData(s_PlayerHeadHurl);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerHeadHurl);
        Saveable.SaveData(s_PlayerDeath);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerDeath);
        Saveable.SaveData(s_PlayerNinjaSword);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaSword);
        Saveable.SaveData(s_PlayerNinjaPunch);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaPunch);
        Saveable.SaveData(s_PlayerNinjaFly);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaFly);
    }

    static /* synthetic */ State[][] access$100() {
        return s_PlayerNinjaRun;
    }

    static /* synthetic */ State[][] access$200() {
        return s_PlayerNinjaStand;
    }

    static /* synthetic */ State[][] access$300() {
        return s_PlayerNinjaJump;
    }

    static /* synthetic */ State[][] access$400() {
        return s_PlayerNinjaFall;
    }

    static /* synthetic */ State[][] access$500() {
        return s_PlayerNinjaClimb;
    }

    static /* synthetic */ State[][] access$600() {
        return s_PlayerNinjaCrawl;
    }

    static /* synthetic */ State[][] access$700() {
        return s_PlayerNinjaSwim;
    }

    static /* synthetic */ State[][] access$800() {
        return s_PlayerHeadFly;
    }

    static /* synthetic */ State[][] access$900() {
        return s_PlayerHead;
    }

    static /* synthetic */ State[][] access$1000() {
        return s_PlayerHeadHurl;
    }

    static /* synthetic */ State[][] access$1100() {
        return s_PlayerDeath;
    }

    static /* synthetic */ State[][] access$1200() {
        return s_PlayerNinjaSword;
    }

    static /* synthetic */ State[][] access$1300() {
        return s_PlayerNinjaPunch;
    }

    static /* synthetic */ State[][] access$1400() {
        return s_PlayerNinjaFly;
    }

    static {
        TargetSort = new Target_Sort[16];
        s_PlayerNinjaRun = new State[][]{{new State(1094, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1095, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1095, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1096, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1097, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1097, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1098, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1099, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1099, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1100, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1101, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1101, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1102, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1103, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1103, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1104, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1105, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1105, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1106, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1107, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1107, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1108, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1109, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1109, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1110, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1111, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1111, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1112, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1113, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1113, Gameutils.SF_QUICK_CALL, DoFootPrints)}};
        s_PlayerNinjaStand = new State[][]{{new State(1094, 10, null).setNext()}, {new State(1098, 10, null).setNext()}, {new State(1102, 10, null).setNext()}, {new State(1106, 10, null).setNext()}, {new State(1110, 10, null).setNext()}};
        s_PlayerNinjaJump = new State[][]{{new State(1074, 24, null), new State(1075, 24, null), new State(1076, 24, null), new State(1077, 24, null).setNext()}, {new State(1078, 24, null), new State(1079, 24, null), new State(1080, 24, null), new State(1081, 24, null).setNext()}, {new State(1082, 24, null), new State(1083, 24, null), new State(1084, 24, null), new State(1085, 24, null).setNext()}, {new State(1086, 24, null), new State(1087, 24, null), new State(1088, 24, null), new State(1089, 24, null).setNext()}, {new State(1090, 24, null), new State(1091, 24, null), new State(1092, 24, null), new State(1093, 24, null).setNext()}};
        s_PlayerNinjaFall = new State[][]{{new State(1075, 16, null), new State(1076, 16, null).setNext()}, {new State(1079, 16, null), new State(1080, 16, null).setNext()}, {new State(1083, 16, null), new State(1084, 16, null).setNext()}, {new State(1087, 16, null), new State(1088, 16, null).setNext()}, {new State(1091, 16, null), new State(1092, 16, null).setNext()}};
        s_PlayerNinjaClimb = new State[][]{{new State(1024, 20, null), new State(1025, 20, null), new State(1026, 20, null), new State(1027, 20, null)}, {new State(1028, 20, null), new State(1029, 20, null), new State(1030, 20, null), new State(1031, 20, null)}, {new State(1032, 20, null), new State(1033, 20, null), new State(1034, 20, null), new State(1035, 20, null)}, {new State(1036, 20, null), new State(1037, 20, null), new State(1038, 20, null), new State(1039, 20, null)}, {new State(1040, 20, null), new State(1041, 20, null), new State(1042, 20, null), new State(1043, 20, null)}};
        s_PlayerNinjaCrawl = new State[][]{{new State(1044, 14, null), new State(1045, 14, null), new State(1045, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1046, 14, null), new State(1045, 14, null), new State(1045, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1048, 14, null), new State(1049, 14, null), new State(1049, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1050, 14, null), new State(1049, 14, null), new State(1049, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1052, 14, null), new State(1053, 14, null), new State(1053, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1054, 14, null), new State(1053, 14, null), new State(1053, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1056, 14, null), new State(1057, 14, null), new State(1057, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1058, 14, null), new State(1057, 14, null), new State(1057, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1060, 14, null), new State(1061, 14, null), new State(1061, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1062, 14, null), new State(1061, 14, null), new State(1061, Gameutils.SF_QUICK_CALL, DoFootPrints)}};
        s_PlayerNinjaSwim = new State[][]{{new State(1114, 22, null), new State(1115, 22, null), new State(1116, 22, null), new State(1117, 22, null)}, {new State(1118, 22, null), new State(1119, 22, null), new State(1120, 22, null), new State(1121, 22, null)}, {new State(1122, 22, null), new State(1123, 22, null), new State(1124, 22, null), new State(1125, 22, null)}, {new State(1126, 22, null), new State(1127, 22, null), new State(1128, 22, null), new State(1129, 22, null)}, {new State(1130, 22, null), new State(1131, 22, null), new State(1132, 22, null), new State(1133, 22, null)}};
        s_PlayerHeadFly = new State[][]{{new State(1134, 16, null), new State(1135, 16, null), new State(1136, 16, null), new State(1137, 16, null), new State(1138, 16, null), new State(1139, 16, null), new State(1140, 16, null), new State(1141, 16, null)}, {new State(1134, 16, null), new State(1135, 16, null), new State(1136, 16, null), new State(1137, 16, null), new State(1138, 16, null), new State(1139, 16, null), new State(1140, 16, null), new State(1141, 16, null)}, {new State(1134, 16, null), new State(1135, 16, null), new State(1136, 16, null), new State(1137, 16, null), new State(1138, 16, null), new State(1139, 16, null), new State(1140, 16, null), new State(1141, 16, null)}, {new State(1134, 16, null), new State(1135, 16, null), new State(1136, 16, null), new State(1137, 16, null), new State(1138, 16, null), new State(1139, 16, null), new State(1140, 16, null), new State(1141, 16, null)}, {new State(1134, 16, null), new State(1135, 16, null), new State(1136, 16, null), new State(1137, 16, null), new State(1138, 16, null), new State(1139, 16, null), new State(1140, 16, null), new State(1141, 16, null)}};
        s_PlayerHead = new State[][]{{new State(1142, 16, null).setNext()}, {new State(1143, 16, null).setNext()}, {new State(1144, 16, null).setNext()}, {new State(1145, 16, null).setNext()}, {new State(1146, 16, null).setNext()}};
        s_PlayerDeath = new State[][]{{new State(1152, 22, null), new State(1153, 22, null), new State(1154, 22, null), new State(1155, 22, null), new State(1156, 22, null), new State(1157, 22, null), new State(1158, 22, null), new State(1159, 22, null), new State(1160, Gameutils.SF_QUICK_CALL, QueueFloorBlood), new State(1160, 22, null).setNext()}, {new State(1152, 22, null), new State(1153, 22, null), new State(1154, 22, null), new State(1155, 22, null), new State(1156, 22, null), new State(1157, 22, null), new State(1158, 22, null), new State(1159, 22, null), new State(1160, Gameutils.SF_QUICK_CALL, QueueFloorBlood), new State(1160, 22, null).setNext()}, {new State(1152, 22, null), new State(1153, 22, null), new State(1154, 22, null), new State(1155, 22, null), new State(1156, 22, null), new State(1157, 22, null), new State(1158, 22, null), new State(1159, 22, null), new State(1160, Gameutils.SF_QUICK_CALL, QueueFloorBlood), new State(1160, 22, null).setNext()}, {new State(1152, 22, null), new State(1153, 22, null), new State(1154, 22, null), new State(1155, 22, null), new State(1156, 22, null), new State(1157, 22, null), new State(1158, 22, null), new State(1159, 22, null), new State(1160, Gameutils.SF_QUICK_CALL, QueueFloorBlood), new State(1160, 22, null).setNext()}, {new State(1152, 22, null), new State(1153, 22, null), new State(1154, 22, null), new State(1155, 22, null), new State(1156, 22, null), new State(1157, 22, null), new State(1158, 22, null), new State(1159, 22, null), new State(1160, Gameutils.SF_QUICK_CALL, QueueFloorBlood), new State(1160, 22, null).setNext()}};
        s_PlayerNinjaSword = new State[][]{{new State(1161, 12, null), new State(1162, 12, null), new State(1163, 12, null), new State(1163, 0xC | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset)}, {new State(1164, 12, null), new State(1165, 12, null), new State(1166, 12, null), new State(1166, 0xC | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset)}, {new State(1167, 12, null), new State(1168, 12, null), new State(1169, 12, null), new State(1169, 0xC | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset)}, {new State(1170, 12, null), new State(1171, 12, null), new State(1172, 12, null), new State(1172, 0xC | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset)}, {new State(1173, 12, null), new State(1174, 12, null), new State(1175, 12, null), new State(1175, 0xC | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset)}};
        s_PlayerNinjaPunch = new State[][]{{new State(1176, 15, null), new State(1177, 15, null), new State(1177, 0xF | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset).setNext()}, {new State(1178, 15, null), new State(1179, 15, null), new State(1179, 0xF | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset).setNext()}, {new State(1180, 15, null), new State(1181, 15, null), new State(1181, 0xF | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset).setNext()}, {new State(1182, 15, null), new State(1183, 15, null), new State(1183, 0xF | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset).setNext()}, {new State(1184, 15, null), new State(1185, 15, null), new State(1185, 0xF | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset).setNext()}};
        s_PlayerNinjaFly = new State[][]{{new State(1200, 15, null).setNext()}, {new State(1200, 15, null).setNext()}, {new State(1200, 15, null).setNext()}, {new State(1200, 15, null).setNext()}, {new State(1200, 15, null).setNext()}};
        count = 0;
        x = new int[4];
        y = new int[4];
        ox = new int[4];
        oy = new int[4];
        handle = null;
        angs = new int[]{0, 0, 0};
        sf = new int[]{0, 0};
        UnderStatList = new int[]{50, 51};
        SpawnPositionUsed = new boolean[9];
        MultiStatList = new int[]{600, 610};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sp", "ru/m210projects/Wang/Player", "FindNearSprite"));
    }

    public static enum PlayerStateGroup implements StateGroup
    {
        sg_PlayerNinjaRun(Player.access$100()[0], Player.access$100()[1], Player.access$100()[2], Player.access$100()[3], Player.access$100()[4]),
        sg_PlayerNinjaStand(Player.access$200()[0], Player.access$200()[1], Player.access$200()[2], Player.access$200()[3], Player.access$200()[4]),
        sg_PlayerNinjaJump(Player.access$300()[0], Player.access$300()[1], Player.access$300()[2], Player.access$300()[3], Player.access$300()[4]),
        sg_PlayerNinjaFall(Player.access$400()[0], Player.access$400()[1], Player.access$400()[2], Player.access$400()[3], Player.access$400()[4]),
        sg_PlayerNinjaClimb(Player.access$500()[0], Player.access$500()[1], Player.access$500()[2], Player.access$500()[3], Player.access$500()[4]),
        sg_PlayerNinjaCrawl(Player.access$600()[0], Player.access$600()[1], Player.access$600()[2], Player.access$600()[3], Player.access$600()[4]),
        sg_PlayerNinjaSwim(Player.access$700()[0], Player.access$700()[1], Player.access$700()[2], Player.access$700()[3], Player.access$700()[4]),
        sg_PlayerHeadFly(Player.access$800()[0], Player.access$800()[1], Player.access$800()[2], Player.access$800()[3], Player.access$800()[4]),
        sg_PlayerHead(Player.access$900()[0], Player.access$900()[1], Player.access$900()[2], Player.access$900()[3], Player.access$900()[4]),
        sg_PlayerHeadHurl(Player.access$1000()[0], Player.access$1000()[1], Player.access$1000()[2], Player.access$1000()[3], Player.access$1000()[4]),
        sg_PlayerDeath(Player.access$1100()[0], Player.access$1100()[1], Player.access$1100()[2], Player.access$1100()[3], Player.access$1100()[4]),
        sg_PlayerNinjaSword(Player.access$1200()[0], Player.access$1200()[1], Player.access$1200()[2], Player.access$1200()[3], Player.access$1200()[4]),
        sg_PlayerNinjaPunch(Player.access$1300()[0], Player.access$1300()[1], Player.access$1300()[2], Player.access$1300()[3], Player.access$1300()[4]),
        sg_PlayerNinjaFly(Player.access$1400()[0], Player.access$1400()[1], Player.access$1400()[2], Player.access$1400()[3], Player.access$1400()[4]);

        private final State[][] group;
        private int index = -1;

        private PlayerStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }

    public static enum Player_Action_Func implements Func<PlayerStr>
    {
        DoPlayerCrawl(Player::DoPlayerCrawl),
        DoPlayerTeleportPause(Player::DoPlayerTeleportPause),
        DoPlayerJump(Player::DoPlayerJump),
        DoPlayerFall(Player::DoPlayerFall),
        DoPlayerForceJump(Player::DoPlayerForceJump),
        DoPlayerClimb(Player::DoPlayerClimb),
        DoPlayerFly(Player::DoPlayerFly),
        DoPlayerDive(Player::DoPlayerDive),
        DoPlayerWade(Player::DoPlayerWade),
        DoPlayerOperateTurret(Player::DoPlayerOperateTurret),
        DoPlayerOperateBoat(Player::DoPlayerOperateBoat),
        DoPlayerOperateTank(Player::DoPlayerOperateTank),
        DoPlayerRun(Player::DoPlayerRun),
        DoPlayerDeathFlip(Player::DoPlayerDeathFlip),
        DoPlayerDeathDrown(Player::DoPlayerDeathDrown),
        DoPlayerDeathCrumble(Player::DoPlayerDeathCrumble),
        DoPlayerDeathExplode(Player::DoPlayerDeathExplode),
        DoPlayerBeginRun(Player::DoPlayerBeginRun),
        InitWeaponSword(Sword::InitWeaponSword),
        InitWeaponFist(Fist::InitWeaponFist),
        InitWeaponStar(Star::InitWeaponStar),
        InitWeaponShotgun(Shotgun::InitWeaponShotgun),
        InitWeaponUzi(Uzi::InitWeaponUzi),
        InitWeaponMicro(Micro::InitWeaponMicro),
        InitWeaponGrenade(Grenade::InitWeaponGrenade),
        InitWeaponMine(Mine::InitWeaponMine),
        InitWeaponRail(Rail::InitWeaponRail),
        InitWeaponHothead(HotHead::InitWeaponHothead),
        InitWeaponHeart(Heart::InitWeaponHeart),
        UseInventoryMedkit(Inv::UseInventoryMedkit),
        UseInventoryCloak(Inv::UseInventoryCloak),
        UseInventoryNightVision(Inv::UseInventoryNightVision),
        UseInventoryChemBomb(Inv::UseInventoryChemBomb),
        UseInventoryFlashBomb(Inv::UseInventoryFlashBomb),
        UseInventoryCaltrops(Inv::UseInventoryCaltrops);

        private final Func<PlayerStr> func;

        private Player_Action_Func(Func<PlayerStr> func) {
            this.func = func;
        }

        @Override
        public void invoke(PlayerStr pp) {
            this.func.invoke(pp);
        }
    }
}

