/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.PlayerStr;

public class Quake {
    public static int QUAKE_Match(Sprite sp) {
        return Gameutils.SP_TAG2(sp);
    }

    public static int QUAKE_Zamt(Sprite sp) {
        return Gameutils.SP_TAG3(sp);
    }

    public static int QUAKE_Radius(Sprite sp) {
        return Gameutils.SP_TAG4(sp);
    }

    public static int QUAKE_Duration(Sprite sp) {
        return Gameutils.SP_TAG5(sp);
    }

    public static int QUAKE_WaitSecs(Sprite sp) {
        return Gameutils.SP_TAG6(sp);
    }

    public static int QUAKE_AngAmt(Sprite sp) {
        return Gameutils.SP_TAG7(sp);
    }

    public static int QUAKE_PosAmt(Sprite sp) {
        return Gameutils.SP_TAG8(sp);
    }

    public static int QUAKE_RandomTest(Sprite sp) {
        return Gameutils.SP_TAG9(sp);
    }

    public static int QUAKE_WaitTics(Sprite sp) {
        return Gameutils.SP_TAG13(sp);
    }

    public static boolean QUAKE_TestDontTaper(Sprite sp) {
        return Gameutils.TEST_BOOL1(sp);
    }

    public static boolean QUAKE_KillAfterQuake(Sprite sp) {
        return Gameutils.TEST_BOOL2(sp);
    }

    public static boolean QUAKE_WaitForTrigger(Sprite sp) {
        return Gameutils.TEST_BOOL3(sp);
    }

    public static void CopyQuakeSpotToOn(Sprite sp) {
        int newsp = Rooms.COVERinsertsprite(sp.getSectnum(), 91);
        WangSprite np = Main.boardService.getSprite(newsp);
        if (np == null) {
            return;
        }
        np.set(sp);
        np.setCstat(0);
        np.setExtra(0);
        np.setOwner(-1);
        Sprites.change_sprite_stat(newsp, 92);
        np.setXvel(np.getXvel() * 120);
    }

    public static void DoQuakeMatch(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(91);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (Quake.QUAKE_Match(sp) == match) {
                if (Quake.QUAKE_WaitTics(sp) > 0) {
                    Gameutils.RESET_BOOL3(sp);
                } else {
                    Quake.CopyQuakeSpotToOn(sp);
                    if (Quake.QUAKE_KillAfterQuake(sp)) {
                        Sprites.KillSprite(node.getIndex());
                    }
                }
            }
            node = nexti;
        }
    }

    public static void ProcessQuakeOn() {
        ListNode<Sprite> node = Main.boardService.getStatNode(92);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            sp.setXvel(sp.getXvel() - 12);
            if (Quake.QUAKE_Duration(sp) < 0) {
                Sprites.KillSprite(node.getIndex());
            }
            node = nexti;
        }
    }

    public static void ProcessQuakeSpot() {
        ListNode<Sprite> node = Main.boardService.getStatNode(91);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (Quake.QUAKE_WaitSecs(sp) != 0 && !Quake.QUAKE_WaitForTrigger(sp)) {
                Gameutils.SET_SP_TAG13(sp, Quake.QUAKE_WaitTics(sp) - 12);
                if (Quake.QUAKE_WaitTics(sp) < 0) {
                    Gameutils.SET_SP_TAG13(sp, (Quake.QUAKE_WaitSecs(sp) * 10 + Quake.QUAKE_Duration(sp)) * 120);
                    int rand_test = Quake.QUAKE_RandomTest(sp);
                    if (rand_test == 0 || Gameutils.RANDOM_RANGE(128) < rand_test) {
                        Quake.CopyQuakeSpotToOn(sp);
                        if (Quake.QUAKE_KillAfterQuake(sp)) {
                            int i = node.getIndex();
                            Sound.DeleteNoSoundOwner(i);
                            Sprites.KillSprite(i);
                        }
                    }
                }
            }
            node = nexti;
        }
    }

    public static void QuakeViewChange(PlayerStr pp, LONGp z_diff, LONGp x_diff, LONGp y_diff, LONGp ang_diff) {
        Sprite save_sp = null;
        int save_dist = 999999;
        z_diff.value = 0;
        x_diff.value = 0;
        y_diff.value = 0;
        ang_diff.value = 0;
        if (Main.game.gPaused) {
            return;
        }
        ListNode<Sprite> node = Main.boardService.getStatNode(92);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            int dist = Gameutils.FindDistance3D(pp.posx - sp.getX(), pp.posy - sp.getY(), pp.posz - sp.getZ() >> 4);
            if (Quake.QUAKE_TestDontTaper(sp)) {
                save_dist = dist;
                save_sp = sp;
                break;
            }
            if (dist < save_dist) {
                save_dist = dist;
                save_sp = sp;
            }
            node = nexti;
        }
        if (save_sp == null) {
            return;
        }
        int radius = Quake.QUAKE_Radius(save_sp) * 8;
        if (save_dist > radius) {
            return;
        }
        z_diff.value = Gameutils.Z(Gameutils.STD_RANDOM_RANGE(Quake.QUAKE_Zamt(save_sp)) - Quake.QUAKE_Zamt(save_sp) / 2);
        int ang_amt = Quake.QUAKE_AngAmt(save_sp) * 4;
        ang_diff.value = Gameutils.STD_RANDOM_RANGE(ang_amt) - ang_amt / 2;
        int pos_amt = Quake.QUAKE_PosAmt(save_sp) * 4;
        x_diff.value = Gameutils.STD_RANDOM_RANGE(pos_amt) - pos_amt / 2;
        y_diff.value = Gameutils.STD_RANDOM_RANGE(pos_amt) - pos_amt / 2;
        if (!Quake.QUAKE_TestDontTaper(save_sp)) {
            int dist_diff = radius - save_dist;
            int scale_value = Pragmas.divscale(dist_diff, radius, 16);
            z_diff.value = Pragmas.mulscale(z_diff.value, scale_value, 16);
            ang_diff.value = Pragmas.mulscale(ang_diff.value, scale_value, 16);
            x_diff.value = Pragmas.mulscale(x_diff.value, scale_value, 16);
            y_diff.value = Pragmas.mulscale(y_diff.value, scale_value, 16);
        }
    }

    public static void SpawnQuake(int sectnum, int x, int y, int z, int tics, int amt, int radius) {
        int SpriteNum = Rooms.COVERinsertsprite(sectnum, 92);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        sp.setX(x);
        sp.setY(y);
        sp.setZ(z);
        sp.setCstat(0);
        sp.setOwner(-1);
        sp.setExtra(0);
        sp.setLotag(-1);
        sp.setClipdist(amt);
        sp.setAng(radius / 8);
        sp.setXvel(tics);
        sp.setZvel(8);
        Sound.Set3DSoundOwner(SpriteNum, Sound.PlaySound(216, sp, 9));
    }

    public static void SetExpQuake(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        if (sp != null) {
            Quake.SpawnQuake(sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), 40, 4, 20000);
        }
    }

    public static void SetGunQuake(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp != null) {
            Quake.SpawnQuake(sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), 40, 8, 40000);
        }
    }

    public static void SetPlayerQuake(PlayerStr pp) {
        Quake.SpawnQuake(pp.cursectnum, pp.posx, pp.posy, pp.posz, 40, 8, 40000);
    }

    public static void SetNuclearQuake(int Weapon2) {
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        if (sp != null) {
            Quake.SpawnQuake(sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), 400, 8, 64000);
        }
    }

    public static void SetSumoQuake(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp != null) {
            Quake.SpawnQuake(sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), 120, 4, 20000);
        }
    }

    public static void SetSumoFartQuake(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp != null) {
            Quake.SpawnQuake(sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), 60, 4, 4000);
        }
    }
}

