/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.util.concurrent.atomic.AtomicInteger;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Hitscan;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Wang.Draw;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Save;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Warp;

public class Rooms {
    public static final int ZMAX = 400;
    private static final int[] sectorlist = new int[16];
    private static final LONGp upper = new LONGp();
    private static final LONGp lower = new LONGp();
    public static final Save save = new Save();
    public static final AtomicInteger fz = new AtomicInteger();
    public static final AtomicInteger cz = new AtomicInteger();
    public static final int[] GlobStackSect = new int[2];

    public static int COVERupdatesector(int x, int y, int newsector) {
        if (Main.boardService.isValidSector(newsector)) {
            return Main.engine.updatesector(x, y, newsector);
        }
        return -1;
    }

    public static int COVERinsertsprite(int sectnum, int stat) {
        int spnum = Main.engine.insertsprite(sectnum, stat);
        WangSprite sp = Main.boardService.getSprite(spnum);
        if (sp == null) {
            return -1;
        }
        sp.setX(0);
        sp.setY(0);
        sp.setZ(0);
        sp.setCstat(0);
        sp.setPicnum(0);
        sp.setShade(0);
        sp.setPal(0);
        sp.setClipdist(0);
        sp.setXrepeat(0);
        sp.setYrepeat(0);
        sp.setXoffset(0);
        sp.setYoffset(0);
        sp.setAng(0);
        sp.setOwner(-1);
        sp.setXvel(0);
        sp.setYvel(0);
        sp.setZvel(0);
        sp.setLotag(0);
        sp.setHitag(0);
        sp.setExtra(0);
        return spnum;
    }

    public static boolean FAF_Sector(int sectnum) {
        if (!Main.boardService.isValidSector(sectnum)) {
            return false;
        }
        for (ListNode<Sprite> node = Main.boardService.getSectNode(sectnum); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (sp.getStatnum() != 60 || sp.getHitag() < 110 || sp.getHitag() > 115) continue;
            return true;
        }
        return false;
    }

    private static void SetWallWarpHitscan(int sectnum) {
        Wall wal;
        short wall_num;
        Sprite sp_warp = Warp.WarpSectorInfo(sectnum);
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sectnum);
        if (sec == null || sp_warp == null) {
            return;
        }
        short start_wall = wall_num = sec.getWallptr();
        while ((wal = Main.boardService.getWall(wall_num)) != null) {
            if (wal.getNextwall() >= 0) {
                wal.setCstat(wal.getCstat() | Gameutils.CSTAT_WALL_WARP_HITSCAN);
            }
            if ((wall_num = wal.getPoint2()) != start_wall) continue;
        }
    }

    private static void ResetWallWarpHitscan(int sectnum) {
        Wall wal;
        short wall_num;
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sectnum);
        if (sec == null) {
            return;
        }
        short start_wall = wall_num = sec.getWallptr();
        while ((wal = Main.boardService.getWall(wall_num)) != null) {
            wal.setCstat(wal.getCstat() & ~Gameutils.CSTAT_WALL_WARP_HITSCAN);
            wall_num = wal.getPoint2();
            if (wall_num != start_wall) continue;
        }
    }

    public static void FAFhitscan(int x, int y, int z, int sectnum, int xvect, int yvect, int zvect, Hitscan hit, int clipmask) {
        int newsectnum = sectnum;
        int startclipmask = 0;
        boolean plax_found = false;
        if (clipmask == Gameutils.CLIPMASK_MISSILE) {
            startclipmask = Gameutils.CLIPMASK_WARP_HITSCAN;
        }
        Main.engine.hitscan(x, y, z, sectnum, xvect, yvect, zvect, hit, startclipmask);
        if (hit.hitsect == -1) {
            return;
        }
        Wall hitWall = Main.boardService.getWall(hit.hitwall);
        if (hitWall != null && MyTypes.TEST(hitWall.getCstat(), Gameutils.CSTAT_WALL_WARP_HITSCAN)) {
            hit.hitx -= xvect >> 9;
            hit.hity -= yvect >> 9;
            if (Warp.WarpM(hit.hitx, hit.hity, hit.hitz, hit.hitsect) != null) {
                hit.hitx = Warp.warp.x;
                hit.hity = Warp.warp.y;
                hit.hitz = Warp.warp.z;
                int dest_sect = hit.hitsect = Warp.warp.sectnum;
                Rooms.ResetWallWarpHitscan(dest_sect);
                Main.engine.hitscan(hit.hitx, hit.hity, hit.hitz, hit.hitsect, xvect, yvect, zvect, hit, startclipmask);
                Rooms.SetWallWarpHitscan(dest_sect);
                return;
            }
        }
        if (hit.hitwall == -1 && hit.hitsprite == -1) {
            ru.m210projects.Build.Types.Sector hitSec = Main.boardService.getSector(hit.hitsect);
            if (hitSec != null && MyTypes.TEST(hitSec.getExtra(), Gameutils.SECTFX_WARP_SECTOR)) {
                Wall wal = Main.boardService.getWall(hitSec.getWallptr());
                if (wal != null && MyTypes.TEST(wal.getCstat(), Gameutils.CSTAT_WALL_WARP_HITSCAN)) {
                    if (Warp.WarpM(hit.hitx, hit.hity, hit.hitz, hit.hitsect) != null) {
                        hit.hitx = Warp.warp.x;
                        hit.hity = Warp.warp.y;
                        hit.hitz = Warp.warp.z;
                        hit.hitsect = Warp.warp.sectnum;
                        Main.engine.hitscan(hit.hitx, hit.hity, hit.hitz, hit.hitsect, xvect, yvect, zvect, hit, clipmask);
                        return;
                    }
                } else if (Warp.WarpPlane(hit.hitx, hit.hity, hit.hitz, hit.hitsect) != null) {
                    hit.hitx = Warp.warp.x;
                    hit.hity = Warp.warp.y;
                    hit.hitz = Warp.warp.z;
                    hit.hitsect = Warp.warp.sectnum;
                    Main.engine.hitscan(hit.hitx, hit.hity, hit.hitz, hit.hitsect, xvect, yvect, zvect, hit, clipmask);
                    return;
                }
            }
            Main.engine.getzsofslope(hit.hitsect, hit.hitx, hit.hity, fz, cz);
            if (Pragmas.klabs(hit.hitz - fz.get()) < Gameutils.Z(4)) {
                if (Gameutils.FAF_ConnectFloor(hitSec) && !MyTypes.TEST(hitSec.getFloorstat(), Gameutils.FLOOR_STAT_FAF_BLOCK_HITSCAN)) {
                    newsectnum = Main.engine.updatesectorz(hit.hitx, hit.hity, hit.hitz + Gameutils.Z(12), newsectnum);
                    plax_found = true;
                }
            } else if (Pragmas.klabs(hit.hitz - cz.get()) < Gameutils.Z(4) && Gameutils.FAF_ConnectCeiling(hitSec) && !MyTypes.TEST(hitSec.getFloorstat(), Gameutils.CEILING_STAT_FAF_BLOCK_HITSCAN)) {
                newsectnum = Main.engine.updatesectorz(hit.hitx, hit.hity, hit.hitz - Gameutils.Z(12), newsectnum);
                plax_found = true;
            }
        }
        if (plax_found) {
            Main.engine.hitscan(hit.hitx, hit.hity, hit.hitz, newsectnum, xvect, yvect, zvect, hit, clipmask);
        }
    }

    public static boolean FAFcansee(int xs, int ys, int zs, int sects, int xe, int ye, int ze, int secte) {
        int newsectnum = sects;
        if (!Rooms.FAF_Sector(sects) && !Rooms.FAF_Sector(secte)) {
            return Main.engine.cansee(xs, ys, zs, sects, xe, ye, ze, secte);
        }
        int ang = EngineUtils.getAngle(xe - xs, ye - ys);
        int xvect = EngineUtils.sin(Gameutils.NORM_ANGLE(ang + 512));
        int yvect = EngineUtils.sin(Gameutils.NORM_ANGLE(ang));
        int zvect = 0;
        int dist = EngineUtils.sqrt(Gameutils.SQ(xe - xs) + Gameutils.SQ(ye - ys));
        if (dist != 0) {
            if (xe - xs != 0) {
                zvect = Pragmas.scale(xvect, ze - zs, xe - xs);
            } else if (ye - ys != 0) {
                zvect = Pragmas.scale(yvect, ze - zs, ye - ys);
            }
        }
        Main.engine.hitscan(xs, ys, zs, sects, xvect, yvect, zvect, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
        if (Engine.pHitInfo.hitsect == -1) {
            return false;
        }
        boolean plax_found = false;
        if (Engine.pHitInfo.hitwall == -1 && Engine.pHitInfo.hitsprite == -1) {
            Main.engine.getzsofslope(Engine.pHitInfo.hitsect, Engine.pHitInfo.hitx, Engine.pHitInfo.hity, fz, cz);
            if (Pragmas.klabs(Engine.pHitInfo.hitz - fz.get()) < Gameutils.Z(4)) {
                if (Gameutils.FAF_ConnectFloor(Main.boardService.getSector(Engine.pHitInfo.hitsect))) {
                    newsectnum = Main.engine.updatesectorz(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, Engine.pHitInfo.hitz + Gameutils.Z(12), newsectnum);
                    plax_found = true;
                }
            } else if (Pragmas.klabs(Engine.pHitInfo.hitz - cz.get()) < Gameutils.Z(4) && Gameutils.FAF_ConnectCeiling(Main.boardService.getSector(Engine.pHitInfo.hitsect))) {
                newsectnum = Main.engine.updatesectorz(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, Engine.pHitInfo.hitz - Gameutils.Z(12), newsectnum);
                plax_found = true;
            }
        } else {
            return Main.engine.cansee(xs, ys, zs, sects, xe, ye, ze, secte);
        }
        if (plax_found) {
            return Main.engine.cansee(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, Engine.pHitInfo.hitz, newsectnum, xe, ye, ze, secte);
        }
        return false;
    }

    public static int GetZadjustment(int sectnum, int hitag) {
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sectnum);
        if (sec == null) {
            return 0;
        }
        if (!MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_Z_ADJUST)) {
            return 0;
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(500); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (sp.getHitag() != hitag || sp.getSectnum() != sectnum) continue;
            return Gameutils.Z(sp.getLotag());
        }
        return 0;
    }

    private static boolean SectorZadjust(int ceilhit, LONGp hiz, int florhit, LONGp loz) {
        int z_amt;
        ru.m210projects.Build.Types.Sector hitSec;
        int hitsector;
        boolean SkipFAFcheck = false;
        if (florhit != -1) {
            switch (MyTypes.DTEST(florhit, -536870912)) {
                case -2147483648: 
                case -1073741824: {
                    break;
                }
                case 0x40000000: {
                    hitsector = Gameutils.NORM_HIT_INDEX(florhit);
                    hitSec = Main.boardService.getSector(hitsector);
                    if (hitSec == null) break;
                    if (Gameutils.FAF_ConnectFloor(Main.boardService.getSector(hitsector))) {
                        if (MyTypes.TEST(hitSec.getFloorstat(), Gameutils.CEILING_STAT_FAF_BLOCK_HITSCAN) || !MyTypes.TEST(hitSec.getExtra(), Gameutils.SECTFX_Z_ADJUST) || (z_amt = Rooms.GetZadjustment(hitsector, 98)) == 0) break;
                        loz.value += z_amt;
                        SkipFAFcheck = true;
                        break;
                    }
                    if (!MyTypes.TEST(hitSec.getExtra(), Gameutils.SECTFX_Z_ADJUST)) break;
                    z_amt = Rooms.GetZadjustment(hitsector, 98);
                    if (z_amt != 0) {
                        loz.value += z_amt;
                        break;
                    }
                    if (!MyTypes.TEST(hitSec.getFloorstat(), Gameutils.FLOOR_STAT_PLAX)) break;
                    loz.value += Game.PlaxFloorGlobZadjust;
                    break;
                }
            }
        }
        if (ceilhit != -1 && MyTypes.DTEST(ceilhit, -536870912) == 0x40000000) {
            hitsector = Gameutils.NORM_HIT_INDEX(ceilhit);
            hitSec = Main.boardService.getSector(hitsector);
            if (hitSec == null) {
                return SkipFAFcheck;
            }
            if (Gameutils.FAF_ConnectCeiling(hitSec)) {
                if (MyTypes.TEST(hitSec.getExtra(), Gameutils.SECTFX_Z_ADJUST) && (z_amt = Rooms.GetZadjustment(hitsector, 97)) != 0) {
                    if (loz != null) {
                        loz.value += z_amt;
                    }
                    SkipFAFcheck = true;
                }
                return SkipFAFcheck;
            }
            if (!MyTypes.TEST(hitSec.getExtra(), Gameutils.SECTFX_Z_ADJUST)) {
                return SkipFAFcheck;
            }
            z_amt = Rooms.GetZadjustment(hitsector, 97);
            if (z_amt != 0) {
                hiz.value -= z_amt;
            } else if (MyTypes.TEST(hitSec.getCeilingstat(), Gameutils.CEILING_STAT_PLAX)) {
                hiz.value -= Game.PlaxCeilGlobZadjust;
            }
        }
        return SkipFAFcheck;
    }

    private static void WaterAdjust(int florhit, LONGp loz) {
        switch (MyTypes.DTEST(florhit, -536870912)) {
            case 0x40000000: {
                Sect_User sectu = Sector.getSectUser(Gameutils.NORM_HIT_INDEX(florhit));
                if (sectu == null || sectu.depth == 0) break;
                loz.value += Gameutils.Z(sectu.depth);
                break;
            }
        }
    }

    public static void FAFgetzrange(int x, int y, int z, int sectnum, LONGp hiz, LONGp ceilhit, LONGp loz, LONGp florhit, int clipdist, int clipmask) {
        if (!Gameutils.FAF_ConnectArea(sectnum)) {
            Main.engine.getzrange(x, y, z, sectnum, hiz, ceilhit, loz, florhit, clipdist, clipmask);
            Rooms.SectorZadjust(ceilhit.value, hiz, florhit.value, loz);
            Rooms.WaterAdjust(florhit.value, loz);
            return;
        }
        Main.engine.getzrange(x, y, z, sectnum, hiz, ceilhit, loz, florhit, clipdist, clipmask);
        boolean SkipFAFcheck = Rooms.SectorZadjust(ceilhit.value, hiz, florhit.value, loz);
        Rooms.WaterAdjust(florhit.value, loz);
        if (SkipFAFcheck) {
            return;
        }
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sectnum);
        if (sec == null) {
            return;
        }
        if (Gameutils.FAF_ConnectCeiling(sec)) {
            int uppersect = sectnum;
            int newz = hiz.value - Gameutils.Z(2);
            if (MyTypes.DTEST(ceilhit.value, -536870912) == -1073741824) {
                return;
            }
            if ((uppersect = Main.engine.updatesectorz(x, y, newz, uppersect)) == -1) {
                Console.out.println("Did not find a sector at " + x + " ," + y + " ," + newz);
            }
            Main.engine.getzrange(x, y, newz, uppersect, hiz, ceilhit, null, null, clipdist, clipmask);
            Rooms.SectorZadjust(ceilhit.value, hiz, -1, null);
        } else if (Gameutils.FAF_ConnectFloor(sec) && !MyTypes.TEST(sec.getFloorstat(), Gameutils.FLOOR_STAT_FAF_BLOCK_HITSCAN)) {
            int lowersect = sectnum;
            int newz = loz.value + Gameutils.Z(2);
            if (MyTypes.DTEST(florhit.value, -536870912) == -1073741824) {
                return;
            }
            if ((lowersect = Main.engine.updatesectorz(x, y, newz, lowersect)) == -1) {
                Console.out.println("Did not find a sector at " + x + " ," + y + " ," + newz);
            }
            Main.engine.getzrange(x, y, newz, lowersect, null, null, loz, florhit, clipdist, clipmask);
            Rooms.SectorZadjust(-1, null, florhit.value, loz);
            Rooms.WaterAdjust(florhit.value, loz);
        }
    }

    public static void FAFgetzrangepoint(int x, int y, int z, int sectnum, LONGp hiz, LONGp ceilhit, LONGp loz, LONGp florhit) {
        if (!Gameutils.FAF_ConnectArea(sectnum)) {
            Main.engine.getzrangepoint(x, y, z, sectnum, hiz, ceilhit, loz, florhit);
            Rooms.SectorZadjust(ceilhit.value, hiz, florhit.value, loz);
            Rooms.WaterAdjust(florhit.value, loz);
            return;
        }
        Main.engine.getzrangepoint(x, y, z, sectnum, hiz, ceilhit, loz, florhit);
        boolean SkipFAFcheck = Rooms.SectorZadjust(ceilhit.value, hiz, florhit.value, loz);
        Rooms.WaterAdjust(florhit.value, loz);
        if (SkipFAFcheck) {
            return;
        }
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sectnum);
        if (sec == null) {
            return;
        }
        if (Gameutils.FAF_ConnectCeiling(sec)) {
            int uppersect = sectnum;
            int newz = hiz.value - Gameutils.Z(2);
            if (MyTypes.DTEST(ceilhit.value, -536870912) == -1073741824) {
                return;
            }
            if ((uppersect = Main.engine.updatesectorz(x, y, newz, uppersect)) == -1) {
                Console.out.println("Did not find a sector at " + x + ", " + y + ", " + newz + ", sectnum " + sectnum);
            }
            Main.engine.getzrangepoint(x, y, newz, uppersect, hiz, ceilhit, null, null);
            Rooms.SectorZadjust(ceilhit.value, hiz, -1, null);
        } else if (Gameutils.FAF_ConnectFloor(sec) && !MyTypes.TEST(sec.getFloorstat(), Gameutils.FLOOR_STAT_FAF_BLOCK_HITSCAN)) {
            int lowersect = sectnum;
            int newz = loz.value + Gameutils.Z(2);
            if (MyTypes.DTEST(florhit.value, -536870912) == -1073741824) {
                return;
            }
            if ((lowersect = Main.engine.updatesectorz(x, y, newz, lowersect)) == -1) {
                Console.out.println("Did not find a sector at " + x + ", " + y + ", " + newz + ", sectnum " + sectnum);
            }
            Main.engine.getzrangepoint(x, y, newz, lowersect, null, null, loz, florhit);
            Rooms.SectorZadjust(-1, null, florhit.value, loz);
            Rooms.WaterAdjust(florhit.value, loz);
        }
    }

    public static boolean PicInView(short tile_num, boolean reset) {
        Renderer renderer = Main.game.getRenderer();
        byte[] gotpic = renderer.getRenderedPics();
        if (MyTypes.TEST(gotpic[tile_num >> 3], 1 << (tile_num & 7))) {
            if (reset) {
                int n = tile_num >> 3;
                gotpic[n] = (byte)(gotpic[n] & (byte)(~(1 << (tile_num & 7))));
            }
            return true;
        }
        return false;
    }

    public static void SetupMirrorTiles() {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(60); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            ru.m210projects.Build.Types.Sector sector = Main.boardService.getSector(sp.getSectnum());
            if (sector == null) continue;
            if (sector.getCeilingpicnum() == 341) {
                sector.setCeilingpicnum(2356);
                sector.setCeilingstat(sector.getCeilingstat() | Gameutils.CEILING_STAT_PLAX);
            }
            if (sector.getFloorpicnum() == 341) {
                sector.setFloorpicnum(2356);
                sector.setFloorstat(sector.getFloorstat() | Gameutils.FLOOR_STAT_PLAX);
            }
            if (sector.getCeilingpicnum() == 342) {
                sector.setCeilingpicnum(2357);
            }
            if (sector.getFloorpicnum() != 342) continue;
            sector.setFloorpicnum(2357);
        }
    }

    private static void GetUpperLowerSector(int match, int x, int y, LONGp upper, LONGp lower) {
        int sln = 0;
        for (int j : GlobStackSect) {
            if (Main.engine.inside(x, y, j) != 1) continue;
            boolean found = false;
            for (ListNode<Sprite> node = Main.boardService.getSectNode(j); node != null; node = node.getNext()) {
                Sprite sp = node.get();
                if (sp.getStatnum() != 60 || sp.getHitag() < 110 || sp.getHitag() > 115 || sp.getLotag() != match) continue;
                found = true;
            }
            if (!found) continue;
            Rooms.sectorlist[sln] = j;
            sln = (short)(sln + 1);
        }
        if (sln < 2) {
            sln = 0;
            for (int i = Main.boardService.getSectorCount() - 1; i >= 0; --i) {
                ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(i);
                if (sec == null || !sec.inside(x, y)) continue;
                boolean found = false;
                for (ListNode<Sprite> node = Main.boardService.getSectNode(i); node != null; node = node.getNext()) {
                    Sprite sp = node.get();
                    if (sp.getStatnum() != 60 || sp.getHitag() < 110 || sp.getHitag() > 115 || sp.getLotag() != match) continue;
                    found = true;
                }
                if (!found) continue;
                Rooms.sectorlist[sln] = i;
                if (sln < GlobStackSect.length) {
                    Rooms.GlobStackSect[sln] = i;
                }
                sln = (short)(sln + 1);
            }
        }
        if (sln == 0) {
            upper.value = -1;
            lower.value = -1;
            return;
        }
        if (sln > 2) {
            Rooms.GetUpperLowerSector(match, x - 1, y, upper, lower);
        }
        if (sln == 2) {
            ru.m210projects.Build.Types.Sector sec0 = Main.boardService.getSector(sectorlist[0]);
            ru.m210projects.Build.Types.Sector sec1 = Main.boardService.getSector(sectorlist[1]);
            if (sec0 != null && sec1 != null && sec0.getFloorz() < sec1.getFloorz()) {
                int hold = sectorlist[0];
                Rooms.sectorlist[0] = sectorlist[1];
                Rooms.sectorlist[1] = hold;
            }
            lower.value = sectorlist[0];
            upper.value = sectorlist[1];
        }
    }

    private static void FindCeilingView(int match, LONGp x, LONGp y, int z, LONGp sectnum) {
        ListNode<Sprite> node;
        int xoff = 0;
        int yoff = 0;
        Sprite sp = null;
        Rooms.save.zcount = 0;
        for (node = Main.boardService.getStatNode(60); node != null; node = node.getNext()) {
            sp = node.get();
            if (sp.getHitag() != 120 || sp.getLotag() != match) continue;
            xoff = x.value - sp.getX();
            yoff = y.value - sp.getY();
            break;
        }
        for (node = Main.boardService.getStatNode(60); node != null; node = node.getNext()) {
            sp = node.get();
            if (sp.getLotag() != match || sp.getHitag() != 121) continue;
            x.value = sp.getX() + xoff;
            y.value = sp.getY() + yoff;
            Rooms.GetUpperLowerSector(match, x.value, y.value, sectnum, lower);
            break;
        }
        if (sectnum.value == -1) {
            return;
        }
        if (sp == null || sp.getHitag() != 121) {
            return;
        }
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sp.getSectnum());
        if (sec == null) {
            return;
        }
        int pix_diff = Pragmas.klabs(z - sec.getFloorz()) >> 8;
        int newz = sec.getFloorz() + (pix_diff / 128 + 1) * Gameutils.Z(128);
        for (ListNode<Sprite> node2 = Main.boardService.getStatNode(60); node2 != null; node2 = node2.getNext()) {
            Sprite sp2 = node2.get();
            ru.m210projects.Build.Types.Sector sec2 = Main.boardService.getSector(sp2.getSectnum());
            if (sec2 == null || sp2.getLotag() != match || sp2.getHitag() != 111) continue;
            Rooms.save.sectnum[Rooms.save.zcount] = sp2.getSectnum();
            Rooms.save.zval[Rooms.save.zcount] = sec2.getFloorz();
            Rooms.save.pic[Rooms.save.zcount] = sec2.getFloorpicnum();
            Rooms.save.slope[Rooms.save.zcount] = sec2.getFloorheinum();
            sec2.setFloorz(newz);
            if (sec2.getFloorpicnum() != 2356) {
                sec2.setFloorpicnum(2357);
            }
            sec2.setFloorheinum(0);
            Rooms.save.zcount = (short)(Rooms.save.zcount + 1);
        }
    }

    private static void FindFloorView(int match, LONGp x, LONGp y, int z, LONGp sectnum) {
        ListNode<Sprite> node;
        int xoff = 0;
        int yoff = 0;
        Sprite sp = null;
        Rooms.save.zcount = 0;
        for (node = Main.boardService.getStatNode(60); node != null; node = node.getNext()) {
            sp = node.get();
            if (sp.getHitag() != 121 || sp.getLotag() != match) continue;
            xoff = x.value - sp.getX();
            yoff = y.value - sp.getY();
            break;
        }
        for (node = Main.boardService.getStatNode(60); node != null; node = node.getNext()) {
            sp = node.get();
            if (sp.getLotag() != match || sp.getHitag() != 120) continue;
            x.value = sp.getX() + xoff;
            y.value = sp.getY() + yoff;
            Rooms.GetUpperLowerSector(match, x.value, y.value, upper, sectnum);
            break;
        }
        if (sectnum.value < 0) {
            return;
        }
        if (sp == null || sp.getHitag() != 120) {
            return;
        }
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sp.getSectnum());
        if (sec == null) {
            return;
        }
        int pix_diff = Pragmas.klabs(z - sec.getCeilingz()) >> 8;
        int newz = sec.getCeilingz() - (pix_diff / 128 + 1) * Gameutils.Z(128);
        for (ListNode<Sprite> node2 = Main.boardService.getStatNode(60); node2 != null; node2 = node2.getNext()) {
            Sprite sp2 = node2.get();
            ru.m210projects.Build.Types.Sector sec2 = Main.boardService.getSector(sp2.getSectnum());
            if (sec2 == null || sp2.getLotag() != match || sp2.getHitag() != 110) continue;
            Rooms.save.sectnum[Rooms.save.zcount] = sp2.getSectnum();
            Rooms.save.zval[Rooms.save.zcount] = sec2.getCeilingz();
            Rooms.save.pic[Rooms.save.zcount] = sec2.getCeilingpicnum();
            Rooms.save.slope[Rooms.save.zcount] = sec2.getCeilingheinum();
            sec2.setCeilingz(newz);
            if (sec2.getCeilingpicnum() != 2356) {
                sec2.setCeilingpicnum(2357);
            }
            sec2.setCeilingheinum(0);
            Rooms.save.zcount = (short)(Rooms.save.zcount + 1);
        }
    }

    private static short ViewSectorInScene(int cursectnum, int level) {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(60); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (sp.getHitag() != level || cursectnum != sp.getSectnum() || sp.getAng() == 1536) continue;
            short match = sp.getLotag();
            if (!Rooms.PicInView((short)2356, true)) {
                return -1;
            }
            return match;
        }
        return -1;
    }

    public static void DrawOverlapRoom(int tx, int ty, int tz, float tang, float thoriz, int tsectnum, int smoothratio) {
        Rooms.save.zcount = 0;
        Renderer renderer = Main.game.getRenderer();
        short match = Rooms.ViewSectorInScene(tsectnum, 110);
        if (match != -1) {
            Rooms.FindCeilingView(match, Game.tmp_ptr[0].set(tx), Game.tmp_ptr[1].set(ty), tz, Game.tmp_ptr[2].set(tsectnum));
            tx = Game.tmp_ptr[0].value;
            ty = Game.tmp_ptr[1].value;
            tsectnum = Game.tmp_ptr[2].value;
            if (tsectnum == -1) {
                return;
            }
            renderer.drawrooms(tx, ty, tz, tang, thoriz, tsectnum);
            for (int i = 0; i < Rooms.save.zcount; ++i) {
                ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(Rooms.save.sectnum[i]);
                if (sec == null) continue;
                sec.setFloorz(Rooms.save.zval[i]);
                sec.setFloorpicnum(Rooms.save.pic[i]);
                sec.setFloorheinum(Rooms.save.slope[i]);
            }
            Draw.analyzesprites(tx, ty, tz, false, smoothratio);
            Draw.post_analyzesprites(smoothratio);
            renderer.drawmasks();
        } else {
            match = Rooms.ViewSectorInScene(tsectnum, 111);
            if (match != -1) {
                Rooms.FindFloorView(match, Game.tmp_ptr[0].set(tx), Game.tmp_ptr[1].set(ty), tz, Game.tmp_ptr[2].set(tsectnum));
                tx = Game.tmp_ptr[0].value;
                ty = Game.tmp_ptr[1].value;
                tsectnum = Game.tmp_ptr[2].value;
                if (tsectnum == -1) {
                    return;
                }
                renderer.drawrooms(tx, ty, tz, tang, thoriz, tsectnum);
                for (int i = 0; i < Rooms.save.zcount; ++i) {
                    ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(Rooms.save.sectnum[i]);
                    if (sec == null) continue;
                    sec.setCeilingz(Rooms.save.zval[i]);
                    sec.setCeilingpicnum(Rooms.save.pic[i]);
                    sec.setCeilingheinum(Rooms.save.slope[i]);
                }
                Draw.analyzesprites(tx, ty, tz, false, smoothratio);
                Draw.post_analyzesprites(smoothratio);
                renderer.drawmasks();
            }
        }
    }
}

